/* draw.c generated by valac 0.56.17, the Vala compiler
 * generated from draw.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cairo-gobject.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
VALA_EXTERN gdouble utils_get_default_monitor_scale (void);
VALA_EXTERN PangoLayout* draw_create_layout_from_context_for_text (cairo_t* cr,
                                                       const gchar* text,
                                                       gint font_size,
                                                       gint layout_width,
                                                       PangoAlignment horizontal_alignment,
                                                       const gchar* vertical_align,
                                                       gint* wrap_width);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
VALA_EXTERN void draw_draw_layout (cairo_t* cr,
                       PangoLayout* layout,
                       gint x,
                       gint y);
VALA_EXTERN PangoLayout* draw_create_layout_from_widget_for_text (GtkWidget* widget,
                                                      const gchar* text,
                                                      gint font_size,
                                                      gint layout_width,
                                                      PangoAlignment horizontal_alignment,
                                                      const gchar* vertical_align,
                                                      gint* wrap_width);
VALA_EXTERN void draw_get_text_bounding_rect_from_widget (GtkWidget* widget,
                                              const gchar* text,
                                              gint font_size,
                                              gint layout_width,
                                              gint* bounding_width,
                                              gint* bounding_height,
                                              PangoAlignment horizontal_alignment,
                                              const gchar* vertical_align,
                                              gint* wrap_width);
VALA_EXTERN void draw_get_text_bounding_rect_from_context (cairo_t* cr,
                                               const gchar* text,
                                               gint font_size,
                                               gint layout_width,
                                               gint* bounding_width,
                                               gint* bounding_height,
                                               PangoAlignment horizontal_alignment,
                                               const gchar* vertical_align,
                                               gint* wrap_width);
VALA_EXTERN gint draw_get_text_render_height (GtkWidget* widget,
                                  const gchar* text,
                                  gint width,
                                  gint height,
                                  gint size,
                                  PangoAlignment horizontal_alignment,
                                  const gchar* vertical_align,
                                  gint* wrap_width);
VALA_EXTERN gint draw_get_text_render_width (cairo_t* cr,
                                 const gchar* text,
                                 gint width,
                                 gint height,
                                 gint size,
                                 PangoAlignment horizontal_alignment,
                                 const gchar* vertical_align,
                                 gint* wrap_width);
VALA_EXTERN void draw_set_context_source_color (cairo_t* cr,
                                    GdkRGBA* rgba);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void draw_fill_rounded_rectangle (cairo_t* cr,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gdouble r);
VALA_EXTERN void draw_stroke_rounded_rectangle (cairo_t* cr,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height,
                                    gdouble r,
                                    GdkRGBA* frame_color,
                                    GdkRGBA* background_color,
                                    gint line_width);
VALA_EXTERN void draw_draw_search_rectangle (cairo_t* cr,
                                 gint x,
                                 gint y,
                                 gint width,
                                 gint height,
                                 gdouble r,
                                 gboolean fill);
VALA_EXTERN void draw_draw_radial (cairo_t* cr,
                       gint x,
                       gint width,
                       gint height,
                       GdkRGBA* center_color,
                       GdkRGBA* edge_color);
VALA_EXTERN void draw_clip_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h);
VALA_EXTERN void draw_clip_rounded_rectangle (cairo_t* cr,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gdouble r);

void
draw_draw_surface (cairo_t* cr,
                   cairo_surface_t* surface,
                   gint x,
                   gint y,
                   gint width,
                   gint height)
{
	g_return_if_fail (cr != NULL);
	g_return_if_fail (surface != NULL);
	if (surface != NULL) {
		cairo_set_source_surface (cr, surface, (gdouble) (x + MAX (0, ((gint) (width - (cairo_image_surface_get_width (surface) / utils_get_default_monitor_scale ()))) / 2)), (gdouble) (y + MAX (0, ((gint) (height - (cairo_image_surface_get_height (surface) / utils_get_default_monitor_scale ()))) / 2)));
		cairo_paint_with_alpha (cr, 1.0);
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

PangoLayout*
draw_create_layout_from_context_for_text (cairo_t* cr,
                                          const gchar* text,
                                          gint font_size,
                                          gint layout_width,
                                          PangoAlignment horizontal_alignment,
                                          const gchar* vertical_align,
                                          gint* wrap_width)
{
	PangoFontDescription* font_description = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	PangoLayout* _tmp8_;
	PangoLayout* result;
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (vertical_align != NULL, NULL);
	_tmp0_ = pango_font_description_new ();
	font_description = _tmp0_;
	_tmp1_ = font_description;
	pango_font_description_set_size (_tmp1_, (gint) (font_size * PANGO_SCALE));
	_tmp2_ = pango_cairo_create_layout (cr);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = font_description;
	pango_layout_set_font_description (_tmp3_, _tmp4_);
	_tmp5_ = layout;
	_tmp6_ = strlen (text);
	_tmp7_ = _tmp6_;
	pango_layout_set_markup (_tmp5_, text, _tmp7_);
	_tmp8_ = layout;
	pango_layout_set_alignment (_tmp8_, horizontal_alignment);
	if (wrap_width == NULL) {
		PangoLayout* _tmp9_;
		PangoLayout* _tmp10_;
		PangoLayout* _tmp11_;
		_tmp9_ = layout;
		pango_layout_set_single_paragraph_mode (_tmp9_, TRUE);
		_tmp10_ = layout;
		pango_layout_set_width (_tmp10_, layout_width * PANGO_SCALE);
		_tmp11_ = layout;
		pango_layout_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_END);
	} else {
		PangoLayout* _tmp12_;
		PangoLayout* _tmp13_;
		_tmp12_ = layout;
		pango_layout_set_width (_tmp12_, (*wrap_width) * PANGO_SCALE);
		_tmp13_ = layout;
		pango_layout_set_wrap (_tmp13_, PANGO_WRAP_WORD);
	}
	result = layout;
	__vala_PangoFontDescription_free0 (font_description);
	return result;
}

void
draw_draw_text (cairo_t* cr,
                const gchar* text,
                gint x,
                gint y,
                gint width,
                gint height,
                gint size,
                PangoAlignment horizontal_alignment,
                const gchar* vertical_align,
                gint* wrap_width)
{
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	gint text_width = 0;
	gint text_height = 0;
	PangoLayout* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint render_y = 0;
	PangoLayout* _tmp4_;
	PangoLayout* _tmp5_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (vertical_align != NULL);
	cairo_save (cr);
	_tmp0_ = draw_create_layout_from_context_for_text (cr, text, size, width, horizontal_alignment, vertical_align, wrap_width);
	layout = _tmp0_;
	_tmp1_ = layout;
	pango_layout_get_pixel_size (_tmp1_, &_tmp2_, &_tmp3_);
	text_width = _tmp2_;
	text_height = _tmp3_;
	if (g_strcmp0 (vertical_align, "top") == 0) {
		render_y = y;
	} else {
		if (g_strcmp0 (vertical_align, "middle") == 0) {
			render_y = y + MAX (0, (height - text_height) / 2);
		} else {
			render_y = y + MAX (0, height - text_height);
		}
	}
	cairo_move_to (cr, (gdouble) x, (gdouble) render_y);
	_tmp4_ = layout;
	pango_cairo_update_layout (cr, _tmp4_);
	_tmp5_ = layout;
	pango_cairo_show_layout (cr, _tmp5_);
	cairo_restore (cr);
	_g_object_unref0 (layout);
}

void
draw_draw_layout (cairo_t* cr,
                  PangoLayout* layout,
                  gint x,
                  gint y)
{
	g_return_if_fail (cr != NULL);
	g_return_if_fail (layout != NULL);
	cairo_move_to (cr, (gdouble) x, (gdouble) y);
	pango_cairo_update_layout (cr, layout);
	pango_cairo_show_layout (cr, layout);
}

PangoLayout*
draw_create_layout_from_widget_for_text (GtkWidget* widget,
                                         const gchar* text,
                                         gint font_size,
                                         gint layout_width,
                                         PangoAlignment horizontal_alignment,
                                         const gchar* vertical_align,
                                         gint* wrap_width)
{
	PangoFontDescription* font_description = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	PangoLayout* _tmp8_;
	PangoLayout* result;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (vertical_align != NULL, NULL);
	_tmp0_ = pango_font_description_new ();
	font_description = _tmp0_;
	_tmp1_ = font_description;
	pango_font_description_set_size (_tmp1_, (gint) (font_size * PANGO_SCALE));
	_tmp2_ = gtk_widget_create_pango_layout (widget, NULL);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = font_description;
	pango_layout_set_font_description (_tmp3_, _tmp4_);
	_tmp5_ = layout;
	_tmp6_ = strlen (text);
	_tmp7_ = _tmp6_;
	pango_layout_set_text (_tmp5_, text, _tmp7_);
	_tmp8_ = layout;
	pango_layout_set_alignment (_tmp8_, horizontal_alignment);
	if (wrap_width == NULL) {
		PangoLayout* _tmp9_;
		PangoLayout* _tmp10_;
		PangoLayout* _tmp11_;
		_tmp9_ = layout;
		pango_layout_set_single_paragraph_mode (_tmp9_, TRUE);
		_tmp10_ = layout;
		pango_layout_set_width (_tmp10_, layout_width * PANGO_SCALE);
		_tmp11_ = layout;
		pango_layout_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_END);
	} else {
		PangoLayout* _tmp12_;
		PangoLayout* _tmp13_;
		_tmp12_ = layout;
		pango_layout_set_width (_tmp12_, (*wrap_width) * PANGO_SCALE);
		_tmp13_ = layout;
		pango_layout_set_wrap (_tmp13_, PANGO_WRAP_WORD);
	}
	result = layout;
	__vala_PangoFontDescription_free0 (font_description);
	return result;
}

void
draw_get_text_bounding_rect_from_widget (GtkWidget* widget,
                                         const gchar* text,
                                         gint font_size,
                                         gint layout_width,
                                         gint* bounding_width,
                                         gint* bounding_height,
                                         PangoAlignment horizontal_alignment,
                                         const gchar* vertical_align,
                                         gint* wrap_width)
{
	gint _vala_bounding_width = 0;
	gint _vala_bounding_height = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (vertical_align != NULL);
	_tmp0_ = draw_create_layout_from_widget_for_text (widget, text, font_size, layout_width, horizontal_alignment, vertical_align, wrap_width);
	layout = _tmp0_;
	pango_layout_get_pixel_size (layout, &_tmp1_, &_tmp2_);
	_vala_bounding_width = _tmp1_;
	_vala_bounding_height = _tmp2_;
	_g_object_unref0 (layout);
	if (bounding_width) {
		*bounding_width = _vala_bounding_width;
	}
	if (bounding_height) {
		*bounding_height = _vala_bounding_height;
	}
}

void
draw_get_text_bounding_rect_from_context (cairo_t* cr,
                                          const gchar* text,
                                          gint font_size,
                                          gint layout_width,
                                          gint* bounding_width,
                                          gint* bounding_height,
                                          PangoAlignment horizontal_alignment,
                                          const gchar* vertical_align,
                                          gint* wrap_width)
{
	gint _vala_bounding_width = 0;
	gint _vala_bounding_height = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (vertical_align != NULL);
	_tmp0_ = draw_create_layout_from_context_for_text (cr, text, font_size, layout_width, horizontal_alignment, vertical_align, wrap_width);
	layout = _tmp0_;
	pango_layout_get_pixel_size (layout, &_tmp1_, &_tmp2_);
	_vala_bounding_width = _tmp1_;
	_vala_bounding_height = _tmp2_;
	_g_object_unref0 (layout);
	if (bounding_width) {
		*bounding_width = _vala_bounding_width;
	}
	if (bounding_height) {
		*bounding_height = _vala_bounding_height;
	}
}

gint
draw_get_text_render_height (GtkWidget* widget,
                             const gchar* text,
                             gint width,
                             gint height,
                             gint size,
                             PangoAlignment horizontal_alignment,
                             const gchar* vertical_align,
                             gint* wrap_width)
{
	gint text_width = 0;
	gint text_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (widget != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	g_return_val_if_fail (vertical_align != NULL, 0);
	draw_get_text_bounding_rect_from_widget (widget, text, size, width, &_tmp0_, &_tmp1_, horizontal_alignment, vertical_align, wrap_width);
	text_width = _tmp0_;
	text_height = _tmp1_;
	result = text_height;
	return result;
}

gint
draw_get_text_render_width (cairo_t* cr,
                            const gchar* text,
                            gint width,
                            gint height,
                            gint size,
                            PangoAlignment horizontal_alignment,
                            const gchar* vertical_align,
                            gint* wrap_width)
{
	gint text_width = 0;
	gint text_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (cr != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	g_return_val_if_fail (vertical_align != NULL, 0);
	draw_get_text_bounding_rect_from_context (cr, text, size, width, &_tmp0_, &_tmp1_, horizontal_alignment, vertical_align, wrap_width);
	text_width = _tmp0_;
	text_height = _tmp1_;
	result = text_width;
	return result;
}

void
draw_set_context_source_color (cairo_t* cr,
                               GdkRGBA* rgba)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (rgba != NULL);
	_tmp0_ = *rgba;
	_tmp1_ = *rgba;
	_tmp2_ = *rgba;
	_tmp3_ = *rgba;
	cairo_set_source_rgba (cr, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
}

void
draw_draw_rectangle (cairo_t* cr,
                     gint x,
                     gint y,
                     gint w,
                     gint h,
                     gboolean fill)
{
	g_return_if_fail (cr != NULL);
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	if (fill) {
		cairo_fill (cr);
	} else {
		cairo_stroke (cr);
	}
}

void
draw_fill_rounded_rectangle (cairo_t* cr,
                             gint x,
                             gint y,
                             gint width,
                             gint height,
                             gdouble r)
{
	g_return_if_fail (cr != NULL);
	cairo_new_sub_path (cr);
	cairo_arc (cr, (x + width) - r, y + r, r, (G_PI * 3) / 2, G_PI * 2);
	cairo_arc (cr, (x + width) - r, (y + height) - r, r, (gdouble) 0, G_PI / 2);
	cairo_arc (cr, x + r, (y + height) - r, r, G_PI / 2, G_PI);
	cairo_arc (cr, x + r, y + r, r, G_PI, (G_PI * 3) / 2);
	cairo_close_path (cr);
	cairo_fill (cr);
}

void
draw_stroke_rounded_rectangle (cairo_t* cr,
                               gint x,
                               gint y,
                               gint width,
                               gint height,
                               gdouble r,
                               GdkRGBA* frame_color,
                               GdkRGBA* background_color,
                               gint line_width)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (frame_color != NULL);
	g_return_if_fail (background_color != NULL);
	_tmp0_ = *frame_color;
	_tmp1_ = *frame_color;
	_tmp2_ = *frame_color;
	_tmp3_ = *frame_color;
	cairo_set_source_rgba (cr, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
	draw_fill_rounded_rectangle (cr, x, y, width, height, r);
	_tmp4_ = *background_color;
	_tmp5_ = *background_color;
	_tmp6_ = *background_color;
	_tmp7_ = *background_color;
	cairo_set_source_rgba (cr, _tmp4_.red, _tmp5_.green, _tmp6_.blue, _tmp7_.alpha);
	draw_fill_rounded_rectangle (cr, x + line_width, y + line_width, width - (line_width * 2), height - (line_width * 2), r);
}

void
draw_draw_search_rectangle (cairo_t* cr,
                            gint x,
                            gint y,
                            gint width,
                            gint height,
                            gdouble r,
                            gboolean fill)
{
	g_return_if_fail (cr != NULL);
	cairo_move_to (cr, (gdouble) x, (gdouble) y);
	cairo_line_to (cr, (gdouble) (x + width), (gdouble) y);
	cairo_line_to (cr, (gdouble) (x + width), (gdouble) (y + height));
	cairo_line_to (cr, x + r, (gdouble) (y + height));
	cairo_arc (cr, x + r, (y + height) - r, r, G_PI / 2, G_PI);
	cairo_line_to (cr, (gdouble) x, (gdouble) y);
	cairo_close_path (cr);
	if (fill) {
		cairo_fill (cr);
	} else {
		cairo_stroke (cr);
	}
}

void
draw_draw_radial (cairo_t* cr,
                  gint x,
                  gint width,
                  gint height,
                  GdkRGBA* center_color,
                  GdkRGBA* edge_color)
{
	cairo_pattern_t* pattern = NULL;
	cairo_pattern_t* _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (center_color != NULL);
	g_return_if_fail (edge_color != NULL);
	_tmp0_ = cairo_pattern_create_radial ((gdouble) (x + (width / 2)), (gdouble) height, (gdouble) (width / 2), (gdouble) (x + (width / 2)), (gdouble) height, (gdouble) 0);
	pattern = _tmp0_;
	_tmp1_ = *center_color;
	_tmp2_ = *center_color;
	_tmp3_ = *center_color;
	_tmp4_ = *center_color;
	cairo_pattern_add_color_stop_rgba (pattern, (gdouble) 1, _tmp1_.red, _tmp2_.green, _tmp3_.blue, _tmp4_.alpha);
	_tmp5_ = *edge_color;
	_tmp6_ = *edge_color;
	_tmp7_ = *edge_color;
	_tmp8_ = *edge_color;
	cairo_pattern_add_color_stop_rgba (pattern, (gdouble) 0, _tmp5_.red, _tmp6_.green, _tmp7_.blue, _tmp8_.alpha);
	cairo_set_source (cr, pattern);
	cairo_paint (cr);
	_cairo_pattern_destroy0 (pattern);
}

void
draw_clip_rectangle (cairo_t* cr,
                     gint x,
                     gint y,
                     gint w,
                     gint h)
{
	g_return_if_fail (cr != NULL);
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_clip (cr);
}

void
draw_clip_rounded_rectangle (cairo_t* cr,
                             gint x,
                             gint y,
                             gint width,
                             gint height,
                             gdouble r)
{
	g_return_if_fail (cr != NULL);
	cairo_new_sub_path (cr);
	cairo_arc (cr, (x + width) - r, y + r, r, (G_PI * 3) / 2, G_PI * 2);
	cairo_arc (cr, (x + width) - r, (y + height) - r, r, (gdouble) 0, G_PI / 2);
	cairo_arc (cr, x + r, (y + height) - r, r, G_PI / 2, G_PI);
	cairo_arc (cr, x + r, y + r, r, G_PI, (G_PI * 3) / 2);
	cairo_close_path (cr);
	cairo_clip (cr);
}

