
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genLttngProvider.py

******************************************************************/


#define TRACEPOINT_DEFINE
#define TRACEPOINT_PROBE_DYNAMIC_LINKAGE

#include "stdlib.h"
#include "pal_mstypes.h"
#include "pal_error.h"
#include "pal.h"
#define PAL_free free
#define PAL_realloc realloc
#include "pal/stackstring.hpp"
#include "tpdotnetruntime.h"

#ifndef tracepoint_enabled

extern "C" bool XplatEventLoggerIsEnabled();

#define tracepoint_enabled(provider, name) XplatEventLoggerIsEnabled()
#define do_tracepoint tracepoint
#endif

#define wcslen PAL_wcslen

bool ResizeBuffer(char *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

extern "C" BOOL  EventXplatEnabledGCStart(){ return tracepoint_enabled(DotNETRuntime, GCStart); }

extern "C" ULONG  FireEtXplatGCStart(
    const unsigned int Count,
    const unsigned int Reason)
{
    if (!EventXplatEnabledGCStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCStart,
        Count,
        Reason);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCStart_V1(){ return tracepoint_enabled(DotNETRuntime, GCStart_V1); }

extern "C" ULONG  FireEtXplatGCStart_V1(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned int Reason,
    const unsigned int Type,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCStart_V1,
        Count,
        Depth,
        Reason,
        Type,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCStart_V2(){ return tracepoint_enabled(DotNETRuntime, GCStart_V2); }

extern "C" ULONG  FireEtXplatGCStart_V2(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned int Reason,
    const unsigned int Type,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ClientSequenceNumber)
{
    if (!EventXplatEnabledGCStart_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCStart_V2,
        Count,
        Depth,
        Reason,
        Type,
        ClrInstanceID,
        ClientSequenceNumber);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCEnd(){ return tracepoint_enabled(DotNETRuntime, GCEnd); }

extern "C" ULONG  FireEtXplatGCEnd(
    const unsigned int Count,
    const unsigned short Depth)
{
    if (!EventXplatEnabledGCEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCEnd,
        Count,
        Depth);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCEnd_V1(){ return tracepoint_enabled(DotNETRuntime, GCEnd_V1); }

extern "C" ULONG  FireEtXplatGCEnd_V1(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCEnd_V1,
        Count,
        Depth,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCRestartEEEnd(){ return tracepoint_enabled(DotNETRuntime, GCRestartEEEnd); }

extern "C" ULONG  FireEtXplatGCRestartEEEnd(
)
{
    if (!EventXplatEnabledGCRestartEEEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCRestartEEEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCRestartEEEnd_V1(){ return tracepoint_enabled(DotNETRuntime, GCRestartEEEnd_V1); }

extern "C" ULONG  FireEtXplatGCRestartEEEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCRestartEEEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCRestartEEEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCHeapStats(){ return tracepoint_enabled(DotNETRuntime, GCHeapStats); }

extern "C" ULONG  FireEtXplatGCHeapStats(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount)
{
    if (!EventXplatEnabledGCHeapStats())
        return ERROR_SUCCESS;

    size_t size = 92;
    char stackBuffer[92];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCHeapStats, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCHeapStats_V1(){ return tracepoint_enabled(DotNETRuntime, GCHeapStats_V1); }

extern "C" ULONG  FireEtXplatGCHeapStats_V1(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCHeapStats_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    char stackBuffer[94];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCHeapStats_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCHeapStats_V2(){ return tracepoint_enabled(DotNETRuntime, GCHeapStats_V2); }

extern "C" ULONG  FireEtXplatGCHeapStats_V2(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount,
    const unsigned short ClrInstanceID,
    const unsigned __int64 GenerationSize4,
    const unsigned __int64 TotalPromotedSize4)
{
    if (!EventXplatEnabledGCHeapStats_V2())
        return ERROR_SUCCESS;

    size_t size = 110;
    char stackBuffer[110];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize4, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize4, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCHeapStats_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCCreateSegment(){ return tracepoint_enabled(DotNETRuntime, GCCreateSegment); }

extern "C" ULONG  FireEtXplatGCCreateSegment(
    const unsigned __int64 Address,
    const unsigned __int64 Size,
    const unsigned int Type)
{
    if (!EventXplatEnabledGCCreateSegment())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCCreateSegment,
        Address,
        Size,
        Type);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCCreateSegment_V1(){ return tracepoint_enabled(DotNETRuntime, GCCreateSegment_V1); }

extern "C" ULONG  FireEtXplatGCCreateSegment_V1(
    const unsigned __int64 Address,
    const unsigned __int64 Size,
    const unsigned int Type,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCCreateSegment_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCCreateSegment_V1,
        Address,
        Size,
        Type,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFreeSegment(){ return tracepoint_enabled(DotNETRuntime, GCFreeSegment); }

extern "C" ULONG  FireEtXplatGCFreeSegment(
    const unsigned __int64 Address)
{
    if (!EventXplatEnabledGCFreeSegment())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCFreeSegment,
        Address);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFreeSegment_V1(){ return tracepoint_enabled(DotNETRuntime, GCFreeSegment_V1); }

extern "C" ULONG  FireEtXplatGCFreeSegment_V1(
    const unsigned __int64 Address,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCFreeSegment_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCFreeSegment_V1,
        Address,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCRestartEEBegin(){ return tracepoint_enabled(DotNETRuntime, GCRestartEEBegin); }

extern "C" ULONG  FireEtXplatGCRestartEEBegin(
)
{
    if (!EventXplatEnabledGCRestartEEBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCRestartEEBegin);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCRestartEEBegin_V1(){ return tracepoint_enabled(DotNETRuntime, GCRestartEEBegin_V1); }

extern "C" ULONG  FireEtXplatGCRestartEEBegin_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCRestartEEBegin_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCRestartEEBegin_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSuspendEEEnd(){ return tracepoint_enabled(DotNETRuntime, GCSuspendEEEnd); }

extern "C" ULONG  FireEtXplatGCSuspendEEEnd(
)
{
    if (!EventXplatEnabledGCSuspendEEEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCSuspendEEEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSuspendEEEnd_V1(){ return tracepoint_enabled(DotNETRuntime, GCSuspendEEEnd_V1); }

extern "C" ULONG  FireEtXplatGCSuspendEEEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSuspendEEEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCSuspendEEEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSuspendEEBegin(){ return tracepoint_enabled(DotNETRuntime, GCSuspendEEBegin); }

extern "C" ULONG  FireEtXplatGCSuspendEEBegin(
    const unsigned short Reason)
{
    if (!EventXplatEnabledGCSuspendEEBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCSuspendEEBegin,
        Reason);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSuspendEEBegin_V1(){ return tracepoint_enabled(DotNETRuntime, GCSuspendEEBegin_V1); }

extern "C" ULONG  FireEtXplatGCSuspendEEBegin_V1(
    const unsigned int Reason,
    const unsigned int Count,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSuspendEEBegin_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCSuspendEEBegin_V1,
        Reason,
        Count,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCAllocationTick(){ return tracepoint_enabled(DotNETRuntime, GCAllocationTick); }

extern "C" ULONG  FireEtXplatGCAllocationTick(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind)
{
    if (!EventXplatEnabledGCAllocationTick())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCAllocationTick,
        AllocationAmount,
        AllocationKind);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCAllocationTick_V1(){ return tracepoint_enabled(DotNETRuntime, GCAllocationTick_V1); }

extern "C" ULONG  FireEtXplatGCAllocationTick_V1(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCAllocationTick_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCAllocationTick_V1,
        AllocationAmount,
        AllocationKind,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCAllocationTick_V2(){ return tracepoint_enabled(DotNETRuntime, GCAllocationTick_V2); }

extern "C" ULONG  FireEtXplatGCAllocationTick_V2(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex)
{
    if (!EventXplatEnabledGCAllocationTick_V2())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        GCAllocationTick_V2,
        AllocationAmount,
        AllocationKind,
        ClrInstanceID,
        AllocationAmount64,
        (const size_t) TypeID,
        TypeName_full_name,
        HeapIndex);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCAllocationTick_V3(){ return tracepoint_enabled(DotNETRuntime, GCAllocationTick_V3); }

extern "C" ULONG  FireEtXplatGCAllocationTick_V3(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex,
    const void* Address)
{
    if (!EventXplatEnabledGCAllocationTick_V3())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        GCAllocationTick_V3,
        AllocationAmount,
        AllocationKind,
        ClrInstanceID,
        AllocationAmount64,
        (const size_t) TypeID,
        TypeName_full_name,
        HeapIndex,
        (const size_t) Address);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCAllocationTick_V4(){ return tracepoint_enabled(DotNETRuntime, GCAllocationTick_V4); }

extern "C" ULONG  FireEtXplatGCAllocationTick_V4(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex,
    const void* Address,
    const unsigned __int64 ObjectSize)
{
    if (!EventXplatEnabledGCAllocationTick_V4())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        GCAllocationTick_V4,
        AllocationAmount,
        AllocationKind,
        ClrInstanceID,
        AllocationAmount64,
        (const size_t) TypeID,
        TypeName_full_name,
        HeapIndex,
        (const size_t) Address,
        ObjectSize);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCCreateConcurrentThread(){ return tracepoint_enabled(DotNETRuntime, GCCreateConcurrentThread); }

extern "C" ULONG  FireEtXplatGCCreateConcurrentThread(
)
{
    if (!EventXplatEnabledGCCreateConcurrentThread())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCCreateConcurrentThread);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCCreateConcurrentThread_V1(){ return tracepoint_enabled(DotNETRuntime, GCCreateConcurrentThread_V1); }

extern "C" ULONG  FireEtXplatGCCreateConcurrentThread_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCCreateConcurrentThread_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCCreateConcurrentThread_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCTerminateConcurrentThread(){ return tracepoint_enabled(DotNETRuntime, GCTerminateConcurrentThread); }

extern "C" ULONG  FireEtXplatGCTerminateConcurrentThread(
)
{
    if (!EventXplatEnabledGCTerminateConcurrentThread())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCTerminateConcurrentThread);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCTerminateConcurrentThread_V1(){ return tracepoint_enabled(DotNETRuntime, GCTerminateConcurrentThread_V1); }

extern "C" ULONG  FireEtXplatGCTerminateConcurrentThread_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCTerminateConcurrentThread_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCTerminateConcurrentThread_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFinalizersEnd(){ return tracepoint_enabled(DotNETRuntime, GCFinalizersEnd); }

extern "C" ULONG  FireEtXplatGCFinalizersEnd(
    const unsigned int Count)
{
    if (!EventXplatEnabledGCFinalizersEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCFinalizersEnd,
        Count);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFinalizersEnd_V1(){ return tracepoint_enabled(DotNETRuntime, GCFinalizersEnd_V1); }

extern "C" ULONG  FireEtXplatGCFinalizersEnd_V1(
    const unsigned int Count,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCFinalizersEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCFinalizersEnd_V1,
        Count,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFinalizersBegin(){ return tracepoint_enabled(DotNETRuntime, GCFinalizersBegin); }

extern "C" ULONG  FireEtXplatGCFinalizersBegin(
)
{
    if (!EventXplatEnabledGCFinalizersBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, GCFinalizersBegin);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFinalizersBegin_V1(){ return tracepoint_enabled(DotNETRuntime, GCFinalizersBegin_V1); }

extern "C" ULONG  FireEtXplatGCFinalizersBegin_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCFinalizersBegin_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCFinalizersBegin_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBulkType(){ return tracepoint_enabled(DotNETRuntime, BulkType); }

extern "C" ULONG  FireEtXplatBulkType(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledBulkType())
        return ERROR_SUCCESS;

    size_t size = 38;
    char stackBuffer[38];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, BulkType, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkRootEdge(){ return tracepoint_enabled(DotNETRuntime, GCBulkRootEdge); }

extern "C" ULONG  FireEtXplatGCBulkRootEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkRootEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkRootEdge, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkRootConditionalWeakTableElementEdge(){ return tracepoint_enabled(DotNETRuntime, GCBulkRootConditionalWeakTableElementEdge); }

extern "C" ULONG  FireEtXplatGCBulkRootConditionalWeakTableElementEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkRootConditionalWeakTableElementEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkRootConditionalWeakTableElementEdge, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkNode(){ return tracepoint_enabled(DotNETRuntime, GCBulkNode); }

extern "C" ULONG  FireEtXplatGCBulkNode(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkNode())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkNode, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkEdge(){ return tracepoint_enabled(DotNETRuntime, GCBulkEdge); }

extern "C" ULONG  FireEtXplatGCBulkEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkEdge, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSampledObjectAllocationHigh(){ return tracepoint_enabled(DotNETRuntime, GCSampledObjectAllocationHigh); }

extern "C" ULONG  FireEtXplatGCSampledObjectAllocationHigh(
    const void* Address,
    const void* TypeID,
    const unsigned int ObjectCountForTypeSample,
    const unsigned __int64 TotalSizeForTypeSample,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSampledObjectAllocationHigh())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCSampledObjectAllocationHigh,
        (const size_t) Address,
        (const size_t) TypeID,
        ObjectCountForTypeSample,
        TotalSizeForTypeSample,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkSurvivingObjectRanges(){ return tracepoint_enabled(DotNETRuntime, GCBulkSurvivingObjectRanges); }

extern "C" ULONG  FireEtXplatGCBulkSurvivingObjectRanges(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkSurvivingObjectRanges())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkSurvivingObjectRanges, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkMovedObjectRanges(){ return tracepoint_enabled(DotNETRuntime, GCBulkMovedObjectRanges); }

extern "C" ULONG  FireEtXplatGCBulkMovedObjectRanges(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkMovedObjectRanges())
        return ERROR_SUCCESS;

    size_t size = 42;
    char stackBuffer[42];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkMovedObjectRanges, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGenerationRange(){ return tracepoint_enabled(DotNETRuntime, GCGenerationRange); }

extern "C" ULONG  FireEtXplatGCGenerationRange(
    const unsigned char Generation,
    const void* RangeStart,
    const unsigned __int64 RangeUsedLength,
    const unsigned __int64 RangeReservedLength,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCGenerationRange())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCGenerationRange,
        Generation,
        (const size_t) RangeStart,
        RangeUsedLength,
        RangeReservedLength,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCMarkStackRoots(){ return tracepoint_enabled(DotNETRuntime, GCMarkStackRoots); }

extern "C" ULONG  FireEtXplatGCMarkStackRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCMarkStackRoots())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCMarkStackRoots,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCMarkFinalizeQueueRoots(){ return tracepoint_enabled(DotNETRuntime, GCMarkFinalizeQueueRoots); }

extern "C" ULONG  FireEtXplatGCMarkFinalizeQueueRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCMarkFinalizeQueueRoots())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCMarkFinalizeQueueRoots,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCMarkHandles(){ return tracepoint_enabled(DotNETRuntime, GCMarkHandles); }

extern "C" ULONG  FireEtXplatGCMarkHandles(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCMarkHandles())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCMarkHandles,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCMarkOlderGenerationRoots(){ return tracepoint_enabled(DotNETRuntime, GCMarkOlderGenerationRoots); }

extern "C" ULONG  FireEtXplatGCMarkOlderGenerationRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCMarkOlderGenerationRoots())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCMarkOlderGenerationRoots,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFinalizeObject(){ return tracepoint_enabled(DotNETRuntime, FinalizeObject); }

extern "C" ULONG  FireEtXplatFinalizeObject(
    const void* TypeID,
    const void* ObjectID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFinalizeObject())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        FinalizeObject,
        (const size_t) TypeID,
        (const size_t) ObjectID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledSetGCHandle(){ return tracepoint_enabled(DotNETRuntime, SetGCHandle); }

extern "C" ULONG  FireEtXplatSetGCHandle(
    const void* HandleID,
    const void* ObjectID,
    const unsigned int Kind,
    const unsigned int Generation,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledSetGCHandle())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        SetGCHandle,
        (const size_t) HandleID,
        (const size_t) ObjectID,
        Kind,
        Generation,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDestroyGCHandle(){ return tracepoint_enabled(DotNETRuntime, DestroyGCHandle); }

extern "C" ULONG  FireEtXplatDestroyGCHandle(
    const void* HandleID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDestroyGCHandle())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        DestroyGCHandle,
        (const size_t) HandleID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSampledObjectAllocationLow(){ return tracepoint_enabled(DotNETRuntime, GCSampledObjectAllocationLow); }

extern "C" ULONG  FireEtXplatGCSampledObjectAllocationLow(
    const void* Address,
    const void* TypeID,
    const unsigned int ObjectCountForTypeSample,
    const unsigned __int64 TotalSizeForTypeSample,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSampledObjectAllocationLow())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCSampledObjectAllocationLow,
        (const size_t) Address,
        (const size_t) TypeID,
        ObjectCountForTypeSample,
        TotalSizeForTypeSample,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPinObjectAtGCTime(){ return tracepoint_enabled(DotNETRuntime, PinObjectAtGCTime); }

extern "C" ULONG  FireEtXplatPinObjectAtGCTime(
    const void* HandleID,
    const void* ObjectID,
    const unsigned __int64 ObjectSize,
    PCWSTR TypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPinObjectAtGCTime())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        PinObjectAtGCTime,
        (const size_t) HandleID,
        (const size_t) ObjectID,
        ObjectSize,
        TypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCTriggered(){ return tracepoint_enabled(DotNETRuntime, GCTriggered); }

extern "C" ULONG  FireEtXplatGCTriggered(
    const unsigned int Reason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCTriggered())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCTriggered,
        Reason,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkRootCCW(){ return tracepoint_enabled(DotNETRuntime, GCBulkRootCCW); }

extern "C" ULONG  FireEtXplatGCBulkRootCCW(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkRootCCW())
        return ERROR_SUCCESS;

    size_t size = 38;
    char stackBuffer[38];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkRootCCW, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkRCW(){ return tracepoint_enabled(DotNETRuntime, GCBulkRCW); }

extern "C" ULONG  FireEtXplatGCBulkRCW(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkRCW())
        return ERROR_SUCCESS;

    size_t size = 38;
    char stackBuffer[38];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkRCW, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCBulkRootStaticVar(){ return tracepoint_enabled(DotNETRuntime, GCBulkRootStaticVar); }

extern "C" ULONG  FireEtXplatGCBulkRootStaticVar(
    const unsigned int Count,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCBulkRootStaticVar())
        return ERROR_SUCCESS;

    size_t size = 46;
    char stackBuffer[46];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCBulkRootStaticVar, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCDynamicEvent(){ return tracepoint_enabled(DotNETRuntime, GCDynamicEvent); }

extern "C" ULONG  FireEtXplatGCDynamicEvent(
    PCWSTR Name,
    const unsigned int DataSize,
    const BYTE* Data,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCDynamicEvent())
        return ERROR_SUCCESS;

    size_t size = 71;
    char stackBuffer[71];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Name, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCDynamicEvent, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledWorkerThreadCreate(){ return tracepoint_enabled(DotNETRuntime, WorkerThreadCreate); }

extern "C" ULONG  FireEtXplatWorkerThreadCreate(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads)
{
    if (!EventXplatEnabledWorkerThreadCreate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        WorkerThreadCreate,
        WorkerThreadCount,
        RetiredWorkerThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledWorkerThreadTerminate(){ return tracepoint_enabled(DotNETRuntime, WorkerThreadTerminate); }

extern "C" ULONG  FireEtXplatWorkerThreadTerminate(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads)
{
    if (!EventXplatEnabledWorkerThreadTerminate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        WorkerThreadTerminate,
        WorkerThreadCount,
        RetiredWorkerThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledWorkerThreadRetire(){ return tracepoint_enabled(DotNETRuntime, WorkerThreadRetire); }

extern "C" ULONG  FireEtXplatWorkerThreadRetire(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads)
{
    if (!EventXplatEnabledWorkerThreadRetire())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        WorkerThreadRetire,
        WorkerThreadCount,
        RetiredWorkerThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledWorkerThreadUnretire(){ return tracepoint_enabled(DotNETRuntime, WorkerThreadUnretire); }

extern "C" ULONG  FireEtXplatWorkerThreadUnretire(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads)
{
    if (!EventXplatEnabledWorkerThreadUnretire())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        WorkerThreadUnretire,
        WorkerThreadCount,
        RetiredWorkerThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadCreate(){ return tracepoint_enabled(DotNETRuntime, IOThreadCreate); }

extern "C" ULONG  FireEtXplatIOThreadCreate(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads)
{
    if (!EventXplatEnabledIOThreadCreate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadCreate,
        IOThreadCount,
        RetiredIOThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadCreate_V1(){ return tracepoint_enabled(DotNETRuntime, IOThreadCreate_V1); }

extern "C" ULONG  FireEtXplatIOThreadCreate_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIOThreadCreate_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadCreate_V1,
        IOThreadCount,
        RetiredIOThreads,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadTerminate(){ return tracepoint_enabled(DotNETRuntime, IOThreadTerminate); }

extern "C" ULONG  FireEtXplatIOThreadTerminate(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads)
{
    if (!EventXplatEnabledIOThreadTerminate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadTerminate,
        IOThreadCount,
        RetiredIOThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadTerminate_V1(){ return tracepoint_enabled(DotNETRuntime, IOThreadTerminate_V1); }

extern "C" ULONG  FireEtXplatIOThreadTerminate_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIOThreadTerminate_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadTerminate_V1,
        IOThreadCount,
        RetiredIOThreads,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadRetire(){ return tracepoint_enabled(DotNETRuntime, IOThreadRetire); }

extern "C" ULONG  FireEtXplatIOThreadRetire(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads)
{
    if (!EventXplatEnabledIOThreadRetire())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadRetire,
        IOThreadCount,
        RetiredIOThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadRetire_V1(){ return tracepoint_enabled(DotNETRuntime, IOThreadRetire_V1); }

extern "C" ULONG  FireEtXplatIOThreadRetire_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIOThreadRetire_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadRetire_V1,
        IOThreadCount,
        RetiredIOThreads,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadUnretire(){ return tracepoint_enabled(DotNETRuntime, IOThreadUnretire); }

extern "C" ULONG  FireEtXplatIOThreadUnretire(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads)
{
    if (!EventXplatEnabledIOThreadUnretire())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadUnretire,
        IOThreadCount,
        RetiredIOThreads);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIOThreadUnretire_V1(){ return tracepoint_enabled(DotNETRuntime, IOThreadUnretire_V1); }

extern "C" ULONG  FireEtXplatIOThreadUnretire_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIOThreadUnretire_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IOThreadUnretire_V1,
        IOThreadCount,
        RetiredIOThreads,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadpoolSuspensionSuspendThread(){ return tracepoint_enabled(DotNETRuntime, ThreadpoolSuspensionSuspendThread); }

extern "C" ULONG  FireEtXplatThreadpoolSuspensionSuspendThread(
    const unsigned int ClrThreadID,
    const unsigned int CpuUtilization)
{
    if (!EventXplatEnabledThreadpoolSuspensionSuspendThread())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadpoolSuspensionSuspendThread,
        ClrThreadID,
        CpuUtilization);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadpoolSuspensionResumeThread(){ return tracepoint_enabled(DotNETRuntime, ThreadpoolSuspensionResumeThread); }

extern "C" ULONG  FireEtXplatThreadpoolSuspensionResumeThread(
    const unsigned int ClrThreadID,
    const unsigned int CpuUtilization)
{
    if (!EventXplatEnabledThreadpoolSuspensionResumeThread())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadpoolSuspensionResumeThread,
        ClrThreadID,
        CpuUtilization);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadStart(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadStart); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadStart(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadStart,
        ActiveWorkerThreadCount,
        RetiredWorkerThreadCount,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadStop(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadStop); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadStop(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadStop,
        ActiveWorkerThreadCount,
        RetiredWorkerThreadCount,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadRetirementStart(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadRetirementStart); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadRetirementStart(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadRetirementStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadRetirementStart,
        ActiveWorkerThreadCount,
        RetiredWorkerThreadCount,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadRetirementStop(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadRetirementStop); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadRetirementStop(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadRetirementStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadRetirementStop,
        ActiveWorkerThreadCount,
        RetiredWorkerThreadCount,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadAdjustmentSample(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadAdjustmentSample); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadAdjustmentSample(
    const double Throughput,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadAdjustmentSample())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadAdjustmentSample,
        Throughput,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadAdjustmentAdjustment(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadAdjustmentAdjustment); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadAdjustmentAdjustment(
    const double AverageThroughput,
    const unsigned int NewWorkerThreadCount,
    const unsigned int Reason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadAdjustmentAdjustment())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadAdjustmentAdjustment,
        AverageThroughput,
        NewWorkerThreadCount,
        Reason,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadAdjustmentStats(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadAdjustmentStats); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadAdjustmentStats(
    const double Duration,
    const double Throughput,
    const double ThreadWave,
    const double ThroughputWave,
    const double ThroughputErrorEstimate,
    const double AverageThroughputErrorEstimate,
    const double ThroughputRatio,
    const double Confidence,
    const double NewControlSetting,
    const unsigned short NewThreadWaveMagnitude,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadAdjustmentStats())
        return ERROR_SUCCESS;

    size_t size = 76;
    char stackBuffer[76];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(Duration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Throughput, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThreadWave, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputWave, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputErrorEstimate, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AverageThroughputErrorEstimate, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputRatio, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Confidence, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewControlSetting, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewThreadWaveMagnitude, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, ThreadPoolWorkerThreadAdjustmentStats, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkerThreadWait(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkerThreadWait); }

extern "C" ULONG  FireEtXplatThreadPoolWorkerThreadWait(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkerThreadWait())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkerThreadWait,
        ActiveWorkerThreadCount,
        RetiredWorkerThreadCount,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledYieldProcessorMeasurement(){ return tracepoint_enabled(DotNETRuntime, YieldProcessorMeasurement); }

extern "C" ULONG  FireEtXplatYieldProcessorMeasurement(
    const unsigned short ClrInstanceID,
    const double NsPerYield,
    const double EstablishedNsPerYield)
{
    if (!EventXplatEnabledYieldProcessorMeasurement())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        YieldProcessorMeasurement,
        ClrInstanceID,
        NsPerYield,
        EstablishedNsPerYield);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolMinMaxThreads(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolMinMaxThreads); }

extern "C" ULONG  FireEtXplatThreadPoolMinMaxThreads(
    const unsigned short MinWorkerThreads,
    const unsigned short MaxWorkerThreads,
    const unsigned short MinIOCompletionThreads,
    const unsigned short MaxIOCompletionThreads,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolMinMaxThreads())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolMinMaxThreads,
        MinWorkerThreads,
        MaxWorkerThreads,
        MinIOCompletionThreads,
        MaxIOCompletionThreads,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolWorkingThreadCount(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolWorkingThreadCount); }

extern "C" ULONG  FireEtXplatThreadPoolWorkingThreadCount(
    const unsigned int Count,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolWorkingThreadCount())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolWorkingThreadCount,
        Count,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolEnqueue(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolEnqueue); }

extern "C" ULONG  FireEtXplatThreadPoolEnqueue(
    const void* WorkID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolEnqueue())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolEnqueue,
        (const size_t) WorkID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolDequeue(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolDequeue); }

extern "C" ULONG  FireEtXplatThreadPoolDequeue(
    const void* WorkID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolDequeue())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolDequeue,
        (const size_t) WorkID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolIOEnqueue(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolIOEnqueue); }

extern "C" ULONG  FireEtXplatThreadPoolIOEnqueue(
    const void* NativeOverlapped,
    const void* Overlapped,
    const BOOL MultiDequeues,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolIOEnqueue())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolIOEnqueue,
        (const size_t) NativeOverlapped,
        (const size_t) Overlapped,
        MultiDequeues,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolIODequeue(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolIODequeue); }

extern "C" ULONG  FireEtXplatThreadPoolIODequeue(
    const void* NativeOverlapped,
    const void* Overlapped,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolIODequeue())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolIODequeue,
        (const size_t) NativeOverlapped,
        (const size_t) Overlapped,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadPoolIOPack(){ return tracepoint_enabled(DotNETRuntime, ThreadPoolIOPack); }

extern "C" ULONG  FireEtXplatThreadPoolIOPack(
    const void* NativeOverlapped,
    const void* Overlapped,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadPoolIOPack())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadPoolIOPack,
        (const size_t) NativeOverlapped,
        (const size_t) Overlapped,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadCreating(){ return tracepoint_enabled(DotNETRuntime, ThreadCreating); }

extern "C" ULONG  FireEtXplatThreadCreating(
    const void* ID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadCreating())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadCreating,
        (const size_t) ID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadRunning(){ return tracepoint_enabled(DotNETRuntime, ThreadRunning); }

extern "C" ULONG  FireEtXplatThreadRunning(
    const void* ID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadRunning())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadRunning,
        (const size_t) ID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDetails(){ return tracepoint_enabled(DotNETRuntime, MethodDetails); }

extern "C" ULONG  FireEtXplatMethodDetails(
    const unsigned __int64 MethodID,
    const unsigned __int64 TypeID,
    const unsigned int MethodToken,
    const unsigned int TypeParameterCount,
    const unsigned __int64 LoaderModuleID,
    const unsigned __int64* TypeParameters)
{
    if (!EventXplatEnabledMethodDetails())
        return ERROR_SUCCESS;

    size_t size = 40;
    char stackBuffer[40];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeParameterCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoaderModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)TypeParameters, sizeof(const unsigned __int64) * (int)TypeParameterCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodDetails, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTypeLoadStart(){ return tracepoint_enabled(DotNETRuntime, TypeLoadStart); }

extern "C" ULONG  FireEtXplatTypeLoadStart(
    const unsigned int TypeLoadStartID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTypeLoadStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TypeLoadStart,
        TypeLoadStartID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTypeLoadStop(){ return tracepoint_enabled(DotNETRuntime, TypeLoadStop); }

extern "C" ULONG  FireEtXplatTypeLoadStop(
    const unsigned int TypeLoadStartID,
    const unsigned short ClrInstanceID,
    const unsigned short LoadLevel,
    const unsigned __int64 TypeID,
    PCWSTR TypeName)
{
    if (!EventXplatEnabledTypeLoadStop())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        TypeLoadStop,
        TypeLoadStartID,
        ClrInstanceID,
        LoadLevel,
        TypeID,
        TypeName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionThrown(){ return tracepoint_enabled(DotNETRuntime, ExceptionThrown); }

extern "C" ULONG  FireEtXplatExceptionThrown(
)
{
    if (!EventXplatEnabledExceptionThrown())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, ExceptionThrown);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionThrown_V1(){ return tracepoint_enabled(DotNETRuntime, ExceptionThrown_V1); }

extern "C" ULONG  FireEtXplatExceptionThrown_V1(
    PCWSTR ExceptionType,
    PCWSTR ExceptionMessage,
    const void* ExceptionEIP,
    const unsigned int ExceptionHRESULT,
    const unsigned short ExceptionFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExceptionThrown_V1())
        return ERROR_SUCCESS;
    INT ExceptionType_path_size = -1;
    PathCharString ExceptionType_PS;
    INT ExceptionType_full_name_path_size = (wcslen(ExceptionType) + 1)*sizeof(WCHAR);
    CHAR* ExceptionType_full_name = ExceptionType_PS.OpenStringBuffer(ExceptionType_full_name_path_size );
    if (ExceptionType_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ExceptionMessage_path_size = -1;
    PathCharString ExceptionMessage_PS;
    INT ExceptionMessage_full_name_path_size = (wcslen(ExceptionMessage) + 1)*sizeof(WCHAR);
    CHAR* ExceptionMessage_full_name = ExceptionMessage_PS.OpenStringBuffer(ExceptionMessage_full_name_path_size );
    if (ExceptionMessage_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ExceptionType_path_size = WideCharToMultiByte( CP_ACP, 0, ExceptionType, -1, ExceptionType_full_name, ExceptionType_full_name_path_size, NULL, NULL );
    _ASSERTE(ExceptionType_path_size < ExceptionType_full_name_path_size );
    ExceptionType_PS.CloseBuffer(ExceptionType_path_size );
    if( ExceptionType_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ExceptionMessage_path_size = WideCharToMultiByte( CP_ACP, 0, ExceptionMessage, -1, ExceptionMessage_full_name, ExceptionMessage_full_name_path_size, NULL, NULL );
    _ASSERTE(ExceptionMessage_path_size < ExceptionMessage_full_name_path_size );
    ExceptionMessage_PS.CloseBuffer(ExceptionMessage_path_size );
    if( ExceptionMessage_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ExceptionThrown_V1,
        ExceptionType_full_name,
        ExceptionMessage_full_name,
        (const size_t) ExceptionEIP,
        ExceptionHRESULT,
        ExceptionFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionCatchStart(){ return tracepoint_enabled(DotNETRuntime, ExceptionCatchStart); }

extern "C" ULONG  FireEtXplatExceptionCatchStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExceptionCatchStart())
        return ERROR_SUCCESS;
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ExceptionCatchStart,
        EntryEIP,
        MethodID,
        MethodName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionCatchStop(){ return tracepoint_enabled(DotNETRuntime, ExceptionCatchStop); }

extern "C" ULONG  FireEtXplatExceptionCatchStop(
)
{
    if (!EventXplatEnabledExceptionCatchStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, ExceptionCatchStop);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionFinallyStart(){ return tracepoint_enabled(DotNETRuntime, ExceptionFinallyStart); }

extern "C" ULONG  FireEtXplatExceptionFinallyStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExceptionFinallyStart())
        return ERROR_SUCCESS;
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ExceptionFinallyStart,
        EntryEIP,
        MethodID,
        MethodName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionFinallyStop(){ return tracepoint_enabled(DotNETRuntime, ExceptionFinallyStop); }

extern "C" ULONG  FireEtXplatExceptionFinallyStop(
)
{
    if (!EventXplatEnabledExceptionFinallyStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, ExceptionFinallyStop);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionFilterStart(){ return tracepoint_enabled(DotNETRuntime, ExceptionFilterStart); }

extern "C" ULONG  FireEtXplatExceptionFilterStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExceptionFilterStart())
        return ERROR_SUCCESS;
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ExceptionFilterStart,
        EntryEIP,
        MethodID,
        MethodName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionFilterStop(){ return tracepoint_enabled(DotNETRuntime, ExceptionFilterStop); }

extern "C" ULONG  FireEtXplatExceptionFilterStop(
)
{
    if (!EventXplatEnabledExceptionFilterStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, ExceptionFilterStop);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExceptionThrownStop(){ return tracepoint_enabled(DotNETRuntime, ExceptionThrownStop); }

extern "C" ULONG  FireEtXplatExceptionThrownStop(
)
{
    if (!EventXplatEnabledExceptionThrownStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, ExceptionThrownStop);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledContention(){ return tracepoint_enabled(DotNETRuntime, Contention); }

extern "C" ULONG  FireEtXplatContention(
)
{
    if (!EventXplatEnabledContention())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, Contention);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledContentionStart_V1(){ return tracepoint_enabled(DotNETRuntime, ContentionStart_V1); }

extern "C" ULONG  FireEtXplatContentionStart_V1(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledContentionStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ContentionStart_V1,
        ContentionFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledContentionStop(){ return tracepoint_enabled(DotNETRuntime, ContentionStop); }

extern "C" ULONG  FireEtXplatContentionStop(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledContentionStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ContentionStop,
        ContentionFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledContentionStop_V1(){ return tracepoint_enabled(DotNETRuntime, ContentionStop_V1); }

extern "C" ULONG  FireEtXplatContentionStop_V1(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID,
    const double DurationNs)
{
    if (!EventXplatEnabledContentionStop_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ContentionStop_V1,
        ContentionFlags,
        ClrInstanceID,
        DurationNs);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCLRStackWalk(){ return tracepoint_enabled(DotNETRuntime, CLRStackWalk); }

extern "C" ULONG  FireEtXplatCLRStackWalk(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack)
{
    if (!EventXplatEnabledCLRStackWalk())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        CLRStackWalk,
        ClrInstanceID,
        Reserved1,
        Reserved2,
        FrameCount,
        (const size_t*) Stack);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainMemAllocated(){ return tracepoint_enabled(DotNETRuntime, AppDomainMemAllocated); }

extern "C" ULONG  FireEtXplatAppDomainMemAllocated(
    const unsigned __int64 AppDomainID,
    const unsigned __int64 Allocated,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainMemAllocated())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        AppDomainMemAllocated,
        AppDomainID,
        Allocated,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainMemSurvived(){ return tracepoint_enabled(DotNETRuntime, AppDomainMemSurvived); }

extern "C" ULONG  FireEtXplatAppDomainMemSurvived(
    const unsigned __int64 AppDomainID,
    const unsigned __int64 Survived,
    const unsigned __int64 ProcessSurvived,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainMemSurvived())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        AppDomainMemSurvived,
        AppDomainID,
        Survived,
        ProcessSurvived,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadCreated(){ return tracepoint_enabled(DotNETRuntime, ThreadCreated); }

extern "C" ULONG  FireEtXplatThreadCreated(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned int Flags,
    const unsigned int ManagedThreadIndex,
    const unsigned int OSThreadID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadCreated())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadCreated,
        ManagedThreadID,
        AppDomainID,
        Flags,
        ManagedThreadIndex,
        OSThreadID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadTerminated(){ return tracepoint_enabled(DotNETRuntime, ThreadTerminated); }

extern "C" ULONG  FireEtXplatThreadTerminated(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadTerminated())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadTerminated,
        ManagedThreadID,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledThreadDomainEnter(){ return tracepoint_enabled(DotNETRuntime, ThreadDomainEnter); }

extern "C" ULONG  FireEtXplatThreadDomainEnter(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledThreadDomainEnter())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ThreadDomainEnter,
        ManagedThreadID,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledILStubGenerated(){ return tracepoint_enabled(DotNETRuntime, ILStubGenerated); }

extern "C" ULONG  FireEtXplatILStubGenerated(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 StubMethodID,
    const unsigned int StubFlags,
    const unsigned int ManagedInteropMethodToken,
    PCWSTR ManagedInteropMethodNamespace,
    PCWSTR ManagedInteropMethodName,
    PCWSTR ManagedInteropMethodSignature,
    PCWSTR NativeMethodSignature,
    PCWSTR StubMethodSignature,
    PCWSTR StubMethodILCode)
{
    if (!EventXplatEnabledILStubGenerated())
        return ERROR_SUCCESS;

    size_t size = 410;
    char stackBuffer[410];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativeMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodILCode, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, ILStubGenerated, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledILStubCacheHit(){ return tracepoint_enabled(DotNETRuntime, ILStubCacheHit); }

extern "C" ULONG  FireEtXplatILStubCacheHit(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 StubMethodID,
    const unsigned int ManagedInteropMethodToken,
    PCWSTR ManagedInteropMethodNamespace,
    PCWSTR ManagedInteropMethodName,
    PCWSTR ManagedInteropMethodSignature)
{
    if (!EventXplatEnabledILStubCacheHit())
        return ERROR_SUCCESS;
    INT ManagedInteropMethodNamespace_path_size = -1;
    PathCharString ManagedInteropMethodNamespace_PS;
    INT ManagedInteropMethodNamespace_full_name_path_size = (wcslen(ManagedInteropMethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* ManagedInteropMethodNamespace_full_name = ManagedInteropMethodNamespace_PS.OpenStringBuffer(ManagedInteropMethodNamespace_full_name_path_size );
    if (ManagedInteropMethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ManagedInteropMethodName_path_size = -1;
    PathCharString ManagedInteropMethodName_PS;
    INT ManagedInteropMethodName_full_name_path_size = (wcslen(ManagedInteropMethodName) + 1)*sizeof(WCHAR);
    CHAR* ManagedInteropMethodName_full_name = ManagedInteropMethodName_PS.OpenStringBuffer(ManagedInteropMethodName_full_name_path_size );
    if (ManagedInteropMethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ManagedInteropMethodSignature_path_size = -1;
    PathCharString ManagedInteropMethodSignature_PS;
    INT ManagedInteropMethodSignature_full_name_path_size = (wcslen(ManagedInteropMethodSignature) + 1)*sizeof(WCHAR);
    CHAR* ManagedInteropMethodSignature_full_name = ManagedInteropMethodSignature_PS.OpenStringBuffer(ManagedInteropMethodSignature_full_name_path_size );
    if (ManagedInteropMethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ManagedInteropMethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, ManagedInteropMethodNamespace, -1, ManagedInteropMethodNamespace_full_name, ManagedInteropMethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(ManagedInteropMethodNamespace_path_size < ManagedInteropMethodNamespace_full_name_path_size );
    ManagedInteropMethodNamespace_PS.CloseBuffer(ManagedInteropMethodNamespace_path_size );
    if( ManagedInteropMethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ManagedInteropMethodName_path_size = WideCharToMultiByte( CP_ACP, 0, ManagedInteropMethodName, -1, ManagedInteropMethodName_full_name, ManagedInteropMethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(ManagedInteropMethodName_path_size < ManagedInteropMethodName_full_name_path_size );
    ManagedInteropMethodName_PS.CloseBuffer(ManagedInteropMethodName_path_size );
    if( ManagedInteropMethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ManagedInteropMethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, ManagedInteropMethodSignature, -1, ManagedInteropMethodSignature_full_name, ManagedInteropMethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(ManagedInteropMethodSignature_path_size < ManagedInteropMethodSignature_full_name_path_size );
    ManagedInteropMethodSignature_PS.CloseBuffer(ManagedInteropMethodSignature_path_size );
    if( ManagedInteropMethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ILStubCacheHit,
        ClrInstanceID,
        ModuleID,
        StubMethodID,
        ManagedInteropMethodToken,
        ManagedInteropMethodNamespace_full_name,
        ManagedInteropMethodName_full_name,
        ManagedInteropMethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCStartCompleteV2(){ return tracepoint_enabled(DotNETRuntime, DCStartCompleteV2); }

extern "C" ULONG  FireEtXplatDCStartCompleteV2(
)
{
    if (!EventXplatEnabledDCStartCompleteV2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DCStartCompleteV2);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDCEndCompleteV2(){ return tracepoint_enabled(DotNETRuntime, DCEndCompleteV2); }

extern "C" ULONG  FireEtXplatDCEndCompleteV2(
)
{
    if (!EventXplatEnabledDCEndCompleteV2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DCEndCompleteV2);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartV2(){ return tracepoint_enabled(DotNETRuntime, MethodDCStartV2); }

extern "C" ULONG  FireEtXplatMethodDCStartV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodDCStartV2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodDCStartV2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndV2(){ return tracepoint_enabled(DotNETRuntime, MethodDCEndV2); }

extern "C" ULONG  FireEtXplatMethodDCEndV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodDCEndV2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodDCEndV2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCStartVerboseV2(){ return tracepoint_enabled(DotNETRuntime, MethodDCStartVerboseV2); }

extern "C" ULONG  FireEtXplatMethodDCStartVerboseV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodDCStartVerboseV2())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodDCStartVerboseV2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodDCEndVerboseV2(){ return tracepoint_enabled(DotNETRuntime, MethodDCEndVerboseV2); }

extern "C" ULONG  FireEtXplatMethodDCEndVerboseV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodDCEndVerboseV2())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodDCEndVerboseV2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoad(){ return tracepoint_enabled(DotNETRuntime, MethodLoad); }

extern "C" ULONG  FireEtXplatMethodLoad(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodLoad())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodLoad,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoad_V1(){ return tracepoint_enabled(DotNETRuntime, MethodLoad_V1); }

extern "C" ULONG  FireEtXplatMethodLoad_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodLoad_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodLoad_V1,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoad_V2(){ return tracepoint_enabled(DotNETRuntime, MethodLoad_V2); }

extern "C" ULONG  FireEtXplatMethodLoad_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodLoad_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodLoad_V2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID,
        ReJITID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledR2RGetEntryPoint(){ return tracepoint_enabled(DotNETRuntime, R2RGetEntryPoint); }

extern "C" ULONG  FireEtXplatR2RGetEntryPoint(
    const unsigned __int64 MethodID,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned __int64 EntryPoint,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledR2RGetEntryPoint())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        R2RGetEntryPoint,
        MethodID,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name,
        EntryPoint,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledR2RGetEntryPointStart(){ return tracepoint_enabled(DotNETRuntime, R2RGetEntryPointStart); }

extern "C" ULONG  FireEtXplatR2RGetEntryPointStart(
    const unsigned __int64 MethodID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledR2RGetEntryPointStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        R2RGetEntryPointStart,
        MethodID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnload(){ return tracepoint_enabled(DotNETRuntime, MethodUnload); }

extern "C" ULONG  FireEtXplatMethodUnload(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags)
{
    if (!EventXplatEnabledMethodUnload())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodUnload,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnload_V1(){ return tracepoint_enabled(DotNETRuntime, MethodUnload_V1); }

extern "C" ULONG  FireEtXplatMethodUnload_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodUnload_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodUnload_V1,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnload_V2(){ return tracepoint_enabled(DotNETRuntime, MethodUnload_V2); }

extern "C" ULONG  FireEtXplatMethodUnload_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodUnload_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodUnload_V2,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        ClrInstanceID,
        ReJITID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoadVerbose(){ return tracepoint_enabled(DotNETRuntime, MethodLoadVerbose); }

extern "C" ULONG  FireEtXplatMethodLoadVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodLoadVerbose())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodLoadVerbose,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoadVerbose_V1(){ return tracepoint_enabled(DotNETRuntime, MethodLoadVerbose_V1); }

extern "C" ULONG  FireEtXplatMethodLoadVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodLoadVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    char stackBuffer[230];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodLoadVerbose_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodLoadVerbose_V2(){ return tracepoint_enabled(DotNETRuntime, MethodLoadVerbose_V2); }

extern "C" ULONG  FireEtXplatMethodLoadVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodLoadVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    char stackBuffer[238];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodLoadVerbose_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnloadVerbose(){ return tracepoint_enabled(DotNETRuntime, MethodUnloadVerbose); }

extern "C" ULONG  FireEtXplatMethodUnloadVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodUnloadVerbose())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodUnloadVerbose,
        MethodID,
        ModuleID,
        MethodStartAddress,
        MethodSize,
        MethodToken,
        MethodFlags,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnloadVerbose_V1(){ return tracepoint_enabled(DotNETRuntime, MethodUnloadVerbose_V1); }

extern "C" ULONG  FireEtXplatMethodUnloadVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodUnloadVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    char stackBuffer[230];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodUnloadVerbose_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodUnloadVerbose_V2(){ return tracepoint_enabled(DotNETRuntime, MethodUnloadVerbose_V2); }

extern "C" ULONG  FireEtXplatMethodUnloadVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID)
{
    if (!EventXplatEnabledMethodUnloadVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    char stackBuffer[238];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodUnloadVerbose_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJittingStarted(){ return tracepoint_enabled(DotNETRuntime, MethodJittingStarted); }

extern "C" ULONG  FireEtXplatMethodJittingStarted(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    const unsigned int MethodILSize,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature)
{
    if (!EventXplatEnabledMethodJittingStarted())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodJittingStarted,
        MethodID,
        ModuleID,
        MethodToken,
        MethodILSize,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJittingStarted_V1(){ return tracepoint_enabled(DotNETRuntime, MethodJittingStarted_V1); }

extern "C" ULONG  FireEtXplatMethodJittingStarted_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    const unsigned int MethodILSize,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJittingStarted_V1())
        return ERROR_SUCCESS;
    INT MethodNamespace_path_size = -1;
    PathCharString MethodNamespace_PS;
    INT MethodNamespace_full_name_path_size = (wcslen(MethodNamespace) + 1)*sizeof(WCHAR);
    CHAR* MethodNamespace_full_name = MethodNamespace_PS.OpenStringBuffer(MethodNamespace_full_name_path_size );
    if (MethodNamespace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodName_path_size = -1;
    PathCharString MethodName_PS;
    INT MethodName_full_name_path_size = (wcslen(MethodName) + 1)*sizeof(WCHAR);
    CHAR* MethodName_full_name = MethodName_PS.OpenStringBuffer(MethodName_full_name_path_size );
    if (MethodName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT MethodSignature_path_size = -1;
    PathCharString MethodSignature_PS;
    INT MethodSignature_full_name_path_size = (wcslen(MethodSignature) + 1)*sizeof(WCHAR);
    CHAR* MethodSignature_full_name = MethodSignature_PS.OpenStringBuffer(MethodSignature_full_name_path_size );
    if (MethodSignature_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    MethodNamespace_path_size = WideCharToMultiByte( CP_ACP, 0, MethodNamespace, -1, MethodNamespace_full_name, MethodNamespace_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodNamespace_path_size < MethodNamespace_full_name_path_size );
    MethodNamespace_PS.CloseBuffer(MethodNamespace_path_size );
    if( MethodNamespace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodName_path_size = WideCharToMultiByte( CP_ACP, 0, MethodName, -1, MethodName_full_name, MethodName_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodName_path_size < MethodName_full_name_path_size );
    MethodName_PS.CloseBuffer(MethodName_path_size );
    if( MethodName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    MethodSignature_path_size = WideCharToMultiByte( CP_ACP, 0, MethodSignature, -1, MethodSignature_full_name, MethodSignature_full_name_path_size, NULL, NULL );
    _ASSERTE(MethodSignature_path_size < MethodSignature_full_name_path_size );
    MethodSignature_PS.CloseBuffer(MethodSignature_path_size );
    if( MethodSignature_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        MethodJittingStarted_V1,
        MethodID,
        ModuleID,
        MethodToken,
        MethodILSize,
        MethodNamespace_full_name,
        MethodName_full_name,
        MethodSignature_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitMemoryAllocatedForCode(){ return tracepoint_enabled(DotNETRuntime, MethodJitMemoryAllocatedForCode); }

extern "C" ULONG  FireEtXplatMethodJitMemoryAllocatedForCode(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 JitHotCodeRequestSize,
    const unsigned __int64 JitRODataRequestSize,
    const unsigned __int64 AllocatedSizeForJitCode,
    const unsigned int JitAllocFlag,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitMemoryAllocatedForCode())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        MethodJitMemoryAllocatedForCode,
        MethodID,
        ModuleID,
        JitHotCodeRequestSize,
        JitRODataRequestSize,
        AllocatedSizeForJitCode,
        JitAllocFlag,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitInliningSucceeded(){ return tracepoint_enabled(DotNETRuntime, MethodJitInliningSucceeded); }

extern "C" ULONG  FireEtXplatMethodJitInliningSucceeded(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitInliningSucceeded())
        return ERROR_SUCCESS;

    size_t size = 578;
    char stackBuffer[578];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitInliningSucceeded, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitInliningFailedAnsi(){ return tracepoint_enabled(DotNETRuntime, MethodJitInliningFailedAnsi); }

extern "C" ULONG  FireEtXplatMethodJitInliningFailedAnsi(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const BOOL FailAlways,
    LPCSTR FailReason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitInliningFailedAnsi())
        return ERROR_SUCCESS;

    size_t size = 614;
    char stackBuffer[614];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailAlways, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitInliningFailedAnsi, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitTailCallSucceeded(){ return tracepoint_enabled(DotNETRuntime, MethodJitTailCallSucceeded); }

extern "C" ULONG  FireEtXplatMethodJitTailCallSucceeded(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    const unsigned int TailCallType,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitTailCallSucceeded())
        return ERROR_SUCCESS;

    size_t size = 586;
    char stackBuffer[586];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailCallType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitTailCallSucceeded, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitTailCallFailedAnsi(){ return tracepoint_enabled(DotNETRuntime, MethodJitTailCallFailedAnsi); }

extern "C" ULONG  FireEtXplatMethodJitTailCallFailedAnsi(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    LPCSTR FailReason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitTailCallFailedAnsi())
        return ERROR_SUCCESS;

    size_t size = 614;
    char stackBuffer[614];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitTailCallFailedAnsi, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodILToNativeMap(){ return tracepoint_enabled(DotNETRuntime, MethodILToNativeMap); }

extern "C" ULONG  FireEtXplatMethodILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    char stackBuffer[32];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodILToNativeMap, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodILToNativeMap_V1(){ return tracepoint_enabled(DotNETRuntime, MethodILToNativeMap_V1); }

extern "C" ULONG  FireEtXplatMethodILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID)
{
    if (!EventXplatEnabledMethodILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    char stackBuffer[37];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodILToNativeMap_V1, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitTailCallFailed(){ return tracepoint_enabled(DotNETRuntime, MethodJitTailCallFailed); }

extern "C" ULONG  FireEtXplatMethodJitTailCallFailed(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    PCWSTR FailReason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitTailCallFailed())
        return ERROR_SUCCESS;

    size_t size = 646;
    char stackBuffer[646];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitTailCallFailed, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodJitInliningFailed(){ return tracepoint_enabled(DotNETRuntime, MethodJitInliningFailed); }

extern "C" ULONG  FireEtXplatMethodJitInliningFailed(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const BOOL FailAlways,
    PCWSTR FailReason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodJitInliningFailed())
        return ERROR_SUCCESS;

    size_t size = 646;
    char stackBuffer[646];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailAlways, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, MethodJitInliningFailed, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCStartV2(){ return tracepoint_enabled(DotNETRuntime, ModuleDCStartV2); }

extern "C" ULONG  FireEtXplatModuleDCStartV2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleDCStartV2())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleDCStartV2,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleDCEndV2(){ return tracepoint_enabled(DotNETRuntime, ModuleDCEndV2); }

extern "C" ULONG  FireEtXplatModuleDCEndV2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleDCEndV2())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleDCEndV2,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleLoad(){ return tracepoint_enabled(DotNETRuntime, DomainModuleLoad); }

extern "C" ULONG  FireEtXplatDomainModuleLoad(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledDomainModuleLoad())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        DomainModuleLoad,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDomainModuleLoad_V1(){ return tracepoint_enabled(DotNETRuntime, DomainModuleLoad_V1); }

extern "C" ULONG  FireEtXplatDomainModuleLoad_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDomainModuleLoad_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        DomainModuleLoad_V1,
        ModuleID,
        AssemblyID,
        AppDomainID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleLoad(){ return tracepoint_enabled(DotNETRuntime, ModuleLoad); }

extern "C" ULONG  FireEtXplatModuleLoad(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleLoad())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleLoad,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleLoad_V1(){ return tracepoint_enabled(DotNETRuntime, ModuleLoad_V1); }

extern "C" ULONG  FireEtXplatModuleLoad_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleLoad_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleLoad_V1,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleLoad_V2(){ return tracepoint_enabled(DotNETRuntime, ModuleLoad_V2); }

extern "C" ULONG  FireEtXplatModuleLoad_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath)
{
    if (!EventXplatEnabledModuleLoad_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    char stackBuffer[290];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, ModuleLoad_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleUnload(){ return tracepoint_enabled(DotNETRuntime, ModuleUnload); }

extern "C" ULONG  FireEtXplatModuleUnload(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath)
{
    if (!EventXplatEnabledModuleUnload())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleUnload,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleUnload_V1(){ return tracepoint_enabled(DotNETRuntime, ModuleUnload_V1); }

extern "C" ULONG  FireEtXplatModuleUnload_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleUnload_V1())
        return ERROR_SUCCESS;
    INT ModuleILPath_path_size = -1;
    PathCharString ModuleILPath_PS;
    INT ModuleILPath_full_name_path_size = (wcslen(ModuleILPath) + 1)*sizeof(WCHAR);
    CHAR* ModuleILPath_full_name = ModuleILPath_PS.OpenStringBuffer(ModuleILPath_full_name_path_size );
    if (ModuleILPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ModuleNativePath_path_size = -1;
    PathCharString ModuleNativePath_PS;
    INT ModuleNativePath_full_name_path_size = (wcslen(ModuleNativePath) + 1)*sizeof(WCHAR);
    CHAR* ModuleNativePath_full_name = ModuleNativePath_PS.OpenStringBuffer(ModuleNativePath_full_name_path_size );
    if (ModuleNativePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModuleILPath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleILPath, -1, ModuleILPath_full_name, ModuleILPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleILPath_path_size < ModuleILPath_full_name_path_size );
    ModuleILPath_PS.CloseBuffer(ModuleILPath_path_size );
    if( ModuleILPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ModuleNativePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModuleNativePath, -1, ModuleNativePath_full_name, ModuleNativePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModuleNativePath_path_size < ModuleNativePath_full_name_path_size );
    ModuleNativePath_PS.CloseBuffer(ModuleNativePath_path_size );
    if( ModuleNativePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ModuleUnload_V1,
        ModuleID,
        AssemblyID,
        ModuleFlags,
        Reserved1,
        ModuleILPath_full_name,
        ModuleNativePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleUnload_V2(){ return tracepoint_enabled(DotNETRuntime, ModuleUnload_V2); }

extern "C" ULONG  FireEtXplatModuleUnload_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath)
{
    if (!EventXplatEnabledModuleUnload_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    char stackBuffer[290];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, ModuleUnload_V2, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoad(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoad); }

extern "C" ULONG  FireEtXplatAssemblyLoad(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledAssemblyLoad())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyLoad,
        AssemblyID,
        AppDomainID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoad_V1(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoad_V1); }

extern "C" ULONG  FireEtXplatAssemblyLoad_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAssemblyLoad_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyLoad_V1,
        AssemblyID,
        AppDomainID,
        BindingID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyUnload(){ return tracepoint_enabled(DotNETRuntime, AssemblyUnload); }

extern "C" ULONG  FireEtXplatAssemblyUnload(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledAssemblyUnload())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyUnload,
        AssemblyID,
        AppDomainID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyUnload_V1(){ return tracepoint_enabled(DotNETRuntime, AssemblyUnload_V1); }

extern "C" ULONG  FireEtXplatAssemblyUnload_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAssemblyUnload_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyUnload_V1,
        AssemblyID,
        AppDomainID,
        BindingID,
        AssemblyFlags,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainLoad(){ return tracepoint_enabled(DotNETRuntime, AppDomainLoad); }

extern "C" ULONG  FireEtXplatAppDomainLoad(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName)
{
    if (!EventXplatEnabledAppDomainLoad())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AppDomainLoad,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainLoad_V1(){ return tracepoint_enabled(DotNETRuntime, AppDomainLoad_V1); }

extern "C" ULONG  FireEtXplatAppDomainLoad_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainLoad_V1())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AppDomainLoad_V1,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name,
        AppDomainIndex,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainUnload(){ return tracepoint_enabled(DotNETRuntime, AppDomainUnload); }

extern "C" ULONG  FireEtXplatAppDomainUnload(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName)
{
    if (!EventXplatEnabledAppDomainUnload())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AppDomainUnload,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainUnload_V1(){ return tracepoint_enabled(DotNETRuntime, AppDomainUnload_V1); }

extern "C" ULONG  FireEtXplatAppDomainUnload_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAppDomainUnload_V1())
        return ERROR_SUCCESS;
    INT AppDomainName_path_size = -1;
    PathCharString AppDomainName_PS;
    INT AppDomainName_full_name_path_size = (wcslen(AppDomainName) + 1)*sizeof(WCHAR);
    CHAR* AppDomainName_full_name = AppDomainName_PS.OpenStringBuffer(AppDomainName_full_name_path_size );
    if (AppDomainName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AppDomainName_path_size = WideCharToMultiByte( CP_ACP, 0, AppDomainName, -1, AppDomainName_full_name, AppDomainName_full_name_path_size, NULL, NULL );
    _ASSERTE(AppDomainName_path_size < AppDomainName_full_name_path_size );
    AppDomainName_PS.CloseBuffer(AppDomainName_path_size );
    if( AppDomainName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AppDomainUnload_V1,
        AppDomainID,
        AppDomainFlags,
        AppDomainName_full_name,
        AppDomainIndex,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleRangeLoad(){ return tracepoint_enabled(DotNETRuntime, ModuleRangeLoad); }

extern "C" ULONG  FireEtXplatModuleRangeLoad(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType)
{
    if (!EventXplatEnabledModuleRangeLoad())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        ModuleRangeLoad,
        ClrInstanceID,
        ModuleID,
        RangeBegin,
        RangeSize,
        RangeType);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledStrongNameVerificationStart(){ return tracepoint_enabled(DotNETRuntime, StrongNameVerificationStart); }

extern "C" ULONG  FireEtXplatStrongNameVerificationStart(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledStrongNameVerificationStart())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        StrongNameVerificationStart,
        VerificationFlags,
        ErrorCode,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledStrongNameVerificationStart_V1(){ return tracepoint_enabled(DotNETRuntime, StrongNameVerificationStart_V1); }

extern "C" ULONG  FireEtXplatStrongNameVerificationStart_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledStrongNameVerificationStart_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        StrongNameVerificationStart_V1,
        VerificationFlags,
        ErrorCode,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledStrongNameVerificationStop(){ return tracepoint_enabled(DotNETRuntime, StrongNameVerificationStop); }

extern "C" ULONG  FireEtXplatStrongNameVerificationStop(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName)
{
    if (!EventXplatEnabledStrongNameVerificationStop())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        StrongNameVerificationStop,
        VerificationFlags,
        ErrorCode,
        FullyQualifiedAssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledStrongNameVerificationStop_V1(){ return tracepoint_enabled(DotNETRuntime, StrongNameVerificationStop_V1); }

extern "C" ULONG  FireEtXplatStrongNameVerificationStop_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledStrongNameVerificationStop_V1())
        return ERROR_SUCCESS;
    INT FullyQualifiedAssemblyName_path_size = -1;
    PathCharString FullyQualifiedAssemblyName_PS;
    INT FullyQualifiedAssemblyName_full_name_path_size = (wcslen(FullyQualifiedAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* FullyQualifiedAssemblyName_full_name = FullyQualifiedAssemblyName_PS.OpenStringBuffer(FullyQualifiedAssemblyName_full_name_path_size );
    if (FullyQualifiedAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FullyQualifiedAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, FullyQualifiedAssemblyName, -1, FullyQualifiedAssemblyName_full_name, FullyQualifiedAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(FullyQualifiedAssemblyName_path_size < FullyQualifiedAssemblyName_full_name_path_size );
    FullyQualifiedAssemblyName_PS.CloseBuffer(FullyQualifiedAssemblyName_path_size );
    if( FullyQualifiedAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        StrongNameVerificationStop_V1,
        VerificationFlags,
        ErrorCode,
        FullyQualifiedAssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAuthenticodeVerificationStart(){ return tracepoint_enabled(DotNETRuntime, AuthenticodeVerificationStart); }

extern "C" ULONG  FireEtXplatAuthenticodeVerificationStart(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath)
{
    if (!EventXplatEnabledAuthenticodeVerificationStart())
        return ERROR_SUCCESS;
    INT ModulePath_path_size = -1;
    PathCharString ModulePath_PS;
    INT ModulePath_full_name_path_size = (wcslen(ModulePath) + 1)*sizeof(WCHAR);
    CHAR* ModulePath_full_name = ModulePath_PS.OpenStringBuffer(ModulePath_full_name_path_size );
    if (ModulePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModulePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModulePath, -1, ModulePath_full_name, ModulePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModulePath_path_size < ModulePath_full_name_path_size );
    ModulePath_PS.CloseBuffer(ModulePath_path_size );
    if( ModulePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AuthenticodeVerificationStart,
        VerificationFlags,
        ErrorCode,
        ModulePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAuthenticodeVerificationStart_V1(){ return tracepoint_enabled(DotNETRuntime, AuthenticodeVerificationStart_V1); }

extern "C" ULONG  FireEtXplatAuthenticodeVerificationStart_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAuthenticodeVerificationStart_V1())
        return ERROR_SUCCESS;
    INT ModulePath_path_size = -1;
    PathCharString ModulePath_PS;
    INT ModulePath_full_name_path_size = (wcslen(ModulePath) + 1)*sizeof(WCHAR);
    CHAR* ModulePath_full_name = ModulePath_PS.OpenStringBuffer(ModulePath_full_name_path_size );
    if (ModulePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModulePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModulePath, -1, ModulePath_full_name, ModulePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModulePath_path_size < ModulePath_full_name_path_size );
    ModulePath_PS.CloseBuffer(ModulePath_path_size );
    if( ModulePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AuthenticodeVerificationStart_V1,
        VerificationFlags,
        ErrorCode,
        ModulePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAuthenticodeVerificationStop(){ return tracepoint_enabled(DotNETRuntime, AuthenticodeVerificationStop); }

extern "C" ULONG  FireEtXplatAuthenticodeVerificationStop(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath)
{
    if (!EventXplatEnabledAuthenticodeVerificationStop())
        return ERROR_SUCCESS;
    INT ModulePath_path_size = -1;
    PathCharString ModulePath_PS;
    INT ModulePath_full_name_path_size = (wcslen(ModulePath) + 1)*sizeof(WCHAR);
    CHAR* ModulePath_full_name = ModulePath_PS.OpenStringBuffer(ModulePath_full_name_path_size );
    if (ModulePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModulePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModulePath, -1, ModulePath_full_name, ModulePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModulePath_path_size < ModulePath_full_name_path_size );
    ModulePath_PS.CloseBuffer(ModulePath_path_size );
    if( ModulePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AuthenticodeVerificationStop,
        VerificationFlags,
        ErrorCode,
        ModulePath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAuthenticodeVerificationStop_V1(){ return tracepoint_enabled(DotNETRuntime, AuthenticodeVerificationStop_V1); }

extern "C" ULONG  FireEtXplatAuthenticodeVerificationStop_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAuthenticodeVerificationStop_V1())
        return ERROR_SUCCESS;
    INT ModulePath_path_size = -1;
    PathCharString ModulePath_PS;
    INT ModulePath_full_name_path_size = (wcslen(ModulePath) + 1)*sizeof(WCHAR);
    CHAR* ModulePath_full_name = ModulePath_PS.OpenStringBuffer(ModulePath_full_name_path_size );
    if (ModulePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ModulePath_path_size = WideCharToMultiByte( CP_ACP, 0, ModulePath, -1, ModulePath_full_name, ModulePath_full_name_path_size, NULL, NULL );
    _ASSERTE(ModulePath_path_size < ModulePath_full_name_path_size );
    ModulePath_PS.CloseBuffer(ModulePath_path_size );
    if( ModulePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AuthenticodeVerificationStop_V1,
        VerificationFlags,
        ErrorCode,
        ModulePath_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledRuntimeInformationStart(){ return tracepoint_enabled(DotNETRuntime, RuntimeInformationStart); }

extern "C" ULONG  FireEtXplatRuntimeInformationStart(
    const unsigned short ClrInstanceID,
    const unsigned short Sku,
    const unsigned short BclMajorVersion,
    const unsigned short BclMinorVersion,
    const unsigned short BclBuildNumber,
    const unsigned short BclQfeNumber,
    const unsigned short VMMajorVersion,
    const unsigned short VMMinorVersion,
    const unsigned short VMBuildNumber,
    const unsigned short VMQfeNumber,
    const unsigned int StartupFlags,
    const unsigned char StartupMode,
    PCWSTR CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR RuntimeDllPath)
{
    if (!EventXplatEnabledRuntimeInformationStart())
        return ERROR_SUCCESS;

    size_t size = 153;
    char stackBuffer[153];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Sku, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CommandLine, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ComObjectGuid, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RuntimeDllPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, RuntimeInformationStart, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIncreaseMemoryPressure(){ return tracepoint_enabled(DotNETRuntime, IncreaseMemoryPressure); }

extern "C" ULONG  FireEtXplatIncreaseMemoryPressure(
    const unsigned __int64 BytesAllocated,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIncreaseMemoryPressure())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        IncreaseMemoryPressure,
        BytesAllocated,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDecreaseMemoryPressure(){ return tracepoint_enabled(DotNETRuntime, DecreaseMemoryPressure); }

extern "C" ULONG  FireEtXplatDecreaseMemoryPressure(
    const unsigned __int64 BytesFreed,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledDecreaseMemoryPressure())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        DecreaseMemoryPressure,
        BytesFreed,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCMarkWithType(){ return tracepoint_enabled(DotNETRuntime, GCMarkWithType); }

extern "C" ULONG  FireEtXplatGCMarkWithType(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    const unsigned int Type,
    const unsigned __int64 Bytes)
{
    if (!EventXplatEnabledGCMarkWithType())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCMarkWithType,
        HeapNum,
        ClrInstanceID,
        Type,
        Bytes);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCJoin_V2(){ return tracepoint_enabled(DotNETRuntime, GCJoin_V2); }

extern "C" ULONG  FireEtXplatGCJoin_V2(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType,
    const unsigned short ClrInstanceID,
    const unsigned int JoinID)
{
    if (!EventXplatEnabledGCJoin_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCJoin_V2,
        Heap,
        JoinTime,
        JoinType,
        ClrInstanceID,
        JoinID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCPerHeapHistory_V3(){ return tracepoint_enabled(DotNETRuntime, GCPerHeapHistory_V3); }

extern "C" ULONG  FireEtXplatGCPerHeapHistory_V3(
    const unsigned short ClrInstanceID,
    const void* FreeListAllocated,
    const void* FreeListRejected,
    const void* EndOfSegAllocated,
    const void* CondemnedAllocated,
    const void* PinnedAllocated,
    const void* PinnedAllocatedAdvance,
    const unsigned int RunningFreeListEfficiency,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1,
    const unsigned int CompactMechanisms,
    const unsigned int ExpandMechanisms,
    const unsigned int HeapIndex,
    const void* ExtraGen0Commit,
    const unsigned int Count,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCPerHeapHistory_V3())
        return ERROR_SUCCESS;

    size_t size = 118;
    char stackBuffer[118];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FreeListAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FreeListRejected, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EndOfSegAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedAllocatedAdvance, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RunningFreeListEfficiency, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CompactMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExpandMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HeapIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExtraGen0Commit, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCPerHeapHistory_V3, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGlobalHeapHistory_V2(){ return tracepoint_enabled(DotNETRuntime, GCGlobalHeapHistory_V2); }

extern "C" ULONG  FireEtXplatGCGlobalHeapHistory_V2(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure)
{
    if (!EventXplatEnabledGCGlobalHeapHistory_V2())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GCGlobalHeapHistory_V2,
        FinalYoungestDesired,
        NumHeaps,
        CondemnedGeneration,
        Gen0ReductionCount,
        Reason,
        GlobalMechanisms,
        ClrInstanceID,
        PauseMode,
        MemoryPressure);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGlobalHeapHistory_V3(){ return tracepoint_enabled(DotNETRuntime, GCGlobalHeapHistory_V3); }

extern "C" ULONG  FireEtXplatGCGlobalHeapHistory_V3(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1)
{
    if (!EventXplatEnabledGCGlobalHeapHistory_V3())
        return ERROR_SUCCESS;

    size_t size = 46;
    char stackBuffer[46];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PauseMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryPressure, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCGlobalHeapHistory_V3, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGlobalHeapHistory_V4(){ return tracepoint_enabled(DotNETRuntime, GCGlobalHeapHistory_V4); }

extern "C" ULONG  FireEtXplatGCGlobalHeapHistory_V4(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1,
    const unsigned int Count,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCGlobalHeapHistory_V4())
        return ERROR_SUCCESS;

    size_t size = 82;
    char stackBuffer[82];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PauseMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryPressure, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCGlobalHeapHistory_V4, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGenAwareBegin(){ return tracepoint_enabled(DotNETRuntime, GenAwareBegin); }

extern "C" ULONG  FireEtXplatGenAwareBegin(
    const unsigned int Count,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGenAwareBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GenAwareBegin,
        Count,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGenAwareEnd(){ return tracepoint_enabled(DotNETRuntime, GenAwareEnd); }

extern "C" ULONG  FireEtXplatGenAwareEnd(
    const unsigned int Count,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGenAwareEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        GenAwareEnd,
        Count,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCLOHCompact(){ return tracepoint_enabled(DotNETRuntime, GCLOHCompact); }

extern "C" ULONG  FireEtXplatGCLOHCompact(
    const unsigned short ClrInstanceID,
    const unsigned short Count,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCLOHCompact())
        return ERROR_SUCCESS;

    size_t size = 36;
    char stackBuffer[36];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCLOHCompact, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFitBucketInfo(){ return tracepoint_enabled(DotNETRuntime, GCFitBucketInfo); }

extern "C" ULONG  FireEtXplatGCFitBucketInfo(
    const unsigned short ClrInstanceID,
    const unsigned short BucketKind,
    const unsigned __int64 TotalSize,
    const unsigned short Count,
    int Values_ElementSize,
    const void* Values)
{
    if (!EventXplatEnabledGCFitBucketInfo())
        return ERROR_SUCCESS;

    size_t size = 46;
    char stackBuffer[46];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BucketKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, GCFitBucketInfo, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDebugIPCEventStart(){ return tracepoint_enabled(DotNETRuntime, DebugIPCEventStart); }

extern "C" ULONG  FireEtXplatDebugIPCEventStart(
)
{
    if (!EventXplatEnabledDebugIPCEventStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DebugIPCEventStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDebugIPCEventEnd(){ return tracepoint_enabled(DotNETRuntime, DebugIPCEventEnd); }

extern "C" ULONG  FireEtXplatDebugIPCEventEnd(
)
{
    if (!EventXplatEnabledDebugIPCEventEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DebugIPCEventEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDebugExceptionProcessingStart(){ return tracepoint_enabled(DotNETRuntime, DebugExceptionProcessingStart); }

extern "C" ULONG  FireEtXplatDebugExceptionProcessingStart(
)
{
    if (!EventXplatEnabledDebugExceptionProcessingStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DebugExceptionProcessingStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledDebugExceptionProcessingEnd(){ return tracepoint_enabled(DotNETRuntime, DebugExceptionProcessingEnd); }

extern "C" ULONG  FireEtXplatDebugExceptionProcessingEnd(
)
{
    if (!EventXplatEnabledDebugExceptionProcessingEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime, DebugExceptionProcessingEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCodeSymbols(){ return tracepoint_enabled(DotNETRuntime, CodeSymbols); }

extern "C" ULONG  FireEtXplatCodeSymbols(
    const unsigned __int64 ModuleId,
    const unsigned short TotalChunks,
    const unsigned short ChunkNumber,
    const unsigned int ChunkLength,
    const BYTE* Chunk,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCodeSymbols())
        return ERROR_SUCCESS;

    size_t size = 32;
    char stackBuffer[32];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ModuleId, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalChunks, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ChunkNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ChunkLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Chunk, sizeof(const BYTE) * (int)ChunkLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, CodeSymbols, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEventSource(){ return tracepoint_enabled(DotNETRuntime, EventSource); }

extern "C" ULONG  FireEtXplatEventSource(
    const signed int EventID,
    PCWSTR EventName,
    PCWSTR EventSourceName,
    PCWSTR Payload)
{
    if (!EventXplatEnabledEventSource())
        return ERROR_SUCCESS;
    INT EventName_path_size = -1;
    PathCharString EventName_PS;
    INT EventName_full_name_path_size = (wcslen(EventName) + 1)*sizeof(WCHAR);
    CHAR* EventName_full_name = EventName_PS.OpenStringBuffer(EventName_full_name_path_size );
    if (EventName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT EventSourceName_path_size = -1;
    PathCharString EventSourceName_PS;
    INT EventSourceName_full_name_path_size = (wcslen(EventSourceName) + 1)*sizeof(WCHAR);
    CHAR* EventSourceName_full_name = EventSourceName_PS.OpenStringBuffer(EventSourceName_full_name_path_size );
    if (EventSourceName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Payload_path_size = -1;
    PathCharString Payload_PS;
    INT Payload_full_name_path_size = (wcslen(Payload) + 1)*sizeof(WCHAR);
    CHAR* Payload_full_name = Payload_PS.OpenStringBuffer(Payload_full_name_path_size );
    if (Payload_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    EventName_path_size = WideCharToMultiByte( CP_ACP, 0, EventName, -1, EventName_full_name, EventName_full_name_path_size, NULL, NULL );
    _ASSERTE(EventName_path_size < EventName_full_name_path_size );
    EventName_PS.CloseBuffer(EventName_path_size );
    if( EventName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    EventSourceName_path_size = WideCharToMultiByte( CP_ACP, 0, EventSourceName, -1, EventSourceName_full_name, EventSourceName_full_name_path_size, NULL, NULL );
    _ASSERTE(EventSourceName_path_size < EventSourceName_full_name_path_size );
    EventSourceName_PS.CloseBuffer(EventSourceName_path_size );
    if( EventSourceName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Payload_path_size = WideCharToMultiByte( CP_ACP, 0, Payload, -1, Payload_full_name, Payload_full_name_path_size, NULL, NULL );
    _ASSERTE(Payload_path_size < Payload_full_name_path_size );
    Payload_PS.CloseBuffer(Payload_path_size );
    if( Payload_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        EventSource,
        EventID,
        EventName_full_name,
        EventSourceName_full_name,
        Payload_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationSettings(){ return tracepoint_enabled(DotNETRuntime, TieredCompilationSettings); }

extern "C" ULONG  FireEtXplatTieredCompilationSettings(
    const unsigned short ClrInstanceID,
    const unsigned int Flags)
{
    if (!EventXplatEnabledTieredCompilationSettings())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TieredCompilationSettings,
        ClrInstanceID,
        Flags);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationPause(){ return tracepoint_enabled(DotNETRuntime, TieredCompilationPause); }

extern "C" ULONG  FireEtXplatTieredCompilationPause(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTieredCompilationPause())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TieredCompilationPause,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationResume(){ return tracepoint_enabled(DotNETRuntime, TieredCompilationResume); }

extern "C" ULONG  FireEtXplatTieredCompilationResume(
    const unsigned short ClrInstanceID,
    const unsigned int NewMethodCount)
{
    if (!EventXplatEnabledTieredCompilationResume())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TieredCompilationResume,
        ClrInstanceID,
        NewMethodCount);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationBackgroundJitStart(){ return tracepoint_enabled(DotNETRuntime, TieredCompilationBackgroundJitStart); }

extern "C" ULONG  FireEtXplatTieredCompilationBackgroundJitStart(
    const unsigned short ClrInstanceID,
    const unsigned int PendingMethodCount)
{
    if (!EventXplatEnabledTieredCompilationBackgroundJitStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TieredCompilationBackgroundJitStart,
        ClrInstanceID,
        PendingMethodCount);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTieredCompilationBackgroundJitStop(){ return tracepoint_enabled(DotNETRuntime, TieredCompilationBackgroundJitStop); }

extern "C" ULONG  FireEtXplatTieredCompilationBackgroundJitStop(
    const unsigned short ClrInstanceID,
    const unsigned int PendingMethodCount,
    const unsigned int JittedMethodCount)
{
    if (!EventXplatEnabledTieredCompilationBackgroundJitStop())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntime,
        TieredCompilationBackgroundJitStop,
        ClrInstanceID,
        PendingMethodCount,
        JittedMethodCount);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoadStart(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoadStart); }

extern "C" ULONG  FireEtXplatAssemblyLoadStart(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR AssemblyPath,
    PCWSTR RequestingAssembly,
    PCWSTR AssemblyLoadContext,
    PCWSTR RequestingAssemblyLoadContext)
{
    if (!EventXplatEnabledAssemblyLoadStart())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyPath_path_size = -1;
    PathCharString AssemblyPath_PS;
    INT AssemblyPath_full_name_path_size = (wcslen(AssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* AssemblyPath_full_name = AssemblyPath_PS.OpenStringBuffer(AssemblyPath_full_name_path_size );
    if (AssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT RequestingAssembly_path_size = -1;
    PathCharString RequestingAssembly_PS;
    INT RequestingAssembly_full_name_path_size = (wcslen(RequestingAssembly) + 1)*sizeof(WCHAR);
    CHAR* RequestingAssembly_full_name = RequestingAssembly_PS.OpenStringBuffer(RequestingAssembly_full_name_path_size );
    if (RequestingAssembly_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyLoadContext_path_size = -1;
    PathCharString AssemblyLoadContext_PS;
    INT AssemblyLoadContext_full_name_path_size = (wcslen(AssemblyLoadContext) + 1)*sizeof(WCHAR);
    CHAR* AssemblyLoadContext_full_name = AssemblyLoadContext_PS.OpenStringBuffer(AssemblyLoadContext_full_name_path_size );
    if (AssemblyLoadContext_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT RequestingAssemblyLoadContext_path_size = -1;
    PathCharString RequestingAssemblyLoadContext_PS;
    INT RequestingAssemblyLoadContext_full_name_path_size = (wcslen(RequestingAssemblyLoadContext) + 1)*sizeof(WCHAR);
    CHAR* RequestingAssemblyLoadContext_full_name = RequestingAssemblyLoadContext_PS.OpenStringBuffer(RequestingAssemblyLoadContext_full_name_path_size );
    if (RequestingAssemblyLoadContext_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyPath, -1, AssemblyPath_full_name, AssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyPath_path_size < AssemblyPath_full_name_path_size );
    AssemblyPath_PS.CloseBuffer(AssemblyPath_path_size );
    if( AssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    RequestingAssembly_path_size = WideCharToMultiByte( CP_ACP, 0, RequestingAssembly, -1, RequestingAssembly_full_name, RequestingAssembly_full_name_path_size, NULL, NULL );
    _ASSERTE(RequestingAssembly_path_size < RequestingAssembly_full_name_path_size );
    RequestingAssembly_PS.CloseBuffer(RequestingAssembly_path_size );
    if( RequestingAssembly_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyLoadContext_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyLoadContext, -1, AssemblyLoadContext_full_name, AssemblyLoadContext_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyLoadContext_path_size < AssemblyLoadContext_full_name_path_size );
    AssemblyLoadContext_PS.CloseBuffer(AssemblyLoadContext_path_size );
    if( AssemblyLoadContext_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    RequestingAssemblyLoadContext_path_size = WideCharToMultiByte( CP_ACP, 0, RequestingAssemblyLoadContext, -1, RequestingAssemblyLoadContext_full_name, RequestingAssemblyLoadContext_full_name_path_size, NULL, NULL );
    _ASSERTE(RequestingAssemblyLoadContext_path_size < RequestingAssemblyLoadContext_full_name_path_size );
    RequestingAssemblyLoadContext_PS.CloseBuffer(RequestingAssemblyLoadContext_path_size );
    if( RequestingAssemblyLoadContext_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyLoadStart,
        ClrInstanceID,
        AssemblyName_full_name,
        AssemblyPath_full_name,
        RequestingAssembly_full_name,
        AssemblyLoadContext_full_name,
        RequestingAssemblyLoadContext_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoadStop(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoadStop); }

extern "C" ULONG  FireEtXplatAssemblyLoadStop(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR AssemblyPath,
    PCWSTR RequestingAssembly,
    PCWSTR AssemblyLoadContext,
    PCWSTR RequestingAssemblyLoadContext,
    const BOOL Success,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    const BOOL Cached)
{
    if (!EventXplatEnabledAssemblyLoadStop())
        return ERROR_SUCCESS;

    size_t size = 458;
    char stackBuffer[458];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssembly, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Success, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Cached, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, AssemblyLoadStop, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledResolutionAttempted(){ return tracepoint_enabled(DotNETRuntime, ResolutionAttempted); }

extern "C" ULONG  FireEtXplatResolutionAttempted(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    const unsigned short Stage,
    PCWSTR AssemblyLoadContext,
    const unsigned short Result,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    PCWSTR ErrorMessage)
{
    if (!EventXplatEnabledResolutionAttempted())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyLoadContext_path_size = -1;
    PathCharString AssemblyLoadContext_PS;
    INT AssemblyLoadContext_full_name_path_size = (wcslen(AssemblyLoadContext) + 1)*sizeof(WCHAR);
    CHAR* AssemblyLoadContext_full_name = AssemblyLoadContext_PS.OpenStringBuffer(AssemblyLoadContext_full_name_path_size );
    if (AssemblyLoadContext_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyName_path_size = -1;
    PathCharString ResultAssemblyName_PS;
    INT ResultAssemblyName_full_name_path_size = (wcslen(ResultAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyName_full_name = ResultAssemblyName_PS.OpenStringBuffer(ResultAssemblyName_full_name_path_size );
    if (ResultAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyPath_path_size = -1;
    PathCharString ResultAssemblyPath_PS;
    INT ResultAssemblyPath_full_name_path_size = (wcslen(ResultAssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyPath_full_name = ResultAssemblyPath_PS.OpenStringBuffer(ResultAssemblyPath_full_name_path_size );
    if (ResultAssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ErrorMessage_path_size = -1;
    PathCharString ErrorMessage_PS;
    INT ErrorMessage_full_name_path_size = (wcslen(ErrorMessage) + 1)*sizeof(WCHAR);
    CHAR* ErrorMessage_full_name = ErrorMessage_PS.OpenStringBuffer(ErrorMessage_full_name_path_size );
    if (ErrorMessage_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyLoadContext_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyLoadContext, -1, AssemblyLoadContext_full_name, AssemblyLoadContext_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyLoadContext_path_size < AssemblyLoadContext_full_name_path_size );
    AssemblyLoadContext_PS.CloseBuffer(AssemblyLoadContext_path_size );
    if( AssemblyLoadContext_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyName, -1, ResultAssemblyName_full_name, ResultAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyName_path_size < ResultAssemblyName_full_name_path_size );
    ResultAssemblyName_PS.CloseBuffer(ResultAssemblyName_path_size );
    if( ResultAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyPath, -1, ResultAssemblyPath_full_name, ResultAssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyPath_path_size < ResultAssemblyPath_full_name_path_size );
    ResultAssemblyPath_PS.CloseBuffer(ResultAssemblyPath_path_size );
    if( ResultAssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ErrorMessage_path_size = WideCharToMultiByte( CP_ACP, 0, ErrorMessage, -1, ErrorMessage_full_name, ErrorMessage_full_name_path_size, NULL, NULL );
    _ASSERTE(ErrorMessage_path_size < ErrorMessage_full_name_path_size );
    ErrorMessage_PS.CloseBuffer(ErrorMessage_path_size );
    if( ErrorMessage_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ResolutionAttempted,
        ClrInstanceID,
        AssemblyName_full_name,
        Stage,
        AssemblyLoadContext_full_name,
        Result,
        ResultAssemblyName_full_name,
        ResultAssemblyPath_full_name,
        ErrorMessage_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoadContextResolvingHandlerInvoked(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoadContextResolvingHandlerInvoked); }

extern "C" ULONG  FireEtXplatAssemblyLoadContextResolvingHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR HandlerName,
    PCWSTR AssemblyLoadContext,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath)
{
    if (!EventXplatEnabledAssemblyLoadContextResolvingHandlerInvoked())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT HandlerName_path_size = -1;
    PathCharString HandlerName_PS;
    INT HandlerName_full_name_path_size = (wcslen(HandlerName) + 1)*sizeof(WCHAR);
    CHAR* HandlerName_full_name = HandlerName_PS.OpenStringBuffer(HandlerName_full_name_path_size );
    if (HandlerName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyLoadContext_path_size = -1;
    PathCharString AssemblyLoadContext_PS;
    INT AssemblyLoadContext_full_name_path_size = (wcslen(AssemblyLoadContext) + 1)*sizeof(WCHAR);
    CHAR* AssemblyLoadContext_full_name = AssemblyLoadContext_PS.OpenStringBuffer(AssemblyLoadContext_full_name_path_size );
    if (AssemblyLoadContext_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyName_path_size = -1;
    PathCharString ResultAssemblyName_PS;
    INT ResultAssemblyName_full_name_path_size = (wcslen(ResultAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyName_full_name = ResultAssemblyName_PS.OpenStringBuffer(ResultAssemblyName_full_name_path_size );
    if (ResultAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyPath_path_size = -1;
    PathCharString ResultAssemblyPath_PS;
    INT ResultAssemblyPath_full_name_path_size = (wcslen(ResultAssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyPath_full_name = ResultAssemblyPath_PS.OpenStringBuffer(ResultAssemblyPath_full_name_path_size );
    if (ResultAssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    HandlerName_path_size = WideCharToMultiByte( CP_ACP, 0, HandlerName, -1, HandlerName_full_name, HandlerName_full_name_path_size, NULL, NULL );
    _ASSERTE(HandlerName_path_size < HandlerName_full_name_path_size );
    HandlerName_PS.CloseBuffer(HandlerName_path_size );
    if( HandlerName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyLoadContext_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyLoadContext, -1, AssemblyLoadContext_full_name, AssemblyLoadContext_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyLoadContext_path_size < AssemblyLoadContext_full_name_path_size );
    AssemblyLoadContext_PS.CloseBuffer(AssemblyLoadContext_path_size );
    if( AssemblyLoadContext_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyName, -1, ResultAssemblyName_full_name, ResultAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyName_path_size < ResultAssemblyName_full_name_path_size );
    ResultAssemblyName_PS.CloseBuffer(ResultAssemblyName_path_size );
    if( ResultAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyPath, -1, ResultAssemblyPath_full_name, ResultAssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyPath_path_size < ResultAssemblyPath_full_name_path_size );
    ResultAssemblyPath_PS.CloseBuffer(ResultAssemblyPath_path_size );
    if( ResultAssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyLoadContextResolvingHandlerInvoked,
        ClrInstanceID,
        AssemblyName_full_name,
        HandlerName_full_name,
        AssemblyLoadContext_full_name,
        ResultAssemblyName_full_name,
        ResultAssemblyPath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAppDomainAssemblyResolveHandlerInvoked(){ return tracepoint_enabled(DotNETRuntime, AppDomainAssemblyResolveHandlerInvoked); }

extern "C" ULONG  FireEtXplatAppDomainAssemblyResolveHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR HandlerName,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath)
{
    if (!EventXplatEnabledAppDomainAssemblyResolveHandlerInvoked())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT HandlerName_path_size = -1;
    PathCharString HandlerName_PS;
    INT HandlerName_full_name_path_size = (wcslen(HandlerName) + 1)*sizeof(WCHAR);
    CHAR* HandlerName_full_name = HandlerName_PS.OpenStringBuffer(HandlerName_full_name_path_size );
    if (HandlerName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyName_path_size = -1;
    PathCharString ResultAssemblyName_PS;
    INT ResultAssemblyName_full_name_path_size = (wcslen(ResultAssemblyName) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyName_full_name = ResultAssemblyName_PS.OpenStringBuffer(ResultAssemblyName_full_name_path_size );
    if (ResultAssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ResultAssemblyPath_path_size = -1;
    PathCharString ResultAssemblyPath_PS;
    INT ResultAssemblyPath_full_name_path_size = (wcslen(ResultAssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* ResultAssemblyPath_full_name = ResultAssemblyPath_PS.OpenStringBuffer(ResultAssemblyPath_full_name_path_size );
    if (ResultAssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    HandlerName_path_size = WideCharToMultiByte( CP_ACP, 0, HandlerName, -1, HandlerName_full_name, HandlerName_full_name_path_size, NULL, NULL );
    _ASSERTE(HandlerName_path_size < HandlerName_full_name_path_size );
    HandlerName_PS.CloseBuffer(HandlerName_path_size );
    if( HandlerName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyName, -1, ResultAssemblyName_full_name, ResultAssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyName_path_size < ResultAssemblyName_full_name_path_size );
    ResultAssemblyName_PS.CloseBuffer(ResultAssemblyName_path_size );
    if( ResultAssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ResultAssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, ResultAssemblyPath, -1, ResultAssemblyPath_full_name, ResultAssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ResultAssemblyPath_path_size < ResultAssemblyPath_full_name_path_size );
    ResultAssemblyPath_PS.CloseBuffer(ResultAssemblyPath_path_size );
    if( ResultAssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AppDomainAssemblyResolveHandlerInvoked,
        ClrInstanceID,
        AssemblyName_full_name,
        HandlerName_full_name,
        ResultAssemblyName_full_name,
        ResultAssemblyPath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAssemblyLoadFromResolveHandlerInvoked(){ return tracepoint_enabled(DotNETRuntime, AssemblyLoadFromResolveHandlerInvoked); }

extern "C" ULONG  FireEtXplatAssemblyLoadFromResolveHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    const BOOL IsTrackedLoad,
    PCWSTR RequestingAssemblyPath,
    PCWSTR ComputedRequestedAssemblyPath)
{
    if (!EventXplatEnabledAssemblyLoadFromResolveHandlerInvoked())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT RequestingAssemblyPath_path_size = -1;
    PathCharString RequestingAssemblyPath_PS;
    INT RequestingAssemblyPath_full_name_path_size = (wcslen(RequestingAssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* RequestingAssemblyPath_full_name = RequestingAssemblyPath_PS.OpenStringBuffer(RequestingAssemblyPath_full_name_path_size );
    if (RequestingAssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT ComputedRequestedAssemblyPath_path_size = -1;
    PathCharString ComputedRequestedAssemblyPath_PS;
    INT ComputedRequestedAssemblyPath_full_name_path_size = (wcslen(ComputedRequestedAssemblyPath) + 1)*sizeof(WCHAR);
    CHAR* ComputedRequestedAssemblyPath_full_name = ComputedRequestedAssemblyPath_PS.OpenStringBuffer(ComputedRequestedAssemblyPath_full_name_path_size );
    if (ComputedRequestedAssemblyPath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    RequestingAssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, RequestingAssemblyPath, -1, RequestingAssemblyPath_full_name, RequestingAssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(RequestingAssemblyPath_path_size < RequestingAssemblyPath_full_name_path_size );
    RequestingAssemblyPath_PS.CloseBuffer(RequestingAssemblyPath_path_size );
    if( RequestingAssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    ComputedRequestedAssemblyPath_path_size = WideCharToMultiByte( CP_ACP, 0, ComputedRequestedAssemblyPath, -1, ComputedRequestedAssemblyPath_full_name, ComputedRequestedAssemblyPath_full_name_path_size, NULL, NULL );
    _ASSERTE(ComputedRequestedAssemblyPath_path_size < ComputedRequestedAssemblyPath_full_name_path_size );
    ComputedRequestedAssemblyPath_PS.CloseBuffer(ComputedRequestedAssemblyPath_path_size );
    if( ComputedRequestedAssemblyPath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        AssemblyLoadFromResolveHandlerInvoked,
        ClrInstanceID,
        AssemblyName_full_name,
        IsTrackedLoad,
        RequestingAssemblyPath_full_name,
        ComputedRequestedAssemblyPath_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledKnownPathProbed(){ return tracepoint_enabled(DotNETRuntime, KnownPathProbed); }

extern "C" ULONG  FireEtXplatKnownPathProbed(
    const unsigned short ClrInstanceID,
    PCWSTR FilePath,
    const unsigned short Source,
    const signed int Result)
{
    if (!EventXplatEnabledKnownPathProbed())
        return ERROR_SUCCESS;
    INT FilePath_path_size = -1;
    PathCharString FilePath_PS;
    INT FilePath_full_name_path_size = (wcslen(FilePath) + 1)*sizeof(WCHAR);
    CHAR* FilePath_full_name = FilePath_PS.OpenStringBuffer(FilePath_full_name_path_size );
    if (FilePath_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FilePath_path_size = WideCharToMultiByte( CP_ACP, 0, FilePath, -1, FilePath_full_name, FilePath_full_name_path_size, NULL, NULL );
    _ASSERTE(FilePath_path_size < FilePath_full_name_path_size );
    FilePath_PS.CloseBuffer(FilePath_path_size );
    if( FilePath_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        KnownPathProbed,
        ClrInstanceID,
        FilePath_full_name,
        Source,
        Result);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledJitInstrumentationData(){ return tracepoint_enabled(DotNETRuntime, JitInstrumentationData); }

extern "C" ULONG  FireEtXplatJitInstrumentationData(
    const unsigned short ClrInstanceID,
    const unsigned int MethodFlags,
    const unsigned int DataSize,
    const unsigned __int64 MethodID,
    const BYTE* Data)
{
    if (!EventXplatEnabledJitInstrumentationData())
        return ERROR_SUCCESS;

    size_t size = 32;
    char stackBuffer[32];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, JitInstrumentationData, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledJitInstrumentationDataVerbose(){ return tracepoint_enabled(DotNETRuntime, JitInstrumentationDataVerbose); }

extern "C" ULONG  FireEtXplatJitInstrumentationDataVerbose(
    const unsigned short ClrInstanceID,
    const unsigned int MethodFlags,
    const unsigned int DataSize,
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const BYTE* Data)
{
    if (!EventXplatEnabledJitInstrumentationDataVerbose())
        return ERROR_SUCCESS;

    size_t size = 223;
    char stackBuffer[223];
    char *buffer = stackBuffer;
    size_t offset = 0;

    bool fixedBuffer = true;
    bool success = true;
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    do_tracepoint(DotNETRuntime, JitInstrumentationDataVerbose, offset, buffer);

    if (!fixedBuffer)
        delete[] buffer;

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledProfilerMessage(){ return tracepoint_enabled(DotNETRuntime, ProfilerMessage); }

extern "C" ULONG  FireEtXplatProfilerMessage(
    const unsigned short ClrInstanceID,
    PCWSTR Message)
{
    if (!EventXplatEnabledProfilerMessage())
        return ERROR_SUCCESS;
    INT Message_path_size = -1;
    PathCharString Message_PS;
    INT Message_full_name_path_size = (wcslen(Message) + 1)*sizeof(WCHAR);
    CHAR* Message_full_name = Message_PS.OpenStringBuffer(Message_full_name_path_size );
    if (Message_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Message_path_size = WideCharToMultiByte( CP_ACP, 0, Message, -1, Message_full_name, Message_full_name_path_size, NULL, NULL );
    _ASSERTE(Message_path_size < Message_full_name_path_size );
    Message_PS.CloseBuffer(Message_path_size );
    if( Message_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ProfilerMessage,
        ClrInstanceID,
        Message_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecutionCheckpoint(){ return tracepoint_enabled(DotNETRuntime, ExecutionCheckpoint); }

extern "C" ULONG  FireEtXplatExecutionCheckpoint(
    const unsigned short ClrInstanceID,
    PCWSTR Name,
    const __int64 Timestamp)
{
    if (!EventXplatEnabledExecutionCheckpoint())
        return ERROR_SUCCESS;
    INT Name_path_size = -1;
    PathCharString Name_PS;
    INT Name_full_name_path_size = (wcslen(Name) + 1)*sizeof(WCHAR);
    CHAR* Name_full_name = Name_PS.OpenStringBuffer(Name_full_name_path_size );
    if (Name_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Name_path_size = WideCharToMultiByte( CP_ACP, 0, Name, -1, Name_full_name, Name_full_name_path_size, NULL, NULL );
    _ASSERTE(Name_path_size < Name_full_name_path_size );
    Name_PS.CloseBuffer(Name_path_size );
    if( Name_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntime,
        ExecutionCheckpoint,
        ClrInstanceID,
        Name_full_name,
        Timestamp);

    return ERROR_SUCCESS;
}


