// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genEventPipe.py

******************************************************************/

#include <common.h>
#include "eventpipeadapter.h"

#if defined(TARGET_UNIX)
#define wcslen PAL_wcslen
#endif

bool ResizeBuffer(BYTE *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

const WCHAR* DotNETRuntimeName = W("Microsoft-Windows-DotNETRuntime");
EventPipeProvider *EventPipeProviderDotNETRuntime = nullptr;
EventPipeEvent *EventPipeEventGCStart = nullptr;
EventPipeEvent *EventPipeEventGCStart_V1 = nullptr;
EventPipeEvent *EventPipeEventGCStart_V2 = nullptr;
EventPipeEvent *EventPipeEventGCEnd = nullptr;
EventPipeEvent *EventPipeEventGCEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventGCRestartEEEnd = nullptr;
EventPipeEvent *EventPipeEventGCRestartEEEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventGCHeapStats = nullptr;
EventPipeEvent *EventPipeEventGCHeapStats_V1 = nullptr;
EventPipeEvent *EventPipeEventGCHeapStats_V2 = nullptr;
EventPipeEvent *EventPipeEventGCCreateSegment = nullptr;
EventPipeEvent *EventPipeEventGCCreateSegment_V1 = nullptr;
EventPipeEvent *EventPipeEventGCFreeSegment = nullptr;
EventPipeEvent *EventPipeEventGCFreeSegment_V1 = nullptr;
EventPipeEvent *EventPipeEventGCRestartEEBegin = nullptr;
EventPipeEvent *EventPipeEventGCRestartEEBegin_V1 = nullptr;
EventPipeEvent *EventPipeEventGCSuspendEEEnd = nullptr;
EventPipeEvent *EventPipeEventGCSuspendEEEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventGCSuspendEEBegin = nullptr;
EventPipeEvent *EventPipeEventGCSuspendEEBegin_V1 = nullptr;
EventPipeEvent *EventPipeEventGCAllocationTick = nullptr;
EventPipeEvent *EventPipeEventGCAllocationTick_V1 = nullptr;
EventPipeEvent *EventPipeEventGCAllocationTick_V2 = nullptr;
EventPipeEvent *EventPipeEventGCAllocationTick_V3 = nullptr;
EventPipeEvent *EventPipeEventGCAllocationTick_V4 = nullptr;
EventPipeEvent *EventPipeEventGCCreateConcurrentThread = nullptr;
EventPipeEvent *EventPipeEventGCCreateConcurrentThread_V1 = nullptr;
EventPipeEvent *EventPipeEventGCTerminateConcurrentThread = nullptr;
EventPipeEvent *EventPipeEventGCTerminateConcurrentThread_V1 = nullptr;
EventPipeEvent *EventPipeEventGCFinalizersEnd = nullptr;
EventPipeEvent *EventPipeEventGCFinalizersEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventGCFinalizersBegin = nullptr;
EventPipeEvent *EventPipeEventGCFinalizersBegin_V1 = nullptr;
EventPipeEvent *EventPipeEventBulkType = nullptr;
EventPipeEvent *EventPipeEventGCBulkRootEdge = nullptr;
EventPipeEvent *EventPipeEventGCBulkRootConditionalWeakTableElementEdge = nullptr;
EventPipeEvent *EventPipeEventGCBulkNode = nullptr;
EventPipeEvent *EventPipeEventGCBulkEdge = nullptr;
EventPipeEvent *EventPipeEventGCSampledObjectAllocationHigh = nullptr;
EventPipeEvent *EventPipeEventGCBulkSurvivingObjectRanges = nullptr;
EventPipeEvent *EventPipeEventGCBulkMovedObjectRanges = nullptr;
EventPipeEvent *EventPipeEventGCGenerationRange = nullptr;
EventPipeEvent *EventPipeEventGCMarkStackRoots = nullptr;
EventPipeEvent *EventPipeEventGCMarkFinalizeQueueRoots = nullptr;
EventPipeEvent *EventPipeEventGCMarkHandles = nullptr;
EventPipeEvent *EventPipeEventGCMarkOlderGenerationRoots = nullptr;
EventPipeEvent *EventPipeEventFinalizeObject = nullptr;
EventPipeEvent *EventPipeEventSetGCHandle = nullptr;
EventPipeEvent *EventPipeEventDestroyGCHandle = nullptr;
EventPipeEvent *EventPipeEventGCSampledObjectAllocationLow = nullptr;
EventPipeEvent *EventPipeEventPinObjectAtGCTime = nullptr;
EventPipeEvent *EventPipeEventGCTriggered = nullptr;
EventPipeEvent *EventPipeEventGCBulkRootCCW = nullptr;
EventPipeEvent *EventPipeEventGCBulkRCW = nullptr;
EventPipeEvent *EventPipeEventGCBulkRootStaticVar = nullptr;
EventPipeEvent *EventPipeEventGCDynamicEvent = nullptr;
EventPipeEvent *EventPipeEventWorkerThreadCreate = nullptr;
EventPipeEvent *EventPipeEventWorkerThreadTerminate = nullptr;
EventPipeEvent *EventPipeEventWorkerThreadRetire = nullptr;
EventPipeEvent *EventPipeEventWorkerThreadUnretire = nullptr;
EventPipeEvent *EventPipeEventIOThreadCreate = nullptr;
EventPipeEvent *EventPipeEventIOThreadCreate_V1 = nullptr;
EventPipeEvent *EventPipeEventIOThreadTerminate = nullptr;
EventPipeEvent *EventPipeEventIOThreadTerminate_V1 = nullptr;
EventPipeEvent *EventPipeEventIOThreadRetire = nullptr;
EventPipeEvent *EventPipeEventIOThreadRetire_V1 = nullptr;
EventPipeEvent *EventPipeEventIOThreadUnretire = nullptr;
EventPipeEvent *EventPipeEventIOThreadUnretire_V1 = nullptr;
EventPipeEvent *EventPipeEventThreadpoolSuspensionSuspendThread = nullptr;
EventPipeEvent *EventPipeEventThreadpoolSuspensionResumeThread = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadStart = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadStop = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadRetirementStart = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadRetirementStop = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadAdjustmentSample = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadAdjustmentAdjustment = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadAdjustmentStats = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkerThreadWait = nullptr;
EventPipeEvent *EventPipeEventYieldProcessorMeasurement = nullptr;
EventPipeEvent *EventPipeEventThreadPoolMinMaxThreads = nullptr;
EventPipeEvent *EventPipeEventThreadPoolWorkingThreadCount = nullptr;
EventPipeEvent *EventPipeEventThreadPoolEnqueue = nullptr;
EventPipeEvent *EventPipeEventThreadPoolDequeue = nullptr;
EventPipeEvent *EventPipeEventThreadPoolIOEnqueue = nullptr;
EventPipeEvent *EventPipeEventThreadPoolIODequeue = nullptr;
EventPipeEvent *EventPipeEventThreadPoolIOPack = nullptr;
EventPipeEvent *EventPipeEventThreadCreating = nullptr;
EventPipeEvent *EventPipeEventThreadRunning = nullptr;
EventPipeEvent *EventPipeEventMethodDetails = nullptr;
EventPipeEvent *EventPipeEventTypeLoadStart = nullptr;
EventPipeEvent *EventPipeEventTypeLoadStop = nullptr;
EventPipeEvent *EventPipeEventExceptionThrown = nullptr;
EventPipeEvent *EventPipeEventExceptionThrown_V1 = nullptr;
EventPipeEvent *EventPipeEventExceptionCatchStart = nullptr;
EventPipeEvent *EventPipeEventExceptionCatchStop = nullptr;
EventPipeEvent *EventPipeEventExceptionFinallyStart = nullptr;
EventPipeEvent *EventPipeEventExceptionFinallyStop = nullptr;
EventPipeEvent *EventPipeEventExceptionFilterStart = nullptr;
EventPipeEvent *EventPipeEventExceptionFilterStop = nullptr;
EventPipeEvent *EventPipeEventExceptionThrownStop = nullptr;
EventPipeEvent *EventPipeEventContention = nullptr;
EventPipeEvent *EventPipeEventContentionStart_V1 = nullptr;
EventPipeEvent *EventPipeEventContentionStop = nullptr;
EventPipeEvent *EventPipeEventContentionStop_V1 = nullptr;
EventPipeEvent *EventPipeEventCLRStackWalk = nullptr;
EventPipeEvent *EventPipeEventAppDomainMemAllocated = nullptr;
EventPipeEvent *EventPipeEventAppDomainMemSurvived = nullptr;
EventPipeEvent *EventPipeEventThreadCreated = nullptr;
EventPipeEvent *EventPipeEventThreadTerminated = nullptr;
EventPipeEvent *EventPipeEventThreadDomainEnter = nullptr;
EventPipeEvent *EventPipeEventILStubGenerated = nullptr;
EventPipeEvent *EventPipeEventILStubCacheHit = nullptr;
EventPipeEvent *EventPipeEventDCStartCompleteV2 = nullptr;
EventPipeEvent *EventPipeEventDCEndCompleteV2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartV2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndV2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCStartVerboseV2 = nullptr;
EventPipeEvent *EventPipeEventMethodDCEndVerboseV2 = nullptr;
EventPipeEvent *EventPipeEventMethodLoad = nullptr;
EventPipeEvent *EventPipeEventMethodLoad_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodLoad_V2 = nullptr;
EventPipeEvent *EventPipeEventR2RGetEntryPoint = nullptr;
EventPipeEvent *EventPipeEventR2RGetEntryPointStart = nullptr;
EventPipeEvent *EventPipeEventMethodUnload = nullptr;
EventPipeEvent *EventPipeEventMethodUnload_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodUnload_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodLoadVerbose = nullptr;
EventPipeEvent *EventPipeEventMethodLoadVerbose_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodLoadVerbose_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodUnloadVerbose = nullptr;
EventPipeEvent *EventPipeEventMethodUnloadVerbose_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodUnloadVerbose_V2 = nullptr;
EventPipeEvent *EventPipeEventMethodJittingStarted = nullptr;
EventPipeEvent *EventPipeEventMethodJittingStarted_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodJitMemoryAllocatedForCode = nullptr;
EventPipeEvent *EventPipeEventMethodJitInliningSucceeded = nullptr;
EventPipeEvent *EventPipeEventMethodJitInliningFailedAnsi = nullptr;
EventPipeEvent *EventPipeEventMethodJitTailCallSucceeded = nullptr;
EventPipeEvent *EventPipeEventMethodJitTailCallFailedAnsi = nullptr;
EventPipeEvent *EventPipeEventMethodILToNativeMap = nullptr;
EventPipeEvent *EventPipeEventMethodILToNativeMap_V1 = nullptr;
EventPipeEvent *EventPipeEventMethodJitTailCallFailed = nullptr;
EventPipeEvent *EventPipeEventMethodJitInliningFailed = nullptr;
EventPipeEvent *EventPipeEventModuleDCStartV2 = nullptr;
EventPipeEvent *EventPipeEventModuleDCEndV2 = nullptr;
EventPipeEvent *EventPipeEventDomainModuleLoad = nullptr;
EventPipeEvent *EventPipeEventDomainModuleLoad_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleLoad = nullptr;
EventPipeEvent *EventPipeEventModuleLoad_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleLoad_V2 = nullptr;
EventPipeEvent *EventPipeEventModuleUnload = nullptr;
EventPipeEvent *EventPipeEventModuleUnload_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleUnload_V2 = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoad = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoad_V1 = nullptr;
EventPipeEvent *EventPipeEventAssemblyUnload = nullptr;
EventPipeEvent *EventPipeEventAssemblyUnload_V1 = nullptr;
EventPipeEvent *EventPipeEventAppDomainLoad = nullptr;
EventPipeEvent *EventPipeEventAppDomainLoad_V1 = nullptr;
EventPipeEvent *EventPipeEventAppDomainUnload = nullptr;
EventPipeEvent *EventPipeEventAppDomainUnload_V1 = nullptr;
EventPipeEvent *EventPipeEventModuleRangeLoad = nullptr;
EventPipeEvent *EventPipeEventStrongNameVerificationStart = nullptr;
EventPipeEvent *EventPipeEventStrongNameVerificationStart_V1 = nullptr;
EventPipeEvent *EventPipeEventStrongNameVerificationStop = nullptr;
EventPipeEvent *EventPipeEventStrongNameVerificationStop_V1 = nullptr;
EventPipeEvent *EventPipeEventAuthenticodeVerificationStart = nullptr;
EventPipeEvent *EventPipeEventAuthenticodeVerificationStart_V1 = nullptr;
EventPipeEvent *EventPipeEventAuthenticodeVerificationStop = nullptr;
EventPipeEvent *EventPipeEventAuthenticodeVerificationStop_V1 = nullptr;
EventPipeEvent *EventPipeEventRuntimeInformationStart = nullptr;
EventPipeEvent *EventPipeEventIncreaseMemoryPressure = nullptr;
EventPipeEvent *EventPipeEventDecreaseMemoryPressure = nullptr;
EventPipeEvent *EventPipeEventGCMarkWithType = nullptr;
EventPipeEvent *EventPipeEventGCJoin_V2 = nullptr;
EventPipeEvent *EventPipeEventGCPerHeapHistory_V3 = nullptr;
EventPipeEvent *EventPipeEventGCGlobalHeapHistory_V2 = nullptr;
EventPipeEvent *EventPipeEventGCGlobalHeapHistory_V3 = nullptr;
EventPipeEvent *EventPipeEventGCGlobalHeapHistory_V4 = nullptr;
EventPipeEvent *EventPipeEventGenAwareBegin = nullptr;
EventPipeEvent *EventPipeEventGenAwareEnd = nullptr;
EventPipeEvent *EventPipeEventGCLOHCompact = nullptr;
EventPipeEvent *EventPipeEventGCFitBucketInfo = nullptr;
EventPipeEvent *EventPipeEventDebugIPCEventStart = nullptr;
EventPipeEvent *EventPipeEventDebugIPCEventEnd = nullptr;
EventPipeEvent *EventPipeEventDebugExceptionProcessingStart = nullptr;
EventPipeEvent *EventPipeEventDebugExceptionProcessingEnd = nullptr;
EventPipeEvent *EventPipeEventCodeSymbols = nullptr;
EventPipeEvent *EventPipeEventEventSource = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationSettings = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationPause = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationResume = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationBackgroundJitStart = nullptr;
EventPipeEvent *EventPipeEventTieredCompilationBackgroundJitStop = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoadStart = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoadStop = nullptr;
EventPipeEvent *EventPipeEventResolutionAttempted = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoadContextResolvingHandlerInvoked = nullptr;
EventPipeEvent *EventPipeEventAppDomainAssemblyResolveHandlerInvoked = nullptr;
EventPipeEvent *EventPipeEventAssemblyLoadFromResolveHandlerInvoked = nullptr;
EventPipeEvent *EventPipeEventKnownPathProbed = nullptr;
EventPipeEvent *EventPipeEventJitInstrumentationData = nullptr;
EventPipeEvent *EventPipeEventJitInstrumentationDataVerbose = nullptr;
EventPipeEvent *EventPipeEventProfilerMessage = nullptr;
EventPipeEvent *EventPipeEventExecutionCheckpoint = nullptr;

BOOL EventPipeEventEnabledGCStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCStart);
}

extern "C" ULONG EventPipeWriteEventGCStart(
    const unsigned int Count,
    const unsigned int Reason,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCStart_V1);
}

extern "C" ULONG EventPipeWriteEventGCStart_V1(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned int Reason,
    const unsigned int Type,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Depth, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCStart_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCStart_V2);
}

extern "C" ULONG EventPipeWriteEventGCStart_V2(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned int Reason,
    const unsigned int Type,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ClientSequenceNumber,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCStart_V2())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Depth, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClientSequenceNumber, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCStart_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCEnd);
}

extern "C" ULONG EventPipeWriteEventGCEnd(
    const unsigned int Count,
    const unsigned short Depth,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Depth, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCEnd_V1);
}

extern "C" ULONG EventPipeWriteEventGCEnd_V1(
    const unsigned int Count,
    const unsigned int Depth,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Depth, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCRestartEEEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCRestartEEEnd);
}

extern "C" ULONG EventPipeWriteEventGCRestartEEEnd(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCRestartEEEnd())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCRestartEEEnd, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCRestartEEEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCRestartEEEnd_V1);
}

extern "C" ULONG EventPipeWriteEventGCRestartEEEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCRestartEEEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCRestartEEEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCHeapStats(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCHeapStats);
}

extern "C" ULONG EventPipeWriteEventGCHeapStats(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCHeapStats())
        return ERROR_SUCCESS;

    size_t size = 92;
    BYTE stackBuffer[92];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCHeapStats, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCHeapStats_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCHeapStats_V1);
}

extern "C" ULONG EventPipeWriteEventGCHeapStats_V1(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCHeapStats_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCHeapStats_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCHeapStats_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCHeapStats_V2);
}

extern "C" ULONG EventPipeWriteEventGCHeapStats_V2(
    const unsigned __int64 GenerationSize0,
    const unsigned __int64 TotalPromotedSize0,
    const unsigned __int64 GenerationSize1,
    const unsigned __int64 TotalPromotedSize1,
    const unsigned __int64 GenerationSize2,
    const unsigned __int64 TotalPromotedSize2,
    const unsigned __int64 GenerationSize3,
    const unsigned __int64 TotalPromotedSize3,
    const unsigned __int64 FinalizationPromotedSize,
    const unsigned __int64 FinalizationPromotedCount,
    const unsigned int PinnedObjectCount,
    const unsigned int SinkBlockCount,
    const unsigned int GCHandleCount,
    const unsigned short ClrInstanceID,
    const unsigned __int64 GenerationSize4,
    const unsigned __int64 TotalPromotedSize4,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCHeapStats_V2())
        return ERROR_SUCCESS;

    size_t size = 110;
    BYTE stackBuffer[110];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenerationSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize3, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FinalizationPromotedCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedObjectCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SinkBlockCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GCHandleCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationSize4, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalPromotedSize4, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCHeapStats_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCCreateSegment(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCCreateSegment);
}

extern "C" ULONG EventPipeWriteEventGCCreateSegment(
    const unsigned __int64 Address,
    const unsigned __int64 Size,
    const unsigned int Type,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCCreateSegment())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Size, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCCreateSegment, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCCreateSegment_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCCreateSegment_V1);
}

extern "C" ULONG EventPipeWriteEventGCCreateSegment_V1(
    const unsigned __int64 Address,
    const unsigned __int64 Size,
    const unsigned int Type,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCCreateSegment_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Size, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCCreateSegment_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFreeSegment(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFreeSegment);
}

extern "C" ULONG EventPipeWriteEventGCFreeSegment(
    const unsigned __int64 Address,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFreeSegment())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFreeSegment, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFreeSegment_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFreeSegment_V1);
}

extern "C" ULONG EventPipeWriteEventGCFreeSegment_V1(
    const unsigned __int64 Address,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFreeSegment_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFreeSegment_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCRestartEEBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCRestartEEBegin);
}

extern "C" ULONG EventPipeWriteEventGCRestartEEBegin(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCRestartEEBegin())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCRestartEEBegin, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCRestartEEBegin_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCRestartEEBegin_V1);
}

extern "C" ULONG EventPipeWriteEventGCRestartEEBegin_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCRestartEEBegin_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCRestartEEBegin_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSuspendEEEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSuspendEEEnd);
}

extern "C" ULONG EventPipeWriteEventGCSuspendEEEnd(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSuspendEEEnd())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCSuspendEEEnd, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSuspendEEEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSuspendEEEnd_V1);
}

extern "C" ULONG EventPipeWriteEventGCSuspendEEEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSuspendEEEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSuspendEEEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSuspendEEBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSuspendEEBegin);
}

extern "C" ULONG EventPipeWriteEventGCSuspendEEBegin(
    const unsigned short Reason,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSuspendEEBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSuspendEEBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSuspendEEBegin_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSuspendEEBegin_V1);
}

extern "C" ULONG EventPipeWriteEventGCSuspendEEBegin_V1(
    const unsigned int Reason,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSuspendEEBegin_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSuspendEEBegin_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCAllocationTick(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCAllocationTick);
}

extern "C" ULONG EventPipeWriteEventGCAllocationTick(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCAllocationTick())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(AllocationAmount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationKind, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCAllocationTick, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCAllocationTick_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCAllocationTick_V1);
}

extern "C" ULONG EventPipeWriteEventGCAllocationTick_V1(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCAllocationTick_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(AllocationAmount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCAllocationTick_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCAllocationTick_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCAllocationTick_V2);
}

extern "C" ULONG EventPipeWriteEventGCAllocationTick_V2(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCAllocationTick_V2())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(AllocationAmount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationAmount64, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HeapIndex, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCAllocationTick_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCAllocationTick_V3(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCAllocationTick_V3);
}

extern "C" ULONG EventPipeWriteEventGCAllocationTick_V3(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex,
    const void* Address,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCAllocationTick_V3())
        return ERROR_SUCCESS;

    size_t size = 102;
    BYTE stackBuffer[102];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(AllocationAmount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationAmount64, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HeapIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCAllocationTick_V3, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCAllocationTick_V4(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCAllocationTick_V4);
}

extern "C" ULONG EventPipeWriteEventGCAllocationTick_V4(
    const unsigned int AllocationAmount,
    const unsigned int AllocationKind,
    const unsigned short ClrInstanceID,
    const unsigned __int64 AllocationAmount64,
    const void* TypeID,
    PCWSTR TypeName,
    const unsigned int HeapIndex,
    const void* Address,
    const unsigned __int64 ObjectSize,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCAllocationTick_V4())
        return ERROR_SUCCESS;

    size_t size = 110;
    BYTE stackBuffer[110];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(AllocationAmount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocationAmount64, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HeapIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCAllocationTick_V4, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCCreateConcurrentThread(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCCreateConcurrentThread);
}

extern "C" ULONG EventPipeWriteEventGCCreateConcurrentThread(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCCreateConcurrentThread())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCCreateConcurrentThread, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCCreateConcurrentThread_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCCreateConcurrentThread_V1);
}

extern "C" ULONG EventPipeWriteEventGCCreateConcurrentThread_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCCreateConcurrentThread_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCCreateConcurrentThread_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCTerminateConcurrentThread(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCTerminateConcurrentThread);
}

extern "C" ULONG EventPipeWriteEventGCTerminateConcurrentThread(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCTerminateConcurrentThread())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCTerminateConcurrentThread, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCTerminateConcurrentThread_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCTerminateConcurrentThread_V1);
}

extern "C" ULONG EventPipeWriteEventGCTerminateConcurrentThread_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCTerminateConcurrentThread_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCTerminateConcurrentThread_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFinalizersEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFinalizersEnd);
}

extern "C" ULONG EventPipeWriteEventGCFinalizersEnd(
    const unsigned int Count,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFinalizersEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFinalizersEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFinalizersEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFinalizersEnd_V1);
}

extern "C" ULONG EventPipeWriteEventGCFinalizersEnd_V1(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFinalizersEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFinalizersEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFinalizersBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFinalizersBegin);
}

extern "C" ULONG EventPipeWriteEventGCFinalizersBegin(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFinalizersBegin())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventGCFinalizersBegin, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFinalizersBegin_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFinalizersBegin_V1);
}

extern "C" ULONG EventPipeWriteEventGCFinalizersBegin_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFinalizersBegin_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFinalizersBegin_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBulkType(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBulkType);
}

extern "C" ULONG EventPipeWriteEventBulkType(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBulkType())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBulkType, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkRootEdge(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkRootEdge);
}

extern "C" ULONG EventPipeWriteEventGCBulkRootEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkRootEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkRootEdge, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkRootConditionalWeakTableElementEdge(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkRootConditionalWeakTableElementEdge);
}

extern "C" ULONG EventPipeWriteEventGCBulkRootConditionalWeakTableElementEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkRootConditionalWeakTableElementEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkRootConditionalWeakTableElementEdge, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkNode(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkNode);
}

extern "C" ULONG EventPipeWriteEventGCBulkNode(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkNode())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkNode, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkEdge(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkEdge);
}

extern "C" ULONG EventPipeWriteEventGCBulkEdge(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkEdge())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkEdge, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSampledObjectAllocationHigh(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSampledObjectAllocationHigh);
}

extern "C" ULONG EventPipeWriteEventGCSampledObjectAllocationHigh(
    const void* Address,
    const void* TypeID,
    const unsigned int ObjectCountForTypeSample,
    const unsigned __int64 TotalSizeForTypeSample,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSampledObjectAllocationHigh())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectCountForTypeSample, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalSizeForTypeSample, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSampledObjectAllocationHigh, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkSurvivingObjectRanges(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkSurvivingObjectRanges);
}

extern "C" ULONG EventPipeWriteEventGCBulkSurvivingObjectRanges(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkSurvivingObjectRanges())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkSurvivingObjectRanges, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkMovedObjectRanges(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkMovedObjectRanges);
}

extern "C" ULONG EventPipeWriteEventGCBulkMovedObjectRanges(
    const unsigned int Index,
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkMovedObjectRanges())
        return ERROR_SUCCESS;

    size_t size = 42;
    BYTE stackBuffer[42];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Index, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkMovedObjectRanges, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGenerationRange(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGenerationRange);
}

extern "C" ULONG EventPipeWriteEventGCGenerationRange(
    const unsigned char Generation,
    const void* RangeStart,
    const unsigned __int64 RangeUsedLength,
    const unsigned __int64 RangeReservedLength,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGenerationRange())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Generation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeStart, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeUsedLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeReservedLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGenerationRange, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCMarkStackRoots(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCMarkStackRoots);
}

extern "C" ULONG EventPipeWriteEventGCMarkStackRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCMarkStackRoots())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCMarkStackRoots, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCMarkFinalizeQueueRoots(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCMarkFinalizeQueueRoots);
}

extern "C" ULONG EventPipeWriteEventGCMarkFinalizeQueueRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCMarkFinalizeQueueRoots())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCMarkFinalizeQueueRoots, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCMarkHandles(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCMarkHandles);
}

extern "C" ULONG EventPipeWriteEventGCMarkHandles(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCMarkHandles())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCMarkHandles, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCMarkOlderGenerationRoots(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCMarkOlderGenerationRoots);
}

extern "C" ULONG EventPipeWriteEventGCMarkOlderGenerationRoots(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCMarkOlderGenerationRoots())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCMarkOlderGenerationRoots, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFinalizeObject(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFinalizeObject);
}

extern "C" ULONG EventPipeWriteEventFinalizeObject(
    const void* TypeID,
    const void* ObjectID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFinalizeObject())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFinalizeObject, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledSetGCHandle(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventSetGCHandle);
}

extern "C" ULONG EventPipeWriteEventSetGCHandle(
    const void* HandleID,
    const void* ObjectID,
    const unsigned int Kind,
    const unsigned int Generation,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledSetGCHandle())
        return ERROR_SUCCESS;

    size_t size = 34;
    BYTE stackBuffer[34];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Kind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Generation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventSetGCHandle, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDestroyGCHandle(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDestroyGCHandle);
}

extern "C" ULONG EventPipeWriteEventDestroyGCHandle(
    const void* HandleID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDestroyGCHandle())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDestroyGCHandle, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSampledObjectAllocationLow(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSampledObjectAllocationLow);
}

extern "C" ULONG EventPipeWriteEventGCSampledObjectAllocationLow(
    const void* Address,
    const void* TypeID,
    const unsigned int ObjectCountForTypeSample,
    const unsigned __int64 TotalSizeForTypeSample,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSampledObjectAllocationLow())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Address, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectCountForTypeSample, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalSizeForTypeSample, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSampledObjectAllocationLow, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPinObjectAtGCTime(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPinObjectAtGCTime);
}

extern "C" ULONG EventPipeWriteEventPinObjectAtGCTime(
    const void* HandleID,
    const void* ObjectID,
    const unsigned __int64 ObjectSize,
    PCWSTR TypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPinObjectAtGCTime())
        return ERROR_SUCCESS;

    size_t size = 90;
    BYTE stackBuffer[90];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPinObjectAtGCTime, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCTriggered(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCTriggered);
}

extern "C" ULONG EventPipeWriteEventGCTriggered(
    const unsigned int Reason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCTriggered())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCTriggered, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkRootCCW(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkRootCCW);
}

extern "C" ULONG EventPipeWriteEventGCBulkRootCCW(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkRootCCW())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkRootCCW, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkRCW(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkRCW);
}

extern "C" ULONG EventPipeWriteEventGCBulkRCW(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkRCW())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkRCW, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCBulkRootStaticVar(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCBulkRootStaticVar);
}

extern "C" ULONG EventPipeWriteEventGCBulkRootStaticVar(
    const unsigned int Count,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCBulkRootStaticVar())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)(Values_ElementSize), buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCBulkRootStaticVar, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCDynamicEvent(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCDynamicEvent);
}

extern "C" ULONG EventPipeWriteEventGCDynamicEvent(
    PCWSTR Name,
    const unsigned int DataSize,
    const BYTE* Data,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCDynamicEvent())
        return ERROR_SUCCESS;

    size_t size = 71;
    BYTE stackBuffer[71];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Name) { Name = W("NULL"); }
    success &= WriteToBuffer(Name, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCDynamicEvent, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledWorkerThreadCreate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventWorkerThreadCreate);
}

extern "C" ULONG EventPipeWriteEventWorkerThreadCreate(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledWorkerThreadCreate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventWorkerThreadCreate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledWorkerThreadTerminate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventWorkerThreadTerminate);
}

extern "C" ULONG EventPipeWriteEventWorkerThreadTerminate(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledWorkerThreadTerminate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventWorkerThreadTerminate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledWorkerThreadRetire(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventWorkerThreadRetire);
}

extern "C" ULONG EventPipeWriteEventWorkerThreadRetire(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledWorkerThreadRetire())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventWorkerThreadRetire, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledWorkerThreadUnretire(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventWorkerThreadUnretire);
}

extern "C" ULONG EventPipeWriteEventWorkerThreadUnretire(
    const unsigned int WorkerThreadCount,
    const unsigned int RetiredWorkerThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledWorkerThreadUnretire())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventWorkerThreadUnretire, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadCreate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadCreate);
}

extern "C" ULONG EventPipeWriteEventIOThreadCreate(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadCreate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadCreate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadCreate_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadCreate_V1);
}

extern "C" ULONG EventPipeWriteEventIOThreadCreate_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadCreate_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadCreate_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadTerminate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadTerminate);
}

extern "C" ULONG EventPipeWriteEventIOThreadTerminate(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadTerminate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadTerminate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadTerminate_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadTerminate_V1);
}

extern "C" ULONG EventPipeWriteEventIOThreadTerminate_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadTerminate_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadTerminate_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadRetire(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadRetire);
}

extern "C" ULONG EventPipeWriteEventIOThreadRetire(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadRetire())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadRetire, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadRetire_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadRetire_V1);
}

extern "C" ULONG EventPipeWriteEventIOThreadRetire_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadRetire_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadRetire_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadUnretire(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadUnretire);
}

extern "C" ULONG EventPipeWriteEventIOThreadUnretire(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadUnretire())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadUnretire, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIOThreadUnretire_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIOThreadUnretire_V1);
}

extern "C" ULONG EventPipeWriteEventIOThreadUnretire_V1(
    const unsigned int IOThreadCount,
    const unsigned int RetiredIOThreads,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIOThreadUnretire_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(IOThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredIOThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIOThreadUnretire_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadpoolSuspensionSuspendThread(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadpoolSuspensionSuspendThread);
}

extern "C" ULONG EventPipeWriteEventThreadpoolSuspensionSuspendThread(
    const unsigned int ClrThreadID,
    const unsigned int CpuUtilization,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadpoolSuspensionSuspendThread())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CpuUtilization, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadpoolSuspensionSuspendThread, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadpoolSuspensionResumeThread(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadpoolSuspensionResumeThread);
}

extern "C" ULONG EventPipeWriteEventThreadpoolSuspensionResumeThread(
    const unsigned int ClrThreadID,
    const unsigned int CpuUtilization,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadpoolSuspensionResumeThread())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CpuUtilization, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadpoolSuspensionResumeThread, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadStart);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadStart(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ActiveWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadStop);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadStop(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadStop())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ActiveWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadRetirementStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadRetirementStart);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadRetirementStart(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadRetirementStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ActiveWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadRetirementStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadRetirementStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadRetirementStop);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadRetirementStop(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadRetirementStop())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ActiveWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadRetirementStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentSample(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadAdjustmentSample);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadAdjustmentSample(
    const double Throughput,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentSample())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Throughput, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadAdjustmentSample, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentAdjustment(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadAdjustmentAdjustment);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadAdjustmentAdjustment(
    const double AverageThroughput,
    const unsigned int NewWorkerThreadCount,
    const unsigned int Reason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentAdjustment())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(AverageThroughput, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadAdjustmentAdjustment, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentStats(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadAdjustmentStats);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadAdjustmentStats(
    const double Duration,
    const double Throughput,
    const double ThreadWave,
    const double ThroughputWave,
    const double ThroughputErrorEstimate,
    const double AverageThroughputErrorEstimate,
    const double ThroughputRatio,
    const double Confidence,
    const double NewControlSetting,
    const unsigned short NewThreadWaveMagnitude,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentStats())
        return ERROR_SUCCESS;

    size_t size = 76;
    BYTE stackBuffer[76];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Duration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Throughput, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThreadWave, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputWave, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputErrorEstimate, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AverageThroughputErrorEstimate, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ThroughputRatio, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Confidence, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewControlSetting, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewThreadWaveMagnitude, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadAdjustmentStats, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkerThreadWait(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkerThreadWait);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkerThreadWait(
    const unsigned int ActiveWorkerThreadCount,
    const unsigned int RetiredWorkerThreadCount,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkerThreadWait())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ActiveWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RetiredWorkerThreadCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkerThreadWait, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledYieldProcessorMeasurement(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventYieldProcessorMeasurement);
}

extern "C" ULONG EventPipeWriteEventYieldProcessorMeasurement(
    const unsigned short ClrInstanceID,
    const double NsPerYield,
    const double EstablishedNsPerYield,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledYieldProcessorMeasurement())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NsPerYield, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EstablishedNsPerYield, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventYieldProcessorMeasurement, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolMinMaxThreads(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolMinMaxThreads);
}

extern "C" ULONG EventPipeWriteEventThreadPoolMinMaxThreads(
    const unsigned short MinWorkerThreads,
    const unsigned short MaxWorkerThreads,
    const unsigned short MinIOCompletionThreads,
    const unsigned short MaxIOCompletionThreads,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolMinMaxThreads())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MinWorkerThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MaxWorkerThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MinIOCompletionThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MaxIOCompletionThreads, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolMinMaxThreads, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolWorkingThreadCount(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolWorkingThreadCount);
}

extern "C" ULONG EventPipeWriteEventThreadPoolWorkingThreadCount(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolWorkingThreadCount())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolWorkingThreadCount, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolEnqueue(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolEnqueue);
}

extern "C" ULONG EventPipeWriteEventThreadPoolEnqueue(
    const void* WorkID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolEnqueue())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolEnqueue, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolDequeue(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolDequeue);
}

extern "C" ULONG EventPipeWriteEventThreadPoolDequeue(
    const void* WorkID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolDequeue())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(WorkID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolDequeue, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolIOEnqueue(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolIOEnqueue);
}

extern "C" ULONG EventPipeWriteEventThreadPoolIOEnqueue(
    const void* NativeOverlapped,
    const void* Overlapped,
    const BOOL MultiDequeues,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolIOEnqueue())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(NativeOverlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Overlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MultiDequeues, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolIOEnqueue, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolIODequeue(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolIODequeue);
}

extern "C" ULONG EventPipeWriteEventThreadPoolIODequeue(
    const void* NativeOverlapped,
    const void* Overlapped,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolIODequeue())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(NativeOverlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Overlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolIODequeue, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadPoolIOPack(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadPoolIOPack);
}

extern "C" ULONG EventPipeWriteEventThreadPoolIOPack(
    const void* NativeOverlapped,
    const void* Overlapped,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadPoolIOPack())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(NativeOverlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Overlapped, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadPoolIOPack, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadCreating(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadCreating);
}

extern "C" ULONG EventPipeWriteEventThreadCreating(
    const void* ID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadCreating())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadCreating, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadRunning(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadRunning);
}

extern "C" ULONG EventPipeWriteEventThreadRunning(
    const void* ID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadRunning())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadRunning, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDetails(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDetails);
}

extern "C" ULONG EventPipeWriteEventMethodDetails(
    const unsigned __int64 MethodID,
    const unsigned __int64 TypeID,
    const unsigned int MethodToken,
    const unsigned int TypeParameterCount,
    const unsigned __int64 LoaderModuleID,
    const unsigned __int64* TypeParameters,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDetails())
        return ERROR_SUCCESS;

    size_t size = 40;
    BYTE stackBuffer[40];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeParameterCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoaderModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)TypeParameters, sizeof(const unsigned __int64) * (int)TypeParameterCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDetails, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTypeLoadStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTypeLoadStart);
}

extern "C" ULONG EventPipeWriteEventTypeLoadStart(
    const unsigned int TypeLoadStartID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTypeLoadStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(TypeLoadStartID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTypeLoadStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTypeLoadStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTypeLoadStop);
}

extern "C" ULONG EventPipeWriteEventTypeLoadStop(
    const unsigned int TypeLoadStartID,
    const unsigned short ClrInstanceID,
    const unsigned short LoadLevel,
    const unsigned __int64 TypeID,
    PCWSTR TypeName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTypeLoadStop())
        return ERROR_SUCCESS;

    size_t size = 80;
    BYTE stackBuffer[80];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeLoadStartID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadLevel, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTypeLoadStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionThrown(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionThrown);
}

extern "C" ULONG EventPipeWriteEventExceptionThrown(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionThrown())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventExceptionThrown, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionThrown_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionThrown_V1);
}

extern "C" ULONG EventPipeWriteEventExceptionThrown_V1(
    PCWSTR ExceptionType,
    PCWSTR ExceptionMessage,
    const void* ExceptionEIP,
    const unsigned int ExceptionHRESULT,
    const unsigned short ExceptionFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionThrown_V1())
        return ERROR_SUCCESS;

    size_t size = 144;
    BYTE stackBuffer[144];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ExceptionType) { ExceptionType = W("NULL"); }
    if (!ExceptionMessage) { ExceptionMessage = W("NULL"); }
    success &= WriteToBuffer(ExceptionType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExceptionMessage, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExceptionEIP, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExceptionHRESULT, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExceptionFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExceptionThrown_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionCatchStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionCatchStart);
}

extern "C" ULONG EventPipeWriteEventExceptionCatchStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionCatchStart())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodName) { MethodName = W("NULL"); }
    success &= WriteToBuffer(EntryEIP, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExceptionCatchStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionCatchStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionCatchStop);
}

extern "C" ULONG EventPipeWriteEventExceptionCatchStop(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionCatchStop())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventExceptionCatchStop, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionFinallyStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionFinallyStart);
}

extern "C" ULONG EventPipeWriteEventExceptionFinallyStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionFinallyStart())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodName) { MethodName = W("NULL"); }
    success &= WriteToBuffer(EntryEIP, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExceptionFinallyStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionFinallyStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionFinallyStop);
}

extern "C" ULONG EventPipeWriteEventExceptionFinallyStop(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionFinallyStop())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventExceptionFinallyStop, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionFilterStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionFilterStart);
}

extern "C" ULONG EventPipeWriteEventExceptionFilterStart(
    const unsigned __int64 EntryEIP,
    const unsigned __int64 MethodID,
    PCWSTR MethodName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionFilterStart())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodName) { MethodName = W("NULL"); }
    success &= WriteToBuffer(EntryEIP, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExceptionFilterStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionFilterStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionFilterStop);
}

extern "C" ULONG EventPipeWriteEventExceptionFilterStop(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionFilterStop())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventExceptionFilterStop, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExceptionThrownStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExceptionThrownStop);
}

extern "C" ULONG EventPipeWriteEventExceptionThrownStop(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExceptionThrownStop())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventExceptionThrownStop, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledContention(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventContention);
}

extern "C" ULONG EventPipeWriteEventContention(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledContention())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventContention, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledContentionStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventContentionStart_V1);
}

extern "C" ULONG EventPipeWriteEventContentionStart_V1(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledContentionStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ContentionFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventContentionStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledContentionStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventContentionStop);
}

extern "C" ULONG EventPipeWriteEventContentionStop(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledContentionStop())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ContentionFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventContentionStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledContentionStop_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventContentionStop_V1);
}

extern "C" ULONG EventPipeWriteEventContentionStop_V1(
    const unsigned char ContentionFlags,
    const unsigned short ClrInstanceID,
    const double DurationNs,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledContentionStop_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ContentionFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DurationNs, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventContentionStop_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCLRStackWalk(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCLRStackWalk);
}

extern "C" ULONG EventPipeWriteEventCLRStackWalk(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCLRStackWalk())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FrameCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Stack, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCLRStackWalk, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainMemAllocated(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainMemAllocated);
}

extern "C" ULONG EventPipeWriteEventAppDomainMemAllocated(
    const unsigned __int64 AppDomainID,
    const unsigned __int64 Allocated,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainMemAllocated())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Allocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainMemAllocated, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainMemSurvived(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainMemSurvived);
}

extern "C" ULONG EventPipeWriteEventAppDomainMemSurvived(
    const unsigned __int64 AppDomainID,
    const unsigned __int64 Survived,
    const unsigned __int64 ProcessSurvived,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainMemSurvived())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Survived, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ProcessSurvived, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainMemSurvived, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadCreated(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadCreated);
}

extern "C" ULONG EventPipeWriteEventThreadCreated(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned int Flags,
    const unsigned int ManagedThreadIndex,
    const unsigned int OSThreadID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadCreated())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ManagedThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Flags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedThreadIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(OSThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadCreated, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadTerminated(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadTerminated);
}

extern "C" ULONG EventPipeWriteEventThreadTerminated(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadTerminated())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ManagedThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadTerminated, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledThreadDomainEnter(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventThreadDomainEnter);
}

extern "C" ULONG EventPipeWriteEventThreadDomainEnter(
    const unsigned __int64 ManagedThreadID,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledThreadDomainEnter())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ManagedThreadID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventThreadDomainEnter, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledILStubGenerated(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventILStubGenerated);
}

extern "C" ULONG EventPipeWriteEventILStubGenerated(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 StubMethodID,
    const unsigned int StubFlags,
    const unsigned int ManagedInteropMethodToken,
    PCWSTR ManagedInteropMethodNamespace,
    PCWSTR ManagedInteropMethodName,
    PCWSTR ManagedInteropMethodSignature,
    PCWSTR NativeMethodSignature,
    PCWSTR StubMethodSignature,
    PCWSTR StubMethodILCode,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledILStubGenerated())
        return ERROR_SUCCESS;

    size_t size = 410;
    BYTE stackBuffer[410];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ManagedInteropMethodNamespace) { ManagedInteropMethodNamespace = W("NULL"); }
    if (!ManagedInteropMethodName) { ManagedInteropMethodName = W("NULL"); }
    if (!ManagedInteropMethodSignature) { ManagedInteropMethodSignature = W("NULL"); }
    if (!NativeMethodSignature) { NativeMethodSignature = W("NULL"); }
    if (!StubMethodSignature) { StubMethodSignature = W("NULL"); }
    if (!StubMethodILCode) { StubMethodILCode = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativeMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodILCode, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventILStubGenerated, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledILStubCacheHit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventILStubCacheHit);
}

extern "C" ULONG EventPipeWriteEventILStubCacheHit(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 StubMethodID,
    const unsigned int ManagedInteropMethodToken,
    PCWSTR ManagedInteropMethodNamespace,
    PCWSTR ManagedInteropMethodName,
    PCWSTR ManagedInteropMethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledILStubCacheHit())
        return ERROR_SUCCESS;

    size_t size = 214;
    BYTE stackBuffer[214];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ManagedInteropMethodNamespace) { ManagedInteropMethodNamespace = W("NULL"); }
    if (!ManagedInteropMethodName) { ManagedInteropMethodName = W("NULL"); }
    if (!ManagedInteropMethodSignature) { ManagedInteropMethodSignature = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StubMethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedInteropMethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventILStubCacheHit, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCStartCompleteV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCStartCompleteV2);
}

extern "C" ULONG EventPipeWriteEventDCStartCompleteV2(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCStartCompleteV2())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCStartCompleteV2, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDCEndCompleteV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDCEndCompleteV2);
}

extern "C" ULONG EventPipeWriteEventDCEndCompleteV2(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDCEndCompleteV2())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDCEndCompleteV2, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartV2);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartV2())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndV2);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndV2())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCStartVerboseV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCStartVerboseV2);
}

extern "C" ULONG EventPipeWriteEventMethodDCStartVerboseV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCStartVerboseV2())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCStartVerboseV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodDCEndVerboseV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodDCEndVerboseV2);
}

extern "C" ULONG EventPipeWriteEventMethodDCEndVerboseV2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodDCEndVerboseV2())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodDCEndVerboseV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoad);
}

extern "C" ULONG EventPipeWriteEventMethodLoad(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoad())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoad_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoad_V1);
}

extern "C" ULONG EventPipeWriteEventMethodLoad_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoad_V1())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoad_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoad_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoad_V2);
}

extern "C" ULONG EventPipeWriteEventMethodLoad_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoad_V2())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoad_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledR2RGetEntryPoint(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventR2RGetEntryPoint);
}

extern "C" ULONG EventPipeWriteEventR2RGetEntryPoint(
    const unsigned __int64 MethodID,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned __int64 EntryPoint,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledR2RGetEntryPoint())
        return ERROR_SUCCESS;

    size_t size = 210;
    BYTE stackBuffer[210];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EntryPoint, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventR2RGetEntryPoint, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledR2RGetEntryPointStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventR2RGetEntryPointStart);
}

extern "C" ULONG EventPipeWriteEventR2RGetEntryPointStart(
    const unsigned __int64 MethodID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledR2RGetEntryPointStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventR2RGetEntryPointStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnload(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnload);
}

extern "C" ULONG EventPipeWriteEventMethodUnload(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnload())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnload, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnload_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnload_V1);
}

extern "C" ULONG EventPipeWriteEventMethodUnload_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnload_V1())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnload_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnload_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnload_V2);
}

extern "C" ULONG EventPipeWriteEventMethodUnload_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnload_V2())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnload_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoadVerbose(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoadVerbose);
}

extern "C" ULONG EventPipeWriteEventMethodLoadVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoadVerbose())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoadVerbose, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoadVerbose_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoadVerbose_V1);
}

extern "C" ULONG EventPipeWriteEventMethodLoadVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoadVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    BYTE stackBuffer[230];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoadVerbose_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodLoadVerbose_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodLoadVerbose_V2);
}

extern "C" ULONG EventPipeWriteEventMethodLoadVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodLoadVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    BYTE stackBuffer[238];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodLoadVerbose_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnloadVerbose(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnloadVerbose);
}

extern "C" ULONG EventPipeWriteEventMethodUnloadVerbose(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnloadVerbose())
        return ERROR_SUCCESS;

    size_t size = 228;
    BYTE stackBuffer[228];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnloadVerbose, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnloadVerbose_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnloadVerbose_V1);
}

extern "C" ULONG EventPipeWriteEventMethodUnloadVerbose_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnloadVerbose_V1())
        return ERROR_SUCCESS;

    size_t size = 230;
    BYTE stackBuffer[230];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnloadVerbose_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodUnloadVerbose_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodUnloadVerbose_V2);
}

extern "C" ULONG EventPipeWriteEventMethodUnloadVerbose_V2(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodStartAddress,
    const unsigned int MethodSize,
    const unsigned int MethodToken,
    const unsigned int MethodFlags,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ReJITID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodUnloadVerbose_V2())
        return ERROR_SUCCESS;

    size_t size = 238;
    BYTE stackBuffer[238];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodStartAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodUnloadVerbose_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJittingStarted(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJittingStarted);
}

extern "C" ULONG EventPipeWriteEventMethodJittingStarted(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    const unsigned int MethodILSize,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJittingStarted())
        return ERROR_SUCCESS;

    size_t size = 216;
    BYTE stackBuffer[216];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodILSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJittingStarted, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJittingStarted_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJittingStarted_V1);
}

extern "C" ULONG EventPipeWriteEventMethodJittingStarted_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    const unsigned int MethodILSize,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJittingStarted_V1())
        return ERROR_SUCCESS;

    size_t size = 218;
    BYTE stackBuffer[218];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodILSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJittingStarted_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitMemoryAllocatedForCode(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitMemoryAllocatedForCode);
}

extern "C" ULONG EventPipeWriteEventMethodJitMemoryAllocatedForCode(
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 JitHotCodeRequestSize,
    const unsigned __int64 JitRODataRequestSize,
    const unsigned __int64 AllocatedSizeForJitCode,
    const unsigned int JitAllocFlag,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitMemoryAllocatedForCode())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JitHotCodeRequestSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JitRODataRequestSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AllocatedSizeForJitCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JitAllocFlag, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitMemoryAllocatedForCode, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitInliningSucceeded(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitInliningSucceeded);
}

extern "C" ULONG EventPipeWriteEventMethodJitInliningSucceeded(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitInliningSucceeded())
        return ERROR_SUCCESS;

    size_t size = 578;
    BYTE stackBuffer[578];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!InlinerNamespace) { InlinerNamespace = W("NULL"); }
    if (!InlinerName) { InlinerName = W("NULL"); }
    if (!InlinerNameSignature) { InlinerNameSignature = W("NULL"); }
    if (!InlineeNamespace) { InlineeNamespace = W("NULL"); }
    if (!InlineeName) { InlineeName = W("NULL"); }
    if (!InlineeNameSignature) { InlineeNameSignature = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitInliningSucceeded, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitInliningFailedAnsi(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitInliningFailedAnsi);
}

extern "C" ULONG EventPipeWriteEventMethodJitInliningFailedAnsi(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const BOOL FailAlways,
    LPCSTR FailReason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitInliningFailedAnsi())
        return ERROR_SUCCESS;

    size_t size = 614;
    BYTE stackBuffer[614];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!InlinerNamespace) { InlinerNamespace = W("NULL"); }
    if (!InlinerName) { InlinerName = W("NULL"); }
    if (!InlinerNameSignature) { InlinerNameSignature = W("NULL"); }
    if (!InlineeNamespace) { InlineeNamespace = W("NULL"); }
    if (!InlineeName) { InlineeName = W("NULL"); }
    if (!InlineeNameSignature) { InlineeNameSignature = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailAlways, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitInliningFailedAnsi, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitTailCallSucceeded(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitTailCallSucceeded);
}

extern "C" ULONG EventPipeWriteEventMethodJitTailCallSucceeded(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    const unsigned int TailCallType,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitTailCallSucceeded())
        return ERROR_SUCCESS;

    size_t size = 586;
    BYTE stackBuffer[586];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!CallerNamespace) { CallerNamespace = W("NULL"); }
    if (!CallerName) { CallerName = W("NULL"); }
    if (!CallerNameSignature) { CallerNameSignature = W("NULL"); }
    if (!CalleeNamespace) { CalleeNamespace = W("NULL"); }
    if (!CalleeName) { CalleeName = W("NULL"); }
    if (!CalleeNameSignature) { CalleeNameSignature = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailCallType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitTailCallSucceeded, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitTailCallFailedAnsi(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitTailCallFailedAnsi);
}

extern "C" ULONG EventPipeWriteEventMethodJitTailCallFailedAnsi(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    LPCSTR FailReason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitTailCallFailedAnsi())
        return ERROR_SUCCESS;

    size_t size = 614;
    BYTE stackBuffer[614];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!CallerNamespace) { CallerNamespace = W("NULL"); }
    if (!CallerName) { CallerName = W("NULL"); }
    if (!CallerNameSignature) { CallerNameSignature = W("NULL"); }
    if (!CalleeNamespace) { CalleeNamespace = W("NULL"); }
    if (!CalleeName) { CalleeName = W("NULL"); }
    if (!CalleeNameSignature) { CalleeNameSignature = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitTailCallFailedAnsi, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodILToNativeMap(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodILToNativeMap);
}

extern "C" ULONG EventPipeWriteEventMethodILToNativeMap(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodILToNativeMap())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodILToNativeMap, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodILToNativeMap_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodILToNativeMap_V1);
}

extern "C" ULONG EventPipeWriteEventMethodILToNativeMap_V1(
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned char MethodExtent,
    const unsigned short CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short ClrInstanceID,
    const unsigned __int64 ILVersionID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodILToNativeMap_V1())
        return ERROR_SUCCESS;

    size_t size = 37;
    BYTE stackBuffer[37];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodExtent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)ILOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)NativeOffsets, sizeof(const unsigned int) * (int)CountOfMapEntries, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodILToNativeMap_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitTailCallFailed(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitTailCallFailed);
}

extern "C" ULONG EventPipeWriteEventMethodJitTailCallFailed(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR CallerNamespace,
    PCWSTR CallerName,
    PCWSTR CallerNameSignature,
    PCWSTR CalleeNamespace,
    PCWSTR CalleeName,
    PCWSTR CalleeNameSignature,
    const BOOL TailPrefix,
    PCWSTR FailReason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitTailCallFailed())
        return ERROR_SUCCESS;

    size_t size = 646;
    BYTE stackBuffer[646];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!CallerNamespace) { CallerNamespace = W("NULL"); }
    if (!CallerName) { CallerName = W("NULL"); }
    if (!CallerNameSignature) { CallerNameSignature = W("NULL"); }
    if (!CalleeNamespace) { CalleeNamespace = W("NULL"); }
    if (!CalleeName) { CalleeName = W("NULL"); }
    if (!CalleeNameSignature) { CalleeNameSignature = W("NULL"); }
    if (!FailReason) { FailReason = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CallerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CalleeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TailPrefix, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitTailCallFailed, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodJitInliningFailed(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodJitInliningFailed);
}

extern "C" ULONG EventPipeWriteEventMethodJitInliningFailed(
    PCWSTR MethodBeingCompiledNamespace,
    PCWSTR MethodBeingCompiledName,
    PCWSTR MethodBeingCompiledNameSignature,
    PCWSTR InlinerNamespace,
    PCWSTR InlinerName,
    PCWSTR InlinerNameSignature,
    PCWSTR InlineeNamespace,
    PCWSTR InlineeName,
    PCWSTR InlineeNameSignature,
    const BOOL FailAlways,
    PCWSTR FailReason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodJitInliningFailed())
        return ERROR_SUCCESS;

    size_t size = 646;
    BYTE stackBuffer[646];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodBeingCompiledNamespace) { MethodBeingCompiledNamespace = W("NULL"); }
    if (!MethodBeingCompiledName) { MethodBeingCompiledName = W("NULL"); }
    if (!MethodBeingCompiledNameSignature) { MethodBeingCompiledNameSignature = W("NULL"); }
    if (!InlinerNamespace) { InlinerNamespace = W("NULL"); }
    if (!InlinerName) { InlinerName = W("NULL"); }
    if (!InlinerNameSignature) { InlinerNameSignature = W("NULL"); }
    if (!InlineeNamespace) { InlineeNamespace = W("NULL"); }
    if (!InlineeName) { InlineeName = W("NULL"); }
    if (!InlineeNameSignature) { InlineeNameSignature = W("NULL"); }
    if (!FailReason) { FailReason = W("NULL"); }
    success &= WriteToBuffer(MethodBeingCompiledNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodBeingCompiledNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlinerNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InlineeNameSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailAlways, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailReason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodJitInliningFailed, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCStartV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCStartV2);
}

extern "C" ULONG EventPipeWriteEventModuleDCStartV2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCStartV2())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCStartV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleDCEndV2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleDCEndV2);
}

extern "C" ULONG EventPipeWriteEventModuleDCEndV2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleDCEndV2())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleDCEndV2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleLoad);
}

extern "C" ULONG EventPipeWriteEventDomainModuleLoad(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleLoad())
        return ERROR_SUCCESS;

    size_t size = 160;
    BYTE stackBuffer[160];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDomainModuleLoad_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDomainModuleLoad_V1);
}

extern "C" ULONG EventPipeWriteEventDomainModuleLoad_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDomainModuleLoad_V1())
        return ERROR_SUCCESS;

    size_t size = 162;
    BYTE stackBuffer[162];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDomainModuleLoad_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleLoad);
}

extern "C" ULONG EventPipeWriteEventModuleLoad(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleLoad())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleLoad_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleLoad_V1);
}

extern "C" ULONG EventPipeWriteEventModuleLoad_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleLoad_V1())
        return ERROR_SUCCESS;

    size_t size = 154;
    BYTE stackBuffer[154];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleLoad_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleLoad_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleLoad_V2);
}

extern "C" ULONG EventPipeWriteEventModuleLoad_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleLoad_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    BYTE stackBuffer[290];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    if (!ManagedPdbBuildPath) { ManagedPdbBuildPath = W("NULL"); }
    if (!NativePdbBuildPath) { NativePdbBuildPath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleLoad_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleUnload(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleUnload);
}

extern "C" ULONG EventPipeWriteEventModuleUnload(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleUnload())
        return ERROR_SUCCESS;

    size_t size = 152;
    BYTE stackBuffer[152];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleUnload, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleUnload_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleUnload_V1);
}

extern "C" ULONG EventPipeWriteEventModuleUnload_V1(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleUnload_V1())
        return ERROR_SUCCESS;

    size_t size = 154;
    BYTE stackBuffer[154];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleUnload_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleUnload_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleUnload_V2);
}

extern "C" ULONG EventPipeWriteEventModuleUnload_V2(
    const unsigned __int64 ModuleID,
    const unsigned __int64 AssemblyID,
    const unsigned int ModuleFlags,
    const unsigned int Reserved1,
    PCWSTR ModuleILPath,
    PCWSTR ModuleNativePath,
    const unsigned short ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int ManagedPdbAge,
    PCWSTR ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int NativePdbAge,
    PCWSTR NativePdbBuildPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleUnload_V2())
        return ERROR_SUCCESS;

    size_t size = 290;
    BYTE stackBuffer[290];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModuleILPath) { ModuleILPath = W("NULL"); }
    if (!ModuleNativePath) { ModuleNativePath = W("NULL"); }
    if (!ManagedPdbBuildPath) { ManagedPdbBuildPath = W("NULL"); }
    if (!NativePdbBuildPath) { NativePdbBuildPath = W("NULL"); }
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleILPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleNativePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ManagedPdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ManagedPdbBuildPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*NativePdbSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbAge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NativePdbBuildPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleUnload_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoad);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoad(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoad())
        return ERROR_SUCCESS;

    size_t size = 84;
    BYTE stackBuffer[84];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoad_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoad_V1);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoad_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoad_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BindingID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoad_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyUnload(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyUnload);
}

extern "C" ULONG EventPipeWriteEventAssemblyUnload(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyUnload())
        return ERROR_SUCCESS;

    size_t size = 84;
    BYTE stackBuffer[84];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyUnload, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyUnload_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyUnload_V1);
}

extern "C" ULONG EventPipeWriteEventAssemblyUnload_V1(
    const unsigned __int64 AssemblyID,
    const unsigned __int64 AppDomainID,
    const unsigned __int64 BindingID,
    const unsigned int AssemblyFlags,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyUnload_V1())
        return ERROR_SUCCESS;

    size_t size = 94;
    BYTE stackBuffer[94];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(AssemblyID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BindingID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyUnload_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainLoad);
}

extern "C" ULONG EventPipeWriteEventAppDomainLoad(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainLoad())
        return ERROR_SUCCESS;

    size_t size = 76;
    BYTE stackBuffer[76];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainLoad_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainLoad_V1);
}

extern "C" ULONG EventPipeWriteEventAppDomainLoad_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainLoad_V1())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainLoad_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainUnload(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainUnload);
}

extern "C" ULONG EventPipeWriteEventAppDomainUnload(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainUnload())
        return ERROR_SUCCESS;

    size_t size = 76;
    BYTE stackBuffer[76];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainUnload, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainUnload_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainUnload_V1);
}

extern "C" ULONG EventPipeWriteEventAppDomainUnload_V1(
    const unsigned __int64 AppDomainID,
    const unsigned int AppDomainFlags,
    PCWSTR AppDomainName,
    const unsigned int AppDomainIndex,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainUnload_V1())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AppDomainName) { AppDomainName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainUnload_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleRangeLoad(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleRangeLoad);
}

extern "C" ULONG EventPipeWriteEventModuleRangeLoad(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleRangeLoad())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeBegin, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeType, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleRangeLoad, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledStrongNameVerificationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStrongNameVerificationStart);
}

extern "C" ULONG EventPipeWriteEventStrongNameVerificationStart(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStrongNameVerificationStart())
        return ERROR_SUCCESS;

    size_t size = 72;
    BYTE stackBuffer[72];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStrongNameVerificationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledStrongNameVerificationStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStrongNameVerificationStart_V1);
}

extern "C" ULONG EventPipeWriteEventStrongNameVerificationStart_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStrongNameVerificationStart_V1())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStrongNameVerificationStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledStrongNameVerificationStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStrongNameVerificationStop);
}

extern "C" ULONG EventPipeWriteEventStrongNameVerificationStop(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStrongNameVerificationStop())
        return ERROR_SUCCESS;

    size_t size = 72;
    BYTE stackBuffer[72];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStrongNameVerificationStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledStrongNameVerificationStop_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStrongNameVerificationStop_V1);
}

extern "C" ULONG EventPipeWriteEventStrongNameVerificationStop_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR FullyQualifiedAssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStrongNameVerificationStop_V1())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FullyQualifiedAssemblyName) { FullyQualifiedAssemblyName = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FullyQualifiedAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStrongNameVerificationStop_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAuthenticodeVerificationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAuthenticodeVerificationStart);
}

extern "C" ULONG EventPipeWriteEventAuthenticodeVerificationStart(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAuthenticodeVerificationStart())
        return ERROR_SUCCESS;

    size_t size = 72;
    BYTE stackBuffer[72];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModulePath) { ModulePath = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModulePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAuthenticodeVerificationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAuthenticodeVerificationStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAuthenticodeVerificationStart_V1);
}

extern "C" ULONG EventPipeWriteEventAuthenticodeVerificationStart_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAuthenticodeVerificationStart_V1())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModulePath) { ModulePath = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModulePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAuthenticodeVerificationStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAuthenticodeVerificationStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAuthenticodeVerificationStop);
}

extern "C" ULONG EventPipeWriteEventAuthenticodeVerificationStop(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAuthenticodeVerificationStop())
        return ERROR_SUCCESS;

    size_t size = 72;
    BYTE stackBuffer[72];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModulePath) { ModulePath = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModulePath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAuthenticodeVerificationStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAuthenticodeVerificationStop_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAuthenticodeVerificationStop_V1);
}

extern "C" ULONG EventPipeWriteEventAuthenticodeVerificationStop_V1(
    const unsigned int VerificationFlags,
    const unsigned int ErrorCode,
    PCWSTR ModulePath,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAuthenticodeVerificationStop_V1())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ModulePath) { ModulePath = W("NULL"); }
    success &= WriteToBuffer(VerificationFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModulePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAuthenticodeVerificationStop_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledRuntimeInformationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventRuntimeInformationStart);
}

extern "C" ULONG EventPipeWriteEventRuntimeInformationStart(
    const unsigned short ClrInstanceID,
    const unsigned short Sku,
    const unsigned short BclMajorVersion,
    const unsigned short BclMinorVersion,
    const unsigned short BclBuildNumber,
    const unsigned short BclQfeNumber,
    const unsigned short VMMajorVersion,
    const unsigned short VMMinorVersion,
    const unsigned short VMBuildNumber,
    const unsigned short VMQfeNumber,
    const unsigned int StartupFlags,
    const unsigned char StartupMode,
    PCWSTR CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR RuntimeDllPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledRuntimeInformationStart())
        return ERROR_SUCCESS;

    size_t size = 153;
    BYTE stackBuffer[153];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!CommandLine) { CommandLine = W("NULL"); }
    if (!RuntimeDllPath) { RuntimeDllPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Sku, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BclQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMajorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMMinorVersion, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMBuildNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VMQfeNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(StartupMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CommandLine, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(*ComObjectGuid, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RuntimeDllPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventRuntimeInformationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIncreaseMemoryPressure(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIncreaseMemoryPressure);
}

extern "C" ULONG EventPipeWriteEventIncreaseMemoryPressure(
    const unsigned __int64 BytesAllocated,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIncreaseMemoryPressure())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(BytesAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIncreaseMemoryPressure, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDecreaseMemoryPressure(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDecreaseMemoryPressure);
}

extern "C" ULONG EventPipeWriteEventDecreaseMemoryPressure(
    const unsigned __int64 BytesFreed,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDecreaseMemoryPressure())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(BytesFreed, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventDecreaseMemoryPressure, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCMarkWithType(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCMarkWithType);
}

extern "C" ULONG EventPipeWriteEventGCMarkWithType(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    const unsigned int Type,
    const unsigned __int64 Bytes,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCMarkWithType())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Bytes, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCMarkWithType, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCJoin_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCJoin_V2);
}

extern "C" ULONG EventPipeWriteEventGCJoin_V2(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType,
    const unsigned short ClrInstanceID,
    const unsigned int JoinID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCJoin_V2())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Heap, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinTime, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCJoin_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCPerHeapHistory_V3(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCPerHeapHistory_V3);
}

extern "C" ULONG EventPipeWriteEventGCPerHeapHistory_V3(
    const unsigned short ClrInstanceID,
    const void* FreeListAllocated,
    const void* FreeListRejected,
    const void* EndOfSegAllocated,
    const void* CondemnedAllocated,
    const void* PinnedAllocated,
    const void* PinnedAllocatedAdvance,
    const unsigned int RunningFreeListEfficiency,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1,
    const unsigned int CompactMechanisms,
    const unsigned int ExpandMechanisms,
    const unsigned int HeapIndex,
    const void* ExtraGen0Commit,
    const unsigned int Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCPerHeapHistory_V3())
        return ERROR_SUCCESS;

    size_t size = 118;
    BYTE stackBuffer[118];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FreeListAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FreeListRejected, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EndOfSegAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedAllocated, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PinnedAllocatedAdvance, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RunningFreeListEfficiency, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CompactMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExpandMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HeapIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ExtraGen0Commit, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCPerHeapHistory_V3, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGlobalHeapHistory_V2(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGlobalHeapHistory_V2);
}

extern "C" ULONG EventPipeWriteEventGCGlobalHeapHistory_V2(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGlobalHeapHistory_V2())
        return ERROR_SUCCESS;

    size_t size = 38;
    BYTE stackBuffer[38];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PauseMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryPressure, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGlobalHeapHistory_V2, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGlobalHeapHistory_V3(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGlobalHeapHistory_V3);
}

extern "C" ULONG EventPipeWriteEventGCGlobalHeapHistory_V3(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGlobalHeapHistory_V3())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PauseMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryPressure, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGlobalHeapHistory_V3, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGlobalHeapHistory_V4(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGlobalHeapHistory_V4);
}

extern "C" ULONG EventPipeWriteEventGCGlobalHeapHistory_V4(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    const unsigned int PauseMode,
    const unsigned int MemoryPressure,
    const unsigned int CondemnReasons0,
    const unsigned int CondemnReasons1,
    const unsigned int Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGlobalHeapHistory_V4())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PauseMode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryPressure, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons0, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnReasons1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGlobalHeapHistory_V4, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGenAwareBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGenAwareBegin);
}

extern "C" ULONG EventPipeWriteEventGenAwareBegin(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGenAwareBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGenAwareBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGenAwareEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGenAwareEnd);
}

extern "C" ULONG EventPipeWriteEventGenAwareEnd(
    const unsigned int Count,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGenAwareEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGenAwareEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCLOHCompact(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCLOHCompact);
}

extern "C" ULONG EventPipeWriteEventGCLOHCompact(
    const unsigned short ClrInstanceID,
    const unsigned short Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCLOHCompact())
        return ERROR_SUCCESS;

    size_t size = 36;
    BYTE stackBuffer[36];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCLOHCompact, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFitBucketInfo(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFitBucketInfo);
}

extern "C" ULONG EventPipeWriteEventGCFitBucketInfo(
    const unsigned short ClrInstanceID,
    const unsigned short BucketKind,
    const unsigned __int64 TotalSize,
    const unsigned short Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFitBucketInfo())
        return ERROR_SUCCESS;

    size_t size = 46;
    BYTE stackBuffer[46];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BucketKind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Count, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Values, (int)Values_ElementSize * (int)Count, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFitBucketInfo, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDebugIPCEventStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDebugIPCEventStart);
}

extern "C" ULONG EventPipeWriteEventDebugIPCEventStart(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDebugIPCEventStart())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDebugIPCEventStart, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDebugIPCEventEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDebugIPCEventEnd);
}

extern "C" ULONG EventPipeWriteEventDebugIPCEventEnd(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDebugIPCEventEnd())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDebugIPCEventEnd, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDebugExceptionProcessingStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDebugExceptionProcessingStart);
}

extern "C" ULONG EventPipeWriteEventDebugExceptionProcessingStart(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDebugExceptionProcessingStart())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDebugExceptionProcessingStart, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledDebugExceptionProcessingEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventDebugExceptionProcessingEnd);
}

extern "C" ULONG EventPipeWriteEventDebugExceptionProcessingEnd(    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledDebugExceptionProcessingEnd())
        return ERROR_SUCCESS;
    EventPipeAdapter::WriteEvent(EventPipeEventDebugExceptionProcessingEnd, (BYTE*) nullptr, 0, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCodeSymbols(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCodeSymbols);
}

extern "C" ULONG EventPipeWriteEventCodeSymbols(
    const unsigned __int64 ModuleId,
    const unsigned short TotalChunks,
    const unsigned short ChunkNumber,
    const unsigned int ChunkLength,
    const BYTE* Chunk,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCodeSymbols())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ModuleId, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TotalChunks, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ChunkNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ChunkLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Chunk, sizeof(const BYTE) * (int)ChunkLength, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCodeSymbols, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEventSource(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEventSource);
}

extern "C" ULONG EventPipeWriteEventEventSource(
    const signed int EventID,
    PCWSTR EventName,
    PCWSTR EventSourceName,
    PCWSTR Payload,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEventSource())
        return ERROR_SUCCESS;

    size_t size = 196;
    BYTE stackBuffer[196];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!EventName) { EventName = W("NULL"); }
    if (!EventSourceName) { EventSourceName = W("NULL"); }
    if (!Payload) { Payload = W("NULL"); }
    success &= WriteToBuffer(EventID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EventName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(EventSourceName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Payload, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEventSource, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationSettings(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationSettings);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationSettings(
    const unsigned short ClrInstanceID,
    const unsigned int Flags,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationSettings())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Flags, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationSettings, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationPause(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationPause);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationPause(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationPause())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationPause, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationResume(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationResume);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationResume(
    const unsigned short ClrInstanceID,
    const unsigned int NewMethodCount,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationResume())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewMethodCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationResume, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationBackgroundJitStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationBackgroundJitStart);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationBackgroundJitStart(
    const unsigned short ClrInstanceID,
    const unsigned int PendingMethodCount,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationBackgroundJitStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PendingMethodCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationBackgroundJitStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTieredCompilationBackgroundJitStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTieredCompilationBackgroundJitStop);
}

extern "C" ULONG EventPipeWriteEventTieredCompilationBackgroundJitStop(
    const unsigned short ClrInstanceID,
    const unsigned int PendingMethodCount,
    const unsigned int JittedMethodCount,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTieredCompilationBackgroundJitStop())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PendingMethodCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JittedMethodCount, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTieredCompilationBackgroundJitStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoadStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoadStart);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoadStart(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR AssemblyPath,
    PCWSTR RequestingAssembly,
    PCWSTR AssemblyLoadContext,
    PCWSTR RequestingAssemblyLoadContext,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoadStart())
        return ERROR_SUCCESS;

    size_t size = 322;
    BYTE stackBuffer[322];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!AssemblyPath) { AssemblyPath = W("NULL"); }
    if (!RequestingAssembly) { RequestingAssembly = W("NULL"); }
    if (!AssemblyLoadContext) { AssemblyLoadContext = W("NULL"); }
    if (!RequestingAssemblyLoadContext) { RequestingAssemblyLoadContext = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssembly, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssemblyLoadContext, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoadStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoadStop(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoadStop);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoadStop(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR AssemblyPath,
    PCWSTR RequestingAssembly,
    PCWSTR AssemblyLoadContext,
    PCWSTR RequestingAssemblyLoadContext,
    const BOOL Success,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    const BOOL Cached,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoadStop())
        return ERROR_SUCCESS;

    size_t size = 458;
    BYTE stackBuffer[458];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!AssemblyPath) { AssemblyPath = W("NULL"); }
    if (!RequestingAssembly) { RequestingAssembly = W("NULL"); }
    if (!AssemblyLoadContext) { AssemblyLoadContext = W("NULL"); }
    if (!RequestingAssemblyLoadContext) { RequestingAssemblyLoadContext = W("NULL"); }
    if (!ResultAssemblyName) { ResultAssemblyName = W("NULL"); }
    if (!ResultAssemblyPath) { ResultAssemblyPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssembly, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Success, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Cached, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoadStop, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledResolutionAttempted(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventResolutionAttempted);
}

extern "C" ULONG EventPipeWriteEventResolutionAttempted(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    const unsigned short Stage,
    PCWSTR AssemblyLoadContext,
    const unsigned short Result,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    PCWSTR ErrorMessage,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledResolutionAttempted())
        return ERROR_SUCCESS;

    size_t size = 326;
    BYTE stackBuffer[326];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!AssemblyLoadContext) { AssemblyLoadContext = W("NULL"); }
    if (!ResultAssemblyName) { ResultAssemblyName = W("NULL"); }
    if (!ResultAssemblyPath) { ResultAssemblyPath = W("NULL"); }
    if (!ErrorMessage) { ErrorMessage = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Stage, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Result, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorMessage, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventResolutionAttempted, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoadContextResolvingHandlerInvoked(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoadContextResolvingHandlerInvoked);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoadContextResolvingHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR HandlerName,
    PCWSTR AssemblyLoadContext,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoadContextResolvingHandlerInvoked())
        return ERROR_SUCCESS;

    size_t size = 322;
    BYTE stackBuffer[322];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!HandlerName) { HandlerName = W("NULL"); }
    if (!AssemblyLoadContext) { AssemblyLoadContext = W("NULL"); }
    if (!ResultAssemblyName) { ResultAssemblyName = W("NULL"); }
    if (!ResultAssemblyPath) { ResultAssemblyPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HandlerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyLoadContext, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoadContextResolvingHandlerInvoked, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAppDomainAssemblyResolveHandlerInvoked(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAppDomainAssemblyResolveHandlerInvoked);
}

extern "C" ULONG EventPipeWriteEventAppDomainAssemblyResolveHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    PCWSTR HandlerName,
    PCWSTR ResultAssemblyName,
    PCWSTR ResultAssemblyPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAppDomainAssemblyResolveHandlerInvoked())
        return ERROR_SUCCESS;

    size_t size = 258;
    BYTE stackBuffer[258];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!HandlerName) { HandlerName = W("NULL"); }
    if (!ResultAssemblyName) { ResultAssemblyName = W("NULL"); }
    if (!ResultAssemblyPath) { ResultAssemblyPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(HandlerName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ResultAssemblyPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAppDomainAssemblyResolveHandlerInvoked, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAssemblyLoadFromResolveHandlerInvoked(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAssemblyLoadFromResolveHandlerInvoked);
}

extern "C" ULONG EventPipeWriteEventAssemblyLoadFromResolveHandlerInvoked(
    const unsigned short ClrInstanceID,
    PCWSTR AssemblyName,
    const BOOL IsTrackedLoad,
    PCWSTR RequestingAssemblyPath,
    PCWSTR ComputedRequestedAssemblyPath,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAssemblyLoadFromResolveHandlerInvoked())
        return ERROR_SUCCESS;

    size_t size = 198;
    BYTE stackBuffer[198];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    if (!RequestingAssemblyPath) { RequestingAssemblyPath = W("NULL"); }
    if (!ComputedRequestedAssemblyPath) { ComputedRequestedAssemblyPath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTrackedLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestingAssemblyPath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ComputedRequestedAssemblyPath, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAssemblyLoadFromResolveHandlerInvoked, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledKnownPathProbed(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventKnownPathProbed);
}

extern "C" ULONG EventPipeWriteEventKnownPathProbed(
    const unsigned short ClrInstanceID,
    PCWSTR FilePath,
    const unsigned short Source,
    const signed int Result,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledKnownPathProbed())
        return ERROR_SUCCESS;

    size_t size = 72;
    BYTE stackBuffer[72];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FilePath) { FilePath = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FilePath, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Source, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Result, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventKnownPathProbed, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledJitInstrumentationData(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventJitInstrumentationData);
}

extern "C" ULONG EventPipeWriteEventJitInstrumentationData(
    const unsigned short ClrInstanceID,
    const unsigned int MethodFlags,
    const unsigned int DataSize,
    const unsigned __int64 MethodID,
    const BYTE* Data,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledJitInstrumentationData())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventJitInstrumentationData, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledJitInstrumentationDataVerbose(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventJitInstrumentationDataVerbose);
}

extern "C" ULONG EventPipeWriteEventJitInstrumentationDataVerbose(
    const unsigned short ClrInstanceID,
    const unsigned int MethodFlags,
    const unsigned int DataSize,
    const unsigned __int64 MethodID,
    const unsigned __int64 ModuleID,
    const unsigned int MethodToken,
    PCWSTR MethodNamespace,
    PCWSTR MethodName,
    PCWSTR MethodSignature,
    const BYTE* Data,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledJitInstrumentationDataVerbose())
        return ERROR_SUCCESS;

    size_t size = 223;
    BYTE stackBuffer[223];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!MethodNamespace) { MethodNamespace = W("NULL"); }
    if (!MethodName) { MethodName = W("NULL"); }
    if (!MethodSignature) { MethodSignature = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodFlags, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodToken, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodNamespace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodSignature, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventJitInstrumentationDataVerbose, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledProfilerMessage(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventProfilerMessage);
}

extern "C" ULONG EventPipeWriteEventProfilerMessage(
    const unsigned short ClrInstanceID,
    PCWSTR Message,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledProfilerMessage())
        return ERROR_SUCCESS;

    size_t size = 66;
    BYTE stackBuffer[66];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Message) { Message = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Message, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventProfilerMessage, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecutionCheckpoint(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecutionCheckpoint);
}

extern "C" ULONG EventPipeWriteEventExecutionCheckpoint(
    const unsigned short ClrInstanceID,
    PCWSTR Name,
    const __int64 Timestamp,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecutionCheckpoint())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Name) { Name = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Name, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Timestamp, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExecutionCheckpoint, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

extern "C" void InitDotNETRuntime(void);

extern "C" void InitDotNETRuntime(void)
{
    EventPipeProviderDotNETRuntime = EventPipeAdapter::CreateProvider(SL(DotNETRuntimeName), reinterpret_cast<EventPipeCallback>(EventPipeEtwCallbackDotNETRuntime));
    EventPipeEventGCStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,1,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,1,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCStart_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,1,1,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,2,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,2,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCRestartEEEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,3,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCRestartEEEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,3,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCHeapStats = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,4,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCHeapStats_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,4,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCHeapStats_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,4,1,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCCreateSegment = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,5,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCCreateSegment_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,5,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFreeSegment = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,6,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFreeSegment_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,6,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCRestartEEBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,7,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCRestartEEBegin_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,7,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCSuspendEEEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,8,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCSuspendEEEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,8,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCSuspendEEBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,9,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCSuspendEEBegin_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,9,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCAllocationTick = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,10,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCAllocationTick_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,10,1,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCAllocationTick_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,10,1,2,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCAllocationTick_V3 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,10,1,3,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCAllocationTick_V4 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,10,1,4,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCCreateConcurrentThread = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,11,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCCreateConcurrentThread_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,11,65537,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCTerminateConcurrentThread = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,12,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCTerminateConcurrentThread_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,12,65537,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFinalizersEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,13,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFinalizersEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,13,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFinalizersBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,14,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCFinalizersBegin_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,14,1,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventBulkType = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,15,524288,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkRootEdge = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,16,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkRootConditionalWeakTableElementEdge = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,17,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkNode = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,18,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkEdge = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,19,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCSampledObjectAllocationHigh = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,20,2097152,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCBulkSurvivingObjectRanges = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,21,4194304,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkMovedObjectRanges = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,22,4194304,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCGenerationRange = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,23,4194304,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCMarkStackRoots = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,25,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCMarkFinalizeQueueRoots = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,26,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCMarkHandles = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,27,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCMarkOlderGenerationRoots = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,28,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventFinalizeObject = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,29,1,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventSetGCHandle = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,30,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDestroyGCHandle = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,31,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCSampledObjectAllocationLow = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,32,33554432,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPinObjectAtGCTime = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,33,1,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventGCTriggered = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,35,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCBulkRootCCW = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,36,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkRCW = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,37,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCBulkRootStaticVar = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,38,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCDynamicEvent = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,39,66060291,0,EP_EVENT_LEVEL_LOGALWAYS,true);
    EventPipeEventWorkerThreadCreate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,40,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventWorkerThreadTerminate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,41,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventWorkerThreadRetire = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,42,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventWorkerThreadUnretire = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,43,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadCreate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,44,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadCreate_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,44,65536,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadTerminate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,45,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadTerminate_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,45,65536,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadRetire = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,46,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadRetire_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,46,65536,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadUnretire = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,47,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIOThreadUnretire_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,47,65536,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadpoolSuspensionSuspendThread = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,48,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadpoolSuspensionResumeThread = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,49,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadPoolWorkerThreadStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,50,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,51,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadRetirementStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,52,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadRetirementStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,53,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadAdjustmentSample = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,54,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadAdjustmentAdjustment = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,55,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolWorkerThreadAdjustmentStats = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,56,65536,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolWorkerThreadWait = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,57,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventYieldProcessorMeasurement = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,58,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventThreadPoolMinMaxThreads = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,59,65536,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadPoolWorkingThreadCount = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,60,65536,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolEnqueue = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,61,2147549184,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolDequeue = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,62,2147549184,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolIOEnqueue = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,63,2147549184,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolIODequeue = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,64,2147549184,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadPoolIOPack = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,65,65536,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventThreadCreating = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,70,2147549184,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadRunning = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,71,2147549184,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDetails = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,72,274877906944,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventTypeLoadStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,73,549755813888,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTypeLoadStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,74,549755813888,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionThrown = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,80,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionThrown_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,80,8589967360,1,EP_EVENT_LEVEL_ERROR,true);
    EventPipeEventExceptionCatchStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,250,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionCatchStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,251,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionFinallyStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,252,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionFinallyStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,253,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionFilterStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,254,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionFilterStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,255,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExceptionThrownStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,256,32768,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventContention = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,81,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventContentionStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,81,16384,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventContentionStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,91,16384,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventContentionStop_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,91,16384,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventCLRStackWalk = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,82,1073741824,0,EP_EVENT_LEVEL_LOGALWAYS,false);
    EventPipeEventAppDomainMemAllocated = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,83,2048,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainMemSurvived = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,84,2048,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadCreated = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,85,67584,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadTerminated = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,86,67584,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventThreadDomainEnter = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,87,67584,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventILStubGenerated = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,88,8192,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventILStubCacheHit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,89,8192,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCStartCompleteV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,135,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDCEndCompleteV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,136,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,137,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEndV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,138,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCStartVerboseV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,139,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodDCEndVerboseV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,140,48,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,141,48,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodLoad_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,141,48,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodLoad_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,141,48,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventR2RGetEntryPoint = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,159,137438953472,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventR2RGetEntryPointStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,160,137438953472,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodUnload = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,142,48,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodUnload_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,142,48,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodUnload_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,142,48,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodLoadVerbose = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,143,48,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodLoadVerbose_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,143,48,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodLoadVerbose_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,143,48,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodUnloadVerbose = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,144,48,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodUnloadVerbose_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,144,48,1,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodUnloadVerbose_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,144,48,2,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventMethodJittingStarted = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,145,16,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodJittingStarted_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,145,16,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodJitMemoryAllocatedForCode = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,146,16,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodJitInliningSucceeded = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,185,4096,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventMethodJitInliningFailedAnsi = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,186,4096,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodJitTailCallSucceeded = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,188,4096,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventMethodJitTailCallFailedAnsi = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,189,4096,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodILToNativeMap = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,190,131072,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodILToNativeMap_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,190,131072,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMethodJitTailCallFailed = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,191,4096,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventMethodJitInliningFailed = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,192,4096,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventModuleDCStartV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,149,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleDCEndV2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,150,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDomainModuleLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,151,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDomainModuleLoad_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,151,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,152,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleLoad_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,152,536870920,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleLoad_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,152,536870920,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleUnload = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,153,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleUnload_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,153,536870920,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleUnload_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,153,536870920,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,154,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyLoad_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,154,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyUnload = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,155,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyUnload_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,155,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,156,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainLoad_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,156,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainUnload = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,157,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainUnload_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,157,8,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleRangeLoad = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,158,536870912,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventStrongNameVerificationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,181,1024,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventStrongNameVerificationStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,181,1024,1,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventStrongNameVerificationStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,182,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventStrongNameVerificationStop_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,182,1024,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAuthenticodeVerificationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,183,1024,0,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventAuthenticodeVerificationStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,183,1024,1,EP_EVENT_LEVEL_VERBOSE,false);
    EventPipeEventAuthenticodeVerificationStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,184,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAuthenticodeVerificationStop_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,184,1024,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventRuntimeInformationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,187,0,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventIncreaseMemoryPressure = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,200,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventDecreaseMemoryPressure = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,201,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCMarkWithType = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,202,1,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCJoin_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,203,1,2,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCPerHeapHistory_V3 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,204,1,3,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventGCGlobalHeapHistory_V2 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,205,1,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCGlobalHeapHistory_V3 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,205,1,3,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCGlobalHeapHistory_V4 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,205,1,4,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGenAwareBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,206,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGenAwareEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,207,1048576,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCLOHCompact = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,208,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCFitBucketInfo = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,209,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventDebugIPCEventStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,240,4294967296,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDebugIPCEventEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,241,4294967296,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDebugExceptionProcessingStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,242,4294967296,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventDebugExceptionProcessingEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,243,4294967296,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCodeSymbols = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,260,17179869184,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventEventSource = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,270,34359738368,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTieredCompilationSettings = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,280,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventTieredCompilationPause = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,281,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventTieredCompilationResume = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,282,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventTieredCompilationBackgroundJitStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,283,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventTieredCompilationBackgroundJitStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,284,68719476736,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventAssemblyLoadStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,290,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyLoadStop = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,291,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventResolutionAttempted = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,292,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyLoadContextResolvingHandlerInvoked = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,293,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAppDomainAssemblyResolveHandlerInvoked = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,294,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAssemblyLoadFromResolveHandlerInvoked = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,295,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventKnownPathProbed = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,296,4,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventJitInstrumentationData = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,297,1099511627776,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventJitInstrumentationDataVerbose = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,298,1099511627776,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventProfilerMessage = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,299,2199023255552,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExecutionCheckpoint = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntime,300,536870912,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
}
