// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genEventPipe.py

******************************************************************/

#include <common.h>
#include "eventpipeadapter.h"

#if defined(TARGET_UNIX)
#define wcslen PAL_wcslen
#endif

bool ResizeBuffer(BYTE *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

const WCHAR* DotNETRuntimePrivateName = W("Microsoft-Windows-DotNETRuntimePrivate");
EventPipeProvider *EventPipeProviderDotNETRuntimePrivate = nullptr;
EventPipeEvent *EventPipeEventGCDecision = nullptr;
EventPipeEvent *EventPipeEventGCDecision_V1 = nullptr;
EventPipeEvent *EventPipeEventGCSettings = nullptr;
EventPipeEvent *EventPipeEventGCSettings_V1 = nullptr;
EventPipeEvent *EventPipeEventGCOptimized = nullptr;
EventPipeEvent *EventPipeEventGCOptimized_V1 = nullptr;
EventPipeEvent *EventPipeEventGCPerHeapHistory = nullptr;
EventPipeEvent *EventPipeEventGCPerHeapHistory_V1 = nullptr;
EventPipeEvent *EventPipeEventGCGlobalHeapHistory = nullptr;
EventPipeEvent *EventPipeEventGCGlobalHeapHistory_V1 = nullptr;
EventPipeEvent *EventPipeEventGCJoin = nullptr;
EventPipeEvent *EventPipeEventGCJoin_V1 = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkStackRoots = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkStackRoots_V1 = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkFinalizeQueueRoots = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkFinalizeQueueRoots_V1 = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkHandles = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkHandles_V1 = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkCards = nullptr;
EventPipeEvent *EventPipeEventPrvGCMarkCards_V1 = nullptr;
EventPipeEvent *EventPipeEventBGCBegin = nullptr;
EventPipeEvent *EventPipeEventBGC1stNonConEnd = nullptr;
EventPipeEvent *EventPipeEventBGC1stConEnd = nullptr;
EventPipeEvent *EventPipeEventBGC2ndNonConBegin = nullptr;
EventPipeEvent *EventPipeEventBGC2ndNonConEnd = nullptr;
EventPipeEvent *EventPipeEventBGC2ndConBegin = nullptr;
EventPipeEvent *EventPipeEventBGC2ndConEnd = nullptr;
EventPipeEvent *EventPipeEventBGCPlanEnd = nullptr;
EventPipeEvent *EventPipeEventBGCSweepEnd = nullptr;
EventPipeEvent *EventPipeEventBGCDrainMark = nullptr;
EventPipeEvent *EventPipeEventBGCRevisit = nullptr;
EventPipeEvent *EventPipeEventBGCOverflow = nullptr;
EventPipeEvent *EventPipeEventBGCOverflow_V1 = nullptr;
EventPipeEvent *EventPipeEventBGCAllocWaitBegin = nullptr;
EventPipeEvent *EventPipeEventBGCAllocWaitEnd = nullptr;
EventPipeEvent *EventPipeEventGCFullNotify = nullptr;
EventPipeEvent *EventPipeEventGCFullNotify_V1 = nullptr;
EventPipeEvent *EventPipeEventBGC1stSweepEnd = nullptr;
EventPipeEvent *EventPipeEventEEStartupStart = nullptr;
EventPipeEvent *EventPipeEventEEStartupStart_V1 = nullptr;
EventPipeEvent *EventPipeEventEEStartupEnd = nullptr;
EventPipeEvent *EventPipeEventEEStartupEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventEEConfigSetup = nullptr;
EventPipeEvent *EventPipeEventEEConfigSetup_V1 = nullptr;
EventPipeEvent *EventPipeEventEEConfigSetupEnd = nullptr;
EventPipeEvent *EventPipeEventEEConfigSetupEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventLdSysBases = nullptr;
EventPipeEvent *EventPipeEventLdSysBases_V1 = nullptr;
EventPipeEvent *EventPipeEventLdSysBasesEnd = nullptr;
EventPipeEvent *EventPipeEventLdSysBasesEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventExecExe = nullptr;
EventPipeEvent *EventPipeEventExecExe_V1 = nullptr;
EventPipeEvent *EventPipeEventExecExeEnd = nullptr;
EventPipeEvent *EventPipeEventExecExeEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventMain = nullptr;
EventPipeEvent *EventPipeEventMain_V1 = nullptr;
EventPipeEvent *EventPipeEventMainEnd = nullptr;
EventPipeEvent *EventPipeEventMainEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventApplyPolicyStart = nullptr;
EventPipeEvent *EventPipeEventApplyPolicyStart_V1 = nullptr;
EventPipeEvent *EventPipeEventApplyPolicyEnd = nullptr;
EventPipeEvent *EventPipeEventApplyPolicyEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventLdLibShFolder = nullptr;
EventPipeEvent *EventPipeEventLdLibShFolder_V1 = nullptr;
EventPipeEvent *EventPipeEventLdLibShFolderEnd = nullptr;
EventPipeEvent *EventPipeEventLdLibShFolderEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventPrestubWorker = nullptr;
EventPipeEvent *EventPipeEventPrestubWorker_V1 = nullptr;
EventPipeEvent *EventPipeEventPrestubWorkerEnd = nullptr;
EventPipeEvent *EventPipeEventPrestubWorkerEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventGetInstallationStart = nullptr;
EventPipeEvent *EventPipeEventGetInstallationStart_V1 = nullptr;
EventPipeEvent *EventPipeEventGetInstallationEnd = nullptr;
EventPipeEvent *EventPipeEventGetInstallationEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventOpenHModule = nullptr;
EventPipeEvent *EventPipeEventOpenHModule_V1 = nullptr;
EventPipeEvent *EventPipeEventOpenHModuleEnd = nullptr;
EventPipeEvent *EventPipeEventOpenHModuleEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventExplicitBindStart = nullptr;
EventPipeEvent *EventPipeEventExplicitBindStart_V1 = nullptr;
EventPipeEvent *EventPipeEventExplicitBindEnd = nullptr;
EventPipeEvent *EventPipeEventExplicitBindEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventParseXml = nullptr;
EventPipeEvent *EventPipeEventParseXml_V1 = nullptr;
EventPipeEvent *EventPipeEventParseXmlEnd = nullptr;
EventPipeEvent *EventPipeEventParseXmlEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventInitDefaultDomain = nullptr;
EventPipeEvent *EventPipeEventInitDefaultDomain_V1 = nullptr;
EventPipeEvent *EventPipeEventInitDefaultDomainEnd = nullptr;
EventPipeEvent *EventPipeEventInitDefaultDomainEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventInitSecurity = nullptr;
EventPipeEvent *EventPipeEventInitSecurity_V1 = nullptr;
EventPipeEvent *EventPipeEventInitSecurityEnd = nullptr;
EventPipeEvent *EventPipeEventInitSecurityEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventAllowBindingRedirs = nullptr;
EventPipeEvent *EventPipeEventAllowBindingRedirs_V1 = nullptr;
EventPipeEvent *EventPipeEventAllowBindingRedirsEnd = nullptr;
EventPipeEvent *EventPipeEventAllowBindingRedirsEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventEEConfigSync = nullptr;
EventPipeEvent *EventPipeEventEEConfigSync_V1 = nullptr;
EventPipeEvent *EventPipeEventEEConfigSyncEnd = nullptr;
EventPipeEvent *EventPipeEventEEConfigSyncEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionBinding = nullptr;
EventPipeEvent *EventPipeEventFusionBinding_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionBindingEnd = nullptr;
EventPipeEvent *EventPipeEventFusionBindingEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventLoaderCatchCall = nullptr;
EventPipeEvent *EventPipeEventLoaderCatchCall_V1 = nullptr;
EventPipeEvent *EventPipeEventLoaderCatchCallEnd = nullptr;
EventPipeEvent *EventPipeEventLoaderCatchCallEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionInit = nullptr;
EventPipeEvent *EventPipeEventFusionInit_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionInitEnd = nullptr;
EventPipeEvent *EventPipeEventFusionInitEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionAppCtx = nullptr;
EventPipeEvent *EventPipeEventFusionAppCtx_V1 = nullptr;
EventPipeEvent *EventPipeEventFusionAppCtxEnd = nullptr;
EventPipeEvent *EventPipeEventFusionAppCtxEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventFusion2EE = nullptr;
EventPipeEvent *EventPipeEventFusion2EE_V1 = nullptr;
EventPipeEvent *EventPipeEventFusion2EEEnd = nullptr;
EventPipeEvent *EventPipeEventFusion2EEEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventSecurityCatchCall = nullptr;
EventPipeEvent *EventPipeEventSecurityCatchCall_V1 = nullptr;
EventPipeEvent *EventPipeEventSecurityCatchCallEnd = nullptr;
EventPipeEvent *EventPipeEventSecurityCatchCallEnd_V1 = nullptr;
EventPipeEvent *EventPipeEventCLRStackWalkPrivate = nullptr;
EventPipeEvent *EventPipeEventModuleRangeLoadPrivate = nullptr;
EventPipeEvent *EventPipeEventBindingPolicyPhaseStart = nullptr;
EventPipeEvent *EventPipeEventBindingPolicyPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventBindingNgenPhaseStart = nullptr;
EventPipeEvent *EventPipeEventBindingNgenPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventBindingLookupAndProbingPhaseStart = nullptr;
EventPipeEvent *EventPipeEventBindingLookupAndProbingPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventLoaderPhaseStart = nullptr;
EventPipeEvent *EventPipeEventLoaderPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventBindingPhaseStart = nullptr;
EventPipeEvent *EventPipeEventBindingPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventBindingDownloadPhaseStart = nullptr;
EventPipeEvent *EventPipeEventBindingDownloadPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventLoaderAssemblyInitPhaseStart = nullptr;
EventPipeEvent *EventPipeEventLoaderAssemblyInitPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventLoaderMappingPhaseStart = nullptr;
EventPipeEvent *EventPipeEventLoaderMappingPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventLoaderDeliverEventsPhaseStart = nullptr;
EventPipeEvent *EventPipeEventLoaderDeliverEventsPhaseEnd = nullptr;
EventPipeEvent *EventPipeEventEvidenceGenerated = nullptr;
EventPipeEvent *EventPipeEventModuleTransparencyComputationStart = nullptr;
EventPipeEvent *EventPipeEventModuleTransparencyComputationEnd = nullptr;
EventPipeEvent *EventPipeEventTypeTransparencyComputationStart = nullptr;
EventPipeEvent *EventPipeEventTypeTransparencyComputationEnd = nullptr;
EventPipeEvent *EventPipeEventMethodTransparencyComputationStart = nullptr;
EventPipeEvent *EventPipeEventMethodTransparencyComputationEnd = nullptr;
EventPipeEvent *EventPipeEventFieldTransparencyComputationStart = nullptr;
EventPipeEvent *EventPipeEventFieldTransparencyComputationEnd = nullptr;
EventPipeEvent *EventPipeEventTokenTransparencyComputationStart = nullptr;
EventPipeEvent *EventPipeEventTokenTransparencyComputationEnd = nullptr;
EventPipeEvent *EventPipeEventNgenBindEvent = nullptr;
EventPipeEvent *EventPipeEventJittedMethodRichDebugInfo = nullptr;
EventPipeEvent *EventPipeEventFailFast = nullptr;
EventPipeEvent *EventPipeEventPrvFinalizeObject = nullptr;
EventPipeEvent *EventPipeEventCCWRefCountChangeAnsi = nullptr;
EventPipeEvent *EventPipeEventPrvSetGCHandle = nullptr;
EventPipeEvent *EventPipeEventPrvDestroyGCHandle = nullptr;
EventPipeEvent *EventPipeEventFusionMessageEvent = nullptr;
EventPipeEvent *EventPipeEventFusionErrorCodeEvent = nullptr;
EventPipeEvent *EventPipeEventPinPlugAtGCTime = nullptr;
EventPipeEvent *EventPipeEventCCWRefCountChange = nullptr;
EventPipeEvent *EventPipeEventAllocRequest = nullptr;
EventPipeEvent *EventPipeEventMulticoreJit = nullptr;
EventPipeEvent *EventPipeEventMulticoreJitMethodCodeReturned = nullptr;
EventPipeEvent *EventPipeEventIInspectableRuntimeClassName = nullptr;
EventPipeEvent *EventPipeEventWinRTUnbox = nullptr;
EventPipeEvent *EventPipeEventCreateRCW = nullptr;
EventPipeEvent *EventPipeEventRCWVariance = nullptr;
EventPipeEvent *EventPipeEventRCWIEnumerableCasting = nullptr;
EventPipeEvent *EventPipeEventCreateCCW = nullptr;
EventPipeEvent *EventPipeEventCCWVariance = nullptr;
EventPipeEvent *EventPipeEventObjectVariantMarshallingToNative = nullptr;
EventPipeEvent *EventPipeEventGetTypeFromGUID = nullptr;
EventPipeEvent *EventPipeEventGetTypeFromProgID = nullptr;
EventPipeEvent *EventPipeEventConvertToCallbackEtw = nullptr;
EventPipeEvent *EventPipeEventBeginCreateManagedReference = nullptr;
EventPipeEvent *EventPipeEventEndCreateManagedReference = nullptr;
EventPipeEvent *EventPipeEventObjectVariantMarshallingToManaged = nullptr;

BOOL EventPipeEventEnabledGCDecision(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCDecision);
}

extern "C" ULONG EventPipeWriteEventGCDecision(
    const BOOL DoCompact,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCDecision())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(DoCompact, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCDecision, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCDecision_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCDecision_V1);
}

extern "C" ULONG EventPipeWriteEventGCDecision_V1(
    const BOOL DoCompact,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCDecision_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(DoCompact, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCDecision_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSettings(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSettings);
}

extern "C" ULONG EventPipeWriteEventGCSettings(
    const unsigned __int64 SegmentSize,
    const unsigned __int64 LargeObjectSegmentSize,
    const BOOL ServerGC,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSettings())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(SegmentSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LargeObjectSegmentSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ServerGC, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSettings, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCSettings_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCSettings_V1);
}

extern "C" ULONG EventPipeWriteEventGCSettings_V1(
    const unsigned __int64 SegmentSize,
    const unsigned __int64 LargeObjectSegmentSize,
    const BOOL ServerGC,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCSettings_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(SegmentSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LargeObjectSegmentSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ServerGC, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCSettings_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCOptimized(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCOptimized);
}

extern "C" ULONG EventPipeWriteEventGCOptimized(
    const unsigned __int64 DesiredAllocation,
    const unsigned __int64 NewAllocation,
    const unsigned int GenerationNumber,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCOptimized())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(DesiredAllocation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewAllocation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationNumber, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCOptimized, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCOptimized_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCOptimized_V1);
}

extern "C" ULONG EventPipeWriteEventGCOptimized_V1(
    const unsigned __int64 DesiredAllocation,
    const unsigned __int64 NewAllocation,
    const unsigned int GenerationNumber,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCOptimized_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(DesiredAllocation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewAllocation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenerationNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCOptimized_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCPerHeapHistory(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCPerHeapHistory);
}

extern "C" ULONG EventPipeWriteEventGCPerHeapHistory(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCPerHeapHistory())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventGCPerHeapHistory, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCPerHeapHistory_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCPerHeapHistory_V1);
}

extern "C" ULONG EventPipeWriteEventGCPerHeapHistory_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCPerHeapHistory_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCPerHeapHistory_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGlobalHeapHistory(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGlobalHeapHistory);
}

extern "C" ULONG EventPipeWriteEventGCGlobalHeapHistory(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGlobalHeapHistory())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGlobalHeapHistory, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCGlobalHeapHistory_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCGlobalHeapHistory_V1);
}

extern "C" ULONG EventPipeWriteEventGCGlobalHeapHistory_V1(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCGlobalHeapHistory_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(FinalYoungestDesired, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NumHeaps, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(CondemnedGeneration, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Gen0ReductionCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GlobalMechanisms, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCGlobalHeapHistory_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCJoin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCJoin);
}

extern "C" ULONG EventPipeWriteEventGCJoin(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCJoin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Heap, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinTime, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinType, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCJoin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCJoin_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCJoin_V1);
}

extern "C" ULONG EventPipeWriteEventGCJoin_V1(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCJoin_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Heap, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinTime, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(JoinType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCJoin_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkStackRoots(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkStackRoots);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkStackRoots(
    const unsigned int HeapNum,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkStackRoots())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkStackRoots, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkStackRoots_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkStackRoots_V1);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkStackRoots_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkStackRoots_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkStackRoots_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkFinalizeQueueRoots);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkFinalizeQueueRoots(
    const unsigned int HeapNum,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkFinalizeQueueRoots, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkFinalizeQueueRoots_V1);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkFinalizeQueueRoots_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkFinalizeQueueRoots_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkHandles(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkHandles);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkHandles(
    const unsigned int HeapNum,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkHandles())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkHandles, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkHandles_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkHandles_V1);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkHandles_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkHandles_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkHandles_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkCards(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkCards);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkCards(
    const unsigned int HeapNum,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkCards())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkCards, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvGCMarkCards_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvGCMarkCards_V1);
}

extern "C" ULONG EventPipeWriteEventPrvGCMarkCards_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvGCMarkCards_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HeapNum, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvGCMarkCards_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCBegin);
}

extern "C" ULONG EventPipeWriteEventBGCBegin(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC1stNonConEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC1stNonConEnd);
}

extern "C" ULONG EventPipeWriteEventBGC1stNonConEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC1stNonConEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC1stNonConEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC1stConEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC1stConEnd);
}

extern "C" ULONG EventPipeWriteEventBGC1stConEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC1stConEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC1stConEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC2ndNonConBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC2ndNonConBegin);
}

extern "C" ULONG EventPipeWriteEventBGC2ndNonConBegin(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC2ndNonConBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC2ndNonConBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC2ndNonConEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC2ndNonConEnd);
}

extern "C" ULONG EventPipeWriteEventBGC2ndNonConEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC2ndNonConEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC2ndNonConEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC2ndConBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC2ndConBegin);
}

extern "C" ULONG EventPipeWriteEventBGC2ndConBegin(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC2ndConBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC2ndConBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC2ndConEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC2ndConEnd);
}

extern "C" ULONG EventPipeWriteEventBGC2ndConEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC2ndConEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC2ndConEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCPlanEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCPlanEnd);
}

extern "C" ULONG EventPipeWriteEventBGCPlanEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCPlanEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCPlanEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCSweepEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCSweepEnd);
}

extern "C" ULONG EventPipeWriteEventBGCSweepEnd(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCSweepEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCSweepEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCDrainMark(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCDrainMark);
}

extern "C" ULONG EventPipeWriteEventBGCDrainMark(
    const unsigned __int64 Objects,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCDrainMark())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Objects, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCDrainMark, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCRevisit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCRevisit);
}

extern "C" ULONG EventPipeWriteEventBGCRevisit(
    const unsigned __int64 Pages,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCRevisit())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Pages, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Objects, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsLarge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCRevisit, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCOverflow(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCOverflow);
}

extern "C" ULONG EventPipeWriteEventBGCOverflow(
    const unsigned __int64 Min,
    const unsigned __int64 Max,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCOverflow())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Min, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Max, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Objects, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsLarge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCOverflow, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCOverflow_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCOverflow_V1);
}

extern "C" ULONG EventPipeWriteEventBGCOverflow_V1(
    const unsigned __int64 Min,
    const unsigned __int64 Max,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID,
    const unsigned int GenNumber,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCOverflow_V1())
        return ERROR_SUCCESS;

    size_t size = 34;
    BYTE stackBuffer[34];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Min, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Max, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Objects, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsLarge, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GenNumber, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCOverflow_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCAllocWaitBegin(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCAllocWaitBegin);
}

extern "C" ULONG EventPipeWriteEventBGCAllocWaitBegin(
    const unsigned int Reason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCAllocWaitBegin())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCAllocWaitBegin, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGCAllocWaitEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGCAllocWaitEnd);
}

extern "C" ULONG EventPipeWriteEventBGCAllocWaitEnd(
    const unsigned int Reason,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGCAllocWaitEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Reason, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGCAllocWaitEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFullNotify(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFullNotify);
}

extern "C" ULONG EventPipeWriteEventGCFullNotify(
    const unsigned int GenNumber,
    const unsigned int IsAlloc,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFullNotify())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAlloc, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFullNotify, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGCFullNotify_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGCFullNotify_V1);
}

extern "C" ULONG EventPipeWriteEventGCFullNotify_V1(
    const unsigned int GenNumber,
    const unsigned int IsAlloc,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGCFullNotify_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAlloc, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGCFullNotify_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBGC1stSweepEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBGC1stSweepEnd);
}

extern "C" ULONG EventPipeWriteEventBGC1stSweepEnd(
    const unsigned int GenNumber,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBGC1stSweepEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(GenNumber, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBGC1stSweepEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEStartupStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEStartupStart);
}

extern "C" ULONG EventPipeWriteEventEEStartupStart(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEStartupStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEStartupStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEStartupStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEStartupStart_V1);
}

extern "C" ULONG EventPipeWriteEventEEStartupStart_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEStartupStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEStartupStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEStartupEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEStartupEnd);
}

extern "C" ULONG EventPipeWriteEventEEStartupEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEStartupEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEStartupEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEStartupEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEStartupEnd_V1);
}

extern "C" ULONG EventPipeWriteEventEEStartupEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEStartupEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEStartupEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSetup(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSetup);
}

extern "C" ULONG EventPipeWriteEventEEConfigSetup(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSetup())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSetup, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSetup_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSetup_V1);
}

extern "C" ULONG EventPipeWriteEventEEConfigSetup_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSetup_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSetup_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSetupEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSetupEnd);
}

extern "C" ULONG EventPipeWriteEventEEConfigSetupEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSetupEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSetupEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSetupEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSetupEnd_V1);
}

extern "C" ULONG EventPipeWriteEventEEConfigSetupEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSetupEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSetupEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdSysBases(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdSysBases);
}

extern "C" ULONG EventPipeWriteEventLdSysBases(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdSysBases())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLdSysBases, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdSysBases_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdSysBases_V1);
}

extern "C" ULONG EventPipeWriteEventLdSysBases_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdSysBases_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLdSysBases_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdSysBasesEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdSysBasesEnd);
}

extern "C" ULONG EventPipeWriteEventLdSysBasesEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdSysBasesEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLdSysBasesEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdSysBasesEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdSysBasesEnd_V1);
}

extern "C" ULONG EventPipeWriteEventLdSysBasesEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdSysBasesEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLdSysBasesEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecExe(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecExe);
}

extern "C" ULONG EventPipeWriteEventExecExe(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecExe())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventExecExe, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecExe_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecExe_V1);
}

extern "C" ULONG EventPipeWriteEventExecExe_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecExe_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExecExe_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecExeEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecExeEnd);
}

extern "C" ULONG EventPipeWriteEventExecExeEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecExeEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventExecExeEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExecExeEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExecExeEnd_V1);
}

extern "C" ULONG EventPipeWriteEventExecExeEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExecExeEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExecExeEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMain(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMain);
}

extern "C" ULONG EventPipeWriteEventMain(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMain())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventMain, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMain_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMain_V1);
}

extern "C" ULONG EventPipeWriteEventMain_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMain_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMain_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMainEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMainEnd);
}

extern "C" ULONG EventPipeWriteEventMainEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMainEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventMainEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMainEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMainEnd_V1);
}

extern "C" ULONG EventPipeWriteEventMainEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMainEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMainEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledApplyPolicyStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventApplyPolicyStart);
}

extern "C" ULONG EventPipeWriteEventApplyPolicyStart(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledApplyPolicyStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventApplyPolicyStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledApplyPolicyStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventApplyPolicyStart_V1);
}

extern "C" ULONG EventPipeWriteEventApplyPolicyStart_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledApplyPolicyStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventApplyPolicyStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledApplyPolicyEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventApplyPolicyEnd);
}

extern "C" ULONG EventPipeWriteEventApplyPolicyEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledApplyPolicyEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventApplyPolicyEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledApplyPolicyEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventApplyPolicyEnd_V1);
}

extern "C" ULONG EventPipeWriteEventApplyPolicyEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledApplyPolicyEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventApplyPolicyEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdLibShFolder(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdLibShFolder);
}

extern "C" ULONG EventPipeWriteEventLdLibShFolder(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdLibShFolder())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLdLibShFolder, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdLibShFolder_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdLibShFolder_V1);
}

extern "C" ULONG EventPipeWriteEventLdLibShFolder_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdLibShFolder_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLdLibShFolder_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdLibShFolderEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdLibShFolderEnd);
}

extern "C" ULONG EventPipeWriteEventLdLibShFolderEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdLibShFolderEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLdLibShFolderEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLdLibShFolderEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLdLibShFolderEnd_V1);
}

extern "C" ULONG EventPipeWriteEventLdLibShFolderEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLdLibShFolderEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLdLibShFolderEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrestubWorker(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrestubWorker);
}

extern "C" ULONG EventPipeWriteEventPrestubWorker(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrestubWorker())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventPrestubWorker, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrestubWorker_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrestubWorker_V1);
}

extern "C" ULONG EventPipeWriteEventPrestubWorker_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrestubWorker_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrestubWorker_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrestubWorkerEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrestubWorkerEnd);
}

extern "C" ULONG EventPipeWriteEventPrestubWorkerEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrestubWorkerEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventPrestubWorkerEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrestubWorkerEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrestubWorkerEnd_V1);
}

extern "C" ULONG EventPipeWriteEventPrestubWorkerEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrestubWorkerEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrestubWorkerEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetInstallationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetInstallationStart);
}

extern "C" ULONG EventPipeWriteEventGetInstallationStart(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetInstallationStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventGetInstallationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetInstallationStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetInstallationStart_V1);
}

extern "C" ULONG EventPipeWriteEventGetInstallationStart_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetInstallationStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGetInstallationStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetInstallationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetInstallationEnd);
}

extern "C" ULONG EventPipeWriteEventGetInstallationEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetInstallationEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventGetInstallationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetInstallationEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetInstallationEnd_V1);
}

extern "C" ULONG EventPipeWriteEventGetInstallationEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetInstallationEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGetInstallationEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledOpenHModule(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventOpenHModule);
}

extern "C" ULONG EventPipeWriteEventOpenHModule(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledOpenHModule())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventOpenHModule, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledOpenHModule_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventOpenHModule_V1);
}

extern "C" ULONG EventPipeWriteEventOpenHModule_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledOpenHModule_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventOpenHModule_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledOpenHModuleEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventOpenHModuleEnd);
}

extern "C" ULONG EventPipeWriteEventOpenHModuleEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledOpenHModuleEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventOpenHModuleEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledOpenHModuleEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventOpenHModuleEnd_V1);
}

extern "C" ULONG EventPipeWriteEventOpenHModuleEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledOpenHModuleEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventOpenHModuleEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExplicitBindStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExplicitBindStart);
}

extern "C" ULONG EventPipeWriteEventExplicitBindStart(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExplicitBindStart())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventExplicitBindStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExplicitBindStart_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExplicitBindStart_V1);
}

extern "C" ULONG EventPipeWriteEventExplicitBindStart_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExplicitBindStart_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExplicitBindStart_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExplicitBindEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExplicitBindEnd);
}

extern "C" ULONG EventPipeWriteEventExplicitBindEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExplicitBindEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventExplicitBindEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledExplicitBindEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventExplicitBindEnd_V1);
}

extern "C" ULONG EventPipeWriteEventExplicitBindEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledExplicitBindEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventExplicitBindEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledParseXml(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventParseXml);
}

extern "C" ULONG EventPipeWriteEventParseXml(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledParseXml())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventParseXml, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledParseXml_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventParseXml_V1);
}

extern "C" ULONG EventPipeWriteEventParseXml_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledParseXml_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventParseXml_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledParseXmlEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventParseXmlEnd);
}

extern "C" ULONG EventPipeWriteEventParseXmlEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledParseXmlEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventParseXmlEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledParseXmlEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventParseXmlEnd_V1);
}

extern "C" ULONG EventPipeWriteEventParseXmlEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledParseXmlEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventParseXmlEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitDefaultDomain(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitDefaultDomain);
}

extern "C" ULONG EventPipeWriteEventInitDefaultDomain(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitDefaultDomain())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventInitDefaultDomain, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitDefaultDomain_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitDefaultDomain_V1);
}

extern "C" ULONG EventPipeWriteEventInitDefaultDomain_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitDefaultDomain_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventInitDefaultDomain_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitDefaultDomainEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitDefaultDomainEnd);
}

extern "C" ULONG EventPipeWriteEventInitDefaultDomainEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitDefaultDomainEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventInitDefaultDomainEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitDefaultDomainEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitDefaultDomainEnd_V1);
}

extern "C" ULONG EventPipeWriteEventInitDefaultDomainEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitDefaultDomainEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventInitDefaultDomainEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitSecurity(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitSecurity);
}

extern "C" ULONG EventPipeWriteEventInitSecurity(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitSecurity())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventInitSecurity, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitSecurity_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitSecurity_V1);
}

extern "C" ULONG EventPipeWriteEventInitSecurity_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitSecurity_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventInitSecurity_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitSecurityEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitSecurityEnd);
}

extern "C" ULONG EventPipeWriteEventInitSecurityEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitSecurityEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventInitSecurityEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledInitSecurityEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventInitSecurityEnd_V1);
}

extern "C" ULONG EventPipeWriteEventInitSecurityEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledInitSecurityEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventInitSecurityEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAllowBindingRedirs(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAllowBindingRedirs);
}

extern "C" ULONG EventPipeWriteEventAllowBindingRedirs(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAllowBindingRedirs())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventAllowBindingRedirs, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAllowBindingRedirs_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAllowBindingRedirs_V1);
}

extern "C" ULONG EventPipeWriteEventAllowBindingRedirs_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAllowBindingRedirs_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAllowBindingRedirs_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAllowBindingRedirsEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAllowBindingRedirsEnd);
}

extern "C" ULONG EventPipeWriteEventAllowBindingRedirsEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAllowBindingRedirsEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventAllowBindingRedirsEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAllowBindingRedirsEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAllowBindingRedirsEnd_V1);
}

extern "C" ULONG EventPipeWriteEventAllowBindingRedirsEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAllowBindingRedirsEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAllowBindingRedirsEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSync(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSync);
}

extern "C" ULONG EventPipeWriteEventEEConfigSync(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSync())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSync, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSync_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSync_V1);
}

extern "C" ULONG EventPipeWriteEventEEConfigSync_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSync_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSync_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSyncEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSyncEnd);
}

extern "C" ULONG EventPipeWriteEventEEConfigSyncEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSyncEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSyncEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEEConfigSyncEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEEConfigSyncEnd_V1);
}

extern "C" ULONG EventPipeWriteEventEEConfigSyncEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEEConfigSyncEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEEConfigSyncEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionBinding(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionBinding);
}

extern "C" ULONG EventPipeWriteEventFusionBinding(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionBinding())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionBinding, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionBinding_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionBinding_V1);
}

extern "C" ULONG EventPipeWriteEventFusionBinding_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionBinding_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionBinding_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionBindingEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionBindingEnd);
}

extern "C" ULONG EventPipeWriteEventFusionBindingEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionBindingEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionBindingEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionBindingEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionBindingEnd_V1);
}

extern "C" ULONG EventPipeWriteEventFusionBindingEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionBindingEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionBindingEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderCatchCall(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderCatchCall);
}

extern "C" ULONG EventPipeWriteEventLoaderCatchCall(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderCatchCall())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLoaderCatchCall, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderCatchCall_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderCatchCall_V1);
}

extern "C" ULONG EventPipeWriteEventLoaderCatchCall_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderCatchCall_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderCatchCall_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderCatchCallEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderCatchCallEnd);
}

extern "C" ULONG EventPipeWriteEventLoaderCatchCallEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderCatchCallEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventLoaderCatchCallEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderCatchCallEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderCatchCallEnd_V1);
}

extern "C" ULONG EventPipeWriteEventLoaderCatchCallEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderCatchCallEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderCatchCallEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionInit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionInit);
}

extern "C" ULONG EventPipeWriteEventFusionInit(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionInit())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionInit, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionInit_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionInit_V1);
}

extern "C" ULONG EventPipeWriteEventFusionInit_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionInit_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionInit_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionInitEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionInitEnd);
}

extern "C" ULONG EventPipeWriteEventFusionInitEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionInitEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionInitEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionInitEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionInitEnd_V1);
}

extern "C" ULONG EventPipeWriteEventFusionInitEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionInitEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionInitEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionAppCtx(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionAppCtx);
}

extern "C" ULONG EventPipeWriteEventFusionAppCtx(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionAppCtx())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionAppCtx, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionAppCtx_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionAppCtx_V1);
}

extern "C" ULONG EventPipeWriteEventFusionAppCtx_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionAppCtx_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionAppCtx_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionAppCtxEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionAppCtxEnd);
}

extern "C" ULONG EventPipeWriteEventFusionAppCtxEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionAppCtxEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusionAppCtxEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionAppCtxEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionAppCtxEnd_V1);
}

extern "C" ULONG EventPipeWriteEventFusionAppCtxEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionAppCtxEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionAppCtxEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusion2EE(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusion2EE);
}

extern "C" ULONG EventPipeWriteEventFusion2EE(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusion2EE())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusion2EE, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusion2EE_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusion2EE_V1);
}

extern "C" ULONG EventPipeWriteEventFusion2EE_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusion2EE_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusion2EE_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusion2EEEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusion2EEEnd);
}

extern "C" ULONG EventPipeWriteEventFusion2EEEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusion2EEEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventFusion2EEEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusion2EEEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusion2EEEnd_V1);
}

extern "C" ULONG EventPipeWriteEventFusion2EEEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusion2EEEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusion2EEEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledSecurityCatchCall(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventSecurityCatchCall);
}

extern "C" ULONG EventPipeWriteEventSecurityCatchCall(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledSecurityCatchCall())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventSecurityCatchCall, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledSecurityCatchCall_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventSecurityCatchCall_V1);
}

extern "C" ULONG EventPipeWriteEventSecurityCatchCall_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledSecurityCatchCall_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventSecurityCatchCall_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledSecurityCatchCallEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventSecurityCatchCallEnd);
}

extern "C" ULONG EventPipeWriteEventSecurityCatchCallEnd(
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledSecurityCatchCallEnd())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;



    EventPipeAdapter::WriteEvent(EventPipeEventSecurityCatchCallEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledSecurityCatchCallEnd_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventSecurityCatchCallEnd_V1);
}

extern "C" ULONG EventPipeWriteEventSecurityCatchCallEnd_V1(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledSecurityCatchCallEnd_V1())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventSecurityCatchCallEnd_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCLRStackWalkPrivate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCLRStackWalkPrivate);
}

extern "C" ULONG EventPipeWriteEventCLRStackWalkPrivate(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCLRStackWalkPrivate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FrameCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Stack, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCLRStackWalkPrivate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleRangeLoadPrivate(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleRangeLoadPrivate);
}

extern "C" ULONG EventPipeWriteEventModuleRangeLoadPrivate(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType,
    const unsigned char IBCType,
    const unsigned short SectionType,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleRangeLoadPrivate())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeBegin, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RangeType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IBCType, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SectionType, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleRangeLoadPrivate, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingPolicyPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingPolicyPhaseStart);
}

extern "C" ULONG EventPipeWriteEventBindingPolicyPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingPolicyPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingPolicyPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingPolicyPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingPolicyPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventBindingPolicyPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingPolicyPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingPolicyPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingNgenPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingNgenPhaseStart);
}

extern "C" ULONG EventPipeWriteEventBindingNgenPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingNgenPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingNgenPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingNgenPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingNgenPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventBindingNgenPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingNgenPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingNgenPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingLookupAndProbingPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingLookupAndProbingPhaseStart);
}

extern "C" ULONG EventPipeWriteEventBindingLookupAndProbingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingLookupAndProbingPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingLookupAndProbingPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingLookupAndProbingPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingLookupAndProbingPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventBindingLookupAndProbingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingLookupAndProbingPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingLookupAndProbingPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderPhaseStart);
}

extern "C" ULONG EventPipeWriteEventLoaderPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventLoaderPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingPhaseStart);
}

extern "C" ULONG EventPipeWriteEventBindingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventBindingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingDownloadPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingDownloadPhaseStart);
}

extern "C" ULONG EventPipeWriteEventBindingDownloadPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingDownloadPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingDownloadPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBindingDownloadPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBindingDownloadPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventBindingDownloadPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBindingDownloadPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBindingDownloadPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderAssemblyInitPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderAssemblyInitPhaseStart);
}

extern "C" ULONG EventPipeWriteEventLoaderAssemblyInitPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderAssemblyInitPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderAssemblyInitPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderAssemblyInitPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderAssemblyInitPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventLoaderAssemblyInitPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderAssemblyInitPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderAssemblyInitPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderMappingPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderMappingPhaseStart);
}

extern "C" ULONG EventPipeWriteEventLoaderMappingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderMappingPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderMappingPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderMappingPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderMappingPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventLoaderMappingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderMappingPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderMappingPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderDeliverEventsPhaseStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderDeliverEventsPhaseStart);
}

extern "C" ULONG EventPipeWriteEventLoaderDeliverEventsPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderDeliverEventsPhaseStart())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderDeliverEventsPhaseStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledLoaderDeliverEventsPhaseEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventLoaderDeliverEventsPhaseEnd);
}

extern "C" ULONG EventPipeWriteEventLoaderDeliverEventsPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledLoaderDeliverEventsPhaseEnd())
        return ERROR_SUCCESS;

    size_t size = 146;
    BYTE stackBuffer[146];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyCodebase) { AssemblyCodebase = W("NULL"); }
    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LoadContextID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FromLoaderCache, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DynamicLoad, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyCodebase, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventLoaderDeliverEventsPhaseEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEvidenceGenerated(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEvidenceGenerated);
}

extern "C" ULONG EventPipeWriteEventEvidenceGenerated(
    const unsigned int Type,
    const unsigned int AppDomain,
    PCWSTR ILImage,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEvidenceGenerated())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ILImage) { ILImage = W("NULL"); }
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomain, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILImage, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEvidenceGenerated, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleTransparencyComputationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleTransparencyComputationStart);
}

extern "C" ULONG EventPipeWriteEventModuleTransparencyComputationStart(
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleTransparencyComputationStart())
        return ERROR_SUCCESS;

    size_t size = 70;
    BYTE stackBuffer[70];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleTransparencyComputationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledModuleTransparencyComputationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventModuleTransparencyComputationEnd);
}

extern "C" ULONG EventPipeWriteEventModuleTransparencyComputationEnd(
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsAllCritical,
    const BOOL IsAllTransparent,
    const BOOL IsTreatAsSafe,
    const BOOL IsOpportunisticallyCritical,
    const unsigned int SecurityRuleSet,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledModuleTransparencyComputationEnd())
        return ERROR_SUCCESS;

    size_t size = 90;
    BYTE stackBuffer[90];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAllCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAllTransparent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTreatAsSafe, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsOpportunisticallyCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecurityRuleSet, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventModuleTransparencyComputationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTypeTransparencyComputationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTypeTransparencyComputationStart);
}

extern "C" ULONG EventPipeWriteEventTypeTransparencyComputationStart(
    PCWSTR Type,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTypeTransparencyComputationStart())
        return ERROR_SUCCESS;

    size_t size = 134;
    BYTE stackBuffer[134];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Type) { Type = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTypeTransparencyComputationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTypeTransparencyComputationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTypeTransparencyComputationEnd);
}

extern "C" ULONG EventPipeWriteEventTypeTransparencyComputationEnd(
    PCWSTR Type,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsAllCritical,
    const BOOL IsAllTransparent,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTypeTransparencyComputationEnd())
        return ERROR_SUCCESS;

    size_t size = 150;
    BYTE stackBuffer[150];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Type) { Type = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Type, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAllCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsAllTransparent, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTreatAsSafe, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTypeTransparencyComputationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodTransparencyComputationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodTransparencyComputationStart);
}

extern "C" ULONG EventPipeWriteEventMethodTransparencyComputationStart(
    PCWSTR Method,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodTransparencyComputationStart())
        return ERROR_SUCCESS;

    size_t size = 134;
    BYTE stackBuffer[134];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Method) { Method = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Method, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodTransparencyComputationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMethodTransparencyComputationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMethodTransparencyComputationEnd);
}

extern "C" ULONG EventPipeWriteEventMethodTransparencyComputationEnd(
    PCWSTR Method,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMethodTransparencyComputationEnd())
        return ERROR_SUCCESS;

    size_t size = 142;
    BYTE stackBuffer[142];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Method) { Method = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Method, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTreatAsSafe, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMethodTransparencyComputationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFieldTransparencyComputationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFieldTransparencyComputationStart);
}

extern "C" ULONG EventPipeWriteEventFieldTransparencyComputationStart(
    PCWSTR Field,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFieldTransparencyComputationStart())
        return ERROR_SUCCESS;

    size_t size = 134;
    BYTE stackBuffer[134];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Field) { Field = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Field, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFieldTransparencyComputationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFieldTransparencyComputationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFieldTransparencyComputationEnd);
}

extern "C" ULONG EventPipeWriteEventFieldTransparencyComputationEnd(
    PCWSTR Field,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFieldTransparencyComputationEnd())
        return ERROR_SUCCESS;

    size_t size = 142;
    BYTE stackBuffer[142];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Field) { Field = W("NULL"); }
    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Field, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTreatAsSafe, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFieldTransparencyComputationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTokenTransparencyComputationStart(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTokenTransparencyComputationStart);
}

extern "C" ULONG EventPipeWriteEventTokenTransparencyComputationStart(
    const unsigned int Token,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTokenTransparencyComputationStart())
        return ERROR_SUCCESS;

    size_t size = 74;
    BYTE stackBuffer[74];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Token, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTokenTransparencyComputationStart, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledTokenTransparencyComputationEnd(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventTokenTransparencyComputationEnd);
}

extern "C" ULONG EventPipeWriteEventTokenTransparencyComputationEnd(
    const unsigned int Token,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledTokenTransparencyComputationEnd())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Module) { Module = W("NULL"); }
    success &= WriteToBuffer(Token, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Module, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsCritical, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(IsTreatAsSafe, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventTokenTransparencyComputationEnd, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledNgenBindEvent(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventNgenBindEvent);
}

extern "C" ULONG EventPipeWriteEventNgenBindEvent(
    const unsigned short ClrInstanceID,
    const unsigned __int64 BindingID,
    const unsigned int ReasonCode,
    PCWSTR AssemblyName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledNgenBindEvent())
        return ERROR_SUCCESS;

    size_t size = 78;
    BYTE stackBuffer[78];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!AssemblyName) { AssemblyName = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(BindingID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReasonCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AssemblyName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventNgenBindEvent, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledJittedMethodRichDebugInfo(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventJittedMethodRichDebugInfo);
}

extern "C" ULONG EventPipeWriteEventJittedMethodRichDebugInfo(
    const unsigned short ClrInstanceID,
    const unsigned __int64 MethodID,
    const unsigned __int64 ReJITID,
    const unsigned __int64 ILVersionID,
    const unsigned int ChunkIndex,
    const unsigned int DataSize,
    const BYTE* Data,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledJittedMethodRichDebugInfo())
        return ERROR_SUCCESS;

    size_t size = 35;
    BYTE stackBuffer[35];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ReJITID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ILVersionID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ChunkIndex, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(DataSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer((const BYTE *)Data, sizeof(const BYTE) * (int)DataSize, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventJittedMethodRichDebugInfo, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFailFast(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFailFast);
}

extern "C" ULONG EventPipeWriteEventFailFast(
    PCWSTR FailFastUserMessage,
    const void* FailedEIP,
    const unsigned int OSExitCode,
    const unsigned int ClrExitCode,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFailFast())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!FailFastUserMessage) { FailFastUserMessage = W("NULL"); }
    success &= WriteToBuffer(FailFastUserMessage, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FailedEIP, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(OSExitCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrExitCode, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFailFast, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvFinalizeObject(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvFinalizeObject);
}

extern "C" ULONG EventPipeWriteEventPrvFinalizeObject(
    const void* TypeID,
    const void* ObjectID,
    const unsigned short ClrInstanceID,
    PCWSTR TypeName,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvFinalizeObject())
        return ERROR_SUCCESS;

    size_t size = 82;
    BYTE stackBuffer[82];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvFinalizeObject, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCCWRefCountChangeAnsi(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCCWRefCountChangeAnsi);
}

extern "C" ULONG EventPipeWriteEventCCWRefCountChangeAnsi(
    const void* HandleID,
    const void* ObjectID,
    const void* COMInterfacePointer,
    const unsigned int NewRefCount,
    const unsigned __int64 AppDomainID,
    LPCSTR ClassName,
    LPCSTR NameSpace,
    PCWSTR Operation,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCCWRefCountChangeAnsi())
        return ERROR_SUCCESS;

    size_t size = 166;
    BYTE stackBuffer[166];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Operation) { Operation = W("NULL"); }
    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(COMInterfacePointer, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewRefCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClassName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NameSpace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Operation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCCWRefCountChangeAnsi, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvSetGCHandle(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvSetGCHandle);
}

extern "C" ULONG EventPipeWriteEventPrvSetGCHandle(
    const void* HandleID,
    const void* ObjectID,
    const unsigned int Kind,
    const unsigned int Generation,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvSetGCHandle())
        return ERROR_SUCCESS;

    size_t size = 34;
    BYTE stackBuffer[34];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Kind, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Generation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvSetGCHandle, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPrvDestroyGCHandle(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPrvDestroyGCHandle);
}

extern "C" ULONG EventPipeWriteEventPrvDestroyGCHandle(
    const void* HandleID,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPrvDestroyGCHandle())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPrvDestroyGCHandle, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionMessageEvent(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionMessageEvent);
}

extern "C" ULONG EventPipeWriteEventFusionMessageEvent(
    const unsigned short ClrInstanceID,
    const BOOL Prepend,
    PCWSTR Message,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionMessageEvent())
        return ERROR_SUCCESS;

    size_t size = 70;
    BYTE stackBuffer[70];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!Message) { Message = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Prepend, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Message, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionMessageEvent, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledFusionErrorCodeEvent(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventFusionErrorCodeEvent);
}

extern "C" ULONG EventPipeWriteEventFusionErrorCodeEvent(
    const unsigned short ClrInstanceID,
    const unsigned int Category,
    const unsigned int ErrorCode,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledFusionErrorCodeEvent())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Category, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ErrorCode, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventFusionErrorCodeEvent, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledPinPlugAtGCTime(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventPinPlugAtGCTime);
}

extern "C" ULONG EventPipeWriteEventPinPlugAtGCTime(
    const void* PlugStart,
    const void* PlugEnd,
    const void* GapBeforeSize,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledPinPlugAtGCTime())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(PlugStart, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(PlugEnd, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(GapBeforeSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventPinPlugAtGCTime, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCCWRefCountChange(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCCWRefCountChange);
}

extern "C" ULONG EventPipeWriteEventCCWRefCountChange(
    const void* HandleID,
    const void* ObjectID,
    const void* COMInterfacePointer,
    const unsigned int NewRefCount,
    const unsigned __int64 AppDomainID,
    PCWSTR ClassName,
    PCWSTR NameSpace,
    PCWSTR Operation,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCCWRefCountChange())
        return ERROR_SUCCESS;

    size_t size = 230;
    BYTE stackBuffer[230];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!ClassName) { ClassName = W("NULL"); }
    if (!NameSpace) { NameSpace = W("NULL"); }
    if (!Operation) { Operation = W("NULL"); }
    success &= WriteToBuffer(HandleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ObjectID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(COMInterfacePointer, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NewRefCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(AppDomainID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClassName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(NameSpace, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Operation, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCCWRefCountChange, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledAllocRequest(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventAllocRequest);
}

extern "C" ULONG EventPipeWriteEventAllocRequest(
    const void* LoaderHeapPtr,
    const void* MemoryAddress,
    const unsigned int RequestSize,
    const unsigned int Unused1,
    const unsigned __int64 Unused2,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledAllocRequest())
        return ERROR_SUCCESS;

    size_t size = 34;
    BYTE stackBuffer[34];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(LoaderHeapPtr, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MemoryAddress, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(RequestSize, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Unused1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Unused2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventAllocRequest, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMulticoreJit(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMulticoreJit);
}

extern "C" ULONG EventPipeWriteEventMulticoreJit(
    const unsigned short ClrInstanceID,
    PCWSTR String1,
    PCWSTR String2,
    const signed int Int1,
    const signed int Int2,
    const signed int Int3,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMulticoreJit())
        return ERROR_SUCCESS;

    size_t size = 142;
    BYTE stackBuffer[142];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!String1) { String1 = W("NULL"); }
    if (!String2) { String2 = W("NULL"); }
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(String1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(String2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Int1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Int2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Int3, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMulticoreJit, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledMulticoreJitMethodCodeReturned(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventMulticoreJitMethodCodeReturned);
}

extern "C" ULONG EventPipeWriteEventMulticoreJitMethodCodeReturned(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledMulticoreJitMethodCodeReturned())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ModuleID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(MethodID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventMulticoreJitMethodCodeReturned, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledIInspectableRuntimeClassName(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventIInspectableRuntimeClassName);
}

extern "C" ULONG EventPipeWriteEventIInspectableRuntimeClassName(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledIInspectableRuntimeClassName())
        return ERROR_SUCCESS;

    size_t size = 66;
    BYTE stackBuffer[66];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventIInspectableRuntimeClassName, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledWinRTUnbox(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventWinRTUnbox);
}

extern "C" ULONG EventPipeWriteEventWinRTUnbox(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledWinRTUnbox())
        return ERROR_SUCCESS;

    size_t size = 130;
    BYTE stackBuffer[130];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!SecondTypeName) { SecondTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecondTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventWinRTUnbox, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCreateRCW(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCreateRCW);
}

extern "C" ULONG EventPipeWriteEventCreateRCW(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCreateRCW())
        return ERROR_SUCCESS;

    size_t size = 66;
    BYTE stackBuffer[66];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCreateRCW, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledRCWVariance(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventRCWVariance);
}

extern "C" ULONG EventPipeWriteEventRCWVariance(
    PCWSTR TypeName,
    PCWSTR InterfaceTypeName,
    PCWSTR VariantInterfaceTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledRCWVariance())
        return ERROR_SUCCESS;

    size_t size = 194;
    BYTE stackBuffer[194];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!InterfaceTypeName) { InterfaceTypeName = W("NULL"); }
    if (!VariantInterfaceTypeName) { VariantInterfaceTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InterfaceTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VariantInterfaceTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventRCWVariance, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledRCWIEnumerableCasting(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventRCWIEnumerableCasting);
}

extern "C" ULONG EventPipeWriteEventRCWIEnumerableCasting(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledRCWIEnumerableCasting())
        return ERROR_SUCCESS;

    size_t size = 130;
    BYTE stackBuffer[130];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!SecondTypeName) { SecondTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecondTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventRCWIEnumerableCasting, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCreateCCW(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCreateCCW);
}

extern "C" ULONG EventPipeWriteEventCreateCCW(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCreateCCW())
        return ERROR_SUCCESS;

    size_t size = 66;
    BYTE stackBuffer[66];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCreateCCW, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCCWVariance(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCCWVariance);
}

extern "C" ULONG EventPipeWriteEventCCWVariance(
    PCWSTR TypeName,
    PCWSTR InterfaceTypeName,
    PCWSTR VariantInterfaceTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCCWVariance())
        return ERROR_SUCCESS;

    size_t size = 194;
    BYTE stackBuffer[194];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!InterfaceTypeName) { InterfaceTypeName = W("NULL"); }
    if (!VariantInterfaceTypeName) { VariantInterfaceTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(InterfaceTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(VariantInterfaceTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCCWVariance, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledObjectVariantMarshallingToNative(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventObjectVariantMarshallingToNative);
}

extern "C" ULONG EventPipeWriteEventObjectVariantMarshallingToNative(
    PCWSTR TypeName,
    const signed int Int1,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledObjectVariantMarshallingToNative())
        return ERROR_SUCCESS;

    size_t size = 70;
    BYTE stackBuffer[70];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Int1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventObjectVariantMarshallingToNative, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetTypeFromGUID(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetTypeFromGUID);
}

extern "C" ULONG EventPipeWriteEventGetTypeFromGUID(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetTypeFromGUID())
        return ERROR_SUCCESS;

    size_t size = 130;
    BYTE stackBuffer[130];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!SecondTypeName) { SecondTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecondTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGetTypeFromGUID, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledGetTypeFromProgID(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventGetTypeFromProgID);
}

extern "C" ULONG EventPipeWriteEventGetTypeFromProgID(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledGetTypeFromProgID())
        return ERROR_SUCCESS;

    size_t size = 130;
    BYTE stackBuffer[130];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!SecondTypeName) { SecondTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecondTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventGetTypeFromProgID, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledConvertToCallbackEtw(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventConvertToCallbackEtw);
}

extern "C" ULONG EventPipeWriteEventConvertToCallbackEtw(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledConvertToCallbackEtw())
        return ERROR_SUCCESS;

    size_t size = 130;
    BYTE stackBuffer[130];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    if (!SecondTypeName) { SecondTypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(SecondTypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventConvertToCallbackEtw, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledBeginCreateManagedReference(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventBeginCreateManagedReference);
}

extern "C" ULONG EventPipeWriteEventBeginCreateManagedReference(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledBeginCreateManagedReference())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventBeginCreateManagedReference, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledEndCreateManagedReference(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventEndCreateManagedReference);
}

extern "C" ULONG EventPipeWriteEventEndCreateManagedReference(
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledEndCreateManagedReference())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventEndCreateManagedReference, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledObjectVariantMarshallingToManaged(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventObjectVariantMarshallingToManaged);
}

extern "C" ULONG EventPipeWriteEventObjectVariantMarshallingToManaged(
    PCWSTR TypeName,
    const signed int Int1,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledObjectVariantMarshallingToManaged())
        return ERROR_SUCCESS;

    size_t size = 70;
    BYTE stackBuffer[70];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    if (!TypeName) { TypeName = W("NULL"); }
    success &= WriteToBuffer(TypeName, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Int1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventObjectVariantMarshallingToManaged, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

extern "C" void InitDotNETRuntimePrivate(void);

extern "C" void InitDotNETRuntimePrivate(void)
{
    EventPipeProviderDotNETRuntimePrivate = EventPipeAdapter::CreateProvider(SL(DotNETRuntimePrivateName), reinterpret_cast<EventPipeCallback>(EventPipeEtwCallbackDotNETRuntimePrivate));
    EventPipeEventGCDecision = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,1,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCDecision_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,1,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCSettings = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,2,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCSettings_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,2,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCOptimized = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,3,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCOptimized_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,3,1,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCPerHeapHistory = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,4,1,2,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCPerHeapHistory_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,4,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCGlobalHeapHistory = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,5,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCGlobalHeapHistory_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,5,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCJoin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,6,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventGCJoin_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,6,1,1,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventPrvGCMarkStackRoots = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,7,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkStackRoots_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,7,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkFinalizeQueueRoots = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,8,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkFinalizeQueueRoots_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,8,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkHandles = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,9,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkHandles_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,9,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkCards = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,10,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrvGCMarkCards_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,10,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,11,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC1stNonConEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,12,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC1stConEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,13,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC2ndNonConBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,14,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC2ndNonConEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,15,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC2ndConBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,16,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC2ndConEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,17,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCPlanEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,18,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCSweepEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,19,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCDrainMark = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,20,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCRevisit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,21,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCOverflow = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,22,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCOverflow_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,22,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCAllocWaitBegin = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,23,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGCAllocWaitEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,24,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCFullNotify = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,25,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGCFullNotify_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,25,1,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBGC1stSweepEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,26,1,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEStartupStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,80,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEStartupStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,80,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEStartupEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,81,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEStartupEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,81,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSetup = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,82,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSetup_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,82,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSetupEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,83,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSetupEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,83,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdSysBases = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,84,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdSysBases_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,84,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdSysBasesEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,85,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdSysBasesEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,85,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExecExe = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,86,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExecExe_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,86,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExecExeEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,87,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExecExeEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,87,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMain = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,88,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMain_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,88,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMainEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,89,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMainEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,89,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventApplyPolicyStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,90,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventApplyPolicyStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,90,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventApplyPolicyEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,91,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventApplyPolicyEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,91,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdLibShFolder = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,92,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdLibShFolder_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,92,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdLibShFolderEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,93,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLdLibShFolderEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,93,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrestubWorker = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,94,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrestubWorker_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,94,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrestubWorkerEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,95,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPrestubWorkerEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,95,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetInstallationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,96,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetInstallationStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,96,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetInstallationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,97,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetInstallationEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,97,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventOpenHModule = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,98,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventOpenHModule_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,98,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventOpenHModuleEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,99,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventOpenHModuleEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,99,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExplicitBindStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,100,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExplicitBindStart_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,100,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExplicitBindEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,101,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventExplicitBindEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,101,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventParseXml = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,102,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventParseXml_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,102,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventParseXmlEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,103,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventParseXmlEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,103,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitDefaultDomain = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,104,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitDefaultDomain_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,104,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitDefaultDomainEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,105,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitDefaultDomainEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,105,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitSecurity = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,106,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitSecurity_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,106,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitSecurityEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,107,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventInitSecurityEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,107,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAllowBindingRedirs = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,108,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAllowBindingRedirs_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,108,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAllowBindingRedirsEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,109,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventAllowBindingRedirsEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,109,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSync = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,110,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSync_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,110,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSyncEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,111,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEEConfigSyncEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,111,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionBinding = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,112,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionBinding_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,112,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionBindingEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,113,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionBindingEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,113,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderCatchCall = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,114,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderCatchCall_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,114,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderCatchCallEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,115,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderCatchCallEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,115,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionInit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,116,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionInit_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,116,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionInitEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,117,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionInitEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,117,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionAppCtx = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,118,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionAppCtx_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,118,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionAppCtxEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,119,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionAppCtxEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,119,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusion2EE = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,120,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusion2EE_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,120,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusion2EEEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,121,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusion2EEEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,121,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventSecurityCatchCall = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,122,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventSecurityCatchCall_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,122,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventSecurityCatchCallEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,123,2147483648,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventSecurityCatchCallEnd_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,123,2147483648,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCLRStackWalkPrivate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,151,1073741824,0,EP_EVENT_LEVEL_LOGALWAYS,true);
    EventPipeEventModuleRangeLoadPrivate = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,158,536870912,0,EP_EVENT_LEVEL_INFORMATIONAL,false);
    EventPipeEventBindingPolicyPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,159,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingPolicyPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,160,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingNgenPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,161,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingNgenPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,162,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingLookupAndProbingPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,163,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingLookupAndProbingPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,164,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,165,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,166,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,167,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,168,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingDownloadPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,169,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBindingDownloadPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,170,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderAssemblyInitPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,171,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderAssemblyInitPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,172,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderMappingPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,173,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderMappingPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,174,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderDeliverEventsPhaseStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,175,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventLoaderDeliverEventsPhaseEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,176,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEvidenceGenerated = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,177,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleTransparencyComputationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,178,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventModuleTransparencyComputationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,179,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTypeTransparencyComputationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,180,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTypeTransparencyComputationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,181,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodTransparencyComputationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,182,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMethodTransparencyComputationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,183,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFieldTransparencyComputationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,184,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFieldTransparencyComputationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,185,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTokenTransparencyComputationStart = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,186,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventTokenTransparencyComputationEnd = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,187,1024,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventNgenBindEvent = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,188,8,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventJittedMethodRichDebugInfo = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,189,262144,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFailFast = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,191,0,0,EP_EVENT_LEVEL_CRITICAL,true);
    EventPipeEventPrvFinalizeObject = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,192,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventCCWRefCountChangeAnsi = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,193,8192,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventPrvSetGCHandle = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,194,16384,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventPrvDestroyGCHandle = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,195,16384,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventFusionMessageEvent = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,196,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventFusionErrorCodeEvent = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,197,2,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventPinPlugAtGCTime = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,199,1,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventCCWRefCountChange = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,200,8192,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventAllocRequest = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,310,16,0,EP_EVENT_LEVEL_VERBOSE,true);
    EventPipeEventMulticoreJit = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,201,131072,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventMulticoreJitMethodCodeReturned = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,202,131072,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventIInspectableRuntimeClassName = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,400,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventWinRTUnbox = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,401,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCreateRCW = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,402,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventRCWVariance = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,403,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventRCWIEnumerableCasting = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,404,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCreateCCW = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,405,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCCWVariance = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,406,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventObjectVariantMarshallingToNative = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,407,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetTypeFromGUID = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,408,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventGetTypeFromProgID = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,409,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventConvertToCallbackEtw = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,410,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventBeginCreateManagedReference = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,411,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventEndCreateManagedReference = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,412,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventObjectVariantMarshallingToManaged = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimePrivate,413,32,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
}
