/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-legion-hid2-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"







/**
 * fu_struct_legion_get_version_ref: (skip):
 **/
FuStructLegionGetVersion *
fu_struct_legion_get_version_ref(FuStructLegionGetVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_get_version_unref: (skip):
 **/
void
fu_struct_legion_get_version_unref(FuStructLegionGetVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionGetVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionGetVersion *
fu_struct_legion_get_version_new_internal(void)
{
    FuStructLegionGetVersion *st = g_new0(FuStructLegionGetVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_legion_get_version_set_cmd: (skip):
 **/
static void
fu_struct_legion_get_version_set_cmd(FuStructLegionGetVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_get_version_new: (skip):
 **/
FuStructLegionGetVersion *
fu_struct_legion_get_version_new(void)
{
    FuStructLegionGetVersion *st = fu_struct_legion_get_version_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_legion_get_version_set_cmd(st, 0x01);
    return st;
}
/**
 * fu_struct_legion_version_ref: (skip):
 **/
FuStructLegionVersion *
fu_struct_legion_version_ref(FuStructLegionVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_version_unref: (skip):
 **/
void
fu_struct_legion_version_unref(FuStructLegionVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionVersion *
fu_struct_legion_version_new_internal(void)
{
    FuStructLegionVersion *st = g_new0(FuStructLegionVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_version_get_command: (skip):
 **/
guint8
fu_struct_legion_version_get_command(const FuStructLegionVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_version_get_version: (skip):
 **/
guint32
fu_struct_legion_version_get_version(const FuStructLegionVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_legion_version_set_command: (skip):
 **/
void
fu_struct_legion_version_set_command(FuStructLegionVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_version_set_version: (skip):
 **/
void
fu_struct_legion_version_set_version(FuStructLegionVersion *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_version_new: (skip):
 **/
FuStructLegionVersion *
fu_struct_legion_version_new(void)
{
    FuStructLegionVersion *st = fu_struct_legion_version_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_legion_get_pl_test_ref: (skip):
 **/
FuStructLegionGetPlTest *
fu_struct_legion_get_pl_test_ref(FuStructLegionGetPlTest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_get_pl_test_unref: (skip):
 **/
void
fu_struct_legion_get_pl_test_unref(FuStructLegionGetPlTest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionGetPlTest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionGetPlTest *
fu_struct_legion_get_pl_test_new_internal(void)
{
    FuStructLegionGetPlTest *st = g_new0(FuStructLegionGetPlTest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_legion_get_pl_test_set_cmd: (skip):
 **/
static void
fu_struct_legion_get_pl_test_set_cmd(FuStructLegionGetPlTest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_get_pl_test_set_index: (skip):
 **/
void
fu_struct_legion_get_pl_test_set_index(FuStructLegionGetPlTest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_legion_get_pl_test_new: (skip):
 **/
FuStructLegionGetPlTest *
fu_struct_legion_get_pl_test_new(void)
{
    FuStructLegionGetPlTest *st = fu_struct_legion_get_pl_test_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_legion_get_pl_test_set_cmd(st, 0xDF);
    return st;
}
/**
 * fu_struct_legion_get_pl_test_result_ref: (skip):
 **/
FuStructLegionGetPlTestResult *
fu_struct_legion_get_pl_test_result_ref(FuStructLegionGetPlTestResult *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_get_pl_test_result_unref: (skip):
 **/
void
fu_struct_legion_get_pl_test_result_unref(FuStructLegionGetPlTestResult *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionGetPlTestResult refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionGetPlTestResult *
fu_struct_legion_get_pl_test_result_new_internal(void)
{
    FuStructLegionGetPlTestResult *st = g_new0(FuStructLegionGetPlTestResult, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_get_pl_test_result_get_cmd: (skip):
 **/
guint8
fu_struct_legion_get_pl_test_result_get_cmd(const FuStructLegionGetPlTestResult *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_get_pl_test_result_get_index: (skip):
 **/
guint8
fu_struct_legion_get_pl_test_result_get_index(const FuStructLegionGetPlTestResult *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_get_pl_test_result_get_content: (skip):
 **/
guint8
fu_struct_legion_get_pl_test_result_get_content(const FuStructLegionGetPlTestResult *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_legion_get_pl_test_result_set_cmd: (skip):
 **/
void
fu_struct_legion_get_pl_test_result_set_cmd(FuStructLegionGetPlTestResult *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_get_pl_test_result_set_index: (skip):
 **/
void
fu_struct_legion_get_pl_test_result_set_index(FuStructLegionGetPlTestResult *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_legion_get_pl_test_result_set_content: (skip):
 **/
void
fu_struct_legion_get_pl_test_result_set_content(FuStructLegionGetPlTestResult *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_legion_get_pl_test_result_new: (skip):
 **/
FuStructLegionGetPlTestResult *
fu_struct_legion_get_pl_test_result_new(void)
{
    FuStructLegionGetPlTestResult *st = fu_struct_legion_get_pl_test_result_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_legion_start_iap_ref: (skip):
 **/
FuStructLegionStartIap *
fu_struct_legion_start_iap_ref(FuStructLegionStartIap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_start_iap_unref: (skip):
 **/
void
fu_struct_legion_start_iap_unref(FuStructLegionStartIap *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionStartIap refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionStartIap *
fu_struct_legion_start_iap_new_internal(void)
{
    FuStructLegionStartIap *st = g_new0(FuStructLegionStartIap, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_legion_start_iap_set_cmd: (skip):
 **/
static void
fu_struct_legion_start_iap_set_cmd(FuStructLegionStartIap *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_start_iap_set_data: (skip):
 **/
static gboolean
fu_struct_legion_start_iap_set_data(FuStructLegionStartIap *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 1, 0x0, 7);
        return TRUE;
    }
    len = strlen(value);
    if (len > 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructLegionStartIap.data (0x%x bytes)",
                    value, (guint) len, (guint) 7);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 1, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_legion_start_iap_set_reset: (skip):
 **/
static void
fu_struct_legion_start_iap_set_reset(FuStructLegionStartIap *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_legion_start_iap_new: (skip):
 **/
FuStructLegionStartIap *
fu_struct_legion_start_iap_new(void)
{
    FuStructLegionStartIap *st = fu_struct_legion_start_iap_new_internal();
    st->buf = g_byte_array_sized_new(65);
    fu_byte_array_set_size(st->buf, 65, 0x0);
    fu_struct_legion_start_iap_set_cmd(st, 0xE1);
    fu_struct_legion_start_iap_set_data(st, "UPGRADE", NULL);
    fu_struct_legion_start_iap_set_reset(st, 0x01);
    return st;
}
/**
 * fu_struct_legion_iap_result_ref: (skip):
 **/
FuStructLegionIapResult *
fu_struct_legion_iap_result_ref(FuStructLegionIapResult *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_iap_result_unref: (skip):
 **/
void
fu_struct_legion_iap_result_unref(FuStructLegionIapResult *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionIapResult refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionIapResult *
fu_struct_legion_iap_result_new_internal(void)
{
    FuStructLegionIapResult *st = g_new0(FuStructLegionIapResult, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_iap_result_get_ret: (skip):
 **/
guint8
fu_struct_legion_iap_result_get_ret(const FuStructLegionIapResult *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}

/* setters */
/**
 * fu_struct_legion_iap_result_set_ret: (skip):
 **/
void
fu_struct_legion_iap_result_set_ret(FuStructLegionIapResult *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_iap_result_new: (skip):
 **/
FuStructLegionIapResult *
fu_struct_legion_iap_result_new(void)
{
    FuStructLegionIapResult *st = fu_struct_legion_iap_result_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_legion_iap_tlv_ref: (skip):
 **/
FuStructLegionIapTlv *
fu_struct_legion_iap_tlv_ref(FuStructLegionIapTlv *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_iap_tlv_unref: (skip):
 **/
void
fu_struct_legion_iap_tlv_unref(FuStructLegionIapTlv *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionIapTlv refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionIapTlv *
fu_struct_legion_iap_tlv_new_internal(void)
{
    FuStructLegionIapTlv *st = g_new0(FuStructLegionIapTlv, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_iap_tlv_get_tag: (skip):
 **/
guint16
fu_struct_legion_iap_tlv_get_tag(const FuStructLegionIapTlv *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_iap_tlv_get_length: (skip):
 **/
guint16
fu_struct_legion_iap_tlv_get_length(const FuStructLegionIapTlv *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_iap_tlv_get_value: (skip):
 **/
const guint8 *
fu_struct_legion_iap_tlv_get_value(const FuStructLegionIapTlv *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 60;
    return st->buf->data + 4;
}

/* setters */
/**
 * fu_struct_legion_iap_tlv_set_tag: (skip):
 **/
void
fu_struct_legion_iap_tlv_set_tag(FuStructLegionIapTlv *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_iap_tlv_set_length: (skip):
 **/
void
fu_struct_legion_iap_tlv_set_length(FuStructLegionIapTlv *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_iap_tlv_set_value: (skip):
 **/
gboolean
fu_struct_legion_iap_tlv_set_value(FuStructLegionIapTlv *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_legion_iap_tlv_new: (skip):
 **/
FuStructLegionIapTlv *
fu_struct_legion_iap_tlv_new(void)
{
    FuStructLegionIapTlv *st = fu_struct_legion_iap_tlv_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_legion_hid2_header_ref: (skip):
 **/
FuStructLegionHid2Header *
fu_struct_legion_hid2_header_ref(FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid2_header_unref: (skip):
 **/
void
fu_struct_legion_hid2_header_unref(FuStructLegionHid2Header *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHid2Header refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionHid2Header *
fu_struct_legion_hid2_header_new_internal(void)
{
    FuStructLegionHid2Header *st = g_new0(FuStructLegionHid2Header, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid2_header_get_magic: (skip):
 **/
static gchar *
fu_struct_legion_hid2_header_get_magic(const FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 7, NULL);
}
/**
 * fu_struct_legion_hid2_header_get_sig_add: (skip):
 **/
guint32
fu_struct_legion_hid2_header_get_sig_add(const FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid2_header_get_sig_len: (skip):
 **/
guint32
fu_struct_legion_hid2_header_get_sig_len(const FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid2_header_get_data_add: (skip):
 **/
guint32
fu_struct_legion_hid2_header_get_data_add(const FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid2_header_get_data_len: (skip):
 **/
guint32
fu_struct_legion_hid2_header_get_data_len(const FuStructLegionHid2Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_legion_hid2_header_to_string: (skip):
 **/
static gchar *
fu_struct_legion_hid2_header_to_string(const FuStructLegionHid2Header *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLegionHid2Header:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  sig_add: 0x%x\n",
                           (guint) fu_struct_legion_hid2_header_get_sig_add(st));
    g_string_append_printf(str, "  sig_len: 0x%x\n",
                           (guint) fu_struct_legion_hid2_header_get_sig_len(st));
    g_string_append_printf(str, "  data_add: 0x%x\n",
                           (guint) fu_struct_legion_hid2_header_get_data_add(st));
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_legion_hid2_header_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_legion_hid2_header_validate_internal(FuStructLegionHid2Header *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "#Legion", 7) != 0) {
        g_autofree gchar *str = fu_struct_legion_hid2_header_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLegionHid2Header.magic was not valid, "
                    "expected '#Legion' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_legion_hid2_header_parse_internal(FuStructLegionHid2Header *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_legion_hid2_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_legion_hid2_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_legion_hid2_header_parse_stream: (skip):
 **/
FuStructLegionHid2Header *
fu_struct_legion_hid2_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructLegionHid2Header) st = fu_struct_legion_hid2_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 30, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructLegionHid2Header failed read of 0x%x: ", (guint) 30);
        return NULL;
    }
    if (st->buf->len != 30) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructLegionHid2Header requested 0x%x and got 0x%x",
                    (guint) 30,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_legion_hid2_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_legion_hid2_version_ref: (skip):
 **/
FuStructLegionHid2Version *
fu_struct_legion_hid2_version_ref(FuStructLegionHid2Version *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid2_version_unref: (skip):
 **/
void
fu_struct_legion_hid2_version_unref(FuStructLegionHid2Version *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHid2Version refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructLegionHid2Version *
fu_struct_legion_hid2_version_new_internal(void)
{
    FuStructLegionHid2Version *st = g_new0(FuStructLegionHid2Version, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid2_version_get_signature: (skip):
 **/
static gchar *
fu_struct_legion_hid2_version_get_signature(const FuStructLegionHid2Version *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 7, NULL);
}
/**
 * fu_struct_legion_hid2_version_get_version: (skip):
 **/
guint32
fu_struct_legion_hid2_version_get_version(const FuStructLegionHid2Version *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_legion_hid2_version_to_string: (skip):
 **/
static gchar *
fu_struct_legion_hid2_version_to_string(const FuStructLegionHid2Version *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLegionHid2Version:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_legion_hid2_version_get_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_legion_hid2_version_validate_internal(FuStructLegionHid2Version *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "VERSION", 7) != 0) {
        g_autofree gchar *str = fu_struct_legion_hid2_version_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLegionHid2Version.signature was not valid, "
                    "expected 'VERSION' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_legion_hid2_version_parse_internal(FuStructLegionHid2Version *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_legion_hid2_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_legion_hid2_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_legion_hid2_version_parse_stream: (skip):
 **/
FuStructLegionHid2Version *
fu_struct_legion_hid2_version_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructLegionHid2Version) st = fu_struct_legion_hid2_version_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 12, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructLegionHid2Version failed read of 0x%x: ", (guint) 12);
        return NULL;
    }
    if (st->buf->len != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructLegionHid2Version requested 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_legion_hid2_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
