/* Generated by wayland-scanner 1.23.1 */

#ifndef PANTHEON_SHELL_V1_SERVER_PROTOCOL_H
#define PANTHEON_SHELL_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_pantheon_shell_v1 The pantheon_shell_v1 protocol
 * @section page_ifaces_pantheon_shell_v1 Interfaces
 * - @subpage page_iface_io_elementary_pantheon_shell_v1 - create panel, widget and get more control
 * - @subpage page_iface_io_elementary_pantheon_panel_v1 - 
 * - @subpage page_iface_io_elementary_pantheon_widget_v1 - 
 * - @subpage page_iface_io_elementary_pantheon_extended_behavior_v1 - 
 * @section page_copyright_pantheon_shell_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2023 Corentin Noël <tintou@noel.tf>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct io_elementary_pantheon_extended_behavior_v1;
struct io_elementary_pantheon_panel_v1;
struct io_elementary_pantheon_shell_v1;
struct io_elementary_pantheon_widget_v1;
struct wl_surface;

#ifndef IO_ELEMENTARY_PANTHEON_SHELL_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_shell_v1 io_elementary_pantheon_shell_v1
 * @section page_iface_io_elementary_pantheon_shell_v1_desc Description
 *
 * This interface is used by the Pantheon Wayland shell to communicate with
 * the compositor.
 * @section page_iface_io_elementary_pantheon_shell_v1_api API
 * See @ref iface_io_elementary_pantheon_shell_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_shell_v1 The io_elementary_pantheon_shell_v1 interface
 *
 * This interface is used by the Pantheon Wayland shell to communicate with
 * the compositor.
 */
extern const struct wl_interface io_elementary_pantheon_shell_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_panel_v1 io_elementary_pantheon_panel_v1
 * @section page_iface_io_elementary_pantheon_panel_v1_api API
 * See @ref iface_io_elementary_pantheon_panel_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_panel_v1 The io_elementary_pantheon_panel_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_panel_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_WIDGET_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_WIDGET_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_widget_v1 io_elementary_pantheon_widget_v1
 * @section page_iface_io_elementary_pantheon_widget_v1_api API
 * See @ref iface_io_elementary_pantheon_widget_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_widget_v1 The io_elementary_pantheon_widget_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_widget_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_extended_behavior_v1 io_elementary_pantheon_extended_behavior_v1
 * @section page_iface_io_elementary_pantheon_extended_behavior_v1_api API
 * See @ref iface_io_elementary_pantheon_extended_behavior_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_extended_behavior_v1 The io_elementary_pantheon_extended_behavior_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_extended_behavior_v1_interface;
#endif

/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 * @struct io_elementary_pantheon_shell_v1_interface
 */
struct io_elementary_pantheon_shell_v1_interface {
	/**
	 * create a panel surface from a surface
	 *
	 * Create a panel surface from an existing surface.
	 */
	void (*get_panel)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t output,
			  struct wl_resource *surface);
	/**
	 * create a widget surface from a surface
	 *
	 * Create a desktop widget surface from an existing surface.
	 */
	void (*get_widget)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t output,
			   struct wl_resource *surface);
	/**
	 * create a desktop-specific surface from a surface
	 *
	 * Create a desktop-specific surface from an existing surface.
	 */
	void (*get_extended_behavior)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t output,
				      struct wl_resource *surface);
};


/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_WIDGET_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_EXTENDED_BEHAVIOR_SINCE_VERSION 1

#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * anchor
 *
 * The anchor is a placement hint to the compositor.
 */
enum io_elementary_pantheon_panel_v1_anchor {
	/**
	 * the top edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP = 0,
	/**
	 * the bottom edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM = 1,
	/**
	 * the left edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT = 2,
	/**
	 * the right edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT = 3,
};
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * Validate a io_elementary_pantheon_panel_v1 anchor value.
 *
 * @return true on success, false on error.
 * @ref io_elementary_pantheon_panel_v1_anchor
 */
static inline bool
io_elementary_pantheon_panel_v1_anchor_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM */

#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * hide mode
 *
 * How the shell should handle the window.
 */
enum io_elementary_pantheon_panel_v1_hide_mode {
	/**
	 * make the surface exclusive
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER = 0,
	/**
	 * hide when the focused window is maximized
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_MAXIMIZED_FOCUS_WINDOW = 1,
	/**
	 * hide when the focused window overlaps the surface
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_FOCUS_WINDOW = 2,
	/**
	 * hide when any window overlaps the surface
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_WINDOW = 3,
	/**
	 * always hide and only show if requested by the user
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ALWAYS = 4,
};
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * Validate a io_elementary_pantheon_panel_v1 hide_mode value.
 *
 * @return true on success, false on error.
 * @ref io_elementary_pantheon_panel_v1_hide_mode
 */
static inline bool
io_elementary_pantheon_panel_v1_hide_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_MAXIMIZED_FOCUS_WINDOW:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_FOCUS_WINDOW:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_WINDOW:
		return version >= 1;
	case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ALWAYS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM */

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * @struct io_elementary_pantheon_panel_v1_interface
 */
struct io_elementary_pantheon_panel_v1_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set panel edge anchor
	 *
	 * Tell the shell which side of the screen the panel is located.
	 * This is so that new windows do not overlap the panel and
	 * maximized windows maximize properly.
	 * @param anchor anchor
	 */
	void (*set_anchor)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t anchor);
	/**
	 * request keyboard focus
	 *
	 * Request keyboard focus, taking it away from any other window.
	 * Keyboard focus must always be manually be requested and is - in
	 * contrast to normal windows - never automatically granted by the
	 * compositor.
	 */
	void (*focus)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * set size
	 *
	 * The given size is only used for exclusive zones and collision
	 * tracking for auto hide. By default and if set to -1 the size of
	 * the surface is used.
	 */
	void (*set_size)(struct wl_client *client,
			 struct wl_resource *resource,
			 int32_t width,
			 int32_t height);
	/**
	 * set panel hide mode
	 *
	 * Tell the shell when to hide the panel.
	 * @param hide_mode hide mode
	 */
	void (*set_hide_mode)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t hide_mode);
};


/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_ANCHOR_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_FOCUS_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_HIDE_MODE_SINCE_VERSION 1

/**
 * @ingroup iface_io_elementary_pantheon_widget_v1
 * @struct io_elementary_pantheon_widget_v1_interface
 */
struct io_elementary_pantheon_widget_v1_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_io_elementary_pantheon_widget_v1
 */
#define IO_ELEMENTARY_PANTHEON_WIDGET_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 * @struct io_elementary_pantheon_extended_behavior_v1_interface
 */
struct io_elementary_pantheon_extended_behavior_v1_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set keep above
	 *
	 * Tell the shell to keep the surface above on all workspaces
	 */
	void (*set_keep_above)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * requests to keep the surface centered
	 *
	 * Request to keep the surface centered. This will cause keyboard
	 * focus to not be granted automatically but having to be requested
	 * via focus.
	 */
	void (*make_centered)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * request keyboard focus
	 *
	 * Request keyboard focus, taking it away from any other window.
	 * Keyboard focus must always be manually be requested and is - in
	 * contrast to normal windows - never automatically granted by the
	 * compositor.
	 */
	void (*focus)(struct wl_client *client,
		      struct wl_resource *resource);
};


/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_SET_KEEP_ABOVE_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_MAKE_CENTERED_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_FOCUS_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
