/* WorkspaceHideTracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspaceHideTracker.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2025 elementary, Inc. (https://elementary.io)
 */

#include "gala.h"
#include <meta/display.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <meta/window.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_WORKSPACE_HIDE_TRACKER_0_PROPERTY,
	GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY,
	GALA_WORKSPACE_HIDE_TRACKER_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_hide_tracker_properties[GALA_WORKSPACE_HIDE_TRACKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_WORKSPACE_HIDE_TRACKER_SWITCHING_WORKSPACE_PROGRESS_UPDATED_SIGNAL,
	GALA_WORKSPACE_HIDE_TRACKER_WINDOW_STATE_CHANGED_PROGRESS_UPDATED_SIGNAL,
	GALA_WORKSPACE_HIDE_TRACKER_NUM_SIGNALS
};
static guint gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_NUM_SIGNALS] = {0};

struct _GalaWorkspaceHideTrackerPrivate {
	MetaDisplay* _display;
	GalaWorkspaceHideTrackerComputeShouldHideOnWorkspace compute_func;
	gpointer compute_func_target;
	GDestroyNotify compute_func_target_destroy_notify;
	gdouble switch_workspace_progress;
	gboolean* should_hide_on_workspace_cache;
	gint should_hide_on_workspace_cache_length1;
	gint _should_hide_on_workspace_cache_size_;
};

static gint GalaWorkspaceHideTracker_private_offset;
static gpointer gala_workspace_hide_tracker_parent_class = NULL;

static void gala_workspace_hide_tracker_setup_window (GalaWorkspaceHideTracker* self,
                                               MetaWindow* window);
static void gala_workspace_hide_tracker_on_window_type_changed (GalaWorkspaceHideTracker* self,
                                                         GObject* obj,
                                                         GParamSpec* pspec);
static void _gala_workspace_hide_tracker_on_window_type_changed_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void gala_workspace_hide_tracker_recalculate_workspace (GalaWorkspaceHideTracker* self,
                                                        MetaWindow* window);
static void _gala_workspace_hide_tracker_recalculate_workspace_meta_window_position_changed (MetaWindow* _sender,
                                                                                      gpointer self);
static void _gala_workspace_hide_tracker_recalculate_workspace_meta_window_size_changed (MetaWindow* _sender,
                                                                                  gpointer self);
static void _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_window_workspace_changed (MetaWindow* _sender,
                                                                                            gpointer self);
static void _gala_workspace_hide_tracker_recalculate_workspace_meta_window_focus (MetaWindow* _sender,
                                                                           gpointer self);
static void _gala_workspace_hide_tracker_recalculate_all_workspaces_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self);
static void gala_workspace_hide_tracker_recalculate_workspace_pspec (GalaWorkspaceHideTracker* self,
                                                              GObject* obj,
                                                              GParamSpec* pspec);
static void _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void _gala_workspace_hide_tracker_recalculate_workspace_meta_window_unmanaged (MetaWindow* _sender,
                                                                               gpointer self);
static gdouble gala_workspace_hide_tracker_get_hidden_progress (GalaWorkspaceHideTracker* self);
static MetaDisplay* gala_workspace_hide_tracker_get_display (GalaWorkspaceHideTracker* self);
static void gala_workspace_hide_tracker_internal_recalculate_workspace (GalaWorkspaceHideTracker* self,
                                                                 MetaWorkspace* workspace,
                                                                 gboolean send_signal);
static GObject * gala_workspace_hide_tracker_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _gala_workspace_hide_tracker_setup_window_gfunc (gconstpointer data,
                                                      gpointer self);
static void _gala_workspace_hide_tracker_setup_window_meta_display_window_created (MetaDisplay* _sender,
                                                                            MetaWindow* object,
                                                                            gpointer self);
static void _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                                    gpointer self);
static void _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                                     gint object,
                                                                                                     gpointer self);
static void _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                                       gint object,
                                                                                                       gpointer self);
static void gala_workspace_hide_tracker_finalize (GObject * obj);
static GType gala_workspace_hide_tracker_get_type_once (void);
static void _vala_gala_workspace_hide_tracker_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_workspace_hide_tracker_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
gala_workspace_hide_tracker_get_instance_private (GalaWorkspaceHideTracker* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceHideTracker_private_offset);
}

GalaWorkspaceHideTracker*
gala_workspace_hide_tracker_construct (GType object_type,
                                       MetaDisplay* display,
                                       GalaWorkspaceHideTrackerComputeShouldHideOnWorkspace compute_func,
                                       gpointer compute_func_target)
{
	GalaWorkspaceHideTracker * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaWorkspaceHideTracker*) g_object_new (object_type, "display", display, NULL);
	(self->priv->compute_func_target_destroy_notify == NULL) ? NULL : (self->priv->compute_func_target_destroy_notify (self->priv->compute_func_target), NULL);
	self->priv->compute_func = NULL;
	self->priv->compute_func_target = NULL;
	self->priv->compute_func_target_destroy_notify = NULL;
	self->priv->compute_func = compute_func;
	self->priv->compute_func_target = compute_func_target;
	self->priv->compute_func_target_destroy_notify = NULL;
	return self;
}

GalaWorkspaceHideTracker*
gala_workspace_hide_tracker_new (MetaDisplay* display,
                                 GalaWorkspaceHideTrackerComputeShouldHideOnWorkspace compute_func,
                                 gpointer compute_func_target)
{
	return gala_workspace_hide_tracker_construct (GALA_TYPE_WORKSPACE_HIDE_TRACKER, display, compute_func, compute_func_target);
}

static void
_gala_workspace_hide_tracker_on_window_type_changed_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	gala_workspace_hide_tracker_on_window_type_changed ((GalaWorkspaceHideTracker*) self, _sender, pspec);
}

static void
_gala_workspace_hide_tracker_recalculate_workspace_meta_window_position_changed (MetaWindow* _sender,
                                                                                 gpointer self)
{
	gala_workspace_hide_tracker_recalculate_workspace ((GalaWorkspaceHideTracker*) self, _sender);
}

static void
_gala_workspace_hide_tracker_recalculate_workspace_meta_window_size_changed (MetaWindow* _sender,
                                                                             gpointer self)
{
	gala_workspace_hide_tracker_recalculate_workspace ((GalaWorkspaceHideTracker*) self, _sender);
}

static void
_gala_workspace_hide_tracker_recalculate_all_workspaces_meta_window_workspace_changed (MetaWindow* _sender,
                                                                                       gpointer self)
{
	gala_workspace_hide_tracker_recalculate_all_workspaces ((GalaWorkspaceHideTracker*) self);
}

static void
_gala_workspace_hide_tracker_recalculate_workspace_meta_window_focus (MetaWindow* _sender,
                                                                      gpointer self)
{
	gala_workspace_hide_tracker_recalculate_workspace ((GalaWorkspaceHideTracker*) self, _sender);
}

static void
_gala_workspace_hide_tracker_recalculate_all_workspaces_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self)
{
	gala_workspace_hide_tracker_recalculate_all_workspaces ((GalaWorkspaceHideTracker*) self);
}

static void
_gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	gala_workspace_hide_tracker_recalculate_workspace_pspec ((GalaWorkspaceHideTracker*) self, _sender, pspec);
}

static void
_gala_workspace_hide_tracker_recalculate_workspace_meta_window_unmanaged (MetaWindow* _sender,
                                                                          gpointer self)
{
	gala_workspace_hide_tracker_recalculate_workspace ((GalaWorkspaceHideTracker*) self, _sender);
}

static void
gala_workspace_hide_tracker_setup_window (GalaWorkspaceHideTracker* self,
                                          MetaWindow* window)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::window-type", (GCallback) _gala_workspace_hide_tracker_on_window_type_changed_g_object_notify, self, 0);
	if (!gala_utils_get_window_is_normal (window)) {
		return;
	}
	g_object_get (window, "on-all-workspaces", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gala_workspace_hide_tracker_recalculate_all_workspaces (self);
	} else {
		gala_workspace_hide_tracker_recalculate_workspace (self, window);
	}
	g_signal_connect_object (window, "position-changed", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_position_changed, self, 0);
	g_signal_connect_object (window, "size-changed", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_size_changed, self, 0);
	g_signal_connect_object (window, "workspace-changed", (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_window_workspace_changed, self, 0);
	g_signal_connect_object (window, "focus", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_focus, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::on-all-workspaces", (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::fullscreen", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::minimized", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::above", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self, 0);
	g_signal_connect_object (window, "unmanaged", (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_unmanaged, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_workspace_hide_tracker_on_window_type_changed (GalaWorkspaceHideTracker* self,
                                                    GObject* obj,
                                                    GParamSpec* pspec)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GQuark _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	guint _tmp11_;
	GQuark _tmp12_;
	guint _tmp13_;
	GQuark _tmp14_;
	guint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
	window = _tmp0_;
	g_signal_parse_name ("notify::window-type", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _gala_workspace_hide_tracker_on_window_type_changed_g_object_notify, self);
	g_signal_parse_name ("position-changed", meta_window_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_position_changed, self);
	g_signal_parse_name ("size-changed", meta_window_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_size_changed, self);
	g_signal_parse_name ("workspace-changed", meta_window_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_window_workspace_changed, self);
	g_signal_parse_name ("focus", meta_window_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_focus, self);
	g_signal_parse_name ("notify::on-all-workspaces", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_g_object_notify, self);
	g_signal_parse_name ("notify::fullscreen", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self);
	g_signal_parse_name ("notify::minimized", G_TYPE_OBJECT, &_tmp11_, &_tmp12_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, _tmp12_, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self);
	g_signal_parse_name ("notify::above", G_TYPE_OBJECT, &_tmp13_, &_tmp14_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, _tmp14_, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_pspec_g_object_notify, self);
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _gala_workspace_hide_tracker_recalculate_workspace_meta_window_unmanaged, self);
	gala_workspace_hide_tracker_setup_window (self, window);
	_g_object_unref0 (window);
}

/**
     * Updates progress, it will do nothing if update_type is COMMIT or action is not SWITCH_WORKSPACE.
     */
void
gala_workspace_hide_tracker_update (GalaWorkspaceHideTracker* self,
                                    GalaGestureTargetUpdateType update_type,
                                    GalaGestureAction action,
                                    gdouble progress)
{
	gboolean _tmp0_ = FALSE;
	gdouble new_switch_workspace_progress = 0.0;
	g_return_if_fail (self != NULL);
	if (action != GALA_GESTURE_ACTION_SWITCH_WORKSPACE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = update_type == GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT;
	}
	if (_tmp0_) {
		return;
	}
	new_switch_workspace_progress = fabs (progress);
	if (self->priv->switch_workspace_progress == new_switch_workspace_progress) {
		return;
	}
	self->priv->switch_workspace_progress = new_switch_workspace_progress;
	g_signal_emit (self, gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_SWITCHING_WORKSPACE_PROGRESS_UPDATED_SIGNAL], 0, gala_workspace_hide_tracker_get_hidden_progress (self));
}

static gdouble
gala_workspace_hide_tracker_get_hidden_progress (GalaWorkspaceHideTracker* self)
{
	gint n_workspaces = 0;
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint left_workspace = 0;
	gint right_workspace = 0;
	gdouble relative_progress = 0.0;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_;
	gboolean* _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->should_hide_on_workspace_cache;
	_tmp0__length1 = self->priv->should_hide_on_workspace_cache_length1;
	n_workspaces = _tmp0__length1;
	left_workspace = MAX ((gint) floor (self->priv->switch_workspace_progress), 0);
	right_workspace = MIN ((gint) ceil (self->priv->switch_workspace_progress), n_workspaces - 1);
	relative_progress = self->priv->switch_workspace_progress - left_workspace;
	_tmp1_ = self->priv->should_hide_on_workspace_cache;
	_tmp1__length1 = self->priv->should_hide_on_workspace_cache_length1;
	_tmp2_ = _tmp1_[left_workspace];
	_tmp3_ = self->priv->should_hide_on_workspace_cache;
	_tmp3__length1 = self->priv->should_hide_on_workspace_cache_length1;
	_tmp4_ = _tmp3_[right_workspace];
	result = (((gint) _tmp2_) * (1.0 - relative_progress)) + (((gint) _tmp4_) * relative_progress);
	return result;
}

void
gala_workspace_hide_tracker_recalculate_all_workspaces (GalaWorkspaceHideTracker* self)
{
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	workspace_manager = _tmp1_;
	_tmp2_ = workspace_manager;
	_tmp3_ = meta_workspace_manager_get_n_workspaces (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_new0 (gboolean, _tmp4_);
	self->priv->should_hide_on_workspace_cache = (g_free (self->priv->should_hide_on_workspace_cache), NULL);
	self->priv->should_hide_on_workspace_cache = _tmp5_;
	self->priv->should_hide_on_workspace_cache_length1 = _tmp4_;
	self->priv->_should_hide_on_workspace_cache_size_ = self->priv->should_hide_on_workspace_cache_length1;
	_tmp6_ = workspace_manager;
	_tmp7_ = meta_workspace_manager_get_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* workspace = NULL;
			workspace = (MetaWorkspace*) workspace_it->data;
			{
				MetaWorkspace* _tmp8_;
				_tmp8_ = workspace;
				gala_workspace_hide_tracker_internal_recalculate_workspace (self, _tmp8_, FALSE);
			}
		}
	}
	g_signal_emit (self, gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_WINDOW_STATE_CHANGED_PROGRESS_UPDATED_SIGNAL], 0, gala_workspace_hide_tracker_get_hidden_progress (self));
}

static void
gala_workspace_hide_tracker_internal_recalculate_workspace (GalaWorkspaceHideTracker* self,
                                                            MetaWorkspace* workspace,
                                                            gboolean send_signal)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean* _tmp6_;
	gint _tmp6__length1;
	guint _tmp7_;
	guint _tmp8_;
	GalaWorkspaceHideTrackerComputeShouldHideOnWorkspace _tmp9_;
	gpointer _tmp9__target;
	g_return_if_fail (self != NULL);
	if (workspace == NULL) {
		_tmp1_ = TRUE;
	} else {
		guint _tmp2_;
		guint _tmp3_;
		gboolean* _tmp4_;
		gint _tmp4__length1;
		g_object_get (workspace, "workspace-index", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->should_hide_on_workspace_cache;
		_tmp4__length1 = self->priv->should_hide_on_workspace_cache_length1;
		_tmp1_ = _tmp3_ >= ((guint) _tmp4__length1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GalaWorkspaceHideTrackerComputeShouldHideOnWorkspace _tmp5_;
		gpointer _tmp5__target;
		_tmp5_ = self->priv->compute_func;
		_tmp5__target = self->priv->compute_func_target;
		_tmp0_ = _tmp5_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->should_hide_on_workspace_cache;
	_tmp6__length1 = self->priv->should_hide_on_workspace_cache_length1;
	g_object_get (workspace, "workspace-index", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->compute_func;
	_tmp9__target = self->priv->compute_func_target;
	_tmp6_[_tmp8_] = _tmp9_ (workspace, _tmp9__target);
	if (send_signal) {
		g_signal_emit (self, gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_WINDOW_STATE_CHANGED_PROGRESS_UPDATED_SIGNAL], 0, gala_workspace_hide_tracker_get_hidden_progress (self));
	}
}

static void
gala_workspace_hide_tracker_recalculate_workspace (GalaWorkspaceHideTracker* self,
                                                   MetaWindow* window)
{
	MetaWorkspace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_workspace (window);
	gala_workspace_hide_tracker_internal_recalculate_workspace (self, _tmp0_, TRUE);
}

static void
gala_workspace_hide_tracker_recalculate_workspace_pspec (GalaWorkspaceHideTracker* self,
                                                         GObject* obj,
                                                         GParamSpec* pspec)
{
	MetaWorkspace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = meta_window_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
	gala_workspace_hide_tracker_internal_recalculate_workspace (self, _tmp0_, TRUE);
}

static MetaDisplay*
gala_workspace_hide_tracker_get_display (GalaWorkspaceHideTracker* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_hide_tracker_set_display (GalaWorkspaceHideTracker* self,
                                         MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_hide_tracker_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_hide_tracker_properties[GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY]);
	}
}

static void
_gala_workspace_hide_tracker_setup_window_gfunc (gconstpointer data,
                                                 gpointer self)
{
	gala_workspace_hide_tracker_setup_window ((GalaWorkspaceHideTracker*) self, (MetaWindow*) data);
}

static void
_gala_workspace_hide_tracker_setup_window_meta_display_window_created (MetaDisplay* _sender,
                                                                       MetaWindow* object,
                                                                       gpointer self)
{
	gala_workspace_hide_tracker_setup_window ((GalaWorkspaceHideTracker*) self, object);
}

static void
_gala_workspace_hide_tracker_recalculate_all_workspaces_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                               gpointer self)
{
	gala_workspace_hide_tracker_recalculate_all_workspaces ((GalaWorkspaceHideTracker*) self);
}

static void
_gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                                gint object,
                                                                                                gpointer self)
{
	gala_workspace_hide_tracker_recalculate_all_workspaces ((GalaWorkspaceHideTracker*) self);
}

static void
_gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                                  gint object,
                                                                                                  gpointer self)
{
	gala_workspace_hide_tracker_recalculate_all_workspaces ((GalaWorkspaceHideTracker*) self);
}

static GObject *
gala_workspace_hide_tracker_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceHideTracker * self;
	MetaDisplay* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp4_;
	MetaContext* _tmp5_;
	MetaBackend* _tmp6_;
	MetaMonitorManager* _tmp7_;
	MetaMonitorManager* _tmp8_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaDisplay* _tmp9_;
	MetaWorkspaceManager* _tmp10_;
	MetaWorkspaceManager* _tmp11_;
	MetaWorkspaceManager* _tmp12_;
	parent_class = G_OBJECT_CLASS (gala_workspace_hide_tracker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_HIDE_TRACKER, GalaWorkspaceHideTracker);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_list_all_windows (_tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, _gala_workspace_hide_tracker_setup_window_gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	_tmp3_ = self->priv->_display;
	g_signal_connect_object (_tmp3_, "window-created", (GCallback) _gala_workspace_hide_tracker_setup_window_meta_display_window_created, self, 0);
	_tmp4_ = self->priv->_display;
	_tmp5_ = meta_display_get_context (_tmp4_);
	_tmp6_ = meta_context_get_backend (_tmp5_);
	_tmp7_ = meta_backend_get_monitor_manager (_tmp6_);
	monitor_manager = _tmp7_;
	_tmp8_ = monitor_manager;
	g_signal_connect_object (_tmp8_, "monitors-changed", (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_monitor_manager_monitors_changed, self, 0);
	_tmp9_ = self->priv->_display;
	_tmp10_ = meta_display_get_workspace_manager (_tmp9_);
	workspace_manager = _tmp10_;
	_tmp11_ = workspace_manager;
	g_signal_connect_object (_tmp11_, "workspace-added", (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_added, self, 0);
	_tmp12_ = workspace_manager;
	g_signal_connect_object (_tmp12_, "workspace-removed", (GCallback) _gala_workspace_hide_tracker_recalculate_all_workspaces_meta_workspace_manager_workspace_removed, self, 0);
	gala_workspace_hide_tracker_recalculate_all_workspaces (self);
	return obj;
}

static void
gala_workspace_hide_tracker_class_init (GalaWorkspaceHideTrackerClass * klass,
                                        gpointer klass_data)
{
	gala_workspace_hide_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceHideTracker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_hide_tracker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_hide_tracker_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_hide_tracker_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_hide_tracker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY, gala_workspace_hide_tracker_properties[GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_SWITCHING_WORKSPACE_PROGRESS_UPDATED_SIGNAL] = g_signal_new ("switching-workspace-progress-updated", GALA_TYPE_WORKSPACE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	gala_workspace_hide_tracker_signals[GALA_WORKSPACE_HIDE_TRACKER_WINDOW_STATE_CHANGED_PROGRESS_UPDATED_SIGNAL] = g_signal_new ("window-state-changed-progress-updated", GALA_TYPE_WORKSPACE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
gala_workspace_hide_tracker_instance_init (GalaWorkspaceHideTracker * self,
                                           gpointer klass)
{
	gboolean* _tmp0_;
	self->priv = gala_workspace_hide_tracker_get_instance_private (self);
	self->priv->compute_func = NULL;
	self->priv->compute_func_target = NULL;
	self->priv->compute_func_target_destroy_notify = NULL;
	self->priv->switch_workspace_progress = 0.0;
	_tmp0_ = g_new0 (gboolean, 0);
	self->priv->should_hide_on_workspace_cache = _tmp0_;
	self->priv->should_hide_on_workspace_cache_length1 = 0;
	self->priv->_should_hide_on_workspace_cache_size_ = self->priv->should_hide_on_workspace_cache_length1;
}

static void
gala_workspace_hide_tracker_finalize (GObject * obj)
{
	GalaWorkspaceHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_HIDE_TRACKER, GalaWorkspaceHideTracker);
	_g_object_unref0 (self->priv->_display);
	(self->priv->compute_func_target_destroy_notify == NULL) ? NULL : (self->priv->compute_func_target_destroy_notify (self->priv->compute_func_target), NULL);
	self->priv->compute_func = NULL;
	self->priv->compute_func_target = NULL;
	self->priv->compute_func_target_destroy_notify = NULL;
	self->priv->should_hide_on_workspace_cache = (g_free (self->priv->should_hide_on_workspace_cache), NULL);
	G_OBJECT_CLASS (gala_workspace_hide_tracker_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_workspace_hide_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceHideTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_hide_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceHideTracker), 0, (GInstanceInitFunc) gala_workspace_hide_tracker_instance_init, NULL };
	GType gala_workspace_hide_tracker_type_id;
	gala_workspace_hide_tracker_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWorkspaceHideTracker", &g_define_type_info, 0);
	GalaWorkspaceHideTracker_private_offset = g_type_add_instance_private (gala_workspace_hide_tracker_type_id, sizeof (GalaWorkspaceHideTrackerPrivate));
	return gala_workspace_hide_tracker_type_id;
}

GType
gala_workspace_hide_tracker_get_type (void)
{
	static gsize gala_workspace_hide_tracker_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_hide_tracker_type_id__once)) {
		GType gala_workspace_hide_tracker_type_id;
		gala_workspace_hide_tracker_type_id = gala_workspace_hide_tracker_get_type_once ();
		g_once_init_leave (&gala_workspace_hide_tracker_type_id__once, gala_workspace_hide_tracker_type_id);
	}
	return gala_workspace_hide_tracker_type_id__once;
}

static void
_vala_gala_workspace_hide_tracker_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaWorkspaceHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_HIDE_TRACKER, GalaWorkspaceHideTracker);
	switch (property_id) {
		case GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_workspace_hide_tracker_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_hide_tracker_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaWorkspaceHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_HIDE_TRACKER, GalaWorkspaceHideTracker);
	switch (property_id) {
		case GALA_WORKSPACE_HIDE_TRACKER_DISPLAY_PROPERTY:
		gala_workspace_hide_tracker_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

