/* gitg-commit-submodule-info.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit-submodule-info.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <glib.h>
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_COMMIT_TYPE_SUBMODULE_INFO (gitg_commit_submodule_info_get_type ())
#define GITG_COMMIT_SUBMODULE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_COMMIT_TYPE_SUBMODULE_INFO, GitgCommitSubmoduleInfo))
#define GITG_COMMIT_SUBMODULE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_COMMIT_TYPE_SUBMODULE_INFO, GitgCommitSubmoduleInfoClass))
#define GITG_COMMIT_IS_SUBMODULE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_COMMIT_TYPE_SUBMODULE_INFO))
#define GITG_COMMIT_IS_SUBMODULE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_COMMIT_TYPE_SUBMODULE_INFO))
#define GITG_COMMIT_SUBMODULE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_COMMIT_TYPE_SUBMODULE_INFO, GitgCommitSubmoduleInfoClass))

typedef struct _GitgCommitSubmoduleInfo GitgCommitSubmoduleInfo;
typedef struct _GitgCommitSubmoduleInfoClass GitgCommitSubmoduleInfoClass;
typedef struct _GitgCommitSubmoduleInfoPrivate GitgCommitSubmoduleInfoPrivate;
enum  {
	GITG_COMMIT_SUBMODULE_INFO_0_PROPERTY,
	GITG_COMMIT_SUBMODULE_INFO_SUBMODULE_PROPERTY,
	GITG_COMMIT_SUBMODULE_INFO_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_submodule_info_properties[GITG_COMMIT_SUBMODULE_INFO_NUM_PROPERTIES];
#define _ggit_submodule_unref0(var) ((var == NULL) ? NULL : (var = (ggit_submodule_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
enum  {
	GITG_COMMIT_SUBMODULE_INFO_REQUEST_OPEN_REPOSITORY_SIGNAL,
	GITG_COMMIT_SUBMODULE_INFO_NUM_SIGNALS
};
static guint gitg_commit_submodule_info_signals[GITG_COMMIT_SUBMODULE_INFO_NUM_SIGNALS] = {0};

struct _GitgCommitSubmoduleInfo {
	GtkGrid parent_instance;
	GitgCommitSubmoduleInfoPrivate * priv;
};

struct _GitgCommitSubmoduleInfoClass {
	GtkGridClass parent_class;
};

struct _GitgCommitSubmoduleInfoPrivate {
	GtkLabel* d_label_path;
	GtkLabel* d_label_url;
	GtkLabel* d_label_sha1;
	GtkLabel* d_label_subject;
	GgitSubmodule* d_submodule;
};

static gint GitgCommitSubmoduleInfo_private_offset;
static gpointer gitg_commit_submodule_info_parent_class = NULL;

VALA_EXTERN GType gitg_commit_submodule_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgCommitSubmoduleInfo, g_object_unref)
static void gitg_commit_submodule_info_update_info_from_repository (GitgCommitSubmoduleInfo* self,
                                                             GgitOId* oid,
                                                             GgitSubmodule* submodule);
static void gitg_commit_submodule_info_on_open_button_clicked (GitgCommitSubmoduleInfo* self);
static void _gitg_commit_submodule_info_on_open_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
VALA_EXTERN GitgCommitSubmoduleInfo* gitg_commit_submodule_info_new (void);
VALA_EXTERN GitgCommitSubmoduleInfo* gitg_commit_submodule_info_construct (GType object_type);
VALA_EXTERN void gitg_commit_submodule_info_set_submodule (GitgCommitSubmoduleInfo* self,
                                               GgitSubmodule* value);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_commit_submodule_info_finalize (GObject * obj);
static GType gitg_commit_submodule_info_get_type_once (void);
static void _vala_gitg_commit_submodule_info_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
gitg_commit_submodule_info_get_instance_private (GitgCommitSubmoduleInfo* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommitSubmoduleInfo_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_commit_submodule_info_update_info_from_repository (GitgCommitSubmoduleInfo* self,
                                                        GgitOId* oid,
                                                        GgitSubmodule* submodule)
{
	GitgRepository* repo = NULL;
	GtkLabel* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (oid != NULL);
	g_return_if_fail (submodule != NULL);
	_tmp0_ = self->priv->d_label_subject;
	gtk_label_set_text (_tmp0_, "");
	{
		GgitRepository* _tmp1_ = NULL;
		GgitRepository* _tmp2_;
		GitgRepository* _tmp3_;
		_tmp2_ = ggit_submodule_open (submodule, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GITG_TYPE_REPOSITORY) ? ((GitgRepository*) _tmp1_) : NULL);
		_g_object_unref0 (repo);
		repo = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (repo);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GitgCommit* commit = NULL;
		GitgRepository* _tmp4_;
		gpointer _tmp5_;
		GitgCommit* _tmp6_;
		_tmp4_ = repo;
		_tmp5_ = gitg_repository_lookup (_tmp4_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, oid, &_inner_error0_);
		commit = (GitgCommit*) _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp6_ = commit;
		if (_tmp6_ != NULL) {
			GtkLabel* _tmp7_;
			GitgCommit* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = self->priv->d_label_subject;
			_tmp8_ = commit;
			_tmp9_ = ggit_commit_get_subject ((GgitCommit*) _tmp8_);
			gtk_label_set_text (_tmp7_, _tmp9_);
		}
		_g_object_unref0 (commit);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (repo);
}

static void
gitg_commit_submodule_info_on_open_button_clicked (GitgCommitSubmoduleInfo* self)
{
	GgitSubmodule* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_submodule;
	g_signal_emit (self, gitg_commit_submodule_info_signals[GITG_COMMIT_SUBMODULE_INFO_REQUEST_OPEN_REPOSITORY_SIGNAL], 0, _tmp0_);
}

static void
_gitg_commit_submodule_info_on_open_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	gitg_commit_submodule_info_on_open_button_clicked ((GitgCommitSubmoduleInfo*) self);
}

GitgCommitSubmoduleInfo*
gitg_commit_submodule_info_construct (GType object_type)
{
	GitgCommitSubmoduleInfo * self = NULL;
	self = (GitgCommitSubmoduleInfo*) g_object_new (object_type, NULL);
	return self;
}

GitgCommitSubmoduleInfo*
gitg_commit_submodule_info_new (void)
{
	return gitg_commit_submodule_info_construct (GITG_COMMIT_TYPE_SUBMODULE_INFO);
}

static gpointer
_ggit_submodule_ref0 (gpointer self)
{
	return self ? ggit_submodule_ref (self) : NULL;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

void
gitg_commit_submodule_info_set_submodule (GitgCommitSubmoduleInfo* self,
                                          GgitSubmodule* value)
{
	GgitSubmodule* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ggit_submodule_ref0 (value);
	_ggit_submodule_unref0 (self->priv->d_submodule);
	self->priv->d_submodule = _tmp0_;
	if (value != NULL) {
		GtkLabel* _tmp1_;
		const gchar* _tmp2_;
		gchar* submodule_url = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		GtkLabel* _tmp8_;
		GgitOId* oid = NULL;
		GgitOId* _tmp9_;
		GtkLabel* _tmp10_;
		GgitOId* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GgitOId* _tmp14_;
		_tmp1_ = self->priv->d_label_path;
		_tmp2_ = ggit_submodule_get_path (value);
		gtk_label_set_text (_tmp1_, _tmp2_);
		_tmp3_ = ggit_submodule_get_url (value);
		_tmp4_ = g_strdup (_tmp3_);
		submodule_url = _tmp4_;
		_tmp6_ = submodule_url;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = submodule_url;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = "";
		}
		_tmp8_ = self->priv->d_label_url;
		gtk_label_set_text (_tmp8_, _tmp5_);
		_tmp9_ = ggit_submodule_get_workdir_id (value);
		oid = _tmp9_;
		_tmp10_ = self->priv->d_label_sha1;
		_tmp11_ = oid;
		_tmp12_ = ggit_oid_to_string (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_label_set_text (_tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = oid;
		gitg_commit_submodule_info_update_info_from_repository (self, _tmp14_, value);
		__vala_GgitOId_free0 (oid);
		_g_free0 (submodule_url);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_submodule_info_properties[GITG_COMMIT_SUBMODULE_INFO_SUBMODULE_PROPERTY]);
}

static void
gitg_commit_submodule_info_class_init (GitgCommitSubmoduleInfoClass * klass,
                                       gpointer klass_data)
{
	gitg_commit_submodule_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommitSubmoduleInfo_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_submodule_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_submodule_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_SUBMODULE_INFO_SUBMODULE_PROPERTY, gitg_commit_submodule_info_properties[GITG_COMMIT_SUBMODULE_INFO_SUBMODULE_PROPERTY] = g_param_spec_boxed ("submodule", "submodule", "submodule", ggit_submodule_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-commit-submodule-info.ui");
	gitg_commit_submodule_info_signals[GITG_COMMIT_SUBMODULE_INFO_REQUEST_OPEN_REPOSITORY_SIGNAL] = g_signal_new ("request-open-repository", GITG_COMMIT_TYPE_SUBMODULE_INFO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, ggit_submodule_get_type ());
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_path", FALSE, GitgCommitSubmoduleInfo_private_offset + G_STRUCT_OFFSET (GitgCommitSubmoduleInfoPrivate, d_label_path));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_url", FALSE, GitgCommitSubmoduleInfo_private_offset + G_STRUCT_OFFSET (GitgCommitSubmoduleInfoPrivate, d_label_url));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_sha1", FALSE, GitgCommitSubmoduleInfo_private_offset + G_STRUCT_OFFSET (GitgCommitSubmoduleInfoPrivate, d_label_sha1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_subject", FALSE, GitgCommitSubmoduleInfo_private_offset + G_STRUCT_OFFSET (GitgCommitSubmoduleInfoPrivate, d_label_subject));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_open_button_clicked", G_CALLBACK(_gitg_commit_submodule_info_on_open_button_clicked_gtk_button_clicked));
}

static void
gitg_commit_submodule_info_instance_init (GitgCommitSubmoduleInfo * self,
                                          gpointer klass)
{
	self->priv = gitg_commit_submodule_info_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_commit_submodule_info_finalize (GObject * obj)
{
	GitgCommitSubmoduleInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_COMMIT_TYPE_SUBMODULE_INFO, GitgCommitSubmoduleInfo);
	_ggit_submodule_unref0 (self->priv->d_submodule);
	G_OBJECT_CLASS (gitg_commit_submodule_info_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_submodule_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitSubmoduleInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_submodule_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommitSubmoduleInfo), 0, (GInstanceInitFunc) gitg_commit_submodule_info_instance_init, NULL };
	GType gitg_commit_submodule_info_type_id;
	gitg_commit_submodule_info_type_id = g_type_register_static (gtk_grid_get_type (), "GitgCommitSubmoduleInfo", &g_define_type_info, 0);
	GitgCommitSubmoduleInfo_private_offset = g_type_add_instance_private (gitg_commit_submodule_info_type_id, sizeof (GitgCommitSubmoduleInfoPrivate));
	return gitg_commit_submodule_info_type_id;
}

GType
gitg_commit_submodule_info_get_type (void)
{
	static gsize gitg_commit_submodule_info_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_submodule_info_type_id__once)) {
		GType gitg_commit_submodule_info_type_id;
		gitg_commit_submodule_info_type_id = gitg_commit_submodule_info_get_type_once ();
		g_once_init_leave (&gitg_commit_submodule_info_type_id__once, gitg_commit_submodule_info_type_id);
	}
	return gitg_commit_submodule_info_type_id__once;
}

static void
_vala_gitg_commit_submodule_info_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GitgCommitSubmoduleInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_COMMIT_TYPE_SUBMODULE_INFO, GitgCommitSubmoduleInfo);
	switch (property_id) {
		case GITG_COMMIT_SUBMODULE_INFO_SUBMODULE_PROPERTY:
		gitg_commit_submodule_info_set_submodule (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

