/* gitg-cell-renderer-lanes.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-cell-renderer-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_CELL_RENDERER_LANES_0_PROPERTY,
	GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY,
	GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY,
	GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY,
	GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY,
	GITG_CELL_RENDERER_LANES_LABELS_PROPERTY,
	GITG_CELL_RENDERER_LANES_NUM_PROPERTIES
};
static GParamSpec* gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gdouble (*GitgCellRendererLanesDirectionFunc) (gdouble i, gpointer user_data);
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgCellRendererLanesPrivate {
	GitgCommit* _commit;
	GitgCommit* _next_commit;
	guint _lane_width;
	guint _dot_width;
	GSList* _labels;
	gint d_last_height;
};

static gint GitgCellRendererLanes_private_offset;
static gpointer gitg_cell_renderer_lanes_parent_class = NULL;

static guint gitg_cell_renderer_lanes_total_width (GitgCellRendererLanes* self,
                                            GtkWidget* widget);
static guint gitg_cell_renderer_lanes_get_num_visible_lanes (GitgCellRendererLanes* self);
static void gitg_cell_renderer_lanes_real_get_preferred_width (GtkCellRenderer* base,
                                                        GtkWidget* widget,
                                                        gint* minimum_width,
                                                        gint* natural_width);
static void gitg_cell_renderer_lanes_draw_arrow (GitgCellRendererLanes* self,
                                          cairo_t* context,
                                          GdkRectangle* area,
                                          guint laneidx,
                                          gboolean top);
static void gitg_cell_renderer_lanes_draw_arrows (GitgCellRendererLanes* self,
                                           cairo_t* context,
                                           GdkRectangle* area);
static void gitg_cell_renderer_lanes_draw_paths_real (GitgCellRendererLanes* self,
                                               cairo_t* context,
                                               GdkRectangle* area,
                                               GitgCommit* commit,
                                               GitgCellRendererLanesDirectionFunc f,
                                               gpointer f_target,
                                               gdouble yoffset);
static void gitg_cell_renderer_lanes_draw_top_paths (GitgCellRendererLanes* self,
                                              cairo_t* context,
                                              GdkRectangle* area,
                                              GitgCellRendererLanesDirectionFunc f,
                                              gpointer f_target);
static void gitg_cell_renderer_lanes_draw_bottom_paths (GitgCellRendererLanes* self,
                                                 cairo_t* context,
                                                 GdkRectangle* area,
                                                 GitgCellRendererLanesDirectionFunc f,
                                                 gpointer f_target);
static void gitg_cell_renderer_lanes_draw_paths (GitgCellRendererLanes* self,
                                          cairo_t* context,
                                          GdkRectangle* area,
                                          GitgCellRendererLanesDirectionFunc f,
                                          gpointer f_target);
static void gitg_cell_renderer_lanes_draw_indicator (GitgCellRendererLanes* self,
                                              cairo_t* context,
                                              GdkRectangle* area,
                                              GitgCellRendererLanesDirectionFunc f,
                                              gpointer f_target);
static void gitg_cell_renderer_lanes_draw_labels (GitgCellRendererLanes* self,
                                           cairo_t* context,
                                           GtkWidget* widget,
                                           GdkRectangle* area);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void gitg_cell_renderer_lanes_draw_lane (GitgCellRendererLanes* self,
                                         cairo_t* context,
                                         GtkWidget* widget,
                                         GdkRectangle* area);
static gdouble ___lambda33_ (GitgCellRendererLanes* self,
                      gdouble a);
static gdouble ____lambda33__gitg_cell_renderer_lanes_direction_func (gdouble i,
                                                               gpointer self);
static gdouble ___lambda34_ (GitgCellRendererLanes* self,
                      gdouble a);
static gdouble ____lambda34__gitg_cell_renderer_lanes_direction_func (gdouble i,
                                                               gpointer self);
static void gitg_cell_renderer_lanes_real_render (GtkCellRenderer* base,
                                           cairo_t* context,
                                           GtkWidget* widget,
                                           GdkRectangle* area,
                                           GdkRectangle* cell_area,
                                           GtkCellRendererState flags);
static void gitg_cell_renderer_lanes_finalize (GObject * obj);
static GType gitg_cell_renderer_lanes_get_type_once (void);
static void _vala_gitg_cell_renderer_lanes_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gitg_cell_renderer_lanes_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
gitg_cell_renderer_lanes_get_instance_private (GitgCellRendererLanes* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCellRendererLanes_private_offset);
}

static guint
gitg_cell_renderer_lanes_total_width (GitgCellRendererLanes* self,
                                      GtkWidget* widget)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	GSList* _tmp5_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (widget != NULL, 0U);
	_tmp0_ = gitg_cell_renderer_lanes_get_num_visible_lanes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_lane_width;
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_labels;
	result = (_tmp1_ * _tmp2_) + gitg_label_renderer_width (widget, _tmp4_, _tmp5_);
	return result;
}

static void
gitg_cell_renderer_lanes_real_get_preferred_width (GtkCellRenderer* base,
                                                   GtkWidget* widget,
                                                   gint* minimum_width,
                                                   gint* natural_width)
{
	GitgCellRendererLanes * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint w = 0;
	self = (GitgCellRendererLanes*) base;
	g_return_if_fail (widget != NULL);
	GTK_CELL_RENDERER_CLASS (gitg_cell_renderer_lanes_parent_class)->get_preferred_width ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), widget, &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	w = (gint) gitg_cell_renderer_lanes_total_width (self, widget);
	if (w > _vala_minimum_width) {
		_vala_minimum_width = w;
	}
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static void
gitg_cell_renderer_lanes_draw_arrow (GitgCellRendererLanes* self,
                                     cairo_t* context,
                                     GdkRectangle* area,
                                     guint laneidx,
                                     gboolean top)
{
	gdouble cw = 0.0;
	guint _tmp0_;
	gdouble xpos = 0.0;
	GdkRectangle _tmp1_;
	gint _tmp2_ = 0;
	gdouble df = 0.0;
	GdkRectangle _tmp3_;
	gdouble ypos = 0.0;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	gdouble q = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = self->priv->_lane_width;
	cw = (gdouble) _tmp0_;
	_tmp1_ = *area;
	xpos = (_tmp1_.x + (laneidx * cw)) + (cw / 2.0);
	if (top) {
		_tmp2_ = -1;
	} else {
		_tmp2_ = 1;
	}
	_tmp3_ = *area;
	df = (_tmp2_ * 0.25) * _tmp3_.height;
	_tmp4_ = *area;
	_tmp5_ = *area;
	ypos = (_tmp4_.y + (_tmp5_.height / 2.0)) + df;
	q = cw / 4.0;
	if (top) {
		_tmp6_ = q;
	} else {
		_tmp6_ = -q;
	}
	cairo_move_to (context, xpos - q, ypos + _tmp6_);
	cairo_line_to (context, xpos, ypos);
	if (top) {
		_tmp7_ = q;
	} else {
		_tmp7_ = -q;
	}
	cairo_line_to (context, xpos + q, ypos + _tmp7_);
	cairo_stroke (context);
	cairo_move_to (context, xpos, ypos);
	cairo_line_to (context, xpos, ypos - df);
	cairo_stroke (context);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_cell_renderer_lanes_draw_arrows (GitgCellRendererLanes* self,
                                      cairo_t* context,
                                      GdkRectangle* area)
{
	guint to = 0U;
	GitgCommit* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	to = (guint) 0;
	_tmp0_ = self->priv->_commit;
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
		lane_collection = _tmp1_;
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
			GitgLane* _tmp2_;
			GitgLane* lane = NULL;
			_tmp2_ = _g_object_ref0 ((GitgLane*) lane_it->data);
			lane = _tmp2_;
			{
				GitgColor* color = NULL;
				GitgLane* _tmp3_;
				GitgColor* _tmp4_;
				GitgColor* _tmp5_;
				GitgColor* _tmp6_;
				gdouble _tmp7_;
				gdouble _tmp8_;
				GitgColor* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				GitgColor* _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				GitgLane* _tmp15_;
				guint _tmp19_;
				_tmp3_ = lane;
				_tmp4_ = _tmp3_->color;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				color = _tmp5_;
				_tmp6_ = color;
				_tmp7_ = gitg_color_get_r (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = color;
				_tmp10_ = gitg_color_get_g (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = color;
				_tmp13_ = gitg_color_get_b (_tmp12_);
				_tmp14_ = _tmp13_;
				cairo_set_source_rgb (context, _tmp8_, _tmp11_, _tmp14_);
				_tmp15_ = lane;
				if (_tmp15_->tag == GITG_LANE_TAG_START) {
					GdkRectangle _tmp16_;
					_tmp16_ = *area;
					gitg_cell_renderer_lanes_draw_arrow (self, context, &_tmp16_, to, TRUE);
				} else {
					GitgLane* _tmp17_;
					_tmp17_ = lane;
					if (_tmp17_->tag == GITG_LANE_TAG_END) {
						GdkRectangle _tmp18_;
						_tmp18_ = *area;
						gitg_cell_renderer_lanes_draw_arrow (self, context, &_tmp18_, to, FALSE);
					}
				}
				to = to + 1;
				_tmp19_ = to;
				_g_object_unref0 (color);
				_g_object_unref0 (lane);
			}
		}
	}
}

static void
gitg_cell_renderer_lanes_draw_paths_real (GitgCellRendererLanes* self,
                                          cairo_t* context,
                                          GdkRectangle* area,
                                          GitgCommit* commit,
                                          GitgCellRendererLanesDirectionFunc f,
                                          gpointer f_target,
                                          gdouble yoffset)
{
	gint to = 0;
	gdouble cw = 0.0;
	guint _tmp0_;
	gdouble ch = 0.0;
	GdkRectangle _tmp1_;
	GSList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	if (commit == NULL) {
		return;
	}
	to = 0;
	_tmp0_ = self->priv->_lane_width;
	cw = (gdouble) _tmp0_;
	_tmp1_ = *area;
	ch = _tmp1_.height / 2.0;
	_tmp2_ = gitg_commit_get_lanes (commit);
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
		lane_collection = _tmp2_;
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
			GitgLane* _tmp3_;
			GitgLane* lane = NULL;
			_tmp3_ = _g_object_ref0 ((GitgLane*) lane_it->data);
			lane = _tmp3_;
			{
				GitgLane* _tmp4_;
				GitgColor* color = NULL;
				GitgLane* _tmp6_;
				GitgColor* _tmp7_;
				GitgColor* _tmp8_;
				GitgColor* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				GitgColor* _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				GitgColor* _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
				GitgLane* _tmp18_;
				GSList* _tmp19_;
				gint _tmp25_;
				_tmp4_ = lane;
				if ((_tmp4_->tag & GITG_LANE_TAG_HIDDEN) != 0) {
					gint _tmp5_;
					to = to + 1;
					_tmp5_ = to;
					_g_object_unref0 (lane);
					continue;
				}
				_tmp6_ = lane;
				_tmp7_ = _tmp6_->color;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				color = _tmp8_;
				_tmp9_ = color;
				_tmp10_ = gitg_color_get_r (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = color;
				_tmp13_ = gitg_color_get_g (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = color;
				_tmp16_ = gitg_color_get_b (_tmp15_);
				_tmp17_ = _tmp16_;
				cairo_set_source_rgb (context, _tmp11_, _tmp14_, _tmp17_);
				_tmp18_ = lane;
				_tmp19_ = _tmp18_->from;
				{
					GSList* from_collection = NULL;
					GSList* from_it = NULL;
					from_collection = _tmp19_;
					for (from_it = from_collection; from_it != NULL; from_it = from_it->next) {
						gint from = 0;
						from = (gint) ((gintptr) from_it->data);
						{
							gdouble x1 = 0.0;
							GdkRectangle _tmp20_;
							gdouble x2 = 0.0;
							GdkRectangle _tmp21_;
							gdouble y1 = 0.0;
							GdkRectangle _tmp22_;
							gdouble y2 = 0.0;
							GdkRectangle _tmp23_;
							gdouble y3 = 0.0;
							GdkRectangle _tmp24_;
							_tmp20_ = *area;
							x1 = _tmp20_.x + f ((from * cw) + (cw / 2.0), f_target);
							_tmp21_ = *area;
							x2 = _tmp21_.x + f ((to * cw) + (cw / 2.0), f_target);
							_tmp22_ = *area;
							y1 = _tmp22_.y + (yoffset * ch);
							_tmp23_ = *area;
							y2 = _tmp23_.y + ((yoffset + 1) * ch);
							_tmp24_ = *area;
							y3 = _tmp24_.y + ((yoffset + 2) * ch);
							cairo_move_to (context, x1, y1);
							cairo_curve_to (context, x1, y2, x2, y2, x2, y3);
							cairo_stroke (context);
						}
					}
				}
				to = to + 1;
				_tmp25_ = to;
				_g_object_unref0 (color);
				_g_object_unref0 (lane);
			}
		}
	}
}

static void
gitg_cell_renderer_lanes_draw_top_paths (GitgCellRendererLanes* self,
                                         cairo_t* context,
                                         GdkRectangle* area,
                                         GitgCellRendererLanesDirectionFunc f,
                                         gpointer f_target)
{
	GdkRectangle _tmp0_;
	GitgCommit* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = *area;
	_tmp1_ = self->priv->_commit;
	gitg_cell_renderer_lanes_draw_paths_real (self, context, &_tmp0_, _tmp1_, f, f_target, (gdouble) -1);
}

static void
gitg_cell_renderer_lanes_draw_bottom_paths (GitgCellRendererLanes* self,
                                            cairo_t* context,
                                            GdkRectangle* area,
                                            GitgCellRendererLanesDirectionFunc f,
                                            gpointer f_target)
{
	GdkRectangle _tmp0_;
	GitgCommit* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = *area;
	_tmp1_ = self->priv->_next_commit;
	gitg_cell_renderer_lanes_draw_paths_real (self, context, &_tmp0_, _tmp1_, f, f_target, (gdouble) 1);
}

static void
gitg_cell_renderer_lanes_draw_paths (GitgCellRendererLanes* self,
                                     cairo_t* context,
                                     GdkRectangle* area,
                                     GitgCellRendererLanesDirectionFunc f,
                                     gpointer f_target)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	cairo_set_line_width (context, 2.0);
	cairo_set_line_cap (context, CAIRO_LINE_CAP_ROUND);
	cairo_save (context);
	_tmp0_ = *area;
	gitg_cell_renderer_lanes_draw_top_paths (self, context, &_tmp0_, f, f_target);
	_tmp1_ = *area;
	gitg_cell_renderer_lanes_draw_bottom_paths (self, context, &_tmp1_, f, f_target);
	_tmp2_ = *area;
	gitg_cell_renderer_lanes_draw_arrows (self, context, &_tmp2_);
	cairo_restore (context);
}

static void
gitg_cell_renderer_lanes_draw_indicator (GitgCellRendererLanes* self,
                                         cairo_t* context,
                                         GdkRectangle* area,
                                         GitgCellRendererLanesDirectionFunc f,
                                         gpointer f_target)
{
	gdouble offset = 0.0;
	gdouble radius = 0.0;
	GitgCommit* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GdkRectangle _tmp9_;
	GitgCommit* _tmp10_;
	GitgLane* _tmp11_;
	GitgLane* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = self->priv->_commit;
	_tmp1_ = gitg_commit_get_mylane (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_lane_width;
	_tmp4_ = self->priv->_lane_width;
	_tmp5_ = self->priv->_dot_width;
	offset = (_tmp2_ * _tmp3_) + ((_tmp4_ - _tmp5_) / 2.0);
	_tmp6_ = self->priv->_dot_width;
	radius = _tmp6_ / 2.0;
	cairo_set_line_width (context, 0.0);
	_tmp7_ = *area;
	_tmp8_ = *area;
	_tmp9_ = *area;
	cairo_arc (context, _tmp7_.x + f (offset + radius, f_target), _tmp8_.y + (_tmp9_.height / 2.0), radius, (gdouble) 0, 2 * G_PI);
	cairo_set_source_rgb (context, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_stroke_preserve (context);
	_tmp10_ = self->priv->_commit;
	_tmp11_ = gitg_commit_get_lane (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		GitgColor* color = NULL;
		GitgCommit* _tmp13_;
		GitgLane* _tmp14_;
		GitgLane* _tmp15_;
		GitgColor* _tmp16_;
		GitgColor* _tmp17_;
		GitgColor* _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		GitgColor* _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		GitgColor* _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		_tmp13_ = self->priv->_commit;
		_tmp14_ = gitg_commit_get_lane (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_->color;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		color = _tmp17_;
		_tmp18_ = color;
		_tmp19_ = gitg_color_get_r (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = color;
		_tmp22_ = gitg_color_get_g (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = color;
		_tmp25_ = gitg_color_get_b (_tmp24_);
		_tmp26_ = _tmp25_;
		cairo_set_source_rgb (context, _tmp20_, _tmp23_, _tmp26_);
		_g_object_unref0 (color);
	}
	cairo_fill (context);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
gitg_cell_renderer_lanes_draw_labels (GitgCellRendererLanes* self,
                                      cairo_t* context,
                                      GtkWidget* widget,
                                      GdkRectangle* area)
{
	gint offset = 0;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp5_;
	PangoFontDescription* _tmp6_;
	GSList* _tmp7_;
	GdkRectangle _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = gitg_cell_renderer_lanes_get_num_visible_lanes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_lane_width;
	offset = (gint) (_tmp1_ * _tmp2_);
	_tmp3_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp3_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	if (rtl) {
		offset = -offset;
	}
	cairo_save (context);
	cairo_translate (context, (gdouble) offset, (gdouble) 0);
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_labels;
	_tmp8_ = *area;
	gitg_label_renderer_draw (widget, _tmp6_, context, _tmp7_, &_tmp8_);
	__vala_PangoFontDescription_free0 (_tmp6_);
	cairo_restore (context);
}

static gdouble
___lambda33_ (GitgCellRendererLanes* self,
              gdouble a)
{
	gdouble result;
	result = -a;
	return result;
}

static gdouble
____lambda33__gitg_cell_renderer_lanes_direction_func (gdouble i,
                                                       gpointer self)
{
	gdouble result;
	result = ___lambda33_ ((GitgCellRendererLanes*) self, i);
	return result;
}

static gdouble
___lambda34_ (GitgCellRendererLanes* self,
              gdouble a)
{
	gdouble result;
	result = a;
	return result;
}

static gdouble
____lambda34__gitg_cell_renderer_lanes_direction_func (gdouble i,
                                                       gpointer self)
{
	gdouble result;
	result = ___lambda34_ ((GitgCellRendererLanes*) self, i);
	return result;
}

static void
gitg_cell_renderer_lanes_draw_lane (GitgCellRendererLanes* self,
                                    cairo_t* context,
                                    GtkWidget* widget,
                                    GdkRectangle* area)
{
	GitgCellRendererLanesDirectionFunc f = NULL;
	gpointer f_target = NULL;
	GDestroyNotify f_target_destroy_notify = NULL;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp0_;
	GdkRectangle _tmp2_;
	GitgCellRendererLanesDirectionFunc _tmp3_;
	gpointer _tmp3__target;
	GdkRectangle _tmp4_;
	GitgCellRendererLanesDirectionFunc _tmp5_;
	gpointer _tmp5__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp0_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	cairo_save (context);
	if (rtl) {
		GdkRectangle _tmp1_;
		_tmp1_ = *area;
		cairo_translate (context, (gdouble) _tmp1_.width, (gdouble) 0);
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
		f = NULL;
		f_target = NULL;
		f_target_destroy_notify = NULL;
		f = ____lambda33__gitg_cell_renderer_lanes_direction_func;
		f_target = g_object_ref (self);
		f_target_destroy_notify = g_object_unref;
	} else {
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
		f = NULL;
		f_target = NULL;
		f_target_destroy_notify = NULL;
		f = ____lambda34__gitg_cell_renderer_lanes_direction_func;
		f_target = g_object_ref (self);
		f_target_destroy_notify = g_object_unref;
	}
	_tmp2_ = *area;
	_tmp3_ = f;
	_tmp3__target = f_target;
	gitg_cell_renderer_lanes_draw_paths (self, context, &_tmp2_, _tmp3_, _tmp3__target);
	_tmp4_ = *area;
	_tmp5_ = f;
	_tmp5__target = f_target;
	gitg_cell_renderer_lanes_draw_indicator (self, context, &_tmp4_, _tmp5_, _tmp5__target);
	cairo_restore (context);
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
}

static void
gitg_cell_renderer_lanes_real_render (GtkCellRenderer* base,
                                      cairo_t* context,
                                      GtkWidget* widget,
                                      GdkRectangle* area,
                                      GdkRectangle* cell_area,
                                      GtkCellRendererState flags)
{
	GitgCellRendererLanes * self;
	GdkRectangle ncell_area = {0};
	GdkRectangle _tmp0_;
	GdkRectangle narea = {0};
	GdkRectangle _tmp1_;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp2_;
	GdkRectangle _tmp3_;
	GitgCommit* _tmp4_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	self = (GitgCellRendererLanes*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = *cell_area;
	ncell_area = _tmp0_;
	_tmp1_ = *area;
	narea = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp2_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	_tmp3_ = *area;
	self->priv->d_last_height = _tmp3_.height;
	_tmp4_ = self->priv->_commit;
	if (_tmp4_ != NULL) {
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_;
		GdkRectangle _tmp7_;
		guint tw = 0U;
		cairo_save (context);
		_tmp5_ = *area;
		gdk_cairo_rectangle (context, &_tmp5_);
		cairo_clip (context);
		_tmp6_ = *area;
		gitg_cell_renderer_lanes_draw_lane (self, context, widget, &_tmp6_);
		_tmp7_ = *area;
		gitg_cell_renderer_lanes_draw_labels (self, context, widget, &_tmp7_);
		tw = gitg_cell_renderer_lanes_total_width (self, widget);
		if (!rtl) {
			narea.x = narea.x + ((gint) tw);
			ncell_area.x = ncell_area.x + ((gint) tw);
		} else {
			narea.width = narea.width - ((gint) tw);
			ncell_area.width = ncell_area.width - ((gint) tw);
		}
		cairo_restore (context);
	}
	g_object_get ((GtkCellRendererText*) self, "text", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = rtl == (pango_find_base_dir (_tmp10_, -1) != PANGO_DIRECTION_RTL);
	_g_free0 (_tmp10_);
	if (_tmp11_) {
		g_object_set ((GtkCellRenderer*) self, "xalign", 1.0f, NULL);
	}
	_tmp12_ = narea;
	_tmp13_ = ncell_area;
	GTK_CELL_RENDERER_CLASS (gitg_cell_renderer_lanes_parent_class)->render ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), context, widget, &_tmp12_, &_tmp13_, flags);
}

GitgRef*
gitg_cell_renderer_lanes_get_ref_at_pos (GitgCellRendererLanes* self,
                                         GtkWidget* widget,
                                         gint x,
                                         gint cell_w,
                                         gint* hot_x)
{
	gint _vala_hot_x = 0;
	gboolean rtl = FALSE;
	GtkStyleContext* _tmp0_;
	gint offset = 0;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp5_;
	PangoFontDescription* _tmp6_;
	GSList* _tmp7_;
	gint _tmp8_ = 0;
	GitgRef* _tmp9_;
	GitgRef* _tmp10_;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	rtl = (gtk_style_context_get_state (_tmp0_) & GTK_STATE_FLAG_DIR_RTL) != 0;
	_tmp1_ = gitg_cell_renderer_lanes_get_num_visible_lanes (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_lane_width;
	offset = (gint) (_tmp2_ * _tmp3_);
	if (rtl) {
		x = cell_w - x;
	}
	g_object_get ((GtkCellRendererText*) self, "font-desc", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_labels;
	_tmp9_ = gitg_label_renderer_get_ref_at_pos (widget, _tmp6_, _tmp7_, x - offset, &_tmp8_);
	_vala_hot_x = _tmp8_;
	_tmp10_ = _tmp9_;
	__vala_PangoFontDescription_free0 (_tmp6_);
	result = _tmp10_;
	if (hot_x) {
		*hot_x = _vala_hot_x;
	}
	return result;
}

GitgCellRendererLanes*
gitg_cell_renderer_lanes_construct (GType object_type)
{
	GitgCellRendererLanes * self = NULL;
	self = (GitgCellRendererLanes*) g_object_new (object_type, NULL);
	return self;
}

GitgCellRendererLanes*
gitg_cell_renderer_lanes_new (void)
{
	return gitg_cell_renderer_lanes_construct (GITG_TYPE_CELL_RENDERER_LANES);
}

GitgCommit*
gitg_cell_renderer_lanes_get_commit (GitgCellRendererLanes* self)
{
	GitgCommit* result;
	GitgCommit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_commit;
	result = _tmp0_;
	return result;
}

void
gitg_cell_renderer_lanes_set_commit (GitgCellRendererLanes* self,
                                     GitgCommit* value)
{
	GitgCommit* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_cell_renderer_lanes_get_commit (self);
	if (old_value != value) {
		GitgCommit* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_commit);
		self->priv->_commit = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY]);
	}
}

GitgCommit*
gitg_cell_renderer_lanes_get_next_commit (GitgCellRendererLanes* self)
{
	GitgCommit* result;
	GitgCommit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_next_commit;
	result = _tmp0_;
	return result;
}

void
gitg_cell_renderer_lanes_set_next_commit (GitgCellRendererLanes* self,
                                          GitgCommit* value)
{
	GitgCommit* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_cell_renderer_lanes_get_next_commit (self);
	if (old_value != value) {
		GitgCommit* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_next_commit);
		self->priv->_next_commit = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY]);
	}
}

guint
gitg_cell_renderer_lanes_get_lane_width (GitgCellRendererLanes* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_lane_width;
	return result;
}

void
gitg_cell_renderer_lanes_set_lane_width (GitgCellRendererLanes* self,
                                         guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_cell_renderer_lanes_get_lane_width (self);
	if (old_value != value) {
		self->priv->_lane_width = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY]);
	}
}

guint
gitg_cell_renderer_lanes_get_dot_width (GitgCellRendererLanes* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_dot_width;
	return result;
}

void
gitg_cell_renderer_lanes_set_dot_width (GitgCellRendererLanes* self,
                                        guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_cell_renderer_lanes_get_dot_width (self);
	if (old_value != value) {
		self->priv->_dot_width = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY]);
	}
}

GSList*
gitg_cell_renderer_lanes_get_labels (GitgCellRendererLanes* self)
{
	GSList* result;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_labels;
	result = _tmp0_;
	return result;
}

void
gitg_cell_renderer_lanes_set_labels (GitgCellRendererLanes* self,
                                     GSList* value)
{
	GSList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_cell_renderer_lanes_get_labels (self);
	if (old_value != value) {
		self->priv->_labels = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_LABELS_PROPERTY]);
	}
}

static guint
gitg_cell_renderer_lanes_get_num_visible_lanes (GitgCellRendererLanes* self)
{
	guint result;
	gint ret = 0;
	gint trailing_hidden = 0;
	GitgCommit* _tmp0_;
	GSList* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	ret = 0;
	trailing_hidden = 0;
	_tmp0_ = self->priv->_commit;
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
		lane_collection = _tmp1_;
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
			GitgLane* _tmp2_;
			GitgLane* lane = NULL;
			_tmp2_ = _g_object_ref0 ((GitgLane*) lane_it->data);
			lane = _tmp2_;
			{
				gint _tmp3_;
				GitgLane* _tmp4_;
				ret = ret + 1;
				_tmp3_ = ret;
				_tmp4_ = lane;
				if ((_tmp4_->tag & GITG_LANE_TAG_HIDDEN) != 0) {
					gint _tmp5_;
					_tmp5_ = trailing_hidden;
					trailing_hidden = _tmp5_ + 1;
				} else {
					trailing_hidden = 0;
				}
				_g_object_unref0 (lane);
			}
		}
	}
	result = (guint) (ret - trailing_hidden);
	return result;
}

static void
gitg_cell_renderer_lanes_class_init (GitgCellRendererLanesClass * klass,
                                     gpointer klass_data)
{
	gitg_cell_renderer_lanes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCellRendererLanes_private_offset);
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) gitg_cell_renderer_lanes_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) gitg_cell_renderer_lanes_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_cell_renderer_lanes_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_cell_renderer_lanes_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_cell_renderer_lanes_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY] = g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY] = g_param_spec_object ("next-commit", "next-commit", "next-commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY] = g_param_spec_uint ("lane-width", "lane-width", "lane-width", 0, G_MAXUINT, (guint) 16, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY] = g_param_spec_uint ("dot-width", "dot-width", "dot-width", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_CELL_RENDERER_LANES_LABELS_PROPERTY, gitg_cell_renderer_lanes_properties[GITG_CELL_RENDERER_LANES_LABELS_PROPERTY] = g_param_spec_pointer ("labels", "labels", "labels", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_cell_renderer_lanes_instance_init (GitgCellRendererLanes * self,
                                        gpointer klass)
{
	self->priv = gitg_cell_renderer_lanes_get_instance_private (self);
	self->priv->_lane_width = (guint) 16;
	self->priv->_dot_width = (guint) 10;
}

static void
gitg_cell_renderer_lanes_finalize (GObject * obj)
{
	GitgCellRendererLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
	_g_object_unref0 (self->priv->_commit);
	_g_object_unref0 (self->priv->_next_commit);
	G_OBJECT_CLASS (gitg_cell_renderer_lanes_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_cell_renderer_lanes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCellRendererLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_cell_renderer_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCellRendererLanes), 0, (GInstanceInitFunc) gitg_cell_renderer_lanes_instance_init, NULL };
	GType gitg_cell_renderer_lanes_type_id;
	gitg_cell_renderer_lanes_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "GitgCellRendererLanes", &g_define_type_info, 0);
	GitgCellRendererLanes_private_offset = g_type_add_instance_private (gitg_cell_renderer_lanes_type_id, sizeof (GitgCellRendererLanesPrivate));
	return gitg_cell_renderer_lanes_type_id;
}

GType
gitg_cell_renderer_lanes_get_type (void)
{
	static gsize gitg_cell_renderer_lanes_type_id__once = 0;
	if (g_once_init_enter (&gitg_cell_renderer_lanes_type_id__once)) {
		GType gitg_cell_renderer_lanes_type_id;
		gitg_cell_renderer_lanes_type_id = gitg_cell_renderer_lanes_get_type_once ();
		g_once_init_leave (&gitg_cell_renderer_lanes_type_id__once, gitg_cell_renderer_lanes_type_id);
	}
	return gitg_cell_renderer_lanes_type_id__once;
}

static void
_vala_gitg_cell_renderer_lanes_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GitgCellRendererLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
	switch (property_id) {
		case GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_cell_renderer_lanes_get_commit (self));
		break;
		case GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_cell_renderer_lanes_get_next_commit (self));
		break;
		case GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY:
		g_value_set_uint (value, gitg_cell_renderer_lanes_get_lane_width (self));
		break;
		case GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY:
		g_value_set_uint (value, gitg_cell_renderer_lanes_get_dot_width (self));
		break;
		case GITG_CELL_RENDERER_LANES_LABELS_PROPERTY:
		g_value_set_pointer (value, gitg_cell_renderer_lanes_get_labels (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_cell_renderer_lanes_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GitgCellRendererLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_CELL_RENDERER_LANES, GitgCellRendererLanes);
	switch (property_id) {
		case GITG_CELL_RENDERER_LANES_COMMIT_PROPERTY:
		gitg_cell_renderer_lanes_set_commit (self, g_value_get_object (value));
		break;
		case GITG_CELL_RENDERER_LANES_NEXT_COMMIT_PROPERTY:
		gitg_cell_renderer_lanes_set_next_commit (self, g_value_get_object (value));
		break;
		case GITG_CELL_RENDERER_LANES_LANE_WIDTH_PROPERTY:
		gitg_cell_renderer_lanes_set_lane_width (self, g_value_get_uint (value));
		break;
		case GITG_CELL_RENDERER_LANES_DOT_WIDTH_PROPERTY:
		gitg_cell_renderer_lanes_set_dot_width (self, g_value_get_uint (value));
		break;
		case GITG_CELL_RENDERER_LANES_LABELS_PROPERTY:
		gitg_cell_renderer_lanes_set_labels (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

