/* archive-writer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from archive-writer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* A non-threadsafe wrapper for libarchives write archive*/

#include <glib-object.h>
#include <archive.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "common.h"
#include <archive_entry.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <sys/stat.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_ARCHIVE_WRITER (boxes_archive_writer_get_type ())
#define BOXES_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter))
#define BOXES_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))
#define BOXES_IS_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_IS_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_ARCHIVE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))

typedef struct _BoxesArchiveWriter BoxesArchiveWriter;
typedef struct _BoxesArchiveWriterClass BoxesArchiveWriterClass;
typedef struct _BoxesArchiveWriterPrivate BoxesArchiveWriterPrivate;
enum  {
	BOXES_ARCHIVE_WRITER_0_PROPERTY,
	BOXES_ARCHIVE_WRITER_NUM_PROPERTIES
};
static GParamSpec* boxes_archive_writer_properties[BOXES_ARCHIVE_WRITER_NUM_PROPERTIES];
#define _archive_write_free0(var) ((var == NULL) ? NULL : (var = (archive_write_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block16Data Block16Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block17Data Block17Data;

#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _Block18Data Block18Data;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block21Data Block21Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesArchiveWriter {
	GObject parent_instance;
	BoxesArchiveWriterPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveWriterClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveWriterPrivate {
	GList* filters;
	int format;
};

struct _Block16Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _Block17Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gint fd;
};

struct _Block18Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _Block19Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* iterator;
};

struct _Block20Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* entry;
};

struct _Block21Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	int filter;
};

static gint BoxesArchiveWriter_private_offset;
static gpointer boxes_archive_writer_parent_class = NULL;

VALA_EXTERN GType boxes_archive_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesArchiveWriter, g_object_unref)
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_new (const gchar* filename,
                                              int format,
                                              GList* filters,
                                              GError** error);
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_construct (GType object_type,
                                                    const gchar* filename,
                                                    int format,
                                                    GList* filters,
                                                    GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self,
                                           GError** error);
static int __lambda26_ (Block16Data* _data16_);
static int ___lambda26__boxes_libarchive_function (gpointer self);
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_new_from_fd (gint fd,
                                                      int format,
                                                      GList* filters,
                                                      GError** error);
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_construct_from_fd (GType object_type,
                                                            gint fd,
                                                            int format,
                                                            GList* filters,
                                                            GError** error);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static int __lambda27_ (Block17Data* _data17_);
static int ___lambda27__boxes_libarchive_function (gpointer self);
VALA_EXTERN GType boxes_archive_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesArchiveReader, g_object_unref)
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader,
                                                                  const gchar* filename,
                                                                  gboolean import_contents,
                                                                  GError** error);
VALA_EXTERN BoxesArchiveWriter* boxes_archive_writer_construct_from_archive_reader (GType object_type,
                                                                        BoxesArchiveReader* archive_reader,
                                                                        const gchar* filename,
                                                                        gboolean import_contents,
                                                                        GError** error);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self,
                                                          struct archive* read_archive);
static int __lambda28_ (Block18Data* _data18_);
static int ___lambda28__boxes_libarchive_function (gpointer self);
VALA_EXTERN void boxes_archive_reader_reset (BoxesArchiveReader* self,
                                 GError** error);
VALA_EXTERN void boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self,
                                               BoxesArchiveReader* archive_reader,
                                               gchar** omit_files,
                                               gint omit_files_length1,
                                               gboolean omit_hardlinked_files,
                                               GError** error);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static int ___lambda29_ (Block19Data* _data19_);
static int ____lambda29__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_insert_data (BoxesArchiveWriter* self,
                                       guint8* data,
                                       gint data_length1,
                                       gint64 len,
                                       GError** error);
VALA_EXTERN void boxes_archive_writer_insert_files (BoxesArchiveWriter* self,
                                        gchar** src_list,
                                        gint src_list_length1,
                                        gchar** dest_list,
                                        gint dest_list_length1,
                                        GError** error);
VALA_EXTERN void boxes_archive_writer_insert_file (BoxesArchiveWriter* self,
                                       const gchar* src,
                                       const gchar* dest,
                                       GError** error);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static struct archive_entry* boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self,
                                                               const gchar* filename,
                                                               const gchar* dest_name);
static int __lambda30_ (Block20Data* _data20_);
static int ___lambda30__boxes_libarchive_function (gpointer self);
static int __lambda24_ (BoxesArchiveWriter* self);
static int ___lambda24__boxes_libarchive_function (gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static int _____lambda25_ (Block21Data* _data21_);
static int ______lambda25__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_finalize (GObject * obj);
static GType boxes_archive_writer_get_type_once (void);

static inline gpointer
boxes_archive_writer_get_instance_private (BoxesArchiveWriter* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesArchiveWriter_private_offset);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data16_->self;
		_g_free0 (_data16_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static int
__lambda26_ (Block16Data* _data16_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	int result;
	self = _data16_->self;
	_tmp0_ = self->archive;
	result = archive_write_open_filename (_tmp0_, _data16_->filename);
	return result;
}

static int
___lambda26__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda26_ (self);
	return result;
}

BoxesArchiveWriter*
boxes_archive_writer_construct (GType object_type,
                                const gchar* filename,
                                int format,
                                GList* filters,
                                GError** error)
{
	BoxesArchiveWriter * self = NULL;
	Block16Data* _data16_;
	gchar* _tmp0_;
	struct archive* _tmp1_;
	GList* _tmp2_;
	struct archive* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data16_->filename);
	_data16_->filename = _tmp0_;
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
	_data16_->self = g_object_ref (self);
	_tmp1_ = archive_write_new ();
	_archive_write_free0 (self->archive);
	self->archive = _tmp1_;
	self->priv->format = format;
	_tmp2_ = g_list_copy (filters);
	(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
	self->priv->filters = _tmp2_;
	boxes_archive_writer_prepare_archive (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block16_data_unref (_data16_);
			_data16_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block16_data_unref (_data16_);
			_data16_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = self->archive;
	boxes_execute_libarchive_function (_tmp3_, ___lambda26__boxes_libarchive_function, _data16_, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block16_data_unref (_data16_);
			_data16_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block16_data_unref (_data16_);
			_data16_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return self;
}

BoxesArchiveWriter*
boxes_archive_writer_new (const gchar* filename,
                          int format,
                          GList* filters,
                          GError** error)
{
	return boxes_archive_writer_construct (BOXES_TYPE_ARCHIVE_WRITER, filename, format, filters, error);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static int
__lambda27_ (Block17Data* _data17_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	int result;
	self = _data17_->self;
	_tmp0_ = self->archive;
	result = archive_write_open_fd (_tmp0_, _data17_->fd);
	return result;
}

static int
___lambda27__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda27_ (self);
	return result;
}

BoxesArchiveWriter*
boxes_archive_writer_construct_from_fd (GType object_type,
                                        gint fd,
                                        int format,
                                        GList* filters,
                                        GError** error)
{
	BoxesArchiveWriter * self = NULL;
	Block17Data* _data17_;
	struct archive* _tmp0_;
	GList* _tmp1_;
	struct archive* _tmp2_;
	GError* _inner_error0_ = NULL;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->fd = fd;
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
	_data17_->self = g_object_ref (self);
	_tmp0_ = archive_write_new ();
	_archive_write_free0 (self->archive);
	self->archive = _tmp0_;
	self->priv->format = format;
	_tmp1_ = g_list_copy (filters);
	(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
	self->priv->filters = _tmp1_;
	boxes_archive_writer_prepare_archive (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = self->archive;
	boxes_execute_libarchive_function (_tmp2_, ___lambda27__boxes_libarchive_function, _data17_, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return self;
}

BoxesArchiveWriter*
boxes_archive_writer_new_from_fd (gint fd,
                                  int format,
                                  GList* filters,
                                  GError** error)
{
	return boxes_archive_writer_construct_from_fd (BOXES_TYPE_ARCHIVE_WRITER, fd, format, filters, error);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data18_->self;
		_g_free0 (_data18_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static int
__lambda28_ (Block18Data* _data18_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	int result;
	self = _data18_->self;
	_tmp0_ = self->archive;
	result = archive_write_open_filename (_tmp0_, _data18_->filename);
	return result;
}

static int
___lambda28__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda28_ (self);
	return result;
}

BoxesArchiveWriter*
boxes_archive_writer_construct_from_archive_reader (GType object_type,
                                                    BoxesArchiveReader* archive_reader,
                                                    const gchar* filename,
                                                    gboolean import_contents,
                                                    GError** error)
{
	BoxesArchiveWriter * self = NULL;
	Block18Data* _data18_;
	gchar* _tmp0_;
	struct archive_entry* iterator = NULL;
	struct archive* _tmp1_;
	gboolean _tmp2_ = FALSE;
	struct archive* _tmp3_;
	struct archive_entry* _tmp4_ = NULL;
	gboolean _tmp5_;
	struct archive* _tmp9_;
	struct archive* _tmp10_;
	struct archive* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (archive_reader != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data18_->filename);
	_data18_->filename = _tmp0_;
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
	_data18_->self = g_object_ref (self);
	_tmp1_ = archive_write_new ();
	_archive_write_free0 (self->archive);
	self->archive = _tmp1_;
	_tmp3_ = archive_reader->archive;
	_tmp5_ = boxes_get_next_header (_tmp3_, &_tmp4_, (guint) 1, &_inner_error0_);
	iterator = _tmp4_;
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!_tmp2_) {
		gchar* msg = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp6_ = g_strdup ("Error creating write archive for archive '%s'. It is probably empty.");
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp7_, _data18_->filename);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp9_ = archive_reader->archive;
	self->priv->format = archive_format (_tmp9_);
	_tmp10_ = archive_reader->archive;
	boxes_archive_writer_copy_filters_from_read_archive (self, _tmp10_);
	boxes_archive_writer_prepare_archive (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = self->archive;
	boxes_execute_libarchive_function (_tmp11_, ___lambda28__boxes_libarchive_function, _data18_, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	boxes_archive_reader_reset (archive_reader, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (import_contents) {
		boxes_archive_writer_import_read_archive (self, archive_reader, NULL, (gint) 0, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				block18_data_unref (_data18_);
				_data18_ = NULL;
				_g_object_unref0 (self);
				return NULL;
			} else {
				block18_data_unref (_data18_);
				_data18_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return self;
}

BoxesArchiveWriter*
boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader,
                                              const gchar* filename,
                                              gboolean import_contents,
                                              GError** error)
{
	return boxes_archive_writer_construct_from_archive_reader (BOXES_TYPE_ARCHIVE_WRITER, archive_reader, filename, import_contents, error);
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data19_->self;
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static int
___lambda29_ (Block19Data* _data19_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
	int result;
	self = _data19_->self;
	_tmp0_ = self->archive;
	_tmp1_ = _data19_->iterator;
	result = archive_write_header (_tmp0_, _tmp1_);
	return result;
}

static int
____lambda29__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda29_ (self);
	return result;
}

void
boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self,
                                          BoxesArchiveReader* archive_reader,
                                          gchar** omit_files,
                                          gint omit_files_length1,
                                          gboolean omit_hardlinked_files,
                                          GError** error)
{
	Block19Data* _data19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (archive_reader != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		struct archive* _tmp1_;
		struct archive_entry* _tmp2_ = NULL;
		gboolean _tmp3_;
		gboolean omit = FALSE;
		la_int64_t len = {0};
		struct archive_entry* _tmp15_;
		struct archive* _tmp16_;
		_tmp1_ = archive_reader->archive;
		_tmp3_ = boxes_get_next_header (_tmp1_, &_tmp2_, (guint) 1, &_inner_error0_);
		_data19_->iterator = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				block19_data_unref (_data19_);
				_data19_ = NULL;
				return;
			} else {
				block19_data_unref (_data19_);
				_data19_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (!_tmp0_) {
			break;
		}
		omit = FALSE;
		{
			gchar** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
			file_collection = omit_files;
			file_collection_length1 = omit_files_length1;
			for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
				gchar* _tmp4_;
				gchar* file = NULL;
				_tmp4_ = g_strdup (file_collection[file_it]);
				file = _tmp4_;
				{
					const gchar* _tmp5_;
					struct archive_entry* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = file;
					_tmp6_ = _data19_->iterator;
					_tmp7_ = archive_entry_pathname (_tmp6_);
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
						omit = TRUE;
						_g_free0 (file);
						break;
					}
					_g_free0 (file);
				}
			}
		}
		if (omit) {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			if (omit_hardlinked_files) {
				_tmp9_ = TRUE;
			} else {
				struct archive_entry* _tmp10_;
				_tmp10_ = _data19_->iterator;
				_tmp9_ = archive_entry_nlink (_tmp10_) == ((guint) 1);
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				struct archive_entry* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = _data19_->iterator;
				_tmp12_ = archive_entry_hardlink (_tmp11_);
				_tmp8_ = _tmp12_ != NULL;
			}
			if (_tmp8_) {
				continue;
			} else {
				struct archive_entry* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = _data19_->iterator;
				_tmp14_ = archive_entry_pathname (_tmp13_);
				g_warning ("archive-writer.vala:80: File '%s' cannot be omitted since a hardlink p" \
"oints to it.", _tmp14_);
			}
		}
		_tmp15_ = _data19_->iterator;
		len = archive_entry_size (_tmp15_);
		_tmp16_ = self->archive;
		boxes_execute_libarchive_function (_tmp16_, ____lambda29__boxes_libarchive_function, _data19_, (guint) 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				block19_data_unref (_data19_);
				_data19_ = NULL;
				return;
			} else {
				block19_data_unref (_data19_);
				_data19_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (len > ((la_int64_t) 0)) {
			guint8* buf = NULL;
			guint8* _tmp17_;
			gint buf_length1;
			gint _buf_size_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			struct archive* _tmp19_;
			guint8* _tmp20_;
			gint _tmp20__length1;
			_tmp17_ = g_new0 (guint8, len);
			buf = _tmp17_;
			buf_length1 = len;
			_buf_size_ = buf_length1;
			_tmp18_ = buf;
			_tmp18__length1 = buf_length1;
			_tmp19_ = archive_reader->archive;
			_tmp20_ = buf;
			_tmp20__length1 = buf_length1;
			boxes_archive_writer_insert_data (self, _tmp18_, (gint) _tmp18__length1, (gint64) archive_read_data (_tmp19_, _tmp20_, (size_t) _tmp20__length1), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					buf = (g_free (buf), NULL);
					block19_data_unref (_data19_);
					_data19_ = NULL;
					return;
				} else {
					buf = (g_free (buf), NULL);
					block19_data_unref (_data19_);
					_data19_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			buf = (g_free (buf), NULL);
		}
	}
	boxes_archive_reader_reset (archive_reader, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block19_data_unref (_data19_);
			_data19_ = NULL;
			return;
		} else {
			block19_data_unref (_data19_);
			_data19_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

void
boxes_archive_writer_insert_files (BoxesArchiveWriter* self,
                                   gchar** src_list,
                                   gint src_list_length1,
                                   gchar** dest_list,
                                   gint dest_list_length1,
                                   GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (src_list_length1 == dest_list_length1, "src_list.length == dest_list.length");
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((guint) src_list_length1))) {
					break;
				}
				_tmp2_ = src_list[i];
				_tmp3_ = dest_list[i];
				boxes_archive_writer_insert_file (self, _tmp2_, _tmp3_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data20_->self;
		_archive_entry_free0 (_data20_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static int
__lambda30_ (Block20Data* _data20_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
	int result;
	self = _data20_->self;
	_tmp0_ = self->archive;
	_tmp1_ = _data20_->entry;
	result = archive_write_header (_tmp0_, _tmp1_);
	return result;
}

static int
___lambda30__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda30_ (self);
	return result;
}

void
boxes_archive_writer_insert_file (BoxesArchiveWriter* self,
                                  const gchar* src,
                                  const gchar* dest,
                                  GError** error)
{
	Block20Data* _data20_;
	struct archive_entry* _tmp2_;
	la_int64_t len = {0};
	struct archive_entry* _tmp3_;
	guint8* buf = NULL;
	guint8* _tmp4_;
	gint buf_length1;
	gint _buf_size_;
	FILE* filestream = NULL;
	FILE* _tmp5_;
	FILE* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	struct archive* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (dest != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	if (!g_file_test (src, G_FILE_TEST_EXISTS)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Source file '%s' cannot be injected. File not found.", src);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			return;
		} else {
			block20_data_unref (_data20_);
			_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (g_file_test (src, G_FILE_TEST_IS_SYMLINK)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Inserting symlinks is currently not supported.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			return;
		} else {
			block20_data_unref (_data20_);
			_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = boxes_archive_writer_get_entry_for_file (self, src, dest);
	_data20_->entry = _tmp2_;
	_tmp3_ = _data20_->entry;
	len = archive_entry_size (_tmp3_);
	_tmp4_ = g_new0 (guint8, len);
	buf = _tmp4_;
	buf_length1 = len;
	_buf_size_ = buf_length1;
	_tmp5_ = g_fopen (src, "r");
	filestream = _tmp5_;
	_tmp6_ = filestream;
	_tmp7_ = buf;
	_tmp7__length1 = buf_length1;
	fread ((guint8*) _tmp7_, (gsize) 1, (gint) ((_tmp7__length1 * sizeof (guint8)) / sizeof (guint8)), _tmp6_);
	_tmp8_ = self->archive;
	boxes_execute_libarchive_function (_tmp8_, ___lambda30__boxes_libarchive_function, _data20_, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_fclose0 (filestream);
			buf = (g_free (buf), NULL);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			return;
		} else {
			_fclose0 (filestream);
			buf = (g_free (buf), NULL);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = buf;
	_tmp9__length1 = buf_length1;
	boxes_archive_writer_insert_data (self, _tmp9_, (gint) _tmp9__length1, (gint64) len, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_fclose0 (filestream);
			buf = (g_free (buf), NULL);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			return;
		} else {
			_fclose0 (filestream);
			buf = (g_free (buf), NULL);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_fclose0 (filestream);
	buf = (g_free (buf), NULL);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static int
__lambda24_ (BoxesArchiveWriter* self)
{
	struct archive* _tmp0_;
	int result;
	_tmp0_ = self->archive;
	result = archive_write_set_format (_tmp0_, self->priv->format);
	return result;
}

static int
___lambda24__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda24_ ((BoxesArchiveWriter*) self);
	return result;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		BoxesArchiveWriter* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static int
_____lambda25_ (Block21Data* _data21_)
{
	BoxesArchiveWriter* self;
	struct archive* _tmp0_;
	int result;
	self = _data21_->self;
	_tmp0_ = self->archive;
	result = archive_write_add_filter (_tmp0_, _data21_->filter);
	return result;
}

static int
______lambda25__boxes_libarchive_function (gpointer self)
{
	int result;
	result = _____lambda25_ (self);
	return result;
}

static void
boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self,
                                      GError** error)
{
	struct archive* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->archive;
	boxes_execute_libarchive_function (_tmp0_, ___lambda24__boxes_libarchive_function, self, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = self->priv->filters;
	if (_tmp1_ != NULL) {
		GList* _tmp2_;
		_tmp2_ = self->priv->filters;
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
			filter_collection = _tmp2_;
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
				int filter = 0;
				filter = (int) ((gintptr) filter_it->data);
				{
					Block21Data* _data21_;
					struct archive* _tmp3_;
					_data21_ = g_slice_new0 (Block21Data);
					_data21_->_ref_count_ = 1;
					_data21_->self = g_object_ref (self);
					_data21_->filter = filter;
					_tmp3_ = self->archive;
					boxes_execute_libarchive_function (_tmp3_, ______lambda25__boxes_libarchive_function, _data21_, (guint) 1, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							g_propagate_error (error, _inner_error0_);
							block21_data_unref (_data21_);
							_data21_ = NULL;
							return;
						} else {
							block21_data_unref (_data21_);
							_data21_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					block21_data_unref (_data21_);
					_data21_ = NULL;
				}
			}
		}
	}
}

static void
boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self,
                                                     struct archive* read_archive)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (read_archive != NULL);
	(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
	self->priv->filters = NULL;
	{
		gint i = 0;
		i = archive_filter_count (read_archive) - 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				self->priv->filters = g_list_append (self->priv->filters, (gpointer) ((gintptr) archive_filter_code (read_archive, i - 1)));
			}
		}
	}
}

static void
boxes_archive_writer_insert_data (BoxesArchiveWriter* self,
                                  guint8* data,
                                  gint data_length1,
                                  gint64 len,
                                  GError** error)
{
	struct archive* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->archive;
	if (((gint64) archive_write_data (_tmp0_, data, (size_t) data_length1)) != len) {
		struct archive* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp1_ = self->archive;
		_tmp2_ = archive_error_string (_tmp1_);
		_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed writing data to archive. Message: '%s'.", _tmp2_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static struct archive_entry*
boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self,
                                         const gchar* filename,
                                         const gchar* dest_name)
{
	struct stat st = {0};
	struct archive_entry* _result_ = NULL;
	struct archive_entry* _tmp0_;
	struct stat _tmp1_ = {0};
	struct stat _tmp2_;
	struct archive_entry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (dest_name != NULL, NULL);
	_tmp0_ = archive_entry_new2 (NULL);
	_result_ = _tmp0_;
	stat (filename, &_tmp1_);
	st = _tmp1_;
	_tmp2_ = st;
	archive_entry_copy_stat (_result_, &_tmp2_);
	archive_entry_set_pathname (_result_, dest_name);
	result = _result_;
	return result;
}

static void
boxes_archive_writer_class_init (BoxesArchiveWriterClass * klass,
                                 gpointer klass_data)
{
	boxes_archive_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesArchiveWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_writer_finalize;
}

static void
boxes_archive_writer_instance_init (BoxesArchiveWriter * self,
                                    gpointer klass)
{
	self->priv = boxes_archive_writer_get_instance_private (self);
}

static void
boxes_archive_writer_finalize (GObject * obj)
{
	BoxesArchiveWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter);
	_archive_write_free0 (self->archive);
	(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
	G_OBJECT_CLASS (boxes_archive_writer_parent_class)->finalize (obj);
}

static GType
boxes_archive_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveWriter), 0, (GInstanceInitFunc) boxes_archive_writer_instance_init, NULL };
	GType boxes_archive_writer_type_id;
	boxes_archive_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveWriter", &g_define_type_info, 0);
	BoxesArchiveWriter_private_offset = g_type_add_instance_private (boxes_archive_writer_type_id, sizeof (BoxesArchiveWriterPrivate));
	return boxes_archive_writer_type_id;
}

GType
boxes_archive_writer_get_type (void)
{
	static volatile gsize boxes_archive_writer_type_id__once = 0;
	if (g_once_init_enter (&boxes_archive_writer_type_id__once)) {
		GType boxes_archive_writer_type_id;
		boxes_archive_writer_type_id = boxes_archive_writer_get_type_once ();
		g_once_init_leave (&boxes_archive_writer_type_id__once, boxes_archive_writer_type_id);
	}
	return boxes_archive_writer_type_id__once;
}

