/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_header_format_counter = R"doc(Header formatter that adds the payload bits/symbol format and a packet number counter.

Child class of header_format_default. This version adds two fields to the header:



Like the default packet formatter, the length is encoded as a 16-bit value repeated twice. The full packet looks like: 


Where the access code is <= 64 bits and hdr is: 


The access code and header are formatted for network byte order.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    access_code : An access code that is used to find and synchronize the start of a packet. Used in the parser and in other blocks like a corr_est block that helps trigger the receiver. Can be up to 64-bits long.
    threshold : How many bits can be wrong in the access code and still count as correct.
    bps : The number of bits/second used in the payload's modulator.)doc";


static const char* __doc_gr_digital_header_format_counter_header_format_counter_0 =
    R"doc()doc";


static const char* __doc_gr_digital_header_format_counter_header_format_counter_1 =
    R"doc()doc";


static const char* __doc_gr_digital_header_format_counter_format = R"doc(Creates a header from the access code and packet length to build an output packet in the form:)doc";


static const char* __doc_gr_digital_header_format_counter_header_nbits = R"doc(Returns the length of the formatted header in bits.)doc";


static const char* __doc_gr_digital_header_format_counter_make = R"doc(Header formatter that adds the payload bits/symbol format and a packet number counter.

Child class of header_format_default. This version adds two fields to the header:



Like the default packet formatter, the length is encoded as a 16-bit value repeated twice. The full packet looks like: 


Where the access code is <= 64 bits and hdr is: 


The access code and header are formatted for network byte order.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    access_code : An access code that is used to find and synchronize the start of a packet. Used in the parser and in other blocks like a corr_est block that helps trigger the receiver. Can be up to 64-bits long.
    threshold : How many bits can be wrong in the access code and still count as correct.
    bps : The number of bits/second used in the payload's modulator.)doc";
