/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, vocoder, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_vocoder_codec2_encode_sp = R"doc(CODEC2 Vocoder Encoder.

Input: Speech (audio) signal as 16-bit shorts, sampling rate 8 kHz.


Output: Vector of unpacked bits, forming one Codec2 frame, per 160 input samples (in 2400 and 3200 bps modes) or per 320 input samples (in 1200, 1300, 1400 and 1600 bps modes).

Constructor Specific Documentation:

Make Codec2 encoder block.

Args:
    mode : Encoded bit rate/mode)doc";


static const char* __doc_gr_vocoder_codec2_encode_sp_codec2_encode_sp = R"doc()doc";


static const char* __doc_gr_vocoder_codec2_encode_sp_make = R"doc(CODEC2 Vocoder Encoder.

Input: Speech (audio) signal as 16-bit shorts, sampling rate 8 kHz.


Output: Vector of unpacked bits, forming one Codec2 frame, per 160 input samples (in 2400 and 3200 bps modes) or per 320 input samples (in 1200, 1300, 1400 and 1600 bps modes).

Constructor Specific Documentation:

Make Codec2 encoder block.

Args:
    mode : Encoded bit rate/mode)doc";
