/*
 * Copyright (c) 2009-2021, Albertas Vyšniauskas
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *     * Neither the name of the software author nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once
#include "Transformation.h"
#include <gtk/gtk.h>
namespace transformation {
struct ColorVisionDeficiency;
struct ColorVisionDeficiency: public Transformation {
	struct Configuration: public BaseConfiguration {
		Configuration(IEventHandler &eventHandler, ColorVisionDeficiency &transformation);
		virtual ~Configuration() override = default;
		virtual void apply(Transformation &transformation) override;
	private:
		GtkWidget *m_infoBar, *m_infoLabel, *m_type, *m_strength;
		bool m_allowChangeNofications;
		static void onTypeComboBoxChange(GtkWidget *widget, Configuration *configuration);
	};
	enum class Type {
		protanomaly,
		deuteranomaly,
		tritanomaly,
		protanopia,
		deuteranopia,
		tritanopia,
	};
	ColorVisionDeficiency();
	virtual ~ColorVisionDeficiency() = default;
	virtual void serialize(dynv::Map &system) override;
	virtual void deserialize(const dynv::Map &system) override;
	virtual std::unique_ptr<BaseConfiguration> configuration(IEventHandler &eventHandler) override;
private:
	Type m_type;
	float m_strength;
	virtual Color apply(Color input) override;
	friend struct Configuration;
};
}
