{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkLayoutChild@ subclass for children in a @GtkOverlayLayout@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.OverlayLayoutChild
    ( 

-- * Exported types
    OverlayLayoutChild(..)                  ,
    IsOverlayLayoutChild                    ,
    toOverlayLayoutChild                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChildWidget]("GI.Gtk.Objects.LayoutChild#g:method:getChildWidget"), [getClipOverlay]("GI.Gtk.Objects.OverlayLayoutChild#g:method:getClipOverlay"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLayoutManager]("GI.Gtk.Objects.LayoutChild#g:method:getLayoutManager"), [getMeasure]("GI.Gtk.Objects.OverlayLayoutChild#g:method:getMeasure"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setClipOverlay]("GI.Gtk.Objects.OverlayLayoutChild#g:method:setClipOverlay"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setMeasure]("GI.Gtk.Objects.OverlayLayoutChild#g:method:setMeasure"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveOverlayLayoutChildMethod         ,
#endif

-- ** getClipOverlay #method:getClipOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildGetClipOverlayMethodInfo,
#endif
    overlayLayoutChildGetClipOverlay        ,


-- ** getMeasure #method:getMeasure#

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildGetMeasureMethodInfo  ,
#endif
    overlayLayoutChildGetMeasure            ,


-- ** setClipOverlay #method:setClipOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildSetClipOverlayMethodInfo,
#endif
    overlayLayoutChildSetClipOverlay        ,


-- ** setMeasure #method:setMeasure#

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildSetMeasureMethodInfo  ,
#endif
    overlayLayoutChildSetMeasure            ,




 -- * Properties


-- ** clipOverlay #attr:clipOverlay#
-- | Whether the child should be clipped to fit the parent\'s size.

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildClipOverlayPropertyInfo,
#endif
    constructOverlayLayoutChildClipOverlay  ,
    getOverlayLayoutChildClipOverlay        ,
#if defined(ENABLE_OVERLOADING)
    overlayLayoutChildClipOverlay           ,
#endif
    setOverlayLayoutChildClipOverlay        ,


-- ** measure #attr:measure#
-- | Whether the child size should contribute to the @GtkOverlayLayout@\'s
-- measurement.

#if defined(ENABLE_OVERLOADING)
    OverlayLayoutChildMeasurePropertyInfo   ,
#endif
    constructOverlayLayoutChildMeasure      ,
    getOverlayLayoutChildMeasure            ,
#if defined(ENABLE_OVERLOADING)
    overlayLayoutChildMeasure               ,
#endif
    setOverlayLayoutChildMeasure            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild

#endif

-- | Memory-managed wrapper type.
newtype OverlayLayoutChild = OverlayLayoutChild (SP.ManagedPtr OverlayLayoutChild)
    deriving (Eq)

instance SP.ManagedPtrNewtype OverlayLayoutChild where
    toManagedPtr (OverlayLayoutChild p) = p

foreign import ccall "gtk_overlay_layout_child_get_type"
    c_gtk_overlay_layout_child_get_type :: IO B.Types.GType

instance B.Types.TypedObject OverlayLayoutChild where
    glibType = c_gtk_overlay_layout_child_get_type

instance B.Types.GObject OverlayLayoutChild

-- | Type class for types which can be safely cast to t'OverlayLayoutChild', for instance with `toOverlayLayoutChild`.
class (SP.GObject o, O.IsDescendantOf OverlayLayoutChild o) => IsOverlayLayoutChild o
instance (SP.GObject o, O.IsDescendantOf OverlayLayoutChild o) => IsOverlayLayoutChild o

instance O.HasParentTypes OverlayLayoutChild
type instance O.ParentTypes OverlayLayoutChild = '[Gtk.LayoutChild.LayoutChild, GObject.Object.Object]

-- | Cast to t'OverlayLayoutChild', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toOverlayLayoutChild :: (MIO.MonadIO m, IsOverlayLayoutChild o) => o -> m OverlayLayoutChild
toOverlayLayoutChild = MIO.liftIO . B.ManagedPtr.unsafeCastTo OverlayLayoutChild

-- | Convert t'OverlayLayoutChild' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe OverlayLayoutChild) where
    gvalueGType_ = c_gtk_overlay_layout_child_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr OverlayLayoutChild)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr OverlayLayoutChild)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject OverlayLayoutChild ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveOverlayLayoutChildMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOverlayLayoutChildMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveOverlayLayoutChildMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveOverlayLayoutChildMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveOverlayLayoutChildMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveOverlayLayoutChildMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveOverlayLayoutChildMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveOverlayLayoutChildMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveOverlayLayoutChildMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveOverlayLayoutChildMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveOverlayLayoutChildMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveOverlayLayoutChildMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveOverlayLayoutChildMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveOverlayLayoutChildMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveOverlayLayoutChildMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveOverlayLayoutChildMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveOverlayLayoutChildMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveOverlayLayoutChildMethod "getChildWidget" o = Gtk.LayoutChild.LayoutChildGetChildWidgetMethodInfo
    ResolveOverlayLayoutChildMethod "getClipOverlay" o = OverlayLayoutChildGetClipOverlayMethodInfo
    ResolveOverlayLayoutChildMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveOverlayLayoutChildMethod "getLayoutManager" o = Gtk.LayoutChild.LayoutChildGetLayoutManagerMethodInfo
    ResolveOverlayLayoutChildMethod "getMeasure" o = OverlayLayoutChildGetMeasureMethodInfo
    ResolveOverlayLayoutChildMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveOverlayLayoutChildMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveOverlayLayoutChildMethod "setClipOverlay" o = OverlayLayoutChildSetClipOverlayMethodInfo
    ResolveOverlayLayoutChildMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveOverlayLayoutChildMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveOverlayLayoutChildMethod "setMeasure" o = OverlayLayoutChildSetMeasureMethodInfo
    ResolveOverlayLayoutChildMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveOverlayLayoutChildMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOverlayLayoutChildMethod t OverlayLayoutChild, O.OverloadedMethod info OverlayLayoutChild p) => OL.IsLabel t (OverlayLayoutChild -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOverlayLayoutChildMethod t OverlayLayoutChild, O.OverloadedMethod info OverlayLayoutChild p, R.HasField t OverlayLayoutChild p) => R.HasField t OverlayLayoutChild p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOverlayLayoutChildMethod t OverlayLayoutChild, O.OverloadedMethodInfo info OverlayLayoutChild) => OL.IsLabel t (O.MethodProxy info OverlayLayoutChild) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "clip-overlay"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@clip-overlay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' overlayLayoutChild #clipOverlay
-- @
getOverlayLayoutChildClipOverlay :: (MonadIO m, IsOverlayLayoutChild o) => o -> m Bool
getOverlayLayoutChildClipOverlay obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "clip-overlay"

-- | Set the value of the “@clip-overlay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' overlayLayoutChild [ #clipOverlay 'Data.GI.Base.Attributes.:=' value ]
-- @
setOverlayLayoutChildClipOverlay :: (MonadIO m, IsOverlayLayoutChild o) => o -> Bool -> m ()
setOverlayLayoutChildClipOverlay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "clip-overlay" val

-- | Construct a t'GValueConstruct' with valid value for the “@clip-overlay@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructOverlayLayoutChildClipOverlay :: (IsOverlayLayoutChild o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructOverlayLayoutChildClipOverlay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "clip-overlay" val

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildClipOverlayPropertyInfo
instance AttrInfo OverlayLayoutChildClipOverlayPropertyInfo where
    type AttrAllowedOps OverlayLayoutChildClipOverlayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint OverlayLayoutChildClipOverlayPropertyInfo = IsOverlayLayoutChild
    type AttrSetTypeConstraint OverlayLayoutChildClipOverlayPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint OverlayLayoutChildClipOverlayPropertyInfo = (~) Bool
    type AttrTransferType OverlayLayoutChildClipOverlayPropertyInfo = Bool
    type AttrGetType OverlayLayoutChildClipOverlayPropertyInfo = Bool
    type AttrLabel OverlayLayoutChildClipOverlayPropertyInfo = "clip-overlay"
    type AttrOrigin OverlayLayoutChildClipOverlayPropertyInfo = OverlayLayoutChild
    attrGet = getOverlayLayoutChildClipOverlay
    attrSet = setOverlayLayoutChildClipOverlay
    attrPut = setOverlayLayoutChildClipOverlay
    attrTransfer _ v = do
        return v
    attrConstruct = constructOverlayLayoutChildClipOverlay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.clipOverlay"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#g:attr:clipOverlay"
        })
#endif

-- VVV Prop "measure"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@measure@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' overlayLayoutChild #measure
-- @
getOverlayLayoutChildMeasure :: (MonadIO m, IsOverlayLayoutChild o) => o -> m Bool
getOverlayLayoutChildMeasure obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "measure"

-- | Set the value of the “@measure@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' overlayLayoutChild [ #measure 'Data.GI.Base.Attributes.:=' value ]
-- @
setOverlayLayoutChildMeasure :: (MonadIO m, IsOverlayLayoutChild o) => o -> Bool -> m ()
setOverlayLayoutChildMeasure obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "measure" val

-- | Construct a t'GValueConstruct' with valid value for the “@measure@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructOverlayLayoutChildMeasure :: (IsOverlayLayoutChild o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructOverlayLayoutChildMeasure val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "measure" val

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildMeasurePropertyInfo
instance AttrInfo OverlayLayoutChildMeasurePropertyInfo where
    type AttrAllowedOps OverlayLayoutChildMeasurePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint OverlayLayoutChildMeasurePropertyInfo = IsOverlayLayoutChild
    type AttrSetTypeConstraint OverlayLayoutChildMeasurePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint OverlayLayoutChildMeasurePropertyInfo = (~) Bool
    type AttrTransferType OverlayLayoutChildMeasurePropertyInfo = Bool
    type AttrGetType OverlayLayoutChildMeasurePropertyInfo = Bool
    type AttrLabel OverlayLayoutChildMeasurePropertyInfo = "measure"
    type AttrOrigin OverlayLayoutChildMeasurePropertyInfo = OverlayLayoutChild
    attrGet = getOverlayLayoutChildMeasure
    attrSet = setOverlayLayoutChildMeasure
    attrPut = setOverlayLayoutChildMeasure
    attrTransfer _ v = do
        return v
    attrConstruct = constructOverlayLayoutChildMeasure
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.measure"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#g:attr:measure"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OverlayLayoutChild
type instance O.AttributeList OverlayLayoutChild = OverlayLayoutChildAttributeList
type OverlayLayoutChildAttributeList = ('[ '("childWidget", Gtk.LayoutChild.LayoutChildChildWidgetPropertyInfo), '("clipOverlay", OverlayLayoutChildClipOverlayPropertyInfo), '("layoutManager", Gtk.LayoutChild.LayoutChildLayoutManagerPropertyInfo), '("measure", OverlayLayoutChildMeasurePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
overlayLayoutChildClipOverlay :: AttrLabelProxy "clipOverlay"
overlayLayoutChildClipOverlay = AttrLabelProxy

overlayLayoutChildMeasure :: AttrLabelProxy "measure"
overlayLayoutChildMeasure = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList OverlayLayoutChild = OverlayLayoutChildSignalList
type OverlayLayoutChildSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method OverlayLayoutChild::get_clip_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "OverlayLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlayLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_layout_child_get_clip_overlay" gtk_overlay_layout_child_get_clip_overlay :: 
    Ptr OverlayLayoutChild ->               -- child : TInterface (Name {namespace = "Gtk", name = "OverlayLayoutChild"})
    IO CInt

-- | Retrieves whether the child is clipped.
overlayLayoutChildGetClipOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlayLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkOverlayLayoutChild@
    -> m Bool
    -- ^ __Returns:__ whether the child is clipped
overlayLayoutChildGetClipOverlay child = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_overlay_layout_child_get_clip_overlay child'
    let result' = (/= 0) result
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildGetClipOverlayMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsOverlayLayoutChild a) => O.OverloadedMethod OverlayLayoutChildGetClipOverlayMethodInfo a signature where
    overloadedMethod = overlayLayoutChildGetClipOverlay

instance O.OverloadedMethodInfo OverlayLayoutChildGetClipOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.overlayLayoutChildGetClipOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#v:overlayLayoutChildGetClipOverlay"
        })


#endif

-- method OverlayLayoutChild::get_measure
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "OverlayLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlayLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_layout_child_get_measure" gtk_overlay_layout_child_get_measure :: 
    Ptr OverlayLayoutChild ->               -- child : TInterface (Name {namespace = "Gtk", name = "OverlayLayoutChild"})
    IO CInt

-- | Retrieves whether the child is measured.
overlayLayoutChildGetMeasure ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlayLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkOverlayLayoutChild@
    -> m Bool
    -- ^ __Returns:__ whether the child is measured
overlayLayoutChildGetMeasure child = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_overlay_layout_child_get_measure child'
    let result' = (/= 0) result
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildGetMeasureMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsOverlayLayoutChild a) => O.OverloadedMethod OverlayLayoutChildGetMeasureMethodInfo a signature where
    overloadedMethod = overlayLayoutChildGetMeasure

instance O.OverloadedMethodInfo OverlayLayoutChildGetMeasureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.overlayLayoutChildGetMeasure",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#v:overlayLayoutChildGetMeasure"
        })


#endif

-- method OverlayLayoutChild::set_clip_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "OverlayLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlayLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clip_overlay"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to clip this child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_layout_child_set_clip_overlay" gtk_overlay_layout_child_set_clip_overlay :: 
    Ptr OverlayLayoutChild ->               -- child : TInterface (Name {namespace = "Gtk", name = "OverlayLayoutChild"})
    CInt ->                                 -- clip_overlay : TBasicType TBoolean
    IO ()

-- | Sets whether to clip this child.
overlayLayoutChildSetClipOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlayLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkOverlayLayoutChild@
    -> Bool
    -- ^ /@clipOverlay@/: whether to clip this child
    -> m ()
overlayLayoutChildSetClipOverlay child clipOverlay = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    let clipOverlay' = (P.fromIntegral . P.fromEnum) clipOverlay
    gtk_overlay_layout_child_set_clip_overlay child' clipOverlay'
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildSetClipOverlayMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsOverlayLayoutChild a) => O.OverloadedMethod OverlayLayoutChildSetClipOverlayMethodInfo a signature where
    overloadedMethod = overlayLayoutChildSetClipOverlay

instance O.OverloadedMethodInfo OverlayLayoutChildSetClipOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.overlayLayoutChildSetClipOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#v:overlayLayoutChildSetClipOverlay"
        })


#endif

-- method OverlayLayoutChild::set_measure
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "OverlayLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlayLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "measure"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to measure this child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_layout_child_set_measure" gtk_overlay_layout_child_set_measure :: 
    Ptr OverlayLayoutChild ->               -- child : TInterface (Name {namespace = "Gtk", name = "OverlayLayoutChild"})
    CInt ->                                 -- measure : TBasicType TBoolean
    IO ()

-- | Sets whether to measure this child.
overlayLayoutChildSetMeasure ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlayLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkOverlayLayoutChild@
    -> Bool
    -- ^ /@measure@/: whether to measure this child
    -> m ()
overlayLayoutChildSetMeasure child measure = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    let measure' = (P.fromIntegral . P.fromEnum) measure
    gtk_overlay_layout_child_set_measure child' measure'
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlayLayoutChildSetMeasureMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsOverlayLayoutChild a) => O.OverloadedMethod OverlayLayoutChildSetMeasureMethodInfo a signature where
    overloadedMethod = overlayLayoutChildSetMeasure

instance O.OverloadedMethodInfo OverlayLayoutChildSetMeasureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.OverlayLayoutChild.overlayLayoutChildSetMeasure",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-OverlayLayoutChild.html#v:overlayLayoutChildSetMeasure"
        })


#endif


