// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace KolabXSD
{
  class KolabBase;
  class attachmentPropType;
  class classifcationPropType;
  class CustomType;
  class Note;
  class File;
  class ConfigurationType;
  class CategoryColor;
  class textformatType;
  class Snippet;
  class FileDriverSettings;
  class Configuration;
  class parameters;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace KolabXSD
{
  class KolabBase: public ::xml_schema::type
  {
    public:
    // version
    //
    typedef ::xml_schema::string version_type;
    typedef ::xsd::cxx::tree::traits< version_type, char > version_traits;

    const version_type&
    version () const;

    version_type&
    version ();

    void
    version (const version_type& x);

    void
    version (::std::unique_ptr< version_type > p);

    static const version_type&
    version_default_value ();

    // Constructors.
    //
    KolabBase ();

    KolabBase (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    KolabBase (const KolabBase& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual KolabBase*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabBase&
    operator= (const KolabBase& x);

    virtual 
    ~KolabBase ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< version_type > version_;
    static const version_type version_default_value_;
  };

  class attachmentPropType: public ::xml_schema::type
  {
    public:
    // parameters
    //
    typedef ::KolabXSD::parameters parameters_type;
    typedef ::xsd::cxx::tree::traits< parameters_type, char > parameters_traits;

    const parameters_type&
    parameters () const;

    parameters_type&
    parameters ();

    void
    parameters (const parameters_type& x);

    void
    parameters (::std::unique_ptr< parameters_type > p);

    // uri
    //
    typedef ::xml_schema::string uri_type;
    typedef ::xsd::cxx::tree::optional< uri_type > uri_optional;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_optional&
    uri () const;

    uri_optional&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (const uri_optional& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // binary
    //
    typedef ::xml_schema::string binary_type;
    typedef ::xsd::cxx::tree::optional< binary_type > binary_optional;
    typedef ::xsd::cxx::tree::traits< binary_type, char > binary_traits;

    const binary_optional&
    binary () const;

    binary_optional&
    binary ();

    void
    binary (const binary_type& x);

    void
    binary (const binary_optional& x);

    void
    binary (::std::unique_ptr< binary_type > p);

    // Constructors.
    //
    attachmentPropType (const parameters_type&);

    attachmentPropType (::std::unique_ptr< parameters_type >);

    attachmentPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    attachmentPropType (const attachmentPropType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual attachmentPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    attachmentPropType&
    operator= (const attachmentPropType& x);

    virtual 
    ~attachmentPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< parameters_type > parameters_;
    uri_optional uri_;
    binary_optional binary_;
  };

  class classifcationPropType: public ::xml_schema::token
  {
    public:
    enum value
    {
      PUBLIC,
      PRIVATE,
      CONFIDENTIAL
    };

    classifcationPropType (value v);

    classifcationPropType (const char* v);

    classifcationPropType (const ::std::string& v);

    classifcationPropType (const ::xml_schema::token& v);

    classifcationPropType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    classifcationPropType (const ::xercesc::DOMAttr& a,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    classifcationPropType (const ::std::string& s,
                           const ::xercesc::DOMElement* e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    classifcationPropType (const classifcationPropType& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    classifcationPropType&
    operator= (const classifcationPropType&) = default;
#endif

    virtual classifcationPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    classifcationPropType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_classifcationPropType_convert ();
    }

    protected:
    value
    _xsd_classifcationPropType_convert () const;

    public:
    static const char* const _xsd_classifcationPropType_literals_[3];
    static const value _xsd_classifcationPropType_indexes_[3];
  };

  class CustomType: public ::xml_schema::type
  {
    public:
    // identifier
    //
    typedef ::xml_schema::string identifier_type;
    typedef ::xsd::cxx::tree::traits< identifier_type, char > identifier_traits;

    const identifier_type&
    identifier () const;

    identifier_type&
    identifier ();

    void
    identifier (const identifier_type& x);

    void
    identifier (::std::unique_ptr< identifier_type > p);

    // value
    //
    typedef ::xml_schema::string value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    void
    value (::std::unique_ptr< value_type > p);

    // Constructors.
    //
    CustomType (const identifier_type&,
                const value_type&);

    CustomType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    CustomType (const CustomType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual CustomType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CustomType&
    operator= (const CustomType& x);

    virtual 
    ~CustomType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< identifier_type > identifier_;
    ::xsd::cxx::tree::one< value_type > value_;
  };

  class Note: public ::KolabXSD::KolabBase
  {
    public:
    // uid
    //
    typedef ::xml_schema::string uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // prodid
    //
    typedef ::xml_schema::string prodid_type;
    typedef ::xsd::cxx::tree::traits< prodid_type, char > prodid_traits;

    const prodid_type&
    prodid () const;

    prodid_type&
    prodid ();

    void
    prodid (const prodid_type& x);

    void
    prodid (::std::unique_ptr< prodid_type > p);

    // creation-date
    //
    typedef ::xml_schema::date_time creation_date_type;
    typedef ::xsd::cxx::tree::traits< creation_date_type, char > creation_date_traits;

    const creation_date_type&
    creation_date () const;

    creation_date_type&
    creation_date ();

    void
    creation_date (const creation_date_type& x);

    void
    creation_date (::std::unique_ptr< creation_date_type > p);

    // last-modification-date
    //
    typedef ::xml_schema::date_time last_modification_date_type;
    typedef ::xsd::cxx::tree::traits< last_modification_date_type, char > last_modification_date_traits;

    const last_modification_date_type&
    last_modification_date () const;

    last_modification_date_type&
    last_modification_date ();

    void
    last_modification_date (const last_modification_date_type& x);

    void
    last_modification_date (::std::unique_ptr< last_modification_date_type > p);

    // categories
    //
    typedef ::xml_schema::string categories_type;
    typedef ::xsd::cxx::tree::sequence< categories_type > categories_sequence;
    typedef categories_sequence::iterator categories_iterator;
    typedef categories_sequence::const_iterator categories_const_iterator;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_sequence&
    categories () const;

    categories_sequence&
    categories ();

    void
    categories (const categories_sequence& s);

    // classification
    //
    typedef ::KolabXSD::classifcationPropType classification_type;
    typedef ::xsd::cxx::tree::optional< classification_type > classification_optional;
    typedef ::xsd::cxx::tree::traits< classification_type, char > classification_traits;

    const classification_optional&
    classification () const;

    classification_optional&
    classification ();

    void
    classification (const classification_type& x);

    void
    classification (const classification_optional& x);

    void
    classification (::std::unique_ptr< classification_type > p);

    // attachment
    //
    typedef ::KolabXSD::attachmentPropType attachment_type;
    typedef ::xsd::cxx::tree::sequence< attachment_type > attachment_sequence;
    typedef attachment_sequence::iterator attachment_iterator;
    typedef attachment_sequence::const_iterator attachment_const_iterator;
    typedef ::xsd::cxx::tree::traits< attachment_type, char > attachment_traits;

    const attachment_sequence&
    attachment () const;

    attachment_sequence&
    attachment ();

    void
    attachment (const attachment_sequence& s);

    // summary
    //
    typedef ::xml_schema::string summary_type;
    typedef ::xsd::cxx::tree::optional< summary_type > summary_optional;
    typedef ::xsd::cxx::tree::traits< summary_type, char > summary_traits;

    const summary_optional&
    summary () const;

    summary_optional&
    summary ();

    void
    summary (const summary_type& x);

    void
    summary (const summary_optional& x);

    void
    summary (::std::unique_ptr< summary_type > p);

    // description
    //
    typedef ::xml_schema::string description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // color
    //
    typedef ::xml_schema::string color_type;
    typedef ::xsd::cxx::tree::optional< color_type > color_optional;
    typedef ::xsd::cxx::tree::traits< color_type, char > color_traits;

    const color_optional&
    color () const;

    color_optional&
    color ();

    void
    color (const color_type& x);

    void
    color (const color_optional& x);

    void
    color (::std::unique_ptr< color_type > p);

    // x-custom
    //
    typedef ::KolabXSD::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    Note (const uid_type&,
          const prodid_type&,
          const creation_date_type&,
          const last_modification_date_type&);

    Note (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    Note (const Note& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    virtual Note*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Note&
    operator= (const Note& x);

    virtual 
    ~Note ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< prodid_type > prodid_;
    ::xsd::cxx::tree::one< creation_date_type > creation_date_;
    ::xsd::cxx::tree::one< last_modification_date_type > last_modification_date_;
    categories_sequence categories_;
    classification_optional classification_;
    attachment_sequence attachment_;
    summary_optional summary_;
    description_optional description_;
    color_optional color_;
    x_custom_sequence x_custom_;
  };

  class File: public ::KolabXSD::KolabBase
  {
    public:
    // uid
    //
    typedef ::xml_schema::string uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // prodid
    //
    typedef ::xml_schema::string prodid_type;
    typedef ::xsd::cxx::tree::traits< prodid_type, char > prodid_traits;

    const prodid_type&
    prodid () const;

    prodid_type&
    prodid ();

    void
    prodid (const prodid_type& x);

    void
    prodid (::std::unique_ptr< prodid_type > p);

    // creation-date
    //
    typedef ::xml_schema::date_time creation_date_type;
    typedef ::xsd::cxx::tree::traits< creation_date_type, char > creation_date_traits;

    const creation_date_type&
    creation_date () const;

    creation_date_type&
    creation_date ();

    void
    creation_date (const creation_date_type& x);

    void
    creation_date (::std::unique_ptr< creation_date_type > p);

    // last-modification-date
    //
    typedef ::xml_schema::date_time last_modification_date_type;
    typedef ::xsd::cxx::tree::traits< last_modification_date_type, char > last_modification_date_traits;

    const last_modification_date_type&
    last_modification_date () const;

    last_modification_date_type&
    last_modification_date ();

    void
    last_modification_date (const last_modification_date_type& x);

    void
    last_modification_date (::std::unique_ptr< last_modification_date_type > p);

    // categories
    //
    typedef ::xml_schema::string categories_type;
    typedef ::xsd::cxx::tree::sequence< categories_type > categories_sequence;
    typedef categories_sequence::iterator categories_iterator;
    typedef categories_sequence::const_iterator categories_const_iterator;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_sequence&
    categories () const;

    categories_sequence&
    categories ();

    void
    categories (const categories_sequence& s);

    // classification
    //
    typedef ::KolabXSD::classifcationPropType classification_type;
    typedef ::xsd::cxx::tree::optional< classification_type > classification_optional;
    typedef ::xsd::cxx::tree::traits< classification_type, char > classification_traits;

    const classification_optional&
    classification () const;

    classification_optional&
    classification ();

    void
    classification (const classification_type& x);

    void
    classification (const classification_optional& x);

    void
    classification (::std::unique_ptr< classification_type > p);

    // file
    //
    typedef ::KolabXSD::attachmentPropType file_type;
    typedef ::xsd::cxx::tree::traits< file_type, char > file_traits;

    const file_type&
    file () const;

    file_type&
    file ();

    void
    file (const file_type& x);

    void
    file (::std::unique_ptr< file_type > p);

    // note
    //
    typedef ::xml_schema::string note_type;
    typedef ::xsd::cxx::tree::optional< note_type > note_optional;
    typedef ::xsd::cxx::tree::traits< note_type, char > note_traits;

    const note_optional&
    note () const;

    note_optional&
    note ();

    void
    note (const note_type& x);

    void
    note (const note_optional& x);

    void
    note (::std::unique_ptr< note_type > p);

    // x-custom
    //
    typedef ::KolabXSD::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    File (const uid_type&,
          const prodid_type&,
          const creation_date_type&,
          const last_modification_date_type&,
          const file_type&);

    File (const uid_type&,
          const prodid_type&,
          const creation_date_type&,
          const last_modification_date_type&,
          ::std::unique_ptr< file_type >);

    File (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    File (const File& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::container* c = 0);

    virtual File*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    File&
    operator= (const File& x);

    virtual 
    ~File ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< prodid_type > prodid_;
    ::xsd::cxx::tree::one< creation_date_type > creation_date_;
    ::xsd::cxx::tree::one< last_modification_date_type > last_modification_date_;
    categories_sequence categories_;
    classification_optional classification_;
    ::xsd::cxx::tree::one< file_type > file_;
    note_optional note_;
    x_custom_sequence x_custom_;
  };

  class ConfigurationType: public ::xml_schema::token
  {
    public:
    enum value
    {
      dictionary,
      categorycolor,
      snippets,
      relation,
      file_driver
    };

    ConfigurationType (value v);

    ConfigurationType (const char* v);

    ConfigurationType (const ::std::string& v);

    ConfigurationType (const ::xml_schema::token& v);

    ConfigurationType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ConfigurationType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ConfigurationType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ConfigurationType (const ConfigurationType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    ConfigurationType&
    operator= (const ConfigurationType&) = default;
#endif

    virtual ConfigurationType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ConfigurationType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ConfigurationType_convert ();
    }

    protected:
    value
    _xsd_ConfigurationType_convert () const;

    public:
    static const char* const _xsd_ConfigurationType_literals_[5];
    static const value _xsd_ConfigurationType_indexes_[5];
  };

  class CategoryColor: public ::xml_schema::type
  {
    public:
    // category
    //
    typedef ::xml_schema::string category_type;
    typedef ::xsd::cxx::tree::traits< category_type, char > category_traits;

    const category_type&
    category () const;

    category_type&
    category ();

    void
    category (const category_type& x);

    void
    category (::std::unique_ptr< category_type > p);

    // categorycolor
    //
    typedef ::KolabXSD::CategoryColor categorycolor_type;
    typedef ::xsd::cxx::tree::sequence< categorycolor_type > categorycolor_sequence;
    typedef categorycolor_sequence::iterator categorycolor_iterator;
    typedef categorycolor_sequence::const_iterator categorycolor_const_iterator;
    typedef ::xsd::cxx::tree::traits< categorycolor_type, char > categorycolor_traits;

    const categorycolor_sequence&
    categorycolor () const;

    categorycolor_sequence&
    categorycolor ();

    void
    categorycolor (const categorycolor_sequence& s);

    // color
    //
    typedef ::xml_schema::string color_type;
    typedef ::xsd::cxx::tree::optional< color_type > color_optional;
    typedef ::xsd::cxx::tree::traits< color_type, char > color_traits;

    const color_optional&
    color () const;

    color_optional&
    color ();

    void
    color (const color_type& x);

    void
    color (const color_optional& x);

    void
    color (::std::unique_ptr< color_type > p);

    // Constructors.
    //
    CategoryColor (const category_type&);

    CategoryColor (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    CategoryColor (const CategoryColor& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual CategoryColor*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CategoryColor&
    operator= (const CategoryColor& x);

    virtual 
    ~CategoryColor ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< category_type > category_;
    categorycolor_sequence categorycolor_;
    color_optional color_;
  };

  class textformatType: public ::xml_schema::token
  {
    public:
    enum value
    {
      PLAIN,
      HTML
    };

    textformatType (value v);

    textformatType (const char* v);

    textformatType (const ::std::string& v);

    textformatType (const ::xml_schema::token& v);

    textformatType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    textformatType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    textformatType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    textformatType (const textformatType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    textformatType&
    operator= (const textformatType&) = default;
#endif

    virtual textformatType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    textformatType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_textformatType_convert ();
    }

    protected:
    value
    _xsd_textformatType_convert () const;

    public:
    static const char* const _xsd_textformatType_literals_[2];
    static const value _xsd_textformatType_indexes_[2];
  };

  class Snippet: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // textformat
    //
    typedef ::KolabXSD::textformatType textformat_type;
    typedef ::xsd::cxx::tree::traits< textformat_type, char > textformat_traits;

    const textformat_type&
    textformat () const;

    textformat_type&
    textformat ();

    void
    textformat (const textformat_type& x);

    void
    textformat (::std::unique_ptr< textformat_type > p);

    // shortcut
    //
    typedef ::xml_schema::string shortcut_type;
    typedef ::xsd::cxx::tree::optional< shortcut_type > shortcut_optional;
    typedef ::xsd::cxx::tree::traits< shortcut_type, char > shortcut_traits;

    const shortcut_optional&
    shortcut () const;

    shortcut_optional&
    shortcut ();

    void
    shortcut (const shortcut_type& x);

    void
    shortcut (const shortcut_optional& x);

    void
    shortcut (::std::unique_ptr< shortcut_type > p);

    // color
    //
    typedef ::xml_schema::string color_type;
    typedef ::xsd::cxx::tree::optional< color_type > color_optional;
    typedef ::xsd::cxx::tree::traits< color_type, char > color_traits;

    const color_optional&
    color () const;

    color_optional&
    color ();

    void
    color (const color_type& x);

    void
    color (const color_optional& x);

    void
    color (::std::unique_ptr< color_type > p);

    // Constructors.
    //
    Snippet (const name_type&,
             const text_type&,
             const textformat_type&);

    Snippet (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Snippet (const Snippet& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Snippet*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Snippet&
    operator= (const Snippet& x);

    virtual 
    ~Snippet ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    ::xsd::cxx::tree::one< text_type > text_;
    ::xsd::cxx::tree::one< textformat_type > textformat_;
    shortcut_optional shortcut_;
    color_optional color_;
  };

  class FileDriverSettings: public ::xml_schema::type
  {
    public:
    // host
    //
    typedef ::xml_schema::string host_type;
    typedef ::xsd::cxx::tree::optional< host_type > host_optional;
    typedef ::xsd::cxx::tree::traits< host_type, char > host_traits;

    const host_optional&
    host () const;

    host_optional&
    host ();

    void
    host (const host_type& x);

    void
    host (const host_optional& x);

    void
    host (::std::unique_ptr< host_type > p);

    // port
    //
    typedef ::xml_schema::integer port_type;
    typedef ::xsd::cxx::tree::optional< port_type > port_optional;
    typedef ::xsd::cxx::tree::traits< port_type, char > port_traits;

    const port_optional&
    port () const;

    port_optional&
    port ();

    void
    port (const port_type& x);

    void
    port (const port_optional& x);

    // username
    //
    typedef ::xml_schema::string username_type;
    typedef ::xsd::cxx::tree::optional< username_type > username_optional;
    typedef ::xsd::cxx::tree::traits< username_type, char > username_traits;

    const username_optional&
    username () const;

    username_optional&
    username ();

    void
    username (const username_type& x);

    void
    username (const username_optional& x);

    void
    username (::std::unique_ptr< username_type > p);

    // password
    //
    typedef ::xml_schema::string password_type;
    typedef ::xsd::cxx::tree::optional< password_type > password_optional;
    typedef ::xsd::cxx::tree::traits< password_type, char > password_traits;

    const password_optional&
    password () const;

    password_optional&
    password ();

    void
    password (const password_type& x);

    void
    password (const password_optional& x);

    void
    password (::std::unique_ptr< password_type > p);

    // Constructors.
    //
    FileDriverSettings ();

    FileDriverSettings (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    FileDriverSettings (const FileDriverSettings& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual FileDriverSettings*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FileDriverSettings&
    operator= (const FileDriverSettings& x);

    virtual 
    ~FileDriverSettings ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    host_optional host_;
    port_optional port_;
    username_optional username_;
    password_optional password_;
  };

  class Configuration: public ::KolabXSD::KolabBase
  {
    public:
    // uid
    //
    typedef ::xml_schema::string uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // prodid
    //
    typedef ::xml_schema::string prodid_type;
    typedef ::xsd::cxx::tree::traits< prodid_type, char > prodid_traits;

    const prodid_type&
    prodid () const;

    prodid_type&
    prodid ();

    void
    prodid (const prodid_type& x);

    void
    prodid (::std::unique_ptr< prodid_type > p);

    // creation-date
    //
    typedef ::xml_schema::date_time creation_date_type;
    typedef ::xsd::cxx::tree::traits< creation_date_type, char > creation_date_traits;

    const creation_date_type&
    creation_date () const;

    creation_date_type&
    creation_date ();

    void
    creation_date (const creation_date_type& x);

    void
    creation_date (::std::unique_ptr< creation_date_type > p);

    // last-modification-date
    //
    typedef ::xml_schema::date_time last_modification_date_type;
    typedef ::xsd::cxx::tree::traits< last_modification_date_type, char > last_modification_date_traits;

    const last_modification_date_type&
    last_modification_date () const;

    last_modification_date_type&
    last_modification_date ();

    void
    last_modification_date (const last_modification_date_type& x);

    void
    last_modification_date (::std::unique_ptr< last_modification_date_type > p);

    // type
    //
    typedef ::KolabXSD::ConfigurationType type_type;
    typedef ::xsd::cxx::tree::traits< type_type, char > type_traits;

    const type_type&
    type () const;

    type_type&
    type ();

    void
    type (const type_type& x);

    void
    type (::std::unique_ptr< type_type > p);

    // language
    //
    typedef ::xml_schema::string language_type;
    typedef ::xsd::cxx::tree::optional< language_type > language_optional;
    typedef ::xsd::cxx::tree::traits< language_type, char > language_traits;

    const language_optional&
    language () const;

    language_optional&
    language ();

    void
    language (const language_type& x);

    void
    language (const language_optional& x);

    void
    language (::std::unique_ptr< language_type > p);

    // e
    //
    typedef ::xml_schema::string e_type;
    typedef ::xsd::cxx::tree::sequence< e_type > e_sequence;
    typedef e_sequence::iterator e_iterator;
    typedef e_sequence::const_iterator e_const_iterator;
    typedef ::xsd::cxx::tree::traits< e_type, char > e_traits;

    const e_sequence&
    e () const;

    e_sequence&
    e ();

    void
    e (const e_sequence& s);

    // categorycolor
    //
    typedef ::KolabXSD::CategoryColor categorycolor_type;
    typedef ::xsd::cxx::tree::sequence< categorycolor_type > categorycolor_sequence;
    typedef categorycolor_sequence::iterator categorycolor_iterator;
    typedef categorycolor_sequence::const_iterator categorycolor_const_iterator;
    typedef ::xsd::cxx::tree::traits< categorycolor_type, char > categorycolor_traits;

    const categorycolor_sequence&
    categorycolor () const;

    categorycolor_sequence&
    categorycolor ();

    void
    categorycolor (const categorycolor_sequence& s);

    // name
    //
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::optional< name_type > name_optional;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_optional&
    name () const;

    name_optional&
    name ();

    void
    name (const name_type& x);

    void
    name (const name_optional& x);

    void
    name (::std::unique_ptr< name_type > p);

    // snippet
    //
    typedef ::KolabXSD::Snippet snippet_type;
    typedef ::xsd::cxx::tree::sequence< snippet_type > snippet_sequence;
    typedef snippet_sequence::iterator snippet_iterator;
    typedef snippet_sequence::const_iterator snippet_const_iterator;
    typedef ::xsd::cxx::tree::traits< snippet_type, char > snippet_traits;

    const snippet_sequence&
    snippet () const;

    snippet_sequence&
    snippet ();

    void
    snippet (const snippet_sequence& s);

    // relationType
    //
    typedef ::xml_schema::string relationType_type;
    typedef ::xsd::cxx::tree::optional< relationType_type > relationType_optional;
    typedef ::xsd::cxx::tree::traits< relationType_type, char > relationType_traits;

    const relationType_optional&
    relationType () const;

    relationType_optional&
    relationType ();

    void
    relationType (const relationType_type& x);

    void
    relationType (const relationType_optional& x);

    void
    relationType (::std::unique_ptr< relationType_type > p);

    // color
    //
    typedef ::xml_schema::string color_type;
    typedef ::xsd::cxx::tree::optional< color_type > color_optional;
    typedef ::xsd::cxx::tree::traits< color_type, char > color_traits;

    const color_optional&
    color () const;

    color_optional&
    color ();

    void
    color (const color_type& x);

    void
    color (const color_optional& x);

    void
    color (::std::unique_ptr< color_type > p);

    // iconName
    //
    typedef ::xml_schema::string iconName_type;
    typedef ::xsd::cxx::tree::optional< iconName_type > iconName_optional;
    typedef ::xsd::cxx::tree::traits< iconName_type, char > iconName_traits;

    const iconName_optional&
    iconName () const;

    iconName_optional&
    iconName ();

    void
    iconName (const iconName_type& x);

    void
    iconName (const iconName_optional& x);

    void
    iconName (::std::unique_ptr< iconName_type > p);

    // priority
    //
    typedef ::xml_schema::integer priority_type;
    typedef ::xsd::cxx::tree::optional< priority_type > priority_optional;
    typedef ::xsd::cxx::tree::traits< priority_type, char > priority_traits;

    const priority_optional&
    priority () const;

    priority_optional&
    priority ();

    void
    priority (const priority_type& x);

    void
    priority (const priority_optional& x);

    // parent
    //
    typedef ::xml_schema::string parent_type;
    typedef ::xsd::cxx::tree::optional< parent_type > parent_optional;
    typedef ::xsd::cxx::tree::traits< parent_type, char > parent_traits;

    const parent_optional&
    parent () const;

    parent_optional&
    parent ();

    void
    parent (const parent_type& x);

    void
    parent (const parent_optional& x);

    void
    parent (::std::unique_ptr< parent_type > p);

    // member
    //
    typedef ::xml_schema::string member_type;
    typedef ::xsd::cxx::tree::sequence< member_type > member_sequence;
    typedef member_sequence::iterator member_iterator;
    typedef member_sequence::const_iterator member_const_iterator;
    typedef ::xsd::cxx::tree::traits< member_type, char > member_traits;

    const member_sequence&
    member () const;

    member_sequence&
    member ();

    void
    member (const member_sequence& s);

    // driver
    //
    typedef ::xml_schema::string driver_type;
    typedef ::xsd::cxx::tree::optional< driver_type > driver_optional;
    typedef ::xsd::cxx::tree::traits< driver_type, char > driver_traits;

    const driver_optional&
    driver () const;

    driver_optional&
    driver ();

    void
    driver (const driver_type& x);

    void
    driver (const driver_optional& x);

    void
    driver (::std::unique_ptr< driver_type > p);

    // title
    //
    typedef ::xml_schema::string title_type;
    typedef ::xsd::cxx::tree::optional< title_type > title_optional;
    typedef ::xsd::cxx::tree::traits< title_type, char > title_traits;

    const title_optional&
    title () const;

    title_optional&
    title ();

    void
    title (const title_type& x);

    void
    title (const title_optional& x);

    void
    title (::std::unique_ptr< title_type > p);

    // enabled
    //
    typedef ::xml_schema::boolean enabled_type;
    typedef ::xsd::cxx::tree::optional< enabled_type > enabled_optional;
    typedef ::xsd::cxx::tree::traits< enabled_type, char > enabled_traits;

    const enabled_optional&
    enabled () const;

    enabled_optional&
    enabled ();

    void
    enabled (const enabled_type& x);

    void
    enabled (const enabled_optional& x);

    // settings
    //
    typedef ::KolabXSD::FileDriverSettings settings_type;
    typedef ::xsd::cxx::tree::optional< settings_type > settings_optional;
    typedef ::xsd::cxx::tree::traits< settings_type, char > settings_traits;

    const settings_optional&
    settings () const;

    settings_optional&
    settings ();

    void
    settings (const settings_type& x);

    void
    settings (const settings_optional& x);

    void
    settings (::std::unique_ptr< settings_type > p);

    // Constructors.
    //
    Configuration (const uid_type&,
                   const prodid_type&,
                   const creation_date_type&,
                   const last_modification_date_type&,
                   const type_type&);

    Configuration (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    Configuration (const Configuration& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual Configuration*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Configuration&
    operator= (const Configuration& x);

    virtual 
    ~Configuration ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< prodid_type > prodid_;
    ::xsd::cxx::tree::one< creation_date_type > creation_date_;
    ::xsd::cxx::tree::one< last_modification_date_type > last_modification_date_;
    ::xsd::cxx::tree::one< type_type > type_;
    language_optional language_;
    e_sequence e_;
    categorycolor_sequence categorycolor_;
    name_optional name_;
    snippet_sequence snippet_;
    relationType_optional relationType_;
    color_optional color_;
    iconName_optional iconName_;
    priority_optional priority_;
    parent_optional parent_;
    member_sequence member_;
    driver_optional driver_;
    title_optional title_;
    enabled_optional enabled_;
    settings_optional settings_;
  };

  class parameters: public ::xml_schema::type
  {
    public:
    // fmttype
    //
    typedef ::xml_schema::string fmttype_type;
    typedef ::xsd::cxx::tree::traits< fmttype_type, char > fmttype_traits;

    const fmttype_type&
    fmttype () const;

    fmttype_type&
    fmttype ();

    void
    fmttype (const fmttype_type& x);

    void
    fmttype (::std::unique_ptr< fmttype_type > p);

    // x-label
    //
    typedef ::xml_schema::string x_label_type;
    typedef ::xsd::cxx::tree::optional< x_label_type > x_label_optional;
    typedef ::xsd::cxx::tree::traits< x_label_type, char > x_label_traits;

    const x_label_optional&
    x_label () const;

    x_label_optional&
    x_label ();

    void
    x_label (const x_label_type& x);

    void
    x_label (const x_label_optional& x);

    void
    x_label (::std::unique_ptr< x_label_type > p);

    // encoding
    //
    typedef ::xml_schema::string encoding_type;
    typedef ::xsd::cxx::tree::optional< encoding_type > encoding_optional;
    typedef ::xsd::cxx::tree::traits< encoding_type, char > encoding_traits;

    const encoding_optional&
    encoding () const;

    encoding_optional&
    encoding ();

    void
    encoding (const encoding_type& x);

    void
    encoding (const encoding_optional& x);

    void
    encoding (::std::unique_ptr< encoding_type > p);

    static const encoding_type&
    encoding_default_value ();

    // Constructors.
    //
    parameters (const fmttype_type&);

    parameters (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    parameters (const parameters& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual parameters*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    parameters&
    operator= (const parameters& x);

    virtual 
    ~parameters ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< fmttype_type > fmttype_;
    x_label_optional x_label_;
    encoding_optional encoding_;
    static const encoding_type encoding_default_value_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace KolabXSD
{
  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& uri,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& uri,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& uri,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& id,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::xercesc::DOMDocument& d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& uri,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& uri,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& uri,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& id,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::xercesc::DOMDocument& d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& uri,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& uri,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& uri,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& id,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& id,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& id,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& is,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& is,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& is,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::xercesc::DOMDocument& d,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace KolabXSD
{
  void
  operator<< (::xercesc::DOMElement&, const KolabBase&);

  void
  operator<< (::xercesc::DOMElement&, const attachmentPropType&);

  void
  operator<< (::xercesc::DOMElement&, const classifcationPropType&);

  void
  operator<< (::xercesc::DOMAttr&, const classifcationPropType&);

  void
  operator<< (::xml_schema::list_stream&,
              const classifcationPropType&);

  void
  operator<< (::xercesc::DOMElement&, const CustomType&);

  void
  operator<< (::xercesc::DOMElement&, const Note&);

  // Serialize to std::ostream.
  //

  void
  note (::std::ostream& os,
        const ::KolabXSD::Note& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  note (::std::ostream& os,
        const ::KolabXSD::Note& x, 
        ::xml_schema::error_handler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  note (::std::ostream& os,
        const ::KolabXSD::Note& x, 
        ::xercesc::DOMErrorHandler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  note (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::Note& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  note (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::Note& x, 
        ::xml_schema::error_handler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  note (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::Note& x, 
        ::xercesc::DOMErrorHandler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  note (::xercesc::DOMDocument& d,
        const ::KolabXSD::Note& x,
        ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  note (const ::KolabXSD::Note& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const File&);

  // Serialize to std::ostream.
  //

  void
  file (::std::ostream& os,
        const ::KolabXSD::File& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  file (::std::ostream& os,
        const ::KolabXSD::File& x, 
        ::xml_schema::error_handler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  file (::std::ostream& os,
        const ::KolabXSD::File& x, 
        ::xercesc::DOMErrorHandler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  file (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::File& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  file (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::File& x, 
        ::xml_schema::error_handler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  void
  file (::xercesc::XMLFormatTarget& ft,
        const ::KolabXSD::File& x, 
        ::xercesc::DOMErrorHandler& eh,
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        const ::std::string& e = "UTF-8",
        ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  file (::xercesc::DOMDocument& d,
        const ::KolabXSD::File& x,
        ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  file (const ::KolabXSD::File& x, 
        const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
        ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const ConfigurationType&);

  void
  operator<< (::xercesc::DOMAttr&, const ConfigurationType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ConfigurationType&);

  void
  operator<< (::xercesc::DOMElement&, const CategoryColor&);

  void
  operator<< (::xercesc::DOMElement&, const textformatType&);

  void
  operator<< (::xercesc::DOMAttr&, const textformatType&);

  void
  operator<< (::xml_schema::list_stream&,
              const textformatType&);

  void
  operator<< (::xercesc::DOMElement&, const Snippet&);

  void
  operator<< (::xercesc::DOMElement&, const FileDriverSettings&);

  void
  operator<< (::xercesc::DOMElement&, const Configuration&);

  // Serialize to std::ostream.
  //

  void
  configuration (::std::ostream& os,
                 const ::KolabXSD::Configuration& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  configuration (::std::ostream& os,
                 const ::KolabXSD::Configuration& x, 
                 ::xml_schema::error_handler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  configuration (::std::ostream& os,
                 const ::KolabXSD::Configuration& x, 
                 ::xercesc::DOMErrorHandler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  configuration (::xercesc::XMLFormatTarget& ft,
                 const ::KolabXSD::Configuration& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  configuration (::xercesc::XMLFormatTarget& ft,
                 const ::KolabXSD::Configuration& x, 
                 ::xml_schema::error_handler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  configuration (::xercesc::XMLFormatTarget& ft,
                 const ::KolabXSD::Configuration& x, 
                 ::xercesc::DOMErrorHandler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  configuration (::xercesc::DOMDocument& d,
                 const ::KolabXSD::Configuration& x,
                 ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  configuration (const ::KolabXSD::Configuration& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const parameters&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_HXX
