/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_lmx2592_regs.py on Wed Oct 15 18:53:21 2025
 **********************************************************************/

#ifndef INCLUDED_LMX2592_REGS_HPP
#define INCLUDED_LMX2592_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class lmx2592_regs_t{
public:
    uint8_t powerdown;
    uint8_t reset;
    enum muxout_sel_t{
        MUXOUT_SEL_READBACK = 0,
        MUXOUT_SEL_LOCK_DETECT = 1
    };
    muxout_sel_t muxout_sel;
    uint8_t fcal_enable;
    uint8_t acal_enable;
    enum fcal_lpfd_adj_t{
        FCAL_LPFD_ADJ_UNUSED = 0,
        FCAL_LPFD_ADJ_20MHZ = 1,
        FCAL_LPFD_ADJ_10MHZ = 2,
        FCAL_LPFD_ADJ_5MHZ = 3
    };
    fcal_lpfd_adj_t fcal_lpfd_adj;
    enum fcal_hpfd_adj_t{
        FCAL_HPFD_ADJ_UNUSED = 0,
        FCAL_HPFD_ADJ_100MHZ = 1,
        FCAL_HPFD_ADJ_150MHZ = 2,
        FCAL_HPFD_ADJ_200MHZ = 3
    };
    fcal_hpfd_adj_t fcal_hpfd_adj;
    uint8_t reg0_reserved0;
    uint8_t ld_enable;
    uint8_t reg0_reserved1;
    uint8_t cal_clk_div;
    uint16_t reg1_reserved0;
    uint16_t reg2_reserved0;
    uint8_t reg4_reserved0;
    uint8_t acal_cmp_delay;
    uint16_t reg7_reserved0;
    uint16_t reg8_reserved0;
    uint8_t vco_capctrl_ovr;
    uint8_t reg8_reserved1;
    uint8_t vco_idac_ovr;
    uint8_t reg8_reserved2;
    uint16_t reg9_reserved0;
    uint8_t ref_enable;
    uint8_t reg9_reserved1;
    uint8_t osc_doubler;
    uint8_t reg9_reserved2;
    uint8_t reg10_reserved0;
    uint8_t mult;
    uint8_t reg10_reserved1;
    uint8_t reg11_reserved0;
    uint8_t pll_r;
    uint8_t reg11_reserved1;
    uint16_t pll_r_pre;
    uint8_t reg12_reserved0;
    uint8_t reg13_reserved0;
    enum pfd_ctl_t{
        PFD_CTL_DUAL_PFD = 0,
        PFD_CTL_SINGLE_PFD = 3
    };
    pfd_ctl_t pfd_ctl;
    uint8_t reg13_reserved1;
    uint8_t cp_enable;
    uint8_t reg13_reserved2;
    enum cp_icoarse_t{
        CP_ICOARSE_MULTIPLY_BY_1 = 0,
        CP_ICOARSE_MULTIPLY_BY_2 = 1,
        CP_ICOARSE_MULTIPLY_BY_1_5 = 2,
        CP_ICOARSE_MULTIPLY_BY_2_5 = 3
    };
    cp_icoarse_t cp_icoarse;
    uint8_t cp_iup;
    uint8_t cp_idn;
    uint8_t reg14_reserved0;
    uint8_t reg19_reserved0;
    uint16_t vco_idac;
    uint8_t reg19_reserved1;
    uint16_t acal_vco_idac_strt;
    uint8_t reg20_reserved0;
    uint8_t vco_capctrl;
    uint8_t reg22_reserved0;
    uint16_t reg23_reserved0;
    uint8_t vco_sel_force;
    uint8_t vco_sel;
    uint8_t fcal_vco_sel_strt;
    uint8_t reg23_reserved1;
    uint16_t reg24_reserved0;
    uint16_t reg25_reserved0;
    uint16_t reg28_reserved0;
    uint16_t reg29_reserved0;
    uint8_t vco_doubler_en;
    uint16_t reg30_reserved0;
    uint8_t mash_ditherer;
    uint8_t reg30_reserved1;
    uint8_t reg31_reserved0;
    uint8_t chdiv_dist_pd;
    uint8_t reg31_reserved1;
    uint8_t vco_dista_pd;
    uint8_t vco_distb_pd;
    uint8_t reg31_reserved2;
    uint16_t reg32_reserved0;
    uint16_t reg33_reserved0;
    uint8_t reg34_reserved0;
    uint8_t chdiv_en;
    uint16_t reg34_reserved1;
    uint8_t reg35_reserved0;
    uint8_t chdiv_seg1_en;
    enum chdiv_seg1_t{
        CHDIV_SEG1_DIVIDE_BY_2 = 0,
        CHDIV_SEG1_DIVIDE_BY_3 = 1
    };
    chdiv_seg1_t chdiv_seg1;
    uint8_t reg35_reserved1;
    uint8_t chdiv_seg2_en;
    uint8_t chdiv_seg3_en;
    enum chdiv_seg2_t{
        CHDIV_SEG2_POWERDOWN = 0,
        CHDIV_SEG2_DIVIDE_BY_2 = 1,
        CHDIV_SEG2_DIVIDE_BY_4 = 2,
        CHDIV_SEG2_DIVIDE_BY_6 = 4,
        CHDIV_SEG2_DIVIDE_BY_8 = 8
    };
    chdiv_seg2_t chdiv_seg2;
    uint8_t reg35_reserved2;
    enum chdiv_seg3_t{
        CHDIV_SEG3_POWERDOWN = 0,
        CHDIV_SEG3_DIVIDE_BY_2 = 1,
        CHDIV_SEG3_DIVIDE_BY_4 = 2,
        CHDIV_SEG3_DIVIDE_BY_6 = 4,
        CHDIV_SEG3_DIVIDE_BY_8 = 8
    };
    chdiv_seg3_t chdiv_seg3;
    enum chdiv_seg_sel_t{
        CHDIV_SEG_SEL_POWERDOWN = 0,
        CHDIV_SEG_SEL_DIV_SEG_1 = 1,
        CHDIV_SEG_SEL_DIV_SEG_1_AND_2 = 2,
        CHDIV_SEG_SEL_DIV_SEG_1_2_AND_3 = 4
    };
    chdiv_seg_sel_t chdiv_seg_sel;
    uint8_t reg36_reserved0;
    uint8_t chdiv_dista_en;
    uint8_t chdiv_distb_en;
    uint8_t reg36_reserved1;
    uint16_t reg37_reserved0;
    enum pll_n_pre_t{
        PLL_N_PRE_DIVIDE_BY_2 = 0,
        PLL_N_PRE_DIVIDE_BY_4 = 1
    };
    pll_n_pre_t pll_n_pre;
    uint8_t reg37_reserved1;
    uint8_t reg38_reserved0;
    uint16_t pll_n;
    uint8_t reg38_reserved1;
    uint8_t reg39_reserved0;
    enum pfd_dly_t{
        PFD_DLY_4_CLK_DELAY = 1,
        PFD_DLY_6_CLK_DELAY = 2,
        PFD_DLY_8_CLK_DELAY = 4,
        PFD_DLY_12_CLK_DELAY = 8,
        PFD_DLY_16_CLK_DELAY = 16
    };
    pfd_dly_t pfd_dly;
    uint8_t reg39_reserved1;
    uint16_t pll_den_msb;
    uint16_t pll_den_lsb;
    uint16_t mash_seed_msb;
    uint16_t mash_seed_lsb;
    uint16_t pll_num_msb;
    uint16_t pll_num_lsb;
    enum mash_order_t{
        MASH_ORDER_INT_MODE = 0,
        MASH_ORDER_FIRST = 1,
        MASH_ORDER_SECOND = 2,
        MASH_ORDER_THIRD = 3,
        MASH_ORDER_FOURTH = 4
    };
    mash_order_t mash_order;
    uint8_t reg46_reserved0;
    uint8_t outa_pd;
    uint8_t outb_pd;
    uint8_t outa_power;
    uint8_t reg46_reserved1;
    uint8_t outb_power;
    uint8_t reg47_reserved0;
    enum outa_mux_t{
        OUTA_MUX_DIVIDER = 0,
        OUTA_MUX_VCO = 1
    };
    outa_mux_t outa_mux;
    uint8_t reg47_reserved1;
    enum outb_mux_t{
        OUTB_MUX_DIVIDER = 0,
        OUTB_MUX_VCO = 1
    };
    outb_mux_t outb_mux;
    uint16_t reg48_reserved0;
    uint8_t reg59_reserved0;
    uint8_t muxout_hdrv;
    uint16_t reg59_reserved1;
    enum ld_type_t{
        LD_TYPE_CAL_STATUS = 0,
        LD_TYPE_VTUNE_DETECT = 1
    };
    ld_type_t ld_type;
    uint16_t reg61_reserved0;
    uint16_t reg62_reserved0;
    uint8_t fjump_size;
    uint8_t reg64_reserved0;
    uint8_t ajump_size;
    uint8_t fcal_fast;
    uint8_t acal_fast;
    uint8_t reg64_reserved1;

    lmx2592_regs_t(void){
        _state = NULL;
        powerdown = 0;
        reset = 0;
        muxout_sel = MUXOUT_SEL_LOCK_DETECT;
        fcal_enable = 1;
        acal_enable = 1;
        fcal_lpfd_adj = FCAL_LPFD_ADJ_UNUSED;
        fcal_hpfd_adj = FCAL_HPFD_ADJ_UNUSED;
        reg0_reserved0 = 1;
        ld_enable = 1;
        reg0_reserved1 = 0;
        cal_clk_div = 3;
        reg1_reserved0 = 257;
        reg2_reserved0 = 1280;
        reg4_reserved0 = 67;
        acal_cmp_delay = 25;
        reg7_reserved0 = 10418;
        reg8_reserved0 = 132;
        vco_capctrl_ovr = 0;
        reg8_reserved1 = 2;
        vco_idac_ovr = 0;
        reg8_reserved2 = 0;
        reg9_reserved0 = 258;
        ref_enable = 1;
        reg9_reserved1 = 0;
        osc_doubler = 0;
        reg9_reserved2 = 0;
        reg10_reserved0 = 88;
        mult = 1;
        reg10_reserved1 = 1;
        reg11_reserved0 = 8;
        pll_r = 1;
        reg11_reserved1 = 0;
        pll_r_pre = 1;
        reg12_reserved0 = 7;
        reg13_reserved0 = 0;
        pfd_ctl = PFD_CTL_DUAL_PFD;
        reg13_reserved1 = 0;
        cp_enable = 1;
        reg13_reserved2 = 0;
        cp_icoarse = CP_ICOARSE_MULTIPLY_BY_2;
        cp_iup = 3;
        cp_idn = 3;
        reg14_reserved0 = 0;
        reg19_reserved0 = 5;
        vco_idac = 300;
        reg19_reserved1 = 0;
        acal_vco_idac_strt = 300;
        reg20_reserved0 = 0;
        vco_capctrl = 0;
        reg22_reserved0 = 35;
        reg23_reserved0 = 66;
        vco_sel_force = 0;
        vco_sel = 1;
        fcal_vco_sel_strt = 0;
        reg23_reserved1 = 1;
        reg24_reserved0 = 1289;
        reg25_reserved0 = 0;
        reg28_reserved0 = 10532;
        reg29_reserved0 = 132;
        vco_doubler_en = 0;
        reg30_reserved0 = 26;
        mash_ditherer = 0;
        reg30_reserved1 = 0;
        reg31_reserved0 = 1;
        chdiv_dist_pd = 0;
        reg31_reserved1 = 0;
        vco_dista_pd = 0;
        vco_distb_pd = 1;
        reg31_reserved2 = 0;
        reg32_reserved0 = 8458;
        reg33_reserved0 = 10762;
        reg34_reserved0 = 10;
        chdiv_en = 1;
        reg34_reserved1 = 783;
        reg35_reserved0 = 1;
        chdiv_seg1_en = 0;
        chdiv_seg1 = CHDIV_SEG1_DIVIDE_BY_3;
        reg35_reserved1 = 3;
        chdiv_seg2_en = 0;
        chdiv_seg3_en = 0;
        chdiv_seg2 = CHDIV_SEG2_DIVIDE_BY_2;
        reg35_reserved2 = 0;
        chdiv_seg3 = CHDIV_SEG3_DIVIDE_BY_2;
        chdiv_seg_sel = CHDIV_SEG_SEL_DIV_SEG_1;
        reg36_reserved0 = 0;
        chdiv_dista_en = 1;
        chdiv_distb_en = 0;
        reg36_reserved1 = 0;
        reg37_reserved0 = 0;
        pll_n_pre = PLL_N_PRE_DIVIDE_BY_2;
        reg37_reserved1 = 2;
        reg38_reserved0 = 0;
        pll_n = 27;
        reg38_reserved1 = 0;
        reg39_reserved0 = 4;
        pfd_dly = PFD_DLY_6_CLK_DELAY;
        reg39_reserved1 = 2;
        pll_den_msb = 1000;
        pll_den_lsb = 1000;
        mash_seed_msb = 0;
        mash_seed_lsb = 0;
        pll_num_msb = 0;
        pll_num_lsb = 0;
        mash_order = MASH_ORDER_THIRD;
        reg46_reserved0 = 4;
        outa_pd = 0;
        outb_pd = 1;
        outa_power = 15;
        reg46_reserved1 = 0;
        outb_power = 0;
        reg47_reserved0 = 3;
        outa_mux = OUTA_MUX_DIVIDER;
        reg47_reserved1 = 0;
        outb_mux = OUTB_MUX_DIVIDER;
        reg48_reserved0 = 255;
        reg59_reserved0 = 0;
        muxout_hdrv = 0;
        reg59_reserved1 = 0;
        ld_type = LD_TYPE_VTUNE_DETECT;
        reg61_reserved0 = 0;
        reg62_reserved0 = 0;
        fjump_size = 15;
        reg64_reserved0 = 1;
        ajump_size = 3;
        fcal_fast = 0;
        acal_fast = 0;
        reg64_reserved1 = 0;
    }

    ~lmx2592_regs_t(void){
        delete _state;
    }

    enum addr_t{
        ADDR_R0 = 0,
        ADDR_R1 = 1,
        ADDR_R2 = 2,
        ADDR_R4 = 4,
        ADDR_R7 = 7,
        ADDR_R8 = 8,
        ADDR_R9 = 9,
        ADDR_R10 = 10,
        ADDR_R11 = 11,
        ADDR_R12 = 12,
        ADDR_R13 = 13,
        ADDR_R14 = 14,
        ADDR_R19 = 19,
        ADDR_R20 = 20,
        ADDR_R22 = 22,
        ADDR_R23 = 23,
        ADDR_R24 = 24,
        ADDR_R25 = 25,
        ADDR_R28 = 28,
        ADDR_R29 = 29,
        ADDR_R30 = 30,
        ADDR_R31 = 31,
        ADDR_R32 = 32,
        ADDR_R33 = 33,
        ADDR_R34 = 34,
        ADDR_R35 = 35,
        ADDR_R36 = 36,
        ADDR_R37 = 37,
        ADDR_R38 = 38,
        ADDR_R39 = 39,
        ADDR_R40 = 40,
        ADDR_R41 = 41,
        ADDR_R42 = 42,
        ADDR_R43 = 43,
        ADDR_R44 = 44,
        ADDR_R45 = 45,
        ADDR_R46 = 46,
        ADDR_R47 = 47,
        ADDR_R48 = 48,
        ADDR_R59 = 59,
        ADDR_R61 = 61,
        ADDR_R62 = 62,
        ADDR_R64 = 64
    };
    
    uint16_t get_reg(uint8_t addr){
        uint16_t reg = 0;
        switch(addr){
        case 0:
            reg |= (uint16_t(powerdown) & 0x1) << 0;
            reg |= (uint16_t(reset) & 0x1) << 1;
            reg |= (uint16_t(muxout_sel) & 0x1) << 2;
            reg |= (uint16_t(fcal_enable) & 0x1) << 3;
            reg |= (uint16_t(acal_enable) & 0x1) << 4;
            reg |= (uint16_t(fcal_lpfd_adj) & 0x3) << 5;
            reg |= (uint16_t(fcal_hpfd_adj) & 0x3) << 7;
            reg |= (uint16_t(reg0_reserved0) & 0xf) << 9;
            reg |= (uint16_t(ld_enable) & 0x1) << 13;
            reg |= (uint16_t(reg0_reserved1) & 0x3) << 14;
            break;
        case 1:
            reg |= (uint16_t(cal_clk_div) & 0x7) << 0;
            reg |= (uint16_t(reg1_reserved0) & 0x1fff) << 3;
            break;
        case 2:
            reg |= (uint16_t(reg2_reserved0) & 0xffff) << 0;
            break;
        case 4:
            reg |= (uint16_t(reg4_reserved0) & 0xff) << 0;
            reg |= (uint16_t(acal_cmp_delay) & 0xff) << 8;
            break;
        case 7:
            reg |= (uint16_t(reg7_reserved0) & 0xffff) << 0;
            break;
        case 8:
            reg |= (uint16_t(reg8_reserved0) & 0x3ff) << 0;
            reg |= (uint16_t(vco_capctrl_ovr) & 0x1) << 10;
            reg |= (uint16_t(reg8_reserved1) & 0x3) << 11;
            reg |= (uint16_t(vco_idac_ovr) & 0x1) << 13;
            reg |= (uint16_t(reg8_reserved2) & 0x3) << 14;
            break;
        case 9:
            reg |= (uint16_t(reg9_reserved0) & 0x1ff) << 0;
            reg |= (uint16_t(ref_enable) & 0x1) << 9;
            reg |= (uint16_t(reg9_reserved1) & 0x1) << 10;
            reg |= (uint16_t(osc_doubler) & 0x1) << 11;
            reg |= (uint16_t(reg9_reserved2) & 0xf) << 12;
            break;
        case 10:
            reg |= (uint16_t(reg10_reserved0) & 0x7f) << 0;
            reg |= (uint16_t(mult) & 0x1f) << 7;
            reg |= (uint16_t(reg10_reserved1) & 0xf) << 12;
            break;
        case 11:
            reg |= (uint16_t(reg11_reserved0) & 0xf) << 0;
            reg |= (uint16_t(pll_r) & 0xff) << 4;
            reg |= (uint16_t(reg11_reserved1) & 0xf) << 12;
            break;
        case 12:
            reg |= (uint16_t(pll_r_pre) & 0xfff) << 0;
            reg |= (uint16_t(reg12_reserved0) & 0xf) << 12;
            break;
        case 13:
            reg |= (uint16_t(reg13_reserved0) & 0xff) << 0;
            reg |= (uint16_t(pfd_ctl) & 0x3) << 8;
            reg |= (uint16_t(reg13_reserved1) & 0xf) << 10;
            reg |= (uint16_t(cp_enable) & 0x1) << 14;
            reg |= (uint16_t(reg13_reserved2) & 0x1) << 15;
            break;
        case 14:
            reg |= (uint16_t(cp_icoarse) & 0x3) << 0;
            reg |= (uint16_t(cp_iup) & 0x1f) << 2;
            reg |= (uint16_t(cp_idn) & 0x1f) << 7;
            reg |= (uint16_t(reg14_reserved0) & 0xf) << 12;
            break;
        case 19:
            reg |= (uint16_t(reg19_reserved0) & 0x7) << 0;
            reg |= (uint16_t(vco_idac) & 0x1ff) << 3;
            reg |= (uint16_t(reg19_reserved1) & 0xf) << 12;
            break;
        case 20:
            reg |= (uint16_t(acal_vco_idac_strt) & 0x1ff) << 0;
            reg |= (uint16_t(reg20_reserved0) & 0x7f) << 9;
            break;
        case 22:
            reg |= (uint16_t(vco_capctrl) & 0xff) << 0;
            reg |= (uint16_t(reg22_reserved0) & 0xff) << 8;
            break;
        case 23:
            reg |= (uint16_t(reg23_reserved0) & 0x3ff) << 0;
            reg |= (uint16_t(vco_sel_force) & 0x1) << 10;
            reg |= (uint16_t(vco_sel) & 0x7) << 11;
            reg |= (uint16_t(fcal_vco_sel_strt) & 0x1) << 14;
            reg |= (uint16_t(reg23_reserved1) & 0x1) << 15;
            break;
        case 24:
            reg |= (uint16_t(reg24_reserved0) & 0xffff) << 0;
            break;
        case 25:
            reg |= (uint16_t(reg25_reserved0) & 0xffff) << 0;
            break;
        case 28:
            reg |= (uint16_t(reg28_reserved0) & 0xffff) << 0;
            break;
        case 29:
            reg |= (uint16_t(reg29_reserved0) & 0xffff) << 0;
            break;
        case 30:
            reg |= (uint16_t(vco_doubler_en) & 0x1) << 0;
            reg |= (uint16_t(reg30_reserved0) & 0x1ff) << 1;
            reg |= (uint16_t(mash_ditherer) & 0x1) << 10;
            reg |= (uint16_t(reg30_reserved1) & 0x1f) << 11;
            break;
        case 31:
            reg |= (uint16_t(reg31_reserved0) & 0x7f) << 0;
            reg |= (uint16_t(chdiv_dist_pd) & 0x1) << 7;
            reg |= (uint16_t(reg31_reserved1) & 0x1) << 8;
            reg |= (uint16_t(vco_dista_pd) & 0x1) << 9;
            reg |= (uint16_t(vco_distb_pd) & 0x1) << 10;
            reg |= (uint16_t(reg31_reserved2) & 0x1f) << 11;
            break;
        case 32:
            reg |= (uint16_t(reg32_reserved0) & 0xffff) << 0;
            break;
        case 33:
            reg |= (uint16_t(reg33_reserved0) & 0xffff) << 0;
            break;
        case 34:
            reg |= (uint16_t(reg34_reserved0) & 0x1f) << 0;
            reg |= (uint16_t(chdiv_en) & 0x1) << 5;
            reg |= (uint16_t(reg34_reserved1) & 0x3ff) << 6;
            break;
        case 35:
            reg |= (uint16_t(reg35_reserved0) & 0x1) << 0;
            reg |= (uint16_t(chdiv_seg1_en) & 0x1) << 1;
            reg |= (uint16_t(chdiv_seg1) & 0x1) << 2;
            reg |= (uint16_t(reg35_reserved1) & 0xf) << 3;
            reg |= (uint16_t(chdiv_seg2_en) & 0x1) << 7;
            reg |= (uint16_t(chdiv_seg3_en) & 0x1) << 8;
            reg |= (uint16_t(chdiv_seg2) & 0xf) << 9;
            reg |= (uint16_t(reg35_reserved2) & 0x7) << 13;
            break;
        case 36:
            reg |= (uint16_t(chdiv_seg3) & 0xf) << 0;
            reg |= (uint16_t(chdiv_seg_sel) & 0x7) << 4;
            reg |= (uint16_t(reg36_reserved0) & 0x7) << 7;
            reg |= (uint16_t(chdiv_dista_en) & 0x1) << 10;
            reg |= (uint16_t(chdiv_distb_en) & 0x1) << 11;
            reg |= (uint16_t(reg36_reserved1) & 0xf) << 12;
            break;
        case 37:
            reg |= (uint16_t(reg37_reserved0) & 0xfff) << 0;
            reg |= (uint16_t(pll_n_pre) & 0x1) << 12;
            reg |= (uint16_t(reg37_reserved1) & 0x7) << 13;
            break;
        case 38:
            reg |= (uint16_t(reg38_reserved0) & 0x1) << 0;
            reg |= (uint16_t(pll_n) & 0xfff) << 1;
            reg |= (uint16_t(reg38_reserved1) & 0x7) << 13;
            break;
        case 39:
            reg |= (uint16_t(reg39_reserved0) & 0xff) << 0;
            reg |= (uint16_t(pfd_dly) & 0x3f) << 8;
            reg |= (uint16_t(reg39_reserved1) & 0x3) << 14;
            break;
        case 40:
            reg |= (uint16_t(pll_den_msb) & 0xffff) << 0;
            break;
        case 41:
            reg |= (uint16_t(pll_den_lsb) & 0xffff) << 0;
            break;
        case 42:
            reg |= (uint16_t(mash_seed_msb) & 0xffff) << 0;
            break;
        case 43:
            reg |= (uint16_t(mash_seed_lsb) & 0xffff) << 0;
            break;
        case 44:
            reg |= (uint16_t(pll_num_msb) & 0xffff) << 0;
            break;
        case 45:
            reg |= (uint16_t(pll_num_lsb) & 0xffff) << 0;
            break;
        case 46:
            reg |= (uint16_t(mash_order) & 0x7) << 0;
            reg |= (uint16_t(reg46_reserved0) & 0x7) << 3;
            reg |= (uint16_t(outa_pd) & 0x1) << 6;
            reg |= (uint16_t(outb_pd) & 0x1) << 7;
            reg |= (uint16_t(outa_power) & 0x3f) << 8;
            reg |= (uint16_t(reg46_reserved1) & 0x3) << 14;
            break;
        case 47:
            reg |= (uint16_t(outb_power) & 0x3f) << 0;
            reg |= (uint16_t(reg47_reserved0) & 0x1f) << 6;
            reg |= (uint16_t(outa_mux) & 0x3) << 11;
            reg |= (uint16_t(reg47_reserved1) & 0x7) << 13;
            break;
        case 48:
            reg |= (uint16_t(outb_mux) & 0x3) << 0;
            reg |= (uint16_t(reg48_reserved0) & 0x3fff) << 2;
            break;
        case 59:
            reg |= (uint16_t(reg59_reserved0) & 0x1f) << 0;
            reg |= (uint16_t(muxout_hdrv) & 0x1) << 5;
            reg |= (uint16_t(reg59_reserved1) & 0x3ff) << 6;
            break;
        case 61:
            reg |= (uint16_t(ld_type) & 0x1) << 0;
            reg |= (uint16_t(reg61_reserved0) & 0x7fff) << 1;
            break;
        case 62:
            reg |= (uint16_t(reg62_reserved0) & 0xffff) << 0;
            break;
        case 64:
            reg |= (uint16_t(fjump_size) & 0xf) << 0;
            reg |= (uint16_t(reg64_reserved0) & 0x1) << 4;
            reg |= (uint16_t(ajump_size) & 0x7) << 5;
            reg |= (uint16_t(fcal_fast) & 0x1) << 8;
            reg |= (uint16_t(acal_fast) & 0x1) << 9;
            reg |= (uint16_t(reg64_reserved1) & 0x3f) << 10;
            break;
        }
        return reg;
    }
    
    std::set<size_t> get_all_addrs()
    {
        std::set<size_t> addrs;
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(0);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(1);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(1);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(2);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(4);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(4);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(7);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(8);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(8);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(8);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(8);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(8);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(9);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(9);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(9);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(9);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(9);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(10);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(10);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(10);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(11);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(11);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(11);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(12);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(12);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(13);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(13);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(13);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(13);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(13);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(14);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(14);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(14);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(14);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(19);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(19);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(19);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(20);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(20);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(22);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(22);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(23);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(23);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(23);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(23);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(23);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(24);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(25);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(28);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(29);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(30);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(30);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(30);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(30);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(31);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(32);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(33);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(34);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(34);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(34);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(35);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(36);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(37);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(37);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(37);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(38);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(38);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(38);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(39);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(39);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(39);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(40);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(41);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(42);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(43);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(44);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(45);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(46);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(47);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(47);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(47);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(47);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(48);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(48);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(59);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(59);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(59);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(61);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(61);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(62);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        // Hopefully, compilers will optimize out this mess...
        addrs.insert(64);
        return addrs;
    }

    void save_state(void){
        if (_state == NULL) _state = new lmx2592_regs_t();
        _state->powerdown = this->powerdown;
        _state->reset = this->reset;
        _state->muxout_sel = this->muxout_sel;
        _state->fcal_enable = this->fcal_enable;
        _state->acal_enable = this->acal_enable;
        _state->fcal_lpfd_adj = this->fcal_lpfd_adj;
        _state->fcal_hpfd_adj = this->fcal_hpfd_adj;
        _state->reg0_reserved0 = this->reg0_reserved0;
        _state->ld_enable = this->ld_enable;
        _state->reg0_reserved1 = this->reg0_reserved1;
        _state->cal_clk_div = this->cal_clk_div;
        _state->reg1_reserved0 = this->reg1_reserved0;
        _state->reg2_reserved0 = this->reg2_reserved0;
        _state->reg4_reserved0 = this->reg4_reserved0;
        _state->acal_cmp_delay = this->acal_cmp_delay;
        _state->reg7_reserved0 = this->reg7_reserved0;
        _state->reg8_reserved0 = this->reg8_reserved0;
        _state->vco_capctrl_ovr = this->vco_capctrl_ovr;
        _state->reg8_reserved1 = this->reg8_reserved1;
        _state->vco_idac_ovr = this->vco_idac_ovr;
        _state->reg8_reserved2 = this->reg8_reserved2;
        _state->reg9_reserved0 = this->reg9_reserved0;
        _state->ref_enable = this->ref_enable;
        _state->reg9_reserved1 = this->reg9_reserved1;
        _state->osc_doubler = this->osc_doubler;
        _state->reg9_reserved2 = this->reg9_reserved2;
        _state->reg10_reserved0 = this->reg10_reserved0;
        _state->mult = this->mult;
        _state->reg10_reserved1 = this->reg10_reserved1;
        _state->reg11_reserved0 = this->reg11_reserved0;
        _state->pll_r = this->pll_r;
        _state->reg11_reserved1 = this->reg11_reserved1;
        _state->pll_r_pre = this->pll_r_pre;
        _state->reg12_reserved0 = this->reg12_reserved0;
        _state->reg13_reserved0 = this->reg13_reserved0;
        _state->pfd_ctl = this->pfd_ctl;
        _state->reg13_reserved1 = this->reg13_reserved1;
        _state->cp_enable = this->cp_enable;
        _state->reg13_reserved2 = this->reg13_reserved2;
        _state->cp_icoarse = this->cp_icoarse;
        _state->cp_iup = this->cp_iup;
        _state->cp_idn = this->cp_idn;
        _state->reg14_reserved0 = this->reg14_reserved0;
        _state->reg19_reserved0 = this->reg19_reserved0;
        _state->vco_idac = this->vco_idac;
        _state->reg19_reserved1 = this->reg19_reserved1;
        _state->acal_vco_idac_strt = this->acal_vco_idac_strt;
        _state->reg20_reserved0 = this->reg20_reserved0;
        _state->vco_capctrl = this->vco_capctrl;
        _state->reg22_reserved0 = this->reg22_reserved0;
        _state->reg23_reserved0 = this->reg23_reserved0;
        _state->vco_sel_force = this->vco_sel_force;
        _state->vco_sel = this->vco_sel;
        _state->fcal_vco_sel_strt = this->fcal_vco_sel_strt;
        _state->reg23_reserved1 = this->reg23_reserved1;
        _state->reg24_reserved0 = this->reg24_reserved0;
        _state->reg25_reserved0 = this->reg25_reserved0;
        _state->reg28_reserved0 = this->reg28_reserved0;
        _state->reg29_reserved0 = this->reg29_reserved0;
        _state->vco_doubler_en = this->vco_doubler_en;
        _state->reg30_reserved0 = this->reg30_reserved0;
        _state->mash_ditherer = this->mash_ditherer;
        _state->reg30_reserved1 = this->reg30_reserved1;
        _state->reg31_reserved0 = this->reg31_reserved0;
        _state->chdiv_dist_pd = this->chdiv_dist_pd;
        _state->reg31_reserved1 = this->reg31_reserved1;
        _state->vco_dista_pd = this->vco_dista_pd;
        _state->vco_distb_pd = this->vco_distb_pd;
        _state->reg31_reserved2 = this->reg31_reserved2;
        _state->reg32_reserved0 = this->reg32_reserved0;
        _state->reg33_reserved0 = this->reg33_reserved0;
        _state->reg34_reserved0 = this->reg34_reserved0;
        _state->chdiv_en = this->chdiv_en;
        _state->reg34_reserved1 = this->reg34_reserved1;
        _state->reg35_reserved0 = this->reg35_reserved0;
        _state->chdiv_seg1_en = this->chdiv_seg1_en;
        _state->chdiv_seg1 = this->chdiv_seg1;
        _state->reg35_reserved1 = this->reg35_reserved1;
        _state->chdiv_seg2_en = this->chdiv_seg2_en;
        _state->chdiv_seg3_en = this->chdiv_seg3_en;
        _state->chdiv_seg2 = this->chdiv_seg2;
        _state->reg35_reserved2 = this->reg35_reserved2;
        _state->chdiv_seg3 = this->chdiv_seg3;
        _state->chdiv_seg_sel = this->chdiv_seg_sel;
        _state->reg36_reserved0 = this->reg36_reserved0;
        _state->chdiv_dista_en = this->chdiv_dista_en;
        _state->chdiv_distb_en = this->chdiv_distb_en;
        _state->reg36_reserved1 = this->reg36_reserved1;
        _state->reg37_reserved0 = this->reg37_reserved0;
        _state->pll_n_pre = this->pll_n_pre;
        _state->reg37_reserved1 = this->reg37_reserved1;
        _state->reg38_reserved0 = this->reg38_reserved0;
        _state->pll_n = this->pll_n;
        _state->reg38_reserved1 = this->reg38_reserved1;
        _state->reg39_reserved0 = this->reg39_reserved0;
        _state->pfd_dly = this->pfd_dly;
        _state->reg39_reserved1 = this->reg39_reserved1;
        _state->pll_den_msb = this->pll_den_msb;
        _state->pll_den_lsb = this->pll_den_lsb;
        _state->mash_seed_msb = this->mash_seed_msb;
        _state->mash_seed_lsb = this->mash_seed_lsb;
        _state->pll_num_msb = this->pll_num_msb;
        _state->pll_num_lsb = this->pll_num_lsb;
        _state->mash_order = this->mash_order;
        _state->reg46_reserved0 = this->reg46_reserved0;
        _state->outa_pd = this->outa_pd;
        _state->outb_pd = this->outb_pd;
        _state->outa_power = this->outa_power;
        _state->reg46_reserved1 = this->reg46_reserved1;
        _state->outb_power = this->outb_power;
        _state->reg47_reserved0 = this->reg47_reserved0;
        _state->outa_mux = this->outa_mux;
        _state->reg47_reserved1 = this->reg47_reserved1;
        _state->outb_mux = this->outb_mux;
        _state->reg48_reserved0 = this->reg48_reserved0;
        _state->reg59_reserved0 = this->reg59_reserved0;
        _state->muxout_hdrv = this->muxout_hdrv;
        _state->reg59_reserved1 = this->reg59_reserved1;
        _state->ld_type = this->ld_type;
        _state->reg61_reserved0 = this->reg61_reserved0;
        _state->reg62_reserved0 = this->reg62_reserved0;
        _state->fjump_size = this->fjump_size;
        _state->reg64_reserved0 = this->reg64_reserved0;
        _state->ajump_size = this->ajump_size;
        _state->fcal_fast = this->fcal_fast;
        _state->acal_fast = this->acal_fast;
        _state->reg64_reserved1 = this->reg64_reserved1;
    }

    uint8_t get_state_powerdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->powerdown;
    }

    uint8_t get_state_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reset;
    }

    muxout_sel_t get_state_muxout_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->muxout_sel;
    }

    uint8_t get_state_fcal_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_enable;
    }

    uint8_t get_state_acal_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->acal_enable;
    }

    fcal_lpfd_adj_t get_state_fcal_lpfd_adj(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_lpfd_adj;
    }

    fcal_hpfd_adj_t get_state_fcal_hpfd_adj(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_hpfd_adj;
    }

    uint8_t get_state_reg0_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved0;
    }

    uint8_t get_state_ld_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_enable;
    }

    uint8_t get_state_reg0_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved1;
    }

    uint8_t get_state_cal_clk_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cal_clk_div;
    }

    uint16_t get_state_reg1_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg1_reserved0;
    }

    uint16_t get_state_reg2_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg2_reserved0;
    }

    uint8_t get_state_reg4_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg4_reserved0;
    }

    uint8_t get_state_acal_cmp_delay(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->acal_cmp_delay;
    }

    uint16_t get_state_reg7_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg7_reserved0;
    }

    uint16_t get_state_reg8_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved0;
    }

    uint8_t get_state_vco_capctrl_ovr(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_capctrl_ovr;
    }

    uint8_t get_state_reg8_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved1;
    }

    uint8_t get_state_vco_idac_ovr(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_idac_ovr;
    }

    uint8_t get_state_reg8_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved2;
    }

    uint16_t get_state_reg9_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved0;
    }

    uint8_t get_state_ref_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ref_enable;
    }

    uint8_t get_state_reg9_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved1;
    }

    uint8_t get_state_osc_doubler(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->osc_doubler;
    }

    uint8_t get_state_reg9_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved2;
    }

    uint8_t get_state_reg10_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg10_reserved0;
    }

    uint8_t get_state_mult(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mult;
    }

    uint8_t get_state_reg10_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg10_reserved1;
    }

    uint8_t get_state_reg11_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg11_reserved0;
    }

    uint8_t get_state_pll_r(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_r;
    }

    uint8_t get_state_reg11_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg11_reserved1;
    }

    uint16_t get_state_pll_r_pre(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_r_pre;
    }

    uint8_t get_state_reg12_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg12_reserved0;
    }

    uint8_t get_state_reg13_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg13_reserved0;
    }

    pfd_ctl_t get_state_pfd_ctl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pfd_ctl;
    }

    uint8_t get_state_reg13_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg13_reserved1;
    }

    uint8_t get_state_cp_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_enable;
    }

    uint8_t get_state_reg13_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg13_reserved2;
    }

    cp_icoarse_t get_state_cp_icoarse(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_icoarse;
    }

    uint8_t get_state_cp_iup(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_iup;
    }

    uint8_t get_state_cp_idn(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_idn;
    }

    uint8_t get_state_reg14_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg14_reserved0;
    }

    uint8_t get_state_reg19_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg19_reserved0;
    }

    uint16_t get_state_vco_idac(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_idac;
    }

    uint8_t get_state_reg19_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg19_reserved1;
    }

    uint16_t get_state_acal_vco_idac_strt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->acal_vco_idac_strt;
    }

    uint8_t get_state_reg20_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg20_reserved0;
    }

    uint8_t get_state_vco_capctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_capctrl;
    }

    uint8_t get_state_reg22_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg22_reserved0;
    }

    uint16_t get_state_reg23_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg23_reserved0;
    }

    uint8_t get_state_vco_sel_force(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_sel_force;
    }

    uint8_t get_state_vco_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_sel;
    }

    uint8_t get_state_fcal_vco_sel_strt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_vco_sel_strt;
    }

    uint8_t get_state_reg23_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg23_reserved1;
    }

    uint16_t get_state_reg24_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg24_reserved0;
    }

    uint16_t get_state_reg25_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg25_reserved0;
    }

    uint16_t get_state_reg28_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg28_reserved0;
    }

    uint16_t get_state_reg29_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg29_reserved0;
    }

    uint8_t get_state_vco_doubler_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_doubler_en;
    }

    uint16_t get_state_reg30_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg30_reserved0;
    }

    uint8_t get_state_mash_ditherer(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_ditherer;
    }

    uint8_t get_state_reg30_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg30_reserved1;
    }

    uint8_t get_state_reg31_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg31_reserved0;
    }

    uint8_t get_state_chdiv_dist_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_dist_pd;
    }

    uint8_t get_state_reg31_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg31_reserved1;
    }

    uint8_t get_state_vco_dista_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_dista_pd;
    }

    uint8_t get_state_vco_distb_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_distb_pd;
    }

    uint8_t get_state_reg31_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg31_reserved2;
    }

    uint16_t get_state_reg32_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg32_reserved0;
    }

    uint16_t get_state_reg33_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg33_reserved0;
    }

    uint8_t get_state_reg34_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg34_reserved0;
    }

    uint8_t get_state_chdiv_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_en;
    }

    uint16_t get_state_reg34_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg34_reserved1;
    }

    uint8_t get_state_reg35_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg35_reserved0;
    }

    uint8_t get_state_chdiv_seg1_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg1_en;
    }

    chdiv_seg1_t get_state_chdiv_seg1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg1;
    }

    uint8_t get_state_reg35_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg35_reserved1;
    }

    uint8_t get_state_chdiv_seg2_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg2_en;
    }

    uint8_t get_state_chdiv_seg3_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg3_en;
    }

    chdiv_seg2_t get_state_chdiv_seg2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg2;
    }

    uint8_t get_state_reg35_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg35_reserved2;
    }

    chdiv_seg3_t get_state_chdiv_seg3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg3;
    }

    chdiv_seg_sel_t get_state_chdiv_seg_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_seg_sel;
    }

    uint8_t get_state_reg36_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg36_reserved0;
    }

    uint8_t get_state_chdiv_dista_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_dista_en;
    }

    uint8_t get_state_chdiv_distb_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv_distb_en;
    }

    uint8_t get_state_reg36_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg36_reserved1;
    }

    uint16_t get_state_reg37_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg37_reserved0;
    }

    pll_n_pre_t get_state_pll_n_pre(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_n_pre;
    }

    uint8_t get_state_reg37_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg37_reserved1;
    }

    uint8_t get_state_reg38_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg38_reserved0;
    }

    uint16_t get_state_pll_n(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_n;
    }

    uint8_t get_state_reg38_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg38_reserved1;
    }

    uint8_t get_state_reg39_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg39_reserved0;
    }

    pfd_dly_t get_state_pfd_dly(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pfd_dly;
    }

    uint8_t get_state_reg39_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg39_reserved1;
    }

    uint16_t get_state_pll_den_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_den_msb;
    }

    uint16_t get_state_pll_den_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_den_lsb;
    }

    uint16_t get_state_mash_seed_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_seed_msb;
    }

    uint16_t get_state_mash_seed_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_seed_lsb;
    }

    uint16_t get_state_pll_num_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_num_msb;
    }

    uint16_t get_state_pll_num_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_num_lsb;
    }

    mash_order_t get_state_mash_order(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_order;
    }

    uint8_t get_state_reg46_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg46_reserved0;
    }

    uint8_t get_state_outa_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_pd;
    }

    uint8_t get_state_outb_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_pd;
    }

    uint8_t get_state_outa_power(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_power;
    }

    uint8_t get_state_reg46_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg46_reserved1;
    }

    uint8_t get_state_outb_power(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_power;
    }

    uint8_t get_state_reg47_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg47_reserved0;
    }

    outa_mux_t get_state_outa_mux(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_mux;
    }

    uint8_t get_state_reg47_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg47_reserved1;
    }

    outb_mux_t get_state_outb_mux(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_mux;
    }

    uint16_t get_state_reg48_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg48_reserved0;
    }

    uint8_t get_state_reg59_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg59_reserved0;
    }

    uint8_t get_state_muxout_hdrv(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->muxout_hdrv;
    }

    uint16_t get_state_reg59_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg59_reserved1;
    }

    ld_type_t get_state_ld_type(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_type;
    }

    uint16_t get_state_reg61_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg61_reserved0;
    }

    uint16_t get_state_reg62_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg62_reserved0;
    }

    uint8_t get_state_fjump_size(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fjump_size;
    }

    uint8_t get_state_reg64_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg64_reserved0;
    }

    uint8_t get_state_ajump_size(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ajump_size;
    }

    uint8_t get_state_fcal_fast(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_fast;
    }

    uint8_t get_state_acal_fast(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->acal_fast;
    }

    uint8_t get_state_reg64_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg64_reserved1;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->powerdown != this->powerdown) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reset != this->reset) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->muxout_sel != this->muxout_sel) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_enable != this->fcal_enable) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->acal_enable != this->acal_enable) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_lpfd_adj != this->fcal_lpfd_adj) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_hpfd_adj != this->fcal_hpfd_adj) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved0 != this->reg0_reserved0) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_enable != this->ld_enable) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved1 != this->reg0_reserved1) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->cal_clk_div != this->cal_clk_div) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->reg1_reserved0 != this->reg1_reserved0) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->reg2_reserved0 != this->reg2_reserved0) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->reg4_reserved0 != this->reg4_reserved0) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->acal_cmp_delay != this->acal_cmp_delay) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reg7_reserved0 != this->reg7_reserved0) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved0 != this->reg8_reserved0) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_capctrl_ovr != this->vco_capctrl_ovr) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved1 != this->reg8_reserved1) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_idac_ovr != this->vco_idac_ovr) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved2 != this->reg8_reserved2) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved0 != this->reg9_reserved0) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->ref_enable != this->ref_enable) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved1 != this->reg9_reserved1) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->osc_doubler != this->osc_doubler) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved2 != this->reg9_reserved2) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg10_reserved0 != this->reg10_reserved0) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->mult != this->mult) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg10_reserved1 != this->reg10_reserved1) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg11_reserved0 != this->reg11_reserved0) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_r != this->pll_r) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->reg11_reserved1 != this->reg11_reserved1) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_r_pre != this->pll_r_pre) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->reg12_reserved0 != this->reg12_reserved0) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->reg13_reserved0 != this->reg13_reserved0) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->pfd_ctl != this->pfd_ctl) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->reg13_reserved1 != this->reg13_reserved1) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_enable != this->cp_enable) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->reg13_reserved2 != this->reg13_reserved2) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_icoarse != this->cp_icoarse) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_iup != this->cp_iup) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_idn != this->cp_idn) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->reg14_reserved0 != this->reg14_reserved0) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->reg19_reserved0 != this->reg19_reserved0) {
                addrs.insert(19);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_idac != this->vco_idac) {
                addrs.insert(19);
            }
        }
        if (include_ro || !false) {
            if(_state->reg19_reserved1 != this->reg19_reserved1) {
                addrs.insert(19);
            }
        }
        if (include_ro || !false) {
            if(_state->acal_vco_idac_strt != this->acal_vco_idac_strt) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->reg20_reserved0 != this->reg20_reserved0) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_capctrl != this->vco_capctrl) {
                addrs.insert(22);
            }
        }
        if (include_ro || !false) {
            if(_state->reg22_reserved0 != this->reg22_reserved0) {
                addrs.insert(22);
            }
        }
        if (include_ro || !false) {
            if(_state->reg23_reserved0 != this->reg23_reserved0) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_sel_force != this->vco_sel_force) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_sel != this->vco_sel) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_vco_sel_strt != this->fcal_vco_sel_strt) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->reg23_reserved1 != this->reg23_reserved1) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->reg24_reserved0 != this->reg24_reserved0) {
                addrs.insert(24);
            }
        }
        if (include_ro || !false) {
            if(_state->reg25_reserved0 != this->reg25_reserved0) {
                addrs.insert(25);
            }
        }
        if (include_ro || !false) {
            if(_state->reg28_reserved0 != this->reg28_reserved0) {
                addrs.insert(28);
            }
        }
        if (include_ro || !false) {
            if(_state->reg29_reserved0 != this->reg29_reserved0) {
                addrs.insert(29);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_doubler_en != this->vco_doubler_en) {
                addrs.insert(30);
            }
        }
        if (include_ro || !false) {
            if(_state->reg30_reserved0 != this->reg30_reserved0) {
                addrs.insert(30);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_ditherer != this->mash_ditherer) {
                addrs.insert(30);
            }
        }
        if (include_ro || !false) {
            if(_state->reg30_reserved1 != this->reg30_reserved1) {
                addrs.insert(30);
            }
        }
        if (include_ro || !false) {
            if(_state->reg31_reserved0 != this->reg31_reserved0) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_dist_pd != this->chdiv_dist_pd) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->reg31_reserved1 != this->reg31_reserved1) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_dista_pd != this->vco_dista_pd) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_distb_pd != this->vco_distb_pd) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->reg31_reserved2 != this->reg31_reserved2) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->reg32_reserved0 != this->reg32_reserved0) {
                addrs.insert(32);
            }
        }
        if (include_ro || !false) {
            if(_state->reg33_reserved0 != this->reg33_reserved0) {
                addrs.insert(33);
            }
        }
        if (include_ro || !false) {
            if(_state->reg34_reserved0 != this->reg34_reserved0) {
                addrs.insert(34);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_en != this->chdiv_en) {
                addrs.insert(34);
            }
        }
        if (include_ro || !false) {
            if(_state->reg34_reserved1 != this->reg34_reserved1) {
                addrs.insert(34);
            }
        }
        if (include_ro || !false) {
            if(_state->reg35_reserved0 != this->reg35_reserved0) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg1_en != this->chdiv_seg1_en) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg1 != this->chdiv_seg1) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->reg35_reserved1 != this->reg35_reserved1) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg2_en != this->chdiv_seg2_en) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg3_en != this->chdiv_seg3_en) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg2 != this->chdiv_seg2) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->reg35_reserved2 != this->reg35_reserved2) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg3 != this->chdiv_seg3) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_seg_sel != this->chdiv_seg_sel) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->reg36_reserved0 != this->reg36_reserved0) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_dista_en != this->chdiv_dista_en) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv_distb_en != this->chdiv_distb_en) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->reg36_reserved1 != this->reg36_reserved1) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->reg37_reserved0 != this->reg37_reserved0) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_n_pre != this->pll_n_pre) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->reg37_reserved1 != this->reg37_reserved1) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->reg38_reserved0 != this->reg38_reserved0) {
                addrs.insert(38);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_n != this->pll_n) {
                addrs.insert(38);
            }
        }
        if (include_ro || !false) {
            if(_state->reg38_reserved1 != this->reg38_reserved1) {
                addrs.insert(38);
            }
        }
        if (include_ro || !false) {
            if(_state->reg39_reserved0 != this->reg39_reserved0) {
                addrs.insert(39);
            }
        }
        if (include_ro || !false) {
            if(_state->pfd_dly != this->pfd_dly) {
                addrs.insert(39);
            }
        }
        if (include_ro || !false) {
            if(_state->reg39_reserved1 != this->reg39_reserved1) {
                addrs.insert(39);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_den_msb != this->pll_den_msb) {
                addrs.insert(40);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_den_lsb != this->pll_den_lsb) {
                addrs.insert(41);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_seed_msb != this->mash_seed_msb) {
                addrs.insert(42);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_seed_lsb != this->mash_seed_lsb) {
                addrs.insert(43);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_num_msb != this->pll_num_msb) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_num_lsb != this->pll_num_lsb) {
                addrs.insert(45);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_order != this->mash_order) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->reg46_reserved0 != this->reg46_reserved0) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_pd != this->outa_pd) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_pd != this->outb_pd) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_power != this->outa_power) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->reg46_reserved1 != this->reg46_reserved1) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_power != this->outb_power) {
                addrs.insert(47);
            }
        }
        if (include_ro || !false) {
            if(_state->reg47_reserved0 != this->reg47_reserved0) {
                addrs.insert(47);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_mux != this->outa_mux) {
                addrs.insert(47);
            }
        }
        if (include_ro || !false) {
            if(_state->reg47_reserved1 != this->reg47_reserved1) {
                addrs.insert(47);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_mux != this->outb_mux) {
                addrs.insert(48);
            }
        }
        if (include_ro || !false) {
            if(_state->reg48_reserved0 != this->reg48_reserved0) {
                addrs.insert(48);
            }
        }
        if (include_ro || !false) {
            if(_state->reg59_reserved0 != this->reg59_reserved0) {
                addrs.insert(59);
            }
        }
        if (include_ro || !false) {
            if(_state->muxout_hdrv != this->muxout_hdrv) {
                addrs.insert(59);
            }
        }
        if (include_ro || !false) {
            if(_state->reg59_reserved1 != this->reg59_reserved1) {
                addrs.insert(59);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_type != this->ld_type) {
                addrs.insert(61);
            }
        }
        if (include_ro || !false) {
            if(_state->reg61_reserved0 != this->reg61_reserved0) {
                addrs.insert(61);
            }
        }
        if (include_ro || !false) {
            if(_state->reg62_reserved0 != this->reg62_reserved0) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->fjump_size != this->fjump_size) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->reg64_reserved0 != this->reg64_reserved0) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->ajump_size != this->ajump_size) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_fast != this->fcal_fast) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->acal_fast != this->acal_fast) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->reg64_reserved1 != this->reg64_reserved1) {
                addrs.insert(64);
            }
        }
        return addrs;
    }

private:
    lmx2592_regs_t *_state;
};

#endif /* INCLUDED_LMX2592_REGS_HPP */
