/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 8),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 17,
  Feature_HasMips4_32Bit = 27,
  Feature_NotMips4_32Bit = 28,
  Feature_HasMips4_32r2Bit = 18,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 29,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 22,
  Feature_IsPTR64bitBit = 24,
  Feature_HasMips64Bit = 25,
  Feature_HasMips64r2Bit = 23,
  Feature_HasMips64r6Bit = 30,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 31,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 26,
  Feature_NotCnMipsBit = 8,
  Feature_IsSym32Bit = 38,
  Feature_IsSym64Bit = 39,
  Feature_IsN64Bit = 40,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 37,
  Feature_NoNaNsFPMathBit = 21,
  Feature_UseAbsBit = 14,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 35,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 42,
  Feature_IsBEBit = 43,
  Feature_IsNotNaClBit = 19,
  Feature_HasEVABit = 36,
  Feature_HasMSABit = 34,
  Feature_HasMadd4Bit = 20,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 41,
  Feature_IsFP64bitBit = 16,
  Feature_NotFP64bitBit = 15,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 32,
  Feature_HasDSPR2Bit = 33,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasMips2())
    Features.set(Feature_HasMips2Bit);
  if (Subtarget->hasMips3())
    Features.set(Feature_HasMips3Bit);
  if (Subtarget->hasMips4_32())
    Features.set(Feature_HasMips4_32Bit);
  if (!Subtarget->hasMips4_32())
    Features.set(Feature_NotMips4_32Bit);
  if (Subtarget->hasMips4_32r2())
    Features.set(Feature_HasMips4_32r2Bit);
  if (Subtarget->hasMips32())
    Features.set(Feature_HasMips32Bit);
  if (Subtarget->hasMips32r2())
    Features.set(Feature_HasMips32r2Bit);
  if (Subtarget->hasMips32r6())
    Features.set(Feature_HasMips32r6Bit);
  if (!Subtarget->hasMips32r6())
    Features.set(Feature_NotMips32r6Bit);
  if (Subtarget->isGP64bit())
    Features.set(Feature_IsGP64bitBit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsPTR64bitBit);
  if (Subtarget->hasMips64())
    Features.set(Feature_HasMips64Bit);
  if (Subtarget->hasMips64r2())
    Features.set(Feature_HasMips64r2Bit);
  if (Subtarget->hasMips64r6())
    Features.set(Feature_HasMips64r6Bit);
  if (!Subtarget->hasMips64r6())
    Features.set(Feature_NotMips64r6Bit);
  if (Subtarget->inMips16Mode())
    Features.set(Feature_InMips16ModeBit);
  if (!Subtarget->inMips16Mode())
    Features.set(Feature_NotInMips16ModeBit);
  if (Subtarget->hasCnMips())
    Features.set(Feature_HasCnMipsBit);
  if (!Subtarget->hasCnMips())
    Features.set(Feature_NotCnMipsBit);
  if (Subtarget->hasSym32())
    Features.set(Feature_IsSym32Bit);
  if (!Subtarget->hasSym32())
    Features.set(Feature_IsSym64Bit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsN64Bit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_RelocNotPICBit);
  if (TM.isPositionIndependent())
    Features.set(Feature_RelocPICBit);
  if (TM.Options.NoNaNsFPMath)
    Features.set(Feature_NoNaNsFPMathBit);
  if (Subtarget->inAbs2008Mode() ||TM.Options.NoNaNsFPMath)
    Features.set(Feature_UseAbsBit);
  if (Subtarget->hasStandardEncoding())
    Features.set(Feature_HasStdEncBit);
  if (!Subtarget->hasDSP())
    Features.set(Feature_NotDSPBit);
  if (Subtarget->inMicroMipsMode())
    Features.set(Feature_InMicroMipsBit);
  if (!Subtarget->inMicroMipsMode())
    Features.set(Feature_NotInMicroMipsBit);
  if (Subtarget->isLittle())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittle())
    Features.set(Feature_IsBEBit);
  if (!Subtarget->isTargetNaCl())
    Features.set(Feature_IsNotNaClBit);
  if (Subtarget->hasEVA())
    Features.set(Feature_HasEVABit);
  if (Subtarget->hasMSA())
    Features.set(Feature_HasMSABit);
  if (!Subtarget->disableMadd4())
    Features.set(Feature_HasMadd4Bit);
  if (Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_UseIndirectJumpsHazardBit);
  if (!Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_NoIndirectJumpGuardsBit);
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features.set(Feature_AllowFPOpFusionBit);
  if (Subtarget->isFP64bit())
    Features.set(Feature_IsFP64bitBit);
  if (!Subtarget->isFP64bit())
    Features.set(Feature_NotFP64bitBit);
  if (!Subtarget->useSoftFloat())
    Features.set(Feature_IsNotSoftFloatBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDSPR2())
    Features.set(Feature_HasDSPR2Bit);
  return Features;
}

void MipsInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const MipsSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat_UseAbs,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode,
  GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips64r6,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_UseAbs,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_UseAbsBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMips16ModeBit, },
  {Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_immLi16 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_immSExt6,
  GICXXPred_I64_Predicate_immSExt10,
  GICXXPred_I64_Predicate_immSExtAddiur2,
  GICXXPred_I64_Predicate_immSExtAddius5,
  GICXXPred_I64_Predicate_immZExt1,
  GICXXPred_I64_Predicate_immZExt1Ptr,
  GICXXPred_I64_Predicate_immZExt2,
  GICXXPred_I64_Predicate_immZExt2Lsa,
  GICXXPred_I64_Predicate_immZExt2Ptr,
  GICXXPred_I64_Predicate_immZExt2Shift,
  GICXXPred_I64_Predicate_immZExt3,
  GICXXPred_I64_Predicate_immZExt3Ptr,
  GICXXPred_I64_Predicate_immZExt4,
  GICXXPred_I64_Predicate_immZExt4Ptr,
  GICXXPred_I64_Predicate_immZExt5,
  GICXXPred_I64_Predicate_immZExt5_64,
  GICXXPred_I64_Predicate_immZExt6,
  GICXXPred_I64_Predicate_immZExt8,
  GICXXPred_I64_Predicate_immZExt10,
  GICXXPred_I64_Predicate_immZExtAndi16,
  GICXXPred_I64_Predicate_immi32Cst7,
  GICXXPred_I64_Predicate_immi32Cst15,
  GICXXPred_I64_Predicate_immi32Cst31,
  GICXXPred_I64_Predicate_timmSExt6,
  GICXXPred_I64_Predicate_timmZExt1,
  GICXXPred_I64_Predicate_timmZExt1Ptr,
  GICXXPred_I64_Predicate_timmZExt2,
  GICXXPred_I64_Predicate_timmZExt2Ptr,
  GICXXPred_I64_Predicate_timmZExt3,
  GICXXPred_I64_Predicate_timmZExt3Ptr,
  GICXXPred_I64_Predicate_timmZExt4,
  GICXXPred_I64_Predicate_timmZExt4Ptr,
  GICXXPred_I64_Predicate_timmZExt5,
  GICXXPred_I64_Predicate_timmZExt6,
  GICXXPred_I64_Predicate_timmZExt8,
  GICXXPred_I64_Predicate_timmZExt10,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
  }
  case GICXXPred_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                               ((Imm % 4 == 0) &&
                                                Imm < 28 && Imm > 0);
  }
  case GICXXPred_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
  }
  case GICXXPred_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
  }
  case GICXXPred_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
  }
  case GICXXPred_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
  }
  case GICXXPred_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
                Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
                Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
  }
  case GICXXPred_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
  }
  case GICXXPred_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
  }
  case GICXXPred_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
  }
  case GICXXPred_I64_Predicate_timmSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_timmZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_timmZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt10: {
    return isUInt<10>(Imm);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_imm32SExt16 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_imm32ZExt16,
};
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_imm32SExt16: {
     return isInt<16>(Imm.getSExtValue()); 
  }
  case GICXXPred_APInt_Predicate_imm32ZExt16: {
    
      return (uint32_t)Imm.getZExtValue() == (unsigned short)Imm.getZExtValue();
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("MipsInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool MipsInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("MipsInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(274), /*)*//*default:*//*Label 64*/ GIMT_Encode4(66615),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(902),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(2200),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(2891),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(3372),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(3641),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(3910),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(4179), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(4448),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5004),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(5408), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_MERGE_VALUES*//*Label 10*/ GIMT_Encode4(6300),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 11*/ GIMT_Encode4(6373), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 12*/ GIMT_Encode4(6714), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_LOAD*//*Label 13*/ GIMT_Encode4(10905),
    /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ GIMT_Encode4(10970),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ GIMT_Encode4(11038), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BRCOND*//*Label 16*/ GIMT_Encode4(11106), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 17*/ GIMT_Encode4(15827),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 18*/ GIMT_Encode4(30092), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 19*/ GIMT_Encode4(34750),
    /*TargetOpcode::G_TRUNC*//*Label 20*/ GIMT_Encode4(34816),
    /*TargetOpcode::G_CONSTANT*//*Label 21*/ GIMT_Encode4(34880), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 22*/ GIMT_Encode4(34941), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 23*/ GIMT_Encode4(36405),
    /*TargetOpcode::G_SHL*//*Label 24*/ GIMT_Encode4(36606),
    /*TargetOpcode::G_LSHR*//*Label 25*/ GIMT_Encode4(38403),
    /*TargetOpcode::G_ASHR*//*Label 26*/ GIMT_Encode4(40200), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 27*/ GIMT_Encode4(41955), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 28*/ GIMT_Encode4(42243),
    /*TargetOpcode::G_FCMP*//*Label 29*/ GIMT_Encode4(44774), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 30*/ GIMT_Encode4(46480), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 31*/ GIMT_Encode4(58518),
    /*TargetOpcode::G_SMULH*//*Label 32*/ GIMT_Encode4(58627), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 33*/ GIMT_Encode4(58736),
    /*TargetOpcode::G_FSUB*//*Label 34*/ GIMT_Encode4(59649),
    /*TargetOpcode::G_FMUL*//*Label 35*/ GIMT_Encode4(60261),
    /*TargetOpcode::G_FMA*//*Label 36*/ GIMT_Encode4(60748), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 37*/ GIMT_Encode4(60854), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FEXP2*//*Label 38*/ GIMT_Encode4(61153), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FLOG2*//*Label 39*/ GIMT_Encode4(61231), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 40*/ GIMT_Encode4(61309),
    /*TargetOpcode::G_FPEXT*//*Label 41*/ GIMT_Encode4(62678),
    /*TargetOpcode::G_FPTRUNC*//*Label 42*/ GIMT_Encode4(62856),
    /*TargetOpcode::G_FPTOSI*//*Label 43*/ GIMT_Encode4(63019),
    /*TargetOpcode::G_FPTOUI*//*Label 44*/ GIMT_Encode4(63097),
    /*TargetOpcode::G_SITOFP*//*Label 45*/ GIMT_Encode4(63175),
    /*TargetOpcode::G_UITOFP*//*Label 46*/ GIMT_Encode4(63428),
    /*TargetOpcode::G_FABS*//*Label 47*/ GIMT_Encode4(63506), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FCANONICALIZE*//*Label 48*/ GIMT_Encode4(63746), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 49*/ GIMT_Encode4(63820),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 50*/ GIMT_Encode4(63892), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 51*/ GIMT_Encode4(63964),
    /*TargetOpcode::G_SMAX*//*Label 52*/ GIMT_Encode4(64132),
    /*TargetOpcode::G_UMIN*//*Label 53*/ GIMT_Encode4(64300),
    /*TargetOpcode::G_UMAX*//*Label 54*/ GIMT_Encode4(64468), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 55*/ GIMT_Encode4(64636), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 56*/ GIMT_Encode4(64760),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 57*/ GIMT_Encode4(65324), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 58*/ GIMT_Encode4(65376), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 59*/ GIMT_Encode4(65881),
    /*TargetOpcode::G_BSWAP*//*Label 60*/ GIMT_Encode4(66087), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 61*/ GIMT_Encode4(66251), GIMT_Encode4(0),
    /*TargetOpcode::G_FRINT*//*Label 62*/ GIMT_Encode4(66491), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 63*/ GIMT_Encode4(66569),
    // Label 0: @902
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 73*/ GIMT_Encode4(2199),
    /*GILLT_s32*//*Label 65*/ GIMT_Encode4(945),
    /*GILLT_s64*//*Label 66*/ GIMT_Encode4(1353),
    /*GILLT_v2s16*//*Label 67*/ GIMT_Encode4(1519),
    /*GILLT_v2s64*//*Label 68*/ GIMT_Encode4(1551),
    /*GILLT_v4s8*//*Label 69*/ GIMT_Encode4(1705),
    /*GILLT_v4s32*//*Label 70*/ GIMT_Encode4(1737),
    /*GILLT_v8s16*//*Label 71*/ GIMT_Encode4(1891),
    /*GILLT_v16s8*//*Label 72*/ GIMT_Encode4(2045),
    // Label 65: @945
    GIM_Try, /*On fail goto*//*Label 74*/ GIMT_Encode4(1352),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 75*/ GIMT_Encode4(1023), // Rule ID 2372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2372,
        GIR_EraseRootFromParent_Done,
      // Label 75: @1023
      GIM_Try, /*On fail goto*//*Label 76*/ GIMT_Encode4(1090), // Rule ID 834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 834,
        GIR_EraseRootFromParent_Done,
      // Label 76: @1090
      GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(1132), // Rule ID 40 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm16)  =>  (ADDiu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDiu),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 40,
        GIR_EraseRootFromParent_Done,
      // Label 77: @1132
      GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(1174), // Rule ID 2141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddiur2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUR2_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2141,
        GIR_EraseRootFromParent_Done,
      // Label 78: @1174
      GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(1216), // Rule ID 2142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddius5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUS5_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2142,
        GIR_EraseRootFromParent_Done,
      // Label 79: @1216
      GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(1243), // Rule ID 1208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 80: @1243
      GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1270), // Rule ID 46 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 81: @1270
      GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1297), // Rule ID 1060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 82: @1297
      GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1324), // Rule ID 1072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 83: @1324
      GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1351), // Rule ID 1801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AdduRxRyRz16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1801,
        GIR_Done,
      // Label 84: @1351
      GIM_Reject,
    // Label 74: @1352
    GIM_Reject,
    // Label 66: @1353
    GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1518),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1431), // Rule ID 2373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2373,
        GIR_EraseRootFromParent_Done,
      // Label 86: @1431
      GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1494), // Rule ID 835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 835,
        GIR_EraseRootFromParent_Done,
      // Label 87: @1494
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1517), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DADDu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 88: @1517
      GIM_Reject,
    // Label 85: @1518
    GIM_Reject,
    // Label 67: @1519
    GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1550), // Rule ID 1900 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1900,
      GIR_Done,
    // Label 89: @1550
    GIM_Reject,
    // Label 68: @1551
    GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1704),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1623), // Rule ID 2377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2377,
        GIR_EraseRootFromParent_Done,
      // Label 91: @1623
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1680), // Rule ID 843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 843,
        GIR_EraseRootFromParent_Done,
      // Label 92: @1680
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1703), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_D),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 93: @1703
      GIM_Reject,
    // Label 90: @1704
    GIM_Reject,
    // Label 69: @1705
    GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1736), // Rule ID 1906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1906,
      GIR_Done,
    // Label 94: @1736
    GIM_Reject,
    // Label 70: @1737
    GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1890),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1809), // Rule ID 2376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2376,
        GIR_EraseRootFromParent_Done,
      // Label 96: @1809
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1866), // Rule ID 842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 842,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1866
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1889), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_W),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 98: @1889
      GIM_Reject,
    // Label 95: @1890
    GIM_Reject,
    // Label 71: @1891
    GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(2044),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1963), // Rule ID 2375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2375,
        GIR_EraseRootFromParent_Done,
      // Label 100: @1963
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2020), // Rule ID 841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 841,
        GIR_EraseRootFromParent_Done,
      // Label 101: @2020
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2043), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_H),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 102: @2043
      GIM_Reject,
    // Label 99: @2044
    GIM_Reject,
    // Label 72: @2045
    GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(2198),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(2117), // Rule ID 2374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2374,
        GIR_EraseRootFromParent_Done,
      // Label 104: @2117
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2174), // Rule ID 840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 840,
        GIR_EraseRootFromParent_Done,
      // Label 105: @2174
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2197), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_B),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 106: @2197
      GIM_Reject,
    // Label 103: @2198
    GIM_Reject,
    // Label 73: @2199
    GIM_Reject,
    // Label 1: @2200
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 115*/ GIMT_Encode4(2890),
    /*GILLT_s32*//*Label 107*/ GIMT_Encode4(2243),
    /*GILLT_s64*//*Label 108*/ GIMT_Encode4(2420),
    /*GILLT_v2s16*//*Label 109*/ GIMT_Encode4(2454),
    /*GILLT_v2s64*//*Label 110*/ GIMT_Encode4(2486),
    /*GILLT_v4s8*//*Label 111*/ GIMT_Encode4(2579),
    /*GILLT_v4s32*//*Label 112*/ GIMT_Encode4(2611),
    /*GILLT_v8s16*//*Label 113*/ GIMT_Encode4(2704),
    /*GILLT_v16s8*//*Label 114*/ GIMT_Encode4(2797),
    // Label 107: @2243
    GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2419),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2283), // Rule ID 1800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NegRxRy16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_RootToRootCopy, /*OpIdx*/2, // r
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1800,
        GIR_EraseRootFromParent_Done,
      // Label 117: @2283
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2310), // Rule ID 1210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 118: @2310
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2337), // Rule ID 47 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 47,
        GIR_Done,
      // Label 119: @2337
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2364), // Rule ID 1064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 120: @2364
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2391), // Rule ID 1073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 121: @2391
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2418), // Rule ID 1805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SubuRxRyRz16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1805,
        GIR_Done,
      // Label 122: @2418
      GIM_Reject,
    // Label 116: @2419
    GIM_Reject,
    // Label 108: @2420
    GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2453), // Rule ID 203 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSUBu),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 203,
      GIR_Done,
    // Label 123: @2453
    GIM_Reject,
    // Label 109: @2454
    GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2485), // Rule ID 1902 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1902,
      GIR_Done,
    // Label 124: @2485
    GIM_Reject,
    // Label 110: @2486
    GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2578),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2558), // Rule ID 899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 899,
        GIR_EraseRootFromParent_Done,
      // Label 126: @2558
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2577), // Rule ID 1028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_D),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1028,
        GIR_Done,
      // Label 127: @2577
      GIM_Reject,
    // Label 125: @2578
    GIM_Reject,
    // Label 111: @2579
    GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2610), // Rule ID 1908 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1908,
      GIR_Done,
    // Label 128: @2610
    GIM_Reject,
    // Label 112: @2611
    GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2703),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2683), // Rule ID 898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 898,
        GIR_EraseRootFromParent_Done,
      // Label 130: @2683
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2702), // Rule ID 1027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_W),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1027,
        GIR_Done,
      // Label 131: @2702
      GIM_Reject,
    // Label 129: @2703
    GIM_Reject,
    // Label 113: @2704
    GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2796),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2776), // Rule ID 897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 897,
        GIR_EraseRootFromParent_Done,
      // Label 133: @2776
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2795), // Rule ID 1026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_H),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1026,
        GIR_Done,
      // Label 134: @2795
      GIM_Reject,
    // Label 132: @2796
    GIM_Reject,
    // Label 114: @2797
    GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2889),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2869), // Rule ID 896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 896,
        GIR_EraseRootFromParent_Done,
      // Label 136: @2869
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2888), // Rule ID 1025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_B),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1025,
        GIR_Done,
      // Label 137: @2888
      GIM_Reject,
    // Label 135: @2889
    GIM_Reject,
    // Label 115: @2890
    GIM_Reject,
    // Label 2: @2891
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 145*/ GIMT_Encode4(3371),
    /*GILLT_s32*//*Label 138*/ GIMT_Encode4(2934),
    /*GILLT_s64*//*Label 139*/ GIMT_Encode4(3118),
    /*GILLT_v2s16*//*Label 140*/ GIMT_Encode4(3203),
    /*GILLT_v2s64*//*Label 141*/ GIMT_Encode4(3235), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 142*/ GIMT_Encode4(3269),
    /*GILLT_v8s16*//*Label 143*/ GIMT_Encode4(3303),
    /*GILLT_v16s8*//*Label 144*/ GIMT_Encode4(3337),
    // Label 138: @2934
    GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(3117),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2984), // Rule ID 48 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 147: @2984
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3011), // Rule ID 332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 148: @3011
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3050), // Rule ID 1074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MM),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 149: @3050
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(3077), // Rule ID 1179 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1179,
        GIR_Done,
      // Label 150: @3077
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3116), // Rule ID 1803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MultRxRyRz16),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1803,
        GIR_Done,
      // Label 151: @3116
      GIM_Reject,
    // Label 146: @3117
    GIM_Reject,
    // Label 139: @3118
    GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(3202),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3186), // Rule ID 274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P1), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P2), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 153: @3186
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3201), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL_R6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 154: @3201
      GIM_Reject,
    // Label 152: @3202
    GIM_Reject,
    // Label 140: @3203
    GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3234), // Rule ID 1904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag21), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1904,
      GIR_Done,
    // Label 155: @3234
    GIM_Reject,
    // Label 141: @3235
    GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3268), // Rule ID 907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 156: @3268
    GIM_Reject,
    // Label 142: @3269
    GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3302), // Rule ID 906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 157: @3302
    GIM_Reject,
    // Label 143: @3303
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3336), // Rule ID 905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 905,
      GIR_Done,
    // Label 158: @3336
    GIM_Reject,
    // Label 144: @3337
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3370), // Rule ID 904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 904,
      GIR_Done,
    // Label 159: @3370
    GIM_Reject,
    // Label 145: @3371
    GIM_Reject,
    // Label 3: @3372
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 166*/ GIMT_Encode4(3640),
    /*GILLT_s32*//*Label 160*/ GIMT_Encode4(3415),
    /*GILLT_s64*//*Label 161*/ GIMT_Encode4(3470), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 162*/ GIMT_Encode4(3504), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 163*/ GIMT_Encode4(3538),
    /*GILLT_v8s16*//*Label 164*/ GIMT_Encode4(3572),
    /*GILLT_v16s8*//*Label 165*/ GIMT_Encode4(3606),
    // Label 160: @3415
    GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3469),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3453), // Rule ID 326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 168: @3453
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(3468), // Rule ID 1172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1172,
        GIR_Done,
      // Label 169: @3468
      GIM_Reject,
    // Label 167: @3469
    GIM_Reject,
    // Label 161: @3470
    GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(3503), // Rule ID 341 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIV),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 341,
      GIR_Done,
    // Label 170: @3503
    GIM_Reject,
    // Label 162: @3504
    GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(3537), // Rule ID 647 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 647,
      GIR_Done,
    // Label 171: @3537
    GIM_Reject,
    // Label 163: @3538
    GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(3571), // Rule ID 646 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 646,
      GIR_Done,
    // Label 172: @3571
    GIM_Reject,
    // Label 164: @3572
    GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(3605), // Rule ID 645 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 645,
      GIR_Done,
    // Label 173: @3605
    GIM_Reject,
    // Label 165: @3606
    GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(3639), // Rule ID 644 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 644,
      GIR_Done,
    // Label 174: @3639
    GIM_Reject,
    // Label 166: @3640
    GIM_Reject,
    // Label 4: @3641
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 181*/ GIMT_Encode4(3909),
    /*GILLT_s32*//*Label 175*/ GIMT_Encode4(3684),
    /*GILLT_s64*//*Label 176*/ GIMT_Encode4(3739), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 177*/ GIMT_Encode4(3773), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 178*/ GIMT_Encode4(3807),
    /*GILLT_v8s16*//*Label 179*/ GIMT_Encode4(3841),
    /*GILLT_v16s8*//*Label 180*/ GIMT_Encode4(3875),
    // Label 175: @3684
    GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3738),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3722), // Rule ID 327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 183: @3722
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3737), // Rule ID 1173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1173,
        GIR_Done,
      // Label 184: @3737
      GIM_Reject,
    // Label 182: @3738
    GIM_Reject,
    // Label 176: @3739
    GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3772), // Rule ID 342 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIVU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 342,
      GIR_Done,
    // Label 185: @3772
    GIM_Reject,
    // Label 177: @3773
    GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3806), // Rule ID 651 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 651,
      GIR_Done,
    // Label 186: @3806
    GIM_Reject,
    // Label 178: @3807
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3840), // Rule ID 650 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 650,
      GIR_Done,
    // Label 187: @3840
    GIM_Reject,
    // Label 179: @3841
    GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3874), // Rule ID 649 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 649,
      GIR_Done,
    // Label 188: @3874
    GIM_Reject,
    // Label 180: @3875
    GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3908), // Rule ID 648 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 648,
      GIR_Done,
    // Label 189: @3908
    GIM_Reject,
    // Label 181: @3909
    GIM_Reject,
    // Label 5: @3910
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 196*/ GIMT_Encode4(4178),
    /*GILLT_s32*//*Label 190*/ GIMT_Encode4(3953),
    /*GILLT_s64*//*Label 191*/ GIMT_Encode4(4008), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 192*/ GIMT_Encode4(4042), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 193*/ GIMT_Encode4(4076),
    /*GILLT_v8s16*//*Label 194*/ GIMT_Encode4(4110),
    /*GILLT_v16s8*//*Label 195*/ GIMT_Encode4(4144),
    // Label 190: @3953
    GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(4007),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3991), // Rule ID 328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 198: @3991
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(4006), // Rule ID 1177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1177,
        GIR_Done,
      // Label 199: @4006
      GIM_Reject,
    // Label 197: @4007
    GIM_Reject,
    // Label 191: @4008
    GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(4041), // Rule ID 343 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMOD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 343,
      GIR_Done,
    // Label 200: @4041
    GIM_Reject,
    // Label 192: @4042
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(4075), // Rule ID 887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 887,
      GIR_Done,
    // Label 201: @4075
    GIM_Reject,
    // Label 193: @4076
    GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(4109), // Rule ID 886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 886,
      GIR_Done,
    // Label 202: @4109
    GIM_Reject,
    // Label 194: @4110
    GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(4143), // Rule ID 885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 885,
      GIR_Done,
    // Label 203: @4143
    GIM_Reject,
    // Label 195: @4144
    GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(4177), // Rule ID 884 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 884,
      GIR_Done,
    // Label 204: @4177
    GIM_Reject,
    // Label 196: @4178
    GIM_Reject,
    // Label 6: @4179
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 211*/ GIMT_Encode4(4447),
    /*GILLT_s32*//*Label 205*/ GIMT_Encode4(4222),
    /*GILLT_s64*//*Label 206*/ GIMT_Encode4(4277), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 207*/ GIMT_Encode4(4311), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 208*/ GIMT_Encode4(4345),
    /*GILLT_v8s16*//*Label 209*/ GIMT_Encode4(4379),
    /*GILLT_v16s8*//*Label 210*/ GIMT_Encode4(4413),
    // Label 205: @4222
    GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4260), // Rule ID 329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 213: @4260
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4275), // Rule ID 1178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1178,
        GIR_Done,
      // Label 214: @4275
      GIM_Reject,
    // Label 212: @4276
    GIM_Reject,
    // Label 206: @4277
    GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4310), // Rule ID 344 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMODU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 344,
      GIR_Done,
    // Label 215: @4310
    GIM_Reject,
    // Label 207: @4311
    GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4344), // Rule ID 891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 891,
      GIR_Done,
    // Label 216: @4344
    GIM_Reject,
    // Label 208: @4345
    GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4378), // Rule ID 890 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_W),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 890,
      GIR_Done,
    // Label 217: @4378
    GIM_Reject,
    // Label 209: @4379
    GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(4412), // Rule ID 889 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 889,
      GIR_Done,
    // Label 218: @4412
    GIM_Reject,
    // Label 210: @4413
    GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(4446), // Rule ID 888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 888,
      GIR_Done,
    // Label 219: @4446
    GIM_Reject,
    // Label 211: @4447
    GIM_Reject,
    // Label 7: @4448
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 226*/ GIMT_Encode4(5003),
    /*GILLT_s32*//*Label 220*/ GIMT_Encode4(4491),
    /*GILLT_s64*//*Label 221*/ GIMT_Encode4(4765), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 222*/ GIMT_Encode4(4867), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 223*/ GIMT_Encode4(4901),
    /*GILLT_v8s16*//*Label 224*/ GIMT_Encode4(4935),
    /*GILLT_v16s8*//*Label 225*/ GIMT_Encode4(4969),
    // Label 220: @4491
    GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4764),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4544), // Rule ID 41 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ANDi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 41,
        GIR_EraseRootFromParent_Done,
      // Label 228: @4544
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4586), // Rule ID 2144 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2144,
        GIR_EraseRootFromParent_Done,
      // Label 229: @4586
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4628), // Rule ID 2303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2303,
        GIR_EraseRootFromParent_Done,
      // Label 230: @4628
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4655), // Rule ID 51 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 51,
        GIR_Done,
      // Label 231: @4655
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4682), // Rule ID 1061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 232: @4682
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4709), // Rule ID 1077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 233: @4709
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4736), // Rule ID 1170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1170,
        GIR_Done,
      // Label 234: @4736
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4763), // Rule ID 1802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AndRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1802,
        GIR_Done,
      // Label 235: @4763
      GIM_Reject,
    // Label 227: @4764
    GIM_Reject,
    // Label 221: @4765
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4866),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(4842), // Rule ID 269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BADDu),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 269,
        GIR_EraseRootFromParent_Done,
      // Label 237: @4842
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(4865), // Rule ID 206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 238: @4865
      GIM_Reject,
    // Label 236: @4866
    GIM_Reject,
    // Label 222: @4867
    GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(4900), // Rule ID 518 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 518,
      GIR_Done,
    // Label 239: @4900
    GIM_Reject,
    // Label 223: @4901
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(4934), // Rule ID 517 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 517,
      GIR_Done,
    // Label 240: @4934
    GIM_Reject,
    // Label 224: @4935
    GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(4968), // Rule ID 516 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 516,
      GIR_Done,
    // Label 241: @4968
    GIM_Reject,
    // Label 225: @4969
    GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(5002), // Rule ID 515 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 515,
      GIR_Done,
    // Label 242: @5002
    GIM_Reject,
    // Label 226: @5003
    GIM_Reject,
    // Label 8: @5004
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 249*/ GIMT_Encode4(5407),
    /*GILLT_s32*//*Label 243*/ GIMT_Encode4(5047),
    /*GILLT_s64*//*Label 244*/ GIMT_Encode4(5237), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 245*/ GIMT_Encode4(5271), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 246*/ GIMT_Encode4(5305),
    /*GILLT_v8s16*//*Label 247*/ GIMT_Encode4(5339),
    /*GILLT_v16s8*//*Label 248*/ GIMT_Encode4(5373),
    // Label 243: @5047
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(5236),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(5100), // Rule ID 42 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ORi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 42,
        GIR_EraseRootFromParent_Done,
      // Label 251: @5100
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5127), // Rule ID 52 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 252: @5127
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5154), // Rule ID 1063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 253: @5154
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5181), // Rule ID 1078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 254: @5181
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5208), // Rule ID 1183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1183,
        GIR_Done,
      // Label 255: @5208
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5235), // Rule ID 1804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OrRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1804,
        GIR_Done,
      // Label 256: @5235
      GIM_Reject,
    // Label 250: @5236
    GIM_Reject,
    // Label 244: @5237
    GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5270), // Rule ID 207 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 207,
      GIR_Done,
    // Label 257: @5270
    GIM_Reject,
    // Label 245: @5271
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5304), // Rule ID 924 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 924,
      GIR_Done,
    // Label 258: @5304
    GIM_Reject,
    // Label 246: @5305
    GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(5338), // Rule ID 923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 923,
      GIR_Done,
    // Label 259: @5338
    GIM_Reject,
    // Label 247: @5339
    GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5372), // Rule ID 922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 922,
      GIR_Done,
    // Label 260: @5372
    GIM_Reject,
    // Label 248: @5373
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5406), // Rule ID 921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 921,
      GIR_Done,
    // Label 261: @5406
    GIM_Reject,
    // Label 249: @5407
    GIM_Reject,
    // Label 9: @5408
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 268*/ GIMT_Encode4(6299),
    /*GILLT_s32*//*Label 262*/ GIMT_Encode4(5451),
    /*GILLT_s64*//*Label 263*/ GIMT_Encode4(6068), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 264*/ GIMT_Encode4(6163), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 265*/ GIMT_Encode4(6197),
    /*GILLT_v8s16*//*Label 266*/ GIMT_Encode4(6231),
    /*GILLT_v16s8*//*Label 267*/ GIMT_Encode4(6265),
    // Label 262: @5451
    GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(6067),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5521), // Rule ID 54 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54,
        GIR_EraseRootFromParent_Done,
      // Label 270: @5521
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5580), // Rule ID 1080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1080,
        GIR_EraseRootFromParent_Done,
      // Label 271: @5580
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5639), // Rule ID 1182 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1182,
        GIR_EraseRootFromParent_Done,
      // Label 272: @5639
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5668), // Rule ID 1209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1209,
        GIR_EraseRootFromParent_Done,
      // Label 273: @5668
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5697), // Rule ID 1062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1062,
        GIR_EraseRootFromParent_Done,
      // Label 274: @5697
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5732), // Rule ID 1397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1397,
        GIR_EraseRootFromParent_Done,
      // Label 275: @5732
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5761), // Rule ID 1799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NotRxRy16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_RootToRootCopy, /*OpIdx*/1, // r
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1799,
        GIR_EraseRootFromParent_Done,
      // Label 276: @5761
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5790), // Rule ID 2139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2139,
        GIR_EraseRootFromParent_Done,
      // Label 277: @5790
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5825), // Rule ID 2140 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2140,
        GIR_EraseRootFromParent_Done,
      // Label 278: @5825
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5854), // Rule ID 2306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2306,
        GIR_EraseRootFromParent_Done,
      // Label 279: @5854
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(5889), // Rule ID 2307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2307,
        GIR_EraseRootFromParent_Done,
      // Label 280: @5889
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(5931), // Rule ID 43 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (XORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::XORi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 43,
        GIR_EraseRootFromParent_Done,
      // Label 281: @5931
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(5958), // Rule ID 53 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 282: @5958
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(5985), // Rule ID 1065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR16_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 283: @5985
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6012), // Rule ID 1079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 284: @6012
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(6039), // Rule ID 1186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MMR6),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1186,
        GIR_Done,
      // Label 285: @6039
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(6066), // Rule ID 1806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XorRxRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1806,
        GIR_Done,
      // Label 286: @6066
      GIM_Reject,
    // Label 269: @6067
    GIM_Reject,
    // Label 263: @6068
    GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(6162),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(6138), // Rule ID 209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 209,
        GIR_EraseRootFromParent_Done,
      // Label 288: @6138
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(6161), // Rule ID 208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 289: @6161
      GIM_Reject,
    // Label 287: @6162
    GIM_Reject,
    // Label 264: @6163
    GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(6196), // Rule ID 1040 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_D_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1040,
      GIR_Done,
    // Label 290: @6196
    GIM_Reject,
    // Label 265: @6197
    GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(6230), // Rule ID 1039 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_W_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1039,
      GIR_Done,
    // Label 291: @6230
    GIM_Reject,
    // Label 266: @6231
    GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(6264), // Rule ID 1038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_H_PSEUDO),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1038,
      GIR_Done,
    // Label 292: @6264
    GIM_Reject,
    // Label 267: @6265
    GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(6298), // Rule ID 1037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1037,
      GIR_Done,
    // Label 293: @6298
    GIM_Reject,
    // Label 268: @6299
    GIM_Reject,
    // Label 10: @6300
    GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(6372),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(6344), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::AFGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 295: @6344
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(6371), // Rule ID 181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64_64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64_64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 296: @6371
      GIM_Reject,
    // Label 294: @6372
    GIM_Reject,
    // Label 11: @6373
    GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(6444),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(6417), // Rule ID 719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rs)  =>  (FILL_D:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 719,
        GIR_EraseRootFromParent_Done,
      // Label 298: @6417
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(6443), // Rule ID 721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs, FGR64:{ *:[f64] }:$fs)  =>  (FILL_FD_PSEUDO:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FD_PSEUDO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // fs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 721,
        GIR_EraseRootFromParent_Done,
      // Label 299: @6443
      GIM_Reject,
    // Label 297: @6444
    GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(6535),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(6498), // Rule ID 718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_W:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 718,
        GIR_EraseRootFromParent_Done,
      // Label 301: @6498
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(6534), // Rule ID 720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs)  =>  (FILL_FW_PSEUDO:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FW_PSEUDO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // fs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 720,
        GIR_EraseRootFromParent_Done,
      // Label 302: @6534
      GIM_Reject,
    // Label 300: @6535
    GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(6604), // Rule ID 717 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/9,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_H:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_H),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
      GIR_RootToRootCopy, /*OpIdx*/1, // rs
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 717,
      GIR_EraseRootFromParent_Done,
    // Label 303: @6604
    GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(6713), // Rule ID 716 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_B:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_B),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
      GIR_RootToRootCopy, /*OpIdx*/1, // rs
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 716,
      GIR_EraseRootFromParent_Done,
    // Label 304: @6713
    GIM_Reject,
    // Label 12: @6714
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 313*/ GIMT_Encode4(10904),
    /*GILLT_s32*//*Label 305*/ GIMT_Encode4(6757),
    /*GILLT_s64*//*Label 306*/ GIMT_Encode4(7034),
    /*GILLT_v2s16*//*Label 307*/ GIMT_Encode4(7090),
    /*GILLT_v2s64*//*Label 308*/ GIMT_Encode4(7150),
    /*GILLT_v4s8*//*Label 309*/ GIMT_Encode4(8249),
    /*GILLT_v4s32*//*Label 310*/ GIMT_Encode4(8309),
    /*GILLT_v8s16*//*Label 311*/ GIMT_Encode4(9348),
    /*GILLT_v16s8*//*Label 312*/ GIMT_Encode4(10243),
    // Label 305: @6757
    GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6783), // Rule ID 135 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 135,
      GIR_Done,
    // Label 314: @6783
    GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6809), // Rule ID 136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 136,
      GIR_Done,
    // Label 315: @6809
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6835), // Rule ID 1160 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1160,
      GIR_Done,
    // Label 316: @6835
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6861), // Rule ID 1161 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1161,
      GIR_Done,
    // Label 317: @6861
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(6887), // Rule ID 1175 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MMR6),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1175,
      GIR_Done,
    // Label 318: @6887
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(6913), // Rule ID 1176 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MMR6),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1176,
      GIR_Done,
    // Label 319: @6913
    GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(6943), // Rule ID 1887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1887,
      GIR_Done,
    // Label 320: @6943
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(6973), // Rule ID 1888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1888,
      GIR_Done,
    // Label 321: @6973
    GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(7003), // Rule ID 1891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1891,
      GIR_Done,
    // Label 322: @7003
    GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(7033), // Rule ID 1892 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1892,
      GIR_Done,
    // Label 323: @7033
    GIM_Reject,
    // Label 306: @7034
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(7089),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(7065), // Rule ID 137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMTC1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 325: @7065
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(7088), // Rule ID 138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMFC1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 326: @7088
      GIM_Reject,
    // Label 324: @7089
    GIM_Reject,
    // Label 307: @7090
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(7149),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(7125), // Rule ID 1889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1889,
        GIR_Done,
      // Label 328: @7125
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(7148), // Rule ID 1893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1893,
        GIR_Done,
      // Label 329: @7148
      GIM_Reject,
    // Label 327: @7149
    GIM_Reject,
    // Label 308: @7150
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(7176), // Rule ID 1974 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1974,
      GIR_Done,
    // Label 330: @7176
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(7202), // Rule ID 1977 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1977,
      GIR_Done,
    // Label 331: @7202
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(7228), // Rule ID 1994 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1994,
      GIR_Done,
    // Label 332: @7228
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(7254), // Rule ID 1995 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1995,
      GIR_Done,
    // Label 333: @7254
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7280), // Rule ID 1996 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1996,
      GIR_Done,
    // Label 334: @7280
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7306), // Rule ID 1997 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1997,
      GIR_Done,
    // Label 335: @7306
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7332), // Rule ID 1998 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1998,
      GIR_Done,
    // Label 336: @7332
    GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7358), // Rule ID 2004 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2004,
      GIR_Done,
    // Label 337: @7358
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(7384), // Rule ID 2005 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2005,
      GIR_Done,
    // Label 338: @7384
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(7410), // Rule ID 2006 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2006,
      GIR_Done,
    // Label 339: @7410
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(7436), // Rule ID 2007 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 340: @7436
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(7462), // Rule ID 2008 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2008,
      GIR_Done,
    // Label 341: @7462
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(7573), // Rule ID 2013 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2013,
      GIR_EraseRootFromParent_Done,
    // Label 342: @7573
    GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(7684), // Rule ID 2014 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2014,
      GIR_EraseRootFromParent_Done,
    // Label 343: @7684
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(7751), // Rule ID 2018 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2018,
      GIR_EraseRootFromParent_Done,
    // Label 344: @7751
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(7818), // Rule ID 2019 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2019,
      GIR_EraseRootFromParent_Done,
    // Label 345: @7818
    GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(7885), // Rule ID 2023 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2023,
      GIR_EraseRootFromParent_Done,
    // Label 346: @7885
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(7952), // Rule ID 2024 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2024,
      GIR_EraseRootFromParent_Done,
    // Label 347: @7952
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(8026), // Rule ID 2028 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2028,
      GIR_EraseRootFromParent_Done,
    // Label 348: @8026
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(8100), // Rule ID 2029 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2029,
      GIR_EraseRootFromParent_Done,
    // Label 349: @8100
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(8174), // Rule ID 2033 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2033,
      GIR_EraseRootFromParent_Done,
    // Label 350: @8174
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(8248), // Rule ID 2034 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2034,
      GIR_EraseRootFromParent_Done,
    // Label 351: @8248
    GIM_Reject,
    // Label 309: @8249
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(8308),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(8284), // Rule ID 1890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1890,
        GIR_Done,
      // Label 353: @8284
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(8307), // Rule ID 1894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1894,
        GIR_Done,
      // Label 354: @8307
      GIM_Reject,
    // Label 352: @8308
    GIM_Reject,
    // Label 310: @8309
    GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(8335), // Rule ID 1973 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1973,
      GIR_Done,
    // Label 355: @8335
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(8361), // Rule ID 1976 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1976,
      GIR_Done,
    // Label 356: @8361
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(8387), // Rule ID 1989 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1989,
      GIR_Done,
    // Label 357: @8387
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(8413), // Rule ID 1990 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1990,
      GIR_Done,
    // Label 358: @8413
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(8439), // Rule ID 1991 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1991,
      GIR_Done,
    // Label 359: @8439
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(8465), // Rule ID 1992 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1992,
      GIR_Done,
    // Label 360: @8465
    GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(8491), // Rule ID 1993 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1993,
      GIR_Done,
    // Label 361: @8491
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(8517), // Rule ID 1999 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1999,
      GIR_Done,
    // Label 362: @8517
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(8543), // Rule ID 2000 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2000,
      GIR_Done,
    // Label 363: @8543
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(8569), // Rule ID 2001 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2001,
      GIR_Done,
    // Label 364: @8569
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(8595), // Rule ID 2002 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2002,
      GIR_Done,
    // Label 365: @8595
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(8621), // Rule ID 2003 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2003,
      GIR_Done,
    // Label 366: @8621
    GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(8688), // Rule ID 2011 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2011,
      GIR_EraseRootFromParent_Done,
    // Label 367: @8688
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(8755), // Rule ID 2012 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2012,
      GIR_EraseRootFromParent_Done,
    // Label 368: @8755
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(8829), // Rule ID 2016 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2016,
      GIR_EraseRootFromParent_Done,
    // Label 369: @8829
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(8903), // Rule ID 2017 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2017,
      GIR_EraseRootFromParent_Done,
    // Label 370: @8903
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(8977), // Rule ID 2021 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2021,
      GIR_EraseRootFromParent_Done,
    // Label 371: @8977
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(9051), // Rule ID 2022 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2022,
      GIR_EraseRootFromParent_Done,
    // Label 372: @9051
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(9125), // Rule ID 2038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2038,
      GIR_EraseRootFromParent_Done,
    // Label 373: @9125
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(9199), // Rule ID 2039 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2039,
      GIR_EraseRootFromParent_Done,
    // Label 374: @9199
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(9273), // Rule ID 2043 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2043,
      GIR_EraseRootFromParent_Done,
    // Label 375: @9273
    GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(9347), // Rule ID 2044 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 2044,
      GIR_EraseRootFromParent_Done,
    // Label 376: @9347
    GIM_Reject,
    // Label 311: @9348
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(9374), // Rule ID 1972 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1972,
      GIR_Done,
    // Label 377: @9374
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(9400), // Rule ID 1975 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1975,
      GIR_Done,
    // Label 378: @9400
    GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(9426), // Rule ID 1984 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1984,
      GIR_Done,
    // Label 379: @9426
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(9452), // Rule ID 1985 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1985,
      GIR_Done,
    // Label 380: @9452
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(9478), // Rule ID 1986 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1986,
      GIR_Done,
    // Label 381: @9478
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(9504), // Rule ID 1987 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1987,
      GIR_Done,
    // Label 382: @9504
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(9530), // Rule ID 1988 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1988,
      GIR_Done,
    // Label 383: @9530
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(9604), // Rule ID 2009 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2009,
      GIR_EraseRootFromParent_Done,
    // Label 384: @9604
    GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(9678), // Rule ID 2010 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2010,
      GIR_EraseRootFromParent_Done,
    // Label 385: @9678
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(9752), // Rule ID 2026 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2026,
      GIR_EraseRootFromParent_Done,
    // Label 386: @9752
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(9826), // Rule ID 2027 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2027,
      GIR_EraseRootFromParent_Done,
    // Label 387: @9826
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(9900), // Rule ID 2031 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2031,
      GIR_EraseRootFromParent_Done,
    // Label 388: @9900
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(9974), // Rule ID 2032 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2032,
      GIR_EraseRootFromParent_Done,
    // Label 389: @9974
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(10041), // Rule ID 2036 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2036,
      GIR_EraseRootFromParent_Done,
    // Label 390: @10041
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(10108), // Rule ID 2037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2037,
      GIR_EraseRootFromParent_Done,
    // Label 391: @10108
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(10175), // Rule ID 2041 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2041,
      GIR_EraseRootFromParent_Done,
    // Label 392: @10175
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(10242), // Rule ID 2042 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 2042,
      GIR_EraseRootFromParent_Done,
    // Label 393: @10242
    GIM_Reject,
    // Label 312: @10243
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(10269), // Rule ID 1978 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1978,
      GIR_Done,
    // Label 394: @10269
    GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(10295), // Rule ID 1979 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1979,
      GIR_Done,
    // Label 395: @10295
    GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(10321), // Rule ID 1980 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1980,
      GIR_Done,
    // Label 396: @10321
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(10347), // Rule ID 1981 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1981,
      GIR_Done,
    // Label 397: @10347
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(10373), // Rule ID 1982 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1982,
      GIR_Done,
    // Label 398: @10373
    GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(10399), // Rule ID 1983 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1983,
      GIR_Done,
    // Label 399: @10399
    GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(10473), // Rule ID 2015 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2015,
      GIR_EraseRootFromParent_Done,
    // Label 400: @10473
    GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(10547), // Rule ID 2020 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2020,
      GIR_EraseRootFromParent_Done,
    // Label 401: @10547
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(10614), // Rule ID 2025 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2025,
      GIR_EraseRootFromParent_Done,
    // Label 402: @10614
    GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(10681), // Rule ID 2030 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2030,
      GIR_EraseRootFromParent_Done,
    // Label 403: @10681
    GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(10792), // Rule ID 2035 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2035,
      GIR_EraseRootFromParent_Done,
    // Label 404: @10792
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(10903), // Rule ID 2040 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 2040,
      GIR_EraseRootFromParent_Done,
    // Label 405: @10903
    GIM_Reject,
    // Label 313: @10904
    GIM_Reject,
    // Label 13: @10905
    GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(10969), // Rule ID 1963 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LWX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1963,
      GIR_EraseRootFromParent_Done,
    // Label 406: @10969
    GIM_Reject,
    // Label 14: @10970
    GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(11037), // Rule ID 1962 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LHX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1962,
      GIR_EraseRootFromParent_Done,
    // Label 407: @11037
    GIM_Reject,
    // Label 15: @11038
    GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(11105), // Rule ID 1961 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LBUX),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1961,
      GIR_EraseRootFromParent_Done,
    // Label 408: @11105
    GIM_Reject,
    // Label 16: @11106
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 411*/ GIMT_Encode4(15826),
    /*GILLT_s32*//*Label 409*/ GIMT_Encode4(11125),
    /*GILLT_s64*//*Label 410*/ GIMT_Encode4(15792),
    // Label 409: @11125
    GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(11233), // Rule ID 2337 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2337,
      GIR_EraseRootFromParent_Done,
    // Label 412: @11233
    GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(11348), // Rule ID 2338 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2338,
      GIR_EraseRootFromParent_Done,
    // Label 413: @11348
    GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(11456), // Rule ID 2339 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2339,
      GIR_EraseRootFromParent_Done,
    // Label 414: @11456
    GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(11571), // Rule ID 2340 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2340,
      GIR_EraseRootFromParent_Done,
    // Label 415: @11571
    GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(11679), // Rule ID 270 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 270,
      GIR_EraseRootFromParent_Done,
    // Label 416: @11679
    GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(11794), // Rule ID 271 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 271,
      GIR_EraseRootFromParent_Done,
    // Label 417: @11794
    GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(11902), // Rule ID 272 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 272,
      GIR_EraseRootFromParent_Done,
    // Label 418: @11902
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(12017), // Rule ID 273 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
      GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
      GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
      GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
      GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
      GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
      // MIs[4] Operand 1
      // No operand predicates
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/4,
      // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 273,
      GIR_EraseRootFromParent_Done,
    // Label 419: @12017
    GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(12074), // Rule ID 94 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 94,
      GIR_EraseRootFromParent_Done,
    // Label 420: @12074
    GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(12131), // Rule ID 95 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 95,
      GIR_EraseRootFromParent_Done,
    // Label 421: @12131
    GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(12188), // Rule ID 96 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 96,
      GIR_EraseRootFromParent_Done,
    // Label 422: @12188
    GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(12245), // Rule ID 97 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 97,
      GIR_EraseRootFromParent_Done,
    // Label 423: @12245
    GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(12302), // Rule ID 245 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 245,
      GIR_EraseRootFromParent_Done,
    // Label 424: @12302
    GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(12359), // Rule ID 246 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 246,
      GIR_EraseRootFromParent_Done,
    // Label 425: @12359
    GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(12416), // Rule ID 247 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 247,
      GIR_EraseRootFromParent_Done,
    // Label 426: @12416
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(12473), // Rule ID 248 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 248,
      GIR_EraseRootFromParent_Done,
    // Label 427: @12473
    GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(12530), // Rule ID 1109 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1109,
      GIR_EraseRootFromParent_Done,
    // Label 428: @12530
    GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(12587), // Rule ID 1110 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1110,
      GIR_EraseRootFromParent_Done,
    // Label 429: @12587
    GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(12644), // Rule ID 1111 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1111,
      GIR_EraseRootFromParent_Done,
    // Label 430: @12644
    GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(12701), // Rule ID 1112 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1112,
      GIR_EraseRootFromParent_Done,
    // Label 431: @12701
    GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(12764), // Rule ID 1402 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1402,
      GIR_EraseRootFromParent_Done,
    // Label 432: @12764
    GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(12827), // Rule ID 1403 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1403,
      GIR_EraseRootFromParent_Done,
    // Label 433: @12827
    GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(12890), // Rule ID 1546 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1546,
      GIR_EraseRootFromParent_Done,
    // Label 434: @12890
    GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(12953), // Rule ID 1547 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1547,
      GIR_EraseRootFromParent_Done,
    // Label 435: @12953
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(13007), // Rule ID 1830 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BeqzRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BeqzRxImm16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // targ16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1830,
      GIR_EraseRootFromParent_Done,
    // Label 436: @13007
    GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(13061), // Rule ID 1839 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // targ16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1839,
      GIR_EraseRootFromParent_Done,
    // Label 437: @13061
    GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(13124), // Rule ID 2167 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2167,
      GIR_EraseRootFromParent_Done,
    // Label 438: @13124
    GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(13187), // Rule ID 2168 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2168,
      GIR_EraseRootFromParent_Done,
    // Label 439: @13187
    GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(13244), // Rule ID 2314 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2314,
      GIR_EraseRootFromParent_Done,
    // Label 440: @13244
    GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(13301), // Rule ID 2315 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2315,
      GIR_EraseRootFromParent_Done,
    // Label 441: @13301
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(13353), // Rule ID 1413 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1413,
      GIR_EraseRootFromParent_Done,
    // Label 442: @13353
    GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(13405), // Rule ID 1414 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1414,
      GIR_EraseRootFromParent_Done,
    // Label 443: @13405
    GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(13457), // Rule ID 1557 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, 1:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1557,
      GIR_EraseRootFromParent_Done,
    // Label 444: @13457
    GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(13509), // Rule ID 1558 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, -1:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1558,
      GIR_EraseRootFromParent_Done,
    // Label 445: @13509
    GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(13561), // Rule ID 2178 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2178,
      GIR_EraseRootFromParent_Done,
    // Label 446: @13561
    GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(13613), // Rule ID 2179 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2179,
      GIR_EraseRootFromParent_Done,
    // Label 447: @13613
    GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(13675), // Rule ID 92 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 92,
      GIR_EraseRootFromParent_Done,
    // Label 448: @13675
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(13737), // Rule ID 93 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 93,
      GIR_EraseRootFromParent_Done,
    // Label 449: @13737
    GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(13799), // Rule ID 243 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 243,
      GIR_EraseRootFromParent_Done,
    // Label 450: @13799
    GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(13861), // Rule ID 244 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 244,
      GIR_EraseRootFromParent_Done,
    // Label 451: @13861
    GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(13923), // Rule ID 1107 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1107,
      GIR_EraseRootFromParent_Done,
    // Label 452: @13923
    GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(13985), // Rule ID 1108 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] offset
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
      GIR_RootToRootCopy, /*OpIdx*/1, // offset
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1108,
      GIR_EraseRootFromParent_Done,
    // Label 453: @13985
    GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(14070), // Rule ID 1404 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1404,
      GIR_EraseRootFromParent_Done,
    // Label 454: @14070
    GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(14155), // Rule ID 1405 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1405,
      GIR_EraseRootFromParent_Done,
    // Label 455: @14155
    GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(14240), // Rule ID 1410 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1410,
      GIR_EraseRootFromParent_Done,
    // Label 456: @14240
    GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(14325), // Rule ID 1411 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1411,
      GIR_EraseRootFromParent_Done,
    // Label 457: @14325
    GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(14410), // Rule ID 1548 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1548,
      GIR_EraseRootFromParent_Done,
    // Label 458: @14410
    GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(14495), // Rule ID 1549 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1549,
      GIR_EraseRootFromParent_Done,
    // Label 459: @14495
    GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(14580), // Rule ID 1554 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1554,
      GIR_EraseRootFromParent_Done,
    // Label 460: @14580
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(14665), // Rule ID 1555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1555,
      GIR_EraseRootFromParent_Done,
    // Label 461: @14665
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(14724), // Rule ID 1828 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8CmpX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1828,
      GIR_EraseRootFromParent_Done,
    // Label 462: @14724
    GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(14783), // Rule ID 1831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1831,
      GIR_EraseRootFromParent_Done,
    // Label 463: @14783
    GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(14842), // Rule ID 1832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1832,
      GIR_EraseRootFromParent_Done,
    // Label 464: @14842
    GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(14901), // Rule ID 1834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1834,
      GIR_EraseRootFromParent_Done,
    // Label 465: @14901
    GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(14960), // Rule ID 1836 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1836,
      GIR_EraseRootFromParent_Done,
    // Label 466: @14960
    GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(15019), // Rule ID 1837 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] imm16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8CmpX16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
      GIR_RootToRootCopy, /*OpIdx*/1, // imm16
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1837,
      GIR_EraseRootFromParent_Done,
    // Label 467: @15019
    GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(15104), // Rule ID 2169 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2169,
      GIR_EraseRootFromParent_Done,
    // Label 468: @15104
    GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(15189), // Rule ID 2170 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2170,
      GIR_EraseRootFromParent_Done,
    // Label 469: @15189
    GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(15274), // Rule ID 2175 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2175,
      GIR_EraseRootFromParent_Done,
    // Label 470: @15274
    GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(15359), // Rule ID 2176 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2176,
      GIR_EraseRootFromParent_Done,
    // Label 471: @15359
    GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(15438), // Rule ID 2316 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2316,
      GIR_EraseRootFromParent_Done,
    // Label 472: @15438
    GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(15517), // Rule ID 2317 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2317,
      GIR_EraseRootFromParent_Done,
    // Label 473: @15517
    GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(15596), // Rule ID 2322 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2322,
      GIR_EraseRootFromParent_Done,
    // Label 474: @15596
    GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(15675), // Rule ID 2323 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2323,
      GIR_EraseRootFromParent_Done,
    // Label 475: @15675
    GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(15708), // Rule ID 1412 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1412,
      GIR_EraseRootFromParent_Done,
    // Label 476: @15708
    GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(15730), // Rule ID 1840 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
      // MIs[0] targ16
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1840,
      GIR_Done,
    // Label 477: @15730
    GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(15763), // Rule ID 2177 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2177,
      GIR_EraseRootFromParent_Done,
    // Label 478: @15763
    GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(15791), // Rule ID 2324 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::AT), GIMT_Encode2(RegState::Dead),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2324,
      GIR_Done,
    // Label 479: @15791
    GIM_Reject,
    // Label 410: @15792
    GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(15825), // Rule ID 1556 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      // (brcond GPR64:{ *:[i64] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$cond, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
      GIR_RootToRootCopy, /*OpIdx*/0, // cond
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootToRootCopy, /*OpIdx*/1, // dst
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1556,
      GIR_EraseRootFromParent_Done,
    // Label 480: @15825
    GIM_Reject,
    // Label 411: @15826
    GIM_Reject,
    // Label 17: @15827
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(17824),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(15882), // Rule ID 428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7714:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 428,
        GIR_EraseRootFromParent_Done,
      // Label 482: @15882
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(15929), // Rule ID 429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7713:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 429,
        GIR_EraseRootFromParent_Done,
      // Label 483: @15929
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(15976), // Rule ID 1288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7713:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1288,
        GIR_EraseRootFromParent_Done,
      // Label 484: @15976
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(16023), // Rule ID 1289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7714:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1289,
        GIR_EraseRootFromParent_Done,
      // Label 485: @16023
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(16059), // Rule ID 362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7711:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 362,
        GIR_EraseRootFromParent_Done,
      // Label 486: @16059
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(16095), // Rule ID 369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7693:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 369,
        GIR_EraseRootFromParent_Done,
      // Label 487: @16095
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(16131), // Rule ID 370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7694:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 370,
        GIR_EraseRootFromParent_Done,
      // Label 488: @16131
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(16167), // Rule ID 371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7695:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 371,
        GIR_EraseRootFromParent_Done,
      // Label 489: @16167
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(16203), // Rule ID 372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7697:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 372,
        GIR_EraseRootFromParent_Done,
      // Label 490: @16203
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(16239), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7696:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 373,
        GIR_EraseRootFromParent_Done,
      // Label 491: @16239
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(16275), // Rule ID 374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7698:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 374,
        GIR_EraseRootFromParent_Done,
      // Label 492: @16275
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(16311), // Rule ID 375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7699:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 375,
        GIR_EraseRootFromParent_Done,
      // Label 493: @16311
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(16347), // Rule ID 376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7701:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 376,
        GIR_EraseRootFromParent_Done,
      // Label 494: @16347
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(16383), // Rule ID 377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7700:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 377,
        GIR_EraseRootFromParent_Done,
      // Label 495: @16383
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(16419), // Rule ID 378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7702:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 378,
        GIR_EraseRootFromParent_Done,
      // Label 496: @16419
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(16455), // Rule ID 426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7267:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 426,
        GIR_EraseRootFromParent_Done,
      // Label 497: @16455
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(16491), // Rule ID 430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7714:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 430,
        GIR_EraseRootFromParent_Done,
      // Label 498: @16491
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(16527), // Rule ID 431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7713:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 431,
        GIR_EraseRootFromParent_Done,
      // Label 499: @16527
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(16563), // Rule ID 680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7419:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 680,
        GIR_EraseRootFromParent_Done,
      // Label 500: @16563
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(16599), // Rule ID 681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7418:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 681,
        GIR_EraseRootFromParent_Done,
      // Label 501: @16599
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(16635), // Rule ID 704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7445:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 704,
        GIR_EraseRootFromParent_Done,
      // Label 502: @16635
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(16671), // Rule ID 705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7444:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 705,
        GIR_EraseRootFromParent_Done,
      // Label 503: @16671
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(16707), // Rule ID 706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7447:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 706,
        GIR_EraseRootFromParent_Done,
      // Label 504: @16707
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(16743), // Rule ID 707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7446:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 707,
        GIR_EraseRootFromParent_Done,
      // Label 505: @16743
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(16779), // Rule ID 712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7453:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 712,
        GIR_EraseRootFromParent_Done,
      // Label 506: @16779
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(16815), // Rule ID 713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7452:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 713,
        GIR_EraseRootFromParent_Done,
      // Label 507: @16815
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(16851), // Rule ID 714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7455:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 714,
        GIR_EraseRootFromParent_Done,
      // Label 508: @16851
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(16887), // Rule ID 715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7454:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 715,
        GIR_EraseRootFromParent_Done,
      // Label 509: @16887
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(16923), // Rule ID 740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7477:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 740,
        GIR_EraseRootFromParent_Done,
      // Label 510: @16923
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(16959), // Rule ID 741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7476:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 741,
        GIR_EraseRootFromParent_Done,
      // Label 511: @16959
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(16995), // Rule ID 742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7481:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 742,
        GIR_EraseRootFromParent_Done,
      // Label 512: @16995
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(17031), // Rule ID 743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7480:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 743,
        GIR_EraseRootFromParent_Done,
      // Label 513: @17031
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(17067), // Rule ID 770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7509:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 770,
        GIR_EraseRootFromParent_Done,
      // Label 514: @17067
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(17103), // Rule ID 771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7508:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 771,
        GIR_EraseRootFromParent_Done,
      // Label 515: @17103
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(17139), // Rule ID 772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7511:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 772,
        GIR_EraseRootFromParent_Done,
      // Label 516: @17139
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(17175), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7510:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 773,
        GIR_EraseRootFromParent_Done,
      // Label 517: @17175
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(17211), // Rule ID 908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7666:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 908,
        GIR_EraseRootFromParent_Done,
      // Label 518: @17211
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(17247), // Rule ID 909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7668:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 909,
        GIR_EraseRootFromParent_Done,
      // Label 519: @17247
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(17283), // Rule ID 910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7669:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 910,
        GIR_EraseRootFromParent_Done,
      // Label 520: @17283
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(17319), // Rule ID 911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7667:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 911,
        GIR_EraseRootFromParent_Done,
      // Label 521: @17319
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(17355), // Rule ID 1251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7693:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1251,
        GIR_EraseRootFromParent_Done,
      // Label 522: @17355
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(17391), // Rule ID 1252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7694:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1252,
        GIR_EraseRootFromParent_Done,
      // Label 523: @17391
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(17427), // Rule ID 1253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7695:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1253,
        GIR_EraseRootFromParent_Done,
      // Label 524: @17427
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(17463), // Rule ID 1254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7696:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1254,
        GIR_EraseRootFromParent_Done,
      // Label 525: @17463
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(17499), // Rule ID 1255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7697:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1255,
        GIR_EraseRootFromParent_Done,
      // Label 526: @17499
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(17535), // Rule ID 1256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7698:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1256,
        GIR_EraseRootFromParent_Done,
      // Label 527: @17535
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(17571), // Rule ID 1257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7699:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1257,
        GIR_EraseRootFromParent_Done,
      // Label 528: @17571
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(17607), // Rule ID 1258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7700:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1258,
        GIR_EraseRootFromParent_Done,
      // Label 529: @17607
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(17643), // Rule ID 1259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7701:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1259,
        GIR_EraseRootFromParent_Done,
      // Label 530: @17643
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(17679), // Rule ID 1260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7702:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1260,
        GIR_EraseRootFromParent_Done,
      // Label 531: @17679
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(17715), // Rule ID 1286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7711:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1286,
        GIR_EraseRootFromParent_Done,
      // Label 532: @17715
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(17751), // Rule ID 1290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7713:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1290,
        GIR_EraseRootFromParent_Done,
      // Label 533: @17751
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(17787), // Rule ID 1291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7714:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1291,
        GIR_EraseRootFromParent_Done,
      // Label 534: @17787
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(17823), // Rule ID 1301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7267:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1301,
        GIR_EraseRootFromParent_Done,
      // Label 535: @17823
      GIM_Reject,
    // Label 481: @17824
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(27577),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(17878), // Rule ID 938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7715:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 938,
        GIR_EraseRootFromParent_Done,
      // Label 537: @17878
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(17924), // Rule ID 939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7717:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 939,
        GIR_EraseRootFromParent_Done,
      // Label 538: @17924
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(17970), // Rule ID 940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7718:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 940,
        GIR_EraseRootFromParent_Done,
      // Label 539: @17970
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(18016), // Rule ID 941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7716:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 941,
        GIR_EraseRootFromParent_Done,
      // Label 540: @18016
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(18062), // Rule ID 942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7719:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 942,
        GIR_EraseRootFromParent_Done,
      // Label 541: @18062
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(18108), // Rule ID 943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7721:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 943,
        GIR_EraseRootFromParent_Done,
      // Label 542: @18108
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(18154), // Rule ID 944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7722:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 944,
        GIR_EraseRootFromParent_Done,
      // Label 543: @18154
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(18200), // Rule ID 945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7720:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 945,
        GIR_EraseRootFromParent_Done,
      // Label 544: @18200
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(18246), // Rule ID 985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7774:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 985,
        GIR_EraseRootFromParent_Done,
      // Label 545: @18246
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(18292), // Rule ID 986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7776:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 986,
        GIR_EraseRootFromParent_Done,
      // Label 546: @18292
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(18338), // Rule ID 987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7777:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 987,
        GIR_EraseRootFromParent_Done,
      // Label 547: @18338
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(18384), // Rule ID 988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7775:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 988,
        GIR_EraseRootFromParent_Done,
      // Label 548: @18384
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(18430), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7790:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1001,
        GIR_EraseRootFromParent_Done,
      // Label 549: @18430
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(18476), // Rule ID 1002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7792:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1002,
        GIR_EraseRootFromParent_Done,
      // Label 550: @18476
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(18522), // Rule ID 1003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7793:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1003,
        GIR_EraseRootFromParent_Done,
      // Label 551: @18522
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(18568), // Rule ID 1004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7791:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // m
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1004,
        GIR_EraseRootFromParent_Done,
      // Label 552: @18568
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(18624), // Rule ID 385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7733:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 385,
        GIR_EraseRootFromParent_Done,
      // Label 553: @18624
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(18680), // Rule ID 389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7735:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 389,
        GIR_EraseRootFromParent_Done,
      // Label 554: @18680
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(18736), // Rule ID 480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7734:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 480,
        GIR_EraseRootFromParent_Done,
      // Label 555: @18736
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(18792), // Rule ID 1245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7733:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1245,
        GIR_EraseRootFromParent_Done,
      // Label 556: @18792
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(18848), // Rule ID 1249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7735:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1249,
        GIR_EraseRootFromParent_Done,
      // Label 557: @18848
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(18904), // Rule ID 1324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7734:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1324,
        GIR_EraseRootFromParent_Done,
      // Label 558: @18904
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(18956), // Rule ID 1917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7731:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1917,
        GIR_EraseRootFromParent_Done,
      // Label 559: @18956
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(19008), // Rule ID 1918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7736:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1918,
        GIR_EraseRootFromParent_Done,
      // Label 560: @19008
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(19060), // Rule ID 1923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7732:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1923,
        GIR_EraseRootFromParent_Done,
      // Label 561: @19060
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(19112), // Rule ID 1924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7737:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1924,
        GIR_EraseRootFromParent_Done,
      // Label 562: @19112
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(19160), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7203:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 355,
        GIR_EraseRootFromParent_Done,
      // Label 563: @19160
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(19208), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7826:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 356,
        GIR_EraseRootFromParent_Done,
      // Label 564: @19208
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(19256), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7181:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 357,
        GIR_EraseRootFromParent_Done,
      // Label 565: @19256
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(19304), // Rule ID 358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7801:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 358,
        GIR_EraseRootFromParent_Done,
      // Label 566: @19304
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(19349), // Rule ID 361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7631:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 361,
        GIR_EraseRootFromParent_Done,
      // Label 567: @19349
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(19394), // Rule ID 365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7707:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 365,
        GIR_EraseRootFromParent_Done,
      // Label 568: @19394
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(19439), // Rule ID 366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7706:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 366,
        GIR_EraseRootFromParent_Done,
      // Label 569: @19439
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(19484), // Rule ID 380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7737:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 380,
        GIR_EraseRootFromParent_Done,
      // Label 570: @19484
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(19529), // Rule ID 384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7731:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 384,
        GIR_EraseRootFromParent_Done,
      // Label 571: @19529
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(19574), // Rule ID 386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7733:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 386,
        GIR_EraseRootFromParent_Done,
      // Label 572: @19574
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(19619), // Rule ID 390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7735:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 390,
        GIR_EraseRootFromParent_Done,
      // Label 573: @19619
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(19664), // Rule ID 427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7678:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 427,
        GIR_EraseRootFromParent_Done,
      // Label 574: @19664
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(19709), // Rule ID 451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7204:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 451,
        GIR_EraseRootFromParent_Done,
      // Label 575: @19709
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(19754), // Rule ID 452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7205:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 452,
        GIR_EraseRootFromParent_Done,
      // Label 576: @19754
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(19799), // Rule ID 453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7827:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 453,
        GIR_EraseRootFromParent_Done,
      // Label 577: @19799
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(19844), // Rule ID 454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7828:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 454,
        GIR_EraseRootFromParent_Done,
      // Label 578: @19844
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(19889), // Rule ID 455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7183:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 455,
        GIR_EraseRootFromParent_Done,
      // Label 579: @19889
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(19934), // Rule ID 456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7184:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 456,
        GIR_EraseRootFromParent_Done,
      // Label 580: @19934
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(19979), // Rule ID 457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7803:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 457,
        GIR_EraseRootFromParent_Done,
      // Label 581: @19979
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(20024), // Rule ID 458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7804:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 458,
        GIR_EraseRootFromParent_Done,
      // Label 582: @20024
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(20069), // Rule ID 459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7186:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 459,
        GIR_EraseRootFromParent_Done,
      // Label 583: @20069
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(20114), // Rule ID 460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7185:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 460,
        GIR_EraseRootFromParent_Done,
      // Label 584: @20114
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(20159), // Rule ID 461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7806:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 461,
        GIR_EraseRootFromParent_Done,
      // Label 585: @20159
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(20204), // Rule ID 462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7805:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 462,
        GIR_EraseRootFromParent_Done,
      // Label 586: @20204
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(20249), // Rule ID 479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7732:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 479,
        GIR_EraseRootFromParent_Done,
      // Label 587: @20249
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(20294), // Rule ID 481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7734:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 481,
        GIR_EraseRootFromParent_Done,
      // Label 588: @20294
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(20339), // Rule ID 482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7736:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 482,
        GIR_EraseRootFromParent_Done,
      // Label 589: @20339
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(20384), // Rule ID 491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7176:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 491,
        GIR_EraseRootFromParent_Done,
      // Label 590: @20384
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(20429), // Rule ID 492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7178:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 492,
        GIR_EraseRootFromParent_Done,
      // Label 591: @20429
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(20474), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7179:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 493,
        GIR_EraseRootFromParent_Done,
      // Label 592: @20474
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(20519), // Rule ID 494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7177:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 494,
        GIR_EraseRootFromParent_Done,
      // Label 593: @20519
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(20564), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7187:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 495,
        GIR_EraseRootFromParent_Done,
      // Label 594: @20564
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(20609), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7189:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 496,
        GIR_EraseRootFromParent_Done,
      // Label 595: @20609
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(20654), // Rule ID 497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7190:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 497,
        GIR_EraseRootFromParent_Done,
      // Label 596: @20654
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(20699), // Rule ID 498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7188:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 498,
        GIR_EraseRootFromParent_Done,
      // Label 597: @20699
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(20744), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7191:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 499,
        GIR_EraseRootFromParent_Done,
      // Label 598: @20744
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(20789), // Rule ID 500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7193:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 500,
        GIR_EraseRootFromParent_Done,
      // Label 599: @20789
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(20834), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7194:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 501,
        GIR_EraseRootFromParent_Done,
      // Label 600: @20834
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(20879), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7192:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 502,
        GIR_EraseRootFromParent_Done,
      // Label 601: @20879
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(20924), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7195:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 503,
        GIR_EraseRootFromParent_Done,
      // Label 602: @20924
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(20969), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7197:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 504,
        GIR_EraseRootFromParent_Done,
      // Label 603: @20969
      GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(21014), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7198:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 505,
        GIR_EraseRootFromParent_Done,
      // Label 604: @21014
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(21059), // Rule ID 506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7196:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 506,
        GIR_EraseRootFromParent_Done,
      // Label 605: @21059
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(21104), // Rule ID 520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7218:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 520,
        GIR_EraseRootFromParent_Done,
      // Label 606: @21104
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(21149), // Rule ID 521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7220:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 521,
        GIR_EraseRootFromParent_Done,
      // Label 607: @21149
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(21194), // Rule ID 522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7221:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 522,
        GIR_EraseRootFromParent_Done,
      // Label 608: @21194
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(21239), // Rule ID 523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7219:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 523,
        GIR_EraseRootFromParent_Done,
      // Label 609: @21239
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(21284), // Rule ID 524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7222:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 524,
        GIR_EraseRootFromParent_Done,
      // Label 610: @21284
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(21329), // Rule ID 525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7224:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 525,
        GIR_EraseRootFromParent_Done,
      // Label 611: @21329
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(21374), // Rule ID 526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7225:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 526,
        GIR_EraseRootFromParent_Done,
      // Label 612: @21374
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(21419), // Rule ID 527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7223:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 527,
        GIR_EraseRootFromParent_Done,
      // Label 613: @21419
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(21464), // Rule ID 528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7226:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 528,
        GIR_EraseRootFromParent_Done,
      // Label 614: @21464
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(21509), // Rule ID 529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7228:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 529,
        GIR_EraseRootFromParent_Done,
      // Label 615: @21509
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(21554), // Rule ID 530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7229:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 530,
        GIR_EraseRootFromParent_Done,
      // Label 616: @21554
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(21599), // Rule ID 531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7227:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 531,
        GIR_EraseRootFromParent_Done,
      // Label 617: @21599
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(21644), // Rule ID 532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7230:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 532,
        GIR_EraseRootFromParent_Done,
      // Label 618: @21644
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(21689), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7232:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 533,
        GIR_EraseRootFromParent_Done,
      // Label 619: @21689
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(21734), // Rule ID 534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7233:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 534,
        GIR_EraseRootFromParent_Done,
      // Label 620: @21734
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(21779), // Rule ID 535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7231:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 535,
        GIR_EraseRootFromParent_Done,
      // Label 621: @21779
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(21824), // Rule ID 536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7234:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 536,
        GIR_EraseRootFromParent_Done,
      // Label 622: @21824
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(21869), // Rule ID 537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7236:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 537,
        GIR_EraseRootFromParent_Done,
      // Label 623: @21869
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(21914), // Rule ID 538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7237:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 538,
        GIR_EraseRootFromParent_Done,
      // Label 624: @21914
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(21959), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7235:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 539,
        GIR_EraseRootFromParent_Done,
      // Label 625: @21959
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(22004), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7238:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 540,
        GIR_EraseRootFromParent_Done,
      // Label 626: @22004
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(22049), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7240:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 541,
        GIR_EraseRootFromParent_Done,
      // Label 627: @22049
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(22094), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7241:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 542,
        GIR_EraseRootFromParent_Done,
      // Label 628: @22094
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(22139), // Rule ID 543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7239:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 543,
        GIR_EraseRootFromParent_Done,
      // Label 629: @22139
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(22184), // Rule ID 652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7373:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 652,
        GIR_EraseRootFromParent_Done,
      // Label 630: @22184
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(22229), // Rule ID 653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7374:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 653,
        GIR_EraseRootFromParent_Done,
      // Label 631: @22229
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(22274), // Rule ID 654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7372:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 654,
        GIR_EraseRootFromParent_Done,
      // Label 632: @22274
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(22319), // Rule ID 655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7376:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 655,
        GIR_EraseRootFromParent_Done,
      // Label 633: @22319
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(22364), // Rule ID 656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7377:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 656,
        GIR_EraseRootFromParent_Done,
      // Label 634: @22364
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(22409), // Rule ID 657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7375:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 657,
        GIR_EraseRootFromParent_Done,
      // Label 635: @22409
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(22454), // Rule ID 672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7415:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 672,
        GIR_EraseRootFromParent_Done,
      // Label 636: @22454
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(22499), // Rule ID 673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7414:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 673,
        GIR_EraseRootFromParent_Done,
      // Label 637: @22499
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(22544), // Rule ID 698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 7440:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 698,
        GIR_EraseRootFromParent_Done,
      // Label 638: @22544
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(22589), // Rule ID 699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7441:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 699,
        GIR_EraseRootFromParent_Done,
      // Label 639: @22589
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(22634), // Rule ID 726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7467:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 726,
        GIR_EraseRootFromParent_Done,
      // Label 640: @22634
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(22679), // Rule ID 727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7466:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 727,
        GIR_EraseRootFromParent_Done,
      // Label 641: @22679
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(22724), // Rule ID 728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7465:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 728,
        GIR_EraseRootFromParent_Done,
      // Label 642: @22724
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(22769), // Rule ID 729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7464:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 729,
        GIR_EraseRootFromParent_Done,
      // Label 643: @22769
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(22814), // Rule ID 730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7471:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 730,
        GIR_EraseRootFromParent_Done,
      // Label 644: @22814
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(22859), // Rule ID 731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7470:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 731,
        GIR_EraseRootFromParent_Done,
      // Label 645: @22859
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(22904), // Rule ID 732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7469:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 732,
        GIR_EraseRootFromParent_Done,
      // Label 646: @22904
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(22949), // Rule ID 733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7468:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 733,
        GIR_EraseRootFromParent_Done,
      // Label 647: @22949
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(22994), // Rule ID 744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7483:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 744,
        GIR_EraseRootFromParent_Done,
      // Label 648: @22994
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(23039), // Rule ID 745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7482:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 745,
        GIR_EraseRootFromParent_Done,
      // Label 649: @23039
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(23084), // Rule ID 746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7485:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 746,
        GIR_EraseRootFromParent_Done,
      // Label 650: @23084
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(23129), // Rule ID 747 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7484:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 747,
        GIR_EraseRootFromParent_Done,
      // Label 651: @23129
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(23174), // Rule ID 748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7487:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 748,
        GIR_EraseRootFromParent_Done,
      // Label 652: @23174
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(23219), // Rule ID 749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7486:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 749,
        GIR_EraseRootFromParent_Done,
      // Label 653: @23219
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(23264), // Rule ID 750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7489:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 750,
        GIR_EraseRootFromParent_Done,
      // Label 654: @23264
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(23309), // Rule ID 751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7488:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 751,
        GIR_EraseRootFromParent_Done,
      // Label 655: @23309
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(23354), // Rule ID 752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7491:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 752,
        GIR_EraseRootFromParent_Done,
      // Label 656: @23354
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(23399), // Rule ID 753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7490:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 753,
        GIR_EraseRootFromParent_Done,
      // Label 657: @23399
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(23444), // Rule ID 754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7493:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 754,
        GIR_EraseRootFromParent_Done,
      // Label 658: @23444
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(23489), // Rule ID 755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7492:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 755,
        GIR_EraseRootFromParent_Done,
      // Label 659: @23489
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(23534), // Rule ID 760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7499:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 760,
        GIR_EraseRootFromParent_Done,
      // Label 660: @23534
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(23579), // Rule ID 761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7498:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 761,
        GIR_EraseRootFromParent_Done,
      // Label 661: @23579
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(23624), // Rule ID 762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7501:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 762,
        GIR_EraseRootFromParent_Done,
      // Label 662: @23624
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(23669), // Rule ID 763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7500:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 763,
        GIR_EraseRootFromParent_Done,
      // Label 663: @23669
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(23714), // Rule ID 764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7503:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 764,
        GIR_EraseRootFromParent_Done,
      // Label 664: @23714
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(23759), // Rule ID 765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7502:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 765,
        GIR_EraseRootFromParent_Done,
      // Label 665: @23759
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(23804), // Rule ID 766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7505:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 766,
        GIR_EraseRootFromParent_Done,
      // Label 666: @23804
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(23849), // Rule ID 767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7504:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 767,
        GIR_EraseRootFromParent_Done,
      // Label 667: @23849
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(23894), // Rule ID 768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7507:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 768,
        GIR_EraseRootFromParent_Done,
      // Label 668: @23894
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(23939), // Rule ID 769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7506:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 769,
        GIR_EraseRootFromParent_Done,
      // Label 669: @23939
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(23984), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7512:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 774,
        GIR_EraseRootFromParent_Done,
      // Label 670: @23984
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(24029), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7513:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 775,
        GIR_EraseRootFromParent_Done,
      // Label 671: @24029
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(24074), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7519:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 780,
        GIR_EraseRootFromParent_Done,
      // Label 672: @24074
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(24119), // Rule ID 781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7520:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 781,
        GIR_EraseRootFromParent_Done,
      // Label 673: @24119
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(24164), // Rule ID 782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7518:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 782,
        GIR_EraseRootFromParent_Done,
      // Label 674: @24164
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(24209), // Rule ID 783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7522:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 783,
        GIR_EraseRootFromParent_Done,
      // Label 675: @24209
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(24254), // Rule ID 784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7523:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 784,
        GIR_EraseRootFromParent_Done,
      // Label 676: @24254
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(24299), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7521:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 785,
        GIR_EraseRootFromParent_Done,
      // Label 677: @24299
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(24344), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7525:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 786,
        GIR_EraseRootFromParent_Done,
      // Label 678: @24344
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(24389), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7526:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 787,
        GIR_EraseRootFromParent_Done,
      // Label 679: @24389
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(24434), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7524:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 788,
        GIR_EraseRootFromParent_Done,
      // Label 680: @24434
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(24479), // Rule ID 789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7528:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 789,
        GIR_EraseRootFromParent_Done,
      // Label 681: @24479
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(24524), // Rule ID 790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7529:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 790,
        GIR_EraseRootFromParent_Done,
      // Label 682: @24524
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(24569), // Rule ID 791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7527:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 791,
        GIR_EraseRootFromParent_Done,
      // Label 683: @24569
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(24614), // Rule ID 844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7583:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 844,
        GIR_EraseRootFromParent_Done,
      // Label 684: @24614
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(24659), // Rule ID 845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7585:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 845,
        GIR_EraseRootFromParent_Done,
      // Label 685: @24659
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(24704), // Rule ID 846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7586:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 846,
        GIR_EraseRootFromParent_Done,
      // Label 686: @24704
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(24749), // Rule ID 847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7584:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 847,
        GIR_EraseRootFromParent_Done,
      // Label 687: @24749
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(24794), // Rule ID 864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7603:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 864,
        GIR_EraseRootFromParent_Done,
      // Label 688: @24794
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(24839), // Rule ID 865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7605:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 865,
        GIR_EraseRootFromParent_Done,
      // Label 689: @24839
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(24884), // Rule ID 866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7606:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 866,
        GIR_EraseRootFromParent_Done,
      // Label 690: @24884
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(24929), // Rule ID 867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7604:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 867,
        GIR_EraseRootFromParent_Done,
      // Label 691: @24929
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(24974), // Rule ID 900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7645:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 900,
        GIR_EraseRootFromParent_Done,
      // Label 692: @24974
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(25019), // Rule ID 901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7646:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 901,
        GIR_EraseRootFromParent_Done,
      // Label 693: @25019
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(25064), // Rule ID 902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7656:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 902,
        GIR_EraseRootFromParent_Done,
      // Label 694: @25064
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(25109), // Rule ID 903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7657:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 903,
        GIR_EraseRootFromParent_Done,
      // Label 695: @25109
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(25154), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7770:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 981,
        GIR_EraseRootFromParent_Done,
      // Label 696: @25154
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(25199), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7772:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 982,
        GIR_EraseRootFromParent_Done,
      // Label 697: @25199
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(25244), // Rule ID 983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7773:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 983,
        GIR_EraseRootFromParent_Done,
      // Label 698: @25244
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(25289), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7771:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 984,
        GIR_EraseRootFromParent_Done,
      // Label 699: @25289
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(25334), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7786:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 997,
        GIR_EraseRootFromParent_Done,
      // Label 700: @25334
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(25379), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7788:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 998,
        GIR_EraseRootFromParent_Done,
      // Label 701: @25379
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(25424), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7789:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 999,
        GIR_EraseRootFromParent_Done,
      // Label 702: @25424
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(25469), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7787:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1000,
        GIR_EraseRootFromParent_Done,
      // Label 703: @25469
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(25514), // Rule ID 1009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7807:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1009,
        GIR_EraseRootFromParent_Done,
      // Label 704: @25514
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(25559), // Rule ID 1010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7809:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1010,
        GIR_EraseRootFromParent_Done,
      // Label 705: @25559
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(25604), // Rule ID 1011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7810:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1011,
        GIR_EraseRootFromParent_Done,
      // Label 706: @25604
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(25649), // Rule ID 1012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7808:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1012,
        GIR_EraseRootFromParent_Done,
      // Label 707: @25649
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(25694), // Rule ID 1013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7811:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1013,
        GIR_EraseRootFromParent_Done,
      // Label 708: @25694
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(25739), // Rule ID 1014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7813:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1014,
        GIR_EraseRootFromParent_Done,
      // Label 709: @25739
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(25784), // Rule ID 1015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7814:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1015,
        GIR_EraseRootFromParent_Done,
      // Label 710: @25784
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(25829), // Rule ID 1016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7812:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1016,
        GIR_EraseRootFromParent_Done,
      // Label 711: @25829
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(25874), // Rule ID 1017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7815:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1017,
        GIR_EraseRootFromParent_Done,
      // Label 712: @25874
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(25919), // Rule ID 1018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7817:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1018,
        GIR_EraseRootFromParent_Done,
      // Label 713: @25919
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(25964), // Rule ID 1019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7818:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1019,
        GIR_EraseRootFromParent_Done,
      // Label 714: @25964
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(26009), // Rule ID 1020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7816:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1020,
        GIR_EraseRootFromParent_Done,
      // Label 715: @26009
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(26054), // Rule ID 1021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7819:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1021,
        GIR_EraseRootFromParent_Done,
      // Label 716: @26054
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(26099), // Rule ID 1022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7821:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1022,
        GIR_EraseRootFromParent_Done,
      // Label 717: @26099
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(26144), // Rule ID 1023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7822:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1023,
        GIR_EraseRootFromParent_Done,
      // Label 718: @26144
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(26189), // Rule ID 1024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7820:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // ws
        GIR_RootToRootCopy, /*OpIdx*/3, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1024,
        GIR_EraseRootFromParent_Done,
      // Label 719: @26189
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(26237), // Rule ID 1223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7181:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1223,
        GIR_EraseRootFromParent_Done,
      // Label 720: @26237
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(26285), // Rule ID 1225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7203:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1225,
        GIR_EraseRootFromParent_Done,
      // Label 721: @26285
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(26330), // Rule ID 1246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7731:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1246,
        GIR_EraseRootFromParent_Done,
      // Label 722: @26330
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(26375), // Rule ID 1247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7733:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1247,
        GIR_EraseRootFromParent_Done,
      // Label 723: @26375
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(26420), // Rule ID 1248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7735:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1248,
        GIR_EraseRootFromParent_Done,
      // Label 724: @26420
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(26465), // Rule ID 1250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7737:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1250,
        GIR_EraseRootFromParent_Done,
      // Label 725: @26465
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(26513), // Rule ID 1261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7801:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1261,
        GIR_EraseRootFromParent_Done,
      // Label 726: @26513
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(26561), // Rule ID 1263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7826:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1263,
        GIR_EraseRootFromParent_Done,
      // Label 727: @26561
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(26606), // Rule ID 1273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7706:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1273,
        GIR_EraseRootFromParent_Done,
      // Label 728: @26606
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(26651), // Rule ID 1274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7707:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1274,
        GIR_EraseRootFromParent_Done,
      // Label 729: @26651
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(26696), // Rule ID 1293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7678:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1293,
        GIR_EraseRootFromParent_Done,
      // Label 730: @26696
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(26741), // Rule ID 1299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7631:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1299,
        GIR_EraseRootFromParent_Done,
      // Label 731: @26741
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(26786), // Rule ID 1312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7183:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1312,
        GIR_EraseRootFromParent_Done,
      // Label 732: @26786
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(26831), // Rule ID 1313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7184:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1313,
        GIR_EraseRootFromParent_Done,
      // Label 733: @26831
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(26876), // Rule ID 1314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7186:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1314,
        GIR_EraseRootFromParent_Done,
      // Label 734: @26876
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(26921), // Rule ID 1315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7185:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1315,
        GIR_EraseRootFromParent_Done,
      // Label 735: @26921
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(26966), // Rule ID 1318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7204:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1318,
        GIR_EraseRootFromParent_Done,
      // Label 736: @26966
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(27011), // Rule ID 1319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7205:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1319,
        GIR_EraseRootFromParent_Done,
      // Label 737: @27011
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(27056), // Rule ID 1325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7732:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1325,
        GIR_EraseRootFromParent_Done,
      // Label 738: @27056
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(27101), // Rule ID 1326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7734:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1326,
        GIR_EraseRootFromParent_Done,
      // Label 739: @27101
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(27146), // Rule ID 1331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7736:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1331,
        GIR_EraseRootFromParent_Done,
      // Label 740: @27146
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(27191), // Rule ID 1332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7803:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1332,
        GIR_EraseRootFromParent_Done,
      // Label 741: @27191
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(27236), // Rule ID 1333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7804:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1333,
        GIR_EraseRootFromParent_Done,
      // Label 742: @27236
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(27281), // Rule ID 1334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7806:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1334,
        GIR_EraseRootFromParent_Done,
      // Label 743: @27281
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(27326), // Rule ID 1335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7805:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1335,
        GIR_EraseRootFromParent_Done,
      // Label 744: @27326
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(27371), // Rule ID 1338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7827:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1338,
        GIR_EraseRootFromParent_Done,
      // Label 745: @27371
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(27416), // Rule ID 1339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7828:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1339,
        GIR_EraseRootFromParent_Done,
      // Label 746: @27416
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(27456), // Rule ID 1899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7180:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1899,
        GIR_EraseRootFromParent_Done,
      // Label 747: @27456
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(27496), // Rule ID 1901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7800:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1901,
        GIR_EraseRootFromParent_Done,
      // Label 748: @27496
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(27536), // Rule ID 1905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7201:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1905,
        GIR_EraseRootFromParent_Done,
      // Label 749: @27536
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(27576), // Rule ID 1907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7824:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1907,
        GIR_EraseRootFromParent_Done,
      // Label 750: @27576
      GIM_Reject,
    // Label 536: @27577
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(30091),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(27640), // Rule ID 477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7704:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 477,
        GIR_EraseRootFromParent_Done,
      // Label 752: @27640
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(27695), // Rule ID 478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7705:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 478,
        GIR_EraseRootFromParent_Done,
      // Label 753: @27695
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(27750), // Rule ID 483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7217:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 483,
        GIR_EraseRootFromParent_Done,
      // Label 754: @27750
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(27805), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[i32] } 7242:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 484,
        GIR_EraseRootFromParent_Done,
      // Label 755: @27805
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(27860), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7710:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 485,
        GIR_EraseRootFromParent_Done,
      // Label 756: @27860
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(27915), // Rule ID 953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7742:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 953,
        GIR_EraseRootFromParent_Done,
      // Label 757: @27915
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(27970), // Rule ID 954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7744:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 954,
        GIR_EraseRootFromParent_Done,
      // Label 758: @27970
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(28025), // Rule ID 955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7745:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 955,
        GIR_EraseRootFromParent_Done,
      // Label 759: @28025
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(28080), // Rule ID 956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt1),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7743:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // n
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 956,
        GIR_EraseRootFromParent_Done,
      // Label 760: @28080
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(28135), // Rule ID 1349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7704:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1349,
        GIR_EraseRootFromParent_Done,
      // Label 761: @28135
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(28190), // Rule ID 1350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7705:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1350,
        GIR_EraseRootFromParent_Done,
      // Label 762: @28190
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(28245), // Rule ID 1351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7710:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1351,
        GIR_EraseRootFromParent_Done,
      // Label 763: @28245
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(28300), // Rule ID 1352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7217:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_RootToRootCopy, /*OpIdx*/4, // sa
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1352,
        GIR_EraseRootFromParent_Done,
      // Label 764: @28300
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(28362), // Rule ID 1327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] bp
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7242:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1327,
        GIR_EraseRootFromParent_Done,
      // Label 765: @28362
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(28416), // Rule ID 552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7251:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 552,
        GIR_EraseRootFromParent_Done,
      // Label 766: @28416
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(28470), // Rule ID 553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7253:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 553,
        GIR_EraseRootFromParent_Done,
      // Label 767: @28470
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(28524), // Rule ID 554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7254:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 554,
        GIR_EraseRootFromParent_Done,
      // Label 768: @28524
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(28578), // Rule ID 555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7252:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 555,
        GIR_EraseRootFromParent_Done,
      // Label 769: @28578
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(28632), // Rule ID 560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7259:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 560,
        GIR_EraseRootFromParent_Done,
      // Label 770: @28632
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(28686), // Rule ID 561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7261:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 561,
        GIR_EraseRootFromParent_Done,
      // Label 771: @28686
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(28740), // Rule ID 562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7262:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 562,
        GIR_EraseRootFromParent_Done,
      // Label 772: @28740
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(28794), // Rule ID 563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7260:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 563,
        GIR_EraseRootFromParent_Done,
      // Label 773: @28794
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(28848), // Rule ID 658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7380:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 658,
        GIR_EraseRootFromParent_Done,
      // Label 774: @28848
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(28902), // Rule ID 659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7381:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 659,
        GIR_EraseRootFromParent_Done,
      // Label 775: @28902
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(28956), // Rule ID 660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7379:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 660,
        GIR_EraseRootFromParent_Done,
      // Label 776: @28956
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(29010), // Rule ID 661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7383:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 661,
        GIR_EraseRootFromParent_Done,
      // Label 777: @29010
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(29064), // Rule ID 662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7384:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 662,
        GIR_EraseRootFromParent_Done,
      // Label 778: @29064
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(29118), // Rule ID 663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7382:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 663,
        GIR_EraseRootFromParent_Done,
      // Label 779: @29118
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(29172), // Rule ID 664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7400:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 664,
        GIR_EraseRootFromParent_Done,
      // Label 780: @29172
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(29226), // Rule ID 665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7401:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 665,
        GIR_EraseRootFromParent_Done,
      // Label 781: @29226
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(29280), // Rule ID 666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7399:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 666,
        GIR_EraseRootFromParent_Done,
      // Label 782: @29280
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(29334), // Rule ID 667 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7403:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 667,
        GIR_EraseRootFromParent_Done,
      // Label 783: @29334
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(29388), // Rule ID 668 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7404:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 668,
        GIR_EraseRootFromParent_Done,
      // Label 784: @29388
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(29442), // Rule ID 669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7402:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 669,
        GIR_EraseRootFromParent_Done,
      // Label 785: @29442
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(29496), // Rule ID 836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7570:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 836,
        GIR_EraseRootFromParent_Done,
      // Label 786: @29496
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(29550), // Rule ID 837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7571:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 837,
        GIR_EraseRootFromParent_Done,
      // Label 787: @29550
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(29604), // Rule ID 838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7572:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 838,
        GIR_EraseRootFromParent_Done,
      // Label 788: @29604
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(29658), // Rule ID 839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7573:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 839,
        GIR_EraseRootFromParent_Done,
      // Label 789: @29658
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(29712), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7634:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 892,
        GIR_EraseRootFromParent_Done,
      // Label 790: @29712
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(29766), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7635:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 893,
        GIR_EraseRootFromParent_Done,
      // Label 791: @29766
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(29820), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7636:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUBR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 894,
        GIR_EraseRootFromParent_Done,
      // Label 792: @29820
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(29874), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7637:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUBR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 895,
        GIR_EraseRootFromParent_Done,
      // Label 793: @29874
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(29928), // Rule ID 949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7738:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_B),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 949,
        GIR_EraseRootFromParent_Done,
      // Label 794: @29928
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(29982), // Rule ID 950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7740:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 950,
        GIR_EraseRootFromParent_Done,
      // Label 795: @29982
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(30036), // Rule ID 951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7741:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 951,
        GIR_EraseRootFromParent_Done,
      // Label 796: @30036
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(30090), // Rule ID 952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7739:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLD_D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
        GIR_RootToRootCopy, /*OpIdx*/3, // ws
        GIR_RootToRootCopy, /*OpIdx*/4, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 952,
        GIR_EraseRootFromParent_Done,
      // Label 797: @30090
      GIM_Reject,
    // Label 751: @30091
    GIM_Reject,
    // Label 18: @30092
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(30123), // Rule ID 354 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bposge32),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (intrinsic_w_chain:{ *:[i32] } 7285:{ *:[iPTR] })  =>  (BPOSGE32_PSEUDO:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BPOSGE32_PSEUDO),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 354,
      GIR_EraseRootFromParent_Done,
    // Label 798: @30123
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(31060),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(30172), // Rule ID 441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_w_chain:{ *:[i32] } 7712:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (RDDSP:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RDDSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 441,
        GIR_EraseRootFromParent_Done,
      // Label 800: @30172
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(30208), // Rule ID 1287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 7712:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (RDDSP_MM:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RDDSP_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1287,
        GIR_EraseRootFromParent_Done,
      // Label 801: @30208
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(30249), // Rule ID 442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_NotInMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_void 7841:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (WRDSP GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::WRDSP),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 442,
        GIR_EraseRootFromParent_Done,
      // Label 802: @30249
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(30285), // Rule ID 1298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 7841:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (WRDSP_MM GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] }):$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::WRDSP_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1298,
        GIR_EraseRootFromParent_Done,
      // Label 803: @30285
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(30328), // Rule ID 363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7173:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ABSQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 363,
        GIR_EraseRootFromParent_Done,
      // Label 804: @30328
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(30371), // Rule ID 364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7175:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ABSQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 364,
        GIR_EraseRootFromParent_Done,
      // Label 805: @30371
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(30414), // Rule ID 450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7174:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ABSQ_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 450,
        GIR_EraseRootFromParent_Done,
      // Label 806: @30414
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(30457), // Rule ID 1230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7173:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (ABSQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1230,
        GIR_EraseRootFromParent_Done,
      // Label 807: @30457
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(30500), // Rule ID 1231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7175:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (ABSQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1231,
        GIR_EraseRootFromParent_Done,
      // Label 808: @30500
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(30543), // Rule ID 1311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7174:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (ABSQ_S_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1311,
        GIR_EraseRootFromParent_Done,
      // Label 809: @30543
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(30586), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7351:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 417,
        GIR_EraseRootFromParent_Done,
      // Label 810: @30586
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(30629), // Rule ID 418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7353:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 418,
        GIR_EraseRootFromParent_Done,
      // Label 811: @30629
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(30672), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7352:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 419,
        GIR_EraseRootFromParent_Done,
      // Label 812: @30672
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(30715), // Rule ID 423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7342:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 423,
        GIR_EraseRootFromParent_Done,
      // Label 813: @30715
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(30758), // Rule ID 424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7344:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 424,
        GIR_EraseRootFromParent_Done,
      // Label 814: @30758
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(30801), // Rule ID 425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7343:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 425,
        GIR_EraseRootFromParent_Done,
      // Label 815: @30801
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(30844), // Rule ID 1302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7342:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1302,
        GIR_EraseRootFromParent_Done,
      // Label 816: @30844
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(30887), // Rule ID 1303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7344:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1303,
        GIR_EraseRootFromParent_Done,
      // Label 817: @30887
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(30930), // Rule ID 1304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7343:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1304,
        GIR_EraseRootFromParent_Done,
      // Label 818: @30930
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(30973), // Rule ID 1308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7351:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1308,
        GIR_EraseRootFromParent_Done,
      // Label 819: @30973
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(31016), // Rule ID 1309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7353:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1309,
        GIR_EraseRootFromParent_Done,
      // Label 820: @31016
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(31059), // Rule ID 1310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7352:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/1, // rs
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1310,
        GIR_EraseRootFromParent_Done,
      // Label 821: @31059
      GIM_Reject,
    // Label 799: @31060
    GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(34749),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(31132), // Rule ID 382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7729:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHLL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 382,
        GIR_EraseRootFromParent_Done,
      // Label 823: @31132
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(31196), // Rule ID 387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i32] } 7730:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHLL_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 387,
        GIR_EraseRootFromParent_Done,
      // Label 824: @31196
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(31260), // Rule ID 1239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7729:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHLL_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1239,
        GIR_EraseRootFromParent_Done,
      // Label 825: @31260
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(31324), // Rule ID 1244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i32] } 7730:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHLL_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1244,
        GIR_EraseRootFromParent_Done,
      // Label 826: @31324
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(31379), // Rule ID 1916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7727:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHLL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1916,
        GIR_EraseRootFromParent_Done,
      // Label 827: @31379
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(31434), // Rule ID 1922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v4i8] } 7728:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHLL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLL_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1922,
        GIR_EraseRootFromParent_Done,
      // Label 828: @31434
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(31486), // Rule ID 359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7182:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 359,
        GIR_EraseRootFromParent_Done,
      // Label 829: @31486
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(31538), // Rule ID 360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7802:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 360,
        GIR_EraseRootFromParent_Done,
      // Label 830: @31538
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(31590), // Rule ID 367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7708:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 367,
        GIR_EraseRootFromParent_Done,
      // Label 831: @31590
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(31642), // Rule ID 368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7709:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 368,
        GIR_EraseRootFromParent_Done,
      // Label 832: @31642
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(31694), // Rule ID 379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7728:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 379,
        GIR_EraseRootFromParent_Done,
      // Label 833: @31694
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(31746), // Rule ID 381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7727:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 381,
        GIR_EraseRootFromParent_Done,
      // Label 834: @31746
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(31798), // Rule ID 383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7729:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 383,
        GIR_EraseRootFromParent_Done,
      // Label 835: @31798
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(31850), // Rule ID 388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7730:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 388,
        GIR_EraseRootFromParent_Done,
      // Label 836: @31850
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(31902), // Rule ID 391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7650:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 391,
        GIR_EraseRootFromParent_Done,
      // Label 837: @31902
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(31954), // Rule ID 392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7651:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 392,
        GIR_EraseRootFromParent_Done,
      // Label 838: @31954
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(32006), // Rule ID 393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7648:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 393,
        GIR_EraseRootFromParent_Done,
      // Label 839: @32006
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(32058), // Rule ID 394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7649:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 394,
        GIR_EraseRootFromParent_Done,
      // Label 840: @32058
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(32110), // Rule ID 395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7652:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 395,
        GIR_EraseRootFromParent_Done,
      // Label 841: @32110
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(32159), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7348:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 420,
        GIR_EraseRootFromParent_Done,
      // Label 842: @32159
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(32208), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7350:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 421,
        GIR_EraseRootFromParent_Done,
      // Label 843: @32208
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(32257), // Rule ID 422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7349:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 422,
        GIR_EraseRootFromParent_Done,
      // Label 844: @32257
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(32306), // Rule ID 432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7692:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 432,
        GIR_EraseRootFromParent_Done,
      // Label 845: @32306
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(32355), // Rule ID 433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7691:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 433,
        GIR_EraseRootFromParent_Done,
      // Label 846: @32355
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(32404), // Rule ID 437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7550:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::INSV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 437,
        GIR_EraseRootFromParent_Done,
      // Label 847: @32404
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(32456), // Rule ID 443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7200:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 443,
        GIR_EraseRootFromParent_Done,
      // Label 848: @32456
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(32508), // Rule ID 444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7202:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 444,
        GIR_EraseRootFromParent_Done,
      // Label 849: @32508
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(32560), // Rule ID 445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7823:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 445,
        GIR_EraseRootFromParent_Done,
      // Label 850: @32560
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(32612), // Rule ID 446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7825:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 446,
        GIR_EraseRootFromParent_Done,
      // Label 851: @32612
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(32664), // Rule ID 447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7345:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 447,
        GIR_EraseRootFromParent_Done,
      // Label 852: @32664
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(32716), // Rule ID 448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7347:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 448,
        GIR_EraseRootFromParent_Done,
      // Label 853: @32716
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(32768), // Rule ID 449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7346:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 449,
        GIR_EraseRootFromParent_Done,
      // Label 854: @32768
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(32820), // Rule ID 463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7647:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 463,
        GIR_EraseRootFromParent_Done,
      // Label 855: @32820
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(32872), // Rule ID 464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7655:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 464,
        GIR_EraseRootFromParent_Done,
      // Label 856: @32872
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(32924), // Rule ID 465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7653:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 465,
        GIR_EraseRootFromParent_Done,
      // Label 857: @32924
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(32976), // Rule ID 466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7654:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 466,
        GIR_EraseRootFromParent_Done,
      // Label 858: @32976
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(33025), // Rule ID 476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7703:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 476,
        GIR_EraseRootFromParent_Done,
      // Label 859: @33025
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(33077), // Rule ID 1224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7182:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1224,
        GIR_EraseRootFromParent_Done,
      // Label 860: @33077
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(33126), // Rule ID 1232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7550:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::INSV_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1232,
        GIR_EraseRootFromParent_Done,
      // Label 861: @33126
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(33178), // Rule ID 1240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7727:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1240,
        GIR_EraseRootFromParent_Done,
      // Label 862: @33178
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(33230), // Rule ID 1241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7729:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1241,
        GIR_EraseRootFromParent_Done,
      // Label 863: @33230
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(33282), // Rule ID 1242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7728:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1242,
        GIR_EraseRootFromParent_Done,
      // Label 864: @33282
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(33334), // Rule ID 1243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7730:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rt
        GIR_RootToRootCopy, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1243,
        GIR_EraseRootFromParent_Done,
      // Label 865: @33334
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(33386), // Rule ID 1262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7802:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1262,
        GIR_EraseRootFromParent_Done,
      // Label 866: @33386
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(33438), // Rule ID 1268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7648:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1268,
        GIR_EraseRootFromParent_Done,
      // Label 867: @33438
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(33490), // Rule ID 1269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7649:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1269,
        GIR_EraseRootFromParent_Done,
      // Label 868: @33490
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(33542), // Rule ID 1270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7650:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1270,
        GIR_EraseRootFromParent_Done,
      // Label 869: @33542
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(33594), // Rule ID 1271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7651:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1271,
        GIR_EraseRootFromParent_Done,
      // Label 870: @33594
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(33646), // Rule ID 1272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7652:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1272,
        GIR_EraseRootFromParent_Done,
      // Label 871: @33646
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(33698), // Rule ID 1275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7709:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1275,
        GIR_EraseRootFromParent_Done,
      // Label 872: @33698
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(33750), // Rule ID 1276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7708:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1276,
        GIR_EraseRootFromParent_Done,
      // Label 873: @33750
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(33799), // Rule ID 1294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7691:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_PH_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1294,
        GIR_EraseRootFromParent_Done,
      // Label 874: @33799
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(33848), // Rule ID 1295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7692:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PICK_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1295,
        GIR_EraseRootFromParent_Done,
      // Label 875: @33848
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(33897), // Rule ID 1305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7348:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1305,
        GIR_EraseRootFromParent_Done,
      // Label 876: @33897
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(33946), // Rule ID 1306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7350:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1306,
        GIR_EraseRootFromParent_Done,
      // Label 877: @33946
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(33995), // Rule ID 1307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7349:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1307,
        GIR_EraseRootFromParent_Done,
      // Label 878: @33995
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(34047), // Rule ID 1316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7200:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1316,
        GIR_EraseRootFromParent_Done,
      // Label 879: @34047
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(34099), // Rule ID 1317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7202:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1317,
        GIR_EraseRootFromParent_Done,
      // Label 880: @34099
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(34151), // Rule ID 1328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7345:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1328,
        GIR_EraseRootFromParent_Done,
      // Label 881: @34151
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(34203), // Rule ID 1329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7347:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1329,
        GIR_EraseRootFromParent_Done,
      // Label 882: @34203
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(34255), // Rule ID 1330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7346:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1330,
        GIR_EraseRootFromParent_Done,
      // Label 883: @34255
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(34307), // Rule ID 1336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7823:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1336,
        GIR_EraseRootFromParent_Done,
      // Label 884: @34307
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(34359), // Rule ID 1337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7825:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1337,
        GIR_EraseRootFromParent_Done,
      // Label 885: @34359
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(34411), // Rule ID 1344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7647:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1344,
        GIR_EraseRootFromParent_Done,
      // Label 886: @34411
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(34463), // Rule ID 1345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7653:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1345,
        GIR_EraseRootFromParent_Done,
      // Label 887: @34463
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(34515), // Rule ID 1346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7654:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1346,
        GIR_EraseRootFromParent_Done,
      // Label 888: @34515
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(34567), // Rule ID 1347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7655:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1347,
        GIR_EraseRootFromParent_Done,
      // Label 889: @34567
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(34616), // Rule ID 1348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7703:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH_MMR2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // rs
        GIR_RootToRootCopy, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1348,
        GIR_EraseRootFromParent_Done,
      // Label 890: @34616
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(34660), // Rule ID 1903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_ph),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7644:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1903,
        GIR_EraseRootFromParent_Done,
      // Label 891: @34660
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(34704), // Rule ID 1909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addsc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7199:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDSC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDSC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCarry*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1909,
        GIR_EraseRootFromParent_Done,
      // Label 892: @34704
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(34748), // Rule ID 1911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addwc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7214:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDWC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDWC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1911,
        GIR_EraseRootFromParent_Done,
      // Label 893: @34748
      GIM_Reject,
    // Label 822: @34749
    GIM_Reject,
    // Label 19: @34750
    GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(34815), // Rule ID 1578 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1578,
      GIR_EraseRootFromParent_Done,
    // Label 894: @34815
    GIM_Reject,
    // Label 20: @34816
    GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(34879), // Rule ID 1573 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$src)  =>  (SLL:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$src, sub_32:{ *:[i32] }), 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1573,
      GIR_EraseRootFromParent_Done,
    // Label 895: @34879
    GIM_Reject,
    // Label 21: @34880
    GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(34940),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(34914), // Rule ID 2134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immLi16),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm  =>  (LI16_MM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LI16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2134,
        GIR_EraseRootFromParent_Done,
      // Label 897: @34914
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(34939), // Rule ID 1827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] }):$imm  =>  (LwConstant32:{ *:[i32] } (imm:{ *:[i32] }):$imm, -1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LwConstant32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1827,
        GIR_EraseRootFromParent_Done,
      // Label 898: @34939
      GIM_Reject,
    // Label 896: @34940
    GIM_Reject,
    // Label 22: @34941
    GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(36404),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(35061), // Rule ID 1612 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRA:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRA),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1612,
        GIR_EraseRootFromParent_Done,
      // Label 900: @35061
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(35166), // Rule ID 1610 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1610,
        GIR_EraseRootFromParent_Done,
      // Label 901: @35166
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(35271), // Rule ID 1608 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SLL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1608,
        GIR_EraseRootFromParent_Done,
      // Label 902: @35271
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(35370), // Rule ID 1603 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (ADDu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::ADDu),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1603,
        GIR_EraseRootFromParent_Done,
      // Label 903: @35370
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(35469), // Rule ID 1613 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRAV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRAV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1613,
        GIR_EraseRootFromParent_Done,
      // Label 904: @35469
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(35568), // Rule ID 1611 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRLV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1611,
        GIR_EraseRootFromParent_Done,
      // Label 905: @35568
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(35676), // Rule ID 1605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32_HasStdEnc_NotMips32r6_NotMips64r6),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (mul:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MUL:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MUL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/2, /*OpIdx for Mips::HI0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/2, /*OpIdx for Mips::LO0*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1605,
        GIR_EraseRootFromParent_Done,
      // Label 906: @35676
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(35778), // Rule ID 1794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (mul:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MUL_R6:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1794,
        GIR_EraseRootFromParent_Done,
      // Label 907: @35778
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(35880), // Rule ID 1795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::DIV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1795,
        GIR_EraseRootFromParent_Done,
      // Label 908: @35880
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(35979), // Rule ID 1609 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SLLV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1609,
        GIR_EraseRootFromParent_Done,
      // Label 909: @35979
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(36081), // Rule ID 1797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (srem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MOD:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MOD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1797,
        GIR_EraseRootFromParent_Done,
      // Label 910: @36081
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(36180), // Rule ID 1604 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (sub:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SUBu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SUBu),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1604,
        GIR_EraseRootFromParent_Done,
      // Label 911: @36180
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(36282), // Rule ID 1796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIVU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::DIVU),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1796,
        GIR_EraseRootFromParent_Done,
      // Label 912: @36282
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(36384), // Rule ID 1798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sext:{ *:[i64] } (urem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MODU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MODU),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        // GIR_Coverage, 1798,
        GIR_EraseRootFromParent_Done,
      // Label 913: @36384
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(36403), // Rule ID 1580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL64_32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1580,
        GIR_Done,
      // Label 914: @36403
      GIM_Reject,
    // Label 899: @36404
    GIM_Reject,
    // Label 23: @36405
    GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(36605),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(36476), // Rule ID 280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }))  =>  (SEQ:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SEQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 280,
        GIR_EraseRootFromParent_Done,
      // Label 916: @36476
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(36532), // Rule ID 282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }))  =>  (SNE:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SNE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 282,
        GIR_EraseRootFromParent_Done,
      // Label 917: @36532
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(36604),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(36580), // Rule ID 1579 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DSRL:{ *:[i64] } (DSLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::DSLL64_32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DSRL),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 1579,
          GIR_EraseRootFromParent_Done,
        // Label 919: @36580
        GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(36603), // Rule ID 1581 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips),
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DEXT64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src, 0:{ *:[i32] }, 32:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DEXT64_32),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
          GIR_RootToRootCopy, /*OpIdx*/1, // src
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 1581,
          GIR_EraseRootFromParent_Done,
        // Label 920: @36603
        GIM_Reject,
      // Label 918: @36604
      GIM_Reject,
    // Label 915: @36605
    GIM_Reject,
    // Label 24: @36606
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 927*/ GIMT_Encode4(38402),
    /*GILLT_s32*//*Label 921*/ GIMT_Encode4(36649),
    /*GILLT_s64*//*Label 922*/ GIMT_Encode4(36911), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 923*/ GIMT_Encode4(37052), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 924*/ GIMT_Encode4(37086),
    /*GILLT_v8s16*//*Label 925*/ GIMT_Encode4(37354),
    /*GILLT_v16s8*//*Label 926*/ GIMT_Encode4(37750),
    // Label 921: @36649
    GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(36910),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(36702), // Rule ID 55 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SLL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 55,
        GIR_EraseRootFromParent_Done,
      // Label 929: @36702
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(36744), // Rule ID 1809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SllX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SllX16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1809,
        GIR_EraseRootFromParent_Done,
      // Label 930: @36744
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(36786), // Rule ID 2146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Shift),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SLL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL16_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2146,
        GIR_EraseRootFromParent_Done,
      // Label 931: @36786
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(36828), // Rule ID 2147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SLL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL_MM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2147,
        GIR_EraseRootFromParent_Done,
      // Label 932: @36828
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(36855), // Rule ID 61 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SLLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLLV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61,
        GIR_Done,
      // Label 933: @36855
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(36882), // Rule ID 1812 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SllvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SllvRxRy16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1812,
        GIR_Done,
      // Label 934: @36882
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(36909), // Rule ID 2148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SLLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLLV_MM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2148,
        GIR_Done,
      // Label 935: @36909
      GIM_Reject,
    // Label 928: @36910
    GIM_Reject,
    // Label 922: @36911
    GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(37051),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(36964), // Rule ID 210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt6),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSLL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DSLL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 210,
        GIR_EraseRootFromParent_Done,
      // Label 937: @36964
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(37031), // Rule ID 1574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (shl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSLLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DSLLV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // rt
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1574,
        GIR_EraseRootFromParent_Done,
      // Label 938: @37031
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(37050), // Rule ID 216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSLLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSLLV),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 216,
        GIR_Done,
      // Label 939: @37050
      GIM_Reject,
    // Label 936: @37051
    GIM_Reject,
    // Label 923: @37052
    GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(37085), // Rule ID 960 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (shl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SLL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 960,
      GIR_Done,
    // Label 940: @37085
    GIM_Reject,
    // Label 924: @37086
    GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(37353),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(37215), // Rule ID 2438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2438,
        GIR_EraseRootFromParent_Done,
      // Label 942: @37215
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(37329), // Rule ID 2049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2049,
        GIR_EraseRootFromParent_Done,
      // Label 943: @37329
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(37352), // Rule ID 959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (shl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SLL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 944: @37352
      GIM_Reject,
    // Label 941: @37353
    GIM_Reject,
    // Label 925: @37354
    GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(37749),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(37547), // Rule ID 2437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2437,
        GIR_EraseRootFromParent_Done,
      // Label 946: @37547
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(37725), // Rule ID 2048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
        GIR_RootToRootCopy, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2048,
        GIR_EraseRootFromParent_Done,
      // Label 947: @37725
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(37748), // Rule ID 958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (shl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SLL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 958,
        GIR_Done,
      // Label 948: @37748
      GIM_Reject,
    // Label 945: @37749
    GIM_Reject,
    // Label 926: @37750
    GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(38401),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(38071), // Rule ID 2436 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[13] Operand 1
        // No operand predicates
       