#[derive(Clone, Hash)] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:426
/// Flags group `pulley`.
pub struct Flags {
    bytes: [u8; 2], // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:429
}
impl Flags {
    /// Create flags pulley settings group.
    #[allow(unused_variables)] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:26
    pub fn new(shared: &settings::Flags, builder: &Builder) -> Self {
        let bvec = builder.state_for("pulley"); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:28
        let mut pulley = Self { bytes: [0; 2] }; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:29
        debug_assert_eq!(bvec.len(), 2); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:35
        pulley.bytes[0..2].copy_from_slice(&bvec); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:40
        pulley // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:61
    }
}
impl Flags {
    /// Iterates the setting values.
    pub fn iter(&self) -> impl Iterator<Item = Value> + use<> {
        let mut bytes = [0; 2]; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:71
        bytes.copy_from_slice(&self.bytes[0..2]); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:72
        DESCRIPTORS.iter().filter_map(move |d| {
            let values = match &d.detail {
                detail::Detail::Preset => return None, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:75
                detail::Detail::Enum { last, enumerators } => Some(TEMPLATE.enums(*last, *enumerators)), // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:76
                _ => None // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:77
            }
            ; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:79
            Some(Value { name: d.name, detail: d.detail, values, value: bytes[d.offset as usize] }) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:80
        }
        ) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:82
    }
}
/// Values for `pulley.pointer_width`.
#[derive(Debug, Copy, Clone, PartialEq, Eq, Hash)] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:144
pub enum PointerWidth {
    /// `pointer32`.
    Pointer32, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:148
    /// `pointer64`.
    Pointer64, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:148
}
impl PointerWidth {
    /// Returns a slice with all possible [PointerWidth] values. // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:89
    pub fn all() -> &'static [PointerWidth] {
        &[ // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:95
            Self::Pointer32, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:98
            Self::Pointer64, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:98
        ] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:101
    }
}
impl fmt::Display for PointerWidth {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(match *self {
            Self::Pointer32 => "pointer32", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:113
            Self::Pointer64 => "pointer64", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:113
        }
        ) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:116
    }
}
impl core::str::FromStr for PointerWidth {
    type Err = (); // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:122
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "pointer32" => Ok(Self::Pointer32), // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:126
            "pointer64" => Ok(Self::Pointer64), // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:126
            _ => Err(()), // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:128
        }
    }
}
/// User-defined settings.
#[allow(dead_code)] // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:206
impl Flags {
    /// Get a view of the boolean predicates.
    pub fn predicate_view(&self) -> crate::settings::PredicateView<'_> {
        crate::settings::PredicateView::new(&self.bytes[1..]) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:212
    }
    /// Dynamic numbered predicate getter.
    fn numbered_predicate(&self, p: usize) -> bool {
        self.bytes[1 + p / 8] & (1 << (p % 8)) != 0 // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:223
    }
    /// The width of pointers for this Pulley target
    /// Supported values:
    /// * 'pointer32'
    /// * 'pointer64'
    pub fn pointer_width(&self) -> PointerWidth {
        match self.bytes[0] {
            0 => {
                PointerWidth::Pointer32
            }
            1 => {
                PointerWidth::Pointer64
            }
            _ => {
                panic!("Invalid enum value")
            }
        }
    }
    /// Whether this is a big-endian target
    /// Whether this is a big-endian target
    pub fn big_endian(&self) -> bool {
        self.numbered_predicate(0) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:168
    }
}
static DESCRIPTORS: [detail::Descriptor; 2] = [ // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:262
    detail::Descriptor {
        name: "pointer_width", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:270
        description: "The width of pointers for this Pulley target", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:271
        offset: 0, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:272
        detail: detail::Detail::Enum { last: 1, enumerators: 0 }, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:283
    }
    , // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:297
    detail::Descriptor {
        name: "big_endian", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:270
        description: "Whether this is a big-endian target", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:271
        offset: 1, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:272
        detail: detail::Detail::Bool { bit: 0 }, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:275
    }
    , // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:297
]; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:313
static ENUMERATORS: [&str; 2] = [ // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:316
    "pointer32", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:319
    "pointer64", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:319
]; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:322
static HASH_TABLE: [u16; 4] = [ // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:332
    0xffff, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:344
    0, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:336
    1, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:336
    0xffff, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:344
]; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:348
static PRESETS: [(u8, u8); 0] = [ // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:351
]; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:368
static TEMPLATE: detail::Template = detail::Template {
    name: "pulley", // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:383
    descriptors: &DESCRIPTORS, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:384
    enumerators: &ENUMERATORS, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:385
    hash_table: &HASH_TABLE, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:386
    defaults: &[0x00, 0x00], // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:387
    presets: &PRESETS, // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:388
}
; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:391
/// Create a `settings::Builder` for the pulley settings group.
pub fn builder() -> Builder {
    Builder::new(&TEMPLATE) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:398
}
impl fmt::Display for Flags {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        writeln!(f, "[pulley]")?; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:407
        for d in &DESCRIPTORS {
            if !d.detail.is_preset() {
                write!(f, "{} = ", d.name)?; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:410
                TEMPLATE.format_toml_value(d.detail, self.bytes[d.offset as usize], f)?; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:411
                writeln!(f)?; // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:415
            }
        }
        Ok(()) // /build/.cargo/registry/src/index.crates.io-1949cf8c6b5b557f/cranelift-codegen-meta-0.122.0/src/gen_settings.rs:418
    }
}
