/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/MDRHighLevel/MDRHighLevel.hpp"
// clang-format off
namespace mgard_x {
namespace MDR {

template void MDRefactor<OPENMP>(DIM D, data_type dtype, std::vector<SIZE> shape, const void *original_data,
          RefactoredMetadata &refactored_metadata,
          RefactoredData &refactored_data,
          Config config, bool output_pre_allocated);

template void MDRefactor<OPENMP>(DIM D, data_type dtype, std::vector<SIZE> shape, const void *original_data,
          std::vector<const Byte *> coords, RefactoredMetadata &refactored_metadata,
          RefactoredData &refactored_data,
          Config config, bool output_pre_allocated);

template void MDRequest<OPENMP>(RefactoredMetadata &refactored_metadata);

template SIZE MDRMaxOutputDataSize<OPENMP>(DIM D, data_type dtype, std::vector<SIZE> shape, Config config);

template void MDReconstruct<OPENMP>(RefactoredMetadata &refactored_metadata,
                  RefactoredData &refactored_data,
                  ReconstructedData &reconstructed_data, Config config,
                  bool output_pre_allocated);

template void release_cache<OPENMP>();
}
} // namespace mgard_x
// clang-format on
