/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Definitions                                                   *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RockAttrDefs.td                                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace rock {
::llvm::StringRef getNameForConvOpType(ConvOpType val) {
  switch (val) {
    case ConvOpType::Fwd: return "conv";
    case ConvOpType::BwdData: return "conv_bwd_data";
    case ConvOpType::BwdWeight: return "conv_bwd_weight";
  }
  return "";
}

::std::optional<ConvOpType> getConvOpTypeForName(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<ConvOpType>>(str)
      .Case("conv", ConvOpType::Fwd)
      .Case("conv_bwd_data", ConvOpType::BwdData)
      .Case("conv_bwd_weight", ConvOpType::BwdWeight)
      .Default(::std::nullopt);
}
::std::optional<ConvOpType> symbolizeConvOpType(uint32_t value) {
  switch (value) {
  case 0: return ConvOpType::Fwd;
  case 1: return ConvOpType::BwdData;
  case 2: return ConvOpType::BwdWeight;
  default: return ::std::nullopt;
  }
}

} // namespace rock
} // namespace mlir

namespace mlir {
namespace rock {
::llvm::StringRef getNameForKernelType(KernelType val) {
  switch (val) {
    case KernelType::Conv: return "Conv";
    case KernelType::ConvBwdData: return "ConvBwdData";
    case KernelType::ConvBwdWeight: return "ConvBwdWeight";
    case KernelType::Gemm: return "Gemm";
    case KernelType::Attention: return "Attention";
  }
  return "";
}

::std::optional<KernelType> getKernelTypeForName(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<KernelType>>(str)
      .Case("Conv", KernelType::Conv)
      .Case("ConvBwdData", KernelType::ConvBwdData)
      .Case("ConvBwdWeight", KernelType::ConvBwdWeight)
      .Case("Gemm", KernelType::Gemm)
      .Case("Attention", KernelType::Attention)
      .Default(::std::nullopt);
}
::std::optional<KernelType> symbolizeKernelType(uint32_t value) {
  switch (value) {
  case 0: return KernelType::Conv;
  case 1: return KernelType::ConvBwdData;
  case 2: return KernelType::ConvBwdWeight;
  case 3: return KernelType::Gemm;
  case 4: return KernelType::Attention;
  default: return ::std::nullopt;
  }
}

} // namespace rock
} // namespace mlir

namespace mlir {
namespace rock {
::llvm::StringRef getNameForReduceMethod(ReduceMethod val) {
  switch (val) {
    case ReduceMethod::Sum: return "sum";
    case ReduceMethod::Max: return "max";
  }
  return "";
}

::std::optional<ReduceMethod> getReduceMethodForName(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<ReduceMethod>>(str)
      .Case("sum", ReduceMethod::Sum)
      .Case("max", ReduceMethod::Max)
      .Default(::std::nullopt);
}
::std::optional<ReduceMethod> symbolizeReduceMethod(uint32_t value) {
  switch (value) {
  case 0: return ReduceMethod::Sum;
  case 1: return ReduceMethod::Max;
  default: return ::std::nullopt;
  }
}

} // namespace rock
} // namespace mlir

namespace mlir {
namespace rock {
std::string stringifyGemmFeatures(GemmFeatures symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(311u == (311u | val) && "invalid bits set in bit enum");
  // Special case for all bits unset.
  if (val == 0) return "none";

  ::llvm::SmallVector<::llvm::StringRef, 2> strs;

  if (1u == (1u & val))
    strs.push_back("mfma");

  if (2u == (2u & val))
    strs.push_back("dot");

  if (4u == (4u & val))
    strs.push_back("atomic_add");

  if (16u == (16u & val))
    strs.push_back("atomic_fmax_f32");

  if (256u == (256u & val))
    strs.push_back("atomic_add_f16");

  if (32u == (32u & val))
    strs.push_back("wmma");
  return ::llvm::join(strs, "|");
}

::std::optional<GemmFeatures> symbolizeGemmFeatures(::llvm::StringRef str) {
  // Special case for all bits unset.
  if (str == "none") return GemmFeatures::none;

  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, "|");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("mfma", 1)
      .Case("dot", 2)
      .Case("atomic_add", 4)
      .Case("atomic_fmax_f32", 16)
      .Case("atomic_add_f16", 256)
      .Case("wmma", 32)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<GemmFeatures>(val);
}

::std::optional<GemmFeatures> symbolizeGemmFeatures(uint32_t value) {
  // Special case for all bits unset.
  if (value == 0) return GemmFeatures::none;

  if (value & ~static_cast<uint32_t>(311u)) return std::nullopt;
  return static_cast<GemmFeatures>(value);
}
} // namespace rock
} // namespace mlir

namespace mlir {
namespace rock {
::llvm::StringRef getNameForStoreMethod(StoreMethod val) {
  switch (val) {
    case StoreMethod::Set: return "set";
    case StoreMethod::AtomicAdd: return "atomic_add";
    case StoreMethod::AtomicMax: return "atomic_max";
  }
  return "";
}

::std::optional<StoreMethod> getStoreMethodForName(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<StoreMethod>>(str)
      .Case("set", StoreMethod::Set)
      .Case("atomic_add", StoreMethod::AtomicAdd)
      .Case("atomic_max", StoreMethod::AtomicMax)
      .Default(::std::nullopt);
}
::std::optional<StoreMethod> symbolizeStoreMethod(uint32_t value) {
  switch (value) {
  case 0: return StoreMethod::Set;
  case 1: return StoreMethod::AtomicAdd;
  case 2: return StoreMethod::AtomicMax;
  default: return ::std::nullopt;
  }
}

} // namespace rock
} // namespace mlir

namespace mlir {
namespace rock {
::llvm::StringRef getNameForTransformType(TransformType val) {
  switch (val) {
    case TransformType::PassThrough: return "PassThrough";
    case TransformType::Pad: return "Pad";
    case TransformType::Slice: return "Slice";
    case TransformType::Embed: return "Embed";
    case TransformType::Unmerge: return "Unmerge";
    case TransformType::Merge: return "Merge";
    case TransformType::AddDim: return "AddDim";
    case TransformType::Broadcast: return "Broadcast";
    case TransformType::ConstDim: return "ConstDim";
  }
  return "";
}

::std::optional<TransformType> getTransformTypeForName(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<TransformType>>(str)
      .Case("PassThrough", TransformType::PassThrough)
      .Case("Pad", TransformType::Pad)
      .Case("Slice", TransformType::Slice)
      .Case("Embed", TransformType::Embed)
      .Case("Unmerge", TransformType::Unmerge)
      .Case("Merge", TransformType::Merge)
      .Case("AddDim", TransformType::AddDim)
      .Case("Broadcast", TransformType::Broadcast)
      .Case("ConstDim", TransformType::ConstDim)
      .Default(::std::nullopt);
}
::std::optional<TransformType> symbolizeTransformType(uint32_t value) {
  switch (value) {
  case 0: return TransformType::PassThrough;
  case 1: return TransformType::Pad;
  case 2: return TransformType::Slice;
  case 3: return TransformType::Embed;
  case 4: return TransformType::Unmerge;
  case 5: return TransformType::Merge;
  case 7: return TransformType::AddDim;
  case 8: return TransformType::Broadcast;
  case 9: return TransformType::ConstDim;
  default: return ::std::nullopt;
  }
}

} // namespace rock
} // namespace mlir

