/* relevancy-backend-zg.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from relevancy-backend-zg.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include "slingshot.h"
#include <zeitgeist.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>
#include <gio/gdesktopappinfo.h>

#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER 65535.0f
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND (synapse_zeitgeist_relevancy_backend_get_type ())
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))

typedef struct _SynapseZeitgeistRelevancyBackend SynapseZeitgeistRelevancyBackend;
typedef struct _SynapseZeitgeistRelevancyBackendClass SynapseZeitgeistRelevancyBackendClass;
typedef struct _SynapseZeitgeistRelevancyBackendPrivate SynapseZeitgeistRelevancyBackendPrivate;
enum  {
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_0_PROPERTY,
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_relevancy_backend_properties[SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendCheckDataSourcesData SynapseZeitgeistRelevancyBackendCheckDataSourcesData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData;
typedef struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseZeitgeistRelevancyBackend {
	GObject parent_instance;
	SynapseZeitgeistRelevancyBackendPrivate * priv;
};

struct _SynapseZeitgeistRelevancyBackendClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistRelevancyBackendPrivate {
	ZeitgeistLog* zg_log;
	ZeitgeistDataSourceRegistry* zg_dsr;
	GeeMap* application_popularity;
	GeeMap* uri_popularity;
	gboolean has_datahub_gio_module;
};

struct _SynapseZeitgeistRelevancyBackendCheckDataSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	ZeitgeistDataSourceRegistry* _tmp0_;
	GPtrArray* array;
	ZeitgeistDataSourceRegistry* _tmp1_;
	GPtrArray* _tmp2_;
	GError* err;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	GPtrArray* array;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistResultSet* rs;
	ZeitgeistResultSet* _tmp15_;
	ZeitgeistLog* _tmp16_;
	ZeitgeistTimeRange* _tmp17_;
	GPtrArray* _tmp18_;
	ZeitgeistResultSet* _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	GeeMap* _tmp21_;
	guint size;
	ZeitgeistResultSet* _tmp22_;
	guint index;
	ZeitgeistResultSet* _e_it;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp25_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistEvent* _tmp27_;
	ZeitgeistEvent* _tmp28_;
	ZeitgeistSubject* s;
	ZeitgeistEvent* _tmp29_;
	GPtrArray* _tmp30_;
	GPtrArray* _tmp31_;
	gconstpointer _tmp32_;
	ZeitgeistSubject* _tmp33_;
	gfloat power;
	gfloat relevancy;
	GeeMap* _tmp34_;
	ZeitgeistSubject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	guint _tmp38_;
	GError* err;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	GPtrArray* array;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistResultSet* rs;
	GeeMap* popularity_map;
	GeeHashMap* _tmp15_;
	guint size;
	guint index;
	gfloat power;
	gfloat relevancy;
	ZeitgeistResultSet* _tmp16_;
	ZeitgeistLog* _tmp17_;
	ZeitgeistTimeRange* _tmp18_;
	GPtrArray* _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	ZeitgeistResultSet* _tmp21_;
	ZeitgeistResultSet* _tmp22_;
	ZeitgeistResultSet* _e1_it;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	ZeitgeistEvent* e1;
	ZeitgeistResultSet* _tmp25_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistEvent* _tmp27_;
	ZeitgeistEvent* _tmp28_;
	ZeitgeistSubject* s1;
	ZeitgeistEvent* _tmp29_;
	GPtrArray* _tmp30_;
	GPtrArray* _tmp31_;
	gconstpointer _tmp32_;
	ZeitgeistSubject* _tmp33_;
	GeeMap* _tmp34_;
	ZeitgeistSubject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	guint _tmp38_;
	ZeitgeistSubject* _tmp39_;
	ZeitgeistSubject* _tmp40_;
	GPtrArray* _tmp41_;
	GPtrArray* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	ZeitgeistEvent* _tmp44_;
	ZeitgeistResultSet* _tmp45_;
	ZeitgeistLog* _tmp46_;
	ZeitgeistTimeRange* _tmp47_;
	GPtrArray* _tmp48_;
	ZeitgeistResultSet* _tmp49_;
	ZeitgeistResultSet* _tmp50_;
	ZeitgeistResultSet* _tmp51_;
	ZeitgeistResultSet* _e2_it;
	ZeitgeistResultSet* _tmp52_;
	ZeitgeistResultSet* _tmp53_;
	ZeitgeistEvent* e2;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistEvent* _tmp55_;
	ZeitgeistEvent* _tmp56_;
	ZeitgeistEvent* _tmp57_;
	ZeitgeistSubject* s2;
	ZeitgeistEvent* _tmp58_;
	GPtrArray* _tmp59_;
	GPtrArray* _tmp60_;
	gconstpointer _tmp61_;
	ZeitgeistSubject* _tmp62_;
	GeeMap* _tmp63_;
	ZeitgeistSubject* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	guint _tmp67_;
	GError* err;
	GError* _tmp68_;
	const gchar* _tmp69_;
	GeeMap* _tmp70_;
	GeeMap* _tmp71_;
	GError* _inner_error0_;
};

static gint SynapseZeitgeistRelevancyBackend_private_offset;
static gpointer synapse_zeitgeist_relevancy_backend_parent_class = NULL;
static SynapseRelevancyBackendIface * synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = NULL;

VALA_EXTERN GType synapse_zeitgeist_relevancy_backend_get_type (void) G_GNUC_CONST ;
static void synapse_zeitgeist_relevancy_backend_check_data_sources_data_free (gpointer _data);
static void synapse_zeitgeist_relevancy_backend_check_data_sources (SynapseZeitgeistRelevancyBackend* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_check_data_sources_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                    GAsyncResult* _res_);
static gboolean synapse_zeitgeist_relevancy_backend_check_data_sources_co (SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_);
static void synapse_zeitgeist_relevancy_backend_check_data_sources_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void ___lambda7_ (SynapseZeitgeistRelevancyBackend* self,
                  ZeitgeistDataSource* ds);
static void ____lambda7__gfunc (gconstpointer data,
                         gpointer self);
static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                              GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                      GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_);
static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_);
static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base,
                                                                            const gchar* desktop_id);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base,
                                                                    const gchar* uri);
static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self);
static gboolean __lambda8_ (SynapseZeitgeistRelevancyBackend* self);
static gboolean ___lambda8__gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base,
                                                                    GAppInfo* app_info);
static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self,
                                                          const gchar* app_uri,
                                                          const gchar* display_name);
VALA_EXTERN SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void);
VALA_EXTERN SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type);
static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_finalize (GObject * obj);
static GType synapse_zeitgeist_relevancy_backend_get_type_once (void);

static inline gpointer
synapse_zeitgeist_relevancy_backend_get_instance_private (SynapseZeitgeistRelevancyBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistRelevancyBackend_private_offset);
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendCheckDataSourcesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources (SynapseZeitgeistRelevancyBackend* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendCheckDataSourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_check_data_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_zeitgeist_relevancy_backend_check_data_sources_co (_data_);
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_finish (SynapseZeitgeistRelevancyBackend* self,
                                                               GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_check_data_sources_co (_data_);
}

static void
___lambda7_ (SynapseZeitgeistRelevancyBackend* self,
             ZeitgeistDataSource* ds)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (ds != NULL);
	_tmp1_ = zeitgeist_data_source_get_unique_id (ds);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "com.zeitgeist-project,datahub,gio-launch-listener") == 0) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = zeitgeist_data_source_get_enabled (ds);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->has_datahub_gio_module = TRUE;
		return;
	}
}

static void
____lambda7__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda7_ ((SynapseZeitgeistRelevancyBackend*) self, (ZeitgeistDataSource*) data);
}

static gboolean
synapse_zeitgeist_relevancy_backend_check_data_sources_co (SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_data_source_registry_new ();
	_g_object_unref0 (_data_->self->priv->zg_dsr);
	_data_->self->priv->zg_dsr = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->zg_dsr;
		_data_->_state_ = 1;
		zeitgeist_data_source_registry_get_data_sources (_data_->_tmp1_, NULL, synapse_zeitgeist_relevancy_backend_check_data_sources_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = zeitgeist_data_source_registry_get_data_sources_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->array = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_ptr_array_foreach (_data_->array, ____lambda7__gfunc, _data_->self);
		_g_ptr_array_unref0 (_data_->array);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->err;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("relevancy-backend-zg.vala:56: Unable to check Zeitgeist data sources: " \
"%s", _data_->_tmp4_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies (self, NULL, NULL);
	result = TRUE;
	return result;
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData, _data_);
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                         GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (self);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
}

static gboolean
synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = g_date_time_new_now_local ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_date_time_to_unix (_data_->_tmp1_) * 1000;
	_g_date_time_unref0 (_data_->_tmp1_);
	_data_->end = _data_->_tmp2_;
	_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	_data_->_tmp3_ = zeitgeist_time_range_new (_data_->start, _data_->end);
	_data_->tr = _data_->_tmp3_;
	_data_->_tmp4_ = zeitgeist_event_new ();
	_data_->event = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->event;
	zeitgeist_event_set_interpretation (_data_->_tmp5_, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	_data_->_tmp6_ = zeitgeist_subject_new ();
	_data_->subject = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->subject;
	zeitgeist_subject_set_interpretation (_data_->_tmp7_, ZEITGEIST_NFO_SOFTWARE);
	_data_->_tmp8_ = _data_->subject;
	zeitgeist_subject_set_uri (_data_->_tmp8_, "application://*");
	_data_->_tmp9_ = _data_->event;
	_data_->_tmp10_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp9_, _data_->_tmp10_);
	_data_->_tmp11_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->array = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->array;
	_data_->_tmp13_ = _data_->event;
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
	g_ptr_array_add (_data_->_tmp12_, _data_->_tmp14_);
	{
		_data_->_tmp16_ = _data_->self->priv->zg_log;
		_data_->_tmp17_ = _data_->tr;
		_data_->_tmp18_ = _data_->array;
		_data_->_state_ = 2;
		zeitgeist_log_find_events (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp19_ = zeitgeist_log_find_events_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp20_ = _data_->_tmp15_;
		_data_->_tmp15_ = NULL;
		_g_object_unref0 (_data_->rs);
		_data_->rs = _data_->_tmp20_;
		_data_->_tmp21_ = _data_->self->priv->application_popularity;
		gee_map_clear (_data_->_tmp21_);
		_data_->_tmp22_ = _data_->rs;
		_data_->size = zeitgeist_result_set_size (_data_->_tmp22_);
		_data_->index = (guint) 0;
		{
			_data_->_tmp23_ = _data_->rs;
			_data_->_tmp24_ = zeitgeist_result_set_iterator (_data_->_tmp23_);
			_data_->_e_it = _data_->_tmp24_;
			while (TRUE) {
				_data_->_tmp25_ = _data_->_e_it;
				_data_->_tmp26_ = zeitgeist_result_set_next_value (_data_->_tmp25_);
				_g_object_unref0 (_data_->e);
				_data_->e = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->e;
				if (!(_data_->_tmp27_ != NULL)) {
					break;
				}
				_data_->_tmp28_ = _data_->e;
				if (zeitgeist_event_num_subjects (_data_->_tmp28_) <= 0) {
					continue;
				}
				_data_->_tmp29_ = _data_->e;
				_data_->_tmp30_ = zeitgeist_event_get_subjects (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = g_ptr_array_index (_data_->_tmp31_, (guint) 0);
				_data_->_tmp33_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp32_);
				_data_->s = _data_->_tmp33_;
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
				_data_->_tmp34_ = _data_->self->priv->application_popularity;
				_data_->_tmp35_ = _data_->s;
				_data_->_tmp36_ = zeitgeist_subject_get_uri (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				gee_map_set (_data_->_tmp34_, _data_->_tmp37_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				_data_->_tmp38_ = _data_->index;
				_data_->index = _data_->_tmp38_ + 1;
				_g_object_unref0 (_data_->s);
			}
			_g_object_unref0 (_data_->e);
			_g_object_unref0 (_data_->_e_it);
		}
		_g_object_unref0 (_data_->_tmp15_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp39_ = _data_->err;
		_data_->_tmp40_ = _data_->_tmp39_->message;
		g_warning ("relevancy-backend-zg.vala:113: %s", _data_->_tmp40_);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->rs);
		_g_ptr_array_unref0 (_data_->array);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->event);
		_g_object_unref0 (_data_->tr);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->rs);
		_g_ptr_array_unref0 (_data_->array);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->event);
		_g_object_unref0 (_data_->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->rs);
	_g_ptr_array_unref0 (_data_->array);
	_g_object_unref0 (_data_->subject);
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->tr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData, _data_);
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                 GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (self);
	return result;
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
}

static gboolean
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = g_date_time_new_now_local ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_date_time_to_unix (_data_->_tmp1_) * 1000;
	_g_date_time_unref0 (_data_->_tmp1_);
	_data_->end = _data_->_tmp2_;
	_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	_data_->_tmp3_ = zeitgeist_time_range_new (_data_->start, _data_->end);
	_data_->tr = _data_->_tmp3_;
	_data_->_tmp4_ = zeitgeist_event_new ();
	_data_->event = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->event;
	zeitgeist_event_set_interpretation (_data_->_tmp5_, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	_data_->_tmp6_ = zeitgeist_subject_new ();
	_data_->subject = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->subject;
	zeitgeist_subject_set_interpretation (_data_->_tmp7_, "!" ZEITGEIST_NFO_SOFTWARE);
	_data_->_tmp8_ = _data_->subject;
	zeitgeist_subject_set_uri (_data_->_tmp8_, "file://*");
	_data_->_tmp9_ = _data_->event;
	_data_->_tmp10_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp9_, _data_->_tmp10_);
	_data_->_tmp11_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->array = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->array;
	_data_->_tmp13_ = _data_->event;
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
	g_ptr_array_add (_data_->_tmp12_, _data_->_tmp14_);
	_data_->_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->popularity_map = (GeeMap*) _data_->_tmp15_;
	{
		_data_->_tmp17_ = _data_->self->priv->zg_log;
		_data_->_tmp18_ = _data_->tr;
		_data_->_tmp19_ = _data_->array;
		_data_->_state_ = 2;
		zeitgeist_log_find_events (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp20_ = zeitgeist_log_find_events_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp16_ = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp21_ = _data_->_tmp16_;
		_data_->_tmp16_ = NULL;
		_g_object_unref0 (_data_->rs);
		_data_->rs = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->rs;
		_data_->size = zeitgeist_result_set_size (_data_->_tmp22_);
		_data_->index = (guint) 0;
		{
			_data_->_tmp23_ = _data_->rs;
			_data_->_tmp24_ = zeitgeist_result_set_iterator (_data_->_tmp23_);
			_data_->_e1_it = _data_->_tmp24_;
			while (TRUE) {
				_data_->_tmp25_ = _data_->_e1_it;
				_data_->_tmp26_ = zeitgeist_result_set_next_value (_data_->_tmp25_);
				_g_object_unref0 (_data_->e1);
				_data_->e1 = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->e1;
				if (!(_data_->_tmp27_ != NULL)) {
					break;
				}
				_data_->_tmp28_ = _data_->e1;
				if (zeitgeist_event_num_subjects (_data_->_tmp28_) <= 0) {
					continue;
				}
				_data_->_tmp29_ = _data_->e1;
				_data_->_tmp30_ = zeitgeist_event_get_subjects (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = g_ptr_array_index (_data_->_tmp31_, (guint) 0);
				_data_->_tmp33_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp32_);
				_data_->s1 = _data_->_tmp33_;
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
				_data_->_tmp34_ = _data_->popularity_map;
				_data_->_tmp35_ = _data_->s1;
				_data_->_tmp36_ = zeitgeist_subject_get_uri (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				gee_map_set (_data_->_tmp34_, _data_->_tmp37_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				_data_->_tmp38_ = _data_->index;
				_data_->index = _data_->_tmp38_ + 1;
				_g_object_unref0 (_data_->s1);
			}
			_g_object_unref0 (_data_->e1);
			_g_object_unref0 (_data_->_e1_it);
		}
		_data_->_tmp39_ = _data_->subject;
		zeitgeist_subject_set_interpretation (_data_->_tmp39_, ZEITGEIST_NFO_WEBSITE);
		_data_->_tmp40_ = _data_->subject;
		zeitgeist_subject_set_uri (_data_->_tmp40_, "");
		_data_->_tmp41_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_g_ptr_array_unref0 (_data_->array);
		_data_->array = _data_->_tmp41_;
		_data_->_tmp42_ = _data_->array;
		_data_->_tmp43_ = _data_->event;
		_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
		g_ptr_array_add (_data_->_tmp42_, _data_->_tmp44_);
		_data_->_tmp46_ = _data_->self->priv->zg_log;
		_data_->_tmp47_ = _data_->tr;
		_data_->_tmp48_ = _data_->array;
		_data_->_state_ = 3;
		zeitgeist_log_find_events (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 128, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp49_ = zeitgeist_log_find_events_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp45_ = _data_->_tmp49_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp16_);
			goto __catch0_g_error;
		}
		_data_->_tmp50_ = _data_->_tmp45_;
		_data_->_tmp45_ = NULL;
		_g_object_unref0 (_data_->rs);
		_data_->rs = _data_->_tmp50_;
		_data_->_tmp51_ = _data_->rs;
		_data_->size = zeitgeist_result_set_size (_data_->_tmp51_);
		_data_->index = (guint) 0;
		{
			_data_->_tmp52_ = _data_->rs;
			_data_->_tmp53_ = zeitgeist_result_set_iterator (_data_->_tmp52_);
			_data_->_e2_it = _data_->_tmp53_;
			while (TRUE) {
				_data_->_tmp54_ = _data_->_e2_it;
				_data_->_tmp55_ = zeitgeist_result_set_next_value (_data_->_tmp54_);
				_g_object_unref0 (_data_->e2);
				_data_->e2 = _data_->_tmp55_;
				_data_->_tmp56_ = _data_->e2;
				if (!(_data_->_tmp56_ != NULL)) {
					break;
				}
				_data_->_tmp57_ = _data_->e2;
				if (zeitgeist_event_num_subjects (_data_->_tmp57_) <= 0) {
					continue;
				}
				_data_->_tmp58_ = _data_->e2;
				_data_->_tmp59_ = zeitgeist_event_get_subjects (_data_->_tmp58_);
				_data_->_tmp60_ = _data_->_tmp59_;
				_data_->_tmp61_ = g_ptr_array_index (_data_->_tmp60_, (guint) 0);
				_data_->_tmp62_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp61_);
				_data_->s2 = _data_->_tmp62_;
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
				_data_->_tmp63_ = _data_->popularity_map;
				_data_->_tmp64_ = _data_->s2;
				_data_->_tmp65_ = zeitgeist_subject_get_uri (_data_->_tmp64_);
				_data_->_tmp66_ = _data_->_tmp65_;
				gee_map_set (_data_->_tmp63_, _data_->_tmp66_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
				_data_->_tmp67_ = _data_->index;
				_data_->index = _data_->_tmp67_ + 1;
				_g_object_unref0 (_data_->s2);
			}
			_g_object_unref0 (_data_->e2);
			_g_object_unref0 (_data_->_e2_it);
		}
		_g_object_unref0 (_data_->_tmp45_);
		_g_object_unref0 (_data_->_tmp16_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp68_ = _data_->err;
		_data_->_tmp69_ = _data_->_tmp68_->message;
		g_warning ("relevancy-backend-zg.vala:197: %s", _data_->_tmp69_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->popularity_map);
		_g_object_unref0 (_data_->rs);
		_g_ptr_array_unref0 (_data_->array);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->event);
		_g_object_unref0 (_data_->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp70_ = _data_->popularity_map;
	_data_->_tmp71_ = _g_object_ref0 (_data_->_tmp70_);
	_g_object_unref0 (_data_->self->priv->uri_popularity);
	_data_->self->priv->uri_popularity = _data_->_tmp71_;
	_g_object_unref0 (_data_->popularity_map);
	_g_object_unref0 (_data_->rs);
	_g_ptr_array_unref0 (_data_->array);
	_g_object_unref0 (_data_->subject);
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->tr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gfloat
synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base,
                                                                     const gchar* desktop_id)
{
	SynapseZeitgeistRelevancyBackend * self;
	GeeMap* _tmp0_;
	gfloat result;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
	_tmp0_ = self->priv->application_popularity;
	if (gee_map_has_key (_tmp0_, desktop_id)) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->application_popularity;
		_tmp2_ = gee_map_get (_tmp1_, desktop_id);
		result = ((gint) ((gintptr) _tmp2_)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}

static gfloat
synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base,
                                                             const gchar* uri)
{
	SynapseZeitgeistRelevancyBackend * self;
	GeeMap* _tmp0_;
	gfloat result;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_val_if_fail (uri != NULL, 0.0F);
	_tmp0_ = self->priv->uri_popularity;
	if (gee_map_has_key (_tmp0_, uri)) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->uri_popularity;
		_tmp2_ = gee_map_get (_tmp1_, uri);
		result = ((gint) ((gintptr) _tmp2_)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
		return result;
	}
	result = 0.0f;
	return result;
}

static gboolean
__lambda8_ (SynapseZeitgeistRelevancyBackend* self)
{
	gboolean result;
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((SynapseZeitgeistRelevancyBackend*) self);
	return result;
}

static void
synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_LOW, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
}

static void
synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base,
                                                               GAppInfo* app_info)
{
	SynapseZeitgeistRelevancyBackend * self;
	GType zg_gio_module = 0UL;
	gchar* app_uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = (SynapseZeitgeistRelevancyBackend*) base;
	g_return_if_fail (app_info != NULL);
	zg_gio_module = g_type_from_name ("GAppLaunchHandlerZeitgeist");
	if (zg_gio_module != ((GType) 0)) {
		g_debug ("relevancy-backend-zg.vala:235: libzg-gio-module detected, not pushing");
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
		return;
	}
	if (self->priv->has_datahub_gio_module) {
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
		return;
	}
	app_uri = NULL;
	_tmp0_ = g_app_info_get_id (app_info);
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_app_info_get_id (app_info);
		_tmp2_ = g_strconcat ("application://", _tmp1_, NULL);
		_g_free0 (app_uri);
		app_uri = _tmp2_;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (app_info, G_TYPE_DESKTOP_APP_INFO)) {
			const gchar* filename = NULL;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp3_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (app_info, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
			filename = _tmp3_;
			_tmp4_ = filename;
			if (_tmp4_ == NULL) {
				_g_free0 (app_uri);
				return;
			}
			_tmp5_ = filename;
			_tmp6_ = g_path_get_basename (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat ("application://", _tmp7_, NULL);
			_g_free0 (app_uri);
			app_uri = _tmp8_;
			_g_free0 (_tmp7_);
		}
	}
	_tmp9_ = app_uri;
	g_debug ("relevancy-backend-zg.vala:257: launched \"%s\", pushing to ZG", _tmp9_);
	_tmp10_ = app_uri;
	_tmp11_ = g_app_info_get_display_name (app_info);
	synapse_zeitgeist_relevancy_backend_push_app_launch (self, _tmp10_, _tmp11_);
	synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
	_g_free0 (app_uri);
}

static void
synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self,
                                                     const gchar* app_uri,
                                                     const gchar* display_name)
{
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	ZeitgeistSubject* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_uri != NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	subject = _tmp1_;
	_tmp2_ = event;
	zeitgeist_event_set_actor (_tmp2_, "application://synapse.desktop");
	_tmp3_ = event;
	zeitgeist_event_set_interpretation (_tmp3_, ZEITGEIST_ZG_ACCESS_EVENT);
	_tmp4_ = event;
	zeitgeist_event_set_manifestation (_tmp4_, ZEITGEIST_ZG_USER_ACTIVITY);
	_tmp5_ = event;
	_tmp6_ = subject;
	zeitgeist_event_add_subject (_tmp5_, _tmp6_);
	_tmp7_ = subject;
	zeitgeist_subject_set_uri (_tmp7_, app_uri);
	_tmp8_ = subject;
	zeitgeist_subject_set_interpretation (_tmp8_, ZEITGEIST_NFO_SOFTWARE);
	_tmp9_ = subject;
	zeitgeist_subject_set_manifestation (_tmp9_, ZEITGEIST_NFO_SOFTWARE_ITEM);
	_tmp10_ = subject;
	zeitgeist_subject_set_mimetype (_tmp10_, "application/x-desktop");
	_tmp11_ = subject;
	zeitgeist_subject_set_text (_tmp11_, display_name);
	{
		ZeitgeistLog* _tmp12_;
		ZeitgeistEvent* _tmp13_;
		_tmp12_ = self->priv->zg_log;
		_tmp13_ = event;
		zeitgeist_log_insert_event_no_reply (_tmp12_, _tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = err;
		_tmp15_ = _tmp14_->message;
		g_warning ("relevancy-backend-zg.vala:283: %s", _tmp15_);
		_g_error_free0 (err);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
}

SynapseZeitgeistRelevancyBackend*
synapse_zeitgeist_relevancy_backend_construct (GType object_type)
{
	SynapseZeitgeistRelevancyBackend * self = NULL;
	self = (SynapseZeitgeistRelevancyBackend*) g_object_new (object_type, NULL);
	return self;
}

SynapseZeitgeistRelevancyBackend*
synapse_zeitgeist_relevancy_backend_new (void)
{
	return synapse_zeitgeist_relevancy_backend_construct (SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND);
}

static gboolean
_synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_refresh_popularity ((SynapseZeitgeistRelevancyBackend*) self);
	return result;
}

static GObject *
synapse_zeitgeist_relevancy_backend_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistRelevancyBackend * self;
	ZeitgeistLog* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend);
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->application_popularity);
	self->priv->application_popularity = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->uri_popularity);
	self->priv->uri_popularity = (GeeMap*) _tmp2_;
	synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
	synapse_zeitgeist_relevancy_backend_check_data_sources (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 30), _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
synapse_zeitgeist_relevancy_backend_class_init (SynapseZeitgeistRelevancyBackendClass * klass,
                                                gpointer klass_data)
{
	synapse_zeitgeist_relevancy_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistRelevancyBackend_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_relevancy_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_relevancy_backend_finalize;
}

static void
synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init (SynapseRelevancyBackendIface * iface,
                                                                              gpointer iface_data)
{
	synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_application_popularity = (gfloat (*) (SynapseRelevancyBackend*, const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_application_popularity;
	iface->get_uri_popularity = (gfloat (*) (SynapseRelevancyBackend*, const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_uri_popularity;
	iface->application_launched = (void (*) (SynapseRelevancyBackend*, GAppInfo*)) synapse_zeitgeist_relevancy_backend_real_application_launched;
}

static void
synapse_zeitgeist_relevancy_backend_instance_init (SynapseZeitgeistRelevancyBackend * self,
                                                   gpointer klass)
{
	self->priv = synapse_zeitgeist_relevancy_backend_get_instance_private (self);
	self->priv->has_datahub_gio_module = FALSE;
}

static void
synapse_zeitgeist_relevancy_backend_finalize (GObject * obj)
{
	SynapseZeitgeistRelevancyBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->zg_dsr);
	_g_object_unref0 (self->priv->application_popularity);
	_g_object_unref0 (self->priv->uri_popularity);
	G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class)->finalize (obj);
}

static GType
synapse_zeitgeist_relevancy_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelevancyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_relevancy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelevancyBackend), 0, (GInstanceInitFunc) synapse_zeitgeist_relevancy_backend_instance_init, NULL };
	static const GInterfaceInfo synapse_relevancy_backend_info = { (GInterfaceInitFunc) synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_relevancy_backend_type_id;
	synapse_zeitgeist_relevancy_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistRelevancyBackend", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_relevancy_backend_type_id, SYNAPSE_TYPE_RELEVANCY_BACKEND, &synapse_relevancy_backend_info);
	SynapseZeitgeistRelevancyBackend_private_offset = g_type_add_instance_private (synapse_zeitgeist_relevancy_backend_type_id, sizeof (SynapseZeitgeistRelevancyBackendPrivate));
	return synapse_zeitgeist_relevancy_backend_type_id;
}

GType
synapse_zeitgeist_relevancy_backend_get_type (void)
{
	static volatile gsize synapse_zeitgeist_relevancy_backend_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_relevancy_backend_type_id__once)) {
		GType synapse_zeitgeist_relevancy_backend_type_id;
		synapse_zeitgeist_relevancy_backend_type_id = synapse_zeitgeist_relevancy_backend_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_relevancy_backend_type_id__once, synapse_zeitgeist_relevancy_backend_type_id);
	}
	return synapse_zeitgeist_relevancy_backend_type_id__once;
}

