/* fuzzy-search.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from fuzzy-search.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Marvin Ahlgrimm
 */

#include "fuzzy-search.h"
#include <glib-object.h>
#include "codecore.h"
#include <gio/gio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <libpeas.h>

#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_KEY GDK_KEY_F
#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_MODTYPE GDK_MOD1_MASK
#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_GROUP "fuzzysearch"
#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_PREFIX SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_GROUP "."
#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_SHOW "action-show"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_PLUGINS_FUZZY_SEARCH_0_PROPERTY,
	SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY,
	SCRATCH_PLUGINS_FUZZY_SEARCH_NUM_PROPERTIES
};
static GParamSpec* scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _ScratchPluginsFuzzySearchPrivate {
	GObject* _object;
	ScratchServicesFuzzySearchIndexer* indexer;
	ScratchMainWindow* window;
	ScratchServicesInterface* plugins;
	GMenuItem* fuzzy_menuitem;
	GCancellable* cancellable;
	GSimpleActionGroup* actions;
	GSettings* folder_settings;
};

struct _Block1Data {
	int _ref_count_;
	ScratchPluginsFuzzySearch* self;
	ScratchFuzzySearchPopover* popover;
};

static gint ScratchPluginsFuzzySearch_private_offset;
static gpointer scratch_plugins_fuzzy_search_parent_class = NULL;
static GeeMultiMap* scratch_plugins_fuzzy_search_action_accelerators;
static GeeMultiMap* scratch_plugins_fuzzy_search_action_accelerators = NULL;
static ScratchServicesActivatablePluginIface * scratch_plugins_fuzzy_search_scratch_services_activatable_plugin_parent_iface = NULL;
static GType scratch_plugins_fuzzy_search_type_id = 0;

static void scratch_plugins_fuzzy_search_fuzzy_find (ScratchPluginsFuzzySearch* self);
static void _scratch_plugins_fuzzy_search_fuzzy_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void scratch_plugins_fuzzy_search_real_update_state (ScratchServicesActivatablePlugin* base);
static void scratch_plugins_fuzzy_search_real_activate (ScratchServicesActivatablePlugin* base);
static void __lambda27_ (ScratchPluginsFuzzySearch* self,
                  ScratchMainWindow* w);
static void __lambda28_ (ScratchPluginsFuzzySearch* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void scratch_plugins_fuzzy_search_add_actions (ScratchPluginsFuzzySearch* self);
static void scratch_plugins_fuzzy_search_handle_opened_projects_change (ScratchPluginsFuzzySearch* self);
static void _scratch_plugins_fuzzy_search_handle_opened_projects_change_g_settings_changed (GSettings* _sender,
                                                                                     const gchar* key,
                                                                                     gpointer self);
static void ___lambda27__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                          ScratchMainWindow* window,
                                                          gpointer self);
static void __lambda29_ (ScratchPluginsFuzzySearch* self,
                  GFile* src,
                  GFile* dest,
                  GFileMonitorEvent event);
static void ___lambda29__scratch_services_interface_hook_folder_item_change (ScratchServicesInterface* _sender,
                                                                      GFile* file,
                                                                      GFile* other_file,
                                                                      GFileMonitorEvent event_type,
                                                                      gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void scratch_plugins_fuzzy_search_remove_actions (ScratchPluginsFuzzySearch* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda25_ (Block1Data* _data1_,
                  const gchar* filepath);
static void ___lambda25__scratch_fuzzy_search_popover_open_file (ScratchFuzzySearchPopover* _sender,
                                                          const gchar* filepath,
                                                          gpointer self);
static void __lambda26_ (Block1Data* _data1_);
static void ___lambda26__scratch_fuzzy_search_popover_close_search (ScratchFuzzySearchPopover* _sender,
                                                             gpointer self);
static void scratch_plugins_fuzzy_search_real_deactivate (ScratchServicesActivatablePlugin* base);
static void scratch_plugins_fuzzy_search_finalize (GObject * obj);
static void _vala_scratch_plugins_fuzzy_search_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_scratch_plugins_fuzzy_search_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
GType scratch_services_fuzzy_finder_register_type (GTypeModule * module);
GType scratch_services_fuzzy_finder_recursive_finder_register_type (GTypeModule * module);
GType scratch_services_fuzzy_search_indexer_register_type (GTypeModule * module);
GType scratch_services_search_project_register_type (GTypeModule * module);
GType scratch_fuzzy_search_popover_register_type (GTypeModule * module);
GType file_item_register_type (GTypeModule * module);
GType indexer_message_register_type (GTypeModule * module);
GType initial_index_request_register_type (GTypeModule * module);
GType project_update_register_type (GTypeModule * module);
GType search_result_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_ENTRIES[1] = {{SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_SHOW, _scratch_plugins_fuzzy_search_fuzzy_find_gsimple_action_activate_callback}};

static inline gpointer
scratch_plugins_fuzzy_search_get_instance_private (ScratchPluginsFuzzySearch* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchPluginsFuzzySearch_private_offset);
}

static void
_scratch_plugins_fuzzy_search_fuzzy_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	scratch_plugins_fuzzy_search_fuzzy_find ((ScratchPluginsFuzzySearch*) self);
}

static void
scratch_plugins_fuzzy_search_real_update_state (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsFuzzySearch * self;
	self = (ScratchPluginsFuzzySearch*) base;
}

static void
__lambda28_ (ScratchPluginsFuzzySearch* self,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_start_finish (_tmp0_, res);
}

static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda28_ ((ScratchPluginsFuzzySearch*) self, source_object, res);
	g_object_unref (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_scratch_plugins_fuzzy_search_handle_opened_projects_change_g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self)
{
	scratch_plugins_fuzzy_search_handle_opened_projects_change ((ScratchPluginsFuzzySearch*) self);
}

static void
__lambda27_ (ScratchPluginsFuzzySearch* self,
             ScratchMainWindow* w)
{
	ScratchMainWindow* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	ScratchServicesFuzzySearchIndexer* _tmp3_;
	ScratchServicesFuzzySearchIndexer* _tmp4_;
	ScratchMainWindow* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = self->priv->cancellable;
	_tmp3_ = scratch_services_fuzzy_search_indexer_new (_tmp2_);
	_g_object_unref0 (self->priv->indexer);
	self->priv->indexer = _tmp3_;
	_tmp4_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_start_async (_tmp4_, ___lambda28__gasync_ready_callback, g_object_ref (self));
	_tmp5_ = _g_object_ref0 (w);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp5_;
	_tmp6_ = g_settings_new ("io.elementary.code.folder-manager");
	_g_object_unref0 (self->priv->folder_settings);
	self->priv->folder_settings = _tmp6_;
	scratch_plugins_fuzzy_search_add_actions (self);
	_tmp7_ = self->priv->folder_settings;
	g_signal_connect_object (_tmp7_, "changed::opened-folders", (GCallback) _scratch_plugins_fuzzy_search_handle_opened_projects_change_g_settings_changed, self, 0);
}

static void
___lambda27__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                     ScratchMainWindow* window,
                                                     gpointer self)
{
	__lambda27_ ((ScratchPluginsFuzzySearch*) self, window);
}

static void
__lambda29_ (ScratchPluginsFuzzySearch* self,
             GFile* src,
             GFile* dest,
             GFileMonitorEvent event)
{
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	ScratchServicesFuzzySearchIndexer* _tmp1_;
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->indexer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_handle_folder_item_change (_tmp1_, src, dest, event);
}

static void
___lambda29__scratch_services_interface_hook_folder_item_change (ScratchServicesInterface* _sender,
                                                                 GFile* file,
                                                                 GFile* other_file,
                                                                 GFileMonitorEvent event_type,
                                                                 gpointer self)
{
	__lambda29_ ((ScratchPluginsFuzzySearch*) self, file, other_file, event_type);
}

static void
scratch_plugins_fuzzy_search_real_activate (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsFuzzySearch * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ScratchServicesInterface* _tmp2_;
	ScratchServicesInterface* _tmp3_;
	self = (ScratchPluginsFuzzySearch*) base;
	_tmp0_ = scratch_services_activatable_plugin_get_object ((ScratchServicesActivatablePlugin*) self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_tmp2_ = self->priv->plugins;
	g_signal_connect_object (_tmp2_, "hook-window", (GCallback) ___lambda27__scratch_services_interface_hook_window, self, 0);
	_tmp3_ = self->priv->plugins;
	g_signal_connect_object (_tmp3_, "hook-folder-item-change", (GCallback) ___lambda29__scratch_services_interface_hook_folder_item_change, self, 0);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
scratch_plugins_fuzzy_search_add_actions (ScratchPluginsFuzzySearch* self)
{
	GSimpleActionGroup* _tmp0_;
	ScratchMainWindow* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GtkApplication* application = NULL;
	GApplication* _tmp5_;
	GtkApplication* _tmp6_;
	ScratchApplication* app = NULL;
	GtkApplication* _tmp7_;
	ScratchApplication* _tmp8_;
	GMenuItem* _tmp29_;
	GMenu* menu = NULL;
	ScratchMainWindow* _tmp30_;
	CodeSidebar* _tmp31_;
	GMenuModel* _tmp32_;
	GMenuModel* _tmp33_;
	GMenu* _tmp34_;
	GMenuItem* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actions;
	if (_tmp0_ == NULL) {
		GSimpleActionGroup* _tmp1_;
		GSimpleActionGroup* _tmp2_;
		_tmp1_ = g_simple_action_group_new ();
		_g_object_unref0 (self->priv->actions);
		self->priv->actions = _tmp1_;
		_tmp2_ = self->priv->actions;
		g_action_map_add_action_entries ((GActionMap*) _tmp2_, SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_ENTRIES, (gint) G_N_ELEMENTS (SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_ENTRIES), self);
	}
	_tmp3_ = self->priv->window;
	_tmp4_ = self->priv->actions;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp3_, SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_GROUP, (GActionGroup*) _tmp4_);
	_tmp5_ = g_application_get_default ();
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_get_type (), GtkApplication));
	application = _tmp6_;
	_tmp7_ = application;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	app = _tmp8_;
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp9_ = scratch_plugins_fuzzy_search_action_accelerators;
		_tmp10_ = gee_multi_map_get_keys (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_action_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gchar* action = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			gchar** accels_array = NULL;
			GeeMultiMap* _tmp17_;
			const gchar* _tmp18_;
			GeeCollection* _tmp19_;
			GeeCollection* _tmp20_;
			gint _tmp21_ = 0;
			gpointer* _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			gint accels_array_length1;
			gint _accels_array_size_;
			ScratchApplication* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			_tmp14_ = _action_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _action_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			action = (gchar*) _tmp16_;
			_tmp17_ = scratch_plugins_fuzzy_search_action_accelerators;
			_tmp18_ = action;
			_tmp19_ = gee_multi_map_get (_tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp22_ = gee_collection_to_array (_tmp20_, &_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp23__length1 = _tmp21_;
			_g_object_unref0 (_tmp20_);
			accels_array = _tmp23_;
			accels_array_length1 = _tmp23__length1;
			_accels_array_size_ = accels_array_length1;
			_vala_array_add1 (&accels_array, &accels_array_length1, &_accels_array_size_, NULL);
			_tmp24_ = app;
			_tmp25_ = action;
			_tmp26_ = g_strconcat (SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_PREFIX, _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = accels_array;
			_tmp28__length1 = accels_array_length1;
			gtk_application_set_accels_for_action ((GtkApplication*) _tmp24_, _tmp27_, _tmp28_);
			_g_free0 (_tmp27_);
			accels_array = (_vala_array_free (accels_array, accels_array_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	scratch_plugins_fuzzy_search_handle_opened_projects_change (self);
	_tmp29_ = g_menu_item_new (_ ("Find Project Files"), SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_PREFIX SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_SHOW);
	_g_object_unref0 (self->priv->fuzzy_menuitem);
	self->priv->fuzzy_menuitem = _tmp29_;
	_tmp30_ = self->priv->window;
	_tmp31_ = _tmp30_->sidebar;
	_tmp32_ = code_sidebar_get_project_menu_model (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_menu_get_type ()) ? ((GMenu*) _tmp33_) : NULL);
	menu = _tmp34_;
	_tmp35_ = self->priv->fuzzy_menuitem;
	g_menu_append_item (menu, _tmp35_);
	_g_object_unref0 (menu);
	_g_object_unref0 (app);
	_g_object_unref0 (application);
}

static void
scratch_plugins_fuzzy_search_remove_actions (ScratchPluginsFuzzySearch* self)
{
	GMenu* sidebar_menu = NULL;
	ScratchMainWindow* _tmp0_;
	CodeSidebar* _tmp1_;
	GMenuModel* _tmp2_;
	GMenuModel* _tmp3_;
	GMenu* _tmp4_;
	gint length = 0;
	GMenu* _tmp5_;
	GtkApplication* application = NULL;
	GApplication* _tmp17_;
	GtkApplication* _tmp18_;
	ScratchApplication* app = NULL;
	GtkApplication* _tmp19_;
	ScratchApplication* _tmp20_;
	ScratchMainWindow* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _tmp0_->sidebar;
	_tmp2_ = code_sidebar_get_project_menu_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, g_menu_get_type ()) ? ((GMenu*) _tmp3_) : NULL);
	sidebar_menu = _tmp4_;
	_tmp5_ = sidebar_menu;
	length = g_menu_model_get_n_items ((GMenuModel*) _tmp5_);
	{
		gint i = 0;
		i = length - 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar* action_name = NULL;
				GMenu* _tmp8_;
				const GVariantType* _tmp9_;
				GVariant* _tmp10_;
				GVariant* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ - 1;
				}
				_tmp6_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp8_ = sidebar_menu;
				_tmp9_ = G_VARIANT_TYPE_STRING;
				_tmp10_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp8_, i, G_MENU_ATTRIBUTE_ACTION, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_variant_get_string (_tmp11_, NULL);
				_tmp13_ = g_strdup (_tmp12_);
				_tmp14_ = _tmp13_;
				_g_variant_unref0 (_tmp11_);
				action_name = _tmp14_;
				_tmp15_ = action_name;
				if (g_str_has_prefix (_tmp15_, SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_PREFIX)) {
					GMenu* _tmp16_;
					_tmp16_ = sidebar_menu;
					g_menu_remove (_tmp16_, i);
				}
				_g_free0 (action_name);
			}
		}
	}
	_tmp17_ = g_application_get_default ();
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_application_get_type (), GtkApplication));
	application = _tmp18_;
	_tmp19_ = application;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	app = _tmp20_;
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp21_;
		GeeSet* _tmp22_;
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _tmp25_;
		_tmp21_ = scratch_plugins_fuzzy_search_action_accelerators;
		_tmp22_ = gee_multi_map_get_keys (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_action_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			gchar* action = NULL;
			GeeIterator* _tmp27_;
			gpointer _tmp28_;
			ScratchApplication* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			_tmp26_ = _action_it;
			if (!gee_iterator_next (_tmp26_)) {
				break;
			}
			_tmp27_ = _action_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			action = (gchar*) _tmp28_;
			_tmp29_ = app;
			_tmp30_ = action;
			_tmp31_ = g_strconcat (SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_PREFIX, _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_new0 (gchar*, 0 + 1);
			_tmp34_ = _tmp33_;
			_tmp34__length1 = 0;
			gtk_application_set_accels_for_action ((GtkApplication*) _tmp29_, _tmp32_, _tmp34_);
			_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp32_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp35_ = self->priv->window;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp35_, SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_GROUP, NULL);
	_g_object_unref0 (app);
	_g_object_unref0 (application);
	_g_object_unref0 (sidebar_menu);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ScratchPluginsFuzzySearch* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->popover);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda25_ (Block1Data* _data1_,
             const gchar* filepath)
{
	ScratchPluginsFuzzySearch* self;
	ScratchFolderManagerFile* file = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchServicesDocument* doc = NULL;
	ScratchMainWindow* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	ScratchServicesDocument* _tmp6_;
	ScratchMainWindow* _tmp7_;
	ScratchFuzzySearchPopover* _tmp8_;
	self = _data1_->self;
	g_return_if_fail (filepath != NULL);
	_tmp0_ = scratch_folder_manager_file_new (filepath);
	file = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = scratch_main_window_get_actions (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = scratch_folder_manager_file_get_file (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = scratch_services_document_new (_tmp3_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	doc = _tmp6_;
	_tmp7_ = self->priv->window;
	scratch_main_window_open_document (_tmp7_, doc, TRUE, 0, NULL, NULL);
	_tmp8_ = _data1_->popover;
	gtk_popover_popdown ((GtkPopover*) _tmp8_);
	_g_object_unref0 (doc);
	_g_object_unref0 (file);
}

static void
___lambda25__scratch_fuzzy_search_popover_open_file (ScratchFuzzySearchPopover* _sender,
                                                     const gchar* filepath,
                                                     gpointer self)
{
	__lambda25_ (self, filepath);
}

static void
__lambda26_ (Block1Data* _data1_)
{
	ScratchPluginsFuzzySearch* self;
	ScratchFuzzySearchPopover* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->popover;
	gtk_popover_popdown ((GtkPopover*) _tmp0_);
}

static void
___lambda26__scratch_fuzzy_search_popover_close_search (ScratchFuzzySearchPopover* _sender,
                                                        gpointer self)
{
	__lambda26_ (self);
}

static void
scratch_plugins_fuzzy_search_fuzzy_find (ScratchPluginsFuzzySearch* self)
{
	Block1Data* _data1_;
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gchar** opened_folders = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint opened_folders_length1;
	gint _opened_folders_size_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ScratchServicesFuzzySearchIndexer* _tmp7_;
	ScratchMainWindow* _tmp8_;
	ScratchFuzzySearchPopover* _tmp9_;
	ScratchFuzzySearchPopover* _tmp10_;
	ScratchFuzzySearchPopover* _tmp11_;
	ScratchFuzzySearchPopover* _tmp12_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("io.elementary.code.folder-manager");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "opened-folders");
	opened_folders = _tmp3_;
	opened_folders_length1 = _vala_array_length (_tmp2_);
	_opened_folders_size_ = opened_folders_length1;
	_tmp5_ = opened_folders;
	_tmp5__length1 = opened_folders_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = opened_folders;
		_tmp6__length1 = opened_folders_length1;
		_tmp4_ = _tmp6__length1 < 1;
	}
	if (_tmp4_) {
		opened_folders = (_vala_array_free (opened_folders, opened_folders_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp7_ = self->priv->indexer;
	_tmp8_ = self->priv->window;
	_tmp9_ = scratch_fuzzy_search_popover_new (_tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	_data1_->popover = _tmp9_;
	_tmp10_ = _data1_->popover;
	g_signal_connect_data (_tmp10_, "open-file", (GCallback) ___lambda25__scratch_fuzzy_search_popover_open_file, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp11_ = _data1_->popover;
	g_signal_connect_data (_tmp11_, "close-search", (GCallback) ___lambda26__scratch_fuzzy_search_popover_close_search, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp12_ = _data1_->popover;
	gtk_popover_popup ((GtkPopover*) _tmp12_);
	opened_folders = (_vala_array_free (opened_folders, opened_folders_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
scratch_plugins_fuzzy_search_real_deactivate (ScratchServicesActivatablePlugin* base)
{
	ScratchPluginsFuzzySearch * self;
	GSettings* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GCancellable* _tmp3_;
	self = (ScratchPluginsFuzzySearch*) base;
	_tmp0_ = self->priv->folder_settings;
	g_signal_parse_name ("changed::opened-folders", g_settings_get_type (), &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _scratch_plugins_fuzzy_search_handle_opened_projects_change_g_settings_changed, self);
	scratch_plugins_fuzzy_search_remove_actions (self);
	_tmp3_ = self->priv->cancellable;
	if (_tmp3_ != NULL) {
		GCancellable* _tmp4_;
		_tmp4_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp4_);
	}
}

static void
scratch_plugins_fuzzy_search_handle_opened_projects_change (ScratchPluginsFuzzySearch* self)
{
	GSimpleAction* show_action = NULL;
	GSimpleActionGroup* _tmp0_;
	GSimpleAction* _tmp1_;
	gchar** opened_folders = NULL;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint opened_folders_length1;
	gint _opened_folders_size_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GSimpleAction* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actions;
	_tmp1_ = scratch_utils_action_from_group (SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_SHOW, _tmp0_);
	show_action = _tmp1_;
	_tmp2_ = self->priv->folder_settings;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "opened-folders");
	opened_folders = _tmp4_;
	opened_folders_length1 = _vala_array_length (_tmp3_);
	_opened_folders_size_ = opened_folders_length1;
	_tmp6_ = opened_folders;
	_tmp6__length1 = opened_folders_length1;
	if (_tmp6_ != NULL) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = opened_folders;
		_tmp7__length1 = opened_folders_length1;
		_tmp5_ = _tmp7__length1 > 0;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = show_action;
	g_simple_action_set_enabled (_tmp8_, _tmp5_);
	opened_folders = (_vala_array_free (opened_folders, opened_folders_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (show_action);
}

ScratchPluginsFuzzySearch*
scratch_plugins_fuzzy_search_construct (GType object_type)
{
	ScratchPluginsFuzzySearch * self = NULL;
	self = (ScratchPluginsFuzzySearch*) g_object_new (object_type, NULL);
	return self;
}

ScratchPluginsFuzzySearch*
scratch_plugins_fuzzy_search_new (void)
{
	return scratch_plugins_fuzzy_search_construct (SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH);
}

static GObject*
scratch_plugins_fuzzy_search_real_get_object (ScratchServicesActivatablePlugin* base)
{
	GObject* result;
	ScratchPluginsFuzzySearch* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	self = (ScratchPluginsFuzzySearch*) base;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
scratch_plugins_fuzzy_search_real_set_object (ScratchServicesActivatablePlugin* base,
                                              GObject* value)
{
	ScratchPluginsFuzzySearch* self;
	GObject* old_value;
	self = (ScratchPluginsFuzzySearch*) base;
	old_value = scratch_plugins_fuzzy_search_real_get_object (base);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
scratch_plugins_fuzzy_search_class_init (ScratchPluginsFuzzySearchClass * klass,
                                         gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	scratch_plugins_fuzzy_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchPluginsFuzzySearch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_plugins_fuzzy_search_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_plugins_fuzzy_search_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_plugins_fuzzy_search_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY, scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	scratch_plugins_fuzzy_search_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = scratch_plugins_fuzzy_search_action_accelerators;
	_tmp2_ = gdk_keyval_name (SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_KEY);
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("<Alt>", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	gee_multi_map_set (_tmp1_, SCRATCH_PLUGINS_FUZZY_SEARCH_ACTION_SHOW, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
scratch_plugins_fuzzy_search_scratch_services_activatable_plugin_interface_init (ScratchServicesActivatablePluginIface * iface,
                                                                                 gpointer iface_data)
{
	scratch_plugins_fuzzy_search_scratch_services_activatable_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_state = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_fuzzy_search_real_update_state;
	iface->activate = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_fuzzy_search_real_activate;
	iface->deactivate = (void (*) (ScratchServicesActivatablePlugin*)) scratch_plugins_fuzzy_search_real_deactivate;
	iface->get_object = scratch_plugins_fuzzy_search_real_get_object;
	iface->set_object = scratch_plugins_fuzzy_search_real_set_object;
}

static void
scratch_plugins_fuzzy_search_instance_init (ScratchPluginsFuzzySearch * self,
                                            gpointer klass)
{
	self->priv = scratch_plugins_fuzzy_search_get_instance_private (self);
	self->priv->window = NULL;
}

static void
scratch_plugins_fuzzy_search_finalize (GObject * obj)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	_g_object_unref0 (self->priv->_object);
	_g_object_unref0 (self->priv->indexer);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->fuzzy_menuitem);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->folder_settings);
	G_OBJECT_CLASS (scratch_plugins_fuzzy_search_parent_class)->finalize (obj);
}

GType
scratch_plugins_fuzzy_search_get_type (void)
{
	return scratch_plugins_fuzzy_search_type_id;
}

GType
scratch_plugins_fuzzy_search_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchPluginsFuzzySearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_plugins_fuzzy_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchPluginsFuzzySearch), 0, (GInstanceInitFunc) scratch_plugins_fuzzy_search_instance_init, NULL };
	static const GInterfaceInfo scratch_services_activatable_plugin_info = { (GInterfaceInitFunc) scratch_plugins_fuzzy_search_scratch_services_activatable_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	scratch_plugins_fuzzy_search_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ScratchPluginsFuzzySearch", &g_define_type_info, 0);
	g_type_module_add_interface (module, scratch_plugins_fuzzy_search_type_id, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, &scratch_services_activatable_plugin_info);
	ScratchPluginsFuzzySearch_private_offset = sizeof (ScratchPluginsFuzzySearchPrivate);
	return scratch_plugins_fuzzy_search_type_id;
}

static void
_vala_scratch_plugins_fuzzy_search_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	switch (property_id) {
		case SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY:
		g_value_take_object (value, scratch_services_activatable_plugin_get_object ((ScratchServicesActivatablePlugin*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_plugins_fuzzy_search_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	switch (property_id) {
		case SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY:
		scratch_services_activatable_plugin_set_object ((ScratchServicesActivatablePlugin*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	scratch_plugins_fuzzy_search_register_type (module);
	scratch_services_fuzzy_finder_register_type (module);
	scratch_services_fuzzy_finder_recursive_finder_register_type (module);
	scratch_services_fuzzy_search_indexer_register_type (module);
	scratch_services_search_project_register_type (module);
	scratch_fuzzy_search_popover_register_type (module);
	file_item_register_type (module);
	indexer_message_register_type (module);
	initial_index_request_register_type (module);
	project_update_register_type (module);
	search_result_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, SCRATCH_SERVICES_TYPE_ACTIVATABLE_PLUGIN, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

