/* Bookmark.c generated by valac 0.56.18, the Vala compiler
 * generated from Bookmark.vala, do not modify */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesParamSpecBookmark FilesParamSpecBookmark;
enum  {
	FILES_BOOKMARK_CONTENTS_CHANGED_SIGNAL,
	FILES_BOOKMARK_DELETED_SIGNAL,
	FILES_BOOKMARK_NUM_SIGNALS
};
static guint files_bookmark_signals[FILES_BOOKMARK_NUM_SIGNALS] = {0};

struct _FilesBookmarkPrivate {
	gchar* _custom_name;
	FilesFile* _gof_file;
	GFileMonitor* monitor;
};

struct _FilesParamSpecBookmark {
	GParamSpec parent_instance;
};

static gint FilesBookmark_private_offset;
static gpointer files_bookmark_parent_class = NULL;
GCompareFunc files_bookmark_compare_with = NULL;

static gint _files_bookmark_compare_with_lambda19_ (FilesBookmark* a,
                                             FilesBookmark* b);
static gint __files_bookmark_compare_with_lambda19__gcompare_func (gconstpointer a,
                                                            gconstpointer b);
static void files_bookmark_set_gof_file (FilesBookmark* self,
                                  FilesFile* value);
static void files_bookmark_connect_file (FilesBookmark* self);
static void files_bookmark_file_changed_callback (FilesBookmark* self,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type);
static void files_bookmark_disconnect_file (FilesBookmark* self);
static void _files_bookmark_file_changed_callback_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self);
static void files_bookmark_finalize (FilesBookmark * obj);
static GType files_bookmark_get_type_once (void);

static inline gpointer
files_bookmark_get_instance_private (FilesBookmark* self)
{
	return G_STRUCT_MEMBER_P (self, FilesBookmark_private_offset);
}

static gint
_files_bookmark_compare_with_lambda19_ (FilesBookmark* a,
                                        FilesBookmark* b)
{
	gint _tmp0_ = 0;
	FilesFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	FilesFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a->priv->_gof_file;
	_tmp2_ = files_file_get_location (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b->priv->_gof_file;
	_tmp5_ = files_file_get_location (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_file_equal (_tmp3_, _tmp6_)) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}

static gint
__files_bookmark_compare_with_lambda19__gcompare_func (gconstpointer a,
                                                       gconstpointer b)
{
	gint result;
	result = _files_bookmark_compare_with_lambda19_ ((FilesBookmark*) a, (FilesBookmark*) b);
	return result;
}

FilesBookmark*
files_bookmark_construct (GType object_type,
                          FilesFile* gof_file,
                          const gchar* label)
{
	FilesBookmark* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (gof_file != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (FilesBookmark*) g_type_create_instance (object_type);
	files_bookmark_set_gof_file (self, gof_file);
	_tmp0_ = files_file_get_basename (gof_file);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (label, _tmp1_) != 0) {
		files_bookmark_set_custom_name (self, label);
	}
	files_bookmark_connect_file (self);
	return self;
}

FilesBookmark*
files_bookmark_new (FilesFile* gof_file,
                    const gchar* label)
{
	return files_bookmark_construct (FILES_TYPE_BOOKMARK, gof_file, label);
}

FilesBookmark*
files_bookmark_construct_from_uri (GType object_type,
                                   const gchar* uri,
                                   const gchar* label)
{
	FilesBookmark* self = NULL;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (FilesBookmark*) g_type_create_instance (object_type);
	_tmp0_ = files_file_get_by_uri (uri);
	_tmp1_ = _tmp0_;
	files_bookmark_set_gof_file (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_gof_file;
	_tmp3_ = files_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (label, _tmp4_) != 0) {
		files_bookmark_set_custom_name (self, label);
	}
	files_bookmark_connect_file (self);
	return self;
}

FilesBookmark*
files_bookmark_new_from_uri (const gchar* uri,
                             const gchar* label)
{
	return files_bookmark_construct_from_uri (FILES_TYPE_BOOKMARK, uri, label);
}

FilesBookmark*
files_bookmark_copy (FilesBookmark* self)
{
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	FilesBookmark* _tmp2_;
	FilesBookmark* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = self->priv->_custom_name;
	_tmp2_ = files_bookmark_new (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}

GFile*
files_bookmark_get_location (FilesBookmark* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = files_file_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gchar*
files_bookmark_get_parse_name (FilesBookmark* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_bookmark_get_location (self);
	_tmp1_ = g_file_get_parse_name (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GIcon*
files_bookmark_get_icon (FilesBookmark* self)
{
	FilesFile* _tmp0_;
	GIcon* _tmp1_;
	GThemedIcon* _tmp30_;
	GError* _inner_error0_ = NULL;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = _tmp0_->icon;
	if (_tmp1_ != NULL) {
		FilesFile* _tmp2_;
		GIcon* _tmp3_;
		GIcon* _tmp4_;
		_tmp2_ = self->priv->_gof_file;
		_tmp3_ = _tmp2_->icon;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		GFileType ftype = 0;
		FilesFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = self->priv->_gof_file;
		_tmp6_ = files_file_get_location (_tmp5_);
		_tmp7_ = _tmp6_;
		ftype = g_file_query_file_type (_tmp7_, G_FILE_QUERY_INFO_NONE, NULL);
		if (ftype == G_FILE_TYPE_DIRECTORY) {
			{
				gchar* path = NULL;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				GIcon* icon = NULL;
				FilesFile* _tmp11_;
				const gchar* _tmp12_;
				GIcon* _tmp13_;
				GIcon* _tmp14_;
				_tmp8_ = files_bookmark_get_uri (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_filename_from_uri (_tmp9_, NULL, &_inner_error0_);
				path = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = self->priv->_gof_file;
				_tmp12_ = path;
				_tmp13_ = files_file_get_icon_user_special_dirs (_tmp11_, _tmp12_);
				icon = _tmp13_;
				_tmp14_ = icon;
				if (_tmp14_ != NULL) {
					result = icon;
					_g_free0 (path);
					return result;
				} else {
					GThemedIcon* _tmp15_;
					_tmp15_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder");
					result = (GIcon*) _tmp15_;
					_g_object_unref0 (icon);
					_g_free0 (path);
					return result;
				}
				_g_object_unref0 (icon);
				_g_free0 (path);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
				GThemedIcon* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				g_debug ("Bookmark.vala:94: %s", _tmp17_);
				_tmp18_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder");
				result = (GIcon*) _tmp18_;
				_g_error_free0 (e);
				return result;
			}
			__finally0:
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		} else {
			if (ftype == G_FILE_TYPE_MOUNTABLE) {
				GThemedIcon* _tmp19_;
				_tmp19_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
				result = (GIcon*) _tmp19_;
				return result;
			} else {
				{
					GFileInfo* info = NULL;
					FilesFile* _tmp20_;
					GFile* _tmp21_;
					GFile* _tmp22_;
					GFileInfo* _tmp23_;
					GFileInfo* _tmp24_;
					const gchar* _tmp25_;
					GIcon* _tmp26_;
					_tmp20_ = self->priv->_gof_file;
					_tmp21_ = files_file_get_location (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_file_query_info (_tmp22_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
					info = _tmp23_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp24_ = info;
					_tmp25_ = g_file_info_get_attribute_string (_tmp24_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
					_tmp26_ = g_content_type_get_icon (_tmp25_);
					result = _tmp26_;
					_g_object_unref0 (info);
					return result;
				}
				goto __finally1;
				__catch1_g_error:
				{
					FilesFile* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					g_clear_error (&_inner_error0_);
					_tmp27_ = self->priv->_gof_file;
					_tmp28_ = files_file_get_uri (_tmp27_);
					_tmp29_ = _tmp28_;
					g_debug ("Bookmark.vala:108: Unable to get icon for %s", _tmp29_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp30_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("unknown");
	result = (GIcon*) _tmp30_;
	return result;
}

gboolean
files_bookmark_uri_known_not_to_exist (FilesBookmark* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* path_name = NULL;
	FilesFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = files_file_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!g_file_is_native (_tmp2_)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_gof_file;
	_tmp4_ = files_file_get_location (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_path (_tmp5_);
	path_name = _tmp6_;
	_tmp7_ = path_name;
	result = !g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
	_g_free0 (path_name);
	return result;
}

static void
files_bookmark_file_changed_callback (FilesBookmark* self,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	switch (event_type) {
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			files_bookmark_disconnect_file (self);
			g_signal_emit (self, files_bookmark_signals[FILES_BOOKMARK_DELETED_SIGNAL], 0);
			break;
		}
		case G_FILE_MONITOR_EVENT_MOVED:
		{
			g_signal_emit (self, files_bookmark_signals[FILES_BOOKMARK_CONTENTS_CHANGED_SIGNAL], 0);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
files_bookmark_disconnect_file (FilesBookmark* self)
{
	GFileMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		_tmp1_ = self->priv->monitor;
		g_file_monitor_cancel (_tmp1_);
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = NULL;
	}
}

static void
_files_bookmark_file_changed_callback_g_file_monitor_changed (GFileMonitor* _sender,
                                                              GFile* file,
                                                              GFile* other_file,
                                                              GFileMonitorEvent event_type,
                                                              gpointer self)
{
	files_bookmark_file_changed_callback ((FilesBookmark*) self, file, other_file, event_type);
}

static void
files_bookmark_connect_file (FilesBookmark* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = files_file_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_file_is_native (_tmp2_)) {
		{
			GFileMonitor* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileMonitor* _tmp5_;
			GFileMonitor* _tmp6_;
			GFileMonitor* _tmp7_;
			_tmp4_ = files_bookmark_get_location (self);
			_tmp5_ = g_file_monitor_file (_tmp4_, G_FILE_MONITOR_SEND_MOVED, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (self->priv->monitor);
			self->priv->monitor = _tmp6_;
			_tmp7_ = self->priv->monitor;
			g_signal_connect (_tmp7_, "changed", (GCallback) _files_bookmark_file_changed_callback_g_file_monitor_changed, self);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = _error_;
			_tmp9_ = _tmp8_->message;
			g_warning ("Bookmark.vala:157: Error connecting file monitor %s", _tmp9_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

const gchar*
files_bookmark_get_custom_name (FilesBookmark* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_name;
	result = _tmp0_;
	return result;
}

void
files_bookmark_set_custom_name (FilesBookmark* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_custom_name);
	self->priv->_custom_name = _tmp0_;
}

FilesFile*
files_bookmark_get_gof_file (FilesBookmark* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	result = _tmp0_;
	return result;
}

static void
files_bookmark_set_gof_file (FilesBookmark* self,
                             FilesFile* value)
{
	FilesFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_gof_file);
	self->priv->_gof_file = _tmp0_;
}

const gchar*
files_bookmark_get_basename (FilesBookmark* self)
{
	const gchar* result;
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = files_file_get_display_name (_tmp0_);
	result = _tmp1_;
	return result;
}

const gchar*
files_bookmark_get_uri (FilesBookmark* self)
{
	const gchar* result;
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gof_file;
	_tmp1_ = files_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
files_value_bookmark_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
files_value_bookmark_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		files_bookmark_unref (value->data[0].v_pointer);
	}
}

static void
files_value_bookmark_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = files_bookmark_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
files_value_bookmark_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
files_value_bookmark_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FilesBookmark * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = files_bookmark_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
files_value_bookmark_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	FilesBookmark ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = files_bookmark_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
files_param_spec_bookmark (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	FilesParamSpecBookmark* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FILES_TYPE_BOOKMARK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
files_value_get_bookmark (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_BOOKMARK), NULL);
	return value->data[0].v_pointer;
}

void
files_value_set_bookmark (GValue* value,
                          gpointer v_object)
{
	FilesBookmark * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_BOOKMARK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_TYPE_BOOKMARK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		files_bookmark_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_bookmark_unref (old);
	}
}

void
files_value_take_bookmark (GValue* value,
                           gpointer v_object)
{
	FilesBookmark * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_BOOKMARK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_TYPE_BOOKMARK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_bookmark_unref (old);
	}
}

static void
files_bookmark_class_init (FilesBookmarkClass * klass,
                           gpointer klass_data)
{
	files_bookmark_parent_class = g_type_class_peek_parent (klass);
	((FilesBookmarkClass *) klass)->finalize = files_bookmark_finalize;
	g_type_class_adjust_private_offset (klass, &FilesBookmark_private_offset);
	files_bookmark_signals[FILES_BOOKMARK_CONTENTS_CHANGED_SIGNAL] = g_signal_new ("contents-changed", FILES_TYPE_BOOKMARK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_bookmark_signals[FILES_BOOKMARK_DELETED_SIGNAL] = g_signal_new ("deleted", FILES_TYPE_BOOKMARK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_bookmark_compare_with = __files_bookmark_compare_with_lambda19__gcompare_func;
}

static void
files_bookmark_instance_init (FilesBookmark * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_bookmark_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_custom_name = _tmp0_;
	self->ref_count = 1;
}

static void
files_bookmark_finalize (FilesBookmark * obj)
{
	FilesBookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_BOOKMARK, FilesBookmark);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_custom_name);
	_g_object_unref0 (self->priv->_gof_file);
	_g_object_unref0 (self->priv->monitor);
}

 G_GNUC_NO_INLINE static GType
files_bookmark_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { files_value_bookmark_init, files_value_bookmark_free_value, files_value_bookmark_copy_value, files_value_bookmark_peek_pointer, "p", files_value_bookmark_collect_value, "p", files_value_bookmark_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FilesBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesBookmark), 0, (GInstanceInitFunc) files_bookmark_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType files_bookmark_type_id;
	files_bookmark_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FilesBookmark", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FilesBookmark_private_offset = g_type_add_instance_private (files_bookmark_type_id, sizeof (FilesBookmarkPrivate));
	return files_bookmark_type_id;
}

GType
files_bookmark_get_type (void)
{
	static volatile gsize files_bookmark_type_id__once = 0;
	if (g_once_init_enter (&files_bookmark_type_id__once)) {
		GType files_bookmark_type_id;
		files_bookmark_type_id = files_bookmark_get_type_once ();
		g_once_init_leave (&files_bookmark_type_id__once, files_bookmark_type_id);
	}
	return files_bookmark_type_id__once;
}

gpointer
files_bookmark_ref (gpointer instance)
{
	FilesBookmark * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
files_bookmark_unref (gpointer instance)
{
	FilesBookmark * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILES_BOOKMARK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

