/* PropertiesWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from PropertiesWindow.vala, do not modify */

/*
* Copyright (c) 2011 Marlin Developers (http://launchpad.net/marlin)
* Copyright (c) 2015-2018 elementary LLC <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1335 USA.
*
* Authored by: ammonkey <am.monkeyd@gmail.com>
*/

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG (files_view_abstract_properties_dialog_get_type ())
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))

typedef struct _FilesViewAbstractPropertiesDialog FilesViewAbstractPropertiesDialog;
typedef struct _FilesViewAbstractPropertiesDialogClass FilesViewAbstractPropertiesDialogClass;
typedef struct _FilesViewAbstractPropertiesDialogPrivate FilesViewAbstractPropertiesDialogPrivate;

#define FILES_VIEW_TYPE_PROPERTIES_WINDOW (files_view_properties_window_get_type ())
#define FILES_VIEW_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindow))
#define FILES_VIEW_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindowClass))
#define FILES_VIEW_IS_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_PROPERTIES_WINDOW))
#define FILES_VIEW_IS_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_PROPERTIES_WINDOW))
#define FILES_VIEW_PROPERTIES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindowClass))

typedef struct _FilesViewPropertiesWindow FilesViewPropertiesWindow;
typedef struct _FilesViewPropertiesWindowClass FilesViewPropertiesWindowClass;
typedef struct _FilesViewPropertiesWindowPrivate FilesViewPropertiesWindowPrivate;

#define TYPE_PERMISSION_BUTTON (permission_button_get_type ())
#define PERMISSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERMISSION_BUTTON, PermissionButton))
#define PERMISSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERMISSION_BUTTON, PermissionButtonClass))
#define IS_PERMISSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERMISSION_BUTTON))
#define IS_PERMISSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERMISSION_BUTTON))
#define PERMISSION_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERMISSION_BUTTON, PermissionButtonClass))

typedef struct _PermissionButton PermissionButton;
typedef struct _PermissionButtonClass PermissionButtonClass;

#define FILES_TYPE_ABSTRACT_DIRECTORY_VIEW (files_abstract_directory_view_get_type ())
#define FILES_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryView))
#define FILES_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_ABSTRACT_DIRECTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))

typedef struct _FilesAbstractDirectoryView FilesAbstractDirectoryView;
typedef struct _FilesAbstractDirectoryViewClass FilesAbstractDirectoryViewClass;

#define FILES_TYPE_DEEP_COUNT (files_deep_count_get_type ())
#define FILES_DEEP_COUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DEEP_COUNT, FilesDeepCount))
#define FILES_DEEP_COUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DEEP_COUNT, FilesDeepCountClass))
#define FILES_IS_DEEP_COUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DEEP_COUNT))
#define FILES_IS_DEEP_COUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DEEP_COUNT))
#define FILES_DEEP_COUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DEEP_COUNT, FilesDeepCountClass))

typedef struct _FilesDeepCount FilesDeepCount;
typedef struct _FilesDeepCountClass FilesDeepCountClass;
enum  {
	FILES_VIEW_PROPERTIES_WINDOW_0_PROPERTY,
	FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY,
	FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY,
	FILES_VIEW_PROPERTIES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* files_view_properties_window_properties[FILES_VIEW_PROPERTIES_WINDOW_NUM_PROPERTIES];
typedef enum  {
	FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO,
	FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL,
	FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON
} FilesViewPropertiesWindowAppsColumn;

#define FILES_VIEW_PROPERTIES_WINDOW_TYPE_APPS_COLUMN (files_view_properties_window_apps_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_INFO,
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_PERMISSIONS
} FilesViewAbstractPropertiesDialogPanelType;

#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_TYPE_PANEL_TYPE (files_view_abstract_properties_dialog_panel_type_get_type ())
typedef struct _Block8Data Block8Data;
typedef struct _FilesDeepCountPrivate FilesDeepCountPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesViewPropertiesWindowGetResolutionData FilesViewPropertiesWindowGetResolutionData;
typedef enum  {
	PERMISSIONS_TYPE_USER,
	PERMISSIONS_TYPE_GROUP,
	PERMISSIONS_TYPE_OTHER
} PermissionsType;

#define PERMISSIONS_TYPE_TYPE (permissions_type_get_type ())
typedef enum  {
	PERMISSIONS_VALUE_READ,
	PERMISSIONS_VALUE_WRITE,
	PERMISSIONS_VALUE_EXE
} PermissionsValue;

#define PERMISSIONS_TYPE_VALUE (permissions_value_get_type ())
typedef struct _FilesViewPropertiesWindowFileSetAttributesData FilesViewPropertiesWindowFileSetAttributesData;
typedef struct _Block9Data Block9Data;
typedef struct _FilesAbstractDirectoryViewPrivate FilesAbstractDirectoryViewPrivate;

#define FILES_TYPE_TEXT_RENDERER (files_text_renderer_get_type ())
#define FILES_TEXT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_TEXT_RENDERER, FilesTextRenderer))
#define FILES_TEXT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_TEXT_RENDERER, FilesTextRendererClass))
#define FILES_IS_TEXT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_TEXT_RENDERER))
#define FILES_IS_TEXT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_TEXT_RENDERER))
#define FILES_TEXT_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_TEXT_RENDERER, FilesTextRendererClass))

typedef struct _FilesTextRenderer FilesTextRenderer;
typedef struct _FilesTextRendererClass FilesTextRendererClass;

#define FILES_TYPE_ICON_RENDERER (files_icon_renderer_get_type ())
#define FILES_ICON_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ICON_RENDERER, FilesIconRenderer))
#define FILES_ICON_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ICON_RENDERER, FilesIconRendererClass))
#define FILES_IS_ICON_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ICON_RENDERER))
#define FILES_IS_ICON_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ICON_RENDERER))
#define FILES_ICON_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ICON_RENDERER, FilesIconRendererClass))

typedef struct _FilesIconRenderer FilesIconRenderer;
typedef struct _FilesIconRendererClass FilesIconRendererClass;

#define FILES_VIEW_TYPE_SLOT (files_view_slot_get_type ())
#define FILES_VIEW_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlot))
#define FILES_VIEW_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))
#define FILES_VIEW_IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))

typedef struct _FilesViewSlot FilesViewSlot;
typedef struct _FilesViewSlotClass FilesViewSlotClass;
enum  {
	FILES_VIEW_PROPERTIES_WINDOW_UNCOUNTED_FOLDERS_CHANGED_SIGNAL,
	FILES_VIEW_PROPERTIES_WINDOW_NUM_SIGNALS
};
static guint files_view_properties_window_signals[FILES_VIEW_PROPERTIES_WINDOW_NUM_SIGNALS] = {0};

struct _FilesViewAbstractPropertiesDialog {
	GraniteDialog parent_instance;
	FilesViewAbstractPropertiesDialogPrivate * priv;
	GtkGrid* info_grid;
	GtkGrid* layout;
	GtkStack* stack;
	GtkWidget* header_title;
};

struct _FilesViewAbstractPropertiesDialogClass {
	GraniteDialogClass parent_class;
};

struct _FilesViewPropertiesWindow {
	FilesViewAbstractPropertiesDialog parent_instance;
	FilesViewPropertiesWindowPrivate * priv;
};

struct _FilesViewPropertiesWindowClass {
	FilesViewAbstractPropertiesDialogClass parent_class;
};

struct _FilesViewPropertiesWindowPrivate {
	GtkEntry* perm_code;
	gboolean perm_code_should_update;
	GtkLabel* l_perm;
	PermissionButton* perm_button_user;
	PermissionButton* perm_button_group;
	PermissionButton* perm_button_other;
	GtkListStore* store_users;
	GtkListStore* store_groups;
	GtkListStore* store_apps;
	GList* files;
	gboolean only_one;
	FilesFile* goffile;
	FilesAbstractDirectoryView* _view;
	GtkEntry* _entry;
	GMutex mutex;
	GList* deep_count_directories;
	GeeSet* mimes;
	GtkLabel* resolution_value;
	GtkLabel* size_value;
	gchar* ftype;
	GtkSpinner* spinner;
	gint size_warning;
	guint64 total_size;
	guint timeout_perm;
	GCancellable* cancellable;
	gboolean files_contain_a_directory;
	guint _uncounted_folders;
	guint selected_folders;
	guint selected_files;
	gint owner_perm_code;
	gint group_perm_code;
	gint everyone_perm_code;
	mode_t* vfs_perms;
	gint vfs_perms_length1;
	gint vfs_perms_length2;
	guint folder_count;
	guint file_count;
};

struct _Block8Data {
	int _ref_count_;
	FilesViewPropertiesWindow* self;
	FilesDeepCount* d;
};

struct _FilesDeepCount {
	GObject parent_instance;
	FilesDeepCountPrivate * priv;
	gint file_not_read;
	guint64 total_size;
	guint files_count;
	guint dirs_count;
	guint directories_count;
};

struct _FilesDeepCountClass {
	GObjectClass parent_class;
};

struct _FilesViewPropertiesWindowGetResolutionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewPropertiesWindow* self;
	FilesFile* goffile;
	GFileInputStream* stream;
	GFile* file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* resolution;
	gchar* _tmp3_;
	GFileInputStream* _tmp4_;
	GFile* _tmp5_;
	GCancellable* _tmp6_;
	GFileInputStream* _tmp7_;
	GFileInputStream* _tmp8_;
	GFileInputStream* _tmp9_;
	GdkPixbuf* pixbuf;
	GFileInputStream* _tmp10_;
	GCancellable* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GFileInputStream* _tmp26_;
	GError* _vala1_e;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GtkLabel* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_;
};

struct _FilesViewPropertiesWindowFileSetAttributesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewPropertiesWindow* self;
	FilesFile* file;
	gchar* attr;
	guint32 val;
	GCancellable* _cancellable;
	GFileInfo* info;
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _Block9Data {
	int _ref_count_;
	FilesViewPropertiesWindow* self;
	gchar* str;
};

struct _FilesAbstractDirectoryView {
	GtkScrolledWindow parent_instance;
	FilesAbstractDirectoryViewPrivate * priv;
	FilesZoomLevel minimum_zoom;
	FilesZoomLevel maximum_zoom;
	GList* source_drag_file_list;
	GdkAtom current_target_type;
	gboolean dnd_disabled;
	FilesTextRenderer* name_renderer;
	gchar* original_name;
	gchar* proposed_name;
	gboolean right_margin_unselects_all;
	gboolean on_directory;
	gboolean one_or_less;
	gboolean should_activate;
	gboolean should_deselect;
	gboolean should_thumbnail;
	gboolean should_select;
	GtkTreePath* click_path;
	guint click_zone;
	guint previous_click_zone;
	GList* selected_files;
	gboolean is_writable;
	gboolean is_loading;
	gboolean helpers_shown;
	FilesListModel* model;
	FilesIconRenderer* icon_renderer;
	FilesViewSlot* slot;
	GtkRecentManager* recent;
	GtkEventControllerKey* key_controller;
	GtkGestureMultiPress* button_controller;
	GtkEventControllerScroll* scroll_controller;
	GtkEventControllerMotion* motion_controller;
};

struct _FilesAbstractDirectoryViewClass {
	GtkScrolledWindowClass parent_class;
	void (*on_row_deleted) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	gboolean (*on_view_key_press_event) (FilesAbstractDirectoryView* self, guint original_keyval, guint keycode, GdkModifierType state);
	void (*on_scroll_event) (FilesAbstractDirectoryView* self, gdouble dx, gdouble dy);
	gboolean (*on_view_draw) (FilesAbstractDirectoryView* self, cairo_t* cr);
	gboolean (*handle_primary_button_click) (FilesAbstractDirectoryView* self, guint n_press, GdkModifierType mods, GtkTreePath* path);
	void (*on_view_button_press_event) (FilesAbstractDirectoryView* self, gint n_press, gdouble x, gdouble y);
	void (*on_view_button_release_event) (FilesAbstractDirectoryView* self, gint n_press, gdouble x, gdouble y);
	void (*change_zoom_level) (FilesAbstractDirectoryView* self);
	gboolean (*expand_collapse) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	gboolean (*handle_default_button_click) (FilesAbstractDirectoryView* self);
	gboolean (*get_next_visible_iter) (FilesAbstractDirectoryView* self, GtkTreeIter* iter, gboolean recurse);
	void (*cancel) (FilesAbstractDirectoryView* self);
	void (*highlight_path) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	GtkTreePath* (*up) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	GtkTreePath* (*down) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	GSettings* (*get_view_settings) (FilesAbstractDirectoryView* self);
	void (*set_up_zoom_level) (FilesAbstractDirectoryView* self);
	gboolean (*view_has_focus) (FilesAbstractDirectoryView* self);
	void (*scroll_to_cell) (FilesAbstractDirectoryView* self, GtkTreePath* path, gboolean scroll_to_top);
	GList* (*get_selected_paths) (FilesAbstractDirectoryView* self);
	GtkTreePath* (*get_path_at_pos) (FilesAbstractDirectoryView* self, gint x, gint win);
	GtkTreePath* (*get_path_at_cursor) (FilesAbstractDirectoryView* self);
	void (*tree_select_all) (FilesAbstractDirectoryView* self);
	void (*tree_unselect_all) (FilesAbstractDirectoryView* self);
	void (*tree_unselect_others) (FilesAbstractDirectoryView* self);
	void (*select_path) (FilesAbstractDirectoryView* self, GtkTreePath* path, gboolean cursor_follows);
	void (*unselect_path) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	gboolean (*path_is_selected) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	gboolean (*get_visible_range) (FilesAbstractDirectoryView* self, GtkTreePath** start_path, GtkTreePath** end_path);
	void (*set_cursor) (FilesAbstractDirectoryView* self, GtkTreePath* path, gboolean start_editing, gboolean select, gboolean scroll_to_top);
	gboolean (*move_cursor) (FilesAbstractDirectoryView* self, guint keyval, gboolean only_shift_pressed, gboolean control_pressed);
	gboolean (*will_handle_button_press) (FilesAbstractDirectoryView* self, gboolean no_mods, gboolean only_control_pressed, gboolean only_shift_pressed);
	gboolean (*handle_multi_select) (FilesAbstractDirectoryView* self, GtkTreePath* path);
	GtkWidget* (*create_view) (FilesAbstractDirectoryView* self);
	guint (*get_event_position_info) (FilesAbstractDirectoryView* self, gdouble x, gdouble y, GtkTreePath** path, gboolean rubberband);
	void (*scroll_to_path) (FilesAbstractDirectoryView* self, GtkTreePath* path, gboolean scroll_to_top);
	void (*set_cursor_on_cell) (FilesAbstractDirectoryView* self, GtkTreePath* path, GtkCellRenderer* renderer, gboolean start_editing, gboolean scroll_to_top);
	void (*freeze_tree) (FilesAbstractDirectoryView* self);
	void (*thaw_tree) (FilesAbstractDirectoryView* self);
	void (*freeze_child_notify) (FilesAbstractDirectoryView* self);
	void (*thaw_child_notify) (FilesAbstractDirectoryView* self);
	void (*connect_tree_signals) (FilesAbstractDirectoryView* self);
	void (*disconnect_tree_signals) (FilesAbstractDirectoryView* self);
};

static gint FilesViewPropertiesWindow_private_offset;
static gpointer files_view_properties_window_parent_class = NULL;

VALA_EXTERN GType files_view_abstract_properties_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewAbstractPropertiesDialog, g_object_unref)
VALA_EXTERN GType files_view_properties_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewPropertiesWindow, g_object_unref)
VALA_EXTERN GType permission_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PermissionButton, g_object_unref)
VALA_EXTERN GType files_abstract_directory_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractDirectoryView, g_object_unref)
VALA_EXTERN GType files_deep_count_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDeepCount, g_object_unref)
static GType files_view_properties_window_apps_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN FilesViewPropertiesWindow* files_view_properties_window_new (GList* _files,
                                                             FilesAbstractDirectoryView* _view,
                                                             GtkWindow* parent);
VALA_EXTERN FilesViewPropertiesWindow* files_view_properties_window_construct (GType object_type,
                                                                   GList* _files,
                                                                   FilesAbstractDirectoryView* _view,
                                                                   GtkWindow* parent);
VALA_EXTERN FilesViewAbstractPropertiesDialog* files_view_abstract_properties_dialog_construct (GType object_type,
                                                                                    const gchar* _title,
                                                                                    GtkWindow* parent);
static void files_view_properties_window_set_view (FilesViewPropertiesWindow* self,
                                            FilesAbstractDirectoryView* value);
static void __lambda139_ (FilesViewPropertiesWindow* self);
VALA_EXTERN void files_deep_count_cancel (FilesDeepCount* self);
static void ___lambda139__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void files_view_properties_window_construct_info_panel (FilesViewPropertiesWindow* self,
                                                        FilesFile* file);
static void files_view_properties_window_update_selection_size (FilesViewPropertiesWindow* self);
VALA_EXTERN void files_view_abstract_properties_dialog_overlay_emblems (FilesViewAbstractPropertiesDialog* self,
                                                            GtkImage* file_icon,
                                                            GList* emblems_list);
static gchar* files_view_properties_window_get_selected_label (FilesViewPropertiesWindow* self,
                                                        guint folders,
                                                        guint files);
static void files_view_properties_window_set_entry (FilesViewPropertiesWindow* self,
                                             GtkEntry* value);
static void files_view_properties_window_set_original_name (FilesViewPropertiesWindow* self,
                                                     const gchar* value);
VALA_EXTERN void files_view_properties_window_reset_entry_text (FilesViewPropertiesWindow* self,
                                                    const gchar* new_name);
VALA_EXTERN GtkEntry* files_view_properties_window_get_entry (FilesViewPropertiesWindow* self);
static void ____lambda142_ (FilesViewPropertiesWindow* self);
static void files_view_properties_window_rename_file (FilesViewPropertiesWindow* self,
                                               FilesFile* file,
                                               const gchar* _new_name);
static void _____lambda142__gtk_entry_activate (GtkEntry* _sender,
                                         gpointer self);
static gboolean ____lambda144_ (FilesViewPropertiesWindow* self);
static gboolean _____lambda144__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                     GdkEventFocus* event,
                                                     gpointer self);
VALA_EXTERN void files_view_abstract_properties_dialog_create_header_title (FilesViewAbstractPropertiesDialog* self);
static GtkWidget* files_view_properties_window_construct_perm_panel (FilesViewPropertiesWindow* self);
VALA_EXTERN GType files_view_abstract_properties_dialog_panel_type_get_type (void) G_GNUC_CONST ;
static void files_view_properties_window_update_size_value (FilesViewPropertiesWindow* self);
static guint files_view_properties_window_get_uncounted_folders (FilesViewPropertiesWindow* self);
VALA_EXTERN GtkLabel* files_make_key_label (const gchar* label);
VALA_EXTERN GtkLabel* files_make_value_label (const gchar* label);
VALA_EXTERN FilesAbstractDirectoryView* files_view_properties_window_get_view (FilesViewPropertiesWindow* self);
VALA_EXTERN gboolean files_abstract_directory_view_get_in_recent (FilesAbstractDirectoryView* self);
static gchar* files_view_properties_window_get_contains_value (FilesViewPropertiesWindow* self,
                                                        guint folders,
                                                        guint files);
static void files_view_properties_window_set_uncounted_folders (FilesViewPropertiesWindow* self,
                                                         guint value);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN FilesDeepCount* files_deep_count_new (GFile* _file);
VALA_EXTERN FilesDeepCount* files_deep_count_construct (GType object_type,
                                            GFile* _file);
static void _____lambda140_ (Block8Data* _data8_);
static void ______lambda140__files_deep_count_finished (FilesDeepCount* _sender,
                                                 gpointer self);
VALA_EXTERN guint64 files_view_properties_window_file_real_size (FilesFile* gof);
static void ___lambda141_ (FilesViewPropertiesWindow* self);
static void ____lambda141__files_view_properties_window_uncounted_folders_changed (FilesViewPropertiesWindow* _sender,
                                                                            gpointer self);
static const gchar* files_view_properties_window_get_original_name (FilesViewPropertiesWindow* self);
static void files_view_properties_window_set_proposed_name (FilesViewPropertiesWindow* self,
                                                     const gchar* value);
VALA_EXTERN void files_abstract_directory_view_set_file_display_name (FilesAbstractDirectoryView* self,
                                                          GFile* old_location,
                                                          const gchar* new_name,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN GFile* files_abstract_directory_view_set_file_display_name_finish (FilesAbstractDirectoryView* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
static void ____lambda143_ (FilesViewPropertiesWindow* self,
                     GObject* obj,
                     GAsyncResult* res);
static void _____lambda143__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static gchar* files_view_properties_window_get_common_ftype (FilesViewPropertiesWindow* self);
static gboolean files_view_properties_window_got_common_location (FilesViewPropertiesWindow* self);
static GFile* files_view_properties_window_get_parent_loc (FilesViewPropertiesWindow* self,
                                                    const gchar* path);
static gchar* files_view_properties_window_get_common_trash_orig (FilesViewPropertiesWindow* self);
static gchar* files_view_properties_window_filetype (FilesViewPropertiesWindow* self,
                                              FilesFile* file);
VALA_EXTERN GAppInfo* files_abstract_directory_view_get_default_app (FilesAbstractDirectoryView* self);
static gchar* files_view_properties_window_resolution (FilesViewPropertiesWindow* self,
                                                FilesFile* file);
static void files_view_properties_window_get_resolution (FilesViewPropertiesWindow* self,
                                                  FilesFile* goffile,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void files_view_properties_window_get_resolution_finish (FilesViewPropertiesWindow* self,
                                                         GAsyncResult* _res_);
static gchar* files_view_properties_window_location (FilesViewPropertiesWindow* self,
                                              FilesFile* file);
static gchar* files_view_properties_window_original_location (FilesViewPropertiesWindow* self,
                                                       FilesFile* file);
static void files_view_properties_window_get_resolution_data_free (gpointer _data);
static gboolean files_view_properties_window_get_resolution_co (FilesViewPropertiesWindowGetResolutionData* _data_);
static void files_view_properties_window_get_resolution_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
VALA_EXTERN GList* files_abstract_directory_view_get_open_with_apps (FilesAbstractDirectoryView* self);
static GIcon* files_view_properties_window_ensure_icon (FilesViewPropertiesWindow* self,
                                                 GAppInfo* app);
static void files_view_properties_window_combo_open_with_changed (FilesViewPropertiesWindow* self,
                                                           GtkComboBox* combo);
static void _files_view_properties_window_combo_open_with_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                  gpointer self);
static gboolean files_view_properties_window_should_show_device_usage (FilesViewPropertiesWindow* self);
VALA_EXTERN void files_view_abstract_properties_dialog_create_storage_bar (FilesViewAbstractPropertiesDialog* self,
                                                               GFileInfo* file_info,
                                                               gint line);
VALA_EXTERN GType permissions_type_get_type (void) G_GNUC_CONST ;
static void files_view_properties_window_update_perm_codes (FilesViewPropertiesWindow* self,
                                                     PermissionsType pt,
                                                     gint val,
                                                     gint mult);
static void files_view_properties_window_permission_button_toggle (FilesViewPropertiesWindow* self,
                                                            GtkToggleButton* btn);
VALA_EXTERN GType permissions_value_get_type (void) G_GNUC_CONST ;
static void files_view_properties_window_reset_and_cancel_perm_timeout (FilesViewPropertiesWindow* self);
static PermissionButton* files_view_properties_window_create_perm_choice (FilesViewPropertiesWindow* self,
                                                                   PermissionsType pt);
VALA_EXTERN PermissionButton* permission_button_new (PermissionsType permission_type);
VALA_EXTERN PermissionButton* permission_button_construct (GType object_type,
                                               PermissionsType permission_type);
VALA_EXTERN GtkToggleButton* permission_button_get_btn_read (PermissionButton* self);
static void _files_view_properties_window_permission_button_toggle_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                       gpointer self);
VALA_EXTERN GtkToggleButton* permission_button_get_btn_write (PermissionButton* self);
VALA_EXTERN GtkToggleButton* permission_button_get_btn_exe (PermissionButton* self);
static guint32 files_view_properties_window_get_perm_from_chmod_unit (FilesViewPropertiesWindow* self,
                                                               guint32 vfs_perm,
                                                               gint nb,
                                                               gint chmod,
                                                               PermissionsType pt);
static guint32 files_view_properties_window_chmod_to_vfs (FilesViewPropertiesWindow* self,
                                                   gint chmod);
static void files_view_properties_window_update_perm_grid_toggle_states (FilesViewPropertiesWindow* self,
                                                                  guint32 permissions);
VALA_EXTERN void permission_button_update_buttons (PermissionButton* self,
                                       guint32 permissions);
static void files_view_properties_window_file_set_attributes_data_free (gpointer _data);
static void files_view_properties_window_file_set_attributes (FilesViewPropertiesWindow* self,
                                                       FilesFile* file,
                                                       const gchar* attr,
                                                       guint32 val,
                                                       GCancellable* _cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void files_view_properties_window_file_set_attributes_finish (FilesViewPropertiesWindow* self,
                                                              GAsyncResult* _res_);
static gboolean files_view_properties_window_file_set_attributes_co (FilesViewPropertiesWindowFileSetAttributesData* _data_);
static void files_view_properties_window_file_set_attributes_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void files_view_properties_window_entry_changed (FilesViewPropertiesWindow* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN gboolean permissions_is_chmod_code (const gchar* str);
static gboolean ___lambda145_ (Block9Data* _data9_);
static gboolean ____lambda145__gsource_func (gpointer self);
static void files_view_properties_window_combo_owner_changed (FilesViewPropertiesWindow* self,
                                                       GtkComboBox* combo);
static gboolean _uid_t_equal (const uid_t * s1,
                       const uid_t * s2);
static void files_view_properties_window_combo_group_changed (FilesViewPropertiesWindow* self,
                                                       GtkComboBox* combo);
static GtkWidget* files_view_properties_window_create_owner_choice (FilesViewPropertiesWindow* self);
static GtkWidget* files_view_properties_window_create_group_choice (FilesViewPropertiesWindow* self);
static void _files_view_properties_window_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self);
static gboolean files_view_properties_window_selection_can_set_owner (FilesViewPropertiesWindow* self);
static gchar* files_view_properties_window_get_common_owner (FilesViewPropertiesWindow* self);
static gboolean files_view_properties_window_selection_can_set_group (FilesViewPropertiesWindow* self);
static gchar* files_view_properties_window_get_common_group (FilesViewPropertiesWindow* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _files_view_properties_window_combo_owner_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                              gpointer self);
static void _files_view_properties_window_combo_group_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                              gpointer self);
VALA_EXTERN GAppInfo* files_mime_actions_choose_app_for_glib_file (GFile* file_to_open,
                                                       GtkWidget* parent);
VALA_EXTERN GType files_text_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesTextRenderer, g_object_unref)
VALA_EXTERN GType files_icon_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesIconRenderer, g_object_unref)
VALA_EXTERN GType files_view_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewSlot, g_object_unref)
static const gchar* files_view_properties_window_get_proposed_name (FilesViewPropertiesWindow* self);
static void files_view_properties_window_finalize (GObject * obj);
static GType files_view_properties_window_get_type_once (void);
static void _vala_files_view_properties_window_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_files_view_properties_window_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
files_view_properties_window_get_instance_private (FilesViewPropertiesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewPropertiesWindow_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_view_properties_window_apps_column_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO, "FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO", "app-info"}, {FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, "FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL", "label"}, {FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON, "FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON", "icon"}, {0, NULL, NULL}};
	GType files_view_properties_window_apps_column_type_id;
	files_view_properties_window_apps_column_type_id = g_enum_register_static ("FilesViewPropertiesWindowAppsColumn", values);
	return files_view_properties_window_apps_column_type_id;
}

static GType
files_view_properties_window_apps_column_get_type (void)
{
	static volatile gsize files_view_properties_window_apps_column_type_id__once = 0;
	if (g_once_init_enter (&files_view_properties_window_apps_column_type_id__once)) {
		GType files_view_properties_window_apps_column_type_id;
		files_view_properties_window_apps_column_type_id = files_view_properties_window_apps_column_get_type_once ();
		g_once_init_leave (&files_view_properties_window_apps_column_type_id__once, files_view_properties_window_apps_column_type_id);
	}
	return files_view_properties_window_apps_column_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda139_ (FilesViewPropertiesWindow* self)
{
	GList* _tmp0_;
	_tmp0_ = self->priv->deep_count_directories;
	{
		GList* dir_collection = NULL;
		GList* dir_it = NULL;
		dir_collection = _tmp0_;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			FilesDeepCount* _tmp1_;
			FilesDeepCount* dir = NULL;
			_tmp1_ = _g_object_ref0 ((FilesDeepCount*) dir_it->data);
			dir = _tmp1_;
			{
				FilesDeepCount* _tmp2_;
				_tmp2_ = dir;
				files_deep_count_cancel (_tmp2_);
				_g_object_unref0 (dir);
			}
		}
	}
}

static void
___lambda139__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda139_ ((FilesViewPropertiesWindow*) self);
}

static void
____lambda142_ (FilesViewPropertiesWindow* self)
{
	FilesFile* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->goffile;
	_tmp1_ = self->priv->_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	files_view_properties_window_rename_file (self, _tmp0_, _tmp2_);
}

static void
_____lambda142__gtk_entry_activate (GtkEntry* _sender,
                                    gpointer self)
{
	____lambda142_ ((FilesViewPropertiesWindow*) self);
}

static gboolean
____lambda144_ (FilesViewPropertiesWindow* self)
{
	FilesFile* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->goffile;
	_tmp1_ = self->priv->_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	files_view_properties_window_rename_file (self, _tmp0_, _tmp2_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda144__gtk_widget_focus_out_event (GtkWidget* _sender,
                                            GdkEventFocus* event,
                                            gpointer self)
{
	gboolean result;
	result = ____lambda144_ ((FilesViewPropertiesWindow*) self);
	return result;
}

FilesViewPropertiesWindow*
files_view_properties_window_construct (GType object_type,
                                        GList* _files,
                                        FilesAbstractDirectoryView* _view,
                                        GtkWindow* parent)
{
	FilesViewPropertiesWindow * self = NULL;
	gboolean _tmp3_ = FALSE;
	GList* _tmp4_;
	gboolean empty = FALSE;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GeeHashSet* _tmp9_;
	GList* _tmp10_;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	FilesFile* _tmp22_;
	GList* _tmp23_;
	gconstpointer _tmp24_;
	FilesFile* _tmp25_;
	GCancellable* _tmp26_;
	GdkPixbuf* file_pix = NULL;
	FilesFile* _tmp27_;
	GdkPixbuf* _tmp28_;
	GdkPixbuf* _tmp29_;
	GtkStack* _tmp52_;
	GtkWidget* _tmp53_;
	GtkWidget* _tmp54_;
	gchar* _tmp55_;
	GtkStackSwitcher* stack_switcher = NULL;
	GtkStack* _tmp56_;
	GtkStack* _tmp57_;
	GtkStackSwitcher* _tmp58_ = NULL;
	GtkGrid* _tmp59_;
	GtkStackSwitcher* _tmp60_;
	GtkGrid* _tmp61_;
	g_return_val_if_fail (_view != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (FilesViewPropertiesWindow*) files_view_abstract_properties_dialog_construct (object_type, _ ("Properties"), parent);
	if (_files == NULL) {
		g_critical ("PropertiesWindow.vala:119: Properties Window constructor called with n" \
"ull file list");
		return self;
	}
	if (_view == NULL) {
		g_critical ("PropertiesWindow.vala:124: Properties Window constructor called with n" \
"ull Directory View");
		return self;
	}
	files_view_properties_window_set_view (self, _view);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) ___lambda139__gtk_widget_destroy, self, 0);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			FilesFile* _tmp0_;
			FilesFile* file = NULL;
			_tmp0_ = _g_object_ref0 ((FilesFile*) file_it->data);
			file = _tmp0_;
			{
				FilesFile* _tmp1_;
				FilesFile* _tmp2_;
				_tmp1_ = file;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				self->priv->files = g_list_prepend (self->priv->files, _tmp2_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp4_ = self->priv->files;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GList* _tmp5_;
		gconstpointer _tmp6_;
		_tmp5_ = self->priv->files;
		_tmp6_ = g_list_nth_data (_tmp5_, (guint) 0);
		_tmp3_ = ((FilesFile*) _tmp6_) == NULL;
	}
	empty = _tmp3_;
	if (empty) {
		g_critical ("PropertiesWindow.vala:152: Properties Window constructor called with e" \
"mpty file list");
		return self;
	}
	_tmp7_ = self->priv->files;
	_tmp8_ = _tmp7_->data;
	if (!G_TYPE_CHECK_INSTANCE_TYPE ((FilesFile*) _tmp8_, FILES_TYPE_FILE)) {
		g_critical ("PropertiesWindow.vala:157: Properties Window constructor called with i" \
"nvalid file data (1)");
		return self;
	}
	_tmp9_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mimes);
	self->priv->mimes = (GeeSet*) _tmp9_;
	_tmp10_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp10_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp11_;
			FilesFile* gof = NULL;
			_tmp11_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp11_;
			{
				FilesFile* _tmp12_;
				gchar* ftype = NULL;
				FilesFile* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				FilesFile* _tmp19_;
				_tmp12_ = gof;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, FILES_TYPE_FILE)) {
					g_critical ("PropertiesWindow.vala:164: Properties Window constructor called with i" \
"nvalid file data (2)");
					_g_object_unref0 (gof);
					return self;
				}
				_tmp13_ = gof;
				_tmp14_ = files_file_get_ftype (_tmp13_);
				_tmp15_ = g_strdup (_tmp14_);
				ftype = _tmp15_;
				_tmp16_ = ftype;
				if (_tmp16_ != NULL) {
					GeeSet* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = self->priv->mimes;
					_tmp18_ = ftype;
					gee_collection_add ((GeeCollection*) _tmp17_, _tmp18_);
				}
				_tmp19_ = gof;
				if (_tmp19_->is_directory) {
					self->priv->files_contain_a_directory = TRUE;
				}
				_g_free0 (ftype);
				_g_object_unref0 (gof);
			}
		}
	}
	_tmp20_ = self->priv->files;
	_tmp21_ = _tmp20_->data;
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FilesFile*) _tmp21_, FILES_TYPE_FILE, FilesFile));
	_g_object_unref0 (self->priv->goffile);
	self->priv->goffile = _tmp22_;
	_tmp23_ = self->priv->files;
	_tmp24_ = g_list_nth_data (_tmp23_, (guint) 1);
	self->priv->only_one = ((FilesFile*) _tmp24_) == NULL;
	_tmp25_ = self->priv->goffile;
	files_view_properties_window_construct_info_panel (self, _tmp25_);
	_tmp26_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp26_;
	files_view_properties_window_update_selection_size (self);
	_tmp27_ = self->priv->goffile;
	_tmp28_ = files_file_get_icon_pixbuf (_tmp27_, 48, gtk_widget_get_scale_factor ((GtkWidget*) self), FILES_FILE_ICON_FLAGS_NONE);
	file_pix = _tmp28_;
	_tmp29_ = file_pix;
	if (_tmp29_ != NULL) {
		GtkImage* file_icon = NULL;
		GdkPixbuf* _tmp30_;
		GtkImage* _tmp31_ = NULL;
		GtkImage* _tmp32_;
		FilesFile* _tmp33_;
		GList* _tmp34_;
		_tmp30_ = file_pix;
		_tmp31_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp30_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
		gtk_image_set_pixel_size (_tmp31_, 48);
		g_object_ref_sink (_tmp31_);
		file_icon = _tmp31_;
		_tmp32_ = file_icon;
		_tmp33_ = self->priv->goffile;
		_tmp34_ = _tmp33_->emblems_list;
		files_view_abstract_properties_dialog_overlay_emblems ((FilesViewAbstractPropertiesDialog*) self, _tmp32_, _tmp34_);
		_g_object_unref0 (file_icon);
	}
	if (!self->priv->only_one) {
		gchar* _tmp35_;
		gchar* _tmp36_;
		GtkLabel* _tmp37_;
		_tmp35_ = files_view_properties_window_get_selected_label (self, self->priv->selected_folders, self->priv->selected_files);
		_tmp36_ = _tmp35_;
		_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
		g_object_ref_sink (_tmp37_);
		_g_object_unref0 (((FilesViewAbstractPropertiesDialog*) self)->header_title);
		((FilesViewAbstractPropertiesDialog*) self)->header_title = (GtkWidget*) _tmp37_;
		_g_free0 (_tmp36_);
	} else {
		FilesFile* _tmp38_;
		_tmp38_ = self->priv->goffile;
		if (!files_file_is_writable (_tmp38_)) {
			FilesFile* _tmp39_;
			GFileInfo* _tmp40_;
			const gchar* _tmp41_;
			GtkLabel* _tmp42_;
			_tmp39_ = self->priv->goffile;
			_tmp40_ = _tmp39_->info;
			_tmp41_ = g_file_info_get_name (_tmp40_);
			_tmp42_ = (GtkLabel*) gtk_label_new (_tmp41_);
			g_object_ref_sink (_tmp42_);
			_g_object_unref0 (((FilesViewAbstractPropertiesDialog*) self)->header_title);
			((FilesViewAbstractPropertiesDialog*) self)->header_title = (GtkWidget*) _tmp42_;
		} else {
			GtkEntry* _tmp43_;
			GtkEntry* _tmp44_;
			FilesFile* _tmp45_;
			GFileInfo* _tmp46_;
			const gchar* _tmp47_;
			GtkEntry* _tmp48_;
			GtkEntry* _tmp49_;
			GtkEntry* _tmp50_;
			GtkWidget* _tmp51_;
			_tmp43_ = (GtkEntry*) gtk_entry_new ();
			g_object_ref_sink (_tmp43_);
			_tmp44_ = _tmp43_;
			files_view_properties_window_set_entry (self, _tmp44_);
			_g_object_unref0 (_tmp44_);
			_tmp45_ = self->priv->goffile;
			_tmp46_ = _tmp45_->info;
			_tmp47_ = g_file_info_get_name (_tmp46_);
			files_view_properties_window_set_original_name (self, _tmp47_);
			files_view_properties_window_reset_entry_text (self, NULL);
			_tmp48_ = self->priv->_entry;
			g_signal_connect_object (_tmp48_, "activate", (GCallback) _____lambda142__gtk_entry_activate, self, 0);
			_tmp49_ = self->priv->_entry;
			g_signal_connect_object ((GtkWidget*) _tmp49_, "focus-out-event", (GCallback) _____lambda144__gtk_widget_focus_out_event, self, 0);
			_tmp50_ = self->priv->_entry;
			_tmp51_ = _g_object_ref0 ((GtkWidget*) _tmp50_);
			_g_object_unref0 (((FilesViewAbstractPropertiesDialog*) self)->header_title);
			((FilesViewAbstractPropertiesDialog*) self)->header_title = _tmp51_;
		}
	}
	files_view_abstract_properties_dialog_create_header_title ((FilesViewAbstractPropertiesDialog*) self);
	_tmp52_ = ((FilesViewAbstractPropertiesDialog*) self)->stack;
	_tmp53_ = files_view_properties_window_construct_perm_panel (self);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_enum_to_string (FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_TYPE_PANEL_TYPE, FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_PERMISSIONS);
	gtk_stack_add_titled (_tmp52_, _tmp54_, _tmp55_, _ ("Permissions"));
	_g_free0 (_tmp55_);
	_g_object_unref0 (_tmp54_);
	_tmp56_ = ((FilesViewAbstractPropertiesDialog*) self)->stack;
	_tmp57_ = _g_object_ref0 (_tmp56_);
	_tmp58_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	gtk_box_set_homogeneous ((GtkBox*) _tmp58_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp58_, 12);
	gtk_stack_switcher_set_stack (_tmp58_, _tmp57_);
	_g_object_unref0 (_tmp57_);
	g_object_ref_sink (_tmp58_);
	stack_switcher = _tmp58_;
	_tmp59_ = ((FilesViewAbstractPropertiesDialog*) self)->layout;
	_tmp60_ = stack_switcher;
	gtk_grid_attach (_tmp59_, (GtkWidget*) _tmp60_, 0, 1, 2, 1);
	_tmp61_ = ((FilesViewAbstractPropertiesDialog*) self)->layout;
	gtk_widget_show_all ((GtkWidget*) _tmp61_);
	gtk_window_present ((GtkWindow*) self);
	_g_object_unref0 (stack_switcher);
	_g_object_unref0 (file_pix);
	return self;
}

FilesViewPropertiesWindow*
files_view_properties_window_new (GList* _files,
                                  FilesAbstractDirectoryView* _view,
                                  GtkWindow* parent)
{
	return files_view_properties_window_construct (FILES_VIEW_TYPE_PROPERTIES_WINDOW, _files, _view, parent);
}

static void
files_view_properties_window_update_size_value (FilesViewPropertiesWindow* self)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GtkWidget* _tmp18_;
	gchar* contains_value = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GtkGrid* _tmp57_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size_value;
	_tmp1_ = g_format_size_full (self->priv->total_size, G_FORMAT_SIZE_DEFAULT);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = files_view_properties_window_get_uncounted_folders (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((guint) 0)) {
		GtkSpinner* _tmp5_;
		_tmp5_ = self->priv->spinner;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	if (self->priv->only_one) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->ftype;
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkLabel* type_key_label = NULL;
		GtkLabel* _tmp8_;
		GtkLabel* type_value = NULL;
		FilesFile* _tmp9_;
		const gchar* _tmp10_;
		GtkLabel* _tmp11_;
		GtkGrid* _tmp12_;
		GtkLabel* _tmp13_;
		GtkGrid* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		_tmp8_ = files_make_key_label (_ ("Type:"));
		type_key_label = _tmp8_;
		_tmp9_ = self->priv->goffile;
		_tmp10_ = _tmp9_->formated_type;
		_tmp11_ = files_make_value_label (_tmp10_);
		type_value = _tmp11_;
		_tmp12_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp13_ = type_key_label;
		gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 0, 2, 1, 1);
		_tmp14_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp15_ = type_value;
		_tmp16_ = type_key_label;
		gtk_grid_attach_next_to (_tmp14_, (GtkWidget*) _tmp15_, (GtkWidget*) _tmp16_, GTK_POS_RIGHT, 1, 1);
		_g_object_unref0 (type_value);
		_g_object_unref0 (type_key_label);
	}
	_tmp18_ = ((FilesViewAbstractPropertiesDialog*) self)->header_title;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_entry_get_type ())) {
		FilesAbstractDirectoryView* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->priv->_view;
		_tmp20_ = files_abstract_directory_view_get_in_recent (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = !_tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint start_offset = 0;
		gint end_offset = 0;
		FilesFile* _tmp22_;
		GFileInfo* _tmp23_;
		const gchar* _tmp24_;
		FilesFile* _tmp25_;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		GtkWidget* _tmp28_;
		start_offset = 0;
		end_offset = -1;
		_tmp22_ = self->priv->goffile;
		_tmp23_ = _tmp22_->info;
		_tmp24_ = g_file_info_get_name (_tmp23_);
		_tmp25_ = self->priv->goffile;
		files_file_utils_get_rename_region (_tmp24_, &_tmp26_, &_tmp27_, files_file_is_folder (_tmp25_));
		start_offset = _tmp26_;
		end_offset = _tmp27_;
		_tmp28_ = ((FilesViewAbstractPropertiesDialog*) self)->header_title;
		gtk_editable_select_region ((GtkEditable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_entry_get_type (), GtkEntry), start_offset, end_offset);
	}
	_tmp29_ = files_view_properties_window_get_contains_value (self, self->priv->folder_count, self->priv->file_count);
	contains_value = _tmp29_;
	if (self->priv->selected_files == ((guint) 0)) {
		const gchar* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp31_ = contains_value;
		_tmp32_ = strlen (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp30_ = _tmp33_ > 0;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GtkLabel* contains_key_label = NULL;
		GtkLabel* _tmp34_;
		GtkLabel* contains_label = NULL;
		const gchar* _tmp35_;
		GtkLabel* _tmp36_;
		GtkGrid* _tmp37_;
		GtkLabel* _tmp38_;
		GtkGrid* _tmp39_;
		GtkLabel* _tmp40_;
		GtkLabel* _tmp41_;
		_tmp34_ = files_make_key_label (_ ("Contains:"));
		contains_key_label = _tmp34_;
		_tmp35_ = contains_value;
		_tmp36_ = files_make_value_label (_tmp35_);
		contains_label = _tmp36_;
		_tmp37_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp38_ = contains_key_label;
		gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 0, 3, 1, 1);
		_tmp39_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp40_ = contains_label;
		_tmp41_ = contains_key_label;
		gtk_grid_attach_next_to (_tmp39_, (GtkWidget*) _tmp40_, (GtkWidget*) _tmp41_, GTK_POS_RIGHT, 1, 1);
		_g_object_unref0 (contains_label);
		_g_object_unref0 (contains_key_label);
	}
	if (self->priv->size_warning > 0) {
		GtkImage* size_warning_image = NULL;
		GtkImage* _tmp42_ = NULL;
		gchar* warning = NULL;
		gchar* _tmp43_;
		GtkImage* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		GtkGrid* _tmp54_;
		GtkImage* _tmp55_;
		GtkLabel* _tmp56_;
		_tmp42_ = (GtkImage*) gtk_image_new_from_icon_name ("help-info-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_START);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp42_, TRUE);
		g_object_ref_sink (_tmp42_);
		size_warning_image = _tmp42_;
		_tmp43_ = g_strdup_printf (ngettext ("%i file could not be read due to permissions or other errors.", "%i files could not be read due to permissions or other errors.", (gulong) self->priv->size_warning), self->priv->size_warning);
		warning = _tmp43_;
		_tmp44_ = size_warning_image;
		_tmp45_ = g_strconcat ("<b>", _ ("Actual Size Could Be Larger"), NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strconcat (_tmp46_, "</b>", NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat (_tmp48_, "\n", NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = warning;
		_tmp52_ = g_strconcat (_tmp50_, _tmp51_, NULL);
		_tmp53_ = _tmp52_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp44_, _tmp53_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_tmp54_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp55_ = size_warning_image;
		_tmp56_ = self->priv->size_value;
		gtk_grid_attach_next_to (_tmp54_, (GtkWidget*) _tmp55_, (GtkWidget*) _tmp56_, GTK_POS_RIGHT, 1, 1);
		_g_free0 (warning);
		_g_object_unref0 (size_warning_image);
	}
	_tmp57_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp57_);
	_g_free0 (contains_value);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		FilesViewPropertiesWindow* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->d);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
_____lambda140_ (Block8Data* _data8_)
{
	FilesViewPropertiesWindow* self;
	FilesDeepCount* _tmp0_;
	FilesDeepCount* _tmp1_;
	FilesDeepCount* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	FilesDeepCount* _tmp6_;
	FilesDeepCount* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	self = _data8_->self;
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = _data8_->d;
	self->priv->deep_count_directories = vala_g_list_remove_full (self->priv->deep_count_directories, _tmp0_, _g_object_unref0_);
	_tmp1_ = _data8_->d;
	self->priv->total_size = self->priv->total_size + _tmp1_->total_size;
	_tmp2_ = _data8_->d;
	self->priv->size_warning = _tmp2_->file_not_read;
	_tmp3_ = files_view_properties_window_get_uncounted_folders (self);
	_tmp4_ = _tmp3_;
	if ((self->priv->file_count + _tmp4_) == ((guint) self->priv->size_warning)) {
		GtkLabel* _tmp5_;
		_tmp5_ = self->priv->size_value;
		gtk_label_set_label (_tmp5_, _ ("unknown"));
	}
	_tmp6_ = _data8_->d;
	self->priv->folder_count = self->priv->folder_count + _tmp6_->dirs_count;
	_tmp7_ = _data8_->d;
	self->priv->file_count = self->priv->file_count + _tmp7_->files_count;
	_tmp8_ = files_view_properties_window_get_uncounted_folders (self);
	_tmp9_ = _tmp8_;
	files_view_properties_window_set_uncounted_folders (self, _tmp9_ - 1);
	g_mutex_unlock (&self->priv->mutex);
}

static void
______lambda140__files_deep_count_finished (FilesDeepCount* _sender,
                                            gpointer self)
{
	_____lambda140_ (self);
}

static void
___lambda141_ (FilesViewPropertiesWindow* self)
{
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = files_view_properties_window_get_uncounted_folders (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GtkSpinner* _tmp2_;
		GtkSpinner* _tmp3_;
		_tmp2_ = self->priv->spinner;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->spinner;
		gtk_spinner_stop (_tmp3_);
		files_view_properties_window_update_size_value (self);
	}
}

static void
____lambda141__files_view_properties_window_uncounted_folders_changed (FilesViewPropertiesWindow* _sender,
                                                                       gpointer self)
{
	___lambda141_ ((FilesViewPropertiesWindow*) self);
}

static void
files_view_properties_window_update_selection_size (FilesViewPropertiesWindow* self)
{
	GList* _tmp0_;
	guint _tmp17_;
	guint _tmp18_;
	g_return_if_fail (self != NULL);
	self->priv->total_size = (guint64) 0;
	files_view_properties_window_set_uncounted_folders (self, (guint) 0);
	self->priv->selected_folders = (guint) 0;
	self->priv->selected_files = (guint) 0;
	self->priv->folder_count = (guint) 0;
	self->priv->file_count = (guint) 0;
	self->priv->size_warning = 0;
	(self->priv->deep_count_directories == NULL) ? NULL : (self->priv->deep_count_directories = (_g_list_free__g_object_unref0_ (self->priv->deep_count_directories), NULL));
	self->priv->deep_count_directories = NULL;
	_tmp0_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp0_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp1_;
			FilesFile* gof = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp1_;
			{
				FilesFile* _tmp2_;
				FilesFile* _tmp4_;
				FilesFile* _tmp16_;
				_tmp2_ = gof;
				if (files_file_is_root_network_folder (_tmp2_)) {
					GtkLabel* _tmp3_;
					_tmp3_ = self->priv->size_value;
					gtk_label_set_label (_tmp3_, _ ("unknown"));
					_g_object_unref0 (gof);
					continue;
				}
				_tmp4_ = gof;
				if (_tmp4_->is_directory) {
					Block8Data* _data8_;
					guint _tmp5_;
					guint _tmp6_;
					guint _tmp7_;
					FilesFile* _tmp8_;
					GFile* _tmp9_;
					GFile* _tmp10_;
					FilesDeepCount* _tmp11_;
					FilesDeepCount* _tmp12_;
					FilesDeepCount* _tmp13_;
					FilesDeepCount* _tmp14_;
					_data8_ = g_slice_new0 (Block8Data);
					_data8_->_ref_count_ = 1;
					_data8_->self = g_object_ref (self);
					g_mutex_lock (&self->priv->mutex);
					_tmp5_ = files_view_properties_window_get_uncounted_folders (self);
					_tmp6_ = _tmp5_;
					files_view_properties_window_set_uncounted_folders (self, _tmp6_ + 1);
					g_mutex_unlock (&self->priv->mutex);
					_tmp7_ = self->priv->selected_folders;
					self->priv->selected_folders = _tmp7_ + 1;
					_tmp8_ = gof;
					_tmp9_ = files_file_get_location (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = files_deep_count_new (_tmp10_);
					_data8_->d = _tmp11_;
					_tmp12_ = _data8_->d;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					self->priv->deep_count_directories = g_list_prepend (self->priv->deep_count_directories, _tmp13_);
					_tmp14_ = _data8_->d;
					g_signal_connect_data (_tmp14_, "finished", (GCallback) ______lambda140__files_deep_count_finished, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
					block8_data_unref (_data8_);
					_data8_ = NULL;
				} else {
					guint _tmp15_;
					_tmp15_ = self->priv->selected_files;
					self->priv->selected_files = _tmp15_ + 1;
				}
				g_mutex_lock (&self->priv->mutex);
				_tmp16_ = gof;
				self->priv->total_size = self->priv->total_size + files_view_properties_window_file_real_size (_tmp16_);
				g_mutex_unlock (&self->priv->mutex);
				_g_object_unref0 (gof);
			}
		}
	}
	_tmp17_ = files_view_properties_window_get_uncounted_folders (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ > ((guint) 0)) {
		GtkSpinner* _tmp19_;
		_tmp19_ = self->priv->spinner;
		gtk_spinner_start (_tmp19_);
		g_signal_connect_object (self, "uncounted-folders-changed", (GCallback) ____lambda141__files_view_properties_window_uncounted_folders_changed, self, 0);
	} else {
		files_view_properties_window_update_size_value (self);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
____lambda143_ (FilesViewPropertiesWindow* self,
                GObject* obj,
                GAsyncResult* res)
{
	GFile* new_location = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	new_location = NULL;
	{
		GFile* _tmp0_ = NULL;
		FilesAbstractDirectoryView* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFile* _tmp7_;
		FilesFile* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		FilesFile* _tmp11_;
		FilesFile* _tmp12_;
		_tmp1_ = self->priv->_view;
		_tmp2_ = files_abstract_directory_view_set_file_display_name_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (new_location);
		new_location = _tmp3_;
		_tmp4_ = new_location;
		_tmp5_ = g_file_get_basename (_tmp4_);
		_tmp6_ = _tmp5_;
		files_view_properties_window_reset_entry_text (self, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = new_location;
		_tmp8_ = files_file_get (_tmp7_);
		_g_object_unref0 (self->priv->goffile);
		self->priv->goffile = _tmp8_;
		_tmp9_ = self->priv->files;
		_tmp10_ = g_list_first (_tmp9_);
		_tmp11_ = self->priv->goffile;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (_tmp10_->data);
		_tmp10_->data = _tmp12_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (new_location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (new_location);
}

static void
_____lambda143__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	____lambda143_ ((FilesViewPropertiesWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
files_view_properties_window_rename_file (FilesViewPropertiesWindow* self,
                                          FilesFile* file,
                                          const gchar* _new_name)
{
	GFileInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* new_name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (_new_name != NULL);
	_tmp0_ = file->info;
	_tmp1_ = g_file_info_get_name (_tmp0_);
	files_view_properties_window_set_original_name (self, _tmp1_);
	_tmp2_ = string_strip (_new_name);
	new_name = _tmp2_;
	_tmp3_ = new_name;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = new_name;
		_tmp5_ = files_view_properties_window_get_original_name (self);
		_tmp6_ = _tmp5_;
		if (g_strcmp0 (_tmp4_, _tmp6_) != 0) {
			const gchar* _tmp7_;
			FilesAbstractDirectoryView* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			const gchar* _tmp11_;
			_tmp7_ = new_name;
			files_view_properties_window_set_proposed_name (self, _tmp7_);
			_tmp8_ = self->priv->_view;
			_tmp9_ = files_file_get_location (file);
			_tmp10_ = _tmp9_;
			_tmp11_ = new_name;
			files_abstract_directory_view_set_file_display_name (_tmp8_, _tmp10_, _tmp11_, NULL, _____lambda143__gasync_ready_callback, g_object_ref (self));
		}
	} else {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		g_warning ("PropertiesWindow.vala:374: Blank name not allowed");
		_tmp12_ = files_view_properties_window_get_original_name (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (new_name);
		new_name = _tmp14_;
	}
	_tmp15_ = new_name;
	files_view_properties_window_reset_entry_text (self, _tmp15_);
	_g_free0 (new_name);
}

void
files_view_properties_window_reset_entry_text (FilesViewPropertiesWindow* self,
                                               const gchar* new_name)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (new_name != NULL) {
		files_view_properties_window_set_original_name (self, new_name);
	}
	_tmp0_ = self->priv->_entry;
	_tmp1_ = files_view_properties_window_get_original_name (self);
	_tmp2_ = _tmp1_;
	gtk_entry_set_text (_tmp0_, _tmp2_);
}

static gchar*
files_view_properties_window_get_common_ftype (FilesViewPropertiesWindow* self)
{
	gchar* ftype = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ftype = NULL;
	_tmp0_ = self->priv->files;
	if (_tmp0_ == NULL) {
		result = NULL;
		_g_free0 (ftype);
		return result;
	}
	_tmp1_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp2_;
			FilesFile* gof = NULL;
			_tmp2_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp2_;
			{
				gchar* gof_ftype = NULL;
				FilesFile* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp3_ = gof;
				_tmp4_ = files_file_get_ftype (_tmp3_);
				_tmp5_ = g_strdup (_tmp4_);
				gof_ftype = _tmp5_;
				_tmp7_ = ftype;
				if (_tmp7_ == NULL) {
					FilesFile* _tmp8_;
					_tmp8_ = gof;
					_tmp6_ = _tmp8_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = gof_ftype;
					_tmp10_ = g_strdup (_tmp9_);
					_g_free0 (ftype);
					ftype = _tmp10_;
					_g_free0 (gof_ftype);
					_g_object_unref0 (gof);
					continue;
				}
				_tmp11_ = ftype;
				_tmp12_ = gof_ftype;
				if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
					result = NULL;
					_g_free0 (gof_ftype);
					_g_object_unref0 (gof);
					_g_free0 (ftype);
					return result;
				}
				_g_free0 (gof_ftype);
				_g_object_unref0 (gof);
			}
		}
	}
	result = ftype;
	return result;
}

static gboolean
files_view_properties_window_got_common_location (FilesViewPropertiesWindow* self)
{
	GFile* loc = NULL;
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	loc = NULL;
	_tmp0_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp0_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp1_;
			FilesFile* gof = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				GFile* _tmp3_;
				GFile* _tmp12_;
				FilesFile* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				_tmp3_ = loc;
				if (_tmp3_ == NULL) {
					FilesFile* _tmp4_;
					_tmp4_ = gof;
					_tmp2_ = _tmp4_ != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					FilesFile* _tmp5_;
					GFile* _tmp6_;
					GFile* _tmp7_;
					FilesFile* _tmp8_;
					GFile* _tmp9_;
					GFile* _tmp10_;
					GFile* _tmp11_;
					_tmp5_ = gof;
					_tmp6_ = files_file_get_directory (_tmp5_);
					_tmp7_ = _tmp6_;
					if (_tmp7_ == NULL) {
						result = FALSE;
						_g_object_unref0 (gof);
						_g_object_unref0 (loc);
						return result;
					}
					_tmp8_ = gof;
					_tmp9_ = files_file_get_directory (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (loc);
					loc = _tmp11_;
					_g_object_unref0 (gof);
					continue;
				}
				_tmp12_ = loc;
				_tmp13_ = gof;
				_tmp14_ = files_file_get_directory (_tmp13_);
				_tmp15_ = _tmp14_;
				if (!g_file_equal (_tmp12_, _tmp15_)) {
					result = FALSE;
					_g_object_unref0 (gof);
					_g_object_unref0 (loc);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (loc);
	return result;
}

static GFile*
files_view_properties_window_get_parent_loc (FilesViewPropertiesWindow* self,
                                             const gchar* path)
{
	GFile* loc = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (path);
	loc = _tmp0_;
	_tmp1_ = g_file_get_parent (loc);
	result = _tmp1_;
	_g_object_unref0 (loc);
	return result;
}

static gchar*
files_view_properties_window_get_common_trash_orig (FilesViewPropertiesWindow* self)
{
	GFile* loc = NULL;
	gchar* path = NULL;
	GList* _tmp0_;
	GFile* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	loc = NULL;
	path = NULL;
	_tmp0_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp0_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp1_;
			FilesFile* gof = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				GFile* _tmp3_;
				gboolean _tmp9_ = FALSE;
				FilesFile* _tmp10_;
				_tmp3_ = loc;
				if (_tmp3_ == NULL) {
					FilesFile* _tmp4_;
					_tmp4_ = gof;
					_tmp2_ = _tmp4_ != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					FilesFile* _tmp5_;
					GFileInfo* _tmp6_;
					const gchar* _tmp7_;
					GFile* _tmp8_;
					_tmp5_ = gof;
					_tmp6_ = _tmp5_->info;
					_tmp7_ = g_file_info_get_attribute_byte_string (_tmp6_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
					_tmp8_ = files_view_properties_window_get_parent_loc (self, _tmp7_);
					_g_object_unref0 (loc);
					loc = _tmp8_;
					_g_object_unref0 (gof);
					continue;
				}
				_tmp10_ = gof;
				if (_tmp10_ != NULL) {
					GFile* _tmp11_;
					FilesFile* _tmp12_;
					GFileInfo* _tmp13_;
					const gchar* _tmp14_;
					GFile* _tmp15_;
					GFile* _tmp16_;
					_tmp11_ = loc;
					_tmp12_ = gof;
					_tmp13_ = _tmp12_->info;
					_tmp14_ = g_file_info_get_attribute_byte_string (_tmp13_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
					_tmp15_ = files_view_properties_window_get_parent_loc (self, _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp9_ = !g_file_equal (_tmp11_, _tmp16_);
					_g_object_unref0 (_tmp16_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					result = NULL;
					_g_object_unref0 (gof);
					_g_free0 (path);
					_g_object_unref0 (loc);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	_tmp17_ = loc;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("/");
		_g_free0 (path);
		path = _tmp18_;
	} else {
		GFile* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = loc;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_g_free0 (path);
		path = _tmp20_;
	}
	result = path;
	_g_object_unref0 (loc);
	return result;
}

static gchar*
files_view_properties_window_filetype (FilesViewPropertiesWindow* self,
                                       FilesFile* file)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = files_view_properties_window_get_common_ftype (self);
	_g_free0 (self->priv->ftype);
	self->priv->ftype = _tmp0_;
	_tmp1_ = self->priv->ftype;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->ftype;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		FilesAbstractDirectoryView* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = self->priv->_view;
		_tmp6_ = files_abstract_directory_view_get_default_app (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ != NULL;
		_g_object_unref0 (_tmp7_);
		if (_tmp8_) {
			FilesFile* _tmp9_;
			_tmp9_ = self->priv->goffile;
			_tmp4_ = !_tmp9_->is_directory;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gchar* str = NULL;
			str = NULL;
			{
				GeeIterator* _mime_it = NULL;
				GeeSet* _tmp10_;
				GeeIterator* _tmp11_;
				_tmp10_ = self->priv->mimes;
				_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
				_mime_it = _tmp11_;
				while (TRUE) {
					GeeIterator* _tmp12_;
					gchar* mime = NULL;
					GeeIterator* _tmp13_;
					gpointer _tmp14_;
					const gchar* _tmp15_ = NULL;
					const gchar* _tmp16_;
					_tmp12_ = _mime_it;
					if (!gee_iterator_next (_tmp12_)) {
						break;
					}
					_tmp13_ = _mime_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					mime = (gchar*) _tmp14_;
					_tmp16_ = str;
					if (_tmp16_ == NULL) {
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						_tmp17_ = mime;
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (str);
						str = _tmp18_;
						_tmp19_ = str;
						_tmp15_ = _tmp19_;
					} else {
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp20_ = str;
						_tmp21_ = mime;
						_tmp22_ = g_strjoin (", ", _tmp20_, _tmp21_, NULL);
						_g_free0 (str);
						str = _tmp22_;
						_tmp23_ = str;
						_tmp15_ = _tmp23_;
					}
					_g_free0 (mime);
				}
				_g_object_unref0 (_mime_it);
			}
			result = str;
			return result;
		}
	}
	_tmp24_ = g_strdup (_ ("Unknown"));
	result = _tmp24_;
	return result;
}

static gchar*
files_view_properties_window_resolution (FilesViewPropertiesWindow* self,
                                         FilesFile* file)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	if (file->width > 0) {
		FilesFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		FilesFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp0_ = self->priv->goffile;
		_tmp1_ = g_strdup_printf ("%i", _tmp0_->width);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_tmp2_, " × ", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->goffile;
		_tmp6_ = g_strdup_printf ("%i", _tmp5_->height);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, " px", NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		result = _tmp11_;
		return result;
	} else {
		gchar* _tmp12_;
		files_view_properties_window_get_resolution (self, file, NULL, NULL);
		_tmp12_ = g_strdup (_ ("Loading…"));
		result = _tmp12_;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
files_view_properties_window_location (FilesViewPropertiesWindow* self,
                                       FilesFile* file)
{
	FilesAbstractDirectoryView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = files_abstract_directory_view_get_in_recent (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gchar* original_location = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* file_name = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* location_folder = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* location_name = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp3_ = files_file_get_display_target_uri (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_tmp4_, "%20", " ");
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		original_location = _tmp6_;
		_tmp7_ = files_file_get_display_name (file);
		_tmp8_ = string_replace (_tmp7_, "%20", " ");
		file_name = _tmp8_;
		_tmp9_ = original_location;
		_tmp10_ = file_name;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp9_, (glong) 0, (glong) (-_tmp12_));
		_tmp14_ = _tmp13_;
		_tmp15_ = string_replace (_tmp14_, "%20", " ");
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		location_folder = _tmp16_;
		_tmp17_ = location_folder;
		_tmp18_ = string_slice (_tmp17_, (glong) 7, (glong) -1);
		location_name = _tmp18_;
		_tmp19_ = location_folder;
		_tmp20_ = g_markup_escape_text (_tmp19_, (gssize) -1);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("<a href=\"", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "\">", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = location_name;
		_tmp27_ = g_markup_escape_text (_tmp26_, (gssize) -1);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, "</a>", NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		result = _tmp32_;
		_g_free0 (location_name);
		_g_free0 (location_folder);
		_g_free0 (file_name);
		_g_free0 (original_location);
		return result;
	} else {
		GFile* _tmp33_;
		GFile* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GFile* _tmp43_;
		GFile* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp33_ = files_file_get_directory (file);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_file_get_uri (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_markup_escape_text (_tmp36_, (gssize) -1);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat ("<a href=\"", _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat (_tmp40_, "\">", NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = files_file_get_directory (file);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_file_get_parse_name (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_markup_escape_text (_tmp46_, (gssize) -1);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat (_tmp42_, _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, "</a>", NULL);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		result = _tmp52_;
		return result;
	}
}

static gchar*
files_view_properties_window_original_location (FilesViewPropertiesWindow* self,
                                                FilesFile* file)
{
	GFileInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file->info;
	_tmp1_ = g_file_info_get_attribute_byte_string (_tmp0_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
	if (_tmp1_ != NULL) {
		gchar* trash_orig_loc = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = files_view_properties_window_get_common_trash_orig (self);
		trash_orig_loc = _tmp2_;
		_tmp3_ = trash_orig_loc;
		if (_tmp3_ != NULL) {
			gchar* orig_pth = NULL;
			GFileInfo* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp4_ = file->info;
			_tmp5_ = g_file_info_get_attribute_byte_string (_tmp4_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
			_tmp6_ = g_strdup (_tmp5_);
			orig_pth = _tmp6_;
			_tmp7_ = orig_pth;
			_tmp8_ = files_view_properties_window_get_parent_loc (self, _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_file_get_uri (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("<a href=\"", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, "\">", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = trash_orig_loc;
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, "</a>", NULL);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			result = _tmp20_;
			_g_free0 (orig_pth);
			_g_free0 (trash_orig_loc);
			return result;
		}
		_g_free0 (trash_orig_loc);
	}
	_tmp21_ = g_strdup (_ ("Unknown"));
	result = _tmp21_;
	return result;
}

static void
files_view_properties_window_get_resolution_data_free (gpointer _data)
{
	FilesViewPropertiesWindowGetResolutionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->goffile);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewPropertiesWindowGetResolutionData, _data_);
}

static void
files_view_properties_window_get_resolution (FilesViewPropertiesWindow* self,
                                             FilesFile* goffile,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	FilesViewPropertiesWindowGetResolutionData* _data_;
	FilesViewPropertiesWindow* _tmp0_;
	FilesFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (goffile != NULL);
	_data_ = g_slice_new0 (FilesViewPropertiesWindowGetResolutionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_properties_window_get_resolution_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (goffile);
	_g_object_unref0 (_data_->goffile);
	_data_->goffile = _tmp1_;
	files_view_properties_window_get_resolution_co (_data_);
}

static void
files_view_properties_window_get_resolution_finish (FilesViewPropertiesWindow* self,
                                                    GAsyncResult* _res_)
{
	FilesViewPropertiesWindowGetResolutionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_view_properties_window_get_resolution_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	FilesViewPropertiesWindowGetResolutionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_properties_window_get_resolution_co (_data_);
}

static gboolean
files_view_properties_window_get_resolution_co (FilesViewPropertiesWindowGetResolutionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->stream = NULL;
	_data_->_tmp0_ = files_file_get_location (_data_->goffile);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->file = _data_->_tmp2_;
	_data_->_tmp3_ = g_strdup (_ ("Could not be determined"));
	_data_->resolution = _data_->_tmp3_;
	{
		_data_->_tmp5_ = _data_->file;
		_data_->_tmp6_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp5_, 0, _data_->_tmp6_, files_view_properties_window_get_resolution_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->stream);
		_data_->stream = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->stream;
		if (_data_->_tmp9_ == NULL) {
			g_error ("PropertiesWindow.vala:525: Could not read image file's size data");
		} else {
			_data_->_tmp10_ = _data_->stream;
			_data_->_tmp11_ = _data_->self->priv->cancellable;
			_data_->_state_ = 2;
			gdk_pixbuf_new_from_stream_async ((GInputStream*) _data_->_tmp10_, _data_->_tmp11_, files_view_properties_window_get_resolution_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp12_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->pixbuf = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp4_);
				goto __catch0_g_error;
			}
			_data_->_tmp13_ = _data_->pixbuf;
			_data_->goffile->width = gdk_pixbuf_get_width (_data_->_tmp13_);
			_data_->_tmp14_ = _data_->pixbuf;
			_data_->goffile->height = gdk_pixbuf_get_height (_data_->_tmp14_);
			_data_->_tmp15_ = g_strdup_printf ("%i", _data_->goffile->width);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp17_ = g_strconcat (_data_->_tmp16_, " × ", NULL);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = g_strdup_printf ("%i", _data_->goffile->height);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = g_strconcat (_data_->_tmp18_, _data_->_tmp20_, NULL);
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = g_strconcat (_data_->_tmp22_, " px", NULL);
			_g_free0 (_data_->resolution);
			_data_->resolution = _data_->_tmp23_;
			_g_free0 (_data_->_tmp22_);
			_g_free0 (_data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
			_g_free0 (_data_->_tmp16_);
			_g_object_unref0 (_data_->pixbuf);
		}
		_g_object_unref0 (_data_->_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("PropertiesWindow.vala:533: Error loading image resolution in Propertie" \
"sWindow: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->resolution);
		_g_object_unref0 (_data_->file);
		_g_object_unref0 (_data_->stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp26_ = _data_->stream;
		g_input_stream_close ((GInputStream*) _data_->_tmp26_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->_vala1_e;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_debug ("PropertiesWindow.vala:538: Error closing stream in get_resolution: %s", _data_->_tmp28_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->resolution);
		_g_object_unref0 (_data_->file);
		_g_object_unref0 (_data_->stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = _data_->self->priv->resolution_value;
	_data_->_tmp30_ = _data_->resolution;
	gtk_label_set_label (_data_->_tmp29_, _data_->_tmp30_);
	_g_free0 (_data_->resolution);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_files_view_properties_window_combo_open_with_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self)
{
	files_view_properties_window_combo_open_with_changed ((FilesViewPropertiesWindow*) self, _sender);
}

static void
files_view_properties_window_construct_info_panel (FilesViewPropertiesWindow* self,
                                                   FilesFile* file)
{
	GtkLabel* size_key_label = NULL;
	GtkLabel* _tmp0_;
	GtkSpinner* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkLabel* _tmp3_;
	GtkGrid* _tmp4_;
	GtkLabel* _tmp5_;
	GtkGrid* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkLabel* _tmp8_;
	GtkGrid* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	gint n = 0;
	gboolean _tmp36_ = FALSE;
	gchar* ftype = NULL;
	gchar* _tmp49_;
	GtkLabel* mimetype_key = NULL;
	GtkLabel* _tmp50_;
	GtkLabel* mimetype_value = NULL;
	const gchar* _tmp51_;
	GtkLabel* _tmp52_;
	GtkGrid* _tmp53_;
	GtkLabel* _tmp54_;
	GtkGrid* _tmp55_;
	GtkLabel* _tmp56_;
	GtkLabel* _tmp57_;
	gint _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp107_ = FALSE;
	FilesAbstractDirectoryView* _tmp108_;
	GAppInfo* _tmp109_;
	GAppInfo* _tmp110_;
	gboolean _tmp111_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = files_make_key_label (_ ("Size:"));
	size_key_label = _tmp0_;
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp1_;
	_tmp2_ = self->priv->spinner;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	_tmp3_ = files_make_value_label ("");
	_g_object_unref0 (self->priv->size_value);
	self->priv->size_value = _tmp3_;
	_tmp4_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	_tmp5_ = size_key_label;
	gtk_grid_attach (_tmp4_, (GtkWidget*) _tmp5_, 0, 1, 1, 1);
	_tmp6_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	_tmp7_ = self->priv->spinner;
	_tmp8_ = size_key_label;
	gtk_grid_attach_next_to (_tmp6_, (GtkWidget*) _tmp7_, (GtkWidget*) _tmp8_, GTK_POS_RIGHT, 1, 1);
	_tmp9_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	_tmp10_ = self->priv->size_value;
	_tmp11_ = size_key_label;
	gtk_grid_attach_next_to (_tmp9_, (GtkWidget*) _tmp10_, (GtkWidget*) _tmp11_, GTK_POS_RIGHT, 1, 1);
	n = 4;
	if (self->priv->only_one) {
		gchar* time_created = NULL;
		GFileInfo* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* time_modified = NULL;
		GFileInfo* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp12_ = file->info;
		_tmp13_ = files_file_utils_get_formatted_time_attribute_from_info (_tmp12_, G_FILE_ATTRIBUTE_TIME_CREATED);
		time_created = _tmp13_;
		_tmp14_ = time_created;
		if (g_strcmp0 (_tmp14_, "") != 0) {
			GtkLabel* key_label = NULL;
			GtkLabel* _tmp15_;
			GtkLabel* value_label = NULL;
			const gchar* _tmp16_;
			GtkLabel* _tmp17_;
			GtkGrid* _tmp18_;
			GtkLabel* _tmp19_;
			GtkGrid* _tmp20_;
			GtkLabel* _tmp21_;
			GtkLabel* _tmp22_;
			gint _tmp23_;
			_tmp15_ = files_make_key_label (_ ("Created:"));
			key_label = _tmp15_;
			_tmp16_ = time_created;
			_tmp17_ = files_make_value_label (_tmp16_);
			value_label = _tmp17_;
			_tmp18_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp19_ = key_label;
			gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, n, 1, 1);
			_tmp20_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp21_ = value_label;
			_tmp22_ = key_label;
			gtk_grid_attach_next_to (_tmp20_, (GtkWidget*) _tmp21_, (GtkWidget*) _tmp22_, GTK_POS_RIGHT, 3, 1);
			_tmp23_ = n;
			n = _tmp23_ + 1;
			_g_object_unref0 (value_label);
			_g_object_unref0 (key_label);
		}
		_tmp24_ = file->info;
		_tmp25_ = files_file_utils_get_formatted_time_attribute_from_info (_tmp24_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
		time_modified = _tmp25_;
		_tmp26_ = time_modified;
		if (g_strcmp0 (_tmp26_, "") != 0) {
			GtkLabel* key_label = NULL;
			GtkLabel* _tmp27_;
			GtkLabel* value_label = NULL;
			const gchar* _tmp28_;
			GtkLabel* _tmp29_;
			GtkGrid* _tmp30_;
			GtkLabel* _tmp31_;
			GtkGrid* _tmp32_;
			GtkLabel* _tmp33_;
			GtkLabel* _tmp34_;
			gint _tmp35_;
			_tmp27_ = files_make_key_label (_ ("Modified:"));
			key_label = _tmp27_;
			_tmp28_ = time_modified;
			_tmp29_ = files_make_value_label (_tmp28_);
			value_label = _tmp29_;
			_tmp30_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp31_ = key_label;
			gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, n, 1, 1);
			_tmp32_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp33_ = value_label;
			_tmp34_ = key_label;
			gtk_grid_attach_next_to (_tmp32_, (GtkWidget*) _tmp33_, (GtkWidget*) _tmp34_, GTK_POS_RIGHT, 3, 1);
			_tmp35_ = n;
			n = _tmp35_ + 1;
			_g_object_unref0 (value_label);
			_g_object_unref0 (key_label);
		}
		_g_free0 (time_modified);
		_g_free0 (time_created);
	}
	if (self->priv->only_one) {
		_tmp36_ = files_file_is_trashed (file);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gchar* deletion_date = NULL;
		GFileInfo* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp37_ = file->info;
		_tmp38_ = files_file_utils_get_formatted_time_attribute_from_info (_tmp37_, G_FILE_ATTRIBUTE_TRASH_DELETION_DATE);
		deletion_date = _tmp38_;
		_tmp39_ = deletion_date;
		if (g_strcmp0 (_tmp39_, "") != 0) {
			GtkLabel* key_label = NULL;
			GtkLabel* _tmp40_;
			GtkLabel* value_label = NULL;
			const gchar* _tmp41_;
			GtkLabel* _tmp42_;
			GtkGrid* _tmp43_;
			GtkLabel* _tmp44_;
			GtkGrid* _tmp45_;
			GtkLabel* _tmp46_;
			GtkLabel* _tmp47_;
			gint _tmp48_;
			_tmp40_ = files_make_key_label (_ ("Deleted:"));
			key_label = _tmp40_;
			_tmp41_ = deletion_date;
			_tmp42_ = files_make_value_label (_tmp41_);
			value_label = _tmp42_;
			_tmp43_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp44_ = key_label;
			gtk_grid_attach (_tmp43_, (GtkWidget*) _tmp44_, 0, n, 1, 1);
			_tmp45_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
			_tmp46_ = value_label;
			_tmp47_ = key_label;
			gtk_grid_attach_next_to (_tmp45_, (GtkWidget*) _tmp46_, (GtkWidget*) _tmp47_, GTK_POS_RIGHT, 3, 1);
			_tmp48_ = n;
			n = _tmp48_ + 1;
			_g_object_unref0 (value_label);
			_g_object_unref0 (key_label);
		}
		_g_free0 (deletion_date);
	}
	_tmp49_ = files_view_properties_window_filetype (self, file);
	ftype = _tmp49_;
	_tmp50_ = files_make_key_label (_ ("Media type:"));
	mimetype_key = _tmp50_;
	_tmp51_ = ftype;
	_tmp52_ = files_make_value_label (_tmp51_);
	mimetype_value = _tmp52_;
	_tmp53_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	_tmp54_ = mimetype_key;
	gtk_grid_attach (_tmp53_, (GtkWidget*) _tmp54_, 0, n, 1, 1);
	_tmp55_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
	_tmp56_ = mimetype_value;
	_tmp57_ = mimetype_key;
	gtk_grid_attach_next_to (_tmp55_, (GtkWidget*) _tmp56_, (GtkWidget*) _tmp57_, GTK_POS_RIGHT, 3, 1);
	_tmp58_ = n;
	n = _tmp58_ + 1;
	if (self->priv->only_one) {
		const gchar* _tmp60_;
		_tmp60_ = ftype;
		_tmp59_ = string_contains (_tmp60_, "image");
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		GtkLabel* resolution_key = NULL;
		GtkLabel* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		GtkLabel* _tmp64_;
		GtkGrid* _tmp65_;
		GtkLabel* _tmp66_;
		GtkGrid* _tmp67_;
		GtkLabel* _tmp68_;
		GtkLabel* _tmp69_;
		gint _tmp70_;
		_tmp61_ = files_make_key_label (_ ("Resolution:"));
		resolution_key = _tmp61_;
		_tmp62_ = files_view_properties_window_resolution (self, file);
		_tmp63_ = _tmp62_;
		_tmp64_ = files_make_value_label (_tmp63_);
		_g_object_unref0 (self->priv->resolution_value);
		self->priv->resolution_value = _tmp64_;
		_g_free0 (_tmp63_);
		_tmp65_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp66_ = resolution_key;
		gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, n, 1, 1);
		_tmp67_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp68_ = self->priv->resolution_value;
		_tmp69_ = resolution_key;
		gtk_grid_attach_next_to (_tmp67_, (GtkWidget*) _tmp68_, (GtkWidget*) _tmp69_, GTK_POS_RIGHT, 3, 1);
		_tmp70_ = n;
		n = _tmp70_ + 1;
		_g_object_unref0 (resolution_key);
	}
	if (files_view_properties_window_got_common_location (self)) {
		GtkLabel* location_key = NULL;
		GtkLabel* _tmp71_;
		GtkLabel* location_value = NULL;
		gchar* _tmp72_;
		gchar* _tmp73_;
		GtkLabel* _tmp74_;
		GtkLabel* _tmp75_;
		GtkLabel* _tmp76_;
		GtkLabel* _tmp77_;
		GtkGrid* _tmp78_;
		GtkLabel* _tmp79_;
		GtkGrid* _tmp80_;
		GtkLabel* _tmp81_;
		GtkLabel* _tmp82_;
		gint _tmp83_;
		_tmp71_ = files_make_key_label (_ ("Location:"));
		location_key = _tmp71_;
		_tmp72_ = files_view_properties_window_location (self, file);
		_tmp73_ = _tmp72_;
		_tmp74_ = files_make_value_label (_tmp73_);
		_tmp75_ = _tmp74_;
		_g_free0 (_tmp73_);
		location_value = _tmp75_;
		_tmp76_ = location_value;
		gtk_label_set_ellipsize (_tmp76_, PANGO_ELLIPSIZE_MIDDLE);
		_tmp77_ = location_value;
		gtk_label_set_max_width_chars (_tmp77_, 32);
		_tmp78_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp79_ = location_key;
		gtk_grid_attach (_tmp78_, (GtkWidget*) _tmp79_, 0, n, 1, 1);
		_tmp80_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp81_ = location_value;
		_tmp82_ = location_key;
		gtk_grid_attach_next_to (_tmp80_, (GtkWidget*) _tmp81_, (GtkWidget*) _tmp82_, GTK_POS_RIGHT, 3, 1);
		_tmp83_ = n;
		n = _tmp83_ + 1;
		_g_object_unref0 (location_value);
		_g_object_unref0 (location_key);
	}
	if (self->priv->only_one) {
		GFileInfo* _tmp85_;
		_tmp85_ = file->info;
		_tmp84_ = g_file_info_get_attribute_boolean (_tmp85_, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK);
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		GtkLabel* key_label = NULL;
		GtkLabel* _tmp86_;
		GtkLabel* value_label = NULL;
		GFileInfo* _tmp87_;
		const gchar* _tmp88_;
		GtkLabel* _tmp89_;
		GtkGrid* _tmp90_;
		GtkLabel* _tmp91_;
		GtkGrid* _tmp92_;
		GtkLabel* _tmp93_;
		GtkLabel* _tmp94_;
		gint _tmp95_;
		_tmp86_ = files_make_key_label (_ ("Target:"));
		key_label = _tmp86_;
		_tmp87_ = file->info;
		_tmp88_ = g_file_info_get_attribute_byte_string (_tmp87_, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
		_tmp89_ = files_make_value_label (_tmp88_);
		value_label = _tmp89_;
		_tmp90_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp91_ = key_label;
		gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 0, n, 1, 1);
		_tmp92_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp93_ = value_label;
		_tmp94_ = key_label;
		gtk_grid_attach_next_to (_tmp92_, (GtkWidget*) _tmp93_, (GtkWidget*) _tmp94_, GTK_POS_RIGHT, 3, 1);
		_tmp95_ = n;
		n = _tmp95_ + 1;
		_g_object_unref0 (value_label);
		_g_object_unref0 (key_label);
	}
	if (files_file_is_trashed (file)) {
		GtkLabel* key_label = NULL;
		GtkLabel* _tmp96_;
		GtkLabel* value_label = NULL;
		gchar* _tmp97_;
		gchar* _tmp98_;
		GtkLabel* _tmp99_;
		GtkLabel* _tmp100_;
		GtkGrid* _tmp101_;
		GtkLabel* _tmp102_;
		GtkGrid* _tmp103_;
		GtkLabel* _tmp104_;
		GtkLabel* _tmp105_;
		gint _tmp106_;
		_tmp96_ = files_make_key_label (_ ("Original Location:"));
		key_label = _tmp96_;
		_tmp97_ = files_view_properties_window_original_location (self, file);
		_tmp98_ = _tmp97_;
		_tmp99_ = files_make_value_label (_tmp98_);
		_tmp100_ = _tmp99_;
		_g_free0 (_tmp98_);
		value_label = _tmp100_;
		_tmp101_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp102_ = key_label;
		gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 0, n, 1, 1);
		_tmp103_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp104_ = value_label;
		_tmp105_ = key_label;
		gtk_grid_attach_next_to (_tmp103_, (GtkWidget*) _tmp104_, (GtkWidget*) _tmp105_, GTK_POS_RIGHT, 3, 1);
		_tmp106_ = n;
		n = _tmp106_ + 1;
		_g_object_unref0 (value_label);
		_g_object_unref0 (key_label);
	}
	_tmp108_ = self->priv->_view;
	_tmp109_ = files_abstract_directory_view_get_default_app (_tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = _tmp110_ != NULL;
	_g_object_unref0 (_tmp110_);
	if (_tmp111_) {
		FilesFile* _tmp112_;
		_tmp112_ = self->priv->goffile;
		_tmp107_ = !_tmp112_->is_directory;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		GtkTreeIter iter = {0};
		GAppInfo* default_app = NULL;
		FilesAbstractDirectoryView* _tmp113_;
		GAppInfo* _tmp114_;
		GtkListStore* _tmp115_;
		GList* apps = NULL;
		FilesAbstractDirectoryView* _tmp116_;
		GList* _tmp117_;
		GList* _tmp118_;
		GtkListStore* _tmp130_;
		GtkTreeIter _tmp131_ = {0};
		GtkListStore* _tmp132_;
		GtkTreeIter _tmp133_;
		GtkListStore* _tmp134_;
		GtkTreeIter _tmp135_ = {0};
		GtkListStore* _tmp136_;
		GtkTreeIter _tmp137_;
		GAppInfo* _tmp138_;
		GAppInfo* _tmp139_;
		const gchar* _tmp140_;
		GAppInfo* _tmp141_;
		GIcon* _tmp142_;
		GIcon* _tmp143_;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp144_;
		GtkCellRendererPixbuf* pix_renderer = NULL;
		GtkCellRendererPixbuf* _tmp145_;
		GtkComboBox* combo = NULL;
		GtkListStore* _tmp146_;
		GtkComboBox* _tmp147_;
		GtkComboBox* _tmp148_;
		GtkComboBox* _tmp149_;
		GtkComboBox* _tmp150_;
		GtkCellRendererPixbuf* _tmp151_;
		GtkComboBox* _tmp152_;
		GtkCellRendererText* _tmp153_;
		GtkComboBox* _tmp154_;
		GtkCellRendererText* _tmp155_;
		GtkComboBox* _tmp156_;
		GtkCellRendererPixbuf* _tmp157_;
		GtkComboBox* _tmp158_;
		GtkLabel* key_label = NULL;
		GtkLabel* _tmp159_;
		GtkGrid* _tmp160_;
		GtkLabel* _tmp161_;
		GtkGrid* _tmp162_;
		GtkComboBox* _tmp163_;
		GtkLabel* _tmp164_;
		gint _tmp165_;
		_tmp113_ = self->priv->_view;
		_tmp114_ = files_abstract_directory_view_get_default_app (_tmp113_);
		default_app = _tmp114_;
		_tmp115_ = gtk_list_store_new (3, g_app_info_get_type (), G_TYPE_STRING, g_icon_get_type (), -1);
		_g_object_unref0 (self->priv->store_apps);
		self->priv->store_apps = _tmp115_;
		_tmp116_ = self->priv->_view;
		_tmp117_ = files_abstract_directory_view_get_open_with_apps (_tmp116_);
		apps = _tmp117_;
		_tmp118_ = apps;
		{
			GList* app_collection = NULL;
			GList* app_it = NULL;
			app_collection = _tmp118_;
			for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
				GAppInfo* _tmp119_;
				GAppInfo* app = NULL;
				_tmp119_ = _g_object_ref0 ((GAppInfo*) app_it->data);
				app = _tmp119_;
				{
					GtkListStore* _tmp120_;
					GtkTreeIter _tmp121_ = {0};
					GtkListStore* _tmp122_;
					GtkTreeIter _tmp123_;
					GAppInfo* _tmp124_;
					GAppInfo* _tmp125_;
					const gchar* _tmp126_;
					GAppInfo* _tmp127_;
					GIcon* _tmp128_;
					GIcon* _tmp129_;
					_tmp120_ = self->priv->store_apps;
					gtk_list_store_append (_tmp120_, &_tmp121_);
					iter = _tmp121_;
					_tmp122_ = self->priv->store_apps;
					_tmp123_ = iter;
					_tmp124_ = app;
					_tmp125_ = app;
					_tmp126_ = g_app_info_get_name (_tmp125_);
					_tmp127_ = app;
					_tmp128_ = files_view_properties_window_ensure_icon (self, _tmp127_);
					_tmp129_ = _tmp128_;
					gtk_list_store_set (_tmp122_, &_tmp123_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO, _tmp124_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, _tmp126_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON, _tmp129_, -1);
					_g_object_unref0 (_tmp129_);
					_g_object_unref0 (app);
				}
			}
		}
		_tmp130_ = self->priv->store_apps;
		gtk_list_store_append (_tmp130_, &_tmp131_);
		iter = _tmp131_;
		_tmp132_ = self->priv->store_apps;
		_tmp133_ = iter;
		gtk_list_store_set (_tmp132_, &_tmp133_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, _ ("Other Application…"), -1);
		_tmp134_ = self->priv->store_apps;
		gtk_list_store_prepend (_tmp134_, &_tmp135_);
		iter = _tmp135_;
		_tmp136_ = self->priv->store_apps;
		_tmp137_ = iter;
		_tmp138_ = default_app;
		_tmp139_ = default_app;
		_tmp140_ = g_app_info_get_name (_tmp139_);
		_tmp141_ = default_app;
		_tmp142_ = files_view_properties_window_ensure_icon (self, _tmp141_);
		_tmp143_ = _tmp142_;
		gtk_list_store_set (_tmp136_, &_tmp137_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO, _tmp138_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, _tmp140_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON, _tmp143_, -1);
		_g_object_unref0 (_tmp143_);
		_tmp144_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp144_);
		renderer = _tmp144_;
		_tmp145_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
		g_object_ref_sink (_tmp145_);
		pix_renderer = _tmp145_;
		_tmp146_ = self->priv->store_apps;
		_tmp147_ = (GtkComboBox*) gtk_combo_box_new_with_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, gtk_tree_model_get_type (), GtkTreeModel));
		g_object_ref_sink (_tmp147_);
		combo = _tmp147_;
		_tmp148_ = combo;
		gtk_combo_box_set_active (_tmp148_, 0);
		_tmp149_ = combo;
		gtk_widget_set_valign ((GtkWidget*) _tmp149_, GTK_ALIGN_CENTER);
		_tmp150_ = combo;
		_tmp151_ = pix_renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp150_, (GtkCellRenderer*) _tmp151_, FALSE);
		_tmp152_ = combo;
		_tmp153_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp152_, (GtkCellRenderer*) _tmp153_, TRUE);
		_tmp154_ = combo;
		_tmp155_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp154_, (GtkCellRenderer*) _tmp155_, "text", (gint) FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL);
		_tmp156_ = combo;
		_tmp157_ = pix_renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp156_, (GtkCellRenderer*) _tmp157_, "gicon", (gint) FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON);
		_tmp158_ = combo;
		g_signal_connect_object (_tmp158_, "changed", (GCallback) _files_view_properties_window_combo_open_with_changed_gtk_combo_box_changed, self, 0);
		_tmp159_ = files_make_key_label (_ ("Open with:"));
		key_label = _tmp159_;
		_tmp160_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp161_ = key_label;
		gtk_grid_attach (_tmp160_, (GtkWidget*) _tmp161_, 0, n, 1, 1);
		_tmp162_ = ((FilesViewAbstractPropertiesDialog*) self)->info_grid;
		_tmp163_ = combo;
		_tmp164_ = key_label;
		gtk_grid_attach_next_to (_tmp162_, (GtkWidget*) _tmp163_, (GtkWidget*) _tmp164_, GTK_POS_RIGHT, 1, 1);
		_tmp165_ = n;
		n = _tmp165_ + 1;
		_g_object_unref0 (key_label);
		_g_object_unref0 (combo);
		_g_object_unref0 (pix_renderer);
		_g_object_unref0 (renderer);
		_g_object_unref0 (default_app);
	}
	if (files_view_properties_window_should_show_device_usage (self)) {
		{
			GFileInfo* info = NULL;
			FilesFile* _tmp166_;
			GFile* _tmp167_;
			GFileInfo* _tmp168_;
			GFileInfo* _tmp169_;
			_tmp166_ = self->priv->goffile;
			_tmp167_ = files_file_get_target_location (_tmp166_);
			_tmp168_ = g_file_query_filesystem_info (_tmp167_, "filesystem::*", NULL, &_inner_error0_);
			info = _tmp168_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp169_ = info;
			files_view_abstract_properties_dialog_create_storage_bar ((FilesViewAbstractPropertiesDialog*) self, _tmp169_, n);
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp170_;
			const gchar* _tmp171_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp170_ = e;
			_tmp171_ = _tmp170_->message;
			g_warning ("PropertiesWindow.vala:686: error: %s", _tmp171_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (mimetype_value);
			_g_object_unref0 (mimetype_key);
			_g_free0 (ftype);
			_g_object_unref0 (size_key_label);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (mimetype_value);
	_g_object_unref0 (mimetype_key);
	_g_free0 (ftype);
	_g_object_unref0 (size_key_label);
}

static gboolean
files_view_properties_window_should_show_device_usage (FilesViewPropertiesWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->files_contain_a_directory) {
		result = TRUE;
		return result;
	}
	if (self->priv->only_one) {
		FilesFile* _tmp0_;
		GFile* rootfs_loc = NULL;
		GFile* _tmp1_;
		FilesFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp0_ = self->priv->goffile;
		if (files_file_can_unmount (_tmp0_)) {
			result = TRUE;
			return result;
		}
		_tmp1_ = g_file_new_for_uri ("file:///");
		rootfs_loc = _tmp1_;
		_tmp2_ = self->priv->goffile;
		_tmp3_ = files_file_get_target_location (_tmp2_);
		_tmp4_ = rootfs_loc;
		if (g_file_equal (_tmp3_, _tmp4_)) {
			result = TRUE;
			_g_object_unref0 (rootfs_loc);
			return result;
		}
		_g_object_unref0 (rootfs_loc);
	}
	result = FALSE;
	return result;
}

static void
files_view_properties_window_update_perm_codes (FilesViewPropertiesWindow* self,
                                                PermissionsType pt,
                                                gint val,
                                                gint mult)
{
	g_return_if_fail (self != NULL);
	switch (pt) {
		case PERMISSIONS_TYPE_USER:
		{
			self->priv->owner_perm_code = self->priv->owner_perm_code + (mult * val);
			break;
		}
		case PERMISSIONS_TYPE_GROUP:
		{
			self->priv->group_perm_code = self->priv->group_perm_code + (mult * val);
			break;
		}
		case PERMISSIONS_TYPE_OTHER:
		{
			self->priv->everyone_perm_code = self->priv->everyone_perm_code + (mult * val);
			break;
		}
		default:
		break;
	}
}

static void
files_view_properties_window_permission_button_toggle (FilesViewPropertiesWindow* self,
                                                       GtkToggleButton* btn)
{
	PermissionsType pt = 0;
	gconstpointer _tmp0_;
	PermissionsValue permission_value = 0;
	gconstpointer _tmp1_;
	gint mult = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	_tmp0_ = g_object_get_data ((GObject*) btn, "permissiontype");
	pt = (PermissionsType) ((gintptr) _tmp0_);
	_tmp1_ = g_object_get_data ((GObject*) btn, "permissionvalue");
	permission_value = (PermissionsValue) ((gintptr) _tmp1_);
	mult = 1;
	files_view_properties_window_reset_and_cancel_perm_timeout (self);
	if (!gtk_toggle_button_get_active (btn)) {
		mult = -1;
	}
	switch (permission_value) {
		case PERMISSIONS_VALUE_READ:
		{
			files_view_properties_window_update_perm_codes (self, pt, 4, mult);
			break;
		}
		case PERMISSIONS_VALUE_WRITE:
		{
			files_view_properties_window_update_perm_codes (self, pt, 2, mult);
			break;
		}
		case PERMISSIONS_VALUE_EXE:
		{
			files_view_properties_window_update_perm_codes (self, pt, 1, mult);
			break;
		}
		default:
		break;
	}
	if (self->priv->perm_code_should_update) {
		GtkEntry* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->perm_code;
		_tmp3_ = g_strdup_printf ("%d%d%d", self->priv->owner_perm_code, self->priv->group_perm_code, self->priv->everyone_perm_code);
		_tmp4_ = _tmp3_;
		gtk_entry_set_text (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
	}
}

static void
_files_view_properties_window_permission_button_toggle_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                  gpointer self)
{
	files_view_properties_window_permission_button_toggle ((FilesViewPropertiesWindow*) self, _sender);
}

static PermissionButton*
files_view_properties_window_create_perm_choice (FilesViewPropertiesWindow* self,
                                                 PermissionsType pt)
{
	PermissionButton* permission_button = NULL;
	PermissionButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	PermissionButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = permission_button_new (pt);
	g_object_ref_sink (_tmp0_);
	permission_button = _tmp0_;
	_tmp1_ = permission_button_get_btn_read (permission_button);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "toggled", (GCallback) _files_view_properties_window_permission_button_toggle_gtk_toggle_button_toggled, self, 0);
	_tmp3_ = permission_button_get_btn_write (permission_button);
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "toggled", (GCallback) _files_view_properties_window_permission_button_toggle_gtk_toggle_button_toggled, self, 0);
	_tmp5_ = permission_button_get_btn_exe (permission_button);
	_tmp6_ = _tmp5_;
	g_signal_connect_object (_tmp6_, "toggled", (GCallback) _files_view_properties_window_permission_button_toggle_gtk_toggle_button_toggled, self, 0);
	result = permission_button;
	return result;
}

static guint32
files_view_properties_window_get_perm_from_chmod_unit (FilesViewPropertiesWindow* self,
                                                       guint32 vfs_perm,
                                                       gint nb,
                                                       gint chmod,
                                                       PermissionsType pt)
{
	gboolean _tmp0_ = FALSE;
	gint* chmod_types = NULL;
	gint* _tmp1_;
	gint chmod_types_length1;
	gint _chmod_types_size_;
	gint i = 0;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	if (nb > 7) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = nb < 0;
	}
	if (_tmp0_) {
		g_critical ("PropertiesWindow.vala:763: erroned chmod code %d %d", chmod, nb);
	}
	_tmp1_ = g_new0 (gint, 3);
	_tmp1_[0] = 4;
	_tmp1_[1] = 2;
	_tmp1_[2] = 1;
	chmod_types = _tmp1_;
	chmod_types_length1 = 3;
	_chmod_types_size_ = chmod_types_length1;
	i = 0;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint div = 0;
			gint* _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			gint modulo = 0;
			gint* _tmp6_;
			gint _tmp6__length1;
			gint _tmp7_;
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp2_ = FALSE;
			if (!(i < 3)) {
				break;
			}
			_tmp4_ = chmod_types;
			_tmp4__length1 = chmod_types_length1;
			_tmp5_ = _tmp4_[i];
			div = nb / _tmp5_;
			_tmp6_ = chmod_types;
			_tmp6__length1 = chmod_types_length1;
			_tmp7_ = _tmp6_[i];
			modulo = nb % _tmp7_;
			if (div >= 1) {
				mode_t* _tmp8_;
				gint _tmp8__length1;
				gint _tmp8__length2;
				mode_t _tmp9_;
				_tmp8_ = self->priv->vfs_perms;
				_tmp8__length1 = self->priv->vfs_perms_length1;
				_tmp8__length2 = self->priv->vfs_perms_length2;
				_tmp9_ = _tmp8_[(pt * _tmp8__length2) + i];
				vfs_perm = vfs_perm | _tmp9_;
			}
			nb = modulo;
		}
	}
	result = vfs_perm;
	chmod_types = (g_free (chmod_types), NULL);
	return result;
}

static guint32
files_view_properties_window_chmod_to_vfs (FilesViewPropertiesWindow* self,
                                           gint chmod)
{
	guint32 vfs_perm = 0U;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	vfs_perm = (guint32) 0;
	vfs_perm = files_view_properties_window_get_perm_from_chmod_unit (self, vfs_perm, ((gint) chmod) / 100, chmod, PERMISSIONS_TYPE_USER);
	vfs_perm = files_view_properties_window_get_perm_from_chmod_unit (self, vfs_perm, ((gint) (chmod / 10)) % 10, chmod, PERMISSIONS_TYPE_GROUP);
	vfs_perm = files_view_properties_window_get_perm_from_chmod_unit (self, vfs_perm, ((gint) chmod) % 10, chmod, PERMISSIONS_TYPE_OTHER);
	result = vfs_perm;
	return result;
}

static void
files_view_properties_window_update_perm_grid_toggle_states (FilesViewPropertiesWindow* self,
                                                             guint32 permissions)
{
	PermissionButton* _tmp0_;
	PermissionButton* _tmp1_;
	PermissionButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->perm_button_user;
	permission_button_update_buttons (_tmp0_, permissions);
	_tmp1_ = self->priv->perm_button_group;
	permission_button_update_buttons (_tmp1_, permissions);
	_tmp2_ = self->priv->perm_button_other;
	permission_button_update_buttons (_tmp2_, permissions);
}

static void
files_view_properties_window_reset_and_cancel_perm_timeout (FilesViewPropertiesWindow* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
		_tmp2_ = self->priv->cancellable;
		g_cancellable_reset (_tmp2_);
	}
	if (self->priv->timeout_perm != ((guint) 0)) {
		g_source_remove (self->priv->timeout_perm);
		self->priv->timeout_perm = (guint) 0;
	}
}

static void
files_view_properties_window_file_set_attributes_data_free (gpointer _data)
{
	FilesViewPropertiesWindowFileSetAttributesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->attr);
	_g_object_unref0 (_data_->_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewPropertiesWindowFileSetAttributesData, _data_);
}

static void
files_view_properties_window_file_set_attributes (FilesViewPropertiesWindow* self,
                                                  FilesFile* file,
                                                  const gchar* attr,
                                                  guint32 val,
                                                  GCancellable* _cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FilesViewPropertiesWindowFileSetAttributesData* _data_;
	FilesViewPropertiesWindow* _tmp0_;
	FilesFile* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (attr != NULL);
	_data_ = g_slice_new0 (FilesViewPropertiesWindowFileSetAttributesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), _cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_properties_window_file_set_attributes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = g_strdup (attr);
	_g_free0 (_data_->attr);
	_data_->attr = _tmp2_;
	_data_->val = val;
	_tmp3_ = _g_object_ref0 (_cancellable);
	_g_object_unref0 (_data_->_cancellable);
	_data_->_cancellable = _tmp3_;
	files_view_properties_window_file_set_attributes_co (_data_);
}

static void
files_view_properties_window_file_set_attributes_finish (FilesViewPropertiesWindow* self,
                                                         GAsyncResult* _res_)
{
	FilesViewPropertiesWindowFileSetAttributesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
files_view_properties_window_file_set_attributes_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	FilesViewPropertiesWindowFileSetAttributesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_properties_window_file_set_attributes_co (_data_);
}

static gboolean
files_view_properties_window_file_set_attributes_co (FilesViewPropertiesWindowFileSetAttributesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_info_new ();
	_data_->info = _data_->_tmp0_;
	{
		g_file_info_set_attribute_uint32 (_data_->info, _data_->attr, _data_->val);
		_data_->_tmp1_ = files_file_get_location (_data_->file);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_state_ = 1;
		g_file_set_attributes_async (_data_->_tmp2_, _data_->info, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_cancellable, files_view_properties_window_file_set_attributes_ready, _data_);
		return FALSE;
		_state_1:
		g_file_set_attributes_finish (_data_->_tmp2_, _data_->_res_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("PropertiesWindow.vala:827: Could not set file attribute %s: %s", _data_->attr, _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		FilesViewPropertiesWindow* self;
		self = _data9_->self;
		_g_free0 (_data9_->str);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
___lambda145_ (Block9Data* _data9_)
{
	FilesViewPropertiesWindow* self;
	guint32 perm = 0U;
	const gchar* _tmp0_;
	gint n = 0;
	GList* _tmp1_;
	gboolean result;
	self = _data9_->self;
	_tmp0_ = _data9_->str;
	perm = files_view_properties_window_chmod_to_vfs (self, atoi (_tmp0_));
	self->priv->perm_code_should_update = FALSE;
	files_view_properties_window_update_perm_grid_toggle_states (self, perm);
	self->priv->perm_code_should_update = TRUE;
	n = 0;
	_tmp1_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp2_;
			FilesFile* gof = NULL;
			_tmp2_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				FilesFile* _tmp4_;
				_tmp4_ = gof;
				if (files_file_can_set_permissions (_tmp4_)) {
					FilesFile* _tmp5_;
					_tmp5_ = gof;
					_tmp3_ = _tmp5_->permissions != perm;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					FilesFile* _tmp6_;
					FilesFile* _tmp13_;
					GCancellable* _tmp14_;
					gint _tmp15_;
					_tmp6_ = gof;
					_tmp6_->permissions = perm;
					if (n < 1) {
						GtkLabel* _tmp7_;
						FilesFile* _tmp8_;
						gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp7_ = self->priv->l_perm;
						_tmp8_ = self->priv->goffile;
						_tmp9_ = files_file_get_permissions_as_string (_tmp8_);
						_tmp10_ = _tmp9_;
						_tmp11_ = g_strdup_printf ("<tt>%s</tt>", _tmp10_);
						_tmp12_ = _tmp11_;
						gtk_label_set_label (_tmp7_, _tmp12_);
						_g_free0 (_tmp12_);
						_g_free0 (_tmp10_);
					}
					_tmp13_ = gof;
					_tmp14_ = self->priv->cancellable;
					files_view_properties_window_file_set_attributes (self, _tmp13_, G_FILE_ATTRIBUTE_UNIX_MODE, perm, _tmp14_, NULL, NULL);
					_tmp15_ = n;
					n = _tmp15_ + 1;
				} else {
					FilesFile* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp16_ = gof;
					_tmp17_ = files_file_get_uri (_tmp16_);
					_tmp18_ = _tmp17_;
					g_warning ("PropertiesWindow.vala:854: can't change permission on %s", _tmp18_);
				}
				_g_object_unref0 (gof);
			}
		}
	}
	self->priv->timeout_perm = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda145__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda145_ (self);
	return result;
}

static void
files_view_properties_window_entry_changed (FilesViewPropertiesWindow* self)
{
	Block9Data* _data9_;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = self->priv->perm_code;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_data9_->str = _tmp2_;
	_tmp3_ = _data9_->str;
	if (permissions_is_chmod_code (_tmp3_)) {
		files_view_properties_window_reset_and_cancel_perm_timeout (self);
		self->priv->timeout_perm = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 60, ____lambda145__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	}
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static gboolean
_uid_t_equal (const uid_t * s1,
              const uid_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
files_view_properties_window_combo_owner_changed (FilesViewPropertiesWindow* self,
                                                  GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	gchar* user = NULL;
	uid_t* uid = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	FilesFile* _tmp5_;
	const gchar* _tmp6_;
	uid_t* _tmp7_;
	uid_t* _tmp8_;
	uid_t* _tmp11_;
	uid_t* _tmp12_;
	FilesFile* _tmp13_;
	uid_t _tmp14_;
	GList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	uid = NULL;
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		_g_free0 (uid);
		_g_free0 (user);
		return;
	}
	_tmp2_ = self->priv->store_users;
	_tmp3_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, 0, &_tmp4_, -1);
	_g_free0 (user);
	user = _tmp4_;
	_tmp5_ = self->priv->goffile;
	if (!files_file_can_set_owner (_tmp5_)) {
		g_critical ("PropertiesWindow.vala:877: error can't set user");
		_g_free0 (uid);
		_g_free0 (user);
		return;
	}
	_tmp6_ = user;
	_tmp7_ = pf_user_utils_get_user_id_from_user_name (_tmp6_);
	_g_free0 (uid);
	uid = _tmp7_;
	_tmp8_ = uid;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		uid_t* _tmp10_;
		_tmp9_ = user;
		_tmp10_ = pf_user_utils_get_id_from_digit_string (_tmp9_);
		_g_free0 (uid);
		uid = _tmp10_;
	}
	_tmp11_ = uid;
	if (_tmp11_ == NULL) {
		g_critical ("PropertiesWindow.vala:887: user doesn t exit");
		_g_free0 (uid);
		_g_free0 (user);
		return;
	}
	_tmp12_ = uid;
	_tmp13_ = self->priv->goffile;
	_tmp14_ = (uid_t) _tmp13_->uid;
	if (_uid_t_equal (_tmp12_, &_tmp14_) == TRUE) {
		_g_free0 (uid);
		_g_free0 (user);
		return;
	}
	_tmp15_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp15_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp16_;
			FilesFile* gof = NULL;
			_tmp16_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp16_;
			{
				FilesFile* _tmp17_;
				uid_t* _tmp18_;
				_tmp17_ = gof;
				_tmp18_ = uid;
				files_view_properties_window_file_set_attributes (self, _tmp17_, G_FILE_ATTRIBUTE_UNIX_UID, (guint32) (*_tmp18_), NULL, NULL, NULL);
				_g_object_unref0 (gof);
			}
		}
	}
	_g_free0 (uid);
	_g_free0 (user);
}

static void
files_view_properties_window_combo_group_changed (FilesViewPropertiesWindow* self,
                                                  GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	gchar* group = NULL;
	uid_t* gid = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	FilesFile* _tmp5_;
	const gchar* _tmp6_;
	uid_t* _tmp7_;
	uid_t* _tmp8_;
	uid_t* _tmp11_;
	uid_t* _tmp12_;
	FilesFile* _tmp13_;
	uid_t _tmp14_;
	GList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		_g_free0 (gid);
		_g_free0 (group);
		return;
	}
	_tmp2_ = self->priv->store_groups;
	_tmp3_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, 0, &_tmp4_, -1);
	_g_free0 (group);
	group = _tmp4_;
	_tmp5_ = self->priv->goffile;
	if (!files_file_can_set_group (_tmp5_)) {
		g_critical ("PropertiesWindow.vala:912: error can't set group");
		_g_free0 (gid);
		_g_free0 (group);
		return;
	}
	_tmp6_ = group;
	_tmp7_ = pf_user_utils_get_group_id_from_group_name (_tmp6_);
	_g_free0 (gid);
	gid = _tmp7_;
	_tmp8_ = gid;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		uid_t* _tmp10_;
		_tmp9_ = group;
		_tmp10_ = pf_user_utils_get_id_from_digit_string (_tmp9_);
		_g_free0 (gid);
		gid = _tmp10_;
	}
	_tmp11_ = gid;
	if (_tmp11_ == NULL) {
		g_critical ("PropertiesWindow.vala:924: group doesn t exit");
		_g_free0 (gid);
		_g_free0 (group);
		return;
	}
	_tmp12_ = gid;
	_tmp13_ = self->priv->goffile;
	_tmp14_ = (uid_t) _tmp13_->gid;
	if (_uid_t_equal (_tmp12_, &_tmp14_) == TRUE) {
		_g_free0 (gid);
		_g_free0 (group);
		return;
	}
	_tmp15_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp15_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp16_;
			FilesFile* gof = NULL;
			_tmp16_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp16_;
			{
				FilesFile* _tmp17_;
				uid_t* _tmp18_;
				_tmp17_ = gof;
				_tmp18_ = gid;
				files_view_properties_window_file_set_attributes (self, _tmp17_, G_FILE_ATTRIBUTE_UNIX_GID, (guint32) (*_tmp18_), NULL, NULL, NULL);
				_g_object_unref0 (gof);
			}
		}
	}
	_g_free0 (gid);
	_g_free0 (group);
}

static void
_files_view_properties_window_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self)
{
	files_view_properties_window_entry_changed ((FilesViewPropertiesWindow*) self);
}

static GtkWidget*
files_view_properties_window_construct_perm_panel (FilesViewPropertiesWindow* self)
{
	GtkWidget* owner_user_choice = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkLabel* owner_user_label = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* group_combo_label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkWidget* group_combo = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	PermissionButton* _tmp8_;
	PermissionButton* _tmp9_;
	PermissionButton* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	FilesFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkListBox* permission_box = NULL;
	GtkListBox* _tmp24_ = NULL;
	GtkListBox* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkListBox* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkListBox* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkListBox* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkListBox* _tmp33_;
	PermissionButton* _tmp34_;
	GtkListBox* _tmp35_;
	PermissionButton* _tmp36_;
	GtkListBox* _tmp37_;
	PermissionButton* _tmp38_;
	GtkGrid* perm_grid = NULL;
	GtkGrid* _tmp39_ = NULL;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkWidget* _tmp43_;
	GtkGrid* _tmp44_;
	GtkLabel* _tmp45_;
	GtkGrid* _tmp46_;
	GtkWidget* _tmp47_;
	GtkGrid* _tmp48_;
	GtkListBox* _tmp49_;
	GtkGrid* _tmp50_;
	GtkLabel* _tmp51_;
	GtkGrid* _tmp52_;
	GtkEntry* _tmp53_;
	GtkGrid* _tmp54_;
	FilesFile* _tmp55_;
	FilesFile* _tmp56_;
	GtkEntry* _tmp57_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_view_properties_window_create_owner_choice (self);
	owner_user_choice = _tmp0_;
	_tmp1_ = owner_user_choice;
	if (_tmp1_ == NULL) {
		GtkLabel* _tmp2_ = NULL;
		_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Unable to determine file ownership and permissions"));
		gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
		gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp2_);
		result = (GtkWidget*) _tmp2_;
		_g_object_unref0 (owner_user_choice);
		return result;
	}
	_tmp3_ = files_make_key_label (_ ("Owner:"));
	owner_user_label = _tmp3_;
	_tmp4_ = files_make_key_label (_ ("Group:"));
	group_combo_label = _tmp4_;
	_tmp5_ = group_combo_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = files_view_properties_window_create_group_choice (self);
	group_combo = _tmp6_;
	_tmp7_ = group_combo;
	gtk_widget_set_margin_bottom (_tmp7_, 12);
	_tmp8_ = files_view_properties_window_create_perm_choice (self, PERMISSIONS_TYPE_USER);
	_g_object_unref0 (self->priv->perm_button_user);
	self->priv->perm_button_user = _tmp8_;
	_tmp9_ = files_view_properties_window_create_perm_choice (self, PERMISSIONS_TYPE_GROUP);
	_g_object_unref0 (self->priv->perm_button_group);
	self->priv->perm_button_group = _tmp9_;
	_tmp10_ = files_view_properties_window_create_perm_choice (self, PERMISSIONS_TYPE_OTHER);
	_g_object_unref0 (self->priv->perm_button_other);
	self->priv->perm_button_other = _tmp10_;
	_tmp11_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->perm_code);
	self->priv->perm_code = _tmp11_;
	_tmp12_ = self->priv->perm_code;
	gtk_entry_set_text (_tmp12_, "000");
	_tmp13_ = self->priv->perm_code;
	_tmp14_ = self->priv->perm_code;
	_tmp15_ = self->priv->perm_code;
	gtk_entry_set_width_chars (_tmp15_, 3);
	gtk_entry_set_max_width_chars (_tmp14_, 3);
	gtk_entry_set_max_length (_tmp13_, 3);
	_tmp16_ = self->priv->goffile;
	_tmp17_ = files_file_get_permissions_as_string (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("<tt>%s</tt>", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->l_perm);
	self->priv->l_perm = _tmp21_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp22_ = self->priv->l_perm;
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_START);
	_tmp23_ = self->priv->l_perm;
	gtk_label_set_use_markup (_tmp23_, TRUE);
	_tmp24_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp24_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp24_);
	permission_box = _tmp24_;
	_tmp25_ = permission_box;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "frame");
	_tmp27_ = permission_box;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "rich-list");
	_tmp29_ = permission_box;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, "boxed-list");
	_tmp31_ = permission_box;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
	gtk_style_context_add_class (_tmp32_, "separators");
	_tmp33_ = permission_box;
	_tmp34_ = self->priv->perm_button_user;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = permission_box;
	_tmp36_ = self->priv->perm_button_group;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = permission_box;
	_tmp38_ = self->priv->perm_button_other;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp39_, 6);
	gtk_grid_set_row_spacing (_tmp39_, 6);
	g_object_ref_sink (_tmp39_);
	perm_grid = _tmp39_;
	_tmp40_ = perm_grid;
	_tmp41_ = owner_user_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 0, 1, 1);
	_tmp42_ = perm_grid;
	_tmp43_ = owner_user_choice;
	gtk_grid_attach (_tmp42_, _tmp43_, 1, 0, 1, 1);
	_tmp44_ = perm_grid;
	_tmp45_ = group_combo_label;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 0, 1, 1, 1);
	_tmp46_ = perm_grid;
	_tmp47_ = group_combo;
	gtk_grid_attach (_tmp46_, _tmp47_, 1, 1, 1, 1);
	_tmp48_ = perm_grid;
	_tmp49_ = permission_box;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 0, 2, 2, 1);
	_tmp50_ = perm_grid;
	_tmp51_ = self->priv->l_perm;
	gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 0, 3, 1, 1);
	_tmp52_ = perm_grid;
	_tmp53_ = self->priv->perm_code;
	gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 1, 3, 1, 1);
	_tmp54_ = perm_grid;
	_tmp55_ = self->priv->goffile;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp54_, files_file_can_set_permissions (_tmp55_));
	_tmp56_ = self->priv->goffile;
	files_view_properties_window_update_perm_grid_toggle_states (self, _tmp56_->permissions);
	_tmp57_ = self->priv->perm_code;
	g_signal_connect_object ((GtkEditable*) _tmp57_, "changed", (GCallback) _files_view_properties_window_entry_changed_gtk_editable_changed, self, 0);
	result = (GtkWidget*) perm_grid;
	_g_object_unref0 (permission_box);
	_g_object_unref0 (group_combo);
	_g_object_unref0 (group_combo_label);
	_g_object_unref0 (owner_user_label);
	_g_object_unref0 (owner_user_choice);
	return result;
}

static gboolean
files_view_properties_window_selection_can_set_owner (FilesViewPropertiesWindow* self)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp0_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp1_;
			FilesFile* gof = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp1_;
			{
				FilesFile* _tmp2_;
				_tmp2_ = gof;
				if (!files_file_can_set_owner (_tmp2_)) {
					result = FALSE;
					_g_object_unref0 (gof);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
files_view_properties_window_get_common_owner (FilesViewPropertiesWindow* self)
{
	guint32 uid = 0U;
	GList* _tmp0_;
	GList* _tmp1_;
	FilesFile* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	uid = (guint32) -1;
	_tmp0_ = self->priv->files;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp2_;
			FilesFile* gof = NULL;
			_tmp2_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp6_ = FALSE;
				FilesFile* _tmp7_;
				if (uid == ((guint32) -1)) {
					FilesFile* _tmp4_;
					_tmp4_ = gof;
					_tmp3_ = _tmp4_ != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					FilesFile* _tmp5_;
					_tmp5_ = gof;
					uid = _tmp5_->uid;
					_g_object_unref0 (gof);
					continue;
				}
				_tmp7_ = gof;
				if (_tmp7_ != NULL) {
					FilesFile* _tmp8_;
					_tmp8_ = gof;
					_tmp6_ = uid != _tmp8_->uid;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = NULL;
					_g_object_unref0 (gof);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	_tmp9_ = self->priv->goffile;
	_tmp10_ = _tmp9_->owner;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}

static gboolean
files_view_properties_window_selection_can_set_group (FilesViewPropertiesWindow* self)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp0_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp1_;
			FilesFile* gof = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp1_;
			{
				FilesFile* _tmp2_;
				_tmp2_ = gof;
				if (!files_file_can_set_group (_tmp2_)) {
					result = FALSE;
					_g_object_unref0 (gof);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
files_view_properties_window_get_common_group (FilesViewPropertiesWindow* self)
{
	guint32 gid = 0U;
	GList* _tmp0_;
	GList* _tmp1_;
	FilesFile* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	gid = (guint32) -1;
	_tmp0_ = self->priv->files;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->files;
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* _tmp2_;
			FilesFile* gof = NULL;
			_tmp2_ = _g_object_ref0 ((FilesFile*) gof_it->data);
			gof = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp6_ = FALSE;
				FilesFile* _tmp7_;
				if (gid == ((guint32) -1)) {
					FilesFile* _tmp4_;
					_tmp4_ = gof;
					_tmp3_ = _tmp4_ != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					FilesFile* _tmp5_;
					_tmp5_ = gof;
					gid = _tmp5_->gid;
					_g_object_unref0 (gof);
					continue;
				}
				_tmp7_ = gof;
				if (_tmp7_ != NULL) {
					FilesFile* _tmp8_;
					_tmp8_ = gof;
					_tmp6_ = gid != _tmp8_->gid;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = NULL;
					_g_object_unref0 (gof);
					return result;
				}
				_g_object_unref0 (gof);
			}
		}
	}
	_tmp9_ = self->priv->goffile;
	_tmp10_ = _tmp9_->group;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
_files_view_properties_window_combo_owner_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                         gpointer self)
{
	files_view_properties_window_combo_owner_changed ((FilesViewPropertiesWindow*) self, _sender);
}

static GtkWidget*
files_view_properties_window_create_owner_choice (FilesViewPropertiesWindow* self)
{
	GtkWidget* choice = NULL;
	GtkWidget* _tmp36_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	choice = NULL;
	if (files_view_properties_window_selection_can_set_owner (self)) {
		GList* users = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp0_;
		GList* _tmp1_;
		gint owner_index = 0;
		gint i = 0;
		GList* _tmp2_;
		GtkComboBox* combo = NULL;
		GtkListStore* _tmp19_;
		GtkComboBox* _tmp20_;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp21_;
		GtkComboBox* _tmp22_;
		GtkCellRendererText* _tmp23_;
		GtkComboBox* _tmp24_;
		GtkCellRendererText* _tmp25_;
		GtkComboBox* _tmp28_;
		GtkComboBox* _tmp29_;
		GtkWidget* _tmp30_;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		_g_object_unref0 (self->priv->store_users);
		self->priv->store_users = _tmp0_;
		_tmp1_ = pf_user_utils_get_user_names ();
		(users == NULL) ? NULL : (users = (_g_list_free__g_free0_ (users), NULL));
		users = _tmp1_;
		owner_index = -1;
		i = 0;
		_tmp2_ = users;
		{
			GList* user_collection = NULL;
			GList* user_it = NULL;
			user_collection = _tmp2_;
			for (user_it = user_collection; user_it != NULL; user_it = user_it->next) {
				gchar* _tmp3_;
				gchar* user = NULL;
				_tmp3_ = g_strdup ((const gchar*) user_it->data);
				user = _tmp3_;
				{
					const gchar* _tmp4_;
					FilesFile* _tmp5_;
					const gchar* _tmp6_;
					GtkListStore* _tmp7_;
					GtkTreeIter _tmp8_ = {0};
					GtkListStore* _tmp9_;
					GtkTreeIter _tmp10_;
					const gchar* _tmp11_;
					gint _tmp12_;
					_tmp4_ = user;
					_tmp5_ = self->priv->goffile;
					_tmp6_ = _tmp5_->owner;
					if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
						owner_index = i;
					}
					_tmp7_ = self->priv->store_users;
					gtk_list_store_append (_tmp7_, &_tmp8_);
					iter = _tmp8_;
					_tmp9_ = self->priv->store_users;
					_tmp10_ = iter;
					_tmp11_ = user;
					gtk_list_store_set (_tmp9_, &_tmp10_, 0, _tmp11_, -1);
					_tmp12_ = i;
					i = _tmp12_ + 1;
					_g_free0 (user);
				}
			}
		}
		if (owner_index == -1) {
			GtkListStore* _tmp13_;
			GtkTreeIter _tmp14_ = {0};
			GtkListStore* _tmp15_;
			GtkTreeIter _tmp16_;
			FilesFile* _tmp17_;
			const gchar* _tmp18_;
			_tmp13_ = self->priv->store_users;
			gtk_list_store_prepend (_tmp13_, &_tmp14_);
			iter = _tmp14_;
			_tmp15_ = self->priv->store_users;
			_tmp16_ = iter;
			_tmp17_ = self->priv->goffile;
			_tmp18_ = _tmp17_->owner;
			gtk_list_store_set (_tmp15_, &_tmp16_, 0, _tmp18_, -1);
		}
		_tmp19_ = self->priv->store_users;
		_tmp20_ = (GtkComboBox*) gtk_combo_box_new_with_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_tree_model_get_type (), GtkTreeModel));
		g_object_ref_sink (_tmp20_);
		combo = _tmp20_;
		_tmp21_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp21_);
		renderer = _tmp21_;
		_tmp22_ = combo;
		_tmp23_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, TRUE);
		_tmp24_ = combo;
		_tmp25_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, "text", 0);
		if (owner_index == -1) {
			GtkComboBox* _tmp26_;
			_tmp26_ = combo;
			gtk_combo_box_set_active (_tmp26_, 0);
		} else {
			GtkComboBox* _tmp27_;
			_tmp27_ = combo;
			gtk_combo_box_set_active (_tmp27_, owner_index);
		}
		_tmp28_ = combo;
		g_signal_connect_object (_tmp28_, "changed", (GCallback) _files_view_properties_window_combo_owner_changed_gtk_combo_box_changed, self, 0);
		_tmp29_ = combo;
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (choice);
		choice = _tmp30_;
		_g_object_unref0 (renderer);
		_g_object_unref0 (combo);
		(users == NULL) ? NULL : (users = (_g_list_free__g_free0_ (users), NULL));
	} else {
		gchar* common_owner = NULL;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		GtkLabel* _tmp34_;
		GtkWidget* _tmp35_;
		_tmp31_ = files_view_properties_window_get_common_owner (self);
		common_owner = _tmp31_;
		_tmp32_ = common_owner;
		if (_tmp32_ == NULL) {
			result = NULL;
			_g_free0 (common_owner);
			_g_object_unref0 (choice);
			return result;
		}
		_tmp33_ = common_owner;
		_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
		g_object_ref_sink (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (choice);
		choice = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget);
		_tmp35_ = choice;
		gtk_widget_set_halign (_tmp35_, GTK_ALIGN_START);
		_g_free0 (common_owner);
	}
	_tmp36_ = choice;
	gtk_widget_set_valign (_tmp36_, GTK_ALIGN_CENTER);
	result = choice;
	return result;
}

static void
_files_view_properties_window_combo_group_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                         gpointer self)
{
	files_view_properties_window_combo_group_changed ((FilesViewPropertiesWindow*) self, _sender);
}

static GtkWidget*
files_view_properties_window_create_group_choice (FilesViewPropertiesWindow* self)
{
	GtkWidget* choice = NULL;
	GtkWidget* _tmp38_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (files_view_properties_window_selection_can_set_group (self)) {
		GList* groups = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp0_;
		FilesFile* _tmp1_;
		GList* _tmp2_;
		gint group_index = 0;
		gint i = 0;
		GList* _tmp3_;
		GtkComboBox* combo = NULL;
		GtkListStore* _tmp20_;
		GtkComboBox* _tmp21_;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp22_;
		GtkComboBox* _tmp23_;
		GtkCellRendererText* _tmp24_;
		GtkComboBox* _tmp25_;
		GtkCellRendererText* _tmp26_;
		GtkComboBox* _tmp29_;
		GtkComboBox* _tmp30_;
		GtkWidget* _tmp31_;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		_g_object_unref0 (self->priv->store_groups);
		self->priv->store_groups = _tmp0_;
		_tmp1_ = self->priv->goffile;
		_tmp2_ = files_file_get_settable_group_names (_tmp1_);
		(groups == NULL) ? NULL : (groups = (_g_list_free__g_free0_ (groups), NULL));
		groups = _tmp2_;
		group_index = -1;
		i = 0;
		_tmp3_ = groups;
		{
			GList* group_collection = NULL;
			GList* group_it = NULL;
			group_collection = _tmp3_;
			for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
				gchar* _tmp4_;
				gchar* group = NULL;
				_tmp4_ = g_strdup ((const gchar*) group_it->data);
				group = _tmp4_;
				{
					const gchar* _tmp5_;
					FilesFile* _tmp6_;
					const gchar* _tmp7_;
					GtkListStore* _tmp8_;
					GtkTreeIter _tmp9_ = {0};
					GtkListStore* _tmp10_;
					GtkTreeIter _tmp11_;
					const gchar* _tmp12_;
					gint _tmp13_;
					_tmp5_ = group;
					_tmp6_ = self->priv->goffile;
					_tmp7_ = _tmp6_->group;
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
						group_index = i;
					}
					_tmp8_ = self->priv->store_groups;
					gtk_list_store_append (_tmp8_, &_tmp9_);
					iter = _tmp9_;
					_tmp10_ = self->priv->store_groups;
					_tmp11_ = iter;
					_tmp12_ = group;
					gtk_list_store_set (_tmp10_, &_tmp11_, 0, _tmp12_, -1);
					_tmp13_ = i;
					i = _tmp13_ + 1;
					_g_free0 (group);
				}
			}
		}
		if (group_index == -1) {
			GtkListStore* _tmp14_;
			GtkTreeIter _tmp15_ = {0};
			GtkListStore* _tmp16_;
			GtkTreeIter _tmp17_;
			FilesFile* _tmp18_;
			const gchar* _tmp19_;
			_tmp14_ = self->priv->store_groups;
			gtk_list_store_prepend (_tmp14_, &_tmp15_);
			iter = _tmp15_;
			_tmp16_ = self->priv->store_groups;
			_tmp17_ = iter;
			_tmp18_ = self->priv->goffile;
			_tmp19_ = _tmp18_->owner;
			gtk_list_store_set (_tmp16_, &_tmp17_, 0, _tmp19_, -1);
		}
		_tmp20_ = self->priv->store_groups;
		_tmp21_ = (GtkComboBox*) gtk_combo_box_new_with_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_tree_model_get_type (), GtkTreeModel));
		g_object_ref_sink (_tmp21_);
		combo = _tmp21_;
		_tmp22_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp22_);
		renderer = _tmp22_;
		_tmp23_ = combo;
		_tmp24_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp23_, (GtkCellRenderer*) _tmp24_, TRUE);
		_tmp25_ = combo;
		_tmp26_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp25_, (GtkCellRenderer*) _tmp26_, "text", 0);
		if (group_index == -1) {
			GtkComboBox* _tmp27_;
			_tmp27_ = combo;
			gtk_combo_box_set_active (_tmp27_, 0);
		} else {
			GtkComboBox* _tmp28_;
			_tmp28_ = combo;
			gtk_combo_box_set_active (_tmp28_, group_index);
		}
		_tmp29_ = combo;
		g_signal_connect_object (_tmp29_, "changed", (GCallback) _files_view_properties_window_combo_group_changed_gtk_combo_box_changed, self, 0);
		_tmp30_ = combo;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (choice);
		choice = _tmp31_;
		_g_object_unref0 (renderer);
		_g_object_unref0 (combo);
		(groups == NULL) ? NULL : (groups = (_g_list_free__g_free0_ (groups), NULL));
	} else {
		gchar* common_group = NULL;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp35_;
		GtkLabel* _tmp36_;
		GtkWidget* _tmp37_;
		_tmp32_ = files_view_properties_window_get_common_group (self);
		common_group = _tmp32_;
		_tmp33_ = common_group;
		if (_tmp33_ == NULL) {
			gchar* _tmp34_;
			_tmp34_ = g_strdup ("--");
			_g_free0 (common_group);
			common_group = _tmp34_;
		}
		_tmp35_ = common_group;
		_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
		g_object_ref_sink (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (choice);
		choice = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget);
		_tmp37_ = choice;
		gtk_widget_set_halign (_tmp37_, GTK_ALIGN_START);
		_g_free0 (common_group);
	}
	_tmp38_ = choice;
	gtk_widget_set_valign (_tmp38_, GTK_ALIGN_CENTER);
	result = choice;
	return result;
}

static GIcon*
files_view_properties_window_ensure_icon (FilesViewPropertiesWindow* self,
                                          GAppInfo* app)
{
	GIcon* icon = NULL;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = g_app_info_get_icon (app);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon = _tmp1_;
	_tmp2_ = icon;
	if (_tmp2_ == NULL) {
		GThemedIcon* _tmp3_;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new ("application-x-executable");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp3_;
	}
	result = icon;
	return result;
}

static void
files_view_properties_window_combo_open_with_changed (FilesViewPropertiesWindow* self,
                                                      GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	gchar* app_label = NULL;
	GAppInfo* app = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	GAppInfo* _tmp5_ = NULL;
	GAppInfo* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		_g_object_unref0 (app);
		_g_free0 (app_label);
		return;
	}
	_tmp2_ = self->priv->store_apps;
	_tmp3_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, &_tmp4_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO, &_tmp5_, -1);
	_g_free0 (app_label);
	app_label = _tmp4_;
	_g_object_unref0 (app);
	app = _tmp5_;
	_tmp6_ = app;
	if (_tmp6_ == NULL) {
		GAppInfo* app_chosen = NULL;
		FilesFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GAppInfo* _tmp10_;
		GAppInfo* _tmp11_;
		_tmp7_ = self->priv->goffile;
		_tmp8_ = files_file_get_location (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = files_mime_actions_choose_app_for_glib_file (_tmp9_, (GtkWidget*) self);
		app_chosen = _tmp10_;
		_tmp11_ = app_chosen;
		if (_tmp11_ != NULL) {
			GtkListStore* _tmp12_;
			GtkTreeIter _tmp13_ = {0};
			GtkListStore* _tmp14_;
			GtkTreeIter _tmp15_;
			GAppInfo* _tmp16_;
			GAppInfo* _tmp17_;
			const gchar* _tmp18_;
			GAppInfo* _tmp19_;
			GIcon* _tmp20_;
			GIcon* _tmp21_;
			_tmp12_ = self->priv->store_apps;
			gtk_list_store_prepend (_tmp12_, &_tmp13_);
			iter = _tmp13_;
			_tmp14_ = self->priv->store_apps;
			_tmp15_ = iter;
			_tmp16_ = app_chosen;
			_tmp17_ = app_chosen;
			_tmp18_ = g_app_info_get_name (_tmp17_);
			_tmp19_ = app_chosen;
			_tmp20_ = files_view_properties_window_ensure_icon (self, _tmp19_);
			_tmp21_ = _tmp20_;
			gtk_list_store_set (_tmp14_, &_tmp15_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_APP_INFO, _tmp16_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_LABEL, _tmp18_, FILES_VIEW_PROPERTIES_WINDOW_APPS_COLUMN_ICON, _tmp21_, -1);
			_g_object_unref0 (_tmp21_);
			gtk_combo_box_set_active (combo, 0);
		}
		_g_object_unref0 (app_chosen);
	} else {
		{
			{
				GeeIterator* _mime_it = NULL;
				GeeSet* _tmp22_;
				GeeIterator* _tmp23_;
				_tmp22_ = self->priv->mimes;
				_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
				_mime_it = _tmp23_;
				while (TRUE) {
					GeeIterator* _tmp24_;
					gchar* mime = NULL;
					GeeIterator* _tmp25_;
					gpointer _tmp26_;
					GAppInfo* _tmp27_;
					const gchar* _tmp28_;
					_tmp24_ = _mime_it;
					if (!gee_iterator_next (_tmp24_)) {
						break;
					}
					_tmp25_ = _mime_it;
					_tmp26_ = gee_iterator_get (_tmp25_);
					mime = (gchar*) _tmp26_;
					_tmp27_ = app;
					_tmp28_ = mime;
					g_app_info_set_as_default_for_type (_tmp27_, _tmp28_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (mime);
						_g_object_unref0 (_mime_it);
						goto __catch0_g_error;
					}
					_g_free0 (mime);
				}
				_g_object_unref0 (_mime_it);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_critical ("PropertiesWindow.vala:1210: Couldn't set as default: %s", _tmp30_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (app);
			_g_free0 (app_label);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (app);
	_g_free0 (app_label);
}

guint64
files_view_properties_window_file_real_size (FilesFile* gof)
{
	guint64 file_size = 0ULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (gof != NULL, 0ULL);
	if (!gof->is_connected) {
		result = (guint64) 0;
		return result;
	}
	file_size = gof->size;
	_tmp0_ = files_file_get_location (gof);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_file_get_type ())) {
		{
			GFileInfo* info = NULL;
			GFile* _tmp2_;
			GFile* _tmp3_;
			GFileInfo* _tmp4_;
			guint64 allocated_size = 0ULL;
			GFileInfo* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			_tmp2_ = files_file_get_location (gof);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_file_query_info (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = info;
			allocated_size = g_file_info_get_attribute_uint64 (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
			if (allocated_size > ((guint64) 0)) {
				_tmp7_ = allocated_size < file_size;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = !gof->is_directory;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				file_size = allocated_size;
			}
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = err;
			_tmp9_ = _tmp8_->message;
			g_debug ("PropertiesWindow.vala:1232: %s", _tmp9_);
			gof->is_connected = FALSE;
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp10_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	result = file_size;
	return result;
}

static gchar*
files_view_properties_window_get_contains_value (FilesViewPropertiesWindow* self,
                                                 guint folders,
                                                 guint files)
{
	gchar* folders_txt = NULL;
	gchar* _tmp0_;
	gchar* files_txt = NULL;
	gchar* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	folders_txt = _tmp0_;
	_tmp1_ = g_strdup ("");
	files_txt = _tmp1_;
	if (folders > ((guint) 0)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (ngettext ("%u subfolder", "%u subfolders", (gulong) folders), folders);
		_g_free0 (folders_txt);
		folders_txt = _tmp2_;
	}
	if (files > ((guint) 0)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup_printf (ngettext ("%u file", "%u files", (gulong) files), files);
		_g_free0 (files_txt);
		files_txt = _tmp3_;
	}
	if (folders > ((guint) 0)) {
		_tmp4_ = files > ((guint) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = folders_txt;
		_tmp6_ = files_txt;
		_tmp7_ = g_strdup_printf (_ ("%s, %s"), _tmp5_, _tmp6_);
		result = _tmp7_;
		_g_free0 (files_txt);
		_g_free0 (folders_txt);
		return result;
	} else {
		if (files > ((guint) 0)) {
			result = files_txt;
			_g_free0 (folders_txt);
			return result;
		} else {
			result = folders_txt;
			_g_free0 (files_txt);
			return result;
		}
	}
}

static gchar*
files_view_properties_window_get_selected_label (FilesViewPropertiesWindow* self,
                                                 guint folders,
                                                 guint files)
{
	gchar* folders_txt = NULL;
	gchar* _tmp0_;
	gchar* files_txt = NULL;
	gchar* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	folders_txt = _tmp0_;
	_tmp1_ = g_strdup ("");
	files_txt = _tmp1_;
	if (folders > ((guint) 0)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (ngettext ("%u folder", "%u folders", (gulong) folders), folders);
		_g_free0 (folders_txt);
		folders_txt = _tmp2_;
	}
	if (files > ((guint) 0)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup_printf (ngettext ("%u file", "%u files", (gulong) files), files);
		_g_free0 (files_txt);
		files_txt = _tmp3_;
	}
	if (files > ((guint) 0)) {
		_tmp4_ = folders > ((guint) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		guint total = 0U;
		gchar* total_txt = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		total = folders + files;
		_tmp5_ = g_strdup_printf (ngettext ("%u selected item", "%u selected items", (gulong) total), total);
		total_txt = _tmp5_;
		_tmp6_ = total_txt;
		_tmp7_ = folders_txt;
		_tmp8_ = files_txt;
		_tmp9_ = g_strdup_printf (_ ("%s (%s, %s)"), _tmp6_, _tmp7_, _tmp8_);
		result = _tmp9_;
		_g_free0 (total_txt);
		_g_free0 (files_txt);
		_g_free0 (folders_txt);
		return result;
	} else {
		if (files > ((guint) 0)) {
			result = files_txt;
			_g_free0 (folders_txt);
			return result;
		} else {
			result = folders_txt;
			_g_free0 (files_txt);
			return result;
		}
	}
}

FilesAbstractDirectoryView*
files_view_properties_window_get_view (FilesViewPropertiesWindow* self)
{
	FilesAbstractDirectoryView* result;
	FilesAbstractDirectoryView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
files_view_properties_window_set_view (FilesViewPropertiesWindow* self,
                                       FilesAbstractDirectoryView* value)
{
	FilesAbstractDirectoryView* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_properties_window_get_view (self);
	if (old_value != value) {
		FilesAbstractDirectoryView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_properties_window_properties[FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY]);
	}
}

GtkEntry*
files_view_properties_window_get_entry (FilesViewPropertiesWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry;
	result = _tmp0_;
	return result;
}

static void
files_view_properties_window_set_entry (FilesViewPropertiesWindow* self,
                                        GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_properties_window_get_entry (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_entry);
		self->priv->_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_properties_window_properties[FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY]);
	}
}

static const gchar*
files_view_properties_window_get_original_name (FilesViewPropertiesWindow* self)
{
	const gchar* result;
	FilesAbstractDirectoryView* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = _tmp0_->original_name;
	result = _tmp1_;
	return result;
}

static void
files_view_properties_window_set_original_name (FilesViewPropertiesWindow* self,
                                                const gchar* value)
{
	FilesAbstractDirectoryView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = g_strdup (value);
	_g_free0 (_tmp0_->original_name);
	_tmp0_->original_name = _tmp1_;
}

static const gchar*
files_view_properties_window_get_proposed_name (FilesViewPropertiesWindow* self)
{
	const gchar* result;
	FilesAbstractDirectoryView* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = _tmp0_->proposed_name;
	result = _tmp1_;
	return result;
}

static void
files_view_properties_window_set_proposed_name (FilesViewPropertiesWindow* self,
                                                const gchar* value)
{
	FilesAbstractDirectoryView* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = g_strdup (value);
	_g_free0 (_tmp0_->proposed_name);
	_tmp0_->proposed_name = _tmp1_;
}

static guint
files_view_properties_window_get_uncounted_folders (FilesViewPropertiesWindow* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_uncounted_folders;
	return result;
}

static void
files_view_properties_window_set_uncounted_folders (FilesViewPropertiesWindow* self,
                                                    guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_uncounted_folders = value;
	g_signal_emit (self, files_view_properties_window_signals[FILES_VIEW_PROPERTIES_WINDOW_UNCOUNTED_FOLDERS_CHANGED_SIGNAL], 0);
}

static void
files_view_properties_window_class_init (FilesViewPropertiesWindowClass * klass,
                                         gpointer klass_data)
{
	files_view_properties_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewPropertiesWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_properties_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_properties_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_view_properties_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY, files_view_properties_window_properties[FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY, files_view_properties_window_properties[FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY] = g_param_spec_object ("entry", "entry", "entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_view_properties_window_signals[FILES_VIEW_PROPERTIES_WINDOW_UNCOUNTED_FOLDERS_CHANGED_SIGNAL] = g_signal_new ("uncounted-folders-changed", FILES_VIEW_TYPE_PROPERTIES_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
files_view_properties_window_instance_init (FilesViewPropertiesWindow * self,
                                            gpointer klass)
{
	mode_t* _tmp0_;
	self->priv = files_view_properties_window_get_instance_private (self);
	self->priv->perm_code_should_update = TRUE;
	self->priv->deep_count_directories = NULL;
	self->priv->size_warning = 0;
	self->priv->total_size = (guint64) 0;
	self->priv->timeout_perm = (guint) 0;
	self->priv->_uncounted_folders = (guint) 0;
	self->priv->selected_folders = (guint) 0;
	self->priv->selected_files = (guint) 0;
	self->priv->owner_perm_code = 0;
	self->priv->group_perm_code = 0;
	self->priv->everyone_perm_code = 0;
	_tmp0_ = g_new0 (mode_t, 3 * 3);
	_tmp0_[0] = S_IRUSR;
	_tmp0_[1] = S_IWUSR;
	_tmp0_[2] = S_IXUSR;
	_tmp0_[3] = S_IRGRP;
	_tmp0_[4] = S_IWGRP;
	_tmp0_[5] = S_IXGRP;
	_tmp0_[6] = S_IROTH;
	_tmp0_[7] = S_IWOTH;
	_tmp0_[8] = S_IXOTH;
	self->priv->vfs_perms = _tmp0_;
	self->priv->vfs_perms_length1 = 3;
	self->priv->vfs_perms_length2 = 3;
	self->priv->folder_count = (guint) 0;
}

static void
files_view_properties_window_finalize (GObject * obj)
{
	FilesViewPropertiesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindow);
	_g_object_unref0 (self->priv->perm_code);
	_g_object_unref0 (self->priv->l_perm);
	_g_object_unref0 (self->priv->perm_button_user);
	_g_object_unref0 (self->priv->perm_button_group);
	_g_object_unref0 (self->priv->perm_button_other);
	_g_object_unref0 (self->priv->store_users);
	_g_object_unref0 (self->priv->store_groups);
	_g_object_unref0 (self->priv->store_apps);
	(self->priv->files == NULL) ? NULL : (self->priv->files = (_g_list_free__g_object_unref0_ (self->priv->files), NULL));
	_g_object_unref0 (self->priv->goffile);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_entry);
	_vala_clear_GMutex (&self->priv->mutex);
	(self->priv->deep_count_directories == NULL) ? NULL : (self->priv->deep_count_directories = (_g_list_free__g_object_unref0_ (self->priv->deep_count_directories), NULL));
	_g_object_unref0 (self->priv->mimes);
	_g_object_unref0 (self->priv->resolution_value);
	_g_object_unref0 (self->priv->size_value);
	_g_free0 (self->priv->ftype);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->vfs_perms = (g_free (self->priv->vfs_perms), NULL);
	G_OBJECT_CLASS (files_view_properties_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_properties_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewPropertiesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_properties_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewPropertiesWindow), 0, (GInstanceInitFunc) files_view_properties_window_instance_init, NULL };
	GType files_view_properties_window_type_id;
	files_view_properties_window_type_id = g_type_register_static (FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, "FilesViewPropertiesWindow", &g_define_type_info, 0);
	FilesViewPropertiesWindow_private_offset = g_type_add_instance_private (files_view_properties_window_type_id, sizeof (FilesViewPropertiesWindowPrivate));
	return files_view_properties_window_type_id;
}

GType
files_view_properties_window_get_type (void)
{
	static volatile gsize files_view_properties_window_type_id__once = 0;
	if (g_once_init_enter (&files_view_properties_window_type_id__once)) {
		GType files_view_properties_window_type_id;
		files_view_properties_window_type_id = files_view_properties_window_get_type_once ();
		g_once_init_leave (&files_view_properties_window_type_id__once, files_view_properties_window_type_id);
	}
	return files_view_properties_window_type_id__once;
}

static void
_vala_files_view_properties_window_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FilesViewPropertiesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindow);
	switch (property_id) {
		case FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, files_view_properties_window_get_view (self));
		break;
		case FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY:
		g_value_set_object (value, files_view_properties_window_get_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_properties_window_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FilesViewPropertiesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_PROPERTIES_WINDOW, FilesViewPropertiesWindow);
	switch (property_id) {
		case FILES_VIEW_PROPERTIES_WINDOW_VIEW_PROPERTY:
		files_view_properties_window_set_view (self, g_value_get_object (value));
		break;
		case FILES_VIEW_PROPERTIES_WINDOW_ENTRY_PROPERTY:
		files_view_properties_window_set_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

