/* LibraryPage.c generated by valac 0.56.17, the Vala compiler
 * generated from LibraryPage.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_LIBRARY_PAGE (audience_library_page_get_type ())
#define AUDIENCE_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage))
#define AUDIENCE_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))
#define AUDIENCE_IS_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_IS_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_LIBRARY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))

typedef struct _AudienceLibraryPage AudienceLibraryPage;
typedef struct _AudienceLibraryPageClass AudienceLibraryPageClass;
typedef struct _AudienceLibraryPagePrivate AudienceLibraryPagePrivate;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
enum  {
	AUDIENCE_LIBRARY_PAGE_0_PROPERTY,
	AUDIENCE_LIBRARY_PAGE_NUM_PROPERTIES
};
static GParamSpec* audience_library_page_properties[AUDIENCE_LIBRARY_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM (audience_objects_media_item_get_type ())
#define AUDIENCE_OBJECTS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))

typedef struct _AudienceObjectsMediaItem AudienceObjectsMediaItem;
typedef struct _AudienceObjectsMediaItemClass AudienceObjectsMediaItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())

#define AUDIENCE_TYPE_HEADER_BAR (audience_header_bar_get_type ())
#define AUDIENCE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBar))
#define AUDIENCE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBarClass))
#define AUDIENCE_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_HEADER_BAR))
#define AUDIENCE_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_HEADER_BAR))
#define AUDIENCE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_HEADER_BAR, AudienceHeaderBarClass))

typedef struct _AudienceHeaderBar AudienceHeaderBar;
typedef struct _AudienceHeaderBarClass AudienceHeaderBarClass;
typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_LIBRARY_ITEM_TYPE_STYLE (audience_library_item_style_get_type ())

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;
enum  {
	AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL,
	AUDIENCE_LIBRARY_PAGE_NUM_SIGNALS
};
static guint audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_NUM_SIGNALS] = {0};

struct _AudienceLibraryPage {
	AdwNavigationPage parent_instance;
	AudienceLibraryPagePrivate * priv;
};

struct _AudienceLibraryPageClass {
	AdwNavigationPageClass parent_class;
};

struct _AudienceLibraryPagePrivate {
	AudienceServicesLibraryManager* manager;
	GtkSearchEntry* search_entry;
	GranitePlaceholder* alert_view;
	GtkScrolledWindow* scrolled_window;
	GtkGridView* view_movies;
	GtkStack* stack;
};

static gint AudienceLibraryPage_private_offset;
static gpointer audience_library_page_parent_class = NULL;
VALA_EXTERN AudienceLibraryPage* audience_library_page_instance;
AudienceLibraryPage* audience_library_page_instance = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_library_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryPage, g_object_unref)
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceLibraryPage* audience_library_page_get_instance (void);
VALA_EXTERN AudienceLibraryPage* audience_library_page_new (void);
VALA_EXTERN AudienceLibraryPage* audience_library_page_construct (GType object_type);
VALA_EXTERN void audience_library_page_search (AudienceLibraryPage* self);
static void audience_library_page_play_video (AudienceLibraryPage* self,
                                       guint position);
VALA_EXTERN GType audience_objects_media_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsMediaItem, g_object_unref)
VALA_EXTERN GListStore* audience_objects_media_item_get_children (AudienceObjectsMediaItem* self);
VALA_EXTERN const gchar* audience_objects_media_item_get_uri (AudienceObjectsMediaItem* self);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_playback_manager_clear_playlist (AudiencePlaybackManager* self,
                                               gboolean should_stop);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   gchar** uris,
                                                   gint uris_length1);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
static gboolean audience_library_page_video_filter_func (AudienceLibraryPage* self,
                                                  GObject* obj);
VALA_EXTERN const gchar* audience_objects_media_item_get_title (AudienceObjectsMediaItem* self);
VALA_EXTERN void audience_library_page_filter (AudienceLibraryPage* self);
VALA_EXTERN GListStore* audience_services_library_manager_get_library_items (AudienceServicesLibraryManager* self);
VALA_EXTERN AudienceWindowNavigationPage audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                                                    const gchar* file);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * audience_library_page_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
VALA_EXTERN GType audience_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceHeaderBar, g_object_unref)
VALA_EXTERN AudienceHeaderBar* audience_header_bar_new (void);
VALA_EXTERN AudienceHeaderBar* audience_header_bar_construct (GType object_type);
VALA_EXTERN GtkHeaderBar* audience_header_bar_get_header_bar (AudienceHeaderBar* self);
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static gboolean _audience_library_page_video_filter_func_gtk_custom_filter_func (GObject* item,
                                                                          gpointer self);
static void _audience_library_page___lambda31_ (AudienceLibraryPage* self,
                                         GObject* obj);
VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceLibraryItemStyle style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceLibraryItemStyle style);
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
static void __audience_library_page___lambda31__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                             GObject* object,
                                                                             gpointer self);
static void _audience_library_page___lambda37_ (AudienceLibraryPage* self,
                                         GObject* obj);
VALA_EXTERN void audience_library_item_bind (AudienceLibraryItem* self,
                                 AudienceObjectsMediaItem* item);
static void __audience_library_page___lambda37__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static void _audience_library_page_play_video_gtk_grid_view_activate (GtkGridView* _sender,
                                                               guint position,
                                                               gpointer self);
VALA_EXTERN void audience_services_library_manager_begin_scan (AudienceServicesLibraryManager* self);
static void _audience_library_page___lambda38_ (AudienceLibraryPage* self);
static void __audience_library_page___lambda38__gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self);
static void _audience_library_page___lambda39_ (AudienceLibraryPage* self);
static void __audience_library_page___lambda39__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                          gpointer self);
static gboolean _audience_library_page___lambda40_ (AudienceLibraryPage* self,
                                             guint keyval);
static gboolean __audience_library_page___lambda40__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                   guint keyval,
                                                                                   guint keycode,
                                                                                   GdkModifierType state,
                                                                                   gpointer self);
static void audience_library_page_finalize (GObject * obj);
static GType audience_library_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_library_page_get_instance_private (AudienceLibraryPage* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceLibraryPage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AudienceLibraryPage*
audience_library_page_get_instance (void)
{
	AudienceLibraryPage* _tmp0_;
	AudienceLibraryPage* _tmp2_;
	AudienceLibraryPage* _tmp3_;
	AudienceLibraryPage* result;
	_tmp0_ = audience_library_page_instance;
	if (_tmp0_ == NULL) {
		AudienceLibraryPage* _tmp1_;
		_tmp1_ = audience_library_page_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (audience_library_page_instance);
		audience_library_page_instance = _tmp1_;
	}
	_tmp2_ = audience_library_page_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
audience_library_page_search (AudienceLibraryPage* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
audience_library_page_play_video (AudienceLibraryPage* self,
                                  guint position)
{
	AudienceObjectsMediaItem* selected = NULL;
	GtkGridView* _tmp0_;
	GtkSelectionModel* _tmp1_;
	GtkSelectionModel* _tmp2_;
	GObject* _tmp3_;
	AudienceObjectsMediaItem* _tmp4_;
	GListStore* _tmp5_;
	GListStore* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_movies;
	_tmp1_ = gtk_grid_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_model_get_item ((GListModel*) _tmp2_, position);
	selected = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	_tmp4_ = selected;
	_tmp5_ = audience_objects_media_item_get_children (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_list_model_get_n_items ((GListModel*) _tmp6_) == ((guint) 0)) {
		gchar* uri = NULL;
		AudienceObjectsMediaItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean same_video = FALSE;
		const gchar* _tmp11_;
		GSettings* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		gboolean playback_complete = FALSE;
		GSettings* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gboolean from_beginning = FALSE;
		AudiencePlaybackManager* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		AudienceWindow* window = NULL;
		GApplication* _tmp24_;
		GtkWindow* _tmp25_;
		GtkWindow* _tmp26_;
		AudienceWindow* _tmp27_;
		AudienceWindow* _tmp28_;
		const gchar* _tmp29_;
		_tmp7_ = selected;
		_tmp8_ = audience_objects_media_item_get_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		uri = _tmp10_;
		_tmp11_ = uri;
		_tmp12_ = audience_settings;
		_tmp13_ = g_settings_get_string (_tmp12_, "current-video");
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strcmp0 (_tmp11_, _tmp14_) == 0;
		_g_free0 (_tmp14_);
		same_video = _tmp15_;
		_tmp16_ = audience_settings;
		playback_complete = ((gdouble) g_settings_get_int64 (_tmp16_, "last-stopped")) == 0.0;
		if (!same_video) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = playback_complete;
		}
		from_beginning = _tmp17_;
		if (from_beginning) {
			AudiencePlaybackManager* _tmp18_;
			_tmp18_ = audience_playback_manager_get_default ();
			audience_playback_manager_clear_playlist (_tmp18_, TRUE);
		}
		_tmp19_ = audience_playback_manager_get_default ();
		_tmp20_ = uri;
		_tmp21_ = g_strdup (_tmp20_);
		_tmp22_ = g_new0 (gchar*, 1 + 1);
		_tmp22_[0] = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp23__length1 = 1;
		audience_playback_manager_append_to_playlist (_tmp19_, _tmp23_, (gint) 1);
		_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
		_tmp24_ = g_application_get_default ();
		_tmp25_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_application_get_type (), GtkApplication));
		_tmp26_ = _tmp25_;
		_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, AUDIENCE_TYPE_WINDOW, AudienceWindow));
		window = _tmp27_;
		_tmp28_ = window;
		_tmp29_ = uri;
		audience_window_play_file (_tmp28_, _tmp29_, AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY, from_beginning);
		_g_object_unref0 (window);
		_g_free0 (uri);
	} else {
		AudienceObjectsMediaItem* _tmp30_;
		_tmp30_ = selected;
		g_signal_emit (self, audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL], 0, _tmp30_, FALSE);
	}
	_g_object_unref0 (selected);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_library_page_video_filter_func (AudienceLibraryPage* self,
                                         GObject* obj)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** filter_elements = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint filter_elements_length1;
	gint _filter_elements_size_;
	gchar* video_title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
	filter_elements = _tmp9_;
	filter_elements_length1 = _vala_array_length (_tmp8_);
	_filter_elements_size_ = filter_elements_length1;
	_tmp10_ = audience_objects_media_item_get_title (G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	video_title = _tmp12_;
	_tmp13_ = filter_elements;
	_tmp13__length1 = filter_elements_length1;
	{
		gchar** filter_element_collection = NULL;
		gint filter_element_collection_length1 = 0;
		gint _filter_element_collection_size_ = 0;
		gint filter_element_it = 0;
		filter_element_collection = _tmp13_;
		filter_element_collection_length1 = _tmp13__length1;
		for (filter_element_it = 0; filter_element_it < filter_element_collection_length1; filter_element_it = filter_element_it + 1) {
			gchar* _tmp14_;
			gchar* filter_element = NULL;
			_tmp14_ = g_strdup (filter_element_collection[filter_element_it]);
			filter_element = _tmp14_;
			{
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_;
				_tmp15_ = video_title;
				_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = filter_element;
				_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
				_tmp20_ = _tmp19_;
				_tmp21_ = !string_contains (_tmp17_, _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp17_);
				if (_tmp21_) {
					result = FALSE;
					_g_free0 (filter_element);
					_g_free0 (video_title);
					filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (filter_element);
			}
		}
	}
	result = TRUE;
	_g_free0 (video_title);
	filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
audience_library_page_filter (AudienceLibraryPage* self)
{
	AudienceServicesLibraryManager* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	AudienceServicesLibraryManager* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	AudienceServicesLibraryManager* _tmp6_;
	GListStore* _tmp7_;
	GListStore* _tmp8_;
	GtkGridView* _tmp9_;
	GtkSelectionModel* _tmp10_;
	GtkSelectionModel* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = audience_services_library_manager_get_library_items (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->manager;
	_tmp4_ = audience_services_library_manager_get_library_items (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->manager;
	_tmp7_ = audience_services_library_manager_get_library_items (_tmp6_);
	_tmp8_ = _tmp7_;
	g_list_model_items_changed ((GListModel*) _tmp2_, (guint) 0, g_list_model_get_n_items ((GListModel*) _tmp5_), g_list_model_get_n_items ((GListModel*) _tmp8_));
	_tmp9_ = self->priv->view_movies;
	_tmp10_ = gtk_grid_view_get_model (_tmp9_);
	_tmp11_ = _tmp10_;
	if (g_list_model_get_n_items ((GListModel*) _tmp11_) == ((guint) 0)) {
		GtkStack* _tmp12_;
		GranitePlaceholder* _tmp13_;
		GranitePlaceholder* _tmp14_;
		GtkSearchEntry* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = self->priv->stack;
		_tmp13_ = self->priv->alert_view;
		gtk_stack_set_visible_child (_tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->alert_view;
		_tmp15_ = self->priv->search_entry;
		_tmp16_ = gtk_editable_get_text ((GtkEditable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp17_);
		_tmp19_ = _tmp18_;
		granite_placeholder_set_title (_tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	} else {
		GtkStack* _tmp20_;
		GtkScrolledWindow* _tmp21_;
		_tmp20_ = self->priv->stack;
		_tmp21_ = self->priv->scrolled_window;
		gtk_stack_set_visible_child (_tmp20_, (GtkWidget*) _tmp21_);
	}
}

AudienceWindowNavigationPage
audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                       const gchar* file)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	AudienceWindowNavigationPage result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	_tmp0_ = g_file_new_for_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = !g_file_has_prefix (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	if (_tmp5_) {
		result = AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				AudienceServicesLibraryManager* _tmp8_;
				GListStore* _tmp9_;
				GListStore* _tmp10_;
				AudienceObjectsMediaItem* item = NULL;
				AudienceServicesLibraryManager* _tmp11_;
				GListStore* _tmp12_;
				GListStore* _tmp13_;
				GObject* _tmp14_;
				gboolean _tmp15_ = FALSE;
				AudienceObjectsMediaItem* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				AudienceObjectsMediaItem* _tmp22_;
				GListStore* _tmp23_;
				GListStore* _tmp24_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->manager;
				_tmp9_ = audience_services_library_manager_get_library_items (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp10_))) {
					break;
				}
				_tmp11_ = self->priv->manager;
				_tmp12_ = audience_services_library_manager_get_library_items (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_list_model_get_item ((GListModel*) _tmp13_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
				_tmp16_ = item;
				_tmp17_ = audience_objects_media_item_get_uri (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ != NULL) {
					AudienceObjectsMediaItem* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = item;
					_tmp20_ = audience_objects_media_item_get_uri (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp15_ = g_strcmp0 (_tmp21_, file) == 0;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					result = AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY;
					_g_object_unref0 (item);
					return result;
				}
				_tmp22_ = item;
				_tmp23_ = audience_objects_media_item_get_children (_tmp22_);
				_tmp24_ = _tmp23_;
				if (g_list_model_get_n_items ((GListModel*) _tmp24_) > ((guint) 0)) {
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp25_ = FALSE;
							_tmp25_ = TRUE;
							while (TRUE) {
								AudienceObjectsMediaItem* _tmp27_;
								GListStore* _tmp28_;
								GListStore* _tmp29_;
								AudienceObjectsMediaItem* episode = NULL;
								AudienceObjectsMediaItem* _tmp30_;
								GListStore* _tmp31_;
								GListStore* _tmp32_;
								GObject* _tmp33_;
								AudienceObjectsMediaItem* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								if (!_tmp25_) {
									gint _tmp26_;
									_tmp26_ = j;
									j = _tmp26_ + 1;
								}
								_tmp25_ = FALSE;
								_tmp27_ = item;
								_tmp28_ = audience_objects_media_item_get_children (_tmp27_);
								_tmp29_ = _tmp28_;
								if (!(((guint) j) < g_list_model_get_n_items ((GListModel*) _tmp29_))) {
									break;
								}
								_tmp30_ = item;
								_tmp31_ = audience_objects_media_item_get_children (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = g_list_model_get_item ((GListModel*) _tmp32_, (guint) j);
								episode = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
								_tmp34_ = episode;
								_tmp35_ = audience_objects_media_item_get_uri (_tmp34_);
								_tmp36_ = _tmp35_;
								if (g_strcmp0 (_tmp36_, file) == 0) {
									AudienceObjectsMediaItem* _tmp37_;
									_tmp37_ = item;
									g_signal_emit (self, audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL], 0, _tmp37_, TRUE);
									result = AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES;
									_g_object_unref0 (episode);
									_g_object_unref0 (item);
									return result;
								}
								_g_object_unref0 (episode);
							}
						}
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME;
	return result;
}

AudienceLibraryPage*
audience_library_page_construct (GType object_type)
{
	AudienceLibraryPage * self = NULL;
	self = (AudienceLibraryPage*) g_object_new (object_type, NULL);
	return self;
}

AudienceLibraryPage*
audience_library_page_new (void)
{
	return audience_library_page_construct (AUDIENCE_TYPE_LIBRARY_PAGE);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static gboolean
_audience_library_page_video_filter_func_gtk_custom_filter_func (GObject* item,
                                                                 gpointer self)
{
	gboolean result;
	result = audience_library_page_video_filter_func ((AudienceLibraryPage*) self, item);
	return result;
}

static void
_audience_library_page___lambda31_ (AudienceLibraryPage* self,
                                    GObject* obj)
{
	GtkListItem* item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	AudienceLibraryItem* _tmp2_;
	AudienceLibraryItem* _tmp3_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = audience_library_item_new (AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_list_item_set_child (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (item);
}

static void
__audience_library_page___lambda31__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self)
{
	_audience_library_page___lambda31_ ((AudienceLibraryPage*) self, object);
}

static void
_audience_library_page___lambda37_ (AudienceLibraryPage* self,
                                    GObject* obj)
{
	GtkListItem* item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkListItem* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = gtk_list_item_get_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = item;
	_tmp5_ = gtk_list_item_get_item (_tmp4_);
	_tmp6_ = _tmp5_;
	audience_library_item_bind (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem));
	_g_object_unref0 (item);
}

static void
__audience_library_page___lambda37__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	_audience_library_page___lambda37_ ((AudienceLibraryPage*) self, object);
}

static void
_audience_library_page_play_video_gtk_grid_view_activate (GtkGridView* _sender,
                                                          guint position,
                                                          gpointer self)
{
	audience_library_page_play_video ((AudienceLibraryPage*) self, position);
}

static void
_audience_library_page___lambda38_ (AudienceLibraryPage* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp1_ = self->priv->search_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		GtkGridView* _tmp4_;
		GtkSelectionModel* _tmp5_;
		GtkSelectionModel* _tmp6_;
		_tmp4_ = self->priv->view_movies;
		_tmp5_ = gtk_grid_view_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_list_model_get_n_items ((GListModel*) _tmp6_) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSearchEntry* _tmp7_;
		_tmp7_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp7_, "");
	}
}

static void
__audience_library_page___lambda38__gtk_widget_map (GtkWidget* _sender,
                                                    gpointer self)
{
	_audience_library_page___lambda38_ ((AudienceLibraryPage*) self);
}

static void
_audience_library_page___lambda39_ (AudienceLibraryPage* self)
{
	audience_library_page_filter (self);
}

static void
__audience_library_page___lambda39__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                     gpointer self)
{
	_audience_library_page___lambda39_ ((AudienceLibraryPage*) self);
}

static gboolean
_audience_library_page___lambda40_ (AudienceLibraryPage* self,
                                    guint keyval)
{
	gboolean result;
	if (keyval == GDK_KEY_Escape) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp0_, "");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__audience_library_page___lambda40__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self)
{
	gboolean result;
	result = _audience_library_page___lambda40_ ((AudienceLibraryPage*) self, keyval);
	return result;
}

static GObject *
audience_library_page_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceLibraryPage * self;
	gchar* _tmp0_;
	GtkSearchEntry* _tmp1_ = NULL;
	AudienceHeaderBar* header_bar = NULL;
	AudienceHeaderBar* _tmp2_;
	AudienceHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkFilterListModel* filter_model = NULL;
	AudienceServicesLibraryManager* _tmp7_;
	AudienceServicesLibraryManager* _tmp8_;
	GListStore* _tmp9_;
	GListStore* _tmp10_;
	GListModel* _tmp11_;
	GtkCustomFilter* _tmp12_;
	GtkFilterListModel* _tmp13_;
	GtkFilterListModel* _tmp14_;
	GtkNoSelection* selection_model = NULL;
	GtkFilterListModel* _tmp15_;
	GListModel* _tmp16_;
	GtkNoSelection* _tmp17_;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp18_;
	GtkNoSelection* _tmp19_;
	GtkSelectionModel* _tmp20_;
	GtkSignalListItemFactory* _tmp21_;
	GtkListItemFactory* _tmp22_;
	GtkGridView* _tmp23_ = NULL;
	GtkGridView* _tmp24_;
	GtkGridView* _tmp25_;
	GtkWidget* _tmp26_;
	GtkScrolledWindow* _tmp27_ = NULL;
	gchar* _tmp28_;
	GThemedIcon* _tmp29_;
	GranitePlaceholder* _tmp30_ = NULL;
	GtkStack* _tmp31_;
	GtkStack* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkStack* _tmp34_;
	GranitePlaceholder* _tmp35_;
	AdwToolbarView* toolbarview = NULL;
	GtkStack* _tmp36_;
	GtkWidget* _tmp37_;
	AdwToolbarView* _tmp38_ = NULL;
	AdwToolbarView* _tmp39_;
	AudienceHeaderBar* _tmp40_;
	AdwToolbarView* _tmp41_;
	GtkSignalListItemFactory* _tmp42_;
	GtkSignalListItemFactory* _tmp43_;
	GtkGridView* _tmp44_;
	AudienceServicesLibraryManager* _tmp45_;
	AudienceServicesLibraryManager* _tmp46_;
	GtkSearchEntry* _tmp47_;
	GtkEventControllerKey* search_entry_key_controller = NULL;
	GtkEventControllerKey* _tmp48_;
	GtkSearchEntry* _tmp49_;
	GtkEventControllerKey* _tmp50_;
	GtkEventController* _tmp51_;
	GtkEventControllerKey* _tmp52_;
	parent_class = G_OBJECT_CLASS (audience_library_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage);
	_tmp0_ = g_strdup (_ ("Search Videos"));
	_tmp1_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set (_tmp1_, "placeholder-text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp1_;
	_tmp2_ = audience_header_bar_new ();
	g_object_ref_sink (_tmp2_);
	header_bar = _tmp2_;
	_tmp3_ = header_bar;
	_tmp4_ = audience_header_bar_get_header_bar (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->search_entry;
	gtk_header_bar_pack_end (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = audience_services_library_manager_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = audience_services_library_manager_get_library_items (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 ((GListModel*) _tmp10_);
	_tmp12_ = gtk_custom_filter_new (_audience_library_page_video_filter_func_gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	_tmp13_ = gtk_filter_list_model_new (_tmp11_, (GtkFilter*) _tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp8_);
	filter_model = _tmp14_;
	_tmp15_ = filter_model;
	_tmp16_ = _g_object_ref0 ((GListModel*) _tmp15_);
	_tmp17_ = gtk_no_selection_new (_tmp16_);
	selection_model = _tmp17_;
	_tmp18_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp18_;
	_tmp19_ = selection_model;
	_tmp20_ = _g_object_ref0 ((GtkSelectionModel*) _tmp19_);
	_tmp21_ = factory;
	_tmp22_ = _g_object_ref0 ((GtkListItemFactory*) _tmp21_);
	_tmp23_ = (GtkGridView*) gtk_grid_view_new (_tmp20_, _tmp22_);
	gtk_grid_view_set_single_click_activate (_tmp23_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->view_movies);
	self->priv->view_movies = _tmp23_;
	_tmp24_ = self->priv->view_movies;
	gtk_widget_add_css_class ((GtkWidget*) _tmp24_, GRANITE_STYLE_CLASS_BACKGROUND);
	_tmp25_ = self->priv->view_movies;
	_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp27_, TRUE);
	gtk_scrolled_window_set_child (_tmp27_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp27_;
	_tmp28_ = g_strdup (_ ("Try changing search terms."));
	_tmp29_ = (GThemedIcon*) g_themed_icon_new ("edit-find-symbolic");
	_tmp30_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp30_, _tmp28_);
	_g_free0 (_tmp28_);
	granite_placeholder_set_icon (_tmp30_, (GIcon*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp30_;
	_tmp31_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp31_;
	_tmp32_ = self->priv->stack;
	_tmp33_ = self->priv->scrolled_window;
	gtk_stack_add_child (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->stack;
	_tmp35_ = self->priv->alert_view;
	gtk_stack_add_child (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->stack;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	toolbarview = _tmp38_;
	_tmp39_ = toolbarview;
	_tmp40_ = header_bar;
	adw_toolbar_view_add_top_bar (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = toolbarview;
	adw_navigation_page_set_child ((AdwNavigationPage*) self, (GtkWidget*) _tmp41_);
	adw_navigation_page_set_title ((AdwNavigationPage*) self, _ ("Library"));
	_tmp42_ = factory;
	g_signal_connect_object (_tmp42_, "setup", (GCallback) __audience_library_page___lambda31__gtk_signal_list_item_factory_setup, self, 0);
	_tmp43_ = factory;
	g_signal_connect_object (_tmp43_, "bind", (GCallback) __audience_library_page___lambda37__gtk_signal_list_item_factory_bind, self, 0);
	_tmp44_ = self->priv->view_movies;
	g_signal_connect_object (_tmp44_, "activate", (GCallback) _audience_library_page_play_video_gtk_grid_view_activate, self, 0);
	_tmp45_ = audience_services_library_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp45_;
	_tmp46_ = self->priv->manager;
	audience_services_library_manager_begin_scan (_tmp46_);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __audience_library_page___lambda38__gtk_widget_map, self, 0);
	_tmp47_ = self->priv->search_entry;
	g_signal_connect_object (_tmp47_, "search-changed", (GCallback) __audience_library_page___lambda39__gtk_search_entry_search_changed, self, 0);
	_tmp48_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	search_entry_key_controller = _tmp48_;
	_tmp49_ = self->priv->search_entry;
	_tmp50_ = search_entry_key_controller;
	_tmp51_ = _g_object_ref0 ((GtkEventController*) _tmp50_);
	gtk_widget_add_controller ((GtkWidget*) _tmp49_, _tmp51_);
	_tmp52_ = search_entry_key_controller;
	g_signal_connect_object (_tmp52_, "key-pressed", (GCallback) __audience_library_page___lambda40__gtk_event_controller_key_key_pressed, self, 0);
	_g_object_unref0 (search_entry_key_controller);
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (factory);
	_g_object_unref0 (selection_model);
	_g_object_unref0 (filter_model);
	_g_object_unref0 (header_bar);
	return obj;
}

static void
audience_library_page_class_init (AudienceLibraryPageClass * klass,
                                  gpointer klass_data)
{
	audience_library_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceLibraryPage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_library_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_library_page_finalize;
	audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL] = g_signal_new ("show-episodes", AUDIENCE_TYPE_LIBRARY_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, G_TYPE_BOOLEAN);
}

static void
audience_library_page_instance_init (AudienceLibraryPage * self,
                                     gpointer klass)
{
	self->priv = audience_library_page_get_instance_private (self);
}

static void
audience_library_page_finalize (GObject * obj)
{
	AudienceLibraryPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->alert_view);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->view_movies);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (audience_library_page_parent_class)->finalize (obj);
}

static GType
audience_library_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceLibraryPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_library_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceLibraryPage), 0, (GInstanceInitFunc) audience_library_page_instance_init, NULL };
	GType audience_library_page_type_id;
	audience_library_page_type_id = g_type_register_static (adw_navigation_page_get_type (), "AudienceLibraryPage", &g_define_type_info, 0);
	AudienceLibraryPage_private_offset = g_type_add_instance_private (audience_library_page_type_id, sizeof (AudienceLibraryPagePrivate));
	return audience_library_page_type_id;
}

GType
audience_library_page_get_type (void)
{
	static volatile gsize audience_library_page_type_id__once = 0;
	if (g_once_init_enter (&audience_library_page_type_id__once)) {
		GType audience_library_page_type_id;
		audience_library_page_type_id = audience_library_page_get_type_once ();
		g_once_init_leave (&audience_library_page_type_id__once, audience_library_page_type_id);
	}
	return audience_library_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

