// python wrapper for vtkSMTransferFunctionManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMTransferFunctionManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTransferFunctionManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTransferFunctionManager_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMTransferFunctionManager.UpdateScalarBarsMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTransferFunctionManager_TransferFunctionResetMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMTransferFunctionManager.TransferFunctionResetMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMTransferFunctionManager_TransferFunctionResetMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMTransferFunctionManager_TransferFunctionResetMode_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMTransferFunctionManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTransferFunctionManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTransferFunctionManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTransferFunctionManager *tempr = vtkSMTransferFunctionManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTransferFunctionManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTransferFunctionManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTransferFunctionManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTransferFunctionManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetColorTransferFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  vtkSMSessionProxyManager *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSessionProxyManager"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetColorTransferFunction(temp0, temp1) :
      op->vtkSMTransferFunctionManager::GetColorTransferFunction(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetOpacityTransferFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOpacityTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  vtkSMSessionProxyManager *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSessionProxyManager"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetOpacityTransferFunction(temp0, temp1) :
      op->vtkSMTransferFunctionManager::GetOpacityTransferFunction(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetTransferFunction2D_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransferFunction2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  vtkSMSessionProxyManager *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSessionProxyManager"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetTransferFunction2D(temp0, temp1) :
      op->vtkSMTransferFunctionManager::GetTransferFunction2D(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunctionManager_GetTransferFunction2D_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransferFunction2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  vtkSMSessionProxyManager *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMSessionProxyManager"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetTransferFunction2D(temp0, temp1, temp2) :
      op->vtkSMTransferFunctionManager::GetTransferFunction2D(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMTransferFunctionManager_GetTransferFunction2D(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMTransferFunctionManager_GetTransferFunction2D_s1(self, args);
    case 3:
      return PyvtkSMTransferFunctionManager_GetTransferFunction2D_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTransferFunction2D");
  return nullptr;
}


static PyObject *
PyvtkSMTransferFunctionManager_GetScalarBarRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScalarBarRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetScalarBarRepresentation(temp0, temp1) :
      op->vtkSMTransferFunctionManager::GetScalarBarRepresentation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_ResetAllTransferFunctionRangesUsingCurrentData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetAllTransferFunctionRangesUsingCurrentData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  vtkSMSessionProxyManager *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMSessionProxyManager") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->ResetAllTransferFunctionRangesUsingCurrentData(temp0, temp1);
    }
    else
    {
      op->vtkSMTransferFunctionManager::ResetAllTransferFunctionRangesUsingCurrentData(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_UpdateScalarBars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateScalarBars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  vtkSMProxy *temp0 = nullptr;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->UpdateScalarBars(temp0, temp1) :
      op->vtkSMTransferFunctionManager::UpdateScalarBars(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_UpdateScalarBarsComponentTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateScalarBarsComponentTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->UpdateScalarBarsComponentTitle(temp0, temp1) :
      op->vtkSMTransferFunctionManager::UpdateScalarBarsComponentTitle(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionManager_HideScalarBarIfNotNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideScalarBarIfNotNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionManager *op = static_cast<vtkSMTransferFunctionManager *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->HideScalarBarIfNotNeeded(temp0, temp1) :
      op->vtkSMTransferFunctionManager::HideScalarBarIfNotNeeded(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTransferFunctionManager_Methods[] = {
  {"IsTypeOf", PyvtkSMTransferFunctionManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTransferFunctionManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTransferFunctionManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTransferFunctionManager\nC++: static vtkSMTransferFunctionManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTransferFunctionManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTransferFunctionManager\nC++: vtkSMTransferFunctionManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTransferFunctionManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTransferFunctionManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetColorTransferFunction", PyvtkSMTransferFunctionManager_GetColorTransferFunction, METH_VARARGS,
   "GetColorTransferFunction(self, arrayName:str,\n    pxm:vtkSMSessionProxyManager) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetColorTransferFunction(\n    const char *arrayName, vtkSMSessionProxyManager *pxm)\n\nReturns a color transfer function proxy instance for mapping a\ndata array with the given name. If none exists in the given\nsession, a new instance will be created and returned.\n"},
  {"GetOpacityTransferFunction", PyvtkSMTransferFunctionManager_GetOpacityTransferFunction, METH_VARARGS,
   "GetOpacityTransferFunction(self, arrayName:str,\n    pxm:vtkSMSessionProxyManager) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetOpacityTransferFunction(\n    const char *arrayName, vtkSMSessionProxyManager *pxm)\n\nReturns a opacity transfer function proxy (aka Piecewise\nFunction) instance for mapping a data array with the given name.\nIf none exists in the given session, a new instance will be\ncreated and returned.\n"},
  {"GetTransferFunction2D", PyvtkSMTransferFunctionManager_GetTransferFunction2D, METH_VARARGS,
   "GetTransferFunction2D(self, arrayName:str,\n    pxm:vtkSMSessionProxyManager) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetTransferFunction2D(\n    const char *arrayName, vtkSMSessionProxyManager *pxm)\nGetTransferFunction2D(self, arrayName:str, array2Name:str,\n    pxm:vtkSMSessionProxyManager) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetTransferFunction2D(\n    const char *arrayName, const char *array2Name,\n    vtkSMSessionProxyManager *pxm)\n\nReturns a 2D transfer function proxy (aka Image Data) instance.\n"},
  {"GetScalarBarRepresentation", PyvtkSMTransferFunctionManager_GetScalarBarRepresentation, METH_VARARGS,
   "GetScalarBarRepresentation(self,\n    colorTransferFunctionProxy:vtkSMProxy, view:vtkSMProxy)\n    -> vtkSMProxy\nC++: virtual vtkSMProxy *GetScalarBarRepresentation(\n    vtkSMProxy *colorTransferFunctionProxy, vtkSMProxy *view)\n\nReturns the scalar-bar (color-legend) representation\ncorresponding to the transfer function for the view (currently\nonly render-views are supported). Thus returns an existing proxy,\nif present, otherwise a new one is created, if possible.\n"},
  {"ResetAllTransferFunctionRangesUsingCurrentData", PyvtkSMTransferFunctionManager_ResetAllTransferFunctionRangesUsingCurrentData, METH_VARARGS,
   "ResetAllTransferFunctionRangesUsingCurrentData(self,\n    pxm:vtkSMSessionProxyManager, animating:bool=False) -> None\nC++: void ResetAllTransferFunctionRangesUsingCurrentData(\n    vtkSMSessionProxyManager *pxm, bool animating=false)\n\nIterates over all \"known\" transfer function proxies and request\neach one of them to update its range using data information\ncurrently available. Set animating to true if this is called in\nthe context of an animation, false otherwise. It relies on the\nmode defined by the TransferFunctionResetMode enum\n"},
  {"UpdateScalarBars", PyvtkSMTransferFunctionManager_UpdateScalarBars, METH_VARARGS,
   "UpdateScalarBars(self, viewProxy:vtkSMProxy, mode:int) -> bool\nC++: virtual bool UpdateScalarBars(vtkSMProxy *viewProxy,\n    unsigned int mode)\n\nUpdates the scalar bar visibility in the view. Based on the\nspecified mode, scalars bars representing non-represented arrays\ncan be automatically hidden; and those corresponding to arrays\nused for coloring can be automatically shown.\n"},
  {"UpdateScalarBarsComponentTitle", PyvtkSMTransferFunctionManager_UpdateScalarBarsComponentTitle, METH_VARARGS,
   "UpdateScalarBarsComponentTitle(self, lutProxy:vtkSMProxy,\n    representation:vtkSMProxy) -> bool\nC++: virtual bool UpdateScalarBarsComponentTitle(\n    vtkSMProxy *lutProxy, vtkSMProxy *representation)\n\nUpdates all scalar bars using provided lutProxy, the\nrepresentation is used to recover the component title\n"},
  {"HideScalarBarIfNotNeeded", PyvtkSMTransferFunctionManager_HideScalarBarIfNotNeeded, METH_VARARGS,
   "HideScalarBarIfNotNeeded(self, lutProxy:vtkSMProxy,\n    view:vtkSMProxy) -> bool\nC++: virtual bool HideScalarBarIfNotNeeded(vtkSMProxy *lutProxy,\n    vtkSMProxy *view)\n\nHides the scalar bar, if any, for the lutProxy in the view if\nit's not being used. Returns true if the scalar bar visibility\nwas changed.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTransferFunctionManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTransferFunctionManager_Doc =
  "vtkSMTransferFunctionManager - manages transfer functions i.e.\n\n"
  "Superclass: vtkSMObject\n\n"
  "color lookuptables and opacity piecewise functions for ParaView\n"
  "applications.\n\n"
  "vtkSMTransferFunctionManager manages transfer functions i.e. color\n"
  "lookuptables and opacity piecewise functions for ParaView\n"
  "applications. vtkSMTransferFunctionManager implements the ParaView\n"
  "specific mechanism for managing such transfer function proxies where\n"
  "there's one transfer function created and maintained per data array\n"
  "name.\n\n"
  "vtkSMTransferFunctionManager has no state. You can create as many\n"
  "instances as per your choosing to call the methods. It uses the\n"
  "session proxy manager to locate proxies registered using specific\n"
  "names under specific groups. Thus, the state is maintained by the\n"
  "proxy manager itself.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTransferFunctionManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMTransferFunctionManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTransferFunctionManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTransferFunctionManager_StaticNew()
{
  return vtkSMTransferFunctionManager::New();
}

PyObject *PyvtkSMTransferFunctionManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTransferFunctionManager_Type, PyvtkSMTransferFunctionManager_Methods,
    "vtkSMTransferFunctionManager",
 &PyvtkSMTransferFunctionManager_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_Type);
  PyVTKEnum_Add(&PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_Type, "vtkSMTransferFunctionManager.UpdateScalarBarsMode");

  o = (PyObject *)&PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_Type;
  if (PyDict_SetItemString(d, "UpdateScalarBarsMode", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkSMTransferFunctionManager_TransferFunctionResetMode_Type);
  PyVTKEnum_Add(&PyvtkSMTransferFunctionManager_TransferFunctionResetMode_Type, "vtkSMTransferFunctionManager.TransferFunctionResetMode");

  o = (PyObject *)&PyvtkSMTransferFunctionManager_TransferFunctionResetMode_Type;
  if (PyDict_SetItemString(d, "TransferFunctionResetMode", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkSMTransferFunctionManager::UpdateScalarBarsMode cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "HIDE_UNUSED_SCALAR_BARS", vtkSMTransferFunctionManager::HIDE_UNUSED_SCALAR_BARS },
        { "SHOW_USED_SCALAR_BARS", vtkSMTransferFunctionManager::SHOW_USED_SCALAR_BARS },
      };

    o = PyvtkSMTransferFunctionManager_UpdateScalarBarsMode_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 7; c++)
  {
    typedef vtkSMTransferFunctionManager::TransferFunctionResetMode cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[7] = {
        { "NEVER", vtkSMTransferFunctionManager::NEVER },
        { "GROW_ON_APPLY", vtkSMTransferFunctionManager::GROW_ON_APPLY },
        { "GROW_ON_APPLY_AND_TIMESTEP", vtkSMTransferFunctionManager::GROW_ON_APPLY_AND_TIMESTEP },
        { "RESET_ON_APPLY", vtkSMTransferFunctionManager::RESET_ON_APPLY },
        { "RESET_ON_APPLY_AND_TIMESTEP", vtkSMTransferFunctionManager::RESET_ON_APPLY_AND_TIMESTEP },
        { "RESET_VISIBLE_ON_APPLY", vtkSMTransferFunctionManager::RESET_VISIBLE_ON_APPLY },
        { "RESET_VISIBLE_ON_APPLY_AND_TIMESTEP", vtkSMTransferFunctionManager::RESET_VISIBLE_ON_APPLY_AND_TIMESTEP },
      };

    o = PyvtkSMTransferFunctionManager_TransferFunctionResetMode_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTransferFunctionManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTransferFunctionManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTransferFunctionManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTransferFunctionManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

