/* TrashDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from TrashDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <plank.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS (docky_nautilus_file_operations_get_type ())
#define DOCKY_NAUTILUS_FILE_OPERATIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS, DockyNautilusFileOperations))
#define DOCKY_IS_NAUTILUS_FILE_OPERATIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS))
#define DOCKY_NAUTILUS_FILE_OPERATIONS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS, DockyNautilusFileOperationsIface))

typedef struct _DockyNautilusFileOperations DockyNautilusFileOperations;
typedef struct _DockyNautilusFileOperationsIface DockyNautilusFileOperationsIface;

#define DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS_PROXY (docky_nautilus_file_operations_proxy_get_type ())
typedef GDBusProxy DockyNautilusFileOperationsProxy;
typedef GDBusProxyClass DockyNautilusFileOperationsProxyClass;

#define DOCKY_TYPE_TRASH_DOCK_ITEM (docky_trash_dock_item_get_type ())
#define DOCKY_TRASH_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_TRASH_DOCK_ITEM, DockyTrashDockItem))
#define DOCKY_TRASH_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_TRASH_DOCK_ITEM, DockyTrashDockItemClass))
#define DOCKY_IS_TRASH_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_TRASH_DOCK_ITEM))
#define DOCKY_IS_TRASH_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_TRASH_DOCK_ITEM))
#define DOCKY_TRASH_DOCK_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_TRASH_DOCK_ITEM, DockyTrashDockItemClass))

typedef struct _DockyTrashDockItem DockyTrashDockItem;
typedef struct _DockyTrashDockItemClass DockyTrashDockItemClass;
typedef struct _DockyTrashDockItemPrivate DockyTrashDockItemPrivate;
enum  {
	DOCKY_TRASH_DOCK_ITEM_0_PROPERTY,
	DOCKY_TRASH_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* docky_trash_dock_item_properties[DOCKY_TRASH_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DockyNautilusFileOperationsIface {
	GTypeInterface parent_iface;
	void (*empty_trash) (DockyNautilusFileOperations* self, GError** error);
};

struct _DockyTrashDockItem {
	PlankDockletItem parent_instance;
	DockyTrashDockItemPrivate * priv;
};

struct _DockyTrashDockItemClass {
	PlankDockletItemClass parent_class;
};

struct _DockyTrashDockItemPrivate {
	GFileMonitor* trash_monitor;
	GFile* owned_file;
	gboolean confirm_trash_delete;
};

struct _Block1Data {
	int _ref_count_;
	DockyTrashDockItem* self;
	GFile* f;
};

struct _Block2Data {
	int _ref_count_;
	DockyTrashDockItem* self;
	GtkMessageDialog* md;
};

static gint DockyTrashDockItem_private_offset;
static gpointer docky_trash_dock_item_parent_class = NULL;

VALA_EXTERN GType docky_nautilus_file_operations_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint docky_nautilus_file_operations_register_object (void* object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error);
VALA_EXTERN GType docky_nautilus_file_operations_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyNautilusFileOperations, g_object_unref)
VALA_EXTERN void docky_nautilus_file_operations_empty_trash (DockyNautilusFileOperations* self,
                                                 GError** error);
static GType docky_nautilus_file_operations_get_type_once (void);
static void docky_nautilus_file_operations_proxy_g_signal (GDBusProxy* proxy,
                                                    const gchar* sender_name,
                                                    const gchar* signal_name,
                                                    GVariant* parameters);
static void docky_nautilus_file_operations_proxy_empty_trash (DockyNautilusFileOperations* self,
                                                       GError** error);
static void docky_nautilus_file_operations_proxy_docky_nautilus_file_operations_interface_init (DockyNautilusFileOperationsIface* iface);
static void _dbus_docky_nautilus_file_operations_empty_trash (DockyNautilusFileOperations* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void docky_nautilus_file_operations_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data);
static GVariant* docky_nautilus_file_operations_dbus_interface_get_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GError** error,
                                                                      gpointer user_data);
static gboolean docky_nautilus_file_operations_dbus_interface_set_property (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* property_name,
                                                                     GVariant* value,
                                                                     GError** error,
                                                                     gpointer user_data);
static void _docky_nautilus_file_operations_unregister_object (gpointer user_data);
VALA_EXTERN GType docky_trash_dock_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyTrashDockItem, g_object_unref)
static void docky_trash_dock_item_trash_changed (GFile* f,
                                          GFile* other,
                                          GFileMonitorEvent event,
                                          DockyTrashDockItem* self);
static void _docky_trash_dock_item_trash_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                  GFile* file,
                                                                  GFile* other_file,
                                                                  GFileMonitorEvent event_type,
                                                                  gpointer self);
static GSettings* docky_trash_dock_item_create_settings (const gchar* schema_id,
                                                  const gchar* path);
VALA_EXTERN DockyTrashDockItem* docky_trash_dock_item_new_with_dockitem_file (GFile* file);
VALA_EXTERN DockyTrashDockItem* docky_trash_dock_item_construct_with_dockitem_file (GType object_type,
                                                                        GFile* file);
static void docky_trash_dock_item_update (DockyTrashDockItem* self);
static guint32 docky_trash_dock_item_get_trash_item_count (DockyTrashDockItem* self);
static PlankAnimationType docky_trash_dock_item_real_on_clicked (PlankDockElement* base,
                                                          PlankPopupButton button,
                                                          GdkModifierType mod,
                                                          guint32 event_time);
static void docky_trash_dock_item_open_trash (DockyTrashDockItem* self);
static gchar* docky_trash_dock_item_real_get_drop_text (PlankDockElement* base);
static gboolean docky_trash_dock_item_real_can_accept_drop (PlankDockElement* base,
                                                     GeeArrayList* uris);
static gboolean docky_trash_dock_item_real_accept_drop (PlankDockElement* base,
                                                 GeeArrayList* uris);
static inline gboolean docky_trash_dock_item_receive_item (const gchar* uri);
static GeeArrayList* docky_trash_dock_item_real_get_menu_items (PlankDockElement* base);
static gint docky_trash_dock_item_compare_files (GFile* left,
                                          GFile* right);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda4_ (Block1Data* _data1_);
static void docky_trash_dock_item_restore_file (DockyTrashDockItem* self,
                                         GFile* f);
static void ______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void _docky_trash_dock_item_open_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self);
static void docky_trash_dock_item_empty_trash (DockyTrashDockItem* self);
static void _docky_trash_dock_item_empty_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self);
static void docky_trash_dock_item_empty_trash_internal (DockyTrashDockItem* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void docky_trash_dock_item_perform_empty_trash (DockyTrashDockItem* self);
static void __lambda7_ (Block2Data* _data2_,
                 gint response_id);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static void* __lambda5_ (DockyTrashDockItem* self,
                  GError** error);
static void docky_trash_dock_item_delete_children_recursive (GFile* file);
static gpointer ___lambda5__plank_task_func (gpointer self,
                                      GError** error);
static void __lambda6_ (DockyTrashDockItem* self);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN DockyTrashDockItem* docky_trash_dock_item_new (void);
VALA_EXTERN DockyTrashDockItem* docky_trash_dock_item_construct (GType object_type);
static GObject * docky_trash_dock_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void docky_trash_dock_item_finalize (GObject * obj);
static GType docky_trash_dock_item_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _docky_nautilus_file_operations_dbus_arg_info_empty_trash_in[] = {NULL};
static const GDBusArgInfo * const _docky_nautilus_file_operations_dbus_arg_info_empty_trash_out[] = {NULL};
static const GDBusMethodInfo _docky_nautilus_file_operations_dbus_method_info_empty_trash = {-1, "EmptyTrash", (GDBusArgInfo **) (&_docky_nautilus_file_operations_dbus_arg_info_empty_trash_in), (GDBusArgInfo **) (&_docky_nautilus_file_operations_dbus_arg_info_empty_trash_out), NULL};
static const GDBusMethodInfo * const _docky_nautilus_file_operations_dbus_method_info[] = {&_docky_nautilus_file_operations_dbus_method_info_empty_trash, NULL};
static const GDBusSignalInfo * const _docky_nautilus_file_operations_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _docky_nautilus_file_operations_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _docky_nautilus_file_operations_dbus_interface_info = {-1, "org.gnome.Nautilus.FileOperations", (GDBusMethodInfo **) (&_docky_nautilus_file_operations_dbus_method_info), (GDBusSignalInfo **) (&_docky_nautilus_file_operations_dbus_signal_info), (GDBusPropertyInfo **) (&_docky_nautilus_file_operations_dbus_property_info), NULL};
static const GDBusInterfaceVTable _docky_nautilus_file_operations_dbus_interface_vtable = {docky_nautilus_file_operations_dbus_interface_method_call, docky_nautilus_file_operations_dbus_interface_get_property, docky_nautilus_file_operations_dbus_interface_set_property};

void
docky_nautilus_file_operations_empty_trash (DockyNautilusFileOperations* self,
                                            GError** error)
{
	DockyNautilusFileOperationsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DOCKY_NAUTILUS_FILE_OPERATIONS_GET_INTERFACE (self);
	if (_iface_->empty_trash) {
		_iface_->empty_trash (self, error);
	}
}

static void
docky_nautilus_file_operations_default_init (DockyNautilusFileOperationsIface * iface,
                                             gpointer iface_data)
{
}

static GType
docky_nautilus_file_operations_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyNautilusFileOperationsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_nautilus_file_operations_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType docky_nautilus_file_operations_type_id;
	docky_nautilus_file_operations_type_id = g_type_register_static (G_TYPE_INTERFACE, "DockyNautilusFileOperations", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (docky_nautilus_file_operations_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (docky_nautilus_file_operations_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) docky_nautilus_file_operations_proxy_get_type);
	g_type_set_qdata (docky_nautilus_file_operations_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Nautilus.FileOperations");
	g_type_set_qdata (docky_nautilus_file_operations_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_docky_nautilus_file_operations_dbus_interface_info));
	g_type_set_qdata (docky_nautilus_file_operations_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) docky_nautilus_file_operations_register_object);
	return docky_nautilus_file_operations_type_id;
}

GType
docky_nautilus_file_operations_get_type (void)
{
	static volatile gsize docky_nautilus_file_operations_type_id__once = 0;
	if (g_once_init_enter (&docky_nautilus_file_operations_type_id__once)) {
		GType docky_nautilus_file_operations_type_id;
		docky_nautilus_file_operations_type_id = docky_nautilus_file_operations_get_type_once ();
		g_once_init_leave (&docky_nautilus_file_operations_type_id__once, docky_nautilus_file_operations_type_id);
	}
	return docky_nautilus_file_operations_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (DockyNautilusFileOperationsProxy, docky_nautilus_file_operations_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS, docky_nautilus_file_operations_proxy_docky_nautilus_file_operations_interface_init) )
static void
docky_nautilus_file_operations_proxy_class_init (DockyNautilusFileOperationsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = docky_nautilus_file_operations_proxy_g_signal;
}

static void
docky_nautilus_file_operations_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters)
{
}

static void
docky_nautilus_file_operations_proxy_init (DockyNautilusFileOperationsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_docky_nautilus_file_operations_dbus_interface_info));
}

static void
docky_nautilus_file_operations_proxy_empty_trash (DockyNautilusFileOperations* self,
                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Nautilus.FileOperations", "EmptyTrash");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
docky_nautilus_file_operations_proxy_docky_nautilus_file_operations_interface_init (DockyNautilusFileOperationsIface* iface)
{
	iface->empty_trash = docky_nautilus_file_operations_proxy_empty_trash;
}

static void
_dbus_docky_nautilus_file_operations_empty_trash (DockyNautilusFileOperations* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	docky_nautilus_file_operations_empty_trash (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
docky_nautilus_file_operations_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EmptyTrash") == 0) {
		_dbus_docky_nautilus_file_operations_empty_trash (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
docky_nautilus_file_operations_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
docky_nautilus_file_operations_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
docky_nautilus_file_operations_register_object (gpointer object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_docky_nautilus_file_operations_dbus_interface_info), &_docky_nautilus_file_operations_dbus_interface_vtable, data, _docky_nautilus_file_operations_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_docky_nautilus_file_operations_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
docky_trash_dock_item_get_instance_private (DockyTrashDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, DockyTrashDockItem_private_offset);
}

static void
_docky_trash_dock_item_trash_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                             GFile* file,
                                                             GFile* other_file,
                                                             GFileMonitorEvent event_type,
                                                             gpointer self)
{
	docky_trash_dock_item_trash_changed (file, other_file, event_type, (DockyTrashDockItem*) self);
}

static GSettings*
docky_trash_dock_item_create_settings (const gchar* schema_id,
                                       const gchar* path)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettings* _tmp4_;
	GSettings* result;
	g_return_val_if_fail (schema_id != NULL, NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, schema_id, TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		g_warning ("TrashDockItem.vala:35: GSettingsSchema '%s' not found", schema_id);
		result = NULL;
		_g_settings_schema_unref0 (schema);
		return result;
	}
	_tmp3_ = schema;
	_tmp4_ = g_settings_new_full (_tmp3_, NULL, path);
	result = _tmp4_;
	_g_settings_schema_unref0 (schema);
	return result;
}

/**
 * {@inheritDoc}
 */
DockyTrashDockItem*
docky_trash_dock_item_construct_with_dockitem_file (GType object_type,
                                                    GFile* file)
{
	DockyTrashDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (DockyTrashDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DockyTrashDockItem*
docky_trash_dock_item_new_with_dockitem_file (GFile* file)
{
	return docky_trash_dock_item_construct_with_dockitem_file (DOCKY_TYPE_TRASH_DOCK_ITEM, file);
}

static void
docky_trash_dock_item_trash_changed (GFile* f,
                                     GFile* other,
                                     GFileMonitorEvent event,
                                     DockyTrashDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	docky_trash_dock_item_update (self);
}

static void
docky_trash_dock_item_update (DockyTrashDockItem* self)
{
	guint32 item_count = 0U;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	item_count = docky_trash_dock_item_get_trash_item_count (self);
	if (item_count == ((guint32) 0U)) {
		plank_dock_element_set_Text ((PlankDockElement*) self, _ ("No items in Trash"));
	} else {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf (ngettext ("%u item in Trash", "%u items in Trash", (gulong) item_count), (guint) item_count);
		_tmp1_ = _tmp0_;
		plank_dock_element_set_Text ((PlankDockElement*) self, _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = self->priv->owned_file;
	_tmp3_ = plank_drawing_service_get_icon_from_file (_tmp2_);
	_tmp4_ = _tmp3_;
	plank_dock_item_set_Icon ((PlankDockItem*) self, _tmp4_);
	_g_free0 (_tmp4_);
}

static guint32
docky_trash_dock_item_get_trash_item_count (DockyTrashDockItem* self)
{
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	{
		GFileInfo* _tmp0_ = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = self->priv->owned_file;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = g_file_info_get_attribute_uint32 (_tmp0_, G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrashDockItem.vala:104: Could not get item count from trash::item-coun" \
"t.");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp3_ = 0U;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = (guint32) 0U;
	return result;
}

static PlankAnimationType
docky_trash_dock_item_real_on_clicked (PlankDockElement* base,
                                       PlankPopupButton button,
                                       GdkModifierType mod,
                                       guint32 event_time)
{
	DockyTrashDockItem * self;
	PlankAnimationType result;
	self = (DockyTrashDockItem*) base;
	if (button == PLANK_POPUP_BUTTON_LEFT) {
		docky_trash_dock_item_open_trash (self);
		result = PLANK_ANIMATION_TYPE_BOUNCE;
		return result;
	}
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

static gchar*
docky_trash_dock_item_real_get_drop_text (PlankDockElement* base)
{
	DockyTrashDockItem * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DockyTrashDockItem*) base;
	_tmp0_ = g_strdup (_ ("Drop to move to Trash"));
	result = _tmp0_;
	return result;
}

static gboolean
docky_trash_dock_item_real_can_accept_drop (PlankDockElement* base,
                                            GeeArrayList* uris)
{
	DockyTrashDockItem * self;
	gboolean accepted = FALSE;
	gboolean result;
	self = (DockyTrashDockItem*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	accepted = FALSE;
	{
		GeeArrayList* _uri_list = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _uri_index = 0;
		_uri_list = uris;
		_tmp0_ = _uri_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_uri_size = _tmp2_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			gchar* uri = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			_uri_index = _uri_index + 1;
			_tmp3_ = _uri_index;
			_tmp4_ = _uri_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _uri_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _uri_index);
			uri = (gchar*) _tmp6_;
			_tmp7_ = uri;
			_tmp8_ = g_file_new_for_uri (_tmp7_);
			_tmp9_ = _tmp8_;
			accepted |= g_file_query_exists (_tmp9_, NULL);
			_g_object_unref0 (_tmp9_);
			_g_free0 (uri);
		}
	}
	result = accepted;
	return result;
}

static gboolean
docky_trash_dock_item_real_accept_drop (PlankDockElement* base,
                                        GeeArrayList* uris)
{
	DockyTrashDockItem * self;
	gboolean accepted = FALSE;
	gboolean result;
	self = (DockyTrashDockItem*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	accepted = FALSE;
	{
		GeeArrayList* _uri_list = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _uri_index = 0;
		_uri_list = uris;
		_tmp0_ = _uri_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_uri_size = _tmp2_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			gchar* uri = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			_uri_index = _uri_index + 1;
			_tmp3_ = _uri_index;
			_tmp4_ = _uri_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _uri_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _uri_index);
			uri = (gchar*) _tmp6_;
			_tmp7_ = uri;
			accepted |= docky_trash_dock_item_receive_item (_tmp7_);
			_g_free0 (uri);
		}
	}
	if (accepted) {
		docky_trash_dock_item_update (self);
	}
	result = accepted;
	return result;
}

static inline gboolean
docky_trash_dock_item_receive_item (const gchar* uri)
{
	gboolean trashed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	trashed = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = g_file_new_for_uri (uri);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_trash (_tmp2_, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		trashed = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	if (!trashed) {
		g_warning ("TrashDockItem.vala:157: Could not move '%s' to trash.'", uri);
	}
	result = trashed;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DockyTrashDockItem* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->f);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_____lambda4_ (Block1Data* _data1_)
{
	DockyTrashDockItem* self;
	GFile* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->f;
	docky_trash_dock_item_restore_file (self, _tmp0_);
}

static void
______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	_____lambda4_ (self);
}

static void
_docky_trash_dock_item_open_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self)
{
	docky_trash_dock_item_open_trash ((DockyTrashDockItem*) self);
}

static void
_docky_trash_dock_item_empty_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self)
{
	docky_trash_dock_item_empty_trash ((DockyTrashDockItem*) self);
}

static GeeArrayList*
docky_trash_dock_item_real_get_menu_items (PlankDockElement* base)
{
	DockyTrashDockItem * self;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	GtkMenuItem* item = NULL;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GtkMenuItem* _tmp54_;
	GtkMenuItem* _tmp55_;
	GeeArrayList* _tmp56_;
	GtkMenuItem* _tmp57_;
	GtkMenuItem* _tmp58_;
	GtkMenuItem* _tmp59_;
	GeeArrayList* _tmp61_;
	GtkMenuItem* _tmp62_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	self = (DockyTrashDockItem*) base;
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp0_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp1_;
		GFileEnumerator* _tmp2_;
		GeeArrayList* files = NULL;
		GeeArrayList* _tmp3_;
		GFileEnumerator* _tmp4_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GeeArrayList* _tmp23_;
		gint count = 0;
		GeeArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp1_ = self->priv->owned_file;
		_tmp2_ = g_file_enumerate_children (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		files = _tmp3_;
		_tmp4_ = enumerator;
		if (_tmp4_ != NULL) {
			GFileInfo* info = NULL;
			GFileEnumerator* _tmp16_;
			while (TRUE) {
				GFileInfo* _tmp5_ = NULL;
				GFileEnumerator* _tmp6_;
				GFileInfo* _tmp7_;
				GFileInfo* _tmp8_;
				GFileInfo* _tmp9_;
				GeeArrayList* _tmp10_;
				GFile* _tmp11_;
				GFileInfo* _tmp12_;
				const gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				_tmp6_ = enumerator;
				_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
				_tmp5_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (files);
					_g_object_unref0 (enumerator);
					goto __catch0_g_error;
				}
				_tmp8_ = _tmp5_;
				_tmp5_ = NULL;
				_g_object_unref0 (info);
				info = _tmp8_;
				_tmp9_ = info;
				if (!(_tmp9_ != NULL)) {
					_g_object_unref0 (_tmp5_);
					break;
				}
				_tmp10_ = files;
				_tmp11_ = self->priv->owned_file;
				_tmp12_ = info;
				_tmp13_ = g_file_info_get_name (_tmp12_);
				_tmp14_ = g_file_get_child (_tmp11_, _tmp13_);
				_tmp15_ = _tmp14_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp15_);
				_g_object_unref0 (_tmp15_);
				_g_object_unref0 (_tmp5_);
			}
			_tmp16_ = enumerator;
			g_file_enumerator_close (_tmp16_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (files);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_g_object_unref0 (info);
		}
		_tmp17_ = files;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ > 0) {
			GeeArrayList* _tmp20_;
			PlankTitledSeparatorMenuItem* _tmp21_;
			PlankTitledSeparatorMenuItem* _tmp22_;
			_tmp20_ = items;
			_tmp21_ = plank_titled_separator_menu_item_new_no_line (_ ("Restore Files"));
			g_object_ref_sink (_tmp21_);
			_tmp22_ = _tmp21_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (GtkMenuItem*) _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		_tmp23_ = files;
		gee_list_sort ((GeeList*) _tmp23_, (GCompareDataFunc) docky_trash_dock_item_compare_files, NULL, NULL);
		count = 0;
		{
			GeeArrayList* __f_list = NULL;
			GeeArrayList* _tmp24_;
			gint __f_size = 0;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint __f_index = 0;
			_tmp24_ = files;
			__f_list = _tmp24_;
			_tmp25_ = __f_list;
			_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			__f_size = _tmp27_;
			__f_index = -1;
			while (TRUE) {
				Block1Data* _data1_;
				gint _tmp28_;
				gint _tmp29_;
				GFile* _f = NULL;
				GeeArrayList* _tmp30_;
				gpointer _tmp31_;
				GFile* _tmp32_;
				GFile* _tmp33_;
				GtkMenuItem* item = NULL;
				GFile* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				GFile* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				GtkMenuItem* _tmp40_;
				GtkMenuItem* _tmp41_;
				GtkMenuItem* _tmp42_;
				GeeArrayList* _tmp43_;
				GtkMenuItem* _tmp44_;
				gint _tmp45_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				__f_index = __f_index + 1;
				_tmp28_ = __f_index;
				_tmp29_ = __f_size;
				if (!(_tmp28_ < _tmp29_)) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_tmp30_ = __f_list;
				_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, __f_index);
				_f = (GFile*) _tmp31_;
				_tmp32_ = _f;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_data1_->f = _tmp33_;
				_tmp34_ = _data1_->f;
				_tmp35_ = g_file_get_basename (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = _data1_->f;
				_tmp38_ = plank_drawing_service_get_icon_from_file (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = plank_dock_element_create_literal_menu_item (_tmp36_, _tmp39_, FALSE);
				_tmp41_ = _tmp40_;
				_g_free0 (_tmp39_);
				_g_free0 (_tmp36_);
				item = _tmp41_;
				_tmp42_ = item;
				g_signal_connect_data (_tmp42_, "activate", (GCallback) ______lambda4__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				_tmp43_ = items;
				_tmp44_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
				count = count + 1;
				_tmp45_ = count;
				if (_tmp45_ == 5) {
					_g_object_unref0 (item);
					_g_object_unref0 (_f);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_g_object_unref0 (item);
				_g_object_unref0 (_f);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
		_tmp46_ = files;
		_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		if (_tmp48_ > 0) {
			GeeArrayList* _tmp49_;
			GtkSeparatorMenuItem* _tmp50_;
			GtkSeparatorMenuItem* _tmp51_;
			_tmp49_ = items;
			_tmp50_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp50_);
			_tmp51_ = _tmp50_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (GtkMenuItem*) _tmp51_);
			_g_object_unref0 (_tmp51_);
		}
		_g_object_unref0 (files);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrashDockItem.vala:199: Could not enumerate items in the trash.");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (items);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp52_ = plank_dock_item_get_Icon ((PlankDockItem*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = plank_dock_element_create_menu_item (_ ("_Open Trash"), _tmp53_, FALSE);
	item = _tmp54_;
	_tmp55_ = item;
	g_signal_connect_object (_tmp55_, "activate", (GCallback) _docky_trash_dock_item_open_trash_gtk_menu_item_activate, self, 0);
	_tmp56_ = items;
	_tmp57_ = item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
	_tmp58_ = plank_dock_element_create_menu_item (_ ("Empty _Trash"), "gtk-clear", FALSE);
	_g_object_unref0 (item);
	item = _tmp58_;
	_tmp59_ = item;
	g_signal_connect_object (_tmp59_, "activate", (GCallback) _docky_trash_dock_item_empty_trash_gtk_menu_item_activate, self, 0);
	if (docky_trash_dock_item_get_trash_item_count (self) == ((guint32) 0U)) {
		GtkMenuItem* _tmp60_;
		_tmp60_ = item;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp60_, FALSE);
	}
	_tmp61_ = items;
	_tmp62_ = item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
	result = items;
	_g_object_unref0 (item);
	return result;
}

static gint
docky_trash_dock_item_compare_files (GFile* left,
                                     GFile* right)
{
	gint _tmp9_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (left != NULL, 0);
	g_return_val_if_fail (right != NULL, 0);
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		const gchar* left_info = NULL;
		const gchar* _tmp2_;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		const gchar* right_info = NULL;
		const gchar* _tmp5_;
		GCompareFunc _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = g_file_query_info (left, G_FILE_ATTRIBUTE_TRASH_DELETION_DATE, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_attribute_string (_tmp0_, G_FILE_ATTRIBUTE_TRASH_DELETION_DATE);
		left_info = _tmp2_;
		_tmp4_ = g_file_query_info (right, G_FILE_ATTRIBUTE_TRASH_DELETION_DATE, 0, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = g_file_info_get_attribute_string (_tmp3_, G_FILE_ATTRIBUTE_TRASH_DELETION_DATE);
		right_info = _tmp5_;
		_tmp6_ = ((GCompareFunc) g_strcmp0);
		_tmp7_ = right_info;
		_tmp8_ = left_info;
		result = _tmp6_ (_tmp7_, _tmp8_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrashDockItem.vala:222: Could not enumerate items in the trash.");
		result = 0;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static void
docky_trash_dock_item_restore_file (DockyTrashDockItem* self,
                                    GFile* f)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		const gchar* orig_path = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_file_query_info (f, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH, 0, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_attribute_string (_tmp0_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
		orig_path = _tmp2_;
		_tmp3_ = orig_path;
		if (_tmp3_ != NULL) {
			GFile* destFile = NULL;
			const gchar* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			_tmp4_ = orig_path;
			_tmp5_ = g_file_new_for_path (_tmp4_);
			destFile = _tmp5_;
			_tmp6_ = destFile;
			g_file_move (f, _tmp6_, (G_FILE_COPY_NOFOLLOW_SYMLINKS | G_FILE_COPY_ALL_METADATA) | G_FILE_COPY_NO_FALLBACK_FOR_MOVE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (destFile);
				_g_object_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (destFile);
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrashDockItem.vala:236: Could not restore file from the trash.");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
docky_trash_dock_item_open_trash (DockyTrashDockItem* self)
{
	PlankSystem* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = self->priv->owned_file;
	plank_system_open (_tmp0_, _tmp1_);
}

static void
docky_trash_dock_item_empty_trash (DockyTrashDockItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (plank_environment_is_session_desktop ((PLANK_XDG_SESSION_DESKTOP_GNOME | PLANK_XDG_SESSION_DESKTOP_UNITY) | PLANK_XDG_SESSION_DESKTOP_UBUNTU)) {
		{
			DockyNautilusFileOperations* nautilus_file_operations = NULL;
			DockyNautilusFileOperations* _tmp0_;
			DockyNautilusFileOperations* _tmp1_;
			_tmp0_ = (DockyNautilusFileOperations*) g_initable_new (DOCKY_TYPE_NAUTILUS_FILE_OPERATIONS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.Nautilus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Nautilus", "g-interface-name", "org.gnome.Nautilus.FileOperations", NULL);
			nautilus_file_operations = (DockyNautilusFileOperations*) _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = nautilus_file_operations;
			docky_nautilus_file_operations_empty_trash (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (nautilus_file_operations);
				goto __catch0_g_error;
			}
			_g_object_unref0 (nautilus_file_operations);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			docky_trash_dock_item_empty_trash_internal (self);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		docky_trash_dock_item_empty_trash_internal (self);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DockyTrashDockItem* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->md);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda7_ (Block2Data* _data2_,
            gint response_id)
{
	DockyTrashDockItem* self;
	GtkMessageDialog* _tmp0_;
	self = _data2_->self;
	if (response_id != ((gint) GTK_RESPONSE_CANCEL)) {
		docky_trash_dock_item_perform_empty_trash (self);
	}
	_tmp0_ = _data2_->md;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda7_ (self, response_id);
}

static void
docky_trash_dock_item_empty_trash_internal (DockyTrashDockItem* self)
{
	Block2Data* _data2_;
	GtkMessageDialog* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GApplication* _tmp8_;
	GtkWindow* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (!self->priv->confirm_trash_delete) {
		docky_trash_dock_item_perform_empty_trash (self);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _ ("Empty all items from Trash?"));
	g_object_ref_sink (_tmp0_);
	_data2_->md = _tmp0_;
	_tmp1_ = _data2_->md;
	g_object_set (_tmp1_, "secondary-text", _ ("All items in the Trash will be permanently deleted."), NULL);
	_tmp2_ = _data2_->md;
	gtk_dialog_add_button ((GtkDialog*) _tmp2_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp3_ = _data2_->md;
	gtk_dialog_add_button ((GtkDialog*) _tmp3_, _ ("Empty _Trash"), (gint) GTK_RESPONSE_OK);
	_tmp4_ = _data2_->md;
	gtk_dialog_set_default_response ((GtkDialog*) _tmp4_, (gint) GTK_RESPONSE_OK);
	_tmp5_ = _data2_->md;
	g_object_set ((GtkWindow*) _tmp5_, "window-position", GTK_WIN_POS_CENTER, NULL);
	_tmp6_ = _data2_->md;
	gtk_window_set_gravity ((GtkWindow*) _tmp6_, GDK_GRAVITY_CENTER);
	_tmp7_ = _data2_->md;
	_tmp8_ = g_application_get_default ();
	_tmp9_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication));
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp9_);
	_tmp10_ = _data2_->md;
	g_signal_connect_data ((GtkDialog*) _tmp10_, "response", (GCallback) ___lambda7__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp11_ = _data2_->md;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void*
__lambda5_ (DockyTrashDockItem* self,
            GError** error)
{
	GFile* _tmp0_;
	void* result;
	_tmp0_ = self->priv->owned_file;
	docky_trash_dock_item_delete_children_recursive (_tmp0_);
	result = NULL;
	return result;
}

static gpointer
___lambda5__plank_task_func (gpointer self,
                             GError** error)
{
	gpointer result;
	result = __lambda5_ ((DockyTrashDockItem*) self, error);
	return result;
}

static void
__lambda6_ (DockyTrashDockItem* self)
{
	GFileMonitor* _tmp0_;
	_tmp0_ = self->priv->trash_monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		_tmp1_ = self->priv->trash_monitor;
		g_signal_connect_object (_tmp1_, "changed", (GCallback) _docky_trash_dock_item_trash_changed_g_file_monitor_changed, self, 0);
	}
	docky_trash_dock_item_update (self);
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((DockyTrashDockItem*) self);
	g_object_unref (self);
}

static void
docky_trash_dock_item_perform_empty_trash (DockyTrashDockItem* self)
{
	GFileMonitor* _tmp0_;
	PlankWorker* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->trash_monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->trash_monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _docky_trash_dock_item_trash_changed_g_file_monitor_changed, self);
	}
	_tmp3_ = plank_worker_get_default ();
	plank_worker_add_task_with_result (_tmp3_, G_TYPE_POINTER, NULL, NULL, ___lambda5__plank_task_func, g_object_ref (self), g_object_unref, PLANK_TASK_PRIORITY_HIGH, ___lambda6__gasync_ready_callback, g_object_ref (self));
}

static void
docky_trash_dock_item_delete_children_recursive (GFile* file)
{
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	enumerator = NULL;
	{
		GFileEnumerator* _tmp0_ = NULL;
		GFileEnumerator* _tmp1_;
		GFileEnumerator* _tmp2_;
		_tmp1_ = g_file_enumerate_children (file, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("TrashDockItem.vala:312: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = enumerator;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (enumerator);
		return;
	}
	{
		GFileInfo* info = NULL;
		GFileEnumerator* _tmp18_;
		while (TRUE) {
			GFileInfo* _tmp6_ = NULL;
			GFileEnumerator* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFile* child = NULL;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFileInfo* _tmp14_;
			_tmp7_ = enumerator;
			_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				goto __catch1_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (info);
			info = _tmp9_;
			_tmp10_ = info;
			if (!(_tmp10_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				break;
			}
			_tmp11_ = info;
			_tmp12_ = g_file_info_get_name (_tmp11_);
			_tmp13_ = g_file_get_child (file, _tmp12_);
			child = _tmp13_;
			_tmp14_ = info;
			if (g_file_info_get_file_type (_tmp14_) == G_FILE_TYPE_DIRECTORY) {
				GFile* _tmp15_;
				_tmp15_ = child;
				docky_trash_dock_item_delete_children_recursive (_tmp15_);
			}
			{
				GFileInfo* _tmp16_;
				_tmp16_ = info;
				if (g_file_info_get_attribute_boolean (_tmp16_, G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE)) {
					GFile* _tmp17_;
					_tmp17_ = child;
					g_file_delete (_tmp17_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (child);
				_g_object_unref0 (_tmp6_);
				_g_object_unref0 (info);
				goto __catch1_g_error;
			}
			_g_object_unref0 (child);
			_g_object_unref0 (_tmp6_);
		}
		_tmp18_ = enumerator;
		g_file_enumerator_close (_tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			goto __catch1_g_error;
		}
		_g_object_unref0 (info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TrashDockItem.vala:333: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (enumerator);
}

DockyTrashDockItem*
docky_trash_dock_item_construct (GType object_type)
{
	DockyTrashDockItem * self = NULL;
	self = (DockyTrashDockItem*) plank_docklet_item_construct (object_type);
	return self;
}

DockyTrashDockItem*
docky_trash_dock_item_new (void)
{
	return docky_trash_dock_item_construct (DOCKY_TYPE_TRASH_DOCK_ITEM);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static GObject *
docky_trash_dock_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DockyTrashDockItem * self;
	GFile* _tmp0_;
	GSettings* nautilus_settings = NULL;
	GSettings* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GSettings* _tmp8_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (docky_trash_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_TRASH_DOCK_ITEM, DockyTrashDockItem);
	_tmp0_ = g_file_new_for_uri ("trash://");
	_g_object_unref0 (self->priv->owned_file);
	self->priv->owned_file = _tmp0_;
	docky_trash_dock_item_update (self);
	{
		GFileMonitor* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp2_ = self->priv->owned_file;
		_tmp3_ = g_file_monitor (_tmp2_, 0, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->trash_monitor);
		self->priv->trash_monitor = _tmp4_;
		_tmp5_ = self->priv->trash_monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _docky_trash_dock_item_trash_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrashDockItem.vala:63: Could not start file monitor for trash.");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp6_ = docky_trash_dock_item_create_settings ("org.gnome.nautilus.preferences", "/org/gnome/nautilus/preferences/");
	nautilus_settings = _tmp6_;
	_tmp8_ = nautilus_settings;
	if (_tmp8_ != NULL) {
		GSettings* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp9_ = nautilus_settings;
		_tmp11_ = _tmp10_ = g_settings_list_keys (_tmp9_);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _vala_array_length (_tmp10_);
		_tmp7_ = _vala_string_array_contains (_tmp12_, _vala_array_length (_tmp10_), "confirm-trash");
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GSettings* _tmp13_;
		_tmp13_ = nautilus_settings;
		self->priv->confirm_trash_delete = g_settings_get_boolean (_tmp13_, "confirm-trash");
	}
	_g_object_unref0 (nautilus_settings);
	return obj;
}

static void
docky_trash_dock_item_class_init (DockyTrashDockItemClass * klass,
                                  gpointer klass_data)
{
	docky_trash_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DockyTrashDockItem_private_offset);
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) docky_trash_dock_item_real_on_clicked;
	((PlankDockElementClass *) klass)->get_drop_text = (gchar* (*) (PlankDockElement*)) docky_trash_dock_item_real_get_drop_text;
	((PlankDockElementClass *) klass)->can_accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) docky_trash_dock_item_real_can_accept_drop;
	((PlankDockElementClass *) klass)->accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) docky_trash_dock_item_real_accept_drop;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) docky_trash_dock_item_real_get_menu_items;
	G_OBJECT_CLASS (klass)->constructor = docky_trash_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = docky_trash_dock_item_finalize;
}

static void
docky_trash_dock_item_instance_init (DockyTrashDockItem * self,
                                     gpointer klass)
{
	self->priv = docky_trash_dock_item_get_instance_private (self);
	self->priv->confirm_trash_delete = TRUE;
}

static void
docky_trash_dock_item_finalize (GObject * obj)
{
	DockyTrashDockItem * self;
	GFileMonitor* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_TRASH_DOCK_ITEM, DockyTrashDockItem);
	_tmp0_ = self->priv->trash_monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		guint _tmp2_;
		GFileMonitor* _tmp3_;
		_tmp1_ = self->priv->trash_monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _docky_trash_dock_item_trash_changed_g_file_monitor_changed, self);
		_tmp3_ = self->priv->trash_monitor;
		g_file_monitor_cancel (_tmp3_);
		_g_object_unref0 (self->priv->trash_monitor);
		self->priv->trash_monitor = NULL;
	}
	_g_object_unref0 (self->priv->trash_monitor);
	_g_object_unref0 (self->priv->owned_file);
	G_OBJECT_CLASS (docky_trash_dock_item_parent_class)->finalize (obj);
}

static GType
docky_trash_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyTrashDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_trash_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockyTrashDockItem), 0, (GInstanceInitFunc) docky_trash_dock_item_instance_init, NULL };
	GType docky_trash_dock_item_type_id;
	docky_trash_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCKLET_ITEM, "DockyTrashDockItem", &g_define_type_info, 0);
	DockyTrashDockItem_private_offset = g_type_add_instance_private (docky_trash_dock_item_type_id, sizeof (DockyTrashDockItemPrivate));
	return docky_trash_dock_item_type_id;
}

GType
docky_trash_dock_item_get_type (void)
{
	static volatile gsize docky_trash_dock_item_type_id__once = 0;
	if (g_once_init_enter (&docky_trash_dock_item_type_id__once)) {
		GType docky_trash_dock_item_type_id;
		docky_trash_dock_item_type_id = docky_trash_dock_item_get_type_once ();
		g_once_init_leave (&docky_trash_dock_item_type_id__once, docky_trash_dock_item_type_id);
	}
	return docky_trash_dock_item_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

