/* ItemFactory.c generated by valac 0.56.17, the Vala compiler
 * generated from ItemFactory.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "plank-internal.h"
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_ITEM_FACTORY_0_PROPERTY,
	PLANK_ITEM_FACTORY_NUM_PROPERTIES
};
static GParamSpec* plank_item_factory_properties[PLANK_ITEM_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer plank_item_factory_parent_class = NULL;

static PlankDockElement* plank_item_factory_real_make_element (PlankItemFactory* self,
                                                        GFile* file);
static PlankDockItem* plank_item_factory_real_get_item_for_dock (PlankItemFactory* self);
static PlankDockItem* plank_item_factory_find_item_for_uri (PlankItemFactory* self,
                                                     GeeArrayList* elements,
                                                     const gchar* uri);
static void plank_item_factory_make_dock_item_for_desktop_id (PlankItemFactory* self,
                                                       const gchar* id);
static gboolean plank_item_factory_make_default_gnome_items (PlankItemFactory* self);
static void plank_item_factory_finalize (GObject * obj);
static GType plank_item_factory_get_type_once (void);

static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_WEB[6] = {"file:///usr/share/applications/chromium-browser.desktop", "file:///usr/share/applications/google-chrome.desktop", "file:///usr/share/applications/firefox.desktop", "file:///usr/share/applications/epiphany.desktop", "file:///usr/share/applications/midori.desktop", "file:///usr/share/applications/kde4/konqbrowser.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_MAIL[4] = {"file:///usr/share/applications/thunderbird.desktop", "file:///usr/share/applications/evolution.desktop", "file:///usr/share/applications/geary.desktop", "file:///usr/share/applications/kde4/KMail2.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_CALENDAR[4] = {"file:///usr/share/applications/thunderbird.desktop", "file:///usr/share/applications/evolution.desktop", "file:///usr/share/applications/maya-calendar.desktop", "file:///usr/share/applications/kde4/korganizer.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_TERMINAL[4] = {"file:///usr/share/applications/terminator.desktop", "file:///usr/share/applications/gnome-terminal.desktop", "file:///usr/share/applications/pantheon-terminal.desktop", "file:///usr/share/applications/kde4/konsole.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_AUDIO[6] = {"file:///usr/share/applications/exaile.desktop", "file:///usr/share/applications/songbird.desktop", "file:///usr/share/applications/rhythmbox.desktop", "file:///usr/share/applications/noise.desktop", "file:///usr/share/applications/banshee-1.desktop", "file:///usr/share/applications/kde4/amarok.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_VIDEO[4] = {"file:///usr/share/applications/vlc.desktop", "file:///usr/share/applications/totem.desktop", "file:///usr/share/applications/audience.desktop", "file:///usr/share/applications/kde4/amarok.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_PHOTO[5] = {"file:///usr/share/applications/eog.desktop", "file:///usr/share/applications/gnome-photos.desktop", "file:///usr/share/applications/org.gnome.Photos.desktop", "file:///usr/share/applications/shotwell.desktop", "file:///usr/share/applications/kde4/digikam.desktop"};
static const gchar* PLANK_ITEM_FACTORY_DEFAULT_APP_MESSENGER[4] = {"file:///usr/share/applications/pidgin.desktop", "file:///usr/share/applications/empathy.desktop", "file:///usr/share/applications/birdie.desktop", "file:///usr/share/applications/kde4/kopete.desktop"};

/**
 * Creates a new {@link DockElement} from a .dockitem.
 *
 * @param file the {@link GLib.File} of .dockitem file to parse
 * @return the new {@link DockElement} created
 */
static PlankDockElement*
plank_item_factory_real_make_element (PlankItemFactory* self,
                                      GFile* file)
{
	gchar* launcher = NULL;
	gchar* _tmp0_;
	PlankDocklet* docklet = NULL;
	PlankDockletManager* _tmp1_;
	const gchar* _tmp2_;
	PlankDocklet* _tmp3_;
	PlankDocklet* _tmp4_;
	const gchar* _tmp8_;
	PlankDockElement* _tmp9_;
	PlankDockElement* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_item_factory_get_launcher_from_dockitem (self, file);
	launcher = _tmp0_;
	_tmp1_ = plank_docklet_manager_get_default ();
	_tmp2_ = launcher;
	_tmp3_ = plank_docklet_manager_get_docklet_by_uri (_tmp1_, _tmp2_);
	_g_object_unref0 (docklet);
	docklet = _tmp3_;
	_tmp4_ = docklet;
	if (_tmp4_ != NULL) {
		PlankDocklet* _tmp5_;
		const gchar* _tmp6_;
		PlankDockElement* _tmp7_;
		_tmp5_ = docklet;
		_tmp6_ = launcher;
		_tmp7_ = plank_docklet_make_element (_tmp5_, _tmp6_, file);
		result = _tmp7_;
		_g_object_unref0 (docklet);
		_g_free0 (launcher);
		return result;
	}
	_tmp8_ = launcher;
	_tmp9_ = plank_item_factory_default_make_element (self, file, _tmp8_);
	result = _tmp9_;
	_g_object_unref0 (docklet);
	_g_free0 (launcher);
	return result;
}

PlankDockElement*
plank_item_factory_make_element (PlankItemFactory* self,
                                 GFile* file)
{
	PlankItemFactoryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_ITEM_FACTORY_GET_CLASS (self);
	if (_klass_->make_element) {
		return _klass_->make_element (self, file);
	}
	return NULL;
}

/**
 * Creates a new {@link PlankDockItem} for the dock itself.
 *
 * @return the new {@link PlankDockItem} created
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static PlankDockItem*
plank_item_factory_real_get_item_for_dock (PlankItemFactory* self)
{
	PlankPlankDockItem* _tmp0_;
	PlankDockItem* _tmp1_;
	PlankDockItem* result;
	_tmp0_ = plank_plank_dock_item_get_instance ();
	_tmp1_ = _g_object_ref0 ((PlankDockItem*) _tmp0_);
	result = _tmp1_;
	return result;
}

PlankDockItem*
plank_item_factory_get_item_for_dock (PlankItemFactory* self)
{
	PlankItemFactoryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_ITEM_FACTORY_GET_CLASS (self);
	if (_klass_->get_item_for_dock) {
		return _klass_->get_item_for_dock (self);
	}
	return NULL;
}

/**
 * Creates a new {@link DockElement} for a launcher parsed from a .dockitem.
 *
 * @param file the {@link GLib.File} of .dockitem file that was parsed
 * @param launcher the launcher name from the .dockitem
 * @return the new {@link DockElement} created
 */
PlankDockElement*
plank_item_factory_default_make_element (PlankItemFactory* self,
                                         GFile* file,
                                         const gchar* launcher)
{
	PlankFileDockItem* _tmp1_;
	PlankDockElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (launcher != NULL, NULL);
	if (g_str_has_suffix (launcher, ".desktop")) {
		PlankApplicationDockItem* _tmp0_;
		_tmp0_ = plank_application_dock_item_new_with_dockitem_file (file);
		result = (PlankDockElement*) _tmp0_;
		return result;
	}
	_tmp1_ = plank_file_dock_item_new_with_dockitem_file (file);
	result = (PlankDockElement*) _tmp1_;
	return result;
}

/**
 * Parses a .dockitem to get the launcher from it.
 *
 * @param file the {@link GLib.File} of .dockitem to parse
 * @return the launcher from the .dockitem
 */
gchar*
plank_item_factory_get_launcher_from_dockitem (PlankItemFactory* self,
                                               GFile* file)
{
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* group_name = NULL;
		const gchar* _tmp4_;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		GKeyFile* _tmp12_;
		_tmp0_ = g_key_file_new ();
		keyfile = _tmp0_;
		_tmp1_ = keyfile;
		_tmp2_ = g_file_get_path (file);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (_tmp1_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		_tmp4_ = g_type_name (PLANK_TYPE_DOCK_ITEM_PREFERENCES);
		group_name = _tmp4_;
		_tmp5_ = keyfile;
		_tmp6_ = group_name;
		if (g_key_file_has_group (_tmp5_, _tmp6_)) {
			gchar* _tmp7_ = NULL;
			GKeyFile* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = keyfile;
			_tmp9_ = group_name;
			_tmp10_ = g_key_file_get_string (_tmp8_, _tmp9_, "Launcher", &_inner_error0_);
			_tmp7_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (keyfile);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp7_;
			_tmp7_ = NULL;
			result = _tmp11_;
			_g_free0 (_tmp7_);
			_g_key_file_unref0 (keyfile);
			return result;
		}
		_tmp12_ = keyfile;
		if (g_key_file_has_group (_tmp12_, "PlankItemsDockItemPreferences")) {
			gchar* _tmp13_ = NULL;
			GKeyFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp14_ = keyfile;
			_tmp15_ = g_key_file_get_string (_tmp14_, "PlankItemsDockItemPreferences", "Launcher", &_inner_error0_);
			_tmp13_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (keyfile);
				goto __catch0_g_error;
			}
			_tmp16_ = _tmp13_;
			_tmp13_ = NULL;
			result = _tmp16_;
			_g_free0 (_tmp13_);
			_g_key_file_unref0 (keyfile);
			return result;
		}
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_file_get_basename (file);
		_tmp20_ = _tmp19_;
		g_warning ("ItemFactory.vala:154: %s (%s)", _tmp18_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp21_ = g_strdup ("");
	result = _tmp21_;
	return result;
}

/**
 * Creates a list of Dockitems based on .dockitem files found in the given source_dir.
 *
 * @param source_dir the folder where to load .dockitem from
 * @param ordering a ";;"-separated string to be used to order the loaded DockItems
 * @return the new List of DockItems
 */
GeeArrayList*
plank_item_factory_load_elements (PlankItemFactory* self,
                                  GFile* source_dir,
                                  gchar** ordering,
                                  gint ordering_length1)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeHashMap* elements = NULL;
	GeeHashMap* _tmp5_;
	guint count = 0U;
	GeeArrayList* _tmp79_;
	GeeHashMap* _tmp80_;
	GeeCollection* _tmp81_;
	GeeCollection* _tmp82_;
	GeeCollection* _tmp83_;
	GeeHashMap* _tmp84_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_dir != NULL, NULL);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	if (!g_file_query_exists (source_dir, NULL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_path (source_dir);
		_tmp2_ = _tmp1_;
		g_critical ("ItemFactory.vala:172: Given folder '%s' does not exist.", _tmp2_);
		_g_free0 (_tmp2_);
		result = _result_;
		return result;
	}
	_tmp3_ = g_file_get_path (source_dir);
	_tmp4_ = _tmp3_;
	g_debug ("ItemFactory.vala:176: Loading dock elements from '%s'", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	elements = _tmp5_;
	count = 0U;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp6_;
		GFileInfo* info = NULL;
		_tmp6_ = g_file_enumerate_children (source_dir, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, 0, NULL, &_inner_error0_);
		enumerator = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			gchar* filename = NULL;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GFileInfo* _tmp16_;
			guint _tmp18_;
			GFile* file = NULL;
			const gchar* _tmp21_;
			GFile* _tmp22_;
			PlankDockElement* element = NULL;
			GFile* _tmp23_;
			PlankDockElement* _tmp24_;
			PlankDockItemProvider* provider = NULL;
			PlankDockElement* _tmp25_;
			PlankDockItemProvider* _tmp26_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp30_;
			PlankDockItem* _tmp31_;
			PlankDockItem* dupe = NULL;
			GeeArrayList* _tmp32_;
			PlankDockItem* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			PlankDockItem* _tmp36_;
			PlankDockItem* _tmp37_;
			_tmp8_ = enumerator;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (info);
			info = _tmp10_;
			_tmp11_ = info;
			if (!(_tmp11_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp12_ = info;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			filename = _tmp14_;
			_tmp16_ = info;
			if (g_file_info_get_is_hidden (_tmp16_)) {
				_tmp15_ = TRUE;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = filename;
				_tmp15_ = !g_str_has_suffix (_tmp17_, ".dockitem");
			}
			if (_tmp15_) {
				_g_free0 (filename);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			_tmp18_ = count;
			count = _tmp18_ + 1;
			if (_tmp18_ >= PLANK_LAUNCHER_DIR_MAX_FILE_COUNT) {
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = g_file_get_path (source_dir);
				_tmp20_ = _tmp19_;
				g_critical ("ItemFactory.vala:190: There are way too many files (%u+) in '%s'.", PLANK_LAUNCHER_DIR_MAX_FILE_COUNT, _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (filename);
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp21_ = filename;
			_tmp22_ = g_file_get_child (source_dir, _tmp21_);
			file = _tmp22_;
			_tmp23_ = file;
			_tmp24_ = plank_item_factory_make_element (self, _tmp23_);
			element = _tmp24_;
			_tmp25_ = element;
			provider = PLANK_IS_DOCK_ITEM_PROVIDER (_tmp25_) ? ((PlankDockItemProvider*) _tmp25_) : NULL;
			_tmp26_ = provider;
			if (_tmp26_ != NULL) {
				GeeHashMap* _tmp27_;
				const gchar* _tmp28_;
				PlankDockElement* _tmp29_;
				_tmp27_ = elements;
				_tmp28_ = filename;
				_tmp29_ = element;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp29_);
				_g_object_unref0 (element);
				_g_object_unref0 (file);
				_g_free0 (filename);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			_tmp30_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp30_) ? ((PlankDockItem*) _tmp30_) : NULL;
			_tmp31_ = item;
			if (_tmp31_ == NULL) {
				_g_object_unref0 (element);
				_g_object_unref0 (file);
				_g_free0 (filename);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			_tmp32_ = _result_;
			_tmp33_ = item;
			_tmp34_ = plank_dock_item_get_Launcher (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = plank_item_factory_find_item_for_uri (self, _tmp32_, _tmp35_);
			dupe = _tmp36_;
			_tmp37_ = dupe;
			if (_tmp37_ != NULL) {
				PlankDockItem* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				GFile* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				PlankDockItem* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				PlankDockItem* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				PlankDockItem* _tmp52_;
				_tmp38_ = item;
				_tmp39_ = plank_dock_item_get_Launcher (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = file;
				_tmp42_ = g_file_get_path (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = dupe;
				_tmp45_ = plank_dock_item_get_DockItemFilename (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_;
				_tmp48_ = item;
				_tmp49_ = plank_dock_item_get_DockItemFilename (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = _tmp50_;
				g_warning ("ItemFactory.vala:209: The launcher '%s' in dock item '%s' is already m" \
"anaged by dock item '%s'. Removing '%s'.", _tmp40_, _tmp43_, _tmp47_, _tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp47_);
				_g_free0 (_tmp43_);
				_tmp52_ = item;
				plank_dock_item_delete (_tmp52_);
			} else {
				PlankDockItem* _tmp53_;
				_tmp53_ = item;
				if (!plank_dock_item_is_valid (_tmp53_)) {
					PlankDockItem* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					GFile* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					PlankDockItem* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					PlankDockItem* _tmp64_;
					_tmp54_ = item;
					_tmp55_ = plank_dock_item_get_Launcher (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = file;
					_tmp58_ = g_file_get_path (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = item;
					_tmp61_ = plank_dock_item_get_DockItemFilename (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = _tmp62_;
					g_warning ("ItemFactory.vala:213: The launcher '%s' in dock item '%s' does not exi" \
"st. Removing '%s'.", _tmp56_, _tmp59_, _tmp63_);
					_g_free0 (_tmp63_);
					_g_free0 (_tmp59_);
					_tmp64_ = item;
					plank_dock_item_delete (_tmp64_);
				} else {
					GeeHashMap* _tmp65_;
					const gchar* _tmp66_;
					PlankDockElement* _tmp67_;
					_tmp65_ = elements;
					_tmp66_ = filename;
					_tmp67_ = element;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp65_, _tmp66_, _tmp67_);
				}
			}
			_g_object_unref0 (element);
			_g_object_unref0 (file);
			_g_free0 (filename);
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
		GError* _tmp71_;
		const gchar* _tmp72_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp69_ = g_file_get_path (source_dir);
		_tmp68_ = _tmp69_;
		if (_tmp68_ == NULL) {
			gchar* _tmp70_;
			_tmp70_ = g_strdup ("");
			_g_free0 (_tmp68_);
			_tmp68_ = _tmp70_;
		}
		_tmp71_ = e;
		_tmp72_ = _tmp71_->message;
		g_critical ("ItemFactory.vala:220: Error loading dock elements from '%s'. (%s)", _tmp68_, _tmp72_);
		_g_free0 (_tmp68_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (elements);
		_g_object_unref0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (ordering != NULL) {
		{
			gchar** dockitem_collection = NULL;
			gint dockitem_collection_length1 = 0;
			gint _dockitem_collection_size_ = 0;
			gint dockitem_it = 0;
			dockitem_collection = ordering;
			dockitem_collection_length1 = ordering_length1;
			for (dockitem_it = 0; dockitem_it < dockitem_collection_length1; dockitem_it = dockitem_it + 1) {
				const gchar* dockitem = NULL;
				dockitem = dockitem_collection[dockitem_it];
				{
					PlankDockElement* element = NULL;
					GeeHashMap* _tmp73_;
					const gchar* _tmp74_;
					gpointer _tmp75_ = NULL;
					PlankDockElement* _tmp76_;
					_tmp73_ = elements;
					_tmp74_ = dockitem;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp73_, _tmp74_, &_tmp75_);
					_g_object_unref0 (element);
					element = (PlankDockElement*) _tmp75_;
					_tmp76_ = element;
					if (_tmp76_ != NULL) {
						GeeArrayList* _tmp77_;
						PlankDockElement* _tmp78_;
						_tmp77_ = _result_;
						_tmp78_ = element;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp77_, _tmp78_);
					}
					_g_object_unref0 (element);
				}
			}
		}
	}
	_tmp79_ = _result_;
	_tmp80_ = elements;
	_tmp81_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = _tmp82_;
	gee_array_list_add_all (_tmp79_, _tmp83_);
	_g_object_unref0 (_tmp83_);
	_tmp84_ = elements;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp84_);
	result = _result_;
	_g_object_unref0 (elements);
	return result;
}

static PlankDockItem*
plank_item_factory_find_item_for_uri (PlankItemFactory* self,
                                      GeeArrayList* elements,
                                      const gchar* uri)
{
	PlankDockItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (elements != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	{
		GeeArrayList* _element_list = NULL;
		gint _element_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _element_index = 0;
		_element_list = elements;
		_tmp0_ = _element_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_element_size = _tmp2_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp7_;
			gboolean _tmp8_ = FALSE;
			PlankDockItem* _tmp9_;
			_element_index = _element_index + 1;
			_tmp3_ = _element_index;
			_tmp4_ = _element_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _element_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _element_index);
			element = (PlankDockElement*) _tmp6_;
			_tmp7_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp7_) ? ((PlankDockItem*) _tmp7_) : NULL;
			_tmp9_ = item;
			if (_tmp9_ != NULL) {
				PlankDockItem* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp10_ = item;
				_tmp11_ = plank_dock_item_get_Launcher (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp8_ = g_strcmp0 (_tmp12_, uri) == 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				PlankDockItem* _tmp13_;
				_tmp13_ = item;
				result = _tmp13_;
				_g_object_unref0 (element);
				return result;
			}
			_g_object_unref0 (element);
		}
	}
	result = NULL;
	return result;
}

static void
plank_item_factory_make_dock_item_for_desktop_id (PlankItemFactory* self,
                                                  const gchar* id)
{
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	const gchar* filename = NULL;
	GDesktopAppInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = g_desktop_app_info_new (id);
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ == NULL) {
		g_warning ("ItemFactory.vala:252: Failed to create dock item for '%s'", id);
		_g_object_unref0 (app_info);
		return;
	}
	_tmp2_ = app_info;
	_tmp3_ = g_desktop_app_info_get_filename (_tmp2_);
	filename = _tmp3_;
	_tmp4_ = filename;
	if (_tmp4_ == NULL) {
		g_warning ("ItemFactory.vala:258: Failed to create dock item for '%s'", id);
		_g_object_unref0 (app_info);
		return;
	}
	{
		gchar* uri = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = filename;
		_tmp6_ = g_filename_to_uri (_tmp5_, NULL, &_inner_error0_);
		uri = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			_g_object_unref0 (app_info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = uri;
		_tmp8_ = plank_item_factory_make_dock_item (self, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ == NULL;
		_g_object_unref0 (_tmp9_);
		if (_tmp10_) {
			const gchar* _tmp11_;
			_tmp11_ = uri;
			g_warning ("ItemFactory.vala:265: Failed to create dock item for '%s' ('%s')", id, _tmp11_);
		}
		_g_free0 (uri);
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_warning ("ItemFactory.vala:267: Failed to create dock item for '%s'", id);
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("ItemFactory.vala:268: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

static gboolean
plank_item_factory_make_default_gnome_items (PlankItemFactory* self)
{
	GAppInfo* browser = NULL;
	GAppInfo* _tmp0_;
	GAppInfo* mail = NULL;
	GAppInfo* _tmp1_;
	GAppInfo* terminal = NULL;
	GAppInfo* _tmp2_;
	GAppInfo* calendar = NULL;
	GAppInfo* _tmp3_;
	GAppInfo* audio = NULL;
	GAppInfo* _tmp4_;
	GAppInfo* video = NULL;
	GAppInfo* _tmp5_;
	GAppInfo* photo = NULL;
	GAppInfo* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GAppInfo* _tmp13_;
	GAppInfo* _tmp20_;
	GAppInfo* _tmp23_;
	GAppInfo* _tmp26_;
	GAppInfo* _tmp29_;
	GAppInfo* _tmp32_;
	GAppInfo* _tmp35_;
	GAppInfo* _tmp38_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_app_info_get_default_for_type ("x-scheme-handler/http", FALSE);
	browser = _tmp0_;
	_tmp1_ = g_app_info_get_default_for_type ("x-scheme-handler/mailto", FALSE);
	mail = _tmp1_;
	_tmp2_ = g_app_info_get_default_for_uri_scheme ("ssh");
	terminal = _tmp2_;
	_tmp3_ = g_app_info_get_default_for_type ("text/calendar", FALSE);
	calendar = _tmp3_;
	_tmp4_ = g_app_info_get_default_for_type ("audio/x-vorbis+ogg", FALSE);
	audio = _tmp4_;
	_tmp5_ = g_app_info_get_default_for_type ("video/x-ogm+ogg", FALSE);
	video = _tmp5_;
	_tmp6_ = g_app_info_get_default_for_type ("image/jpeg", FALSE);
	photo = _tmp6_;
	_tmp13_ = browser;
	if (_tmp13_ == NULL) {
		GAppInfo* _tmp14_;
		_tmp14_ = mail;
		_tmp12_ = _tmp14_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GAppInfo* _tmp15_;
		_tmp15_ = calendar;
		_tmp11_ = _tmp15_ == NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GAppInfo* _tmp16_;
		_tmp16_ = terminal;
		_tmp10_ = _tmp16_ == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GAppInfo* _tmp17_;
		_tmp17_ = audio;
		_tmp9_ = _tmp17_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GAppInfo* _tmp18_;
		_tmp18_ = video;
		_tmp8_ = _tmp18_ == NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GAppInfo* _tmp19_;
		_tmp19_ = photo;
		_tmp7_ = _tmp19_ == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = FALSE;
		_g_object_unref0 (photo);
		_g_object_unref0 (video);
		_g_object_unref0 (audio);
		_g_object_unref0 (calendar);
		_g_object_unref0 (terminal);
		_g_object_unref0 (mail);
		_g_object_unref0 (browser);
		return result;
	}
	_tmp20_ = browser;
	if (_tmp20_ != NULL) {
		GAppInfo* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = browser;
		_tmp22_ = g_app_info_get_id (_tmp21_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp22_);
	}
	_tmp23_ = mail;
	if (_tmp23_ != NULL) {
		GAppInfo* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = mail;
		_tmp25_ = g_app_info_get_id (_tmp24_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp25_);
	}
	_tmp26_ = terminal;
	if (_tmp26_ != NULL) {
		GAppInfo* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = terminal;
		_tmp28_ = g_app_info_get_id (_tmp27_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp28_);
	}
	_tmp29_ = calendar;
	if (_tmp29_ != NULL) {
		GAppInfo* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = calendar;
		_tmp31_ = g_app_info_get_id (_tmp30_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp31_);
	}
	_tmp32_ = audio;
	if (_tmp32_ != NULL) {
		GAppInfo* _tmp33_;
		const gchar* _tmp34_;
		_tmp33_ = audio;
		_tmp34_ = g_app_info_get_id (_tmp33_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp34_);
	}
	_tmp35_ = video;
	if (_tmp35_ != NULL) {
		GAppInfo* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = video;
		_tmp37_ = g_app_info_get_id (_tmp36_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp37_);
	}
	_tmp38_ = photo;
	if (_tmp38_ != NULL) {
		GAppInfo* _tmp39_;
		const gchar* _tmp40_;
		_tmp39_ = photo;
		_tmp40_ = g_app_info_get_id (_tmp39_);
		plank_item_factory_make_dock_item_for_desktop_id (self, _tmp40_);
	}
	result = TRUE;
	_g_object_unref0 (photo);
	_g_object_unref0 (video);
	_g_object_unref0 (audio);
	_g_object_unref0 (calendar);
	_g_object_unref0 (terminal);
	_g_object_unref0 (mail);
	_g_object_unref0 (browser);
	return result;
}

/**
 * Creates a bunch of default .dockitem's.
 */
void
plank_item_factory_make_default_items (PlankItemFactory* self)
{
	g_return_if_fail (self != NULL);
	if (plank_item_factory_make_default_gnome_items (self)) {
		return;
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_WEB;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_WEB);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp0_;
				GFile* _tmp1_;
				GFile* _tmp2_;
				gboolean _tmp3_;
				_tmp0_ = uri;
				_tmp1_ = plank_item_factory_make_dock_item (self, _tmp0_, NULL);
				_tmp2_ = _tmp1_;
				_tmp3_ = _tmp2_ != NULL;
				_g_object_unref0 (_tmp2_);
				if (_tmp3_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_MAIL;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_MAIL);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp4_;
				GFile* _tmp5_;
				GFile* _tmp6_;
				gboolean _tmp7_;
				_tmp4_ = uri;
				_tmp5_ = plank_item_factory_make_dock_item (self, _tmp4_, NULL);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_ != NULL;
				_g_object_unref0 (_tmp6_);
				if (_tmp7_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_TERMINAL;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_TERMINAL);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp8_;
				GFile* _tmp9_;
				GFile* _tmp10_;
				gboolean _tmp11_;
				_tmp8_ = uri;
				_tmp9_ = plank_item_factory_make_dock_item (self, _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_ != NULL;
				_g_object_unref0 (_tmp10_);
				if (_tmp11_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_AUDIO;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_AUDIO);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gboolean _tmp15_;
				_tmp12_ = uri;
				_tmp13_ = plank_item_factory_make_dock_item (self, _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_ != NULL;
				_g_object_unref0 (_tmp14_);
				if (_tmp15_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_VIDEO;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_VIDEO);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				gboolean _tmp19_;
				_tmp16_ = uri;
				_tmp17_ = plank_item_factory_make_dock_item (self, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_ != NULL;
				_g_object_unref0 (_tmp18_);
				if (_tmp19_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_PHOTO;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_PHOTO);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp20_;
				GFile* _tmp21_;
				GFile* _tmp22_;
				gboolean _tmp23_;
				_tmp20_ = uri;
				_tmp21_ = plank_item_factory_make_dock_item (self, _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_ != NULL;
				_g_object_unref0 (_tmp22_);
				if (_tmp23_) {
					break;
				}
			}
		}
	}
	{
		const gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = PLANK_ITEM_FACTORY_DEFAULT_APP_MESSENGER;
		uri_collection_length1 = G_N_ELEMENTS (PLANK_ITEM_FACTORY_DEFAULT_APP_MESSENGER);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			const gchar* uri = NULL;
			uri = uri_collection[uri_it];
			{
				const gchar* _tmp24_;
				GFile* _tmp25_;
				GFile* _tmp26_;
				gboolean _tmp27_;
				_tmp24_ = uri;
				_tmp25_ = plank_item_factory_make_dock_item (self, _tmp24_, NULL);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_ != NULL;
				_g_object_unref0 (_tmp26_);
				if (_tmp27_) {
					break;
				}
			}
		}
	}
}

/**
 * Creates a new .dockitem for a uri.
 *
 * @param uri the uri or path to create a .dockitem for
 * @param target_dir the folder where to put the newly created .dockitem (defaults to launchers_dir)
 * @return the new {@link GLib.File} of the new .dockitem created
 */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

GFile*
plank_item_factory_make_dock_item (PlankItemFactory* self,
                                   const gchar* uri,
                                   GFile* target_dir)
{
	gboolean is_valid = FALSE;
	gchar* basename = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	if (target_dir == NULL) {
		GFile* _tmp0_;
		_tmp0_ = self->launchers_dir;
		target_dir = _tmp0_;
	}
	is_valid = FALSE;
	if (g_str_has_prefix (uri, PLANK_DOCKLET_URI_PREFIX)) {
		gchar* _tmp1_;
		is_valid = TRUE;
		_tmp1_ = string_substring (uri, (glong) 10, (glong) -1);
		_g_free0 (basename);
		basename = _tmp1_;
	} else {
		GFile* launcher_file = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp8_;
		_tmp2_ = g_file_new_for_uri (uri);
		launcher_file = _tmp2_;
		_tmp3_ = launcher_file;
		is_valid = g_file_query_exists (_tmp3_, NULL);
		_tmp5_ = launcher_file;
		_tmp6_ = g_file_get_basename (_tmp5_);
		_tmp4_ = _tmp6_;
		if (_tmp4_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("unknown");
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp7_;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (basename);
		basename = _tmp8_;
		_g_free0 (_tmp4_);
		_g_object_unref0 (launcher_file);
	}
	if (is_valid) {
		GKeyFile* file = NULL;
		GKeyFile* _tmp9_;
		GKeyFile* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = g_key_file_new ();
		file = _tmp9_;
		_tmp10_ = file;
		_tmp11_ = g_type_name (PLANK_TYPE_DOCK_ITEM_PREFERENCES);
		g_key_file_set_string (_tmp10_, _tmp11_, "Launcher", uri);
		{
			gint index_of_last_dot = 0;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* launcher_base = NULL;
			gchar* _tmp18_;
			gchar* dockitem = NULL;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			GFile* dockitem_file = NULL;
			const gchar* _tmp21_;
			GFile* _tmp22_;
			gint counter = 0;
			GFileOutputStream* _tmp29_ = NULL;
			GFile* _tmp30_;
			GFileOutputStream* _tmp31_;
			GDataOutputStream* stream = NULL;
			GDataOutputStream* _tmp32_;
			GDataOutputStream* _tmp33_;
			GKeyFile* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GDataOutputStream* _tmp37_;
			GFile* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp12_ = basename;
			index_of_last_dot = string_last_index_of (_tmp12_, ".", 0);
			if (index_of_last_dot >= 0) {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = basename;
				_tmp15_ = string_slice (_tmp14_, (glong) 0, (glong) index_of_last_dot);
				_g_free0 (_tmp13_);
				_tmp13_ = _tmp15_;
			} else {
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = basename;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (_tmp13_);
				_tmp13_ = _tmp17_;
			}
			_tmp18_ = g_strdup (_tmp13_);
			launcher_base = _tmp18_;
			_tmp19_ = launcher_base;
			_tmp20_ = g_strdup_printf ("%s.dockitem", _tmp19_);
			dockitem = _tmp20_;
			_tmp21_ = dockitem;
			_tmp22_ = g_file_get_child (target_dir, _tmp21_);
			dockitem_file = _tmp22_;
			counter = 1;
			while (TRUE) {
				GFile* _tmp23_;
				const gchar* _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				GFile* _tmp28_;
				_tmp23_ = dockitem_file;
				if (!g_file_query_exists (_tmp23_, NULL)) {
					break;
				}
				_tmp24_ = launcher_base;
				_tmp25_ = counter;
				counter = _tmp25_ + 1;
				_tmp26_ = g_strdup_printf ("%s-%d.dockitem", _tmp24_, _tmp25_);
				_g_free0 (dockitem);
				dockitem = _tmp26_;
				_tmp27_ = dockitem;
				_tmp28_ = g_file_get_child (target_dir, _tmp27_);
				_g_object_unref0 (dockitem_file);
				dockitem_file = _tmp28_;
			}
			_tmp30_ = dockitem_file;
			_tmp31_ = g_file_create (_tmp30_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp29_ = _tmp31_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dockitem_file);
				_g_free0 (dockitem);
				_g_free0 (launcher_base);
				_g_free0 (_tmp13_);
				goto __catch0_g_error;
			}
			_tmp32_ = g_data_output_stream_new ((GOutputStream*) _tmp29_);
			stream = _tmp32_;
			_tmp33_ = stream;
			_tmp34_ = file;
			_tmp35_ = g_key_file_to_data (_tmp34_, NULL, NULL);
			_tmp36_ = _tmp35_;
			g_data_output_stream_put_string (_tmp33_, _tmp36_, NULL, &_inner_error0_);
			_g_free0 (_tmp36_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (dockitem_file);
				_g_free0 (dockitem);
				_g_free0 (launcher_base);
				_g_free0 (_tmp13_);
				goto __catch0_g_error;
			}
			_tmp37_ = stream;
			g_output_stream_close ((GOutputStream*) _tmp37_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (dockitem_file);
				_g_free0 (dockitem);
				_g_free0 (launcher_base);
				_g_free0 (_tmp13_);
				goto __catch0_g_error;
			}
			_tmp38_ = dockitem_file;
			_tmp39_ = g_file_get_path (_tmp38_);
			_tmp40_ = _tmp39_;
			g_debug ("ItemFactory.vala:395: Created dock item '%s' for launcher '%s'", _tmp40_, uri);
			_g_free0 (_tmp40_);
			result = dockitem_file;
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp29_);
			_g_free0 (dockitem);
			_g_free0 (launcher_base);
			_g_free0 (_tmp13_);
			_g_key_file_unref0 (file);
			_g_free0 (basename);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (file);
			_g_free0 (basename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_key_file_unref0 (file);
	}
	result = NULL;
	_g_free0 (basename);
	return result;
}

PlankItemFactory*
plank_item_factory_construct (GType object_type)
{
	PlankItemFactory * self = NULL;
	self = (PlankItemFactory*) g_object_new (object_type, NULL);
	return self;
}

PlankItemFactory*
plank_item_factory_new (void)
{
	return plank_item_factory_construct (PLANK_TYPE_ITEM_FACTORY);
}

static void
plank_item_factory_class_init (PlankItemFactoryClass * klass,
                               gpointer klass_data)
{
	plank_item_factory_parent_class = g_type_class_peek_parent (klass);
	((PlankItemFactoryClass *) klass)->make_element = (PlankDockElement* (*) (PlankItemFactory*, GFile*)) plank_item_factory_real_make_element;
	((PlankItemFactoryClass *) klass)->get_item_for_dock = (PlankDockItem* (*) (PlankItemFactory*)) plank_item_factory_real_get_item_for_dock;
	G_OBJECT_CLASS (klass)->finalize = plank_item_factory_finalize;
}

static void
plank_item_factory_instance_init (PlankItemFactory * self,
                                  gpointer klass)
{
}

static void
plank_item_factory_finalize (GObject * obj)
{
	PlankItemFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_ITEM_FACTORY, PlankItemFactory);
	_g_object_unref0 (self->launchers_dir);
	G_OBJECT_CLASS (plank_item_factory_parent_class)->finalize (obj);
}

/**
 * An item factory.  Creates {@link DockItem}s based on .dockitem files.
 */
static GType
plank_item_factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankItemFactory), 0, (GInstanceInitFunc) plank_item_factory_instance_init, NULL };
	GType plank_item_factory_type_id;
	plank_item_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankItemFactory", &g_define_type_info, 0);
	return plank_item_factory_type_id;
}

GType
plank_item_factory_get_type (void)
{
	static volatile gsize plank_item_factory_type_id__once = 0;
	if (g_once_init_enter (&plank_item_factory_type_id__once)) {
		GType plank_item_factory_type_id;
		plank_item_factory_type_id = plank_item_factory_get_type_once ();
		g_once_init_leave (&plank_item_factory_type_id__once, plank_item_factory_type_id);
	}
	return plank_item_factory_type_id__once;
}

