/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 177 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 160 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 210 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 169 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 142 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
// Raise an exception when QMetaObject::invokeMethod() returns false.
static void qtcore_invokeMethod_exception()
{
    PyErr_SetString(PyExc_RuntimeError, "QMetaObject.invokeMethod() call failed");
}
#line 64 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"


PyDoc_STRVAR(doc_QMetaObject_className, "className(self) -> str");

extern "C" {static PyObject *meth_QMetaObject_className(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_className(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            const char*sipRes;

            sipRes = sipCpp->className();

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_DecodeASCII(sipRes, strlen(sipRes), SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_className, doc_QMetaObject_className);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_superClass, "superClass(self) -> QMetaObject|None");

extern "C" {static PyObject *meth_QMetaObject_superClass(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_superClass(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            const ::QMetaObject*sipRes;

            sipRes = sipCpp->superClass();

            return sipConvertFromType(const_cast< ::QMetaObject *>(sipRes), sipType_QMetaObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_superClass, doc_QMetaObject_superClass);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_userProperty, "userProperty(self) -> QMetaProperty");

extern "C" {static PyObject *meth_QMetaObject_userProperty(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_userProperty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            ::QMetaProperty*sipRes;

            sipRes = new ::QMetaProperty(sipCpp->userProperty());

            return sipConvertFromNewType(sipRes, sipType_QMetaProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_userProperty, doc_QMetaObject_userProperty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_methodOffset, "methodOffset(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_methodOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_methodOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->methodOffset();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_methodOffset, doc_QMetaObject_methodOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_enumeratorOffset, "enumeratorOffset(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_enumeratorOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumeratorOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->enumeratorOffset();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_enumeratorOffset, doc_QMetaObject_enumeratorOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_propertyOffset, "propertyOffset(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_propertyOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_propertyOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->propertyOffset();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_propertyOffset, doc_QMetaObject_propertyOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_classInfoOffset, "classInfoOffset(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_classInfoOffset(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfoOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->classInfoOffset();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_classInfoOffset, doc_QMetaObject_classInfoOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_methodCount, "methodCount(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_methodCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_methodCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->methodCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_methodCount, doc_QMetaObject_methodCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_enumeratorCount, "enumeratorCount(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_enumeratorCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumeratorCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->enumeratorCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_enumeratorCount, doc_QMetaObject_enumeratorCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_propertyCount, "propertyCount(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_propertyCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_propertyCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->propertyCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_propertyCount, doc_QMetaObject_propertyCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_classInfoCount, "classInfoCount(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_classInfoCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfoCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->classInfoCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_classInfoCount, doc_QMetaObject_classInfoCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfMethod, "indexOfMethod(self, method: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfMethod(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfMethod(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfMethod, doc_QMetaObject_indexOfMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfSignal, "indexOfSignal(self, signal: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfSignal(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfSignal(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfSignal(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfSignal, doc_QMetaObject_indexOfSignal);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfSlot, "indexOfSlot(self, slot: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfSlot(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfSlot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfSlot(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfSlot, doc_QMetaObject_indexOfSlot);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfEnumerator, "indexOfEnumerator(self, name: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfEnumerator(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfEnumerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfEnumerator(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfEnumerator, doc_QMetaObject_indexOfEnumerator);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfProperty, "indexOfProperty(self, name: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfProperty(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfProperty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfProperty(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfProperty, doc_QMetaObject_indexOfProperty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfClassInfo, "indexOfClassInfo(self, name: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfClassInfo(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfClassInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfClassInfo(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfClassInfo, doc_QMetaObject_indexOfClassInfo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_method, "method(self, index: int) -> QMetaMethod");

extern "C" {static PyObject *meth_QMetaObject_method(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_method(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMetaObject, &sipCpp, &a0))
        {
            ::QMetaMethod*sipRes;

            sipRes = new ::QMetaMethod(sipCpp->method(a0));

            return sipConvertFromNewType(sipRes, sipType_QMetaMethod, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_method, doc_QMetaObject_method);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_enumerator, "enumerator(self, index: int) -> QMetaEnum");

extern "C" {static PyObject *meth_QMetaObject_enumerator(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_enumerator(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMetaObject, &sipCpp, &a0))
        {
            ::QMetaEnum*sipRes;

            sipRes = new ::QMetaEnum(sipCpp->enumerator(a0));

            return sipConvertFromNewType(sipRes, sipType_QMetaEnum, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_enumerator, doc_QMetaObject_enumerator);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_property, "property(self, index: int) -> QMetaProperty");

extern "C" {static PyObject *meth_QMetaObject_property(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_property(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMetaObject, &sipCpp, &a0))
        {
            ::QMetaProperty*sipRes;

            sipRes = new ::QMetaProperty(sipCpp->property(a0));

            return sipConvertFromNewType(sipRes, sipType_QMetaProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_property, doc_QMetaObject_property);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_classInfo, "classInfo(self, index: int) -> QMetaClassInfo");

extern "C" {static PyObject *meth_QMetaObject_classInfo(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_classInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMetaObject, &sipCpp, &a0))
        {
            ::QMetaClassInfo*sipRes;

            sipRes = new ::QMetaClassInfo(sipCpp->classInfo(a0));

            return sipConvertFromNewType(sipRes, sipType_QMetaClassInfo, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_classInfo, doc_QMetaObject_classInfo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_checkConnectArgs, "checkConnectArgs(signal: str, method: str) -> bool\n"
"checkConnectArgs(signal: QMetaMethod, method: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QMetaObject_checkConnectArgs(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_checkConnectArgs(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const char* a1;
        PyObject *a1Keep;

        if (sipParseArgs(&sipParseErr, sipArgs, "AAAA", &a0Keep, &a0, &a1Keep, &a1))
        {
            bool sipRes;

            sipRes = ::QMetaObject::checkConnectArgs(a0, a1);
            Py_DECREF(a0Keep);
            Py_DECREF(a1Keep);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QMetaMethod* a0;
        const ::QMetaMethod* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QMetaMethod, &a0, sipType_QMetaMethod, &a1))
        {
            bool sipRes;

            sipRes = ::QMetaObject::checkConnectArgs(*a0, *a1);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_checkConnectArgs, doc_QMetaObject_checkConnectArgs);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_connectSlotsByName, "connectSlotsByName(o: QObject|None)");

extern "C" {static PyObject *meth_QMetaObject_connectSlotsByName(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_connectSlotsByName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        PyObject *a0Wrapper;

        if (sipParseArgs(&sipParseErr, sipArgs, "@J8", &a0Wrapper, sipType_QObject, &a0))
        {
#line 61 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
        qpycore_qmetaobject_connectslotsbyname(a0, a0Wrapper);
        
        // Make sure there is no (benign) Python exception.
        PyErr_Clear();
#line 705 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_connectSlotsByName, doc_QMetaObject_connectSlotsByName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_normalizedSignature, "normalizedSignature(method: str) -> QByteArray");

extern "C" {static PyObject *meth_QMetaObject_normalizedSignature(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_normalizedSignature(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;

        if (sipParseArgs(&sipParseErr, sipArgs, "AA", &a0Keep, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QMetaObject::normalizedSignature(a0));
            Py_DECREF(a0Keep);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_normalizedSignature, doc_QMetaObject_normalizedSignature);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_normalizedType, "normalizedType(type: str) -> QByteArray");

extern "C" {static PyObject *meth_QMetaObject_normalizedType(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_normalizedType(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;

        if (sipParseArgs(&sipParseErr, sipArgs, "AA", &a0Keep, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QMetaObject::normalizedType(a0));
            Py_DECREF(a0Keep);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_normalizedType, doc_QMetaObject_normalizedType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_invokeMethod, "invokeMethod(obj: QObject|None, member: str, type: Qt.ConnectionType, ret: QGenericReturnArgument, value0: QGenericArgument = QGenericArgument(0, 0), value1: QGenericArgument = QGenericArgument(0, 0), value2: QGenericArgument = QGenericArgument(0, 0), value3: QGenericArgument = QGenericArgument(0, 0), value4: QGenericArgument = QGenericArgument(0, 0), value5: QGenericArgument = QGenericArgument(0, 0), value6: QGenericArgument = QGenericArgument(0, 0), value7: QGenericArgument = QGenericArgument(0, 0), value8: QGenericArgument = QGenericArgument(0, 0), value9: QGenericArgument = QGenericArgument(0, 0)) -> Any\n"
"invokeMethod(obj: QObject|None, member: str, ret: QGenericReturnArgument, value0: QGenericArgument = QGenericArgument(0, 0), value1: QGenericArgument = QGenericArgument(0, 0), value2: QGenericArgument = QGenericArgument(0, 0), value3: QGenericArgument = QGenericArgument(0, 0), value4: QGenericArgument = QGenericArgument(0, 0), value5: QGenericArgument = QGenericArgument(0, 0), value6: QGenericArgument = QGenericArgument(0, 0), value7: QGenericArgument = QGenericArgument(0, 0), value8: QGenericArgument = QGenericArgument(0, 0), value9: QGenericArgument = QGenericArgument(0, 0)) -> Any\n"
"invokeMethod(obj: QObject|None, member: str, type: Qt.ConnectionType, value0: QGenericArgument = QGenericArgument(0, 0), value1: QGenericArgument = QGenericArgument(0, 0), value2: QGenericArgument = QGenericArgument(0, 0), value3: QGenericArgument = QGenericArgument(0, 0), value4: QGenericArgument = QGenericArgument(0, 0), value5: QGenericArgument = QGenericArgument(0, 0), value6: QGenericArgument = QGenericArgument(0, 0), value7: QGenericArgument = QGenericArgument(0, 0), value8: QGenericArgument = QGenericArgument(0, 0), value9: QGenericArgument = QGenericArgument(0, 0)) -> Any\n"
"invokeMethod(obj: QObject|None, member: str, value0: QGenericArgument = QGenericArgument(0, 0), value1: QGenericArgument = QGenericArgument(0, 0), value2: QGenericArgument = QGenericArgument(0, 0), value3: QGenericArgument = QGenericArgument(0, 0), value4: QGenericArgument = QGenericArgument(0, 0), value5: QGenericArgument = QGenericArgument(0, 0), value6: QGenericArgument = QGenericArgument(0, 0), value7: QGenericArgument = QGenericArgument(0, 0), value8: QGenericArgument = QGenericArgument(0, 0), value9: QGenericArgument = QGenericArgument(0, 0)) -> Any");

extern "C" {static PyObject *meth_QMetaObject_invokeMethod(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_invokeMethod(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        const char* a1;
        PyObject *a1Keep;
        ::Qt::ConnectionType a2;
        ::QGenericReturnArgument* a3;
        PyObject *a3Wrapper;
        ::QGenericArgument a4def = QGenericArgument(0, 0);
        ::QGenericArgument* a4 = &a4def;
        ::QGenericArgument a5def = QGenericArgument(0, 0);
        ::QGenericArgument* a5 = &a5def;
        ::QGenericArgument a6def = QGenericArgument(0, 0);
        ::QGenericArgument* a6 = &a6def;
        ::QGenericArgument a7def = QGenericArgument(0, 0);
        ::QGenericArgument* a7 = &a7def;
        ::QGenericArgument a8def = QGenericArgument(0, 0);
        ::QGenericArgument* a8 = &a8def;
        ::QGenericArgument a9def = QGenericArgument(0, 0);
        ::QGenericArgument* a9 = &a9def;
        ::QGenericArgument a10def = QGenericArgument(0, 0);
        ::QGenericArgument* a10 = &a10def;
        ::QGenericArgument a11def = QGenericArgument(0, 0);
        ::QGenericArgument* a11 = &a11def;
        ::QGenericArgument a12def = QGenericArgument(0, 0);
        ::QGenericArgument* a12 = &a12def;
        ::QGenericArgument a13def = QGenericArgument(0, 0);
        ::QGenericArgument* a13 = &a13def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_value0,
            sipName_value1,
            sipName_value2,
            sipName_value3,
            sipName_value4,
            sipName_value5,
            sipName_value6,
            sipName_value7,
            sipName_value8,
            sipName_value9,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8AAE@J9|J9J9J9J9J9J9J9J9J9J9", sipType_QObject, &a0, &a1Keep, &a1, sipType_Qt_ConnectionType, &a2, &a3Wrapper, sipType_QGenericReturnArgument, &a3, sipType_QGenericArgument, &a4, sipType_QGenericArgument, &a5, sipType_QGenericArgument, &a6, sipType_QGenericArgument, &a7, sipType_QGenericArgument, &a8, sipType_QGenericArgument, &a9, sipType_QGenericArgument, &a10, sipType_QGenericArgument, &a11, sipType_QGenericArgument, &a12, sipType_QGenericArgument, &a13))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 71 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12,*a13);
        Py_END_ALLOW_THREADS
        
        if (ok)
            sipRes = qpycore_ReturnValue(a3Wrapper);
        else
            qtcore_invokeMethod_exception();
#line 845 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
            Py_DECREF(a1Keep);

            return sipRes;
        }
    }

    {
        ::QObject* a0;
        const char* a1;
        PyObject *a1Keep;
        ::QGenericReturnArgument* a2;
        PyObject *a2Wrapper;
        ::QGenericArgument a3def = QGenericArgument(0, 0);
        ::QGenericArgument* a3 = &a3def;
        ::QGenericArgument a4def = QGenericArgument(0, 0);
        ::QGenericArgument* a4 = &a4def;
        ::QGenericArgument a5def = QGenericArgument(0, 0);
        ::QGenericArgument* a5 = &a5def;
        ::QGenericArgument a6def = QGenericArgument(0, 0);
        ::QGenericArgument* a6 = &a6def;
        ::QGenericArgument a7def = QGenericArgument(0, 0);
        ::QGenericArgument* a7 = &a7def;
        ::QGenericArgument a8def = QGenericArgument(0, 0);
        ::QGenericArgument* a8 = &a8def;
        ::QGenericArgument a9def = QGenericArgument(0, 0);
        ::QGenericArgument* a9 = &a9def;
        ::QGenericArgument a10def = QGenericArgument(0, 0);
        ::QGenericArgument* a10 = &a10def;
        ::QGenericArgument a11def = QGenericArgument(0, 0);
        ::QGenericArgument* a11 = &a11def;
        ::QGenericArgument a12def = QGenericArgument(0, 0);
        ::QGenericArgument* a12 = &a12def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_value0,
            sipName_value1,
            sipName_value2,
            sipName_value3,
            sipName_value4,
            sipName_value5,
            sipName_value6,
            sipName_value7,
            sipName_value8,
            sipName_value9,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8AA@J9|J9J9J9J9J9J9J9J9J9J9", sipType_QObject, &a0, &a1Keep, &a1, &a2Wrapper, sipType_QGenericReturnArgument, &a2, sipType_QGenericArgument, &a3, sipType_QGenericArgument, &a4, sipType_QGenericArgument, &a5, sipType_QGenericArgument, &a6, sipType_QGenericArgument, &a7, sipType_QGenericArgument, &a8, sipType_QGenericArgument, &a9, sipType_QGenericArgument, &a10, sipType_QGenericArgument, &a11, sipType_QGenericArgument, &a12))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 86 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12);
        Py_END_ALLOW_THREADS
        
        if (ok)
            sipRes = qpycore_ReturnValue(a2Wrapper);
        else
            qtcore_invokeMethod_exception();
#line 911 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
            Py_DECREF(a1Keep);

            return sipRes;
        }
    }

    {
        ::QObject* a0;
        const char* a1;
        PyObject *a1Keep;
        ::Qt::ConnectionType a2;
        ::QGenericArgument a3def = QGenericArgument(0, 0);
        ::QGenericArgument* a3 = &a3def;
        ::QGenericArgument a4def = QGenericArgument(0, 0);
        ::QGenericArgument* a4 = &a4def;
        ::QGenericArgument a5def = QGenericArgument(0, 0);
        ::QGenericArgument* a5 = &a5def;
        ::QGenericArgument a6def = QGenericArgument(0, 0);
        ::QGenericArgument* a6 = &a6def;
        ::QGenericArgument a7def = QGenericArgument(0, 0);
        ::QGenericArgument* a7 = &a7def;
        ::QGenericArgument a8def = QGenericArgument(0, 0);
        ::QGenericArgument* a8 = &a8def;
        ::QGenericArgument a9def = QGenericArgument(0, 0);
        ::QGenericArgument* a9 = &a9def;
        ::QGenericArgument a10def = QGenericArgument(0, 0);
        ::QGenericArgument* a10 = &a10def;
        ::QGenericArgument a11def = QGenericArgument(0, 0);
        ::QGenericArgument* a11 = &a11def;
        ::QGenericArgument a12def = QGenericArgument(0, 0);
        ::QGenericArgument* a12 = &a12def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_value0,
            sipName_value1,
            sipName_value2,
            sipName_value3,
            sipName_value4,
            sipName_value5,
            sipName_value6,
            sipName_value7,
            sipName_value8,
            sipName_value9,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8AAE|J9J9J9J9J9J9J9J9J9J9", sipType_QObject, &a0, &a1Keep, &a1, sipType_Qt_ConnectionType, &a2, sipType_QGenericArgument, &a3, sipType_QGenericArgument, &a4, sipType_QGenericArgument, &a5, sipType_QGenericArgument, &a6, sipType_QGenericArgument, &a7, sipType_QGenericArgument, &a8, sipType_QGenericArgument, &a9, sipType_QGenericArgument, &a10, sipType_QGenericArgument, &a11, sipType_QGenericArgument, &a12))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 101 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11,*a12);
        Py_END_ALLOW_THREADS
        
        if (ok)
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
        else
            qtcore_invokeMethod_exception();
#line 979 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
            Py_DECREF(a1Keep);

            return sipRes;
        }
    }

    {
        ::QObject* a0;
        const char* a1;
        PyObject *a1Keep;
        ::QGenericArgument a2def = QGenericArgument(0, 0);
        ::QGenericArgument* a2 = &a2def;
        ::QGenericArgument a3def = QGenericArgument(0, 0);
        ::QGenericArgument* a3 = &a3def;
        ::QGenericArgument a4def = QGenericArgument(0, 0);
        ::QGenericArgument* a4 = &a4def;
        ::QGenericArgument a5def = QGenericArgument(0, 0);
        ::QGenericArgument* a5 = &a5def;
        ::QGenericArgument a6def = QGenericArgument(0, 0);
        ::QGenericArgument* a6 = &a6def;
        ::QGenericArgument a7def = QGenericArgument(0, 0);
        ::QGenericArgument* a7 = &a7def;
        ::QGenericArgument a8def = QGenericArgument(0, 0);
        ::QGenericArgument* a8 = &a8def;
        ::QGenericArgument a9def = QGenericArgument(0, 0);
        ::QGenericArgument* a9 = &a9def;
        ::QGenericArgument a10def = QGenericArgument(0, 0);
        ::QGenericArgument* a10 = &a10def;
        ::QGenericArgument a11def = QGenericArgument(0, 0);
        ::QGenericArgument* a11 = &a11def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_value0,
            sipName_value1,
            sipName_value2,
            sipName_value3,
            sipName_value4,
            sipName_value5,
            sipName_value6,
            sipName_value7,
            sipName_value8,
            sipName_value9,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8AA|J9J9J9J9J9J9J9J9J9J9", sipType_QObject, &a0, &a1Keep, &a1, sipType_QGenericArgument, &a2, sipType_QGenericArgument, &a3, sipType_QGenericArgument, &a4, sipType_QGenericArgument, &a5, sipType_QGenericArgument, &a6, sipType_QGenericArgument, &a7, sipType_QGenericArgument, &a8, sipType_QGenericArgument, &a9, sipType_QGenericArgument, &a10, sipType_QGenericArgument, &a11))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 119 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
        // Raise an exception if the call failed.
        bool ok;
        
        Py_BEGIN_ALLOW_THREADS
        ok = QMetaObject::invokeMethod(a0,a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8,*a9,*a10,*a11);
        Py_END_ALLOW_THREADS
        
        if (ok)
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
        else
            qtcore_invokeMethod_exception();
#line 1045 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQMetaObject.cpp"
            Py_DECREF(a1Keep);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_invokeMethod, doc_QMetaObject_invokeMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_constructorCount, "constructorCount(self) -> int");

extern "C" {static PyObject *meth_QMetaObject_constructorCount(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_constructorCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMetaObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->constructorCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_constructorCount, doc_QMetaObject_constructorCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_indexOfConstructor, "indexOfConstructor(self, constructor: str) -> int");

extern "C" {static PyObject *meth_QMetaObject_indexOfConstructor(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_indexOfConstructor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QMetaObject, &sipCpp, &a0Keep, &a0))
        {
            int sipRes;

            sipRes = sipCpp->indexOfConstructor(a0);
            Py_DECREF(a0Keep);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_indexOfConstructor, doc_QMetaObject_indexOfConstructor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_constructor, "constructor(self, index: int) -> QMetaMethod");

extern "C" {static PyObject *meth_QMetaObject_constructor(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_constructor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMetaObject, &sipCpp, &a0))
        {
            ::QMetaMethod*sipRes;

            sipRes = new ::QMetaMethod(sipCpp->constructor(a0));

            return sipConvertFromNewType(sipRes, sipType_QMetaMethod, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_constructor, doc_QMetaObject_constructor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMetaObject_inherits, "inherits(self, metaObject: QMetaObject|None) -> bool");

extern "C" {static PyObject *meth_QMetaObject_inherits(PyObject *, PyObject *);}
static PyObject *meth_QMetaObject_inherits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject* a0;
        const ::QMetaObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QMetaObject, &sipCpp, sipType_QMetaObject, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->inherits(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMetaObject, sipName_inherits, doc_QMetaObject_inherits);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QMetaObject(void *, int);}
static void release_QMetaObject(void *sipCppV, int)
{
    delete reinterpret_cast< ::QMetaObject *>(sipCppV);
}


extern "C" {static void *array_QMetaObject(Py_ssize_t);}
static void *array_QMetaObject(Py_ssize_t sipNrElem)
{
    return new ::QMetaObject[sipNrElem];
}


extern "C" {static void array_delete_QMetaObject(void *);}
static void array_delete_QMetaObject(void *sipCpp)
{
    delete[] reinterpret_cast< ::QMetaObject *>(sipCpp);
}


extern "C" {static void assign_QMetaObject(void *, Py_ssize_t, void *);}
static void assign_QMetaObject(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QMetaObject *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QMetaObject *>(sipSrc);
}


extern "C" {static void *copy_QMetaObject(const void *, Py_ssize_t);}
static void *copy_QMetaObject(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QMetaObject(reinterpret_cast<const ::QMetaObject *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QMetaObject(sipSimpleWrapper *);}
static void dealloc_QMetaObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QMetaObject(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QMetaObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QMetaObject(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QMetaObject *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QMetaObject();

            return sipCpp;
        }
    }

    {
        const ::QMetaObject* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QMetaObject, &a0))
        {
            sipCpp = new ::QMetaObject(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QMetaObject[] = {
    {sipName_checkConnectArgs, meth_QMetaObject_checkConnectArgs, METH_VARARGS, doc_QMetaObject_checkConnectArgs},
    {sipName_classInfo, meth_QMetaObject_classInfo, METH_VARARGS, doc_QMetaObject_classInfo},
    {sipName_classInfoCount, meth_QMetaObject_classInfoCount, METH_VARARGS, doc_QMetaObject_classInfoCount},
    {sipName_classInfoOffset, meth_QMetaObject_classInfoOffset, METH_VARARGS, doc_QMetaObject_classInfoOffset},
    {sipName_className, meth_QMetaObject_className, METH_VARARGS, doc_QMetaObject_className},
    {sipName_connectSlotsByName, meth_QMetaObject_connectSlotsByName, METH_VARARGS, doc_QMetaObject_connectSlotsByName},
    {sipName_constructor, meth_QMetaObject_constructor, METH_VARARGS, doc_QMetaObject_constructor},
    {sipName_constructorCount, meth_QMetaObject_constructorCount, METH_VARARGS, doc_QMetaObject_constructorCount},
    {sipName_enumerator, meth_QMetaObject_enumerator, METH_VARARGS, doc_QMetaObject_enumerator},
    {sipName_enumeratorCount, meth_QMetaObject_enumeratorCount, METH_VARARGS, doc_QMetaObject_enumeratorCount},
    {sipName_enumeratorOffset, meth_QMetaObject_enumeratorOffset, METH_VARARGS, doc_QMetaObject_enumeratorOffset},
    {sipName_indexOfClassInfo, meth_QMetaObject_indexOfClassInfo, METH_VARARGS, doc_QMetaObject_indexOfClassInfo},
    {sipName_indexOfConstructor, meth_QMetaObject_indexOfConstructor, METH_VARARGS, doc_QMetaObject_indexOfConstructor},
    {sipName_indexOfEnumerator, meth_QMetaObject_indexOfEnumerator, METH_VARARGS, doc_QMetaObject_indexOfEnumerator},
    {sipName_indexOfMethod, meth_QMetaObject_indexOfMethod, METH_VARARGS, doc_QMetaObject_indexOfMethod},
    {sipName_indexOfProperty, meth_QMetaObject_indexOfProperty, METH_VARARGS, doc_QMetaObject_indexOfProperty},
    {sipName_indexOfSignal, meth_QMetaObject_indexOfSignal, METH_VARARGS, doc_QMetaObject_indexOfSignal},
    {sipName_indexOfSlot, meth_QMetaObject_indexOfSlot, METH_VARARGS, doc_QMetaObject_indexOfSlot},
    {sipName_inherits, meth_QMetaObject_inherits, METH_VARARGS, doc_QMetaObject_inherits},
    {sipName_invokeMethod, SIP_MLMETH_CAST(meth_QMetaObject_invokeMethod), METH_VARARGS|METH_KEYWORDS, doc_QMetaObject_invokeMethod},
    {sipName_method, meth_QMetaObject_method, METH_VARARGS, doc_QMetaObject_method},
    {sipName_methodCount, meth_QMetaObject_methodCount, METH_VARARGS, doc_QMetaObject_methodCount},
    {sipName_methodOffset, meth_QMetaObject_methodOffset, METH_VARARGS, doc_QMetaObject_methodOffset},
    {sipName_normalizedSignature, meth_QMetaObject_normalizedSignature, METH_VARARGS, doc_QMetaObject_normalizedSignature},
    {sipName_normalizedType, meth_QMetaObject_normalizedType, METH_VARARGS, doc_QMetaObject_normalizedType},
    {sipName_property, meth_QMetaObject_property, METH_VARARGS, doc_QMetaObject_property},
    {sipName_propertyCount, meth_QMetaObject_propertyCount, METH_VARARGS, doc_QMetaObject_propertyCount},
    {sipName_propertyOffset, meth_QMetaObject_propertyOffset, METH_VARARGS, doc_QMetaObject_propertyOffset},
    {sipName_superClass, meth_QMetaObject_superClass, METH_VARARGS, doc_QMetaObject_superClass},
    {sipName_userProperty, meth_QMetaObject_userProperty, METH_VARARGS, doc_QMetaObject_userProperty}
};

PyDoc_STRVAR(doc_QMetaObject, "\1QMetaObject()\n"
"QMetaObject(a0: QMetaObject)");


static pyqt5ClassPluginDef plugin_QMetaObject = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QMetaObject = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QMetaObject,
        SIP_NULLPTR,
        &plugin_QMetaObject,
    },
    {
        sipNameNr_QMetaObject,
        {0, 0, 1},
        30, methods_QMetaObject,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QMetaObject,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QMetaObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QMetaObject,
    assign_QMetaObject,
    array_QMetaObject,
    copy_QMetaObject,
    release_QMetaObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QMetaObject,
    sizeof (::QMetaObject),
};
