#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <brotli/decode.h>
       #include <brotli/encode.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // BrotliDecoderErrorCode()(BrotliDecoderState const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 68), // BrotliDecoderState const *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 67), // BrotliDecoderResult()(BrotliDecoderState *, size_t *, uint8_t const * *, size_t *, uint8_t * *, size_t *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 68), // BrotliDecoderState *
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 45), // size_t *
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 46), // uint8_t const * *
/*  7 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 48), // uint8_t * *
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // BrotliDecoderState *()(void *(*)(void *, size_t), void(*)(void *, void *), void *)
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // void *(*)(void *, size_t)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 63), // void(*)(void *, void *)
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 74), // void *
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // BrotliEncoderState *()(void *(*)(void *, size_t), void(*)(void *, void *), void *)
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // _Bool()(BrotliDecoderState const *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // _Bool()(BrotliEncoderState *)
/* 25 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // BrotliEncoderState *
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // _Bool()(BrotliEncoderState *, BrotliEncoderOperation, size_t *, uint8_t const * *, size_t *, uint8_t * *, size_t *)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 29 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // BrotliEncoderOperation
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // _Bool()(BrotliEncoderState *, BrotliEncoderParameter, uint32_t)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 38 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // BrotliEncoderParameter
/* 39 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // _Bool()(int, int, BrotliEncoderMode, size_t, uint8_t const *, size_t *, uint8_t *)
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 44 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // BrotliEncoderMode
/* 45 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 46 */ _CFFI_OP(_CFFI_OP_POINTER, 73), // uint8_t const *
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 73), // uint8_t *
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 71), // char const *()(BrotliDecoderErrorCode)
/* 51 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // BrotliDecoderErrorCode
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // void *()(void *, size_t)
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 74), // void()(BrotliDecoderState *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 74), // void()(BrotliEncoderState *)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 74), // void()(void *, void *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // BrotliDecoderResult
/* 68 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // BrotliDecoderState
/* 69 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // BrotliEncoderState
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 71 */ _CFFI_OP(_CFFI_OP_POINTER, 72), // char const *
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 73 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 74 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_BROTLI_DECODER_RESULT_ERROR(unsigned long long *o)
{
  int n = (BROTLI_DECODER_RESULT_ERROR) <= 0;
  *o = (unsigned long long)((BROTLI_DECODER_RESULT_ERROR) | 0);  /* check that BROTLI_DECODER_RESULT_ERROR is an integer */
  return n;
}

static int _cffi_const_BROTLI_DECODER_RESULT_SUCCESS(unsigned long long *o)
{
  int n = (BROTLI_DECODER_RESULT_SUCCESS) <= 0;
  *o = (unsigned long long)((BROTLI_DECODER_RESULT_SUCCESS) | 0);  /* check that BROTLI_DECODER_RESULT_SUCCESS is an integer */
  return n;
}

static int _cffi_const_BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT(unsigned long long *o)
{
  int n = (BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT) <= 0;
  *o = (unsigned long long)((BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT) | 0);  /* check that BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT is an integer */
  return n;
}

static int _cffi_const_BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT(unsigned long long *o)
{
  int n = (BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT) <= 0;
  *o = (unsigned long long)((BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT) | 0);  /* check that BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT is an integer */
  return n;
}

static int _cffi_const_BROTLI_MODE_GENERIC(unsigned long long *o)
{
  int n = (BROTLI_MODE_GENERIC) <= 0;
  *o = (unsigned long long)((BROTLI_MODE_GENERIC) | 0);  /* check that BROTLI_MODE_GENERIC is an integer */
  return n;
}

static int _cffi_const_BROTLI_MODE_TEXT(unsigned long long *o)
{
  int n = (BROTLI_MODE_TEXT) <= 0;
  *o = (unsigned long long)((BROTLI_MODE_TEXT) | 0);  /* check that BROTLI_MODE_TEXT is an integer */
  return n;
}

static int _cffi_const_BROTLI_MODE_FONT(unsigned long long *o)
{
  int n = (BROTLI_MODE_FONT) <= 0;
  *o = (unsigned long long)((BROTLI_MODE_FONT) | 0);  /* check that BROTLI_MODE_FONT is an integer */
  return n;
}

static int _cffi_const_BROTLI_OPERATION_PROCESS(unsigned long long *o)
{
  int n = (BROTLI_OPERATION_PROCESS) <= 0;
  *o = (unsigned long long)((BROTLI_OPERATION_PROCESS) | 0);  /* check that BROTLI_OPERATION_PROCESS is an integer */
  return n;
}

static int _cffi_const_BROTLI_OPERATION_FLUSH(unsigned long long *o)
{
  int n = (BROTLI_OPERATION_FLUSH) <= 0;
  *o = (unsigned long long)((BROTLI_OPERATION_FLUSH) | 0);  /* check that BROTLI_OPERATION_FLUSH is an integer */
  return n;
}

static int _cffi_const_BROTLI_OPERATION_FINISH(unsigned long long *o)
{
  int n = (BROTLI_OPERATION_FINISH) <= 0;
  *o = (unsigned long long)((BROTLI_OPERATION_FINISH) | 0);  /* check that BROTLI_OPERATION_FINISH is an integer */
  return n;
}

static int _cffi_const_BROTLI_PARAM_MODE(unsigned long long *o)
{
  int n = (BROTLI_PARAM_MODE) <= 0;
  *o = (unsigned long long)((BROTLI_PARAM_MODE) | 0);  /* check that BROTLI_PARAM_MODE is an integer */
  return n;
}

static int _cffi_const_BROTLI_PARAM_QUALITY(unsigned long long *o)
{
  int n = (BROTLI_PARAM_QUALITY) <= 0;
  *o = (unsigned long long)((BROTLI_PARAM_QUALITY) | 0);  /* check that BROTLI_PARAM_QUALITY is an integer */
  return n;
}

static int _cffi_const_BROTLI_PARAM_LGWIN(unsigned long long *o)
{
  int n = (BROTLI_PARAM_LGWIN) <= 0;
  *o = (unsigned long long)((BROTLI_PARAM_LGWIN) | 0);  /* check that BROTLI_PARAM_LGWIN is an integer */
  return n;
}

static int _cffi_const_BROTLI_PARAM_LGBLOCK(unsigned long long *o)
{
  int n = (BROTLI_PARAM_LGBLOCK) <= 0;
  *o = (unsigned long long)((BROTLI_PARAM_LGBLOCK) | 0);  /* check that BROTLI_PARAM_LGBLOCK is an integer */
  return n;
}

static BrotliDecoderState * _cffi_d_BrotliDecoderCreateInstance(void *(* x0)(void *, size_t), void(* x1)(void *, void *), void * x2)
{
  return BrotliDecoderCreateInstance(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderCreateInstance(PyObject *self, PyObject *args)
{
  void *(* x0)(void *, size_t);
  void(* x1)(void *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BrotliDecoderState * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "BrotliDecoderCreateInstance", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = (void *(*)(void *, size_t))_cffi_to_c_pointer(arg0, _cffi_type(12));
  if (x0 == (void *(*)(void *, size_t))NULL && PyErr_Occurred())
    return NULL;

  x1 = (void(*)(void *, void *))_cffi_to_c_pointer(arg1, _cffi_type(13));
  if (x1 == (void(*)(void *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderCreateInstance(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderCreateInstance _cffi_d_BrotliDecoderCreateInstance
#endif

static BrotliDecoderResult _cffi_d_BrotliDecoderDecompressStream(BrotliDecoderState * x0, size_t * x1, uint8_t const * * x2, size_t * x3, uint8_t * * x4, size_t * x5)
{
  return BrotliDecoderDecompressStream(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderDecompressStream(PyObject *self, PyObject *args)
{
  BrotliDecoderState * x0;
  size_t * x1;
  uint8_t const * * x2;
  size_t * x3;
  uint8_t * * x4;
  size_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BrotliDecoderResult result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "BrotliDecoderDecompressStream", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint8_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint8_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderDecompressStream(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(67));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderDecompressStream _cffi_d_BrotliDecoderDecompressStream
#endif

static void _cffi_d_BrotliDecoderDestroyInstance(BrotliDecoderState * x0)
{
  BrotliDecoderDestroyInstance(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderDestroyInstance(PyObject *self, PyObject *arg0)
{
  BrotliDecoderState * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BrotliDecoderDestroyInstance(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_BrotliDecoderDestroyInstance _cffi_d_BrotliDecoderDestroyInstance
#endif

static char const * _cffi_d_BrotliDecoderErrorString(BrotliDecoderErrorCode x0)
{
  return BrotliDecoderErrorString(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderErrorString(PyObject *self, PyObject *arg0)
{
  BrotliDecoderErrorCode x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(51), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderErrorString(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(71));
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderErrorString _cffi_d_BrotliDecoderErrorString
#endif

static BrotliDecoderErrorCode _cffi_d_BrotliDecoderGetErrorCode(BrotliDecoderState const * x0)
{
  return BrotliDecoderGetErrorCode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderGetErrorCode(PyObject *self, PyObject *arg0)
{
  BrotliDecoderState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BrotliDecoderErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderGetErrorCode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderGetErrorCode _cffi_d_BrotliDecoderGetErrorCode
#endif

static _Bool _cffi_d_BrotliDecoderHasMoreOutput(BrotliDecoderState const * x0)
{
  return BrotliDecoderHasMoreOutput(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderHasMoreOutput(PyObject *self, PyObject *arg0)
{
  BrotliDecoderState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderHasMoreOutput(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderHasMoreOutput _cffi_d_BrotliDecoderHasMoreOutput
#endif

static _Bool _cffi_d_BrotliDecoderIsFinished(BrotliDecoderState const * x0)
{
  return BrotliDecoderIsFinished(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderIsFinished(PyObject *self, PyObject *arg0)
{
  BrotliDecoderState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderIsFinished(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderIsFinished _cffi_d_BrotliDecoderIsFinished
#endif

static _Bool _cffi_d_BrotliDecoderIsUsed(BrotliDecoderState const * x0)
{
  return BrotliDecoderIsUsed(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliDecoderIsUsed(PyObject *self, PyObject *arg0)
{
  BrotliDecoderState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliDecoderState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliDecoderIsUsed(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliDecoderIsUsed _cffi_d_BrotliDecoderIsUsed
#endif

static _Bool _cffi_d_BrotliEncoderCompress(int x0, int x1, BrotliEncoderMode x2, size_t x3, uint8_t const * x4, size_t * x5, uint8_t * x6)
{
  return BrotliEncoderCompress(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderCompress(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  BrotliEncoderMode x2;
  size_t x3;
  uint8_t const * x4;
  size_t * x5;
  uint8_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "BrotliEncoderCompress", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(44), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderCompress(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderCompress _cffi_d_BrotliEncoderCompress
#endif

static _Bool _cffi_d_BrotliEncoderCompressStream(BrotliEncoderState * x0, BrotliEncoderOperation x1, size_t * x2, uint8_t const * * x3, size_t * x4, uint8_t * * x5, size_t * x6)
{
  return BrotliEncoderCompressStream(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderCompressStream(PyObject *self, PyObject *args)
{
  BrotliEncoderState * x0;
  BrotliEncoderOperation x1;
  size_t * x2;
  uint8_t const * * x3;
  size_t * x4;
  uint8_t * * x5;
  size_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "BrotliEncoderCompressStream", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliEncoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(29), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint8_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint8_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderCompressStream(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderCompressStream _cffi_d_BrotliEncoderCompressStream
#endif

static BrotliEncoderState * _cffi_d_BrotliEncoderCreateInstance(void *(* x0)(void *, size_t), void(* x1)(void *, void *), void * x2)
{
  return BrotliEncoderCreateInstance(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderCreateInstance(PyObject *self, PyObject *args)
{
  void *(* x0)(void *, size_t);
  void(* x1)(void *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BrotliEncoderState * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "BrotliEncoderCreateInstance", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = (void *(*)(void *, size_t))_cffi_to_c_pointer(arg0, _cffi_type(12));
  if (x0 == (void *(*)(void *, size_t))NULL && PyErr_Occurred())
    return NULL;

  x1 = (void(*)(void *, void *))_cffi_to_c_pointer(arg1, _cffi_type(13));
  if (x1 == (void(*)(void *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderCreateInstance(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(25));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderCreateInstance _cffi_d_BrotliEncoderCreateInstance
#endif

static void _cffi_d_BrotliEncoderDestroyInstance(BrotliEncoderState * x0)
{
  BrotliEncoderDestroyInstance(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderDestroyInstance(PyObject *self, PyObject *arg0)
{
  BrotliEncoderState * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliEncoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BrotliEncoderDestroyInstance(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_BrotliEncoderDestroyInstance _cffi_d_BrotliEncoderDestroyInstance
#endif

static _Bool _cffi_d_BrotliEncoderHasMoreOutput(BrotliEncoderState * x0)
{
  return BrotliEncoderHasMoreOutput(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderHasMoreOutput(PyObject *self, PyObject *arg0)
{
  BrotliEncoderState * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliEncoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderHasMoreOutput(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderHasMoreOutput _cffi_d_BrotliEncoderHasMoreOutput
#endif

static _Bool _cffi_d_BrotliEncoderIsFinished(BrotliEncoderState * x0)
{
  return BrotliEncoderIsFinished(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderIsFinished(PyObject *self, PyObject *arg0)
{
  BrotliEncoderState * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliEncoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderIsFinished(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderIsFinished _cffi_d_BrotliEncoderIsFinished
#endif

static _Bool _cffi_d_BrotliEncoderSetParameter(BrotliEncoderState * x0, BrotliEncoderParameter x1, uint32_t x2)
{
  return BrotliEncoderSetParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BrotliEncoderSetParameter(PyObject *self, PyObject *args)
{
  BrotliEncoderState * x0;
  BrotliEncoderParameter x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "BrotliEncoderSetParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BrotliEncoderState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(38), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BrotliEncoderSetParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BrotliEncoderSetParameter _cffi_d_BrotliEncoderSetParameter
#endif

static int _cffi_const_BROTLI_DEFAULT_MODE(unsigned long long *o)
{
  int n = (BROTLI_DEFAULT_MODE) <= 0;
  *o = (unsigned long long)((BROTLI_DEFAULT_MODE) | 0);  /* check that BROTLI_DEFAULT_MODE is an integer */
  return n;
}

static int _cffi_const_BROTLI_DEFAULT_QUALITY(unsigned long long *o)
{
  int n = (BROTLI_DEFAULT_QUALITY) <= 0;
  *o = (unsigned long long)((BROTLI_DEFAULT_QUALITY) | 0);  /* check that BROTLI_DEFAULT_QUALITY is an integer */
  if (!_cffi_check_int(*o, n, 11U))
    n |= 2;
  return n;
}

static int _cffi_const_BROTLI_DEFAULT_WINDOW(unsigned long long *o)
{
  int n = (BROTLI_DEFAULT_WINDOW) <= 0;
  *o = (unsigned long long)((BROTLI_DEFAULT_WINDOW) | 0);  /* check that BROTLI_DEFAULT_WINDOW is an integer */
  if (!_cffi_check_int(*o, n, 22U))
    n |= 2;
  return n;
}

static int _cffi_const_BROTLI_FALSE(unsigned long long *o)
{
  int n = (BROTLI_FALSE) <= 0;
  *o = (unsigned long long)((BROTLI_FALSE) | 0);  /* check that BROTLI_FALSE is an integer */
  return n;
}

static int _cffi_const_BROTLI_TRUE(unsigned long long *o)
{
  int n = (BROTLI_TRUE) <= 0;
  *o = (unsigned long long)((BROTLI_TRUE) | 0);  /* check that BROTLI_TRUE is an integer */
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "BROTLI_DECODER_RESULT_ERROR", (void *)_cffi_const_BROTLI_DECODER_RESULT_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT", (void *)_cffi_const_BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT", (void *)_cffi_const_BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_DECODER_RESULT_SUCCESS", (void *)_cffi_const_BROTLI_DECODER_RESULT_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_DEFAULT_MODE", (void *)_cffi_const_BROTLI_DEFAULT_MODE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BROTLI_DEFAULT_QUALITY", (void *)_cffi_const_BROTLI_DEFAULT_QUALITY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BROTLI_DEFAULT_WINDOW", (void *)_cffi_const_BROTLI_DEFAULT_WINDOW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BROTLI_FALSE", (void *)_cffi_const_BROTLI_FALSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BROTLI_MODE_FONT", (void *)_cffi_const_BROTLI_MODE_FONT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_MODE_GENERIC", (void *)_cffi_const_BROTLI_MODE_GENERIC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_MODE_TEXT", (void *)_cffi_const_BROTLI_MODE_TEXT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_OPERATION_FINISH", (void *)_cffi_const_BROTLI_OPERATION_FINISH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_OPERATION_FLUSH", (void *)_cffi_const_BROTLI_OPERATION_FLUSH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_OPERATION_PROCESS", (void *)_cffi_const_BROTLI_OPERATION_PROCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_PARAM_LGBLOCK", (void *)_cffi_const_BROTLI_PARAM_LGBLOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_PARAM_LGWIN", (void *)_cffi_const_BROTLI_PARAM_LGWIN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_PARAM_MODE", (void *)_cffi_const_BROTLI_PARAM_MODE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_PARAM_QUALITY", (void *)_cffi_const_BROTLI_PARAM_QUALITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BROTLI_TRUE", (void *)_cffi_const_BROTLI_TRUE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BrotliDecoderCreateInstance", (void *)_cffi_f_BrotliDecoderCreateInstance, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 11), (void *)_cffi_d_BrotliDecoderCreateInstance },
  { "BrotliDecoderDecompressStream", (void *)_cffi_f_BrotliDecoderDecompressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_BrotliDecoderDecompressStream },
  { "BrotliDecoderDestroyInstance", (void *)_cffi_f_BrotliDecoderDestroyInstance, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_BrotliDecoderDestroyInstance },
  { "BrotliDecoderErrorString", (void *)_cffi_f_BrotliDecoderErrorString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 50), (void *)_cffi_d_BrotliDecoderErrorString },
  { "BrotliDecoderGetErrorCode", (void *)_cffi_f_BrotliDecoderGetErrorCode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_BrotliDecoderGetErrorCode },
  { "BrotliDecoderHasMoreOutput", (void *)_cffi_f_BrotliDecoderHasMoreOutput, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 21), (void *)_cffi_d_BrotliDecoderHasMoreOutput },
  { "BrotliDecoderIsFinished", (void *)_cffi_f_BrotliDecoderIsFinished, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 21), (void *)_cffi_d_BrotliDecoderIsFinished },
  { "BrotliDecoderIsUsed", (void *)_cffi_f_BrotliDecoderIsUsed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 21), (void *)_cffi_d_BrotliDecoderIsUsed },
  { "BrotliEncoderCompress", (void *)_cffi_f_BrotliEncoderCompress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 41), (void *)_cffi_d_BrotliEncoderCompress },
  { "BrotliEncoderCompressStream", (void *)_cffi_f_BrotliEncoderCompressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_BrotliEncoderCompressStream },
  { "BrotliEncoderCreateInstance", (void *)_cffi_f_BrotliEncoderCreateInstance, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 16), (void *)_cffi_d_BrotliEncoderCreateInstance },
  { "BrotliEncoderDestroyInstance", (void *)_cffi_f_BrotliEncoderDestroyInstance, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_BrotliEncoderDestroyInstance },
  { "BrotliEncoderHasMoreOutput", (void *)_cffi_f_BrotliEncoderHasMoreOutput, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 24), (void *)_cffi_d_BrotliEncoderHasMoreOutput },
  { "BrotliEncoderIsFinished", (void *)_cffi_f_BrotliEncoderIsFinished, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 24), (void *)_cffi_d_BrotliEncoderIsFinished },
  { "BrotliEncoderSetParameter", (void *)_cffi_f_BrotliEncoderSetParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 36), (void *)_cffi_d_BrotliEncoderSetParameter },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$BrotliDecoderState", 68, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BrotliEncoderState", 69, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$BrotliDecoderErrorCode", 51, _cffi_prim_int(sizeof(BrotliDecoderErrorCode), ((BrotliDecoderErrorCode)-1) <= 0),
    "" },
  { "$BrotliDecoderResult", 67, _cffi_prim_int(sizeof(BrotliDecoderResult), ((BrotliDecoderResult)-1) <= 0),
    "BROTLI_DECODER_RESULT_ERROR,BROTLI_DECODER_RESULT_SUCCESS,BROTLI_DECODER_RESULT_NEEDS_MORE_INPUT,BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT" },
  { "BrotliEncoderMode", 44, _cffi_prim_int(sizeof(BrotliEncoderMode), ((BrotliEncoderMode)-1) <= 0),
    "BROTLI_MODE_GENERIC,BROTLI_MODE_TEXT,BROTLI_MODE_FONT" },
  { "BrotliEncoderOperation", 29, _cffi_prim_int(sizeof(BrotliEncoderOperation), ((BrotliEncoderOperation)-1) <= 0),
    "BROTLI_OPERATION_PROCESS,BROTLI_OPERATION_FLUSH,BROTLI_OPERATION_FINISH" },
  { "BrotliEncoderParameter", 38, _cffi_prim_int(sizeof(BrotliEncoderParameter), ((BrotliEncoderParameter)-1) <= 0),
    "BROTLI_PARAM_MODE,BROTLI_PARAM_QUALITY,BROTLI_PARAM_LGWIN,BROTLI_PARAM_LGBLOCK" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "BROTLI_BOOL", 70 },
  { "BrotliDecoderErrorCode", 51 },
  { "BrotliDecoderResult", 67 },
  { "BrotliDecoderState", 68 },
  { "BrotliEncoderMode", 44 },
  { "BrotliEncoderOperation", 29 },
  { "BrotliEncoderParameter", 38 },
  { "BrotliEncoderState", 69 },
  { "brotli_alloc_func", 12 },
  { "brotli_free_func", 13 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  34,  /* num_globals */
  2,  /* num_struct_unions */
  5,  /* num_enums */
  10,  /* num_typenames */
  NULL,  /* no includes */
  75,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__brotlicffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__brotlicffi(void) { return NULL; }
#  else
     init_brotlicffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__brotlicffi(void)
{
  return _cffi_init("_brotlicffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_brotlicffi(void)
{
  _cffi_init("_brotlicffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
