// media/mojo/mojom/audio_decoder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_decoder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
class SupportedAudioDecoderConfigDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SupportedAudioDecoderConfigDataView> {
  using Data = ::media::mojom::internal::SupportedAudioDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class AudioDecoderInterfaceBase {};

using AudioDecoderPtrDataView =
    mojo::InterfacePtrDataView<AudioDecoderInterfaceBase>;
using AudioDecoderRequestDataView =
    mojo::InterfaceRequestDataView<AudioDecoderInterfaceBase>;
using AudioDecoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioDecoderInterfaceBase>;
using AudioDecoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioDecoderInterfaceBase>;
class AudioDecoderClientInterfaceBase {};

using AudioDecoderClientPtrDataView =
    mojo::InterfacePtrDataView<AudioDecoderClientInterfaceBase>;
using AudioDecoderClientRequestDataView =
    mojo::InterfaceRequestDataView<AudioDecoderClientInterfaceBase>;
using AudioDecoderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioDecoderClientInterfaceBase>;
using AudioDecoderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioDecoderClientInterfaceBase>;


class SupportedAudioDecoderConfigDataView {
 public:
  SupportedAudioDecoderConfigDataView() = default;

  SupportedAudioDecoderConfigDataView(
      internal::SupportedAudioDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::mojom::AudioCodec>(
        data_value, output);
  }
  ::media::mojom::AudioCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodec>(data_->codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::AudioCodecProfile>(
        data_value, output);
  }
  ::media::mojom::AudioCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodecProfile>(data_->profile));
  }
 private:
  internal::SupportedAudioDecoderConfig_Data* data_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SupportedAudioDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SupportedAudioDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SupportedAudioDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::AudioCodec>(
        Traits::codec(input), &fragment->codec);
    mojo::internal::Serialize<::media::mojom::AudioCodecProfile>(
        Traits::profile(input), &fragment->profile);
  }

  static bool Deserialize(::media::mojom::internal::SupportedAudioDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SupportedAudioDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {




}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_SHARED_H_