// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* WebBluetoothResultToStringHelper(WebBluetoothResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebBluetoothResult::SUCCESS:
      return "SUCCESS";
    case WebBluetoothResult::WATCH_ADVERTISEMENTS_ABORTED:
      return "WATCH_ADVERTISEMENTS_ABORTED";
    case WebBluetoothResult::GATT_INVALID_ATTRIBUTE_LENGTH:
      return "GATT_INVALID_ATTRIBUTE_LENGTH";
    case WebBluetoothResult::CONNECT_INVALID_ARGS:
      return "CONNECT_INVALID_ARGS";
    case WebBluetoothResult::SERVICE_NO_LONGER_EXISTS:
      return "SERVICE_NO_LONGER_EXISTS";
    case WebBluetoothResult::CHARACTERISTIC_NO_LONGER_EXISTS:
      return "CHARACTERISTIC_NO_LONGER_EXISTS";
    case WebBluetoothResult::PROMPT_CANCELED:
      return "PROMPT_CANCELED";
    case WebBluetoothResult::CONNECT_DOES_NOT_EXIST:
      return "CONNECT_DOES_NOT_EXIST";
    case WebBluetoothResult::CONNECT_ALREADY_IN_PROGRESS:
      return "CONNECT_ALREADY_IN_PROGRESS";
    case WebBluetoothResult::CONNECT_AUTH_CANCELED:
      return "CONNECT_AUTH_CANCELED";
    case WebBluetoothResult::CONNECT_AUTH_FAILED:
      return "CONNECT_AUTH_FAILED";
    case WebBluetoothResult::CONNECT_AUTH_REJECTED:
      return "CONNECT_AUTH_REJECTED";
    case WebBluetoothResult::CONNECT_AUTH_TIMEOUT:
      return "CONNECT_AUTH_TIMEOUT";
    case WebBluetoothResult::CONNECT_UNKNOWN_ERROR:
      return "CONNECT_UNKNOWN_ERROR";
    case WebBluetoothResult::CONNECT_UNKNOWN_FAILURE:
      return "CONNECT_UNKNOWN_FAILURE";
    case WebBluetoothResult::CONNECT_UNSUPPORTED_DEVICE:
      return "CONNECT_UNSUPPORTED_DEVICE";
    case WebBluetoothResult::DEVICE_NO_LONGER_IN_RANGE:
      return "DEVICE_NO_LONGER_IN_RANGE";
    case WebBluetoothResult::GATT_NOT_PAIRED:
      return "GATT_NOT_PAIRED";
    case WebBluetoothResult::GATT_OPERATION_IN_PROGRESS:
      return "GATT_OPERATION_IN_PROGRESS";
    case WebBluetoothResult::CONNECT_CONN_FAILED:
      return "CONNECT_CONN_FAILED";
    case WebBluetoothResult::CONNECT_NOT_READY:
      return "CONNECT_NOT_READY";
    case WebBluetoothResult::CONNECT_ALREADY_CONNECTED:
      return "CONNECT_ALREADY_CONNECTED";
    case WebBluetoothResult::CONNECT_ALREADY_EXISTS:
      return "CONNECT_ALREADY_EXISTS";
    case WebBluetoothResult::CONNECT_NOT_CONNECTED:
      return "CONNECT_NOT_CONNECTED";
    case WebBluetoothResult::CONNECT_NON_AUTH_TIMEOUT:
      return "CONNECT_NON_AUTH_TIMEOUT";
    case WebBluetoothResult::CONNECT_NO_MEMORY:
      return "CONNECT_NO_MEMORY";
    case WebBluetoothResult::CONNECT_JNI_ENVIRONMENT:
      return "CONNECT_JNI_ENVIRONMENT";
    case WebBluetoothResult::CONNECT_JNI_THREAD_ATTACH:
      return "CONNECT_JNI_THREAD_ATTACH";
    case WebBluetoothResult::CONNECT_WAKELOCK:
      return "CONNECT_WAKELOCK";
    case WebBluetoothResult::CONNECT_UNEXPECTED_STATE:
      return "CONNECT_UNEXPECTED_STATE";
    case WebBluetoothResult::CONNECT_SOCKET_ERROR:
      return "CONNECT_SOCKET_ERROR";
    case WebBluetoothResult::NO_BLUETOOTH_ADAPTER:
      return "NO_BLUETOOTH_ADAPTER";
    case WebBluetoothResult::CHOSEN_DEVICE_VANISHED:
      return "CHOSEN_DEVICE_VANISHED";
    case WebBluetoothResult::CHOOSER_CANCELLED:
      return "CHOOSER_CANCELLED";
    case WebBluetoothResult::CHOOSER_NOT_SHOWN_API_GLOBALLY_DISABLED:
      return "CHOOSER_NOT_SHOWN_API_GLOBALLY_DISABLED";
    case WebBluetoothResult::CHOOSER_NOT_SHOWN_API_LOCALLY_DISABLED:
      return "CHOOSER_NOT_SHOWN_API_LOCALLY_DISABLED";
    case WebBluetoothResult::CHOOSER_NOT_SHOWN_USER_DENIED_PERMISSION_TO_SCAN:
      return "CHOOSER_NOT_SHOWN_USER_DENIED_PERMISSION_TO_SCAN";
    case WebBluetoothResult::SERVICE_NOT_FOUND:
      return "SERVICE_NOT_FOUND";
    case WebBluetoothResult::NO_SERVICES_FOUND:
      return "NO_SERVICES_FOUND";
    case WebBluetoothResult::CHARACTERISTIC_NOT_FOUND:
      return "CHARACTERISTIC_NOT_FOUND";
    case WebBluetoothResult::NO_CHARACTERISTICS_FOUND:
      return "NO_CHARACTERISTICS_FOUND";
    case WebBluetoothResult::DESCRIPTOR_NOT_FOUND:
      return "DESCRIPTOR_NOT_FOUND";
    case WebBluetoothResult::NO_DESCRIPTORS_FOUND:
      return "NO_DESCRIPTORS_FOUND";
    case WebBluetoothResult::WEB_BLUETOOTH_NOT_SUPPORTED:
      return "WEB_BLUETOOTH_NOT_SUPPORTED";
    case WebBluetoothResult::BLUETOOTH_LOW_ENERGY_NOT_AVAILABLE:
      return "BLUETOOTH_LOW_ENERGY_NOT_AVAILABLE";
    case WebBluetoothResult::GATT_UNKNOWN_ERROR:
      return "GATT_UNKNOWN_ERROR";
    case WebBluetoothResult::GATT_UNKNOWN_FAILURE:
      return "GATT_UNKNOWN_FAILURE";
    case WebBluetoothResult::GATT_NOT_PERMITTED:
      return "GATT_NOT_PERMITTED";
    case WebBluetoothResult::GATT_NOT_SUPPORTED:
      return "GATT_NOT_SUPPORTED";
    case WebBluetoothResult::GATT_UNTRANSLATED_ERROR_CODE:
      return "GATT_UNTRANSLATED_ERROR_CODE";
    case WebBluetoothResult::GATT_NOT_AUTHORIZED:
      return "GATT_NOT_AUTHORIZED";
    case WebBluetoothResult::BLOCKLISTED_DESCRIPTOR_UUID:
      return "BLOCKLISTED_DESCRIPTOR_UUID";
    case WebBluetoothResult::BLOCKLISTED_CHARACTERISTIC_UUID:
      return "BLOCKLISTED_CHARACTERISTIC_UUID";
    case WebBluetoothResult::BLOCKLISTED_READ:
      return "BLOCKLISTED_READ";
    case WebBluetoothResult::BLOCKLISTED_WRITE:
      return "BLOCKLISTED_WRITE";
    case WebBluetoothResult::NOT_ALLOWED_TO_ACCESS_ANY_SERVICE:
      return "NOT_ALLOWED_TO_ACCESS_ANY_SERVICE";
    case WebBluetoothResult::NOT_ALLOWED_TO_ACCESS_SERVICE:
      return "NOT_ALLOWED_TO_ACCESS_SERVICE";
    case WebBluetoothResult::REQUEST_DEVICE_WITH_BLOCKLISTED_UUID_OR_MANUFACTURER_DATA:
      return "REQUEST_DEVICE_WITH_BLOCKLISTED_UUID_OR_MANUFACTURER_DATA";
    case WebBluetoothResult::DESCRIPTOR_NO_LONGER_EXISTS:
      return "DESCRIPTOR_NO_LONGER_EXISTS";
    case WebBluetoothResult::PERMISSIONS_POLICY_VIOLATION:
      return "PERMISSIONS_POLICY_VIOLATION";
    case WebBluetoothResult::SCANNING_BLOCKED:
      return "SCANNING_BLOCKED";
    default:
      return nullptr;
  }
}

std::string WebBluetoothResultToString(WebBluetoothResult value) {
  const char *str = WebBluetoothResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebBluetoothResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebBluetoothResult value) {
  return os << WebBluetoothResultToString(value);
}

NOINLINE static const char* WebBluetoothGATTQueryQuantityToStringHelper(WebBluetoothGATTQueryQuantity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebBluetoothGATTQueryQuantity::SINGLE:
      return "SINGLE";
    case WebBluetoothGATTQueryQuantity::MULTIPLE:
      return "MULTIPLE";
    default:
      return nullptr;
  }
}

std::string WebBluetoothGATTQueryQuantityToString(WebBluetoothGATTQueryQuantity value) {
  const char *str = WebBluetoothGATTQueryQuantityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebBluetoothGATTQueryQuantity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebBluetoothGATTQueryQuantity value) {
  return os << WebBluetoothGATTQueryQuantityToString(value);
}

NOINLINE static const char* WebBluetoothWriteTypeToStringHelper(WebBluetoothWriteType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebBluetoothWriteType::kWriteDefaultDeprecated:
      return "kWriteDefaultDeprecated";
    case WebBluetoothWriteType::kWriteWithResponse:
      return "kWriteWithResponse";
    case WebBluetoothWriteType::kWriteWithoutResponse:
      return "kWriteWithoutResponse";
    default:
      return nullptr;
  }
}

std::string WebBluetoothWriteTypeToString(WebBluetoothWriteType value) {
  const char *str = WebBluetoothWriteTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebBluetoothWriteType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebBluetoothWriteType value) {
  return os << WebBluetoothWriteTypeToString(value);
}

namespace internal {


// static
bool WebBluetoothLeScanFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothLeScanFilter_Data* object =
      static_cast<const WebBluetoothLeScanFilter_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->services, validation_context,
                                         &services_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& name_prefix_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name_prefix, validation_context,
                                         &name_prefix_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->manufacturer_data, validation_context,
                                         &manufacturer_data_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothLeScanFilter_Data::WebBluetoothLeScanFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothCompany_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothCompany_Data* object =
      static_cast<const WebBluetoothCompany_Data*>(data);

  return true;
}

WebBluetoothCompany_Data::WebBluetoothCompany_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothDataFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothDataFilter_Data* object =
      static_cast<const WebBluetoothDataFilter_Data*>(data);

  return true;
}

WebBluetoothDataFilter_Data::WebBluetoothDataFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothRequestDeviceOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothRequestDeviceOptions_Data* object =
      static_cast<const WebBluetoothRequestDeviceOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filters, validation_context,
                                         &filters_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& exclusion_filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->exclusion_filters, validation_context,
                                         &exclusion_filters_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->optional_services, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& optional_services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->optional_services, validation_context,
                                         &optional_services_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->optional_manufacturer_data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& optional_manufacturer_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->optional_manufacturer_data, validation_context,
                                         &optional_manufacturer_data_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothRequestDeviceOptions_Data::WebBluetoothRequestDeviceOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothRequestLEScanOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothRequestLEScanOptions_Data* object =
      static_cast<const WebBluetoothRequestLEScanOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filters, validation_context,
                                         &filters_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothRequestLEScanOptions_Data::WebBluetoothRequestLEScanOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothDeviceId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothDeviceId_Data* object =
      static_cast<const WebBluetoothDeviceId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<16, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothDeviceId_Data::WebBluetoothDeviceId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothDevice_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothDevice_Data* object =
      static_cast<const WebBluetoothDevice_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothDevice_Data::WebBluetoothDevice_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothRemoteGATTService_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothRemoteGATTService_Data* object =
      static_cast<const WebBluetoothRemoteGATTService_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instance_id, validation_context,
                                         &instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

WebBluetoothRemoteGATTService_Data::WebBluetoothRemoteGATTService_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothRemoteGATTCharacteristic_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothRemoteGATTCharacteristic_Data* object =
      static_cast<const WebBluetoothRemoteGATTCharacteristic_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instance_id, validation_context,
                                         &instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

WebBluetoothRemoteGATTCharacteristic_Data::WebBluetoothRemoteGATTCharacteristic_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothAdvertisingEvent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothAdvertisingEvent_Data* object =
      static_cast<const WebBluetoothAdvertisingEvent_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuids, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->uuids, validation_context,
                                         &uuids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manufacturer_data, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->manufacturer_data, validation_context,
                                         &manufacturer_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_data, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->service_data, validation_context,
                                         &service_data_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothAdvertisingEvent_Data::WebBluetoothAdvertisingEvent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothRemoteGATTDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothRemoteGATTDescriptor_Data* object =
      static_cast<const WebBluetoothRemoteGATTDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instance_id, validation_context,
                                         &instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

WebBluetoothRemoteGATTDescriptor_Data::WebBluetoothRemoteGATTDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_GetAvailability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_GetAvailability_Params_Data* object =
      static_cast<const WebBluetoothService_GetAvailability_Params_Data*>(data);

  return true;
}

WebBluetoothService_GetAvailability_Params_Data::WebBluetoothService_GetAvailability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_GetAvailability_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_GetAvailability_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_GetAvailability_ResponseParams_Data*>(data);

  return true;
}

WebBluetoothService_GetAvailability_ResponseParams_Data::WebBluetoothService_GetAvailability_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RequestDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RequestDevice_Params_Data* object =
      static_cast<const WebBluetoothService_RequestDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebBluetoothService_RequestDevice_Params_Data::WebBluetoothService_RequestDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RequestDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RequestDevice_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RequestDevice_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->device, validation_context))
    return false;

  return true;
}

WebBluetoothService_RequestDevice_ResponseParams_Data::WebBluetoothService_RequestDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_GetDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_GetDevices_Params_Data* object =
      static_cast<const WebBluetoothService_GetDevices_Params_Data*>(data);

  return true;
}

WebBluetoothService_GetDevices_Params_Data::WebBluetoothService_GetDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_GetDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_GetDevices_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_GetDevices_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_GetDevices_ResponseParams_Data::WebBluetoothService_GetDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_ForgetDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_ForgetDevice_Params_Data* object =
      static_cast<const WebBluetoothService_ForgetDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

WebBluetoothService_ForgetDevice_Params_Data::WebBluetoothService_ForgetDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_ForgetDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_ForgetDevice_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_ForgetDevice_ResponseParams_Data*>(data);

  return true;
}

WebBluetoothService_ForgetDevice_ResponseParams_Data::WebBluetoothService_ForgetDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServerConnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServerConnect_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteServerConnect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteServerConnect_Params_Data::WebBluetoothService_RemoteServerConnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServerConnect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServerConnect_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteServerConnect_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteServerConnect_ResponseParams_Data::WebBluetoothService_RemoteServerConnect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServerDisconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServerDisconnect_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteServerDisconnect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteServerDisconnect_Params_Data::WebBluetoothService_RemoteServerDisconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;


  if (!::blink::mojom::internal::WebBluetoothGATTQueryQuantity_Data
        ::Validate(object->quantity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->services_uuid, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data::WebBluetoothService_RemoteServerGetPrimaryServices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->services, validation_context,
                                         &services_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data::WebBluetoothService_RemoteServerGetPrimaryServices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_instance_id, validation_context,
                                         &service_instance_id_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebBluetoothGATTQueryQuantity_Data
        ::Validate(object->quantity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->characteristics_uuid, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data::WebBluetoothService_RemoteServiceGetCharacteristics_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& characteristics_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristics, validation_context,
                                         &characteristics_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data::WebBluetoothService_RemoteServiceGetCharacteristics_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicReadValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicReadValue_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicReadValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_instance_id, validation_context,
                                         &characteristic_instance_id_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteCharacteristicReadValue_Params_Data::WebBluetoothService_RemoteCharacteristicReadValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data::WebBluetoothService_RemoteCharacteristicReadValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_instance_id, validation_context,
                                         &characteristic_instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;


  if (!::blink::mojom::internal::WebBluetoothWriteType_Data
        ::Validate(object->write_type, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data::WebBluetoothService_RemoteCharacteristicWriteValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data::WebBluetoothService_RemoteCharacteristicWriteValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_instance_id, validation_context,
                                         &characteristic_instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data::WebBluetoothService_RemoteCharacteristicStartNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data::WebBluetoothService_RemoteCharacteristicStartNotifications_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristic_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristic_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristic_instance_id, validation_context,
                                         &characteristic_instance_id_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data::WebBluetoothService_RemoteCharacteristicStopNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data*>(data);

  return true;
}

WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data::WebBluetoothService_RemoteCharacteristicStopNotifications_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->characteristics_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& characteristics_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->characteristics_instance_id, validation_context,
                                         &characteristics_instance_id_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::WebBluetoothGATTQueryQuantity_Data
        ::Validate(object->quantity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->descriptor_uuid, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data::WebBluetoothService_RemoteCharacteristicGetDescriptors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& descriptors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptors, validation_context,
                                         &descriptors_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data::WebBluetoothService_RemoteCharacteristicGetDescriptors_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteDescriptorReadValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteDescriptorReadValue_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteDescriptorReadValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_instance_id, validation_context,
                                         &descriptor_instance_id_validate_params)) {
    return false;
  }

  return true;
}

WebBluetoothService_RemoteDescriptorReadValue_Params_Data::WebBluetoothService_RemoteDescriptorReadValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data::WebBluetoothService_RemoteDescriptorReadValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteDescriptorWriteValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteDescriptorWriteValue_Params_Data* object =
      static_cast<const WebBluetoothService_RemoteDescriptorWriteValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor_instance_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& descriptor_instance_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->descriptor_instance_id, validation_context,
                                         &descriptor_instance_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteDescriptorWriteValue_Params_Data::WebBluetoothService_RemoteDescriptorWriteValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data::WebBluetoothService_RemoteDescriptorWriteValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RequestScanningStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RequestScanningStart_Params_Data* object =
      static_cast<const WebBluetoothService_RequestScanningStart_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebBluetoothService_RequestScanningStart_Params_Data::WebBluetoothService_RequestScanningStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_RequestScanningStart_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_RequestScanningStart_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_RequestScanningStart_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_RequestScanningStart_ResponseParams_Data::WebBluetoothService_RequestScanningStart_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_WatchAdvertisementsForDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_WatchAdvertisementsForDevice_Params_Data* object =
      static_cast<const WebBluetoothService_WatchAdvertisementsForDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBluetoothService_WatchAdvertisementsForDevice_Params_Data::WebBluetoothService_WatchAdvertisementsForDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data* object =
      static_cast<const WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebBluetoothResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data::WebBluetoothService_WatchAdvertisementsForDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothServerClient_GATTServerDisconnected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothServerClient_GATTServerDisconnected_Params_Data* object =
      static_cast<const WebBluetoothServerClient_GATTServerDisconnected_Params_Data*>(data);

  return true;
}

WebBluetoothServerClient_GATTServerDisconnected_Params_Data::WebBluetoothServerClient_GATTServerDisconnected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data* object =
      static_cast<const WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data::WebBluetoothCharacteristicClient_RemoteCharacteristicValueChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data* object =
      static_cast<const WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data::WebBluetoothAdvertisementClient_AdvertisingEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebBluetoothResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebBluetoothResult value) {
  return std::move(context).WriteString(::blink::mojom::WebBluetoothResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebBluetoothGATTQueryQuantity>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebBluetoothGATTQueryQuantity value) {
  return std::move(context).WriteString(::blink::mojom::WebBluetoothGATTQueryQuantityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebBluetoothWriteType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebBluetoothWriteType value) {
  return std::move(context).WriteString(::blink::mojom::WebBluetoothWriteTypeToString(value));
}

} // namespace perfetto