/* TimeLimitView.c generated by valac 0.56.17, the Vala compiler
 * generated from TimeLimitView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2015 Adam Bieńkowski
 */

#include "screentime-limits.h"
#include <act/act.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <granite-7.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX (pc_widgets_time_limit_view_week_spin_box_get_type ())
#define PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBox))
#define PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBoxClass))
#define PC_WIDGETS_TIME_LIMIT_VIEW_IS_WEEK_SPIN_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX))
#define PC_WIDGETS_TIME_LIMIT_VIEW_IS_WEEK_SPIN_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX))
#define PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBoxClass))

typedef struct _PCWidgetsTimeLimitViewWeekSpinBox PCWidgetsTimeLimitViewWeekSpinBox;
typedef struct _PCWidgetsTimeLimitViewWeekSpinBoxClass PCWidgetsTimeLimitViewWeekSpinBoxClass;
enum  {
	PC_WIDGETS_TIME_LIMIT_VIEW_0_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_time_limit_view_properties[PC_WIDGETS_TIME_LIMIT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pc_pam_time_info_unref0(var) ((var == NULL) ? NULL : (var = (pc_pam_time_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PCWidgetsTimeLimitViewWeekSpinBoxPrivate PCWidgetsTimeLimitViewWeekSpinBoxPrivate;
enum  {
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_0_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
enum  {
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_CHANGED_SIGNAL,
	PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_NUM_SIGNALS
};
static guint pc_widgets_time_limit_view_week_spin_box_signals[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_NUM_SIGNALS] = {0};

struct _PCWidgetsTimeLimitViewPrivate {
	ActUser* _user;
	PCWidgetsTimeLimitViewWeekSpinBox* weekday_box;
	PCWidgetsTimeLimitViewWeekSpinBox* weekend_box;
};

struct _PCWidgetsTimeLimitViewWeekSpinBox {
	GtkGrid parent_instance;
	PCWidgetsTimeLimitViewWeekSpinBoxPrivate * priv;
};

struct _PCWidgetsTimeLimitViewWeekSpinBoxClass {
	GtkGridClass parent_class;
};

struct _PCWidgetsTimeLimitViewWeekSpinBoxPrivate {
	gboolean _active;
	gchar* _title;
	gboolean _is_weekend;
	ActUser* _user;
	GraniteTimePicker* picker_from;
	GraniteTimePicker* picker_to;
};

struct _Block3Data {
	int _ref_count_;
	PCWidgetsTimeLimitViewWeekSpinBox* self;
	gchar* message_not_limited;
	gchar* message_limited;
	GraniteHeaderLabel* label;
};

static gint PCWidgetsTimeLimitView_private_offset;
static gpointer pc_widgets_time_limit_view_parent_class = NULL;
static gint PCWidgetsTimeLimitViewWeekSpinBox_private_offset;
static gpointer pc_widgets_time_limit_view_week_spin_box_parent_class = NULL;

static GType pc_widgets_time_limit_view_week_spin_box_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void pc_widgets_time_limit_view_load_restrictions (PCWidgetsTimeLimitView* self);
static void pc_widgets_time_limit_view_week_spin_box_set_active (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                          gboolean value);
static void pc_widgets_time_limit_view_week_spin_box_set_from (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                        const gchar* from);
static void pc_widgets_time_limit_view_week_spin_box_set_to (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                      const gchar* to);
static void _pc_pam_time_info_unref0_ (gpointer var);
static inline void _g_list_free__pc_pam_time_info_unref0_ (GList* self);
static gboolean pc_widgets_time_limit_view_week_spin_box_get_active (PCWidgetsTimeLimitViewWeekSpinBox* self);
static gchar* pc_widgets_time_limit_view_week_spin_box_get_from (PCWidgetsTimeLimitViewWeekSpinBox* self);
static gchar* pc_widgets_time_limit_view_week_spin_box_get_to (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static PCWidgetsTimeLimitViewWeekSpinBox* pc_widgets_time_limit_view_week_spin_box_new (const gchar* title,
                                                                                 gboolean is_weekend,
                                                                                 ActUser* user);
static PCWidgetsTimeLimitViewWeekSpinBox* pc_widgets_time_limit_view_week_spin_box_construct (GType object_type,
                                                                                       const gchar* title,
                                                                                       gboolean is_weekend,
                                                                                       ActUser* user);
static gchar* pc_widgets_time_limit_view_week_spin_box_format_time_string (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                                    gint val);
static const gchar* pc_widgets_time_limit_view_week_spin_box_get_title (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void pc_widgets_time_limit_view_week_spin_box_set_title (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                         const gchar* value);
static gboolean pc_widgets_time_limit_view_week_spin_box_get_is_weekend (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void pc_widgets_time_limit_view_week_spin_box_set_is_weekend (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                              gboolean value);
static ActUser* pc_widgets_time_limit_view_week_spin_box_get_user (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void pc_widgets_time_limit_view_week_spin_box_set_user (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                        ActUser* value);
static GObject * pc_widgets_time_limit_view_week_spin_box_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _pc_widgets_time_limit_view_week_spin_box___lambda4_ (Block3Data* _data3_);
static void __pc_widgets_time_limit_view_week_spin_box___lambda4__g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void _pc_widgets_time_limit_view_week_spin_box___lambda5_ (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void __pc_widgets_time_limit_view_week_spin_box___lambda5__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                             gpointer self);
static void _pc_widgets_time_limit_view_week_spin_box___lambda6_ (PCWidgetsTimeLimitViewWeekSpinBox* self);
static void __pc_widgets_time_limit_view_week_spin_box___lambda6__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                             gpointer self);
static void pc_widgets_time_limit_view_week_spin_box_finalize (GObject * obj);
static GType pc_widgets_time_limit_view_week_spin_box_get_type_once (void);
static void _vala_pc_widgets_time_limit_view_week_spin_box_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_pc_widgets_time_limit_view_week_spin_box_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static GObject * pc_widgets_time_limit_view_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _pc_widgets_time_limit_view___lambda7_ (PCWidgetsTimeLimitView* self);
static void __pc_widgets_time_limit_view___lambda7__pc_widgets_time_limit_view_week_spin_box_changed (PCWidgetsTimeLimitViewWeekSpinBox* _sender,
                                                                                               gpointer self);
static void _pc_widgets_time_limit_view___lambda8_ (PCWidgetsTimeLimitView* self);
static void __pc_widgets_time_limit_view___lambda8__pc_widgets_time_limit_view_week_spin_box_changed (PCWidgetsTimeLimitViewWeekSpinBox* _sender,
                                                                                               gpointer self);
static void _pc_widgets_time_limit_view___lambda9_ (PCWidgetsTimeLimitView* self);
static void __pc_widgets_time_limit_view___lambda9__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _pc_widgets_time_limit_view___lambda10_ (PCWidgetsTimeLimitView* self);
static void __pc_widgets_time_limit_view___lambda10__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void pc_widgets_time_limit_view_finalize (GObject * obj);
static GType pc_widgets_time_limit_view_get_type_once (void);
static void _vala_pc_widgets_time_limit_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_pc_widgets_time_limit_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pc_widgets_time_limit_view_get_instance_private (PCWidgetsTimeLimitView* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsTimeLimitView_private_offset);
}

PCWidgetsTimeLimitView*
pc_widgets_time_limit_view_construct (GType object_type,
                                      ActUser* user)
{
	PCWidgetsTimeLimitView * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (PCWidgetsTimeLimitView*) g_object_new (object_type, "user", user, NULL);
	return self;
}

PCWidgetsTimeLimitView*
pc_widgets_time_limit_view_new (ActUser* user)
{
	return pc_widgets_time_limit_view_construct (PC_WIDGETS_TYPE_TIME_LIMIT_VIEW, user);
}

static gpointer
_pc_pam_time_info_ref0 (gpointer self)
{
	return self ? pc_pam_time_info_ref (self) : NULL;
}

static void
_pc_pam_time_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (pc_pam_time_info_unref (var), NULL));
}

static inline void
_g_list_free__pc_pam_time_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _pc_pam_time_info_unref0_);
}

static void
pc_widgets_time_limit_view_load_restrictions (PCWidgetsTimeLimitView* self)
{
	PCPAMToken* token = NULL;
	ActUser* _tmp0_;
	const gchar* _tmp1_;
	PCPAMToken* _tmp2_;
	PCPAMToken* _tmp3_;
	PCPAMToken* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = act_user_get_user_name (_tmp0_);
	_tmp2_ = pc_pam_reader_get_token_for_user (PC_CONSTANTS_PAM_TIME_CONF_PATH, _tmp1_);
	token = _tmp2_;
	_tmp3_ = token;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (token);
		return;
	}
	_tmp4_ = token;
	_tmp5_ = pc_pam_token_get_times_info (_tmp4_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp5_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PCPAMTimeInfo* _tmp6_;
			PCPAMTimeInfo* info = NULL;
			_tmp6_ = _pc_pam_time_info_ref0 ((PCPAMTimeInfo*) info_it->data);
			info = _tmp6_;
			{
				PCPAMTimeInfo* _tmp7_;
				_tmp7_ = info;
				switch (_tmp7_->day_type) {
					case PC_PAM_DAY_TYPE_WEEKDAY:
					{
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp8_;
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp9_;
						PCPAMTimeInfo* _tmp10_;
						const gchar* _tmp11_;
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp12_;
						PCPAMTimeInfo* _tmp13_;
						const gchar* _tmp14_;
						_tmp8_ = self->priv->weekday_box;
						pc_widgets_time_limit_view_week_spin_box_set_active (_tmp8_, TRUE);
						_tmp9_ = self->priv->weekday_box;
						_tmp10_ = info;
						_tmp11_ = _tmp10_->from;
						pc_widgets_time_limit_view_week_spin_box_set_from (_tmp9_, _tmp11_);
						_tmp12_ = self->priv->weekday_box;
						_tmp13_ = info;
						_tmp14_ = _tmp13_->to;
						pc_widgets_time_limit_view_week_spin_box_set_to (_tmp12_, _tmp14_);
						break;
					}
					case PC_PAM_DAY_TYPE_WEEKEND:
					{
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp15_;
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp16_;
						PCPAMTimeInfo* _tmp17_;
						const gchar* _tmp18_;
						PCWidgetsTimeLimitViewWeekSpinBox* _tmp19_;
						PCPAMTimeInfo* _tmp20_;
						const gchar* _tmp21_;
						_tmp15_ = self->priv->weekend_box;
						pc_widgets_time_limit_view_week_spin_box_set_active (_tmp15_, TRUE);
						_tmp16_ = self->priv->weekend_box;
						_tmp17_ = info;
						_tmp18_ = _tmp17_->from;
						pc_widgets_time_limit_view_week_spin_box_set_from (_tmp16_, _tmp18_);
						_tmp19_ = self->priv->weekend_box;
						_tmp20_ = info;
						_tmp21_ = _tmp20_->to;
						pc_widgets_time_limit_view_week_spin_box_set_to (_tmp19_, _tmp21_);
						break;
					}
					default:
					{
						break;
					}
				}
				_pc_pam_time_info_unref0 (info);
			}
		}
		(info_collection == NULL) ? NULL : (info_collection = (_g_list_free__pc_pam_time_info_unref0_ (info_collection), NULL));
	}
	_g_object_unref0 (token);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
pc_widgets_time_limit_view_update_pam (PCWidgetsTimeLimitView* self,
                                       gboolean daemon_active)
{
	PolkitPermission* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_utils_get_permission ();
	if (!g_permission_get_allowed ((GPermission*) _tmp0_)) {
		return;
	}
	_tmp3_ = self->priv->weekday_box;
	_tmp4_ = pc_widgets_time_limit_view_week_spin_box_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = TRUE;
	} else {
		PCWidgetsTimeLimitViewWeekSpinBox* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->weekend_box;
		_tmp7_ = pc_widgets_time_limit_view_week_spin_box_get_active (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	}
	if (_tmp2_) {
		_tmp1_ = daemon_active;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** times = NULL;
		gchar** _tmp9_;
		gint times_length1;
		gint _times_size_;
		gchar** users = NULL;
		ActUser* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gint users_length1;
		gint _users_size_;
		PCWidgetsTimeLimitViewWeekSpinBox* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		PCWidgetsTimeLimitViewWeekSpinBox* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		gchar* input = NULL;
		gchar** _tmp46_;
		gint _tmp46__length1;
		gchar** _tmp47_;
		gint _tmp47__length1;
		gchar* _tmp48_;
		PCIParentalControls* _tmp49_;
		const gchar* _tmp50_;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		times = _tmp9_;
		times_length1 = 0;
		_times_size_ = times_length1;
		_tmp10_ = self->priv->_user;
		_tmp11_ = act_user_get_user_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		users = _tmp13_;
		users_length1 = 1;
		_users_size_ = users_length1;
		_tmp14_ = self->priv->weekday_box;
		_tmp15_ = pc_widgets_time_limit_view_week_spin_box_get_active (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			PCWidgetsTimeLimitViewWeekSpinBox* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			PCWidgetsTimeLimitViewWeekSpinBox* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp17_ = pc_pam_day_type_to_string (PC_PAM_DAY_TYPE_WEEKDAY);
			_tmp18_ = _tmp17_;
			_tmp19_ = self->priv->weekday_box;
			_tmp20_ = pc_widgets_time_limit_view_week_spin_box_get_from (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (_tmp23_, "-", NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->weekday_box;
			_tmp27_ = pc_widgets_time_limit_view_week_spin_box_get_to (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
			_vala_array_add2 (&times, &times_length1, &_times_size_, _tmp29_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp18_);
		}
		_tmp30_ = self->priv->weekend_box;
		_tmp31_ = pc_widgets_time_limit_view_week_spin_box_get_active (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_) {
			gchar* _tmp33_;
			gchar* _tmp34_;
			PCWidgetsTimeLimitViewWeekSpinBox* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			PCWidgetsTimeLimitViewWeekSpinBox* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp33_ = pc_pam_day_type_to_string (PC_PAM_DAY_TYPE_WEEKEND);
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->weekend_box;
			_tmp36_ = pc_widgets_time_limit_view_week_spin_box_get_from (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "-", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = self->priv->weekend_box;
			_tmp43_ = pc_widgets_time_limit_view_week_spin_box_get_to (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp41_, _tmp44_, NULL);
			_vala_array_add3 (&times, &times_length1, &_times_size_, _tmp45_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp34_);
		}
		_tmp46_ = users;
		_tmp46__length1 = users_length1;
		_tmp47_ = times;
		_tmp47__length1 = times_length1;
		_tmp48_ = pc_pam_token_construct_pam_restriction_simple (_tmp46_, (gint) _tmp46__length1, _tmp47_, (gint) _tmp47__length1);
		input = _tmp48_;
		_tmp49_ = pc_utils_get_api ();
		_tmp50_ = input;
		pc_iparental_controls_add_restriction_for_user (_tmp49_, _tmp50_, TRUE, NULL, NULL);
		_g_free0 (input);
		users = (_vala_array_free (users, users_length1, (GDestroyNotify) g_free), NULL);
		times = (_vala_array_free (times, times_length1, (GDestroyNotify) g_free), NULL);
	} else {
		PCIParentalControls* _tmp51_;
		ActUser* _tmp52_;
		const gchar* _tmp53_;
		_tmp51_ = pc_utils_get_api ();
		_tmp52_ = self->priv->_user;
		_tmp53_ = act_user_get_user_name (_tmp52_);
		pc_iparental_controls_remove_restriction_for_user (_tmp51_, _tmp53_, NULL, NULL);
	}
}

ActUser*
pc_widgets_time_limit_view_get_user (PCWidgetsTimeLimitView* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_time_limit_view_set_user (PCWidgetsTimeLimitView* self,
                                     ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_time_limit_view_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_time_limit_view_properties[PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY]);
	}
}

static inline gpointer
pc_widgets_time_limit_view_week_spin_box_get_instance_private (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsTimeLimitViewWeekSpinBox_private_offset);
}

static PCWidgetsTimeLimitViewWeekSpinBox*
pc_widgets_time_limit_view_week_spin_box_construct (GType object_type,
                                                    const gchar* title,
                                                    gboolean is_weekend,
                                                    ActUser* user)
{
	PCWidgetsTimeLimitViewWeekSpinBox * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (user != NULL, NULL);
	self = (PCWidgetsTimeLimitViewWeekSpinBox*) g_object_new (object_type, "title", title, "is-weekend", is_weekend, "user", user, NULL);
	return self;
}

static PCWidgetsTimeLimitViewWeekSpinBox*
pc_widgets_time_limit_view_week_spin_box_new (const gchar* title,
                                              gboolean is_weekend,
                                              ActUser* user)
{
	return pc_widgets_time_limit_view_week_spin_box_construct (PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, title, is_weekend, user);
}

static gchar*
pc_widgets_time_limit_view_week_spin_box_get_from (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	GraniteTimePicker* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GraniteTimePicker* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->picker_from;
	_tmp1_ = granite_time_picker_get_time (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pc_widgets_time_limit_view_week_spin_box_format_time_string (self, g_date_time_get_hour (_tmp2_));
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->picker_from;
	_tmp6_ = granite_time_picker_get_time (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = pc_widgets_time_limit_view_week_spin_box_format_time_string (self, g_date_time_get_minute (_tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp4_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	result = _tmp11_;
	return result;
}

static gchar*
pc_widgets_time_limit_view_week_spin_box_get_to (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	GraniteTimePicker* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GraniteTimePicker* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->picker_to;
	_tmp1_ = granite_time_picker_get_time (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pc_widgets_time_limit_view_week_spin_box_format_time_string (self, g_date_time_get_hour (_tmp2_));
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->picker_to;
	_tmp6_ = granite_time_picker_get_time (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = pc_widgets_time_limit_view_week_spin_box_format_time_string (self, g_date_time_get_minute (_tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp4_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	result = _tmp11_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
pc_widgets_time_limit_view_week_spin_box_set_from (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                   const gchar* from)
{
	gchar* hours = NULL;
	gchar* _tmp0_;
	gchar* minutes = NULL;
	gchar* _tmp1_;
	GDateTime* time = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GraniteTimePicker* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	_tmp0_ = string_slice (from, (glong) 0, (glong) 2);
	hours = _tmp0_;
	_tmp1_ = string_substring (from, (glong) 2, (glong) -1);
	minutes = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_new_local (g_date_time_get_year (_tmp3_), 1, 1, atoi (hours), atoi (minutes), (gdouble) 0);
	_tmp5_ = _tmp4_;
	_g_date_time_unref0 (_tmp3_);
	time = _tmp5_;
	_tmp6_ = self->priv->picker_from;
	granite_time_picker_set_time (_tmp6_, time);
	_g_date_time_unref0 (time);
	_g_free0 (minutes);
	_g_free0 (hours);
}

static void
pc_widgets_time_limit_view_week_spin_box_set_to (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                 const gchar* to)
{
	gchar* hours = NULL;
	gchar* _tmp0_;
	gchar* minutes = NULL;
	gchar* _tmp1_;
	GDateTime* time = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GraniteTimePicker* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = string_slice (to, (glong) 0, (glong) 2);
	hours = _tmp0_;
	_tmp1_ = string_substring (to, (glong) 2, (glong) -1);
	minutes = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_new_local (g_date_time_get_year (_tmp3_), 1, 1, atoi (hours), atoi (minutes), (gdouble) 0);
	_tmp5_ = _tmp4_;
	_g_date_time_unref0 (_tmp3_);
	time = _tmp5_;
	_tmp6_ = self->priv->picker_to;
	granite_time_picker_set_time (_tmp6_, time);
	_g_date_time_unref0 (time);
	_g_free0 (minutes);
	_g_free0 (hours);
}

static gchar*
pc_widgets_time_limit_view_week_spin_box_format_time_string (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                             gint val)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (val < 10) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_strdup_printf ("%i", val);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat ("0", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup_printf ("%i", val);
	result = _tmp4_;
	return result;
}

static gboolean
pc_widgets_time_limit_view_week_spin_box_get_active (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

static void
pc_widgets_time_limit_view_week_spin_box_set_active (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_time_limit_view_week_spin_box_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY]);
	}
}

static const gchar*
pc_widgets_time_limit_view_week_spin_box_get_title (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_time_limit_view_week_spin_box_set_title (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_time_limit_view_week_spin_box_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY]);
	}
}

static gboolean
pc_widgets_time_limit_view_week_spin_box_get_is_weekend (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_weekend;
	return result;
}

static void
pc_widgets_time_limit_view_week_spin_box_set_is_weekend (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_time_limit_view_week_spin_box_get_is_weekend (self);
	if (old_value != value) {
		self->priv->_is_weekend = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY]);
	}
}

static ActUser*
pc_widgets_time_limit_view_week_spin_box_get_user (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_time_limit_view_week_spin_box_set_user (PCWidgetsTimeLimitViewWeekSpinBox* self,
                                                   ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_time_limit_view_week_spin_box_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY]);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PCWidgetsTimeLimitViewWeekSpinBox* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->label);
		_g_free0 (_data3_->message_limited);
		_g_free0 (_data3_->message_not_limited);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_pc_widgets_time_limit_view_week_spin_box___lambda4_ (Block3Data* _data3_)
{
	PCWidgetsTimeLimitViewWeekSpinBox* self;
	gboolean _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->_active;
	if (_tmp0_) {
		GraniteHeaderLabel* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = _data3_->label;
		_tmp2_ = _data3_->message_limited;
		granite_header_label_set_secondary_text (_tmp1_, _tmp2_);
	} else {
		GraniteHeaderLabel* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = _data3_->label;
		_tmp4_ = _data3_->message_not_limited;
		granite_header_label_set_secondary_text (_tmp3_, _tmp4_);
	}
}

static void
__pc_widgets_time_limit_view_week_spin_box___lambda4__g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	_pc_widgets_time_limit_view_week_spin_box___lambda4_ (self);
}

static void
_pc_widgets_time_limit_view_week_spin_box___lambda5_ (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	g_signal_emit (self, pc_widgets_time_limit_view_week_spin_box_signals[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_CHANGED_SIGNAL], 0);
}

static void
__pc_widgets_time_limit_view_week_spin_box___lambda5__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                        gpointer self)
{
	_pc_widgets_time_limit_view_week_spin_box___lambda5_ ((PCWidgetsTimeLimitViewWeekSpinBox*) self);
}

static void
_pc_widgets_time_limit_view_week_spin_box___lambda6_ (PCWidgetsTimeLimitViewWeekSpinBox* self)
{
	g_signal_emit (self, pc_widgets_time_limit_view_week_spin_box_signals[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_CHANGED_SIGNAL], 0);
}

static void
__pc_widgets_time_limit_view_week_spin_box___lambda6__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                        gpointer self)
{
	_pc_widgets_time_limit_view_week_spin_box___lambda6_ ((PCWidgetsTimeLimitViewWeekSpinBox*) self);
}

static GObject *
pc_widgets_time_limit_view_week_spin_box_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsTimeLimitViewWeekSpinBox * self;
	Block3Data* _data3_;
	GtkSwitch* enable_switch = NULL;
	GtkSwitch* _tmp0_ = NULL;
	GDateTime* today_local = NULL;
	GDateTime* _tmp1_;
	GDateTime* today_start = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* today_end = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GraniteTimePicker* _tmp12_ = NULL;
	GtkLabel* from_label = NULL;
	GraniteTimePicker* _tmp13_;
	GtkWidget* _tmp14_;
	GtkLabel* _tmp15_ = NULL;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	GraniteTimePicker* _tmp18_ = NULL;
	GtkLabel* to_label = NULL;
	GraniteTimePicker* _tmp19_;
	GtkWidget* _tmp20_;
	GtkLabel* _tmp21_ = NULL;
	gboolean _tmp22_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GtkSwitch* _tmp34_;
	GtkWidget* _tmp35_;
	GraniteHeaderLabel* _tmp36_ = NULL;
	GtkBox* duration_box = NULL;
	GtkBox* _tmp37_ = NULL;
	GtkBox* _tmp38_;
	GtkLabel* _tmp39_;
	GtkBox* _tmp40_;
	GraniteTimePicker* _tmp41_;
	GtkBox* _tmp42_;
	GtkLabel* _tmp43_;
	GtkBox* _tmp44_;
	GraniteTimePicker* _tmp45_;
	GraniteHeaderLabel* _tmp46_;
	GtkSwitch* _tmp47_;
	GtkBox* _tmp48_;
	GtkSwitch* _tmp49_;
	GtkLabel* _tmp50_;
	GraniteTimePicker* _tmp51_;
	GtkLabel* _tmp52_;
	GraniteTimePicker* _tmp53_;
	GraniteTimePicker* _tmp54_;
	GraniteTimePicker* _tmp55_;
	parent_class = G_OBJECT_CLASS (pc_widgets_time_limit_view_week_spin_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBox);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	enable_switch = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	today_local = _tmp1_;
	_tmp2_ = today_local;
	_tmp3_ = today_local;
	_tmp4_ = today_local;
	_tmp5_ = g_date_time_new_local (g_date_time_get_year (_tmp2_), g_date_time_get_month (_tmp3_), g_date_time_get_day_of_month (_tmp4_), 0, 0, (gdouble) 0);
	today_start = _tmp5_;
	_tmp6_ = today_local;
	_tmp7_ = today_local;
	_tmp8_ = today_local;
	_tmp9_ = g_date_time_new_local (g_date_time_get_year (_tmp6_), g_date_time_get_month (_tmp7_), g_date_time_get_day_of_month (_tmp8_), 23, 59, (gdouble) 59);
	today_end = _tmp9_;
	_tmp10_ = today_start;
	_tmp11_ = _g_date_time_ref0 (_tmp10_);
	_tmp12_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp12_, 6);
	granite_time_picker_set_time (_tmp12_, _tmp11_);
	_g_date_time_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->picker_from);
	self->priv->picker_from = _tmp12_;
	_tmp13_ = self->priv->picker_from;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	gtk_label_set_mnemonic_widget (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	from_label = _tmp15_;
	_tmp16_ = today_end;
	_tmp17_ = _g_date_time_ref0 (_tmp16_);
	_tmp18_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp18_, TRUE);
	granite_time_picker_set_time (_tmp18_, _tmp17_);
	_g_date_time_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->picker_to);
	self->priv->picker_to = _tmp18_;
	_tmp19_ = self->priv->picker_to;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	gtk_label_set_mnemonic_widget (_tmp21_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	g_object_ref_sink (_tmp21_);
	to_label = _tmp21_;
	_tmp22_ = self->priv->_is_weekend;
	if (_tmp22_) {
		gchar* _tmp23_;
		ActUser* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp23_ = g_strdup (_ ("Screen Time is not limited on weekends."));
		_g_free0 (_data3_->message_not_limited);
		_data3_->message_not_limited = _tmp23_;
		_tmp24_ = self->priv->_user;
		_tmp25_ = act_user_get_real_name (_tmp24_);
		_tmp26_ = g_strdup_printf (_ ("%s will only be able to log in during this time on weekends, and will " \
"be automatically logged out once this period ends:"), _tmp25_);
		_g_free0 (_data3_->message_limited);
		_data3_->message_limited = _tmp26_;
	} else {
		gchar* _tmp27_;
		ActUser* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = g_strdup (_ ("Screen Time is not limited on weekdays."));
		_g_free0 (_data3_->message_not_limited);
		_data3_->message_not_limited = _tmp27_;
		_tmp28_ = self->priv->_user;
		_tmp29_ = act_user_get_real_name (_tmp28_);
		_tmp30_ = g_strdup_printf (_ ("%s will only be able to log in during this time on weekdays, and will " \
"be automatically logged out once this period ends:"), _tmp29_);
		_g_free0 (_data3_->message_limited);
		_data3_->message_limited = _tmp30_;
	}
	_tmp31_ = self->priv->_title;
	_tmp32_ = _data3_->message_not_limited;
	_tmp33_ = g_strdup (_tmp32_);
	_tmp34_ = enable_switch;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = granite_header_label_new (_tmp31_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp36_, TRUE);
	granite_header_label_set_secondary_text (_tmp36_, _tmp33_);
	_g_free0 (_tmp33_);
	granite_header_label_set_mnemonic_widget (_tmp36_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	_data3_->label = _tmp36_;
	_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 12);
	g_object_ref_sink (_tmp37_);
	duration_box = _tmp37_;
	_tmp38_ = duration_box;
	_tmp39_ = from_label;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = duration_box;
	_tmp41_ = self->priv->picker_from;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = duration_box;
	_tmp43_ = to_label;
	gtk_box_append (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = duration_box;
	_tmp45_ = self->priv->picker_to;
	gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp46_ = _data3_->label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp46_, 0, 0, 1, 1);
	_tmp47_ = enable_switch;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp47_, 1, 0, 1, 1);
	_tmp48_ = duration_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp48_, 0, 2, 2, 1);
	_tmp49_ = enable_switch;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp49_, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp50_ = from_label;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp50_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp51_ = self->priv->picker_from;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp51_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp52_ = to_label;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp52_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp53_ = self->priv->picker_to;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp53_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) self, "notify::active", (GCallback) __pc_widgets_time_limit_view_week_spin_box___lambda4__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp54_ = self->priv->picker_from;
	g_signal_connect_object (_tmp54_, "time-changed", (GCallback) __pc_widgets_time_limit_view_week_spin_box___lambda5__granite_time_picker_time_changed, self, 0);
	_tmp55_ = self->priv->picker_to;
	g_signal_connect_object (_tmp55_, "time-changed", (GCallback) __pc_widgets_time_limit_view_week_spin_box___lambda6__granite_time_picker_time_changed, self, 0);
	_g_object_unref0 (duration_box);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_label);
	_g_date_time_unref0 (today_end);
	_g_date_time_unref0 (today_start);
	_g_date_time_unref0 (today_local);
	_g_object_unref0 (enable_switch);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
pc_widgets_time_limit_view_week_spin_box_class_init (PCWidgetsTimeLimitViewWeekSpinBoxClass * klass,
                                                     gpointer klass_data)
{
	pc_widgets_time_limit_view_week_spin_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsTimeLimitViewWeekSpinBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_time_limit_view_week_spin_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_time_limit_view_week_spin_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_time_limit_view_week_spin_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_time_limit_view_week_spin_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY] = g_param_spec_boolean ("is-weekend", "is-weekend", "is-weekend", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY, pc_widgets_time_limit_view_week_spin_box_properties[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	pc_widgets_time_limit_view_week_spin_box_signals[PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_CHANGED_SIGNAL] = g_signal_new ("changed", PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pc_widgets_time_limit_view_week_spin_box_instance_init (PCWidgetsTimeLimitViewWeekSpinBox * self,
                                                        gpointer klass)
{
	self->priv = pc_widgets_time_limit_view_week_spin_box_get_instance_private (self);
}

static void
pc_widgets_time_limit_view_week_spin_box_finalize (GObject * obj)
{
	PCWidgetsTimeLimitViewWeekSpinBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBox);
	_g_free0 (self->priv->_title);
	_g_object_unref0 (self->priv->picker_from);
	_g_object_unref0 (self->priv->picker_to);
	G_OBJECT_CLASS (pc_widgets_time_limit_view_week_spin_box_parent_class)->finalize (obj);
}

static GType
pc_widgets_time_limit_view_week_spin_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsTimeLimitViewWeekSpinBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_time_limit_view_week_spin_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsTimeLimitViewWeekSpinBox), 0, (GInstanceInitFunc) pc_widgets_time_limit_view_week_spin_box_instance_init, NULL };
	GType pc_widgets_time_limit_view_week_spin_box_type_id;
	pc_widgets_time_limit_view_week_spin_box_type_id = g_type_register_static (gtk_grid_get_type (), "PCWidgetsTimeLimitViewWeekSpinBox", &g_define_type_info, 0);
	PCWidgetsTimeLimitViewWeekSpinBox_private_offset = g_type_add_instance_private (pc_widgets_time_limit_view_week_spin_box_type_id, sizeof (PCWidgetsTimeLimitViewWeekSpinBoxPrivate));
	return pc_widgets_time_limit_view_week_spin_box_type_id;
}

static GType
pc_widgets_time_limit_view_week_spin_box_get_type (void)
{
	static volatile gsize pc_widgets_time_limit_view_week_spin_box_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_time_limit_view_week_spin_box_type_id__once)) {
		GType pc_widgets_time_limit_view_week_spin_box_type_id;
		pc_widgets_time_limit_view_week_spin_box_type_id = pc_widgets_time_limit_view_week_spin_box_get_type_once ();
		g_once_init_leave (&pc_widgets_time_limit_view_week_spin_box_type_id__once, pc_widgets_time_limit_view_week_spin_box_type_id);
	}
	return pc_widgets_time_limit_view_week_spin_box_type_id__once;
}

static void
_vala_pc_widgets_time_limit_view_week_spin_box_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	PCWidgetsTimeLimitViewWeekSpinBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBox);
	switch (property_id) {
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY:
		g_value_set_boolean (value, pc_widgets_time_limit_view_week_spin_box_get_active (self));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY:
		g_value_set_string (value, pc_widgets_time_limit_view_week_spin_box_get_title (self));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY:
		g_value_set_boolean (value, pc_widgets_time_limit_view_week_spin_box_get_is_weekend (self));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY:
		g_value_set_object (value, pc_widgets_time_limit_view_week_spin_box_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_time_limit_view_week_spin_box_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	PCWidgetsTimeLimitViewWeekSpinBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TIME_LIMIT_VIEW_TYPE_WEEK_SPIN_BOX, PCWidgetsTimeLimitViewWeekSpinBox);
	switch (property_id) {
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_ACTIVE_PROPERTY:
		pc_widgets_time_limit_view_week_spin_box_set_active (self, g_value_get_boolean (value));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_TITLE_PROPERTY:
		pc_widgets_time_limit_view_week_spin_box_set_title (self, g_value_get_string (value));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_IS_WEEKEND_PROPERTY:
		pc_widgets_time_limit_view_week_spin_box_set_is_weekend (self, g_value_get_boolean (value));
		break;
		case PC_WIDGETS_TIME_LIMIT_VIEW_WEEK_SPIN_BOX_USER_PROPERTY:
		pc_widgets_time_limit_view_week_spin_box_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_pc_widgets_time_limit_view___lambda7_ (PCWidgetsTimeLimitView* self)
{
	pc_widgets_time_limit_view_update_pam (self, TRUE);
}

static void
__pc_widgets_time_limit_view___lambda7__pc_widgets_time_limit_view_week_spin_box_changed (PCWidgetsTimeLimitViewWeekSpinBox* _sender,
                                                                                          gpointer self)
{
	_pc_widgets_time_limit_view___lambda7_ ((PCWidgetsTimeLimitView*) self);
}

static void
_pc_widgets_time_limit_view___lambda8_ (PCWidgetsTimeLimitView* self)
{
	pc_widgets_time_limit_view_update_pam (self, TRUE);
}

static void
__pc_widgets_time_limit_view___lambda8__pc_widgets_time_limit_view_week_spin_box_changed (PCWidgetsTimeLimitViewWeekSpinBox* _sender,
                                                                                          gpointer self)
{
	_pc_widgets_time_limit_view___lambda8_ ((PCWidgetsTimeLimitView*) self);
}

static void
_pc_widgets_time_limit_view___lambda9_ (PCWidgetsTimeLimitView* self)
{
	pc_widgets_time_limit_view_update_pam (self, TRUE);
}

static void
__pc_widgets_time_limit_view___lambda9__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_pc_widgets_time_limit_view___lambda9_ ((PCWidgetsTimeLimitView*) self);
}

static void
_pc_widgets_time_limit_view___lambda10_ (PCWidgetsTimeLimitView* self)
{
	pc_widgets_time_limit_view_update_pam (self, TRUE);
}

static void
__pc_widgets_time_limit_view___lambda10__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	_pc_widgets_time_limit_view___lambda10_ ((PCWidgetsTimeLimitView*) self);
}

static GObject *
pc_widgets_time_limit_view_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsTimeLimitView * self;
	ActUser* _tmp0_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp1_;
	ActUser* _tmp2_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp3_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp4_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp5_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp6_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp7_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp8_;
	PCWidgetsTimeLimitViewWeekSpinBox* _tmp9_;
	parent_class = G_OBJECT_CLASS (pc_widgets_time_limit_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_TIME_LIMIT_VIEW, PCWidgetsTimeLimitView);
	_tmp0_ = self->priv->_user;
	_tmp1_ = pc_widgets_time_limit_view_week_spin_box_new (_ ("Weekdays"), FALSE, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->weekday_box);
	self->priv->weekday_box = _tmp1_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = pc_widgets_time_limit_view_week_spin_box_new (_ ("Weekends"), TRUE, _tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->weekend_box);
	self->priv->weekend_box = _tmp3_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 24);
	_tmp4_ = self->priv->weekday_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->weekend_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->weekday_box;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) __pc_widgets_time_limit_view___lambda7__pc_widgets_time_limit_view_week_spin_box_changed, self, 0);
	_tmp7_ = self->priv->weekend_box;
	g_signal_connect_object (_tmp7_, "changed", (GCallback) __pc_widgets_time_limit_view___lambda8__pc_widgets_time_limit_view_week_spin_box_changed, self, 0);
	pc_widgets_time_limit_view_load_restrictions (self);
	_tmp8_ = self->priv->weekday_box;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::active", (GCallback) __pc_widgets_time_limit_view___lambda9__g_object_notify, self, 0);
	_tmp9_ = self->priv->weekend_box;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::active", (GCallback) __pc_widgets_time_limit_view___lambda10__g_object_notify, self, 0);
	return obj;
}

static void
pc_widgets_time_limit_view_class_init (PCWidgetsTimeLimitViewClass * klass,
                                       gpointer klass_data)
{
	pc_widgets_time_limit_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsTimeLimitView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_time_limit_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_time_limit_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_time_limit_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_time_limit_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY, pc_widgets_time_limit_view_properties[PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pc_widgets_time_limit_view_instance_init (PCWidgetsTimeLimitView * self,
                                          gpointer klass)
{
	self->priv = pc_widgets_time_limit_view_get_instance_private (self);
}

static void
pc_widgets_time_limit_view_finalize (GObject * obj)
{
	PCWidgetsTimeLimitView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_TIME_LIMIT_VIEW, PCWidgetsTimeLimitView);
	_g_object_unref0 (self->priv->weekday_box);
	_g_object_unref0 (self->priv->weekend_box);
	G_OBJECT_CLASS (pc_widgets_time_limit_view_parent_class)->finalize (obj);
}

static GType
pc_widgets_time_limit_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsTimeLimitViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_time_limit_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsTimeLimitView), 0, (GInstanceInitFunc) pc_widgets_time_limit_view_instance_init, NULL };
	GType pc_widgets_time_limit_view_type_id;
	pc_widgets_time_limit_view_type_id = g_type_register_static (gtk_box_get_type (), "PCWidgetsTimeLimitView", &g_define_type_info, 0);
	PCWidgetsTimeLimitView_private_offset = g_type_add_instance_private (pc_widgets_time_limit_view_type_id, sizeof (PCWidgetsTimeLimitViewPrivate));
	return pc_widgets_time_limit_view_type_id;
}

GType
pc_widgets_time_limit_view_get_type (void)
{
	static volatile gsize pc_widgets_time_limit_view_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_time_limit_view_type_id__once)) {
		GType pc_widgets_time_limit_view_type_id;
		pc_widgets_time_limit_view_type_id = pc_widgets_time_limit_view_get_type_once ();
		g_once_init_leave (&pc_widgets_time_limit_view_type_id__once, pc_widgets_time_limit_view_type_id);
	}
	return pc_widgets_time_limit_view_type_id__once;
}

static void
_vala_pc_widgets_time_limit_view_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	PCWidgetsTimeLimitView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_TIME_LIMIT_VIEW, PCWidgetsTimeLimitView);
	switch (property_id) {
		case PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY:
		g_value_set_object (value, pc_widgets_time_limit_view_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_time_limit_view_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	PCWidgetsTimeLimitView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_TIME_LIMIT_VIEW, PCWidgetsTimeLimitView);
	switch (property_id) {
		case PC_WIDGETS_TIME_LIMIT_VIEW_USER_PROPERTY:
		pc_widgets_time_limit_view_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

