/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * Copyright (c) 2011-2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <gio/gio.h>
#include "power.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_PLUG_0_PROPERTY,
	POWER_PLUG_NUM_PROPERTIES
};
static GParamSpec* power_plug_properties[POWER_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PowerPlugSearchData PowerPlugSearchData;

struct _PowerPlugPrivate {
	GtkBox* box;
	PowerMainView* main_view;
};

struct _PowerPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PowerPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
};

VALA_EXTERN GSettings* power_settings;
GSettings* power_settings = NULL;
static gint PowerPlug_private_offset;
static gpointer power_plug_parent_class = NULL;

static GtkWidget* power_plug_real_get_widget (SwitchboardPlug* base);
static void power_plug_real_shown (SwitchboardPlug* base);
static void power_plug_real_hidden (SwitchboardPlug* base);
static void power_plug_real_search_callback (SwitchboardPlug* base,
                                      const gchar* location);
static void power_plug_real_search_data_free (gpointer _data);
static void power_plug_real_search (SwitchboardPlug* base,
                             const gchar* search,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static gboolean power_plug_real_search_co (PowerPlugSearchData* _data_);
static void power_plug_finalize (GObject * obj);
static GType power_plug_get_type_once (void);

static inline gpointer
power_plug_get_instance_private (PowerPlug* self)
{
	return G_STRUCT_MEMBER_P (self, PowerPlug_private_offset);
}

PowerPlug*
power_plug_construct (GType object_type)
{
	PowerPlug * self = NULL;
	GeeTreeMap* supported_settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	supported_settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) supported_settings, "power", NULL);
	self = (PowerPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.power", "display-name", _ ("Power"), "description", _ ("Configure display brightness, power buttons, and suspend behavior"), "icon", "preferences-system-power", "supported-settings", supported_settings, NULL);
	_g_object_unref0 (supported_settings);
	return self;
}

PowerPlug*
power_plug_new (void)
{
	return power_plug_construct (POWER_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
power_plug_real_get_widget (SwitchboardPlug* base)
{
	PowerPlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* result;
	self = (PowerPlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		GdkDisplay* _tmp1_;
		GtkIconTheme* _tmp2_;
		AdwHeaderBar* headerbar = NULL;
		AdwHeaderBar* _tmp3_ = NULL;
		AdwHeaderBar* _tmp4_;
		PowerMainView* _tmp5_ = NULL;
		GtkBox* _tmp6_;
		GtkBox* _tmp7_;
		AdwHeaderBar* _tmp8_;
		GtkBox* _tmp9_;
		PowerMainView* _tmp10_;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gtk_icon_theme_get_for_display (_tmp1_);
		gtk_icon_theme_add_resource_path (_tmp2_, "/io/elementary/settings/power");
		_tmp3_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp3_, FALSE);
		g_object_ref_sink (_tmp3_);
		headerbar = _tmp3_;
		_tmp4_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_FLAT);
		_tmp5_ = power_main_view_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp5_, TRUE);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->main_view);
		self->priv->main_view = _tmp5_;
		_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp6_;
		_tmp7_ = self->priv->box;
		_tmp8_ = headerbar;
		gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->box;
		_tmp10_ = self->priv->main_view;
		gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
		_g_object_unref0 (headerbar);
	}
	_tmp11_ = self->priv->box;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	result = _tmp12_;
	return result;
}

static void
power_plug_real_shown (SwitchboardPlug* base)
{
	PowerPlug * self;
	PowerMainView* _tmp0_;
	GtkStack* _tmp1_;
	GtkStack* _tmp2_;
	PowerPowerManager* _tmp3_;
	self = (PowerPlug*) base;
	_tmp0_ = self->priv->main_view;
	_tmp1_ = power_main_view_get_stack (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = power_power_manager_get_default ();
	if (power_power_manager_on_battery (_tmp3_)) {
		PowerMainView* _tmp4_;
		GtkStack* _tmp5_;
		GtkStack* _tmp6_;
		_tmp4_ = self->priv->main_view;
		_tmp5_ = power_main_view_get_stack (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_stack_set_visible_child_name (_tmp6_, "battery");
	} else {
		PowerMainView* _tmp7_;
		GtkStack* _tmp8_;
		GtkStack* _tmp9_;
		_tmp7_ = self->priv->main_view;
		_tmp8_ = power_main_view_get_stack (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_stack_set_visible_child_name (_tmp9_, "ac");
	}
}

static void
power_plug_real_hidden (SwitchboardPlug* base)
{
	PowerPlug * self;
	self = (PowerPlug*) base;
}

static void
power_plug_real_search_callback (SwitchboardPlug* base,
                                 const gchar* location)
{
	PowerPlug * self;
	self = (PowerPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
power_plug_real_search_data_free (gpointer _data)
{
	PowerPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PowerPlugSearchData, _data_);
}

static void
power_plug_real_search (SwitchboardPlug* base,
                        const gchar* search,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	PowerPlug * self;
	PowerPlugSearchData* _data_;
	PowerPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (PowerPlug*) base;
	_data_ = g_slice_new0 (PowerPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, power_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	power_plug_real_search_co (_data_);
}

static GeeTreeMap*
power_plug_search_finish (SwitchboardPlug* base,
                          GAsyncResult* _res_)
{
	GeeTreeMap* result;
	PowerPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
power_plug_real_search_co (PowerPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Automatically Adjust Brightness"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("Automatically Save Power"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Automatic Display Off"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "");
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Battery Level"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, "");
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("Dim Display"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, "");
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s", _data_->_tmp24_, _ ("Display Brightness"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, "");
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s", _data_->_tmp28_, _ ("Lid Close Behavior"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, "");
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s", _data_->_tmp32_, _ ("Lid Close With External Display"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, "");
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s", _data_->_tmp36_, _ ("Power Button Behavior"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, "");
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s", _data_->_tmp40_, _ ("Suspend When Inactive For"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp42_, "");
	_g_free0 (_data_->_tmp42_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
power_plug_class_init (PowerPlugClass * klass,
                       gpointer klass_data)
{
	power_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) power_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) power_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) power_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) power_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) power_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) power_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = power_plug_finalize;
}

static void
power_plug_instance_init (PowerPlug * self,
                          gpointer klass)
{
	self->priv = power_plug_get_instance_private (self);
}

static void
power_plug_finalize (GObject * obj)
{
	PowerPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_PLUG, PowerPlug);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->main_view);
	G_OBJECT_CLASS (power_plug_parent_class)->finalize (obj);
}

static GType
power_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerPlug), 0, (GInstanceInitFunc) power_plug_instance_init, NULL };
	GType power_plug_type_id;
	power_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "PowerPlug", &g_define_type_info, 0);
	PowerPlug_private_offset = g_type_add_instance_private (power_plug_type_id, sizeof (PowerPlugPrivate));
	return power_plug_type_id;
}

GType
power_plug_get_type (void)
{
	static volatile gsize power_plug_type_id__once = 0;
	if (g_once_init_enter (&power_plug_type_id__once)) {
		GType power_plug_type_id;
		power_plug_type_id = power_plug_get_type_once ();
		g_once_init_leave (&power_plug_type_id__once, power_plug_type_id);
	}
	return power_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	PowerPlug* plug = NULL;
	PowerPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:102: Activating Power plug");
	_tmp0_ = power_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

