// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/v1/autokey.proto

package kmspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Autokey_CreateKeyHandle_FullMethodName = "/google.cloud.kms.v1.Autokey/CreateKeyHandle"
	Autokey_GetKeyHandle_FullMethodName    = "/google.cloud.kms.v1.Autokey/GetKeyHandle"
	Autokey_ListKeyHandles_FullMethodName  = "/google.cloud.kms.v1.Autokey/ListKeyHandles"
)

// AutokeyClient is the client API for Autokey service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutokeyClient interface {
	// Creates a new [KeyHandle][google.cloud.kms.v1.KeyHandle], triggering the
	// provisioning of a new [CryptoKey][google.cloud.kms.v1.CryptoKey] for CMEK
	// use with the given resource type in the configured key project and the same
	// location. [GetOperation][google.longrunning.Operations.GetOperation] should
	// be used to resolve the resulting long-running operation and get the
	// resulting [KeyHandle][google.cloud.kms.v1.KeyHandle] and
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	CreateKeyHandle(ctx context.Context, in *CreateKeyHandleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the [KeyHandle][google.cloud.kms.v1.KeyHandle].
	GetKeyHandle(ctx context.Context, in *GetKeyHandleRequest, opts ...grpc.CallOption) (*KeyHandle, error)
	// Lists [KeyHandles][google.cloud.kms.v1.KeyHandle].
	ListKeyHandles(ctx context.Context, in *ListKeyHandlesRequest, opts ...grpc.CallOption) (*ListKeyHandlesResponse, error)
}

type autokeyClient struct {
	cc grpc.ClientConnInterface
}

func NewAutokeyClient(cc grpc.ClientConnInterface) AutokeyClient {
	return &autokeyClient{cc}
}

func (c *autokeyClient) CreateKeyHandle(ctx context.Context, in *CreateKeyHandleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Autokey_CreateKeyHandle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autokeyClient) GetKeyHandle(ctx context.Context, in *GetKeyHandleRequest, opts ...grpc.CallOption) (*KeyHandle, error) {
	out := new(KeyHandle)
	err := c.cc.Invoke(ctx, Autokey_GetKeyHandle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autokeyClient) ListKeyHandles(ctx context.Context, in *ListKeyHandlesRequest, opts ...grpc.CallOption) (*ListKeyHandlesResponse, error) {
	out := new(ListKeyHandlesResponse)
	err := c.cc.Invoke(ctx, Autokey_ListKeyHandles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutokeyServer is the server API for Autokey service.
// All implementations should embed UnimplementedAutokeyServer
// for forward compatibility
type AutokeyServer interface {
	// Creates a new [KeyHandle][google.cloud.kms.v1.KeyHandle], triggering the
	// provisioning of a new [CryptoKey][google.cloud.kms.v1.CryptoKey] for CMEK
	// use with the given resource type in the configured key project and the same
	// location. [GetOperation][google.longrunning.Operations.GetOperation] should
	// be used to resolve the resulting long-running operation and get the
	// resulting [KeyHandle][google.cloud.kms.v1.KeyHandle] and
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	CreateKeyHandle(context.Context, *CreateKeyHandleRequest) (*longrunningpb.Operation, error)
	// Returns the [KeyHandle][google.cloud.kms.v1.KeyHandle].
	GetKeyHandle(context.Context, *GetKeyHandleRequest) (*KeyHandle, error)
	// Lists [KeyHandles][google.cloud.kms.v1.KeyHandle].
	ListKeyHandles(context.Context, *ListKeyHandlesRequest) (*ListKeyHandlesResponse, error)
}

// UnimplementedAutokeyServer should be embedded to have forward compatible implementations.
type UnimplementedAutokeyServer struct {
}

func (UnimplementedAutokeyServer) CreateKeyHandle(context.Context, *CreateKeyHandleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKeyHandle not implemented")
}
func (UnimplementedAutokeyServer) GetKeyHandle(context.Context, *GetKeyHandleRequest) (*KeyHandle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeyHandle not implemented")
}
func (UnimplementedAutokeyServer) ListKeyHandles(context.Context, *ListKeyHandlesRequest) (*ListKeyHandlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeyHandles not implemented")
}

// UnsafeAutokeyServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutokeyServer will
// result in compilation errors.
type UnsafeAutokeyServer interface {
	mustEmbedUnimplementedAutokeyServer()
}

func RegisterAutokeyServer(s grpc.ServiceRegistrar, srv AutokeyServer) {
	s.RegisterService(&Autokey_ServiceDesc, srv)
}

func _Autokey_CreateKeyHandle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyHandleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyServer).CreateKeyHandle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autokey_CreateKeyHandle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyServer).CreateKeyHandle(ctx, req.(*CreateKeyHandleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autokey_GetKeyHandle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyHandleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyServer).GetKeyHandle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autokey_GetKeyHandle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyServer).GetKeyHandle(ctx, req.(*GetKeyHandleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autokey_ListKeyHandles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyHandlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyServer).ListKeyHandles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autokey_ListKeyHandles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyServer).ListKeyHandles(ctx, req.(*ListKeyHandlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Autokey_ServiceDesc is the grpc.ServiceDesc for Autokey service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Autokey_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.Autokey",
	HandlerType: (*AutokeyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateKeyHandle",
			Handler:    _Autokey_CreateKeyHandle_Handler,
		},
		{
			MethodName: "GetKeyHandle",
			Handler:    _Autokey_GetKeyHandle_Handler,
		},
		{
			MethodName: "ListKeyHandles",
			Handler:    _Autokey_ListKeyHandles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/autokey.proto",
}
