#include <wayland-client-protocol-unstable.hpp>

using namespace wayland;
using namespace wayland::detail;

const wl_interface* zwp_fullscreen_shell_v1_interface_release_request[0] = {
};

const wl_interface* zwp_fullscreen_shell_v1_interface_present_surface_request[3] = {
  &surface_interface,
  nullptr,
  &output_interface,
};

const wl_interface* zwp_fullscreen_shell_v1_interface_present_surface_for_mode_request[4] = {
  &surface_interface,
  &output_interface,
  nullptr,
  &zwp_fullscreen_shell_mode_feedback_v1_interface,
};

const wl_interface* zwp_fullscreen_shell_v1_interface_capability_event[1] = {
  nullptr,
};

const wl_message zwp_fullscreen_shell_v1_interface_requests[3] = {
  {
    "release",
    "",
    zwp_fullscreen_shell_v1_interface_release_request,
  },
  {
    "present_surface",
    "?ou?o",
    zwp_fullscreen_shell_v1_interface_present_surface_request,
  },
  {
    "present_surface_for_mode",
    "ooin",
    zwp_fullscreen_shell_v1_interface_present_surface_for_mode_request,
  },
};

const wl_message zwp_fullscreen_shell_v1_interface_events[1] = {
  {
    "capability",
    "u",
    zwp_fullscreen_shell_v1_interface_capability_event,
  },
};

const wl_interface wayland::detail::zwp_fullscreen_shell_v1_interface =
  {
    "zwp_fullscreen_shell_v1",
    1,
    3,
    zwp_fullscreen_shell_v1_interface_requests,
    1,
    zwp_fullscreen_shell_v1_interface_events,
  };

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_mode_successful_event[0] = {
};

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_mode_failed_event[0] = {
};

const wl_interface* zwp_fullscreen_shell_mode_feedback_v1_interface_present_cancelled_event[0] = {
};

const wl_message zwp_fullscreen_shell_mode_feedback_v1_interface_requests[0] = {
};

const wl_message zwp_fullscreen_shell_mode_feedback_v1_interface_events[3] = {
  {
    "mode_successful",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_mode_successful_event,
  },
  {
    "mode_failed",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_mode_failed_event,
  },
  {
    "present_cancelled",
    "",
    zwp_fullscreen_shell_mode_feedback_v1_interface_present_cancelled_event,
  },
};

const wl_interface wayland::detail::zwp_fullscreen_shell_mode_feedback_v1_interface =
  {
    "zwp_fullscreen_shell_mode_feedback_v1",
    1,
    0,
    zwp_fullscreen_shell_mode_feedback_v1_interface_requests,
    3,
    zwp_fullscreen_shell_mode_feedback_v1_interface_events,
  };

const wl_interface* zwp_idle_inhibit_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_idle_inhibit_manager_v1_interface_create_inhibitor_request[2] = {
  &zwp_idle_inhibitor_v1_interface,
  &surface_interface,
};

const wl_message zwp_idle_inhibit_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_idle_inhibit_manager_v1_interface_destroy_request,
  },
  {
    "create_inhibitor",
    "no",
    zwp_idle_inhibit_manager_v1_interface_create_inhibitor_request,
  },
};

const wl_message zwp_idle_inhibit_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_idle_inhibit_manager_v1_interface =
  {
    "zwp_idle_inhibit_manager_v1",
    1,
    2,
    zwp_idle_inhibit_manager_v1_interface_requests,
    0,
    zwp_idle_inhibit_manager_v1_interface_events,
  };

const wl_interface* zwp_idle_inhibitor_v1_interface_destroy_request[0] = {
};

const wl_message zwp_idle_inhibitor_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_idle_inhibitor_v1_interface_destroy_request,
  },
};

const wl_message zwp_idle_inhibitor_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_idle_inhibitor_v1_interface =
  {
    "zwp_idle_inhibitor_v1",
    1,
    1,
    zwp_idle_inhibitor_v1_interface_requests,
    0,
    zwp_idle_inhibitor_v1_interface_events,
  };

const wl_interface* zwp_input_method_context_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_input_method_context_v1_interface_commit_string_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_string_request[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_styling_request[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preedit_cursor_request[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_delete_surrounding_text_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_cursor_position_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_modifiers_map_request[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_keysym_request[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_grab_keyboard_request[1] = {
  &keyboard_interface,
};

const wl_interface* zwp_input_method_context_v1_interface_key_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_modifiers_request[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_language_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_text_direction_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_surrounding_text_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_reset_event[0] = {
};

const wl_interface* zwp_input_method_context_v1_interface_content_type_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_invoke_action_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_commit_state_event[1] = {
  nullptr,
};

const wl_interface* zwp_input_method_context_v1_interface_preferred_language_event[1] = {
  nullptr,
};

const wl_message zwp_input_method_context_v1_interface_requests[14] = {
  {
    "destroy",
    "",
    zwp_input_method_context_v1_interface_destroy_request,
  },
  {
    "commit_string",
    "us",
    zwp_input_method_context_v1_interface_commit_string_request,
  },
  {
    "preedit_string",
    "uss",
    zwp_input_method_context_v1_interface_preedit_string_request,
  },
  {
    "preedit_styling",
    "uuu",
    zwp_input_method_context_v1_interface_preedit_styling_request,
  },
  {
    "preedit_cursor",
    "i",
    zwp_input_method_context_v1_interface_preedit_cursor_request,
  },
  {
    "delete_surrounding_text",
    "iu",
    zwp_input_method_context_v1_interface_delete_surrounding_text_request,
  },
  {
    "cursor_position",
    "ii",
    zwp_input_method_context_v1_interface_cursor_position_request,
  },
  {
    "modifiers_map",
    "a",
    zwp_input_method_context_v1_interface_modifiers_map_request,
  },
  {
    "keysym",
    "uuuuu",
    zwp_input_method_context_v1_interface_keysym_request,
  },
  {
    "grab_keyboard",
    "n",
    zwp_input_method_context_v1_interface_grab_keyboard_request,
  },
  {
    "key",
    "uuuu",
    zwp_input_method_context_v1_interface_key_request,
  },
  {
    "modifiers",
    "uuuuu",
    zwp_input_method_context_v1_interface_modifiers_request,
  },
  {
    "language",
    "us",
    zwp_input_method_context_v1_interface_language_request,
  },
  {
    "text_direction",
    "uu",
    zwp_input_method_context_v1_interface_text_direction_request,
  },
};

const wl_message zwp_input_method_context_v1_interface_events[6] = {
  {
    "surrounding_text",
    "suu",
    zwp_input_method_context_v1_interface_surrounding_text_event,
  },
  {
    "reset",
    "",
    zwp_input_method_context_v1_interface_reset_event,
  },
  {
    "content_type",
    "uu",
    zwp_input_method_context_v1_interface_content_type_event,
  },
  {
    "invoke_action",
    "uu",
    zwp_input_method_context_v1_interface_invoke_action_event,
  },
  {
    "commit_state",
    "u",
    zwp_input_method_context_v1_interface_commit_state_event,
  },
  {
    "preferred_language",
    "s",
    zwp_input_method_context_v1_interface_preferred_language_event,
  },
};

const wl_interface wayland::detail::zwp_input_method_context_v1_interface =
  {
    "zwp_input_method_context_v1",
    1,
    14,
    zwp_input_method_context_v1_interface_requests,
    6,
    zwp_input_method_context_v1_interface_events,
  };

const wl_interface* zwp_input_method_v1_interface_activate_event[1] = {
  &zwp_input_method_context_v1_interface,
};

const wl_interface* zwp_input_method_v1_interface_deactivate_event[1] = {
  &zwp_input_method_context_v1_interface,
};

const wl_message zwp_input_method_v1_interface_requests[0] = {
};

const wl_message zwp_input_method_v1_interface_events[2] = {
  {
    "activate",
    "n",
    zwp_input_method_v1_interface_activate_event,
  },
  {
    "deactivate",
    "o",
    zwp_input_method_v1_interface_deactivate_event,
  },
};

const wl_interface wayland::detail::zwp_input_method_v1_interface =
  {
    "zwp_input_method_v1",
    1,
    0,
    zwp_input_method_v1_interface_requests,
    2,
    zwp_input_method_v1_interface_events,
  };

const wl_interface* zwp_input_panel_v1_interface_get_input_panel_surface_request[2] = {
  &zwp_input_panel_surface_v1_interface,
  &surface_interface,
};

const wl_message zwp_input_panel_v1_interface_requests[1] = {
  {
    "get_input_panel_surface",
    "no",
    zwp_input_panel_v1_interface_get_input_panel_surface_request,
  },
};

const wl_message zwp_input_panel_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_input_panel_v1_interface =
  {
    "zwp_input_panel_v1",
    1,
    1,
    zwp_input_panel_v1_interface_requests,
    0,
    zwp_input_panel_v1_interface_events,
  };

const wl_interface* zwp_input_panel_surface_v1_interface_set_toplevel_request[2] = {
  &output_interface,
  nullptr,
};

const wl_interface* zwp_input_panel_surface_v1_interface_set_overlay_panel_request[0] = {
};

const wl_message zwp_input_panel_surface_v1_interface_requests[2] = {
  {
    "set_toplevel",
    "ou",
    zwp_input_panel_surface_v1_interface_set_toplevel_request,
  },
  {
    "set_overlay_panel",
    "",
    zwp_input_panel_surface_v1_interface_set_overlay_panel_request,
  },
};

const wl_message zwp_input_panel_surface_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_input_panel_surface_v1_interface =
  {
    "zwp_input_panel_surface_v1",
    1,
    2,
    zwp_input_panel_surface_v1_interface_requests,
    0,
    zwp_input_panel_surface_v1_interface_events,
  };

const wl_interface* zwp_input_timestamps_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_keyboard_timestamps_request[2] = {
  &zwp_input_timestamps_v1_interface,
  &keyboard_interface,
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_pointer_timestamps_request[2] = {
  &zwp_input_timestamps_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_input_timestamps_manager_v1_interface_get_touch_timestamps_request[2] = {
  &zwp_input_timestamps_v1_interface,
  &touch_interface,
};

const wl_message zwp_input_timestamps_manager_v1_interface_requests[4] = {
  {
    "destroy",
    "",
    zwp_input_timestamps_manager_v1_interface_destroy_request,
  },
  {
    "get_keyboard_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_keyboard_timestamps_request,
  },
  {
    "get_pointer_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_pointer_timestamps_request,
  },
  {
    "get_touch_timestamps",
    "no",
    zwp_input_timestamps_manager_v1_interface_get_touch_timestamps_request,
  },
};

const wl_message zwp_input_timestamps_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_input_timestamps_manager_v1_interface =
  {
    "zwp_input_timestamps_manager_v1",
    1,
    4,
    zwp_input_timestamps_manager_v1_interface_requests,
    0,
    zwp_input_timestamps_manager_v1_interface_events,
  };

const wl_interface* zwp_input_timestamps_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_input_timestamps_v1_interface_timestamp_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_input_timestamps_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_input_timestamps_v1_interface_destroy_request,
  },
};

const wl_message zwp_input_timestamps_v1_interface_events[1] = {
  {
    "timestamp",
    "uuu",
    zwp_input_timestamps_v1_interface_timestamp_event,
  },
};

const wl_interface wayland::detail::zwp_input_timestamps_v1_interface =
  {
    "zwp_input_timestamps_v1",
    1,
    1,
    zwp_input_timestamps_v1_interface_requests,
    1,
    zwp_input_timestamps_v1_interface_events,
  };

const wl_interface* zwp_keyboard_shortcuts_inhibit_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibit_manager_v1_interface_inhibit_shortcuts_request[3] = {
  &zwp_keyboard_shortcuts_inhibitor_v1_interface,
  &surface_interface,
  &seat_interface,
};

const wl_message zwp_keyboard_shortcuts_inhibit_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_destroy_request,
  },
  {
    "inhibit_shortcuts",
    "noo",
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_inhibit_shortcuts_request,
  },
};

const wl_message zwp_keyboard_shortcuts_inhibit_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_keyboard_shortcuts_inhibit_manager_v1_interface =
  {
    "zwp_keyboard_shortcuts_inhibit_manager_v1",
    1,
    2,
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_requests,
    0,
    zwp_keyboard_shortcuts_inhibit_manager_v1_interface_events,
  };

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_active_event[0] = {
};

const wl_interface* zwp_keyboard_shortcuts_inhibitor_v1_interface_inactive_event[0] = {
};

const wl_message zwp_keyboard_shortcuts_inhibitor_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_destroy_request,
  },
};

const wl_message zwp_keyboard_shortcuts_inhibitor_v1_interface_events[2] = {
  {
    "active",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_active_event,
  },
  {
    "inactive",
    "",
    zwp_keyboard_shortcuts_inhibitor_v1_interface_inactive_event,
  },
};

const wl_interface wayland::detail::zwp_keyboard_shortcuts_inhibitor_v1_interface =
  {
    "zwp_keyboard_shortcuts_inhibitor_v1",
    1,
    1,
    zwp_keyboard_shortcuts_inhibitor_v1_interface_requests,
    2,
    zwp_keyboard_shortcuts_inhibitor_v1_interface_events,
  };

const wl_interface* zwp_linux_dmabuf_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_linux_dmabuf_v1_interface_create_params_request[1] = {
  &zwp_linux_buffer_params_v1_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_get_default_feedback_request[1] = {
  &zwp_linux_dmabuf_feedback_v1_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_get_surface_feedback_request[2] = {
  &zwp_linux_dmabuf_feedback_v1_interface,
  &surface_interface,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_format_event[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_v1_interface_modifier_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_linux_dmabuf_v1_interface_requests[4] = {
  {
    "destroy",
    "",
    zwp_linux_dmabuf_v1_interface_destroy_request,
  },
  {
    "create_params",
    "n",
    zwp_linux_dmabuf_v1_interface_create_params_request,
  },
  {
    "get_default_feedback",
    "4n",
    zwp_linux_dmabuf_v1_interface_get_default_feedback_request,
  },
  {
    "get_surface_feedback",
    "4no",
    zwp_linux_dmabuf_v1_interface_get_surface_feedback_request,
  },
};

const wl_message zwp_linux_dmabuf_v1_interface_events[2] = {
  {
    "format",
    "u",
    zwp_linux_dmabuf_v1_interface_format_event,
  },
  {
    "modifier",
    "3uuu",
    zwp_linux_dmabuf_v1_interface_modifier_event,
  },
};

const wl_interface wayland::detail::zwp_linux_dmabuf_v1_interface =
  {
    "zwp_linux_dmabuf_v1",
    4,
    4,
    zwp_linux_dmabuf_v1_interface_requests,
    2,
    zwp_linux_dmabuf_v1_interface_events,
  };

const wl_interface* zwp_linux_buffer_params_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_linux_buffer_params_v1_interface_add_request[6] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_create_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_create_immed_request[5] = {
  &buffer_interface,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_created_event[1] = {
  &buffer_interface,
};

const wl_interface* zwp_linux_buffer_params_v1_interface_failed_event[0] = {
};

const wl_message zwp_linux_buffer_params_v1_interface_requests[4] = {
  {
    "destroy",
    "",
    zwp_linux_buffer_params_v1_interface_destroy_request,
  },
  {
    "add",
    "huuuuu",
    zwp_linux_buffer_params_v1_interface_add_request,
  },
  {
    "create",
    "iiuu",
    zwp_linux_buffer_params_v1_interface_create_request,
  },
  {
    "create_immed",
    "2niiuu",
    zwp_linux_buffer_params_v1_interface_create_immed_request,
  },
};

const wl_message zwp_linux_buffer_params_v1_interface_events[2] = {
  {
    "created",
    "n",
    zwp_linux_buffer_params_v1_interface_created_event,
  },
  {
    "failed",
    "",
    zwp_linux_buffer_params_v1_interface_failed_event,
  },
};

const wl_interface wayland::detail::zwp_linux_buffer_params_v1_interface =
  {
    "zwp_linux_buffer_params_v1",
    4,
    4,
    zwp_linux_buffer_params_v1_interface_requests,
    2,
    zwp_linux_buffer_params_v1_interface_events,
  };

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_done_event[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_format_table_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_main_device_event[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_done_event[0] = {
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_target_device_event[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_formats_event[1] = {
  nullptr,
};

const wl_interface* zwp_linux_dmabuf_feedback_v1_interface_tranche_flags_event[1] = {
  nullptr,
};

const wl_message zwp_linux_dmabuf_feedback_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_destroy_request,
  },
};

const wl_message zwp_linux_dmabuf_feedback_v1_interface_events[7] = {
  {
    "done",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_done_event,
  },
  {
    "format_table",
    "hu",
    zwp_linux_dmabuf_feedback_v1_interface_format_table_event,
  },
  {
    "main_device",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_main_device_event,
  },
  {
    "tranche_done",
    "",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_done_event,
  },
  {
    "tranche_target_device",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_target_device_event,
  },
  {
    "tranche_formats",
    "a",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_formats_event,
  },
  {
    "tranche_flags",
    "u",
    zwp_linux_dmabuf_feedback_v1_interface_tranche_flags_event,
  },
};

const wl_interface wayland::detail::zwp_linux_dmabuf_feedback_v1_interface =
  {
    "zwp_linux_dmabuf_feedback_v1",
    4,
    1,
    zwp_linux_dmabuf_feedback_v1_interface_requests,
    7,
    zwp_linux_dmabuf_feedback_v1_interface_events,
  };

const wl_interface* zwp_linux_explicit_synchronization_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_linux_explicit_synchronization_v1_interface_get_synchronization_request[2] = {
  &zwp_linux_surface_synchronization_v1_interface,
  &surface_interface,
};

const wl_message zwp_linux_explicit_synchronization_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_linux_explicit_synchronization_v1_interface_destroy_request,
  },
  {
    "get_synchronization",
    "no",
    zwp_linux_explicit_synchronization_v1_interface_get_synchronization_request,
  },
};

const wl_message zwp_linux_explicit_synchronization_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_linux_explicit_synchronization_v1_interface =
  {
    "zwp_linux_explicit_synchronization_v1",
    2,
    2,
    zwp_linux_explicit_synchronization_v1_interface_requests,
    0,
    zwp_linux_explicit_synchronization_v1_interface_events,
  };

const wl_interface* zwp_linux_surface_synchronization_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_linux_surface_synchronization_v1_interface_set_acquire_fence_request[1] = {
  nullptr,
};

const wl_interface* zwp_linux_surface_synchronization_v1_interface_get_release_request[1] = {
  &zwp_linux_buffer_release_v1_interface,
};

const wl_message zwp_linux_surface_synchronization_v1_interface_requests[3] = {
  {
    "destroy",
    "",
    zwp_linux_surface_synchronization_v1_interface_destroy_request,
  },
  {
    "set_acquire_fence",
    "h",
    zwp_linux_surface_synchronization_v1_interface_set_acquire_fence_request,
  },
  {
    "get_release",
    "n",
    zwp_linux_surface_synchronization_v1_interface_get_release_request,
  },
};

const wl_message zwp_linux_surface_synchronization_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_linux_surface_synchronization_v1_interface =
  {
    "zwp_linux_surface_synchronization_v1",
    2,
    3,
    zwp_linux_surface_synchronization_v1_interface_requests,
    0,
    zwp_linux_surface_synchronization_v1_interface_events,
  };

const wl_interface* zwp_linux_buffer_release_v1_interface_fenced_release_event[1] = {
  nullptr,
};

const wl_interface* zwp_linux_buffer_release_v1_interface_immediate_release_event[0] = {
};

const wl_message zwp_linux_buffer_release_v1_interface_requests[0] = {
};

const wl_message zwp_linux_buffer_release_v1_interface_events[2] = {
  {
    "fenced_release",
    "h",
    zwp_linux_buffer_release_v1_interface_fenced_release_event,
  },
  {
    "immediate_release",
    "",
    zwp_linux_buffer_release_v1_interface_immediate_release_event,
  },
};

const wl_interface wayland::detail::zwp_linux_buffer_release_v1_interface =
  {
    "zwp_linux_buffer_release_v1",
    1,
    0,
    zwp_linux_buffer_release_v1_interface_requests,
    2,
    zwp_linux_buffer_release_v1_interface_events,
  };

const wl_interface* zwp_pointer_constraints_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_pointer_constraints_v1_interface_lock_pointer_request[5] = {
  &zwp_locked_pointer_v1_interface,
  &surface_interface,
  &pointer_interface,
  &region_interface,
  nullptr,
};

const wl_interface* zwp_pointer_constraints_v1_interface_confine_pointer_request[5] = {
  &zwp_confined_pointer_v1_interface,
  &surface_interface,
  &pointer_interface,
  &region_interface,
  nullptr,
};

const wl_message zwp_pointer_constraints_v1_interface_requests[3] = {
  {
    "destroy",
    "",
    zwp_pointer_constraints_v1_interface_destroy_request,
  },
  {
    "lock_pointer",
    "noo?ou",
    zwp_pointer_constraints_v1_interface_lock_pointer_request,
  },
  {
    "confine_pointer",
    "noo?ou",
    zwp_pointer_constraints_v1_interface_confine_pointer_request,
  },
};

const wl_message zwp_pointer_constraints_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_pointer_constraints_v1_interface =
  {
    "zwp_pointer_constraints_v1",
    1,
    3,
    zwp_pointer_constraints_v1_interface_requests,
    0,
    zwp_pointer_constraints_v1_interface_events,
  };

const wl_interface* zwp_locked_pointer_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_locked_pointer_v1_interface_set_cursor_position_hint_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_locked_pointer_v1_interface_set_region_request[1] = {
  &region_interface,
};

const wl_interface* zwp_locked_pointer_v1_interface_locked_event[0] = {
};

const wl_interface* zwp_locked_pointer_v1_interface_unlocked_event[0] = {
};

const wl_message zwp_locked_pointer_v1_interface_requests[3] = {
  {
    "destroy",
    "",
    zwp_locked_pointer_v1_interface_destroy_request,
  },
  {
    "set_cursor_position_hint",
    "ff",
    zwp_locked_pointer_v1_interface_set_cursor_position_hint_request,
  },
  {
    "set_region",
    "?o",
    zwp_locked_pointer_v1_interface_set_region_request,
  },
};

const wl_message zwp_locked_pointer_v1_interface_events[2] = {
  {
    "locked",
    "",
    zwp_locked_pointer_v1_interface_locked_event,
  },
  {
    "unlocked",
    "",
    zwp_locked_pointer_v1_interface_unlocked_event,
  },
};

const wl_interface wayland::detail::zwp_locked_pointer_v1_interface =
  {
    "zwp_locked_pointer_v1",
    1,
    3,
    zwp_locked_pointer_v1_interface_requests,
    2,
    zwp_locked_pointer_v1_interface_events,
  };

const wl_interface* zwp_confined_pointer_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_confined_pointer_v1_interface_set_region_request[1] = {
  &region_interface,
};

const wl_interface* zwp_confined_pointer_v1_interface_confined_event[0] = {
};

const wl_interface* zwp_confined_pointer_v1_interface_unconfined_event[0] = {
};

const wl_message zwp_confined_pointer_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_confined_pointer_v1_interface_destroy_request,
  },
  {
    "set_region",
    "?o",
    zwp_confined_pointer_v1_interface_set_region_request,
  },
};

const wl_message zwp_confined_pointer_v1_interface_events[2] = {
  {
    "confined",
    "",
    zwp_confined_pointer_v1_interface_confined_event,
  },
  {
    "unconfined",
    "",
    zwp_confined_pointer_v1_interface_unconfined_event,
  },
};

const wl_interface wayland::detail::zwp_confined_pointer_v1_interface =
  {
    "zwp_confined_pointer_v1",
    1,
    2,
    zwp_confined_pointer_v1_interface_requests,
    2,
    zwp_confined_pointer_v1_interface_events,
  };

const wl_interface* zwp_pointer_gestures_v1_interface_get_swipe_gesture_request[2] = {
  &zwp_pointer_gesture_swipe_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_pointer_gestures_v1_interface_get_pinch_gesture_request[2] = {
  &zwp_pointer_gesture_pinch_v1_interface,
  &pointer_interface,
};

const wl_interface* zwp_pointer_gestures_v1_interface_release_request[0] = {
};

const wl_interface* zwp_pointer_gestures_v1_interface_get_hold_gesture_request[2] = {
  &zwp_pointer_gesture_hold_v1_interface,
  &pointer_interface,
};

const wl_message zwp_pointer_gestures_v1_interface_requests[4] = {
  {
    "get_swipe_gesture",
    "no",
    zwp_pointer_gestures_v1_interface_get_swipe_gesture_request,
  },
  {
    "get_pinch_gesture",
    "no",
    zwp_pointer_gestures_v1_interface_get_pinch_gesture_request,
  },
  {
    "release",
    "2",
    zwp_pointer_gestures_v1_interface_release_request,
  },
  {
    "get_hold_gesture",
    "3no",
    zwp_pointer_gestures_v1_interface_get_hold_gesture_request,
  },
};

const wl_message zwp_pointer_gestures_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_pointer_gestures_v1_interface =
  {
    "zwp_pointer_gestures_v1",
    3,
    4,
    zwp_pointer_gestures_v1_interface_requests,
    0,
    zwp_pointer_gestures_v1_interface_events,
  };

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_begin_event[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_update_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_swipe_v1_interface_end_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_swipe_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_pointer_gesture_swipe_v1_interface_destroy_request,
  },
};

const wl_message zwp_pointer_gesture_swipe_v1_interface_events[3] = {
  {
    "begin",
    "uuou",
    zwp_pointer_gesture_swipe_v1_interface_begin_event,
  },
  {
    "update",
    "uff",
    zwp_pointer_gesture_swipe_v1_interface_update_event,
  },
  {
    "end",
    "uui",
    zwp_pointer_gesture_swipe_v1_interface_end_event,
  },
};

const wl_interface wayland::detail::zwp_pointer_gesture_swipe_v1_interface =
  {
    "zwp_pointer_gesture_swipe_v1",
    2,
    1,
    zwp_pointer_gesture_swipe_v1_interface_requests,
    3,
    zwp_pointer_gesture_swipe_v1_interface_events,
  };

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_begin_event[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_update_event[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_pinch_v1_interface_end_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_pinch_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_pointer_gesture_pinch_v1_interface_destroy_request,
  },
};

const wl_message zwp_pointer_gesture_pinch_v1_interface_events[3] = {
  {
    "begin",
    "uuou",
    zwp_pointer_gesture_pinch_v1_interface_begin_event,
  },
  {
    "update",
    "uffff",
    zwp_pointer_gesture_pinch_v1_interface_update_event,
  },
  {
    "end",
    "uui",
    zwp_pointer_gesture_pinch_v1_interface_end_event,
  },
};

const wl_interface wayland::detail::zwp_pointer_gesture_pinch_v1_interface =
  {
    "zwp_pointer_gesture_pinch_v1",
    2,
    1,
    zwp_pointer_gesture_pinch_v1_interface_requests,
    3,
    zwp_pointer_gesture_pinch_v1_interface_events,
  };

const wl_interface* zwp_pointer_gesture_hold_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_pointer_gesture_hold_v1_interface_begin_event[4] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* zwp_pointer_gesture_hold_v1_interface_end_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_pointer_gesture_hold_v1_interface_requests[1] = {
  {
    "destroy",
    "3",
    zwp_pointer_gesture_hold_v1_interface_destroy_request,
  },
};

const wl_message zwp_pointer_gesture_hold_v1_interface_events[2] = {
  {
    "begin",
    "3uuou",
    zwp_pointer_gesture_hold_v1_interface_begin_event,
  },
  {
    "end",
    "3uui",
    zwp_pointer_gesture_hold_v1_interface_end_event,
  },
};

const wl_interface wayland::detail::zwp_pointer_gesture_hold_v1_interface =
  {
    "zwp_pointer_gesture_hold_v1",
    3,
    1,
    zwp_pointer_gesture_hold_v1_interface_requests,
    2,
    zwp_pointer_gesture_hold_v1_interface_events,
  };

const wl_interface* zwp_primary_selection_device_manager_v1_interface_create_source_request[1] = {
  &zwp_primary_selection_source_v1_interface,
};

const wl_interface* zwp_primary_selection_device_manager_v1_interface_get_device_request[2] = {
  &zwp_primary_selection_device_v1_interface,
  &seat_interface,
};

const wl_interface* zwp_primary_selection_device_manager_v1_interface_destroy_request[0] = {
};

const wl_message zwp_primary_selection_device_manager_v1_interface_requests[3] = {
  {
    "create_source",
    "n",
    zwp_primary_selection_device_manager_v1_interface_create_source_request,
  },
  {
    "get_device",
    "no",
    zwp_primary_selection_device_manager_v1_interface_get_device_request,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_device_manager_v1_interface_destroy_request,
  },
};

const wl_message zwp_primary_selection_device_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_primary_selection_device_manager_v1_interface =
  {
    "zwp_primary_selection_device_manager_v1",
    1,
    3,
    zwp_primary_selection_device_manager_v1_interface_requests,
    0,
    zwp_primary_selection_device_manager_v1_interface_events,
  };

const wl_interface* zwp_primary_selection_device_v1_interface_set_selection_request[2] = {
  &zwp_primary_selection_source_v1_interface,
  nullptr,
};

const wl_interface* zwp_primary_selection_device_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_primary_selection_device_v1_interface_data_offer_event[1] = {
  &zwp_primary_selection_offer_v1_interface,
};

const wl_interface* zwp_primary_selection_device_v1_interface_selection_event[1] = {
  &zwp_primary_selection_offer_v1_interface,
};

const wl_message zwp_primary_selection_device_v1_interface_requests[2] = {
  {
    "set_selection",
    "?ou",
    zwp_primary_selection_device_v1_interface_set_selection_request,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_device_v1_interface_destroy_request,
  },
};

const wl_message zwp_primary_selection_device_v1_interface_events[2] = {
  {
    "data_offer",
    "n",
    zwp_primary_selection_device_v1_interface_data_offer_event,
  },
  {
    "selection",
    "?o",
    zwp_primary_selection_device_v1_interface_selection_event,
  },
};

const wl_interface wayland::detail::zwp_primary_selection_device_v1_interface =
  {
    "zwp_primary_selection_device_v1",
    1,
    2,
    zwp_primary_selection_device_v1_interface_requests,
    2,
    zwp_primary_selection_device_v1_interface_events,
  };

const wl_interface* zwp_primary_selection_offer_v1_interface_receive_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_primary_selection_offer_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_primary_selection_offer_v1_interface_offer_event[1] = {
  nullptr,
};

const wl_message zwp_primary_selection_offer_v1_interface_requests[2] = {
  {
    "receive",
    "sh",
    zwp_primary_selection_offer_v1_interface_receive_request,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_offer_v1_interface_destroy_request,
  },
};

const wl_message zwp_primary_selection_offer_v1_interface_events[1] = {
  {
    "offer",
    "s",
    zwp_primary_selection_offer_v1_interface_offer_event,
  },
};

const wl_interface wayland::detail::zwp_primary_selection_offer_v1_interface =
  {
    "zwp_primary_selection_offer_v1",
    1,
    2,
    zwp_primary_selection_offer_v1_interface_requests,
    1,
    zwp_primary_selection_offer_v1_interface_events,
  };

const wl_interface* zwp_primary_selection_source_v1_interface_offer_request[1] = {
  nullptr,
};

const wl_interface* zwp_primary_selection_source_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_primary_selection_source_v1_interface_send_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_primary_selection_source_v1_interface_cancelled_event[0] = {
};

const wl_message zwp_primary_selection_source_v1_interface_requests[2] = {
  {
    "offer",
    "s",
    zwp_primary_selection_source_v1_interface_offer_request,
  },
  {
    "destroy",
    "",
    zwp_primary_selection_source_v1_interface_destroy_request,
  },
};

const wl_message zwp_primary_selection_source_v1_interface_events[2] = {
  {
    "send",
    "sh",
    zwp_primary_selection_source_v1_interface_send_event,
  },
  {
    "cancelled",
    "",
    zwp_primary_selection_source_v1_interface_cancelled_event,
  },
};

const wl_interface wayland::detail::zwp_primary_selection_source_v1_interface =
  {
    "zwp_primary_selection_source_v1",
    1,
    2,
    zwp_primary_selection_source_v1_interface_requests,
    2,
    zwp_primary_selection_source_v1_interface_events,
  };

const wl_interface* zwp_relative_pointer_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_relative_pointer_manager_v1_interface_get_relative_pointer_request[2] = {
  &zwp_relative_pointer_v1_interface,
  &pointer_interface,
};

const wl_message zwp_relative_pointer_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_relative_pointer_manager_v1_interface_destroy_request,
  },
  {
    "get_relative_pointer",
    "no",
    zwp_relative_pointer_manager_v1_interface_get_relative_pointer_request,
  },
};

const wl_message zwp_relative_pointer_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_relative_pointer_manager_v1_interface =
  {
    "zwp_relative_pointer_manager_v1",
    1,
    2,
    zwp_relative_pointer_manager_v1_interface_requests,
    0,
    zwp_relative_pointer_manager_v1_interface_events,
  };

const wl_interface* zwp_relative_pointer_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_relative_pointer_v1_interface_relative_motion_event[6] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_relative_pointer_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_relative_pointer_v1_interface_destroy_request,
  },
};

const wl_message zwp_relative_pointer_v1_interface_events[1] = {
  {
    "relative_motion",
    "uuffff",
    zwp_relative_pointer_v1_interface_relative_motion_event,
  },
};

const wl_interface wayland::detail::zwp_relative_pointer_v1_interface =
  {
    "zwp_relative_pointer_v1",
    1,
    1,
    zwp_relative_pointer_v1_interface_requests,
    1,
    zwp_relative_pointer_v1_interface_events,
  };

const wl_interface* zwp_tablet_manager_v1_interface_get_tablet_seat_request[2] = {
  &zwp_tablet_seat_v1_interface,
  &seat_interface,
};

const wl_interface* zwp_tablet_manager_v1_interface_destroy_request[0] = {
};

const wl_message zwp_tablet_manager_v1_interface_requests[2] = {
  {
    "get_tablet_seat",
    "no",
    zwp_tablet_manager_v1_interface_get_tablet_seat_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_manager_v1_interface_destroy_request,
  },
};

const wl_message zwp_tablet_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_tablet_manager_v1_interface =
  {
    "zwp_tablet_manager_v1",
    1,
    2,
    zwp_tablet_manager_v1_interface_requests,
    0,
    zwp_tablet_manager_v1_interface_events,
  };

const wl_interface* zwp_tablet_seat_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_seat_v1_interface_tablet_added_event[1] = {
  &zwp_tablet_v1_interface,
};

const wl_interface* zwp_tablet_seat_v1_interface_tool_added_event[1] = {
  &zwp_tablet_tool_v1_interface,
};

const wl_message zwp_tablet_seat_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_tablet_seat_v1_interface_destroy_request,
  },
};

const wl_message zwp_tablet_seat_v1_interface_events[2] = {
  {
    "tablet_added",
    "n",
    zwp_tablet_seat_v1_interface_tablet_added_event,
  },
  {
    "tool_added",
    "n",
    zwp_tablet_seat_v1_interface_tool_added_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_seat_v1_interface =
  {
    "zwp_tablet_seat_v1",
    1,
    1,
    zwp_tablet_seat_v1_interface_requests,
    2,
    zwp_tablet_seat_v1_interface_events,
  };

const wl_interface* zwp_tablet_tool_v1_interface_set_cursor_request[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_type_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_hardware_serial_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_hardware_id_wacom_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_capability_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_removed_event[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_proximity_in_event[3] = {
  nullptr,
  &zwp_tablet_v1_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_tool_v1_interface_proximity_out_event[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_down_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_up_event[0] = {
};

const wl_interface* zwp_tablet_tool_v1_interface_motion_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_pressure_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_distance_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_tilt_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_rotation_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_slider_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_wheel_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_button_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v1_interface_frame_event[1] = {
  nullptr,
};

const wl_message zwp_tablet_tool_v1_interface_requests[2] = {
  {
    "set_cursor",
    "u?oii",
    zwp_tablet_tool_v1_interface_set_cursor_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_tool_v1_interface_destroy_request,
  },
};

const wl_message zwp_tablet_tool_v1_interface_events[19] = {
  {
    "type",
    "u",
    zwp_tablet_tool_v1_interface_type_event,
  },
  {
    "hardware_serial",
    "uu",
    zwp_tablet_tool_v1_interface_hardware_serial_event,
  },
  {
    "hardware_id_wacom",
    "uu",
    zwp_tablet_tool_v1_interface_hardware_id_wacom_event,
  },
  {
    "capability",
    "u",
    zwp_tablet_tool_v1_interface_capability_event,
  },
  {
    "done",
    "",
    zwp_tablet_tool_v1_interface_done_event,
  },
  {
    "removed",
    "",
    zwp_tablet_tool_v1_interface_removed_event,
  },
  {
    "proximity_in",
    "uoo",
    zwp_tablet_tool_v1_interface_proximity_in_event,
  },
  {
    "proximity_out",
    "",
    zwp_tablet_tool_v1_interface_proximity_out_event,
  },
  {
    "down",
    "u",
    zwp_tablet_tool_v1_interface_down_event,
  },
  {
    "up",
    "",
    zwp_tablet_tool_v1_interface_up_event,
  },
  {
    "motion",
    "ff",
    zwp_tablet_tool_v1_interface_motion_event,
  },
  {
    "pressure",
    "u",
    zwp_tablet_tool_v1_interface_pressure_event,
  },
  {
    "distance",
    "u",
    zwp_tablet_tool_v1_interface_distance_event,
  },
  {
    "tilt",
    "ii",
    zwp_tablet_tool_v1_interface_tilt_event,
  },
  {
    "rotation",
    "i",
    zwp_tablet_tool_v1_interface_rotation_event,
  },
  {
    "slider",
    "i",
    zwp_tablet_tool_v1_interface_slider_event,
  },
  {
    "wheel",
    "ii",
    zwp_tablet_tool_v1_interface_wheel_event,
  },
  {
    "button",
    "uuu",
    zwp_tablet_tool_v1_interface_button_event,
  },
  {
    "frame",
    "u",
    zwp_tablet_tool_v1_interface_frame_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_tool_v1_interface =
  {
    "zwp_tablet_tool_v1",
    1,
    2,
    zwp_tablet_tool_v1_interface_requests,
    19,
    zwp_tablet_tool_v1_interface_events,
  };

const wl_interface* zwp_tablet_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_v1_interface_name_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_id_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_path_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v1_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_v1_interface_removed_event[0] = {
};

const wl_message zwp_tablet_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_tablet_v1_interface_destroy_request,
  },
};

const wl_message zwp_tablet_v1_interface_events[5] = {
  {
    "name",
    "s",
    zwp_tablet_v1_interface_name_event,
  },
  {
    "id",
    "uu",
    zwp_tablet_v1_interface_id_event,
  },
  {
    "path",
    "s",
    zwp_tablet_v1_interface_path_event,
  },
  {
    "done",
    "",
    zwp_tablet_v1_interface_done_event,
  },
  {
    "removed",
    "",
    zwp_tablet_v1_interface_removed_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_v1_interface =
  {
    "zwp_tablet_v1",
    1,
    1,
    zwp_tablet_v1_interface_requests,
    5,
    zwp_tablet_v1_interface_events,
  };

const wl_interface* zwp_tablet_manager_v2_interface_get_tablet_seat_request[2] = {
  &zwp_tablet_seat_v2_interface,
  &seat_interface,
};

const wl_interface* zwp_tablet_manager_v2_interface_destroy_request[0] = {
};

const wl_message zwp_tablet_manager_v2_interface_requests[2] = {
  {
    "get_tablet_seat",
    "no",
    zwp_tablet_manager_v2_interface_get_tablet_seat_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_manager_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_manager_v2_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_tablet_manager_v2_interface =
  {
    "zwp_tablet_manager_v2",
    1,
    2,
    zwp_tablet_manager_v2_interface_requests,
    0,
    zwp_tablet_manager_v2_interface_events,
  };

const wl_interface* zwp_tablet_seat_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_seat_v2_interface_tablet_added_event[1] = {
  &zwp_tablet_v2_interface,
};

const wl_interface* zwp_tablet_seat_v2_interface_tool_added_event[1] = {
  &zwp_tablet_tool_v2_interface,
};

const wl_interface* zwp_tablet_seat_v2_interface_pad_added_event[1] = {
  &zwp_tablet_pad_v2_interface,
};

const wl_message zwp_tablet_seat_v2_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_tablet_seat_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_seat_v2_interface_events[3] = {
  {
    "tablet_added",
    "n",
    zwp_tablet_seat_v2_interface_tablet_added_event,
  },
  {
    "tool_added",
    "n",
    zwp_tablet_seat_v2_interface_tool_added_event,
  },
  {
    "pad_added",
    "n",
    zwp_tablet_seat_v2_interface_pad_added_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_seat_v2_interface =
  {
    "zwp_tablet_seat_v2",
    1,
    1,
    zwp_tablet_seat_v2_interface_requests,
    3,
    zwp_tablet_seat_v2_interface_events,
  };

const wl_interface* zwp_tablet_tool_v2_interface_set_cursor_request[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_type_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_hardware_serial_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_hardware_id_wacom_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_capability_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_removed_event[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_proximity_in_event[3] = {
  nullptr,
  &zwp_tablet_v2_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_tool_v2_interface_proximity_out_event[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_down_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_up_event[0] = {
};

const wl_interface* zwp_tablet_tool_v2_interface_motion_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_pressure_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_distance_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_tilt_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_rotation_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_slider_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_wheel_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_button_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_tool_v2_interface_frame_event[1] = {
  nullptr,
};

const wl_message zwp_tablet_tool_v2_interface_requests[2] = {
  {
    "set_cursor",
    "u?oii",
    zwp_tablet_tool_v2_interface_set_cursor_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_tool_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_tool_v2_interface_events[19] = {
  {
    "type",
    "u",
    zwp_tablet_tool_v2_interface_type_event,
  },
  {
    "hardware_serial",
    "uu",
    zwp_tablet_tool_v2_interface_hardware_serial_event,
  },
  {
    "hardware_id_wacom",
    "uu",
    zwp_tablet_tool_v2_interface_hardware_id_wacom_event,
  },
  {
    "capability",
    "u",
    zwp_tablet_tool_v2_interface_capability_event,
  },
  {
    "done",
    "",
    zwp_tablet_tool_v2_interface_done_event,
  },
  {
    "removed",
    "",
    zwp_tablet_tool_v2_interface_removed_event,
  },
  {
    "proximity_in",
    "uoo",
    zwp_tablet_tool_v2_interface_proximity_in_event,
  },
  {
    "proximity_out",
    "",
    zwp_tablet_tool_v2_interface_proximity_out_event,
  },
  {
    "down",
    "u",
    zwp_tablet_tool_v2_interface_down_event,
  },
  {
    "up",
    "",
    zwp_tablet_tool_v2_interface_up_event,
  },
  {
    "motion",
    "ff",
    zwp_tablet_tool_v2_interface_motion_event,
  },
  {
    "pressure",
    "u",
    zwp_tablet_tool_v2_interface_pressure_event,
  },
  {
    "distance",
    "u",
    zwp_tablet_tool_v2_interface_distance_event,
  },
  {
    "tilt",
    "ff",
    zwp_tablet_tool_v2_interface_tilt_event,
  },
  {
    "rotation",
    "f",
    zwp_tablet_tool_v2_interface_rotation_event,
  },
  {
    "slider",
    "i",
    zwp_tablet_tool_v2_interface_slider_event,
  },
  {
    "wheel",
    "fi",
    zwp_tablet_tool_v2_interface_wheel_event,
  },
  {
    "button",
    "uuu",
    zwp_tablet_tool_v2_interface_button_event,
  },
  {
    "frame",
    "u",
    zwp_tablet_tool_v2_interface_frame_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_tool_v2_interface =
  {
    "zwp_tablet_tool_v2",
    1,
    2,
    zwp_tablet_tool_v2_interface_requests,
    19,
    zwp_tablet_tool_v2_interface_events,
  };

const wl_interface* zwp_tablet_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_v2_interface_name_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_id_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_path_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_v2_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_v2_interface_removed_event[0] = {
};

const wl_message zwp_tablet_v2_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_tablet_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_v2_interface_events[5] = {
  {
    "name",
    "s",
    zwp_tablet_v2_interface_name_event,
  },
  {
    "id",
    "uu",
    zwp_tablet_v2_interface_id_event,
  },
  {
    "path",
    "s",
    zwp_tablet_v2_interface_path_event,
  },
  {
    "done",
    "",
    zwp_tablet_v2_interface_done_event,
  },
  {
    "removed",
    "",
    zwp_tablet_v2_interface_removed_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_v2_interface =
  {
    "zwp_tablet_v2",
    1,
    1,
    zwp_tablet_v2_interface_requests,
    5,
    zwp_tablet_v2_interface_events,
  };

const wl_interface* zwp_tablet_pad_ring_v2_interface_set_feedback_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_source_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_angle_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_stop_event[0] = {
};

const wl_interface* zwp_tablet_pad_ring_v2_interface_frame_event[1] = {
  nullptr,
};

const wl_message zwp_tablet_pad_ring_v2_interface_requests[2] = {
  {
    "set_feedback",
    "su",
    zwp_tablet_pad_ring_v2_interface_set_feedback_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_ring_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_pad_ring_v2_interface_events[4] = {
  {
    "source",
    "u",
    zwp_tablet_pad_ring_v2_interface_source_event,
  },
  {
    "angle",
    "f",
    zwp_tablet_pad_ring_v2_interface_angle_event,
  },
  {
    "stop",
    "",
    zwp_tablet_pad_ring_v2_interface_stop_event,
  },
  {
    "frame",
    "u",
    zwp_tablet_pad_ring_v2_interface_frame_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_pad_ring_v2_interface =
  {
    "zwp_tablet_pad_ring_v2",
    1,
    2,
    zwp_tablet_pad_ring_v2_interface_requests,
    4,
    zwp_tablet_pad_ring_v2_interface_events,
  };

const wl_interface* zwp_tablet_pad_strip_v2_interface_set_feedback_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_source_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_position_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_stop_event[0] = {
};

const wl_interface* zwp_tablet_pad_strip_v2_interface_frame_event[1] = {
  nullptr,
};

const wl_message zwp_tablet_pad_strip_v2_interface_requests[2] = {
  {
    "set_feedback",
    "su",
    zwp_tablet_pad_strip_v2_interface_set_feedback_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_strip_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_pad_strip_v2_interface_events[4] = {
  {
    "source",
    "u",
    zwp_tablet_pad_strip_v2_interface_source_event,
  },
  {
    "position",
    "u",
    zwp_tablet_pad_strip_v2_interface_position_event,
  },
  {
    "stop",
    "",
    zwp_tablet_pad_strip_v2_interface_stop_event,
  },
  {
    "frame",
    "u",
    zwp_tablet_pad_strip_v2_interface_frame_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_pad_strip_v2_interface =
  {
    "zwp_tablet_pad_strip_v2",
    1,
    2,
    zwp_tablet_pad_strip_v2_interface_requests,
    4,
    zwp_tablet_pad_strip_v2_interface_events,
  };

const wl_interface* zwp_tablet_pad_group_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_pad_group_v2_interface_buttons_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_ring_event[1] = {
  &zwp_tablet_pad_ring_v2_interface,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_strip_event[1] = {
  &zwp_tablet_pad_strip_v2_interface,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_modes_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_group_v2_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_pad_group_v2_interface_mode_switch_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_message zwp_tablet_pad_group_v2_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_tablet_pad_group_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_pad_group_v2_interface_events[6] = {
  {
    "buttons",
    "a",
    zwp_tablet_pad_group_v2_interface_buttons_event,
  },
  {
    "ring",
    "n",
    zwp_tablet_pad_group_v2_interface_ring_event,
  },
  {
    "strip",
    "n",
    zwp_tablet_pad_group_v2_interface_strip_event,
  },
  {
    "modes",
    "u",
    zwp_tablet_pad_group_v2_interface_modes_event,
  },
  {
    "done",
    "",
    zwp_tablet_pad_group_v2_interface_done_event,
  },
  {
    "mode_switch",
    "uuu",
    zwp_tablet_pad_group_v2_interface_mode_switch_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_pad_group_v2_interface =
  {
    "zwp_tablet_pad_group_v2",
    1,
    1,
    zwp_tablet_pad_group_v2_interface_requests,
    6,
    zwp_tablet_pad_group_v2_interface_events,
  };

const wl_interface* zwp_tablet_pad_v2_interface_set_feedback_request[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_destroy_request[0] = {
};

const wl_interface* zwp_tablet_pad_v2_interface_group_event[1] = {
  &zwp_tablet_pad_group_v2_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_path_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_buttons_event[1] = {
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_done_event[0] = {
};

const wl_interface* zwp_tablet_pad_v2_interface_button_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_tablet_pad_v2_interface_enter_event[3] = {
  nullptr,
  &zwp_tablet_v2_interface,
  &surface_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_leave_event[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* zwp_tablet_pad_v2_interface_removed_event[0] = {
};

const wl_message zwp_tablet_pad_v2_interface_requests[2] = {
  {
    "set_feedback",
    "usu",
    zwp_tablet_pad_v2_interface_set_feedback_request,
  },
  {
    "destroy",
    "",
    zwp_tablet_pad_v2_interface_destroy_request,
  },
};

const wl_message zwp_tablet_pad_v2_interface_events[8] = {
  {
    "group",
    "n",
    zwp_tablet_pad_v2_interface_group_event,
  },
  {
    "path",
    "s",
    zwp_tablet_pad_v2_interface_path_event,
  },
  {
    "buttons",
    "u",
    zwp_tablet_pad_v2_interface_buttons_event,
  },
  {
    "done",
    "",
    zwp_tablet_pad_v2_interface_done_event,
  },
  {
    "button",
    "uuu",
    zwp_tablet_pad_v2_interface_button_event,
  },
  {
    "enter",
    "uoo",
    zwp_tablet_pad_v2_interface_enter_event,
  },
  {
    "leave",
    "uo",
    zwp_tablet_pad_v2_interface_leave_event,
  },
  {
    "removed",
    "",
    zwp_tablet_pad_v2_interface_removed_event,
  },
};

const wl_interface wayland::detail::zwp_tablet_pad_v2_interface =
  {
    "zwp_tablet_pad_v2",
    1,
    2,
    zwp_tablet_pad_v2_interface_requests,
    8,
    zwp_tablet_pad_v2_interface_events,
  };

const wl_interface* zwp_text_input_v1_interface_activate_request[2] = {
  &seat_interface,
  &surface_interface,
};

const wl_interface* zwp_text_input_v1_interface_deactivate_request[1] = {
  &seat_interface,
};

const wl_interface* zwp_text_input_v1_interface_show_input_panel_request[0] = {
};

const wl_interface* zwp_text_input_v1_interface_hide_input_panel_request[0] = {
};

const wl_interface* zwp_text_input_v1_interface_reset_request[0] = {
};

const wl_interface* zwp_text_input_v1_interface_set_surrounding_text_request[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_content_type_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_cursor_rectangle_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_set_preferred_language_request[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_commit_state_request[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_invoke_action_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_enter_event[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v1_interface_leave_event[0] = {
};

const wl_interface* zwp_text_input_v1_interface_modifiers_map_event[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_input_panel_state_event[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_string_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_styling_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_preedit_cursor_event[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_commit_string_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_cursor_position_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_delete_surrounding_text_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_keysym_event[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_language_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v1_interface_text_direction_event[2] = {
  nullptr,
  nullptr,
};

const wl_message zwp_text_input_v1_interface_requests[11] = {
  {
    "activate",
    "oo",
    zwp_text_input_v1_interface_activate_request,
  },
  {
    "deactivate",
    "o",
    zwp_text_input_v1_interface_deactivate_request,
  },
  {
    "show_input_panel",
    "",
    zwp_text_input_v1_interface_show_input_panel_request,
  },
  {
    "hide_input_panel",
    "",
    zwp_text_input_v1_interface_hide_input_panel_request,
  },
  {
    "reset",
    "",
    zwp_text_input_v1_interface_reset_request,
  },
  {
    "set_surrounding_text",
    "suu",
    zwp_text_input_v1_interface_set_surrounding_text_request,
  },
  {
    "set_content_type",
    "uu",
    zwp_text_input_v1_interface_set_content_type_request,
  },
  {
    "set_cursor_rectangle",
    "iiii",
    zwp_text_input_v1_interface_set_cursor_rectangle_request,
  },
  {
    "set_preferred_language",
    "s",
    zwp_text_input_v1_interface_set_preferred_language_request,
  },
  {
    "commit_state",
    "u",
    zwp_text_input_v1_interface_commit_state_request,
  },
  {
    "invoke_action",
    "uu",
    zwp_text_input_v1_interface_invoke_action_request,
  },
};

const wl_message zwp_text_input_v1_interface_events[13] = {
  {
    "enter",
    "o",
    zwp_text_input_v1_interface_enter_event,
  },
  {
    "leave",
    "",
    zwp_text_input_v1_interface_leave_event,
  },
  {
    "modifiers_map",
    "a",
    zwp_text_input_v1_interface_modifiers_map_event,
  },
  {
    "input_panel_state",
    "u",
    zwp_text_input_v1_interface_input_panel_state_event,
  },
  {
    "preedit_string",
    "uss",
    zwp_text_input_v1_interface_preedit_string_event,
  },
  {
    "preedit_styling",
    "uuu",
    zwp_text_input_v1_interface_preedit_styling_event,
  },
  {
    "preedit_cursor",
    "i",
    zwp_text_input_v1_interface_preedit_cursor_event,
  },
  {
    "commit_string",
    "us",
    zwp_text_input_v1_interface_commit_string_event,
  },
  {
    "cursor_position",
    "ii",
    zwp_text_input_v1_interface_cursor_position_event,
  },
  {
    "delete_surrounding_text",
    "iu",
    zwp_text_input_v1_interface_delete_surrounding_text_event,
  },
  {
    "keysym",
    "uuuuu",
    zwp_text_input_v1_interface_keysym_event,
  },
  {
    "language",
    "us",
    zwp_text_input_v1_interface_language_event,
  },
  {
    "text_direction",
    "uu",
    zwp_text_input_v1_interface_text_direction_event,
  },
};

const wl_interface wayland::detail::zwp_text_input_v1_interface =
  {
    "zwp_text_input_v1",
    1,
    11,
    zwp_text_input_v1_interface_requests,
    13,
    zwp_text_input_v1_interface_events,
  };

const wl_interface* zwp_text_input_manager_v1_interface_create_text_input_request[1] = {
  &zwp_text_input_v1_interface,
};

const wl_message zwp_text_input_manager_v1_interface_requests[1] = {
  {
    "create_text_input",
    "n",
    zwp_text_input_manager_v1_interface_create_text_input_request,
  },
};

const wl_message zwp_text_input_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_text_input_manager_v1_interface =
  {
    "zwp_text_input_manager_v1",
    1,
    1,
    zwp_text_input_manager_v1_interface_requests,
    0,
    zwp_text_input_manager_v1_interface_events,
  };

const wl_interface* zwp_text_input_v3_interface_destroy_request[0] = {
};

const wl_interface* zwp_text_input_v3_interface_enable_request[0] = {
};

const wl_interface* zwp_text_input_v3_interface_disable_request[0] = {
};

const wl_interface* zwp_text_input_v3_interface_set_surrounding_text_request[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_text_change_cause_request[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_content_type_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_set_cursor_rectangle_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_commit_request[0] = {
};

const wl_interface* zwp_text_input_v3_interface_enter_event[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v3_interface_leave_event[1] = {
  &surface_interface,
};

const wl_interface* zwp_text_input_v3_interface_preedit_string_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_commit_string_event[1] = {
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_delete_surrounding_text_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zwp_text_input_v3_interface_done_event[1] = {
  nullptr,
};

const wl_message zwp_text_input_v3_interface_requests[8] = {
  {
    "destroy",
    "",
    zwp_text_input_v3_interface_destroy_request,
  },
  {
    "enable",
    "",
    zwp_text_input_v3_interface_enable_request,
  },
  {
    "disable",
    "",
    zwp_text_input_v3_interface_disable_request,
  },
  {
    "set_surrounding_text",
    "sii",
    zwp_text_input_v3_interface_set_surrounding_text_request,
  },
  {
    "set_text_change_cause",
    "u",
    zwp_text_input_v3_interface_set_text_change_cause_request,
  },
  {
    "set_content_type",
    "uu",
    zwp_text_input_v3_interface_set_content_type_request,
  },
  {
    "set_cursor_rectangle",
    "iiii",
    zwp_text_input_v3_interface_set_cursor_rectangle_request,
  },
  {
    "commit",
    "",
    zwp_text_input_v3_interface_commit_request,
  },
};

const wl_message zwp_text_input_v3_interface_events[6] = {
  {
    "enter",
    "o",
    zwp_text_input_v3_interface_enter_event,
  },
  {
    "leave",
    "o",
    zwp_text_input_v3_interface_leave_event,
  },
  {
    "preedit_string",
    "?sii",
    zwp_text_input_v3_interface_preedit_string_event,
  },
  {
    "commit_string",
    "?s",
    zwp_text_input_v3_interface_commit_string_event,
  },
  {
    "delete_surrounding_text",
    "uu",
    zwp_text_input_v3_interface_delete_surrounding_text_event,
  },
  {
    "done",
    "u",
    zwp_text_input_v3_interface_done_event,
  },
};

const wl_interface wayland::detail::zwp_text_input_v3_interface =
  {
    "zwp_text_input_v3",
    1,
    8,
    zwp_text_input_v3_interface_requests,
    6,
    zwp_text_input_v3_interface_events,
  };

const wl_interface* zwp_text_input_manager_v3_interface_destroy_request[0] = {
};

const wl_interface* zwp_text_input_manager_v3_interface_get_text_input_request[2] = {
  &zwp_text_input_v3_interface,
  &seat_interface,
};

const wl_message zwp_text_input_manager_v3_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_text_input_manager_v3_interface_destroy_request,
  },
  {
    "get_text_input",
    "no",
    zwp_text_input_manager_v3_interface_get_text_input_request,
  },
};

const wl_message zwp_text_input_manager_v3_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_text_input_manager_v3_interface =
  {
    "zwp_text_input_manager_v3",
    1,
    2,
    zwp_text_input_manager_v3_interface_requests,
    0,
    zwp_text_input_manager_v3_interface_events,
  };

const wl_interface* xdg_activation_v1_interface_destroy_request[0] = {
};

const wl_interface* xdg_activation_v1_interface_get_activation_token_request[1] = {
  &xdg_activation_token_v1_interface,
};

const wl_interface* xdg_activation_v1_interface_activate_request[2] = {
  nullptr,
  &surface_interface,
};

const wl_message xdg_activation_v1_interface_requests[3] = {
  {
    "destroy",
    "",
    xdg_activation_v1_interface_destroy_request,
  },
  {
    "get_activation_token",
    "n",
    xdg_activation_v1_interface_get_activation_token_request,
  },
  {
    "activate",
    "so",
    xdg_activation_v1_interface_activate_request,
  },
};

const wl_message xdg_activation_v1_interface_events[0] = {
};

const wl_interface wayland::detail::xdg_activation_v1_interface =
  {
    "xdg_activation_v1",
    1,
    3,
    xdg_activation_v1_interface_requests,
    0,
    xdg_activation_v1_interface_events,
  };

const wl_interface* xdg_activation_token_v1_interface_set_serial_request[2] = {
  nullptr,
  &seat_interface,
};

const wl_interface* xdg_activation_token_v1_interface_set_app_id_request[1] = {
  nullptr,
};

const wl_interface* xdg_activation_token_v1_interface_set_surface_request[1] = {
  &surface_interface,
};

const wl_interface* xdg_activation_token_v1_interface_commit_request[0] = {
};

const wl_interface* xdg_activation_token_v1_interface_destroy_request[0] = {
};

const wl_interface* xdg_activation_token_v1_interface_done_event[1] = {
  nullptr,
};

const wl_message xdg_activation_token_v1_interface_requests[5] = {
  {
    "set_serial",
    "uo",
    xdg_activation_token_v1_interface_set_serial_request,
  },
  {
    "set_app_id",
    "s",
    xdg_activation_token_v1_interface_set_app_id_request,
  },
  {
    "set_surface",
    "o",
    xdg_activation_token_v1_interface_set_surface_request,
  },
  {
    "commit",
    "",
    xdg_activation_token_v1_interface_commit_request,
  },
  {
    "destroy",
    "",
    xdg_activation_token_v1_interface_destroy_request,
  },
};

const wl_message xdg_activation_token_v1_interface_events[1] = {
  {
    "done",
    "s",
    xdg_activation_token_v1_interface_done_event,
  },
};

const wl_interface wayland::detail::xdg_activation_token_v1_interface =
  {
    "xdg_activation_token_v1",
    1,
    5,
    xdg_activation_token_v1_interface_requests,
    1,
    xdg_activation_token_v1_interface_events,
  };

const wl_interface* zxdg_decoration_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_decoration_manager_v1_interface_get_toplevel_decoration_request[2] = {
  &zxdg_toplevel_decoration_v1_interface,
  &xdg_toplevel_interface,
};

const wl_message zxdg_decoration_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_decoration_manager_v1_interface_destroy_request,
  },
  {
    "get_toplevel_decoration",
    "no",
    zxdg_decoration_manager_v1_interface_get_toplevel_decoration_request,
  },
};

const wl_message zxdg_decoration_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_decoration_manager_v1_interface =
  {
    "zxdg_decoration_manager_v1",
    1,
    2,
    zxdg_decoration_manager_v1_interface_requests,
    0,
    zxdg_decoration_manager_v1_interface_events,
  };

const wl_interface* zxdg_toplevel_decoration_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_set_mode_request[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_unset_mode_request[0] = {
};

const wl_interface* zxdg_toplevel_decoration_v1_interface_configure_event[1] = {
  nullptr,
};

const wl_message zxdg_toplevel_decoration_v1_interface_requests[3] = {
  {
    "destroy",
    "",
    zxdg_toplevel_decoration_v1_interface_destroy_request,
  },
  {
    "set_mode",
    "u",
    zxdg_toplevel_decoration_v1_interface_set_mode_request,
  },
  {
    "unset_mode",
    "",
    zxdg_toplevel_decoration_v1_interface_unset_mode_request,
  },
};

const wl_message zxdg_toplevel_decoration_v1_interface_events[1] = {
  {
    "configure",
    "u",
    zxdg_toplevel_decoration_v1_interface_configure_event,
  },
};

const wl_interface wayland::detail::zxdg_toplevel_decoration_v1_interface =
  {
    "zxdg_toplevel_decoration_v1",
    1,
    3,
    zxdg_toplevel_decoration_v1_interface_requests,
    1,
    zxdg_toplevel_decoration_v1_interface_events,
  };

const wl_interface* zxdg_exporter_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_exporter_v1_interface_export_request[2] = {
  &zxdg_exported_v1_interface,
  &surface_interface,
};

const wl_message zxdg_exporter_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_exporter_v1_interface_destroy_request,
  },
  {
    "export",
    "no",
    zxdg_exporter_v1_interface_export_request,
  },
};

const wl_message zxdg_exporter_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_exporter_v1_interface =
  {
    "zxdg_exporter_v1",
    1,
    2,
    zxdg_exporter_v1_interface_requests,
    0,
    zxdg_exporter_v1_interface_events,
  };

const wl_interface* zxdg_importer_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_importer_v1_interface_import_request[2] = {
  &zxdg_imported_v1_interface,
  nullptr,
};

const wl_message zxdg_importer_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_importer_v1_interface_destroy_request,
  },
  {
    "import",
    "ns",
    zxdg_importer_v1_interface_import_request,
  },
};

const wl_message zxdg_importer_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_importer_v1_interface =
  {
    "zxdg_importer_v1",
    1,
    2,
    zxdg_importer_v1_interface_requests,
    0,
    zxdg_importer_v1_interface_events,
  };

const wl_interface* zxdg_exported_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_exported_v1_interface_handle_event[1] = {
  nullptr,
};

const wl_message zxdg_exported_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zxdg_exported_v1_interface_destroy_request,
  },
};

const wl_message zxdg_exported_v1_interface_events[1] = {
  {
    "handle",
    "s",
    zxdg_exported_v1_interface_handle_event,
  },
};

const wl_interface wayland::detail::zxdg_exported_v1_interface =
  {
    "zxdg_exported_v1",
    1,
    1,
    zxdg_exported_v1_interface_requests,
    1,
    zxdg_exported_v1_interface_events,
  };

const wl_interface* zxdg_imported_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_imported_v1_interface_set_parent_of_request[1] = {
  &surface_interface,
};

const wl_interface* zxdg_imported_v1_interface_destroyed_event[0] = {
};

const wl_message zxdg_imported_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_imported_v1_interface_destroy_request,
  },
  {
    "set_parent_of",
    "o",
    zxdg_imported_v1_interface_set_parent_of_request,
  },
};

const wl_message zxdg_imported_v1_interface_events[1] = {
  {
    "destroyed",
    "",
    zxdg_imported_v1_interface_destroyed_event,
  },
};

const wl_interface wayland::detail::zxdg_imported_v1_interface =
  {
    "zxdg_imported_v1",
    1,
    2,
    zxdg_imported_v1_interface_requests,
    1,
    zxdg_imported_v1_interface_events,
  };

const wl_interface* zxdg_exporter_v2_interface_destroy_request[0] = {
};

const wl_interface* zxdg_exporter_v2_interface_export_toplevel_request[2] = {
  &zxdg_exported_v2_interface,
  &surface_interface,
};

const wl_message zxdg_exporter_v2_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_exporter_v2_interface_destroy_request,
  },
  {
    "export_toplevel",
    "no",
    zxdg_exporter_v2_interface_export_toplevel_request,
  },
};

const wl_message zxdg_exporter_v2_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_exporter_v2_interface =
  {
    "zxdg_exporter_v2",
    1,
    2,
    zxdg_exporter_v2_interface_requests,
    0,
    zxdg_exporter_v2_interface_events,
  };

const wl_interface* zxdg_importer_v2_interface_destroy_request[0] = {
};

const wl_interface* zxdg_importer_v2_interface_import_toplevel_request[2] = {
  &zxdg_imported_v2_interface,
  nullptr,
};

const wl_message zxdg_importer_v2_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_importer_v2_interface_destroy_request,
  },
  {
    "import_toplevel",
    "ns",
    zxdg_importer_v2_interface_import_toplevel_request,
  },
};

const wl_message zxdg_importer_v2_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_importer_v2_interface =
  {
    "zxdg_importer_v2",
    1,
    2,
    zxdg_importer_v2_interface_requests,
    0,
    zxdg_importer_v2_interface_events,
  };

const wl_interface* zxdg_exported_v2_interface_destroy_request[0] = {
};

const wl_interface* zxdg_exported_v2_interface_handle_event[1] = {
  nullptr,
};

const wl_message zxdg_exported_v2_interface_requests[1] = {
  {
    "destroy",
    "",
    zxdg_exported_v2_interface_destroy_request,
  },
};

const wl_message zxdg_exported_v2_interface_events[1] = {
  {
    "handle",
    "s",
    zxdg_exported_v2_interface_handle_event,
  },
};

const wl_interface wayland::detail::zxdg_exported_v2_interface =
  {
    "zxdg_exported_v2",
    1,
    1,
    zxdg_exported_v2_interface_requests,
    1,
    zxdg_exported_v2_interface_events,
  };

const wl_interface* zxdg_imported_v2_interface_destroy_request[0] = {
};

const wl_interface* zxdg_imported_v2_interface_set_parent_of_request[1] = {
  &surface_interface,
};

const wl_interface* zxdg_imported_v2_interface_destroyed_event[0] = {
};

const wl_message zxdg_imported_v2_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_imported_v2_interface_destroy_request,
  },
  {
    "set_parent_of",
    "o",
    zxdg_imported_v2_interface_set_parent_of_request,
  },
};

const wl_message zxdg_imported_v2_interface_events[1] = {
  {
    "destroyed",
    "",
    zxdg_imported_v2_interface_destroyed_event,
  },
};

const wl_interface wayland::detail::zxdg_imported_v2_interface =
  {
    "zxdg_imported_v2",
    1,
    2,
    zxdg_imported_v2_interface_requests,
    1,
    zxdg_imported_v2_interface_events,
  };

const wl_interface* zxdg_output_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_output_manager_v1_interface_get_xdg_output_request[2] = {
  &zxdg_output_v1_interface,
  &output_interface,
};

const wl_message zxdg_output_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_output_manager_v1_interface_destroy_request,
  },
  {
    "get_xdg_output",
    "no",
    zxdg_output_manager_v1_interface_get_xdg_output_request,
  },
};

const wl_message zxdg_output_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_output_manager_v1_interface =
  {
    "zxdg_output_manager_v1",
    3,
    2,
    zxdg_output_manager_v1_interface_requests,
    0,
    zxdg_output_manager_v1_interface_events,
  };

const wl_interface* zxdg_output_v1_interface_destroy_request[0] = {
};

const wl_interface* zxdg_output_v1_interface_logical_position_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_logical_size_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_done_event[0] = {
};

const wl_interface* zxdg_output_v1_interface_name_event[1] = {
  nullptr,
};

const wl_interface* zxdg_output_v1_interface_description_event[1] = {
  nullptr,
};

const wl_message zxdg_output_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zxdg_output_v1_interface_destroy_request,
  },
};

const wl_message zxdg_output_v1_interface_events[5] = {
  {
    "logical_position",
    "ii",
    zxdg_output_v1_interface_logical_position_event,
  },
  {
    "logical_size",
    "ii",
    zxdg_output_v1_interface_logical_size_event,
  },
  {
    "done",
    "",
    zxdg_output_v1_interface_done_event,
  },
  {
    "name",
    "2s",
    zxdg_output_v1_interface_name_event,
  },
  {
    "description",
    "2s",
    zxdg_output_v1_interface_description_event,
  },
};

const wl_interface wayland::detail::zxdg_output_v1_interface =
  {
    "zxdg_output_v1",
    3,
    1,
    zxdg_output_v1_interface_requests,
    5,
    zxdg_output_v1_interface_events,
  };

const wl_interface* zxdg_shell_v6_interface_destroy_request[0] = {
};

const wl_interface* zxdg_shell_v6_interface_create_positioner_request[1] = {
  &zxdg_positioner_v6_interface,
};

const wl_interface* zxdg_shell_v6_interface_get_xdg_surface_request[2] = {
  &zxdg_surface_v6_interface,
  &surface_interface,
};

const wl_interface* zxdg_shell_v6_interface_pong_request[1] = {
  nullptr,
};

const wl_interface* zxdg_shell_v6_interface_ping_event[1] = {
  nullptr,
};

const wl_message zxdg_shell_v6_interface_requests[4] = {
  {
    "destroy",
    "",
    zxdg_shell_v6_interface_destroy_request,
  },
  {
    "create_positioner",
    "n",
    zxdg_shell_v6_interface_create_positioner_request,
  },
  {
    "get_xdg_surface",
    "no",
    zxdg_shell_v6_interface_get_xdg_surface_request,
  },
  {
    "pong",
    "u",
    zxdg_shell_v6_interface_pong_request,
  },
};

const wl_message zxdg_shell_v6_interface_events[1] = {
  {
    "ping",
    "u",
    zxdg_shell_v6_interface_ping_event,
  },
};

const wl_interface wayland::detail::zxdg_shell_v6_interface =
  {
    "zxdg_shell_v6",
    1,
    4,
    zxdg_shell_v6_interface_requests,
    1,
    zxdg_shell_v6_interface_events,
  };

const wl_interface* zxdg_positioner_v6_interface_destroy_request[0] = {
};

const wl_interface* zxdg_positioner_v6_interface_set_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_anchor_rect_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_anchor_request[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_gravity_request[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_constraint_adjustment_request[1] = {
  nullptr,
};

const wl_interface* zxdg_positioner_v6_interface_set_offset_request[2] = {
  nullptr,
  nullptr,
};

const wl_message zxdg_positioner_v6_interface_requests[7] = {
  {
    "destroy",
    "",
    zxdg_positioner_v6_interface_destroy_request,
  },
  {
    "set_size",
    "ii",
    zxdg_positioner_v6_interface_set_size_request,
  },
  {
    "set_anchor_rect",
    "iiii",
    zxdg_positioner_v6_interface_set_anchor_rect_request,
  },
  {
    "set_anchor",
    "u",
    zxdg_positioner_v6_interface_set_anchor_request,
  },
  {
    "set_gravity",
    "u",
    zxdg_positioner_v6_interface_set_gravity_request,
  },
  {
    "set_constraint_adjustment",
    "u",
    zxdg_positioner_v6_interface_set_constraint_adjustment_request,
  },
  {
    "set_offset",
    "ii",
    zxdg_positioner_v6_interface_set_offset_request,
  },
};

const wl_message zxdg_positioner_v6_interface_events[0] = {
};

const wl_interface wayland::detail::zxdg_positioner_v6_interface =
  {
    "zxdg_positioner_v6",
    1,
    7,
    zxdg_positioner_v6_interface_requests,
    0,
    zxdg_positioner_v6_interface_events,
  };

const wl_interface* zxdg_surface_v6_interface_destroy_request[0] = {
};

const wl_interface* zxdg_surface_v6_interface_get_toplevel_request[1] = {
  &zxdg_toplevel_v6_interface,
};

const wl_interface* zxdg_surface_v6_interface_get_popup_request[3] = {
  &zxdg_popup_v6_interface,
  &zxdg_surface_v6_interface,
  &zxdg_positioner_v6_interface,
};

const wl_interface* zxdg_surface_v6_interface_set_window_geometry_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_surface_v6_interface_ack_configure_request[1] = {
  nullptr,
};

const wl_interface* zxdg_surface_v6_interface_configure_event[1] = {
  nullptr,
};

const wl_message zxdg_surface_v6_interface_requests[5] = {
  {
    "destroy",
    "",
    zxdg_surface_v6_interface_destroy_request,
  },
  {
    "get_toplevel",
    "n",
    zxdg_surface_v6_interface_get_toplevel_request,
  },
  {
    "get_popup",
    "noo",
    zxdg_surface_v6_interface_get_popup_request,
  },
  {
    "set_window_geometry",
    "iiii",
    zxdg_surface_v6_interface_set_window_geometry_request,
  },
  {
    "ack_configure",
    "u",
    zxdg_surface_v6_interface_ack_configure_request,
  },
};

const wl_message zxdg_surface_v6_interface_events[1] = {
  {
    "configure",
    "u",
    zxdg_surface_v6_interface_configure_event,
  },
};

const wl_interface wayland::detail::zxdg_surface_v6_interface =
  {
    "zxdg_surface_v6",
    1,
    5,
    zxdg_surface_v6_interface_requests,
    1,
    zxdg_surface_v6_interface_events,
  };

const wl_interface* zxdg_toplevel_v6_interface_destroy_request[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_parent_request[1] = {
  &zxdg_toplevel_v6_interface,
};

const wl_interface* zxdg_toplevel_v6_interface_set_title_request[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_app_id_request[1] = {
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_show_window_menu_request[4] = {
  &seat_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_move_request[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_resize_request[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_max_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_min_size_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_set_maximized_request[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_unset_maximized_request[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_fullscreen_request[1] = {
  &output_interface,
};

const wl_interface* zxdg_toplevel_v6_interface_unset_fullscreen_request[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_set_minimized_request[0] = {
};

const wl_interface* zxdg_toplevel_v6_interface_configure_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_toplevel_v6_interface_close_event[0] = {
};

const wl_message zxdg_toplevel_v6_interface_requests[14] = {
  {
    "destroy",
    "",
    zxdg_toplevel_v6_interface_destroy_request,
  },
  {
    "set_parent",
    "?o",
    zxdg_toplevel_v6_interface_set_parent_request,
  },
  {
    "set_title",
    "s",
    zxdg_toplevel_v6_interface_set_title_request,
  },
  {
    "set_app_id",
    "s",
    zxdg_toplevel_v6_interface_set_app_id_request,
  },
  {
    "show_window_menu",
    "ouii",
    zxdg_toplevel_v6_interface_show_window_menu_request,
  },
  {
    "move",
    "ou",
    zxdg_toplevel_v6_interface_move_request,
  },
  {
    "resize",
    "ouu",
    zxdg_toplevel_v6_interface_resize_request,
  },
  {
    "set_max_size",
    "ii",
    zxdg_toplevel_v6_interface_set_max_size_request,
  },
  {
    "set_min_size",
    "ii",
    zxdg_toplevel_v6_interface_set_min_size_request,
  },
  {
    "set_maximized",
    "",
    zxdg_toplevel_v6_interface_set_maximized_request,
  },
  {
    "unset_maximized",
    "",
    zxdg_toplevel_v6_interface_unset_maximized_request,
  },
  {
    "set_fullscreen",
    "?o",
    zxdg_toplevel_v6_interface_set_fullscreen_request,
  },
  {
    "unset_fullscreen",
    "",
    zxdg_toplevel_v6_interface_unset_fullscreen_request,
  },
  {
    "set_minimized",
    "",
    zxdg_toplevel_v6_interface_set_minimized_request,
  },
};

const wl_message zxdg_toplevel_v6_interface_events[2] = {
  {
    "configure",
    "iia",
    zxdg_toplevel_v6_interface_configure_event,
  },
  {
    "close",
    "",
    zxdg_toplevel_v6_interface_close_event,
  },
};

const wl_interface wayland::detail::zxdg_toplevel_v6_interface =
  {
    "zxdg_toplevel_v6",
    1,
    14,
    zxdg_toplevel_v6_interface_requests,
    2,
    zxdg_toplevel_v6_interface_events,
  };

const wl_interface* zxdg_popup_v6_interface_destroy_request[0] = {
};

const wl_interface* zxdg_popup_v6_interface_grab_request[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* zxdg_popup_v6_interface_configure_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* zxdg_popup_v6_interface_popup_done_event[0] = {
};

const wl_message zxdg_popup_v6_interface_requests[2] = {
  {
    "destroy",
    "",
    zxdg_popup_v6_interface_destroy_request,
  },
  {
    "grab",
    "ou",
    zxdg_popup_v6_interface_grab_request,
  },
};

const wl_message zxdg_popup_v6_interface_events[2] = {
  {
    "configure",
    "iiii",
    zxdg_popup_v6_interface_configure_event,
  },
  {
    "popup_done",
    "",
    zxdg_popup_v6_interface_popup_done_event,
  },
};

const wl_interface wayland::detail::zxdg_popup_v6_interface =
  {
    "zxdg_popup_v6",
    1,
    2,
    zxdg_popup_v6_interface_requests,
    2,
    zxdg_popup_v6_interface_events,
  };

const wl_interface* zwp_xwayland_keyboard_grab_manager_v1_interface_destroy_request[0] = {
};

const wl_interface* zwp_xwayland_keyboard_grab_manager_v1_interface_grab_keyboard_request[3] = {
  &zwp_xwayland_keyboard_grab_v1_interface,
  &surface_interface,
  &seat_interface,
};

const wl_message zwp_xwayland_keyboard_grab_manager_v1_interface_requests[2] = {
  {
    "destroy",
    "",
    zwp_xwayland_keyboard_grab_manager_v1_interface_destroy_request,
  },
  {
    "grab_keyboard",
    "noo",
    zwp_xwayland_keyboard_grab_manager_v1_interface_grab_keyboard_request,
  },
};

const wl_message zwp_xwayland_keyboard_grab_manager_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_xwayland_keyboard_grab_manager_v1_interface =
  {
    "zwp_xwayland_keyboard_grab_manager_v1",
    1,
    2,
    zwp_xwayland_keyboard_grab_manager_v1_interface_requests,
    0,
    zwp_xwayland_keyboard_grab_manager_v1_interface_events,
  };

const wl_interface* zwp_xwayland_keyboard_grab_v1_interface_destroy_request[0] = {
};

const wl_message zwp_xwayland_keyboard_grab_v1_interface_requests[1] = {
  {
    "destroy",
    "",
    zwp_xwayland_keyboard_grab_v1_interface_destroy_request,
  },
};

const wl_message zwp_xwayland_keyboard_grab_v1_interface_events[0] = {
};

const wl_interface wayland::detail::zwp_xwayland_keyboard_grab_v1_interface =
  {
    "zwp_xwayland_keyboard_grab_v1",
    1,
    1,
    zwp_xwayland_keyboard_grab_v1_interface_requests,
    0,
    zwp_xwayland_keyboard_grab_v1_interface_events,
  };

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_fullscreen_shell_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_v1_t(p); });
}

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t()
{
  set_interface(&zwp_fullscreen_shell_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_v1_t(p); });
}

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t(zwp_fullscreen_shell_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_fullscreen_shell_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_v1_t(p); });
}

zwp_fullscreen_shell_v1_t::zwp_fullscreen_shell_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_fullscreen_shell_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_v1_t(p); });
}

zwp_fullscreen_shell_v1_t zwp_fullscreen_shell_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_fullscreen_shell_v1_t::interface_name = "zwp_fullscreen_shell_v1";

zwp_fullscreen_shell_v1_t::operator zwp_fullscreen_shell_v1*() const
{
  return reinterpret_cast<zwp_fullscreen_shell_v1*> (c_ptr());
}

void zwp_fullscreen_shell_v1_t::release()
{
  marshal(0U);
}


void zwp_fullscreen_shell_v1_t::present_surface(surface_t const& surface, zwp_fullscreen_shell_v1_present_method const& method, output_t const& output)
{
  marshal(1U, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, static_cast<uint32_t>(method), output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}


zwp_fullscreen_shell_mode_feedback_v1_t zwp_fullscreen_shell_v1_t::present_surface_for_mode(surface_t const& surface, output_t const& output, int32_t framerate)
{
  proxy_t p = marshal_constructor(2U, &zwp_fullscreen_shell_mode_feedback_v1_interface, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr, framerate, nullptr);
  return zwp_fullscreen_shell_mode_feedback_v1_t(p);
}


std::function<void(zwp_fullscreen_shell_v1_capability)> &zwp_fullscreen_shell_v1_t::on_capability()
{
  return std::static_pointer_cast<events_t>(get_events())->capability;
}

int zwp_fullscreen_shell_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->capability) events->capability(zwp_fullscreen_shell_v1_capability(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}




zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_fullscreen_shell_mode_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_mode_feedback_v1_t(p); });
}

zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t()
{
  set_interface(&zwp_fullscreen_shell_mode_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_mode_feedback_v1_t(p); });
}

zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t(zwp_fullscreen_shell_mode_feedback_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_fullscreen_shell_mode_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_mode_feedback_v1_t(p); });
}

zwp_fullscreen_shell_mode_feedback_v1_t::zwp_fullscreen_shell_mode_feedback_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_fullscreen_shell_mode_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_fullscreen_shell_mode_feedback_v1_t(p); });
}

zwp_fullscreen_shell_mode_feedback_v1_t zwp_fullscreen_shell_mode_feedback_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_fullscreen_shell_mode_feedback_v1_t::interface_name = "zwp_fullscreen_shell_mode_feedback_v1";

zwp_fullscreen_shell_mode_feedback_v1_t::operator zwp_fullscreen_shell_mode_feedback_v1*() const
{
  return reinterpret_cast<zwp_fullscreen_shell_mode_feedback_v1*> (c_ptr());
}

std::function<void()> &zwp_fullscreen_shell_mode_feedback_v1_t::on_mode_successful()
{
  return std::static_pointer_cast<events_t>(get_events())->mode_successful;
}

std::function<void()> &zwp_fullscreen_shell_mode_feedback_v1_t::on_mode_failed()
{
  return std::static_pointer_cast<events_t>(get_events())->mode_failed;
}

std::function<void()> &zwp_fullscreen_shell_mode_feedback_v1_t::on_present_cancelled()
{
  return std::static_pointer_cast<events_t>(get_events())->present_cancelled;
}

int zwp_fullscreen_shell_mode_feedback_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->mode_successful) events->mode_successful();
      break;
    case 1:
      if(events->mode_failed) events->mode_failed();
      break;
    case 2:
      if(events->present_cancelled) events->present_cancelled();
      break;
    }
  return 0;
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_idle_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibit_manager_v1_t(p); });
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t()
{
  set_interface(&zwp_idle_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibit_manager_v1_t(p); });
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t(zwp_idle_inhibit_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_idle_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibit_manager_v1_t(p); });
}

zwp_idle_inhibit_manager_v1_t::zwp_idle_inhibit_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_idle_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibit_manager_v1_t(p); });
}

zwp_idle_inhibit_manager_v1_t zwp_idle_inhibit_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_idle_inhibit_manager_v1_t::interface_name = "zwp_idle_inhibit_manager_v1";

zwp_idle_inhibit_manager_v1_t::operator zwp_idle_inhibit_manager_v1*() const
{
  return reinterpret_cast<zwp_idle_inhibit_manager_v1*> (c_ptr());
}

zwp_idle_inhibitor_v1_t zwp_idle_inhibit_manager_v1_t::create_inhibitor(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &zwp_idle_inhibitor_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zwp_idle_inhibitor_v1_t(p);
}


int zwp_idle_inhibit_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_idle_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibitor_v1_t(p); });
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t()
{
  set_interface(&zwp_idle_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibitor_v1_t(p); });
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t(zwp_idle_inhibitor_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_idle_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibitor_v1_t(p); });
}

zwp_idle_inhibitor_v1_t::zwp_idle_inhibitor_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_idle_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_idle_inhibitor_v1_t(p); });
}

zwp_idle_inhibitor_v1_t zwp_idle_inhibitor_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_idle_inhibitor_v1_t::interface_name = "zwp_idle_inhibitor_v1";

zwp_idle_inhibitor_v1_t::operator zwp_idle_inhibitor_v1*() const
{
  return reinterpret_cast<zwp_idle_inhibitor_v1*> (c_ptr());
}

int zwp_idle_inhibitor_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_method_context_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_context_v1_t(p); });
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t()
{
  set_interface(&zwp_input_method_context_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_context_v1_t(p); });
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t(zwp_input_method_context_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_method_context_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_context_v1_t(p); });
}

zwp_input_method_context_v1_t::zwp_input_method_context_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_method_context_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_context_v1_t(p); });
}

zwp_input_method_context_v1_t zwp_input_method_context_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_method_context_v1_t::interface_name = "zwp_input_method_context_v1";

zwp_input_method_context_v1_t::operator zwp_input_method_context_v1*() const
{
  return reinterpret_cast<zwp_input_method_context_v1*> (c_ptr());
}

void zwp_input_method_context_v1_t::commit_string(uint32_t serial, std::string const& text)
{
  marshal(1U, serial, text);
}


void zwp_input_method_context_v1_t::preedit_string(uint32_t serial, std::string const& text, std::string const& commit)
{
  marshal(2U, serial, text, commit);
}


void zwp_input_method_context_v1_t::preedit_styling(uint32_t index, uint32_t length, zwp_text_input_v1_preedit_style const& style)
{
  marshal(3U, index, length, static_cast<uint32_t>(style));
}


void zwp_input_method_context_v1_t::preedit_cursor(int32_t index)
{
  marshal(4U, index);
}


void zwp_input_method_context_v1_t::delete_surrounding_text(int32_t index, uint32_t length)
{
  marshal(5U, index, length);
}


void zwp_input_method_context_v1_t::cursor_position(int32_t index, int32_t anchor)
{
  marshal(6U, index, anchor);
}


void zwp_input_method_context_v1_t::modifiers_map(array_t const& map)
{
  marshal(7U, map);
}


void zwp_input_method_context_v1_t::keysym(uint32_t serial, uint32_t time, uint32_t sym, keyboard_key_state const& state, uint32_t modifiers)
{
  marshal(8U, serial, time, sym, static_cast<uint32_t>(state), modifiers);
}


keyboard_t zwp_input_method_context_v1_t::grab_keyboard()
{
  proxy_t p = marshal_constructor(9U, &keyboard_interface, nullptr);
  return keyboard_t(p);
}


void zwp_input_method_context_v1_t::key(uint32_t serial, uint32_t time, uint32_t key, keyboard_key_state const& state)
{
  marshal(10U, serial, time, key, static_cast<uint32_t>(state));
}


void zwp_input_method_context_v1_t::modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
  marshal(11U, serial, mods_depressed, mods_latched, mods_locked, group);
}


void zwp_input_method_context_v1_t::language(uint32_t serial, std::string const& language)
{
  marshal(12U, serial, language);
}


void zwp_input_method_context_v1_t::text_direction(uint32_t serial, uint32_t direction)
{
  marshal(13U, serial, direction);
}


std::function<void(std::string, uint32_t, uint32_t)> &zwp_input_method_context_v1_t::on_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->surrounding_text;
}

std::function<void()> &zwp_input_method_context_v1_t::on_reset()
{
  return std::static_pointer_cast<events_t>(get_events())->reset;
}

std::function<void(zwp_text_input_v1_content_hint, zwp_text_input_v1_content_purpose)> &zwp_input_method_context_v1_t::on_content_type()
{
  return std::static_pointer_cast<events_t>(get_events())->content_type;
}

std::function<void(uint32_t, uint32_t)> &zwp_input_method_context_v1_t::on_invoke_action()
{
  return std::static_pointer_cast<events_t>(get_events())->invoke_action;
}

std::function<void(uint32_t)> &zwp_input_method_context_v1_t::on_commit_state()
{
  return std::static_pointer_cast<events_t>(get_events())->commit_state;
}

std::function<void(std::string)> &zwp_input_method_context_v1_t::on_preferred_language()
{
  return std::static_pointer_cast<events_t>(get_events())->preferred_language;
}

int zwp_input_method_context_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->surrounding_text) events->surrounding_text(args[0].get<std::string>(), args[1].get<uint32_t>(), args[2].get<uint32_t>());
      break;
    case 1:
      if(events->reset) events->reset();
      break;
    case 2:
      if(events->content_type) events->content_type(zwp_text_input_v1_content_hint(args[0].get<uint32_t>()), zwp_text_input_v1_content_purpose(args[1].get<uint32_t>()));
      break;
    case 3:
      if(events->invoke_action) events->invoke_action(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 4:
      if(events->commit_state) events->commit_state(args[0].get<uint32_t>());
      break;
    case 5:
      if(events->preferred_language) events->preferred_language(args[0].get<std::string>());
      break;
    }
  return 0;
}

zwp_input_method_v1_t::zwp_input_method_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_method_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_v1_t(p); });
}

zwp_input_method_v1_t::zwp_input_method_v1_t()
{
  set_interface(&zwp_input_method_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_v1_t(p); });
}

zwp_input_method_v1_t::zwp_input_method_v1_t(zwp_input_method_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_method_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_v1_t(p); });
}

zwp_input_method_v1_t::zwp_input_method_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_method_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_method_v1_t(p); });
}

zwp_input_method_v1_t zwp_input_method_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_method_v1_t::interface_name = "zwp_input_method_v1";

zwp_input_method_v1_t::operator zwp_input_method_v1*() const
{
  return reinterpret_cast<zwp_input_method_v1*> (c_ptr());
}

std::function<void(zwp_input_method_context_v1_t)> &zwp_input_method_v1_t::on_activate()
{
  return std::static_pointer_cast<events_t>(get_events())->activate;
}

std::function<void(zwp_input_method_context_v1_t)> &zwp_input_method_v1_t::on_deactivate()
{
  return std::static_pointer_cast<events_t>(get_events())->deactivate;
}

int zwp_input_method_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->activate) events->activate(zwp_input_method_context_v1_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->deactivate) events->deactivate(zwp_input_method_context_v1_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_panel_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_v1_t(p); });
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t()
{
  set_interface(&zwp_input_panel_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_v1_t(p); });
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t(zwp_input_panel_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_panel_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_v1_t(p); });
}

zwp_input_panel_v1_t::zwp_input_panel_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_panel_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_v1_t(p); });
}

zwp_input_panel_v1_t zwp_input_panel_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_panel_v1_t::interface_name = "zwp_input_panel_v1";

zwp_input_panel_v1_t::operator zwp_input_panel_v1*() const
{
  return reinterpret_cast<zwp_input_panel_v1*> (c_ptr());
}

zwp_input_panel_surface_v1_t zwp_input_panel_v1_t::get_input_panel_surface(surface_t const& surface)
{
  proxy_t p = marshal_constructor(0U, &zwp_input_panel_surface_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zwp_input_panel_surface_v1_t(p);
}


int zwp_input_panel_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_panel_surface_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_surface_v1_t(p); });
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t()
{
  set_interface(&zwp_input_panel_surface_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_surface_v1_t(p); });
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t(zwp_input_panel_surface_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_input_panel_surface_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_surface_v1_t(p); });
}

zwp_input_panel_surface_v1_t::zwp_input_panel_surface_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_panel_surface_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_panel_surface_v1_t(p); });
}

zwp_input_panel_surface_v1_t zwp_input_panel_surface_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_panel_surface_v1_t::interface_name = "zwp_input_panel_surface_v1";

zwp_input_panel_surface_v1_t::operator zwp_input_panel_surface_v1*() const
{
  return reinterpret_cast<zwp_input_panel_surface_v1*> (c_ptr());
}

void zwp_input_panel_surface_v1_t::set_toplevel(output_t const& output, zwp_input_panel_surface_v1_position const& position)
{
  marshal(0U, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr, static_cast<uint32_t>(position));
}


void zwp_input_panel_surface_v1_t::set_overlay_panel()
{
  marshal(1U);
}


int zwp_input_panel_surface_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_timestamps_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_manager_v1_t(p); });
}

zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t()
{
  set_interface(&zwp_input_timestamps_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_manager_v1_t(p); });
}

zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t(zwp_input_timestamps_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_timestamps_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_manager_v1_t(p); });
}

zwp_input_timestamps_manager_v1_t::zwp_input_timestamps_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_timestamps_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_manager_v1_t(p); });
}

zwp_input_timestamps_manager_v1_t zwp_input_timestamps_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_timestamps_manager_v1_t::interface_name = "zwp_input_timestamps_manager_v1";

zwp_input_timestamps_manager_v1_t::operator zwp_input_timestamps_manager_v1*() const
{
  return reinterpret_cast<zwp_input_timestamps_manager_v1*> (c_ptr());
}

zwp_input_timestamps_v1_t zwp_input_timestamps_manager_v1_t::get_keyboard_timestamps(keyboard_t const& keyboard)
{
  proxy_t p = marshal_constructor(1U, &zwp_input_timestamps_v1_interface, nullptr, keyboard.proxy_has_object() ? reinterpret_cast<wl_object*>(keyboard.c_ptr()) : nullptr);
  return zwp_input_timestamps_v1_t(p);
}


zwp_input_timestamps_v1_t zwp_input_timestamps_manager_v1_t::get_pointer_timestamps(pointer_t const& pointer)
{
  proxy_t p = marshal_constructor(2U, &zwp_input_timestamps_v1_interface, nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr);
  return zwp_input_timestamps_v1_t(p);
}


zwp_input_timestamps_v1_t zwp_input_timestamps_manager_v1_t::get_touch_timestamps(touch_t const& touch)
{
  proxy_t p = marshal_constructor(3U, &zwp_input_timestamps_v1_interface, nullptr, touch.proxy_has_object() ? reinterpret_cast<wl_object*>(touch.c_ptr()) : nullptr);
  return zwp_input_timestamps_v1_t(p);
}


int zwp_input_timestamps_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_timestamps_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_v1_t(p); });
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t()
{
  set_interface(&zwp_input_timestamps_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_v1_t(p); });
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t(zwp_input_timestamps_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_input_timestamps_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_v1_t(p); });
}

zwp_input_timestamps_v1_t::zwp_input_timestamps_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_input_timestamps_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_input_timestamps_v1_t(p); });
}

zwp_input_timestamps_v1_t zwp_input_timestamps_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_input_timestamps_v1_t::interface_name = "zwp_input_timestamps_v1";

zwp_input_timestamps_v1_t::operator zwp_input_timestamps_v1*() const
{
  return reinterpret_cast<zwp_input_timestamps_v1*> (c_ptr());
}

std::function<void(uint32_t, uint32_t, uint32_t)> &zwp_input_timestamps_v1_t::on_timestamp()
{
  return std::static_pointer_cast<events_t>(get_events())->timestamp;
}

int zwp_input_timestamps_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->timestamp) events->timestamp(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>());
      break;
    }
  return 0;
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_keyboard_shortcuts_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibit_manager_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t()
{
  set_interface(&zwp_keyboard_shortcuts_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibit_manager_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t(zwp_keyboard_shortcuts_inhibit_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_keyboard_shortcuts_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibit_manager_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t::zwp_keyboard_shortcuts_inhibit_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_keyboard_shortcuts_inhibit_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibit_manager_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibit_manager_v1_t zwp_keyboard_shortcuts_inhibit_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_keyboard_shortcuts_inhibit_manager_v1_t::interface_name = "zwp_keyboard_shortcuts_inhibit_manager_v1";

zwp_keyboard_shortcuts_inhibit_manager_v1_t::operator zwp_keyboard_shortcuts_inhibit_manager_v1*() const
{
  return reinterpret_cast<zwp_keyboard_shortcuts_inhibit_manager_v1*> (c_ptr());
}

zwp_keyboard_shortcuts_inhibitor_v1_t zwp_keyboard_shortcuts_inhibit_manager_v1_t::inhibit_shortcuts(surface_t const& surface, seat_t const& seat)
{
  proxy_t p = marshal_constructor(1U, &zwp_keyboard_shortcuts_inhibitor_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_keyboard_shortcuts_inhibitor_v1_t(p);
}


int zwp_keyboard_shortcuts_inhibit_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_keyboard_shortcuts_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibitor_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t()
{
  set_interface(&zwp_keyboard_shortcuts_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibitor_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t(zwp_keyboard_shortcuts_inhibitor_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_keyboard_shortcuts_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibitor_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibitor_v1_t::zwp_keyboard_shortcuts_inhibitor_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_keyboard_shortcuts_inhibitor_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_keyboard_shortcuts_inhibitor_v1_t(p); });
}

zwp_keyboard_shortcuts_inhibitor_v1_t zwp_keyboard_shortcuts_inhibitor_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_keyboard_shortcuts_inhibitor_v1_t::interface_name = "zwp_keyboard_shortcuts_inhibitor_v1";

zwp_keyboard_shortcuts_inhibitor_v1_t::operator zwp_keyboard_shortcuts_inhibitor_v1*() const
{
  return reinterpret_cast<zwp_keyboard_shortcuts_inhibitor_v1*> (c_ptr());
}

std::function<void()> &zwp_keyboard_shortcuts_inhibitor_v1_t::on_active()
{
  return std::static_pointer_cast<events_t>(get_events())->active;
}

std::function<void()> &zwp_keyboard_shortcuts_inhibitor_v1_t::on_inactive()
{
  return std::static_pointer_cast<events_t>(get_events())->inactive;
}

int zwp_keyboard_shortcuts_inhibitor_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->active) events->active();
      break;
    case 1:
      if(events->inactive) events->inactive();
      break;
    }
  return 0;
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_dmabuf_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_v1_t(p); });
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t()
{
  set_interface(&zwp_linux_dmabuf_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_v1_t(p); });
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t(zwp_linux_dmabuf_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_dmabuf_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_v1_t(p); });
}

zwp_linux_dmabuf_v1_t::zwp_linux_dmabuf_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_dmabuf_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_v1_t(p); });
}

zwp_linux_dmabuf_v1_t zwp_linux_dmabuf_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_dmabuf_v1_t::interface_name = "zwp_linux_dmabuf_v1";

zwp_linux_dmabuf_v1_t::operator zwp_linux_dmabuf_v1*() const
{
  return reinterpret_cast<zwp_linux_dmabuf_v1*> (c_ptr());
}

zwp_linux_buffer_params_v1_t zwp_linux_dmabuf_v1_t::create_params()
{
  proxy_t p = marshal_constructor(1U, &zwp_linux_buffer_params_v1_interface, nullptr);
  return zwp_linux_buffer_params_v1_t(p);
}


zwp_linux_dmabuf_feedback_v1_t zwp_linux_dmabuf_v1_t::get_default_feedback()
{
  proxy_t p = marshal_constructor(2U, &zwp_linux_dmabuf_feedback_v1_interface, nullptr);
  return zwp_linux_dmabuf_feedback_v1_t(p);
}

bool zwp_linux_dmabuf_v1_t::can_get_default_feedback() const
{
  return (get_version() >= get_default_feedback_since_version);
}


zwp_linux_dmabuf_feedback_v1_t zwp_linux_dmabuf_v1_t::get_surface_feedback(surface_t const& surface)
{
  proxy_t p = marshal_constructor(3U, &zwp_linux_dmabuf_feedback_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zwp_linux_dmabuf_feedback_v1_t(p);
}

bool zwp_linux_dmabuf_v1_t::can_get_surface_feedback() const
{
  return (get_version() >= get_surface_feedback_since_version);
}


std::function<void(uint32_t)> &zwp_linux_dmabuf_v1_t::on_format()
{
  return std::static_pointer_cast<events_t>(get_events())->format;
}

std::function<void(uint32_t, uint32_t, uint32_t)> &zwp_linux_dmabuf_v1_t::on_modifier()
{
  return std::static_pointer_cast<events_t>(get_events())->modifier;
}

int zwp_linux_dmabuf_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->format) events->format(args[0].get<uint32_t>());
      break;
    case 1:
      if(events->modifier) events->modifier(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>());
      break;
    }
  return 0;
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_buffer_params_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_params_v1_t(p); });
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t()
{
  set_interface(&zwp_linux_buffer_params_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_params_v1_t(p); });
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t(zwp_linux_buffer_params_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_buffer_params_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_params_v1_t(p); });
}

zwp_linux_buffer_params_v1_t::zwp_linux_buffer_params_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_buffer_params_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_params_v1_t(p); });
}

zwp_linux_buffer_params_v1_t zwp_linux_buffer_params_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_buffer_params_v1_t::interface_name = "zwp_linux_buffer_params_v1";

zwp_linux_buffer_params_v1_t::operator zwp_linux_buffer_params_v1*() const
{
  return reinterpret_cast<zwp_linux_buffer_params_v1*> (c_ptr());
}

void zwp_linux_buffer_params_v1_t::add(int fd, uint32_t plane_idx, uint32_t offset, uint32_t stride, uint32_t modifier_hi, uint32_t modifier_lo)
{
  marshal(1U, argument_t::fd(fd), plane_idx, offset, stride, modifier_hi, modifier_lo);
}


void zwp_linux_buffer_params_v1_t::create(int32_t width, int32_t height, uint32_t format, zwp_linux_buffer_params_v1_flags const& flags)
{
  marshal(2U, width, height, format, static_cast<uint32_t>(flags));
}


buffer_t zwp_linux_buffer_params_v1_t::create_immed(int32_t width, int32_t height, uint32_t format, zwp_linux_buffer_params_v1_flags const& flags)
{
  proxy_t p = marshal_constructor(3U, &buffer_interface, nullptr, width, height, format, static_cast<uint32_t>(flags));
  return buffer_t(p);
}

bool zwp_linux_buffer_params_v1_t::can_create_immed() const
{
  return (get_version() >= create_immed_since_version);
}


std::function<void(buffer_t)> &zwp_linux_buffer_params_v1_t::on_created()
{
  return std::static_pointer_cast<events_t>(get_events())->created;
}

std::function<void()> &zwp_linux_buffer_params_v1_t::on_failed()
{
  return std::static_pointer_cast<events_t>(get_events())->failed;
}

int zwp_linux_buffer_params_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->created) events->created(buffer_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->failed) events->failed();
      break;
    }
  return 0;
}

const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::y_invert{1};
const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::interlaced{2};
const bitfield<3, 6> zwp_linux_buffer_params_v1_flags::bottom_first{4};


zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_dmabuf_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_feedback_v1_t(p); });
}

zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t()
{
  set_interface(&zwp_linux_dmabuf_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_feedback_v1_t(p); });
}

zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t(zwp_linux_dmabuf_feedback_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_dmabuf_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_feedback_v1_t(p); });
}

zwp_linux_dmabuf_feedback_v1_t::zwp_linux_dmabuf_feedback_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_dmabuf_feedback_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_dmabuf_feedback_v1_t(p); });
}

zwp_linux_dmabuf_feedback_v1_t zwp_linux_dmabuf_feedback_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_dmabuf_feedback_v1_t::interface_name = "zwp_linux_dmabuf_feedback_v1";

zwp_linux_dmabuf_feedback_v1_t::operator zwp_linux_dmabuf_feedback_v1*() const
{
  return reinterpret_cast<zwp_linux_dmabuf_feedback_v1*> (c_ptr());
}

std::function<void()> &zwp_linux_dmabuf_feedback_v1_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void(int, uint32_t)> &zwp_linux_dmabuf_feedback_v1_t::on_format_table()
{
  return std::static_pointer_cast<events_t>(get_events())->format_table;
}

std::function<void(array_t)> &zwp_linux_dmabuf_feedback_v1_t::on_main_device()
{
  return std::static_pointer_cast<events_t>(get_events())->main_device;
}

std::function<void()> &zwp_linux_dmabuf_feedback_v1_t::on_tranche_done()
{
  return std::static_pointer_cast<events_t>(get_events())->tranche_done;
}

std::function<void(array_t)> &zwp_linux_dmabuf_feedback_v1_t::on_tranche_target_device()
{
  return std::static_pointer_cast<events_t>(get_events())->tranche_target_device;
}

std::function<void(array_t)> &zwp_linux_dmabuf_feedback_v1_t::on_tranche_formats()
{
  return std::static_pointer_cast<events_t>(get_events())->tranche_formats;
}

std::function<void(zwp_linux_dmabuf_feedback_v1_tranche_flags)> &zwp_linux_dmabuf_feedback_v1_t::on_tranche_flags()
{
  return std::static_pointer_cast<events_t>(get_events())->tranche_flags;
}

int zwp_linux_dmabuf_feedback_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->done) events->done();
      break;
    case 1:
      if(events->format_table) events->format_table(args[0].get<int>(), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->main_device) events->main_device(args[0].get<array_t>());
      break;
    case 3:
      if(events->tranche_done) events->tranche_done();
      break;
    case 4:
      if(events->tranche_target_device) events->tranche_target_device(args[0].get<array_t>());
      break;
    case 5:
      if(events->tranche_formats) events->tranche_formats(args[0].get<array_t>());
      break;
    case 6:
      if(events->tranche_flags) events->tranche_flags(zwp_linux_dmabuf_feedback_v1_tranche_flags(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}
const bitfield<1, 7> zwp_linux_dmabuf_feedback_v1_tranche_flags::scanout{1};


zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_explicit_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_explicit_synchronization_v1_t(p); });
}

zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t()
{
  set_interface(&zwp_linux_explicit_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_explicit_synchronization_v1_t(p); });
}

zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t(zwp_linux_explicit_synchronization_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_explicit_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_explicit_synchronization_v1_t(p); });
}

zwp_linux_explicit_synchronization_v1_t::zwp_linux_explicit_synchronization_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_explicit_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_explicit_synchronization_v1_t(p); });
}

zwp_linux_explicit_synchronization_v1_t zwp_linux_explicit_synchronization_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_explicit_synchronization_v1_t::interface_name = "zwp_linux_explicit_synchronization_v1";

zwp_linux_explicit_synchronization_v1_t::operator zwp_linux_explicit_synchronization_v1*() const
{
  return reinterpret_cast<zwp_linux_explicit_synchronization_v1*> (c_ptr());
}

zwp_linux_surface_synchronization_v1_t zwp_linux_explicit_synchronization_v1_t::get_synchronization(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &zwp_linux_surface_synchronization_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zwp_linux_surface_synchronization_v1_t(p);
}


int zwp_linux_explicit_synchronization_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_surface_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_surface_synchronization_v1_t(p); });
}

zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t()
{
  set_interface(&zwp_linux_surface_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_surface_synchronization_v1_t(p); });
}

zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t(zwp_linux_surface_synchronization_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_linux_surface_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_surface_synchronization_v1_t(p); });
}

zwp_linux_surface_synchronization_v1_t::zwp_linux_surface_synchronization_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_surface_synchronization_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_surface_synchronization_v1_t(p); });
}

zwp_linux_surface_synchronization_v1_t zwp_linux_surface_synchronization_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_surface_synchronization_v1_t::interface_name = "zwp_linux_surface_synchronization_v1";

zwp_linux_surface_synchronization_v1_t::operator zwp_linux_surface_synchronization_v1*() const
{
  return reinterpret_cast<zwp_linux_surface_synchronization_v1*> (c_ptr());
}

void zwp_linux_surface_synchronization_v1_t::set_acquire_fence(int fd)
{
  marshal(1U, argument_t::fd(fd));
}


zwp_linux_buffer_release_v1_t zwp_linux_surface_synchronization_v1_t::get_release()
{
  proxy_t p = marshal_constructor(2U, &zwp_linux_buffer_release_v1_interface, nullptr);
  return zwp_linux_buffer_release_v1_t(p);
}


int zwp_linux_surface_synchronization_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_linux_buffer_release_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_release_v1_t(p); });
}

zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t()
{
  set_interface(&zwp_linux_buffer_release_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_release_v1_t(p); });
}

zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t(zwp_linux_buffer_release_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_linux_buffer_release_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_release_v1_t(p); });
}

zwp_linux_buffer_release_v1_t::zwp_linux_buffer_release_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_linux_buffer_release_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_linux_buffer_release_v1_t(p); });
}

zwp_linux_buffer_release_v1_t zwp_linux_buffer_release_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_linux_buffer_release_v1_t::interface_name = "zwp_linux_buffer_release_v1";

zwp_linux_buffer_release_v1_t::operator zwp_linux_buffer_release_v1*() const
{
  return reinterpret_cast<zwp_linux_buffer_release_v1*> (c_ptr());
}

std::function<void(int)> &zwp_linux_buffer_release_v1_t::on_fenced_release()
{
  return std::static_pointer_cast<events_t>(get_events())->fenced_release;
}

std::function<void()> &zwp_linux_buffer_release_v1_t::on_immediate_release()
{
  return std::static_pointer_cast<events_t>(get_events())->immediate_release;
}

int zwp_linux_buffer_release_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->fenced_release) events->fenced_release(args[0].get<int>());
      break;
    case 1:
      if(events->immediate_release) events->immediate_release();
      break;
    }
  return 0;
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_constraints_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_constraints_v1_t(p); });
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t()
{
  set_interface(&zwp_pointer_constraints_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_constraints_v1_t(p); });
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t(zwp_pointer_constraints_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_constraints_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_constraints_v1_t(p); });
}

zwp_pointer_constraints_v1_t::zwp_pointer_constraints_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_pointer_constraints_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_constraints_v1_t(p); });
}

zwp_pointer_constraints_v1_t zwp_pointer_constraints_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_pointer_constraints_v1_t::interface_name = "zwp_pointer_constraints_v1";

zwp_pointer_constraints_v1_t::operator zwp_pointer_constraints_v1*() const
{
  return reinterpret_cast<zwp_pointer_constraints_v1*> (c_ptr());
}

zwp_locked_pointer_v1_t zwp_pointer_constraints_v1_t::lock_pointer(surface_t const& surface, pointer_t const& pointer, region_t const& region, zwp_pointer_constraints_v1_lifetime const& lifetime)
{
  proxy_t p = marshal_constructor(1U, &zwp_locked_pointer_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr, static_cast<uint32_t>(lifetime));
  return zwp_locked_pointer_v1_t(p);
}


zwp_confined_pointer_v1_t zwp_pointer_constraints_v1_t::confine_pointer(surface_t const& surface, pointer_t const& pointer, region_t const& region, zwp_pointer_constraints_v1_lifetime const& lifetime)
{
  proxy_t p = marshal_constructor(2U, &zwp_confined_pointer_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr, static_cast<uint32_t>(lifetime));
  return zwp_confined_pointer_v1_t(p);
}


int zwp_pointer_constraints_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}



zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_locked_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_locked_pointer_v1_t(p); });
}

zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t()
{
  set_interface(&zwp_locked_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_locked_pointer_v1_t(p); });
}

zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t(zwp_locked_pointer_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_locked_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_locked_pointer_v1_t(p); });
}

zwp_locked_pointer_v1_t::zwp_locked_pointer_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_locked_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_locked_pointer_v1_t(p); });
}

zwp_locked_pointer_v1_t zwp_locked_pointer_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_locked_pointer_v1_t::interface_name = "zwp_locked_pointer_v1";

zwp_locked_pointer_v1_t::operator zwp_locked_pointer_v1*() const
{
  return reinterpret_cast<zwp_locked_pointer_v1*> (c_ptr());
}

void zwp_locked_pointer_v1_t::set_cursor_position_hint(double surface_x, double surface_y)
{
  marshal(1U, surface_x, surface_y);
}


void zwp_locked_pointer_v1_t::set_region(region_t const& region)
{
  marshal(2U, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr);
}


std::function<void()> &zwp_locked_pointer_v1_t::on_locked()
{
  return std::static_pointer_cast<events_t>(get_events())->locked;
}

std::function<void()> &zwp_locked_pointer_v1_t::on_unlocked()
{
  return std::static_pointer_cast<events_t>(get_events())->unlocked;
}

int zwp_locked_pointer_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->locked) events->locked();
      break;
    case 1:
      if(events->unlocked) events->unlocked();
      break;
    }
  return 0;
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_confined_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_confined_pointer_v1_t(p); });
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t()
{
  set_interface(&zwp_confined_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_confined_pointer_v1_t(p); });
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t(zwp_confined_pointer_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_confined_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_confined_pointer_v1_t(p); });
}

zwp_confined_pointer_v1_t::zwp_confined_pointer_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_confined_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_confined_pointer_v1_t(p); });
}

zwp_confined_pointer_v1_t zwp_confined_pointer_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_confined_pointer_v1_t::interface_name = "zwp_confined_pointer_v1";

zwp_confined_pointer_v1_t::operator zwp_confined_pointer_v1*() const
{
  return reinterpret_cast<zwp_confined_pointer_v1*> (c_ptr());
}

void zwp_confined_pointer_v1_t::set_region(region_t const& region)
{
  marshal(1U, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr);
}


std::function<void()> &zwp_confined_pointer_v1_t::on_confined()
{
  return std::static_pointer_cast<events_t>(get_events())->confined;
}

std::function<void()> &zwp_confined_pointer_v1_t::on_unconfined()
{
  return std::static_pointer_cast<events_t>(get_events())->unconfined;
}

int zwp_confined_pointer_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->confined) events->confined();
      break;
    case 1:
      if(events->unconfined) events->unconfined();
      break;
    }
  return 0;
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_pointer_gestures_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gestures_v1_t(p); });
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t()
{
  set_interface(&zwp_pointer_gestures_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gestures_v1_t(p); });
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t(zwp_pointer_gestures_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_pointer_gestures_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gestures_v1_t(p); });
}

zwp_pointer_gestures_v1_t::zwp_pointer_gestures_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_pointer_gestures_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gestures_v1_t(p); });
}

zwp_pointer_gestures_v1_t zwp_pointer_gestures_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_pointer_gestures_v1_t::interface_name = "zwp_pointer_gestures_v1";

zwp_pointer_gestures_v1_t::operator zwp_pointer_gestures_v1*() const
{
  return reinterpret_cast<zwp_pointer_gestures_v1*> (c_ptr());
}

zwp_pointer_gesture_swipe_v1_t zwp_pointer_gestures_v1_t::get_swipe_gesture(pointer_t const& pointer)
{
  proxy_t p = marshal_constructor(0U, &zwp_pointer_gesture_swipe_v1_interface, nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr);
  return zwp_pointer_gesture_swipe_v1_t(p);
}


zwp_pointer_gesture_pinch_v1_t zwp_pointer_gestures_v1_t::get_pinch_gesture(pointer_t const& pointer)
{
  proxy_t p = marshal_constructor(1U, &zwp_pointer_gesture_pinch_v1_interface, nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr);
  return zwp_pointer_gesture_pinch_v1_t(p);
}


void zwp_pointer_gestures_v1_t::release()
{
  marshal(2U);
}

bool zwp_pointer_gestures_v1_t::can_release() const
{
  return (get_version() >= release_since_version);
}


zwp_pointer_gesture_hold_v1_t zwp_pointer_gestures_v1_t::get_hold_gesture(pointer_t const& pointer)
{
  proxy_t p = marshal_constructor(3U, &zwp_pointer_gesture_hold_v1_interface, nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr);
  return zwp_pointer_gesture_hold_v1_t(p);
}

bool zwp_pointer_gestures_v1_t::can_get_hold_gesture() const
{
  return (get_version() >= get_hold_gesture_since_version);
}


int zwp_pointer_gestures_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_swipe_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_swipe_v1_t(p); });
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t()
{
  set_interface(&zwp_pointer_gesture_swipe_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_swipe_v1_t(p); });
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t(zwp_pointer_gesture_swipe_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_swipe_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_swipe_v1_t(p); });
}

zwp_pointer_gesture_swipe_v1_t::zwp_pointer_gesture_swipe_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_pointer_gesture_swipe_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_swipe_v1_t(p); });
}

zwp_pointer_gesture_swipe_v1_t zwp_pointer_gesture_swipe_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_pointer_gesture_swipe_v1_t::interface_name = "zwp_pointer_gesture_swipe_v1";

zwp_pointer_gesture_swipe_v1_t::operator zwp_pointer_gesture_swipe_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_swipe_v1*> (c_ptr());
}

std::function<void(uint32_t, uint32_t, surface_t, uint32_t)> &zwp_pointer_gesture_swipe_v1_t::on_begin()
{
  return std::static_pointer_cast<events_t>(get_events())->begin;
}

std::function<void(uint32_t, double, double)> &zwp_pointer_gesture_swipe_v1_t::on_update()
{
  return std::static_pointer_cast<events_t>(get_events())->update;
}

std::function<void(uint32_t, uint32_t, int32_t)> &zwp_pointer_gesture_swipe_v1_t::on_end()
{
  return std::static_pointer_cast<events_t>(get_events())->end;
}

int zwp_pointer_gesture_swipe_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->begin) events->begin(args[0].get<uint32_t>(), args[1].get<uint32_t>(), surface_t(args[2].get<proxy_t>()), args[3].get<uint32_t>());
      break;
    case 1:
      if(events->update) events->update(args[0].get<uint32_t>(), args[1].get<double>(), args[2].get<double>());
      break;
    case 2:
      if(events->end) events->end(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<int32_t>());
      break;
    }
  return 0;
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_pinch_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_pinch_v1_t(p); });
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t()
{
  set_interface(&zwp_pointer_gesture_pinch_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_pinch_v1_t(p); });
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t(zwp_pointer_gesture_pinch_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_pinch_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_pinch_v1_t(p); });
}

zwp_pointer_gesture_pinch_v1_t::zwp_pointer_gesture_pinch_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_pointer_gesture_pinch_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_pinch_v1_t(p); });
}

zwp_pointer_gesture_pinch_v1_t zwp_pointer_gesture_pinch_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_pointer_gesture_pinch_v1_t::interface_name = "zwp_pointer_gesture_pinch_v1";

zwp_pointer_gesture_pinch_v1_t::operator zwp_pointer_gesture_pinch_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_pinch_v1*> (c_ptr());
}

std::function<void(uint32_t, uint32_t, surface_t, uint32_t)> &zwp_pointer_gesture_pinch_v1_t::on_begin()
{
  return std::static_pointer_cast<events_t>(get_events())->begin;
}

std::function<void(uint32_t, double, double, double, double)> &zwp_pointer_gesture_pinch_v1_t::on_update()
{
  return std::static_pointer_cast<events_t>(get_events())->update;
}

std::function<void(uint32_t, uint32_t, int32_t)> &zwp_pointer_gesture_pinch_v1_t::on_end()
{
  return std::static_pointer_cast<events_t>(get_events())->end;
}

int zwp_pointer_gesture_pinch_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->begin) events->begin(args[0].get<uint32_t>(), args[1].get<uint32_t>(), surface_t(args[2].get<proxy_t>()), args[3].get<uint32_t>());
      break;
    case 1:
      if(events->update) events->update(args[0].get<uint32_t>(), args[1].get<double>(), args[2].get<double>(), args[3].get<double>(), args[4].get<double>());
      break;
    case 2:
      if(events->end) events->end(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<int32_t>());
      break;
    }
  return 0;
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_hold_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_hold_v1_t(p); });
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t()
{
  set_interface(&zwp_pointer_gesture_hold_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_hold_v1_t(p); });
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t(zwp_pointer_gesture_hold_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_pointer_gesture_hold_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_hold_v1_t(p); });
}

zwp_pointer_gesture_hold_v1_t::zwp_pointer_gesture_hold_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_pointer_gesture_hold_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_pointer_gesture_hold_v1_t(p); });
}

zwp_pointer_gesture_hold_v1_t zwp_pointer_gesture_hold_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_pointer_gesture_hold_v1_t::interface_name = "zwp_pointer_gesture_hold_v1";

zwp_pointer_gesture_hold_v1_t::operator zwp_pointer_gesture_hold_v1*() const
{
  return reinterpret_cast<zwp_pointer_gesture_hold_v1*> (c_ptr());
}

std::function<void(uint32_t, uint32_t, surface_t, uint32_t)> &zwp_pointer_gesture_hold_v1_t::on_begin()
{
  return std::static_pointer_cast<events_t>(get_events())->begin;
}

std::function<void(uint32_t, uint32_t, int32_t)> &zwp_pointer_gesture_hold_v1_t::on_end()
{
  return std::static_pointer_cast<events_t>(get_events())->end;
}

int zwp_pointer_gesture_hold_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->begin) events->begin(args[0].get<uint32_t>(), args[1].get<uint32_t>(), surface_t(args[2].get<proxy_t>()), args[3].get<uint32_t>());
      break;
    case 1:
      if(events->end) events->end(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<int32_t>());
      break;
    }
  return 0;
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(2U);
    }
  set_interface(&zwp_primary_selection_device_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_manager_v1_t(p); });
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t()
{
  set_interface(&zwp_primary_selection_device_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_manager_v1_t(p); });
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t(zwp_primary_selection_device_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(2U);
    }
  set_interface(&zwp_primary_selection_device_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_manager_v1_t(p); });
}

zwp_primary_selection_device_manager_v1_t::zwp_primary_selection_device_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_primary_selection_device_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_manager_v1_t(p); });
}

zwp_primary_selection_device_manager_v1_t zwp_primary_selection_device_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_primary_selection_device_manager_v1_t::interface_name = "zwp_primary_selection_device_manager_v1";

zwp_primary_selection_device_manager_v1_t::operator zwp_primary_selection_device_manager_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_device_manager_v1*> (c_ptr());
}

zwp_primary_selection_source_v1_t zwp_primary_selection_device_manager_v1_t::create_source()
{
  proxy_t p = marshal_constructor(0U, &zwp_primary_selection_source_v1_interface, nullptr);
  return zwp_primary_selection_source_v1_t(p);
}


zwp_primary_selection_device_v1_t zwp_primary_selection_device_manager_v1_t::get_device(seat_t const& seat)
{
  proxy_t p = marshal_constructor(1U, &zwp_primary_selection_device_v1_interface, nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_primary_selection_device_v1_t(p);
}


int zwp_primary_selection_device_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_device_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_v1_t(p); });
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t()
{
  set_interface(&zwp_primary_selection_device_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_v1_t(p); });
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t(zwp_primary_selection_device_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_device_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_v1_t(p); });
}

zwp_primary_selection_device_v1_t::zwp_primary_selection_device_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_primary_selection_device_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_device_v1_t(p); });
}

zwp_primary_selection_device_v1_t zwp_primary_selection_device_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_primary_selection_device_v1_t::interface_name = "zwp_primary_selection_device_v1";

zwp_primary_selection_device_v1_t::operator zwp_primary_selection_device_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_device_v1*> (c_ptr());
}

void zwp_primary_selection_device_v1_t::set_selection(zwp_primary_selection_source_v1_t const& source, uint32_t serial)
{
  marshal(0U, source.proxy_has_object() ? reinterpret_cast<wl_object*>(source.c_ptr()) : nullptr, serial);
}


std::function<void(zwp_primary_selection_offer_v1_t)> &zwp_primary_selection_device_v1_t::on_data_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->data_offer;
}

std::function<void(zwp_primary_selection_offer_v1_t)> &zwp_primary_selection_device_v1_t::on_selection()
{
  return std::static_pointer_cast<events_t>(get_events())->selection;
}

int zwp_primary_selection_device_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->data_offer) events->data_offer(zwp_primary_selection_offer_v1_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->selection) events->selection(zwp_primary_selection_offer_v1_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_offer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_offer_v1_t(p); });
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t()
{
  set_interface(&zwp_primary_selection_offer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_offer_v1_t(p); });
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t(zwp_primary_selection_offer_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_offer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_offer_v1_t(p); });
}

zwp_primary_selection_offer_v1_t::zwp_primary_selection_offer_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_primary_selection_offer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_offer_v1_t(p); });
}

zwp_primary_selection_offer_v1_t zwp_primary_selection_offer_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_primary_selection_offer_v1_t::interface_name = "zwp_primary_selection_offer_v1";

zwp_primary_selection_offer_v1_t::operator zwp_primary_selection_offer_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_offer_v1*> (c_ptr());
}

void zwp_primary_selection_offer_v1_t::receive(std::string const& mime_type, int fd)
{
  marshal(0U, mime_type, argument_t::fd(fd));
}


std::function<void(std::string)> &zwp_primary_selection_offer_v1_t::on_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->offer;
}

int zwp_primary_selection_offer_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->offer) events->offer(args[0].get<std::string>());
      break;
    }
  return 0;
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_source_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_source_v1_t(p); });
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t()
{
  set_interface(&zwp_primary_selection_source_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_source_v1_t(p); });
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t(zwp_primary_selection_source_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_primary_selection_source_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_source_v1_t(p); });
}

zwp_primary_selection_source_v1_t::zwp_primary_selection_source_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_primary_selection_source_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_primary_selection_source_v1_t(p); });
}

zwp_primary_selection_source_v1_t zwp_primary_selection_source_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_primary_selection_source_v1_t::interface_name = "zwp_primary_selection_source_v1";

zwp_primary_selection_source_v1_t::operator zwp_primary_selection_source_v1*() const
{
  return reinterpret_cast<zwp_primary_selection_source_v1*> (c_ptr());
}

void zwp_primary_selection_source_v1_t::offer(std::string const& mime_type)
{
  marshal(0U, mime_type);
}


std::function<void(std::string, int)> &zwp_primary_selection_source_v1_t::on_send()
{
  return std::static_pointer_cast<events_t>(get_events())->send;
}

std::function<void()> &zwp_primary_selection_source_v1_t::on_cancelled()
{
  return std::static_pointer_cast<events_t>(get_events())->cancelled;
}

int zwp_primary_selection_source_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->send) events->send(args[0].get<std::string>(), args[1].get<int>());
      break;
    case 1:
      if(events->cancelled) events->cancelled();
      break;
    }
  return 0;
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_relative_pointer_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_manager_v1_t(p); });
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t()
{
  set_interface(&zwp_relative_pointer_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_manager_v1_t(p); });
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t(zwp_relative_pointer_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_relative_pointer_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_manager_v1_t(p); });
}

zwp_relative_pointer_manager_v1_t::zwp_relative_pointer_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_relative_pointer_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_manager_v1_t(p); });
}

zwp_relative_pointer_manager_v1_t zwp_relative_pointer_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_relative_pointer_manager_v1_t::interface_name = "zwp_relative_pointer_manager_v1";

zwp_relative_pointer_manager_v1_t::operator zwp_relative_pointer_manager_v1*() const
{
  return reinterpret_cast<zwp_relative_pointer_manager_v1*> (c_ptr());
}

zwp_relative_pointer_v1_t zwp_relative_pointer_manager_v1_t::get_relative_pointer(pointer_t const& pointer)
{
  proxy_t p = marshal_constructor(1U, &zwp_relative_pointer_v1_interface, nullptr, pointer.proxy_has_object() ? reinterpret_cast<wl_object*>(pointer.c_ptr()) : nullptr);
  return zwp_relative_pointer_v1_t(p);
}


int zwp_relative_pointer_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_relative_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_v1_t(p); });
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t()
{
  set_interface(&zwp_relative_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_v1_t(p); });
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t(zwp_relative_pointer_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_relative_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_v1_t(p); });
}

zwp_relative_pointer_v1_t::zwp_relative_pointer_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_relative_pointer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_relative_pointer_v1_t(p); });
}

zwp_relative_pointer_v1_t zwp_relative_pointer_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_relative_pointer_v1_t::interface_name = "zwp_relative_pointer_v1";

zwp_relative_pointer_v1_t::operator zwp_relative_pointer_v1*() const
{
  return reinterpret_cast<zwp_relative_pointer_v1*> (c_ptr());
}

std::function<void(uint32_t, uint32_t, double, double, double, double)> &zwp_relative_pointer_v1_t::on_relative_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->relative_motion;
}

int zwp_relative_pointer_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->relative_motion) events->relative_motion(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<double>(), args[3].get<double>(), args[4].get<double>(), args[5].get<double>());
      break;
    }
  return 0;
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v1_t(p); });
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t()
{
  set_interface(&zwp_tablet_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v1_t(p); });
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t(zwp_tablet_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v1_t(p); });
}

zwp_tablet_manager_v1_t::zwp_tablet_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v1_t(p); });
}

zwp_tablet_manager_v1_t zwp_tablet_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_manager_v1_t::interface_name = "zwp_tablet_manager_v1";

zwp_tablet_manager_v1_t::operator zwp_tablet_manager_v1*() const
{
  return reinterpret_cast<zwp_tablet_manager_v1*> (c_ptr());
}

zwp_tablet_seat_v1_t zwp_tablet_manager_v1_t::get_tablet_seat(seat_t const& seat)
{
  proxy_t p = marshal_constructor(0U, &zwp_tablet_seat_v1_interface, nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_tablet_seat_v1_t(p);
}


int zwp_tablet_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_seat_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v1_t(p); });
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t()
{
  set_interface(&zwp_tablet_seat_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v1_t(p); });
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t(zwp_tablet_seat_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_seat_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v1_t(p); });
}

zwp_tablet_seat_v1_t::zwp_tablet_seat_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_seat_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v1_t(p); });
}

zwp_tablet_seat_v1_t zwp_tablet_seat_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_seat_v1_t::interface_name = "zwp_tablet_seat_v1";

zwp_tablet_seat_v1_t::operator zwp_tablet_seat_v1*() const
{
  return reinterpret_cast<zwp_tablet_seat_v1*> (c_ptr());
}

std::function<void(zwp_tablet_v1_t)> &zwp_tablet_seat_v1_t::on_tablet_added()
{
  return std::static_pointer_cast<events_t>(get_events())->tablet_added;
}

std::function<void(zwp_tablet_tool_v1_t)> &zwp_tablet_seat_v1_t::on_tool_added()
{
  return std::static_pointer_cast<events_t>(get_events())->tool_added;
}

int zwp_tablet_seat_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->tablet_added) events->tablet_added(zwp_tablet_v1_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->tool_added) events->tool_added(zwp_tablet_tool_v1_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_tool_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v1_t(p); });
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t()
{
  set_interface(&zwp_tablet_tool_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v1_t(p); });
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t(zwp_tablet_tool_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_tool_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v1_t(p); });
}

zwp_tablet_tool_v1_t::zwp_tablet_tool_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_tool_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v1_t(p); });
}

zwp_tablet_tool_v1_t zwp_tablet_tool_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_tool_v1_t::interface_name = "zwp_tablet_tool_v1";

zwp_tablet_tool_v1_t::operator zwp_tablet_tool_v1*() const
{
  return reinterpret_cast<zwp_tablet_tool_v1*> (c_ptr());
}

void zwp_tablet_tool_v1_t::set_cursor(uint32_t serial, surface_t const& surface, int32_t hotspot_x, int32_t hotspot_y)
{
  marshal(0U, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, hotspot_x, hotspot_y);
}


std::function<void(zwp_tablet_tool_v1_type)> &zwp_tablet_tool_v1_t::on_type()
{
  return std::static_pointer_cast<events_t>(get_events())->type;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_tool_v1_t::on_hardware_serial()
{
  return std::static_pointer_cast<events_t>(get_events())->hardware_serial;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_tool_v1_t::on_hardware_id_wacom()
{
  return std::static_pointer_cast<events_t>(get_events())->hardware_id_wacom;
}

std::function<void(zwp_tablet_tool_v1_capability)> &zwp_tablet_tool_v1_t::on_capability()
{
  return std::static_pointer_cast<events_t>(get_events())->capability;
}

std::function<void()> &zwp_tablet_tool_v1_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void()> &zwp_tablet_tool_v1_t::on_removed()
{
  return std::static_pointer_cast<events_t>(get_events())->removed;
}

std::function<void(uint32_t, zwp_tablet_v1_t, surface_t)> &zwp_tablet_tool_v1_t::on_proximity_in()
{
  return std::static_pointer_cast<events_t>(get_events())->proximity_in;
}

std::function<void()> &zwp_tablet_tool_v1_t::on_proximity_out()
{
  return std::static_pointer_cast<events_t>(get_events())->proximity_out;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v1_t::on_down()
{
  return std::static_pointer_cast<events_t>(get_events())->down;
}

std::function<void()> &zwp_tablet_tool_v1_t::on_up()
{
  return std::static_pointer_cast<events_t>(get_events())->up;
}

std::function<void(double, double)> &zwp_tablet_tool_v1_t::on_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->motion;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v1_t::on_pressure()
{
  return std::static_pointer_cast<events_t>(get_events())->pressure;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v1_t::on_distance()
{
  return std::static_pointer_cast<events_t>(get_events())->distance;
}

std::function<void(int32_t, int32_t)> &zwp_tablet_tool_v1_t::on_tilt()
{
  return std::static_pointer_cast<events_t>(get_events())->tilt;
}

std::function<void(int32_t)> &zwp_tablet_tool_v1_t::on_rotation()
{
  return std::static_pointer_cast<events_t>(get_events())->rotation;
}

std::function<void(int32_t)> &zwp_tablet_tool_v1_t::on_slider()
{
  return std::static_pointer_cast<events_t>(get_events())->slider;
}

std::function<void(int32_t, int32_t)> &zwp_tablet_tool_v1_t::on_wheel()
{
  return std::static_pointer_cast<events_t>(get_events())->wheel;
}

std::function<void(uint32_t, uint32_t, zwp_tablet_tool_v1_button_state)> &zwp_tablet_tool_v1_t::on_button()
{
  return std::static_pointer_cast<events_t>(get_events())->button;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v1_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

int zwp_tablet_tool_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->type) events->type(zwp_tablet_tool_v1_type(args[0].get<uint32_t>()));
      break;
    case 1:
      if(events->hardware_serial) events->hardware_serial(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->hardware_id_wacom) events->hardware_id_wacom(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 3:
      if(events->capability) events->capability(zwp_tablet_tool_v1_capability(args[0].get<uint32_t>()));
      break;
    case 4:
      if(events->done) events->done();
      break;
    case 5:
      if(events->removed) events->removed();
      break;
    case 6:
      if(events->proximity_in) events->proximity_in(args[0].get<uint32_t>(), zwp_tablet_v1_t(args[1].get<proxy_t>()), surface_t(args[2].get<proxy_t>()));
      break;
    case 7:
      if(events->proximity_out) events->proximity_out();
      break;
    case 8:
      if(events->down) events->down(args[0].get<uint32_t>());
      break;
    case 9:
      if(events->up) events->up();
      break;
    case 10:
      if(events->motion) events->motion(args[0].get<double>(), args[1].get<double>());
      break;
    case 11:
      if(events->pressure) events->pressure(args[0].get<uint32_t>());
      break;
    case 12:
      if(events->distance) events->distance(args[0].get<uint32_t>());
      break;
    case 13:
      if(events->tilt) events->tilt(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 14:
      if(events->rotation) events->rotation(args[0].get<int32_t>());
      break;
    case 15:
      if(events->slider) events->slider(args[0].get<int32_t>());
      break;
    case 16:
      if(events->wheel) events->wheel(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 17:
      if(events->button) events->button(args[0].get<uint32_t>(), args[1].get<uint32_t>(), zwp_tablet_tool_v1_button_state(args[2].get<uint32_t>()));
      break;
    case 18:
      if(events->frame) events->frame(args[0].get<uint32_t>());
      break;
    }
  return 0;
}





zwp_tablet_v1_t::zwp_tablet_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v1_t(p); });
}

zwp_tablet_v1_t::zwp_tablet_v1_t()
{
  set_interface(&zwp_tablet_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v1_t(p); });
}

zwp_tablet_v1_t::zwp_tablet_v1_t(zwp_tablet_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v1_t(p); });
}

zwp_tablet_v1_t::zwp_tablet_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v1_t(p); });
}

zwp_tablet_v1_t zwp_tablet_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_v1_t::interface_name = "zwp_tablet_v1";

zwp_tablet_v1_t::operator zwp_tablet_v1*() const
{
  return reinterpret_cast<zwp_tablet_v1*> (c_ptr());
}

std::function<void(std::string)> &zwp_tablet_v1_t::on_name()
{
  return std::static_pointer_cast<events_t>(get_events())->name;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_v1_t::on_id()
{
  return std::static_pointer_cast<events_t>(get_events())->id;
}

std::function<void(std::string)> &zwp_tablet_v1_t::on_path()
{
  return std::static_pointer_cast<events_t>(get_events())->path;
}

std::function<void()> &zwp_tablet_v1_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void()> &zwp_tablet_v1_t::on_removed()
{
  return std::static_pointer_cast<events_t>(get_events())->removed;
}

int zwp_tablet_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->name) events->name(args[0].get<std::string>());
      break;
    case 1:
      if(events->id) events->id(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->path) events->path(args[0].get<std::string>());
      break;
    case 3:
      if(events->done) events->done();
      break;
    case 4:
      if(events->removed) events->removed();
      break;
    }
  return 0;
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_manager_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v2_t(p); });
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t()
{
  set_interface(&zwp_tablet_manager_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v2_t(p); });
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t(zwp_tablet_manager_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_manager_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v2_t(p); });
}

zwp_tablet_manager_v2_t::zwp_tablet_manager_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_manager_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_manager_v2_t(p); });
}

zwp_tablet_manager_v2_t zwp_tablet_manager_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_manager_v2_t::interface_name = "zwp_tablet_manager_v2";

zwp_tablet_manager_v2_t::operator zwp_tablet_manager_v2*() const
{
  return reinterpret_cast<zwp_tablet_manager_v2*> (c_ptr());
}

zwp_tablet_seat_v2_t zwp_tablet_manager_v2_t::get_tablet_seat(seat_t const& seat)
{
  proxy_t p = marshal_constructor(0U, &zwp_tablet_seat_v2_interface, nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_tablet_seat_v2_t(p);
}


int zwp_tablet_manager_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_seat_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v2_t(p); });
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t()
{
  set_interface(&zwp_tablet_seat_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v2_t(p); });
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t(zwp_tablet_seat_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_seat_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v2_t(p); });
}

zwp_tablet_seat_v2_t::zwp_tablet_seat_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_seat_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_seat_v2_t(p); });
}

zwp_tablet_seat_v2_t zwp_tablet_seat_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_seat_v2_t::interface_name = "zwp_tablet_seat_v2";

zwp_tablet_seat_v2_t::operator zwp_tablet_seat_v2*() const
{
  return reinterpret_cast<zwp_tablet_seat_v2*> (c_ptr());
}

std::function<void(zwp_tablet_v2_t)> &zwp_tablet_seat_v2_t::on_tablet_added()
{
  return std::static_pointer_cast<events_t>(get_events())->tablet_added;
}

std::function<void(zwp_tablet_tool_v2_t)> &zwp_tablet_seat_v2_t::on_tool_added()
{
  return std::static_pointer_cast<events_t>(get_events())->tool_added;
}

std::function<void(zwp_tablet_pad_v2_t)> &zwp_tablet_seat_v2_t::on_pad_added()
{
  return std::static_pointer_cast<events_t>(get_events())->pad_added;
}

int zwp_tablet_seat_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->tablet_added) events->tablet_added(zwp_tablet_v2_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->tool_added) events->tool_added(zwp_tablet_tool_v2_t(args[0].get<proxy_t>()));
      break;
    case 2:
      if(events->pad_added) events->pad_added(zwp_tablet_pad_v2_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_tool_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v2_t(p); });
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t()
{
  set_interface(&zwp_tablet_tool_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v2_t(p); });
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t(zwp_tablet_tool_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_tool_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v2_t(p); });
}

zwp_tablet_tool_v2_t::zwp_tablet_tool_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_tool_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_tool_v2_t(p); });
}

zwp_tablet_tool_v2_t zwp_tablet_tool_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_tool_v2_t::interface_name = "zwp_tablet_tool_v2";

zwp_tablet_tool_v2_t::operator zwp_tablet_tool_v2*() const
{
  return reinterpret_cast<zwp_tablet_tool_v2*> (c_ptr());
}

void zwp_tablet_tool_v2_t::set_cursor(uint32_t serial, surface_t const& surface, int32_t hotspot_x, int32_t hotspot_y)
{
  marshal(0U, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, hotspot_x, hotspot_y);
}


std::function<void(zwp_tablet_tool_v2_type)> &zwp_tablet_tool_v2_t::on_type()
{
  return std::static_pointer_cast<events_t>(get_events())->type;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_tool_v2_t::on_hardware_serial()
{
  return std::static_pointer_cast<events_t>(get_events())->hardware_serial;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_tool_v2_t::on_hardware_id_wacom()
{
  return std::static_pointer_cast<events_t>(get_events())->hardware_id_wacom;
}

std::function<void(zwp_tablet_tool_v2_capability)> &zwp_tablet_tool_v2_t::on_capability()
{
  return std::static_pointer_cast<events_t>(get_events())->capability;
}

std::function<void()> &zwp_tablet_tool_v2_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void()> &zwp_tablet_tool_v2_t::on_removed()
{
  return std::static_pointer_cast<events_t>(get_events())->removed;
}

std::function<void(uint32_t, zwp_tablet_v2_t, surface_t)> &zwp_tablet_tool_v2_t::on_proximity_in()
{
  return std::static_pointer_cast<events_t>(get_events())->proximity_in;
}

std::function<void()> &zwp_tablet_tool_v2_t::on_proximity_out()
{
  return std::static_pointer_cast<events_t>(get_events())->proximity_out;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v2_t::on_down()
{
  return std::static_pointer_cast<events_t>(get_events())->down;
}

std::function<void()> &zwp_tablet_tool_v2_t::on_up()
{
  return std::static_pointer_cast<events_t>(get_events())->up;
}

std::function<void(double, double)> &zwp_tablet_tool_v2_t::on_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->motion;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v2_t::on_pressure()
{
  return std::static_pointer_cast<events_t>(get_events())->pressure;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v2_t::on_distance()
{
  return std::static_pointer_cast<events_t>(get_events())->distance;
}

std::function<void(double, double)> &zwp_tablet_tool_v2_t::on_tilt()
{
  return std::static_pointer_cast<events_t>(get_events())->tilt;
}

std::function<void(double)> &zwp_tablet_tool_v2_t::on_rotation()
{
  return std::static_pointer_cast<events_t>(get_events())->rotation;
}

std::function<void(int32_t)> &zwp_tablet_tool_v2_t::on_slider()
{
  return std::static_pointer_cast<events_t>(get_events())->slider;
}

std::function<void(double, int32_t)> &zwp_tablet_tool_v2_t::on_wheel()
{
  return std::static_pointer_cast<events_t>(get_events())->wheel;
}

std::function<void(uint32_t, uint32_t, zwp_tablet_tool_v2_button_state)> &zwp_tablet_tool_v2_t::on_button()
{
  return std::static_pointer_cast<events_t>(get_events())->button;
}

std::function<void(uint32_t)> &zwp_tablet_tool_v2_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

int zwp_tablet_tool_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->type) events->type(zwp_tablet_tool_v2_type(args[0].get<uint32_t>()));
      break;
    case 1:
      if(events->hardware_serial) events->hardware_serial(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->hardware_id_wacom) events->hardware_id_wacom(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 3:
      if(events->capability) events->capability(zwp_tablet_tool_v2_capability(args[0].get<uint32_t>()));
      break;
    case 4:
      if(events->done) events->done();
      break;
    case 5:
      if(events->removed) events->removed();
      break;
    case 6:
      if(events->proximity_in) events->proximity_in(args[0].get<uint32_t>(), zwp_tablet_v2_t(args[1].get<proxy_t>()), surface_t(args[2].get<proxy_t>()));
      break;
    case 7:
      if(events->proximity_out) events->proximity_out();
      break;
    case 8:
      if(events->down) events->down(args[0].get<uint32_t>());
      break;
    case 9:
      if(events->up) events->up();
      break;
    case 10:
      if(events->motion) events->motion(args[0].get<double>(), args[1].get<double>());
      break;
    case 11:
      if(events->pressure) events->pressure(args[0].get<uint32_t>());
      break;
    case 12:
      if(events->distance) events->distance(args[0].get<uint32_t>());
      break;
    case 13:
      if(events->tilt) events->tilt(args[0].get<double>(), args[1].get<double>());
      break;
    case 14:
      if(events->rotation) events->rotation(args[0].get<double>());
      break;
    case 15:
      if(events->slider) events->slider(args[0].get<int32_t>());
      break;
    case 16:
      if(events->wheel) events->wheel(args[0].get<double>(), args[1].get<int32_t>());
      break;
    case 17:
      if(events->button) events->button(args[0].get<uint32_t>(), args[1].get<uint32_t>(), zwp_tablet_tool_v2_button_state(args[2].get<uint32_t>()));
      break;
    case 18:
      if(events->frame) events->frame(args[0].get<uint32_t>());
      break;
    }
  return 0;
}





zwp_tablet_v2_t::zwp_tablet_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v2_t(p); });
}

zwp_tablet_v2_t::zwp_tablet_v2_t()
{
  set_interface(&zwp_tablet_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v2_t(p); });
}

zwp_tablet_v2_t::zwp_tablet_v2_t(zwp_tablet_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v2_t(p); });
}

zwp_tablet_v2_t::zwp_tablet_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_v2_t(p); });
}

zwp_tablet_v2_t zwp_tablet_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_v2_t::interface_name = "zwp_tablet_v2";

zwp_tablet_v2_t::operator zwp_tablet_v2*() const
{
  return reinterpret_cast<zwp_tablet_v2*> (c_ptr());
}

std::function<void(std::string)> &zwp_tablet_v2_t::on_name()
{
  return std::static_pointer_cast<events_t>(get_events())->name;
}

std::function<void(uint32_t, uint32_t)> &zwp_tablet_v2_t::on_id()
{
  return std::static_pointer_cast<events_t>(get_events())->id;
}

std::function<void(std::string)> &zwp_tablet_v2_t::on_path()
{
  return std::static_pointer_cast<events_t>(get_events())->path;
}

std::function<void()> &zwp_tablet_v2_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void()> &zwp_tablet_v2_t::on_removed()
{
  return std::static_pointer_cast<events_t>(get_events())->removed;
}

int zwp_tablet_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->name) events->name(args[0].get<std::string>());
      break;
    case 1:
      if(events->id) events->id(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->path) events->path(args[0].get<std::string>());
      break;
    case 3:
      if(events->done) events->done();
      break;
    case 4:
      if(events->removed) events->removed();
      break;
    }
  return 0;
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_ring_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_ring_v2_t(p); });
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t()
{
  set_interface(&zwp_tablet_pad_ring_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_ring_v2_t(p); });
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t(zwp_tablet_pad_ring_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_ring_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_ring_v2_t(p); });
}

zwp_tablet_pad_ring_v2_t::zwp_tablet_pad_ring_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_pad_ring_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_ring_v2_t(p); });
}

zwp_tablet_pad_ring_v2_t zwp_tablet_pad_ring_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_pad_ring_v2_t::interface_name = "zwp_tablet_pad_ring_v2";

zwp_tablet_pad_ring_v2_t::operator zwp_tablet_pad_ring_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_ring_v2*> (c_ptr());
}

void zwp_tablet_pad_ring_v2_t::set_feedback(std::string const& description, uint32_t serial)
{
  marshal(0U, description, serial);
}


std::function<void(zwp_tablet_pad_ring_v2_source)> &zwp_tablet_pad_ring_v2_t::on_source()
{
  return std::static_pointer_cast<events_t>(get_events())->source;
}

std::function<void(double)> &zwp_tablet_pad_ring_v2_t::on_angle()
{
  return std::static_pointer_cast<events_t>(get_events())->angle;
}

std::function<void()> &zwp_tablet_pad_ring_v2_t::on_stop()
{
  return std::static_pointer_cast<events_t>(get_events())->stop;
}

std::function<void(uint32_t)> &zwp_tablet_pad_ring_v2_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

int zwp_tablet_pad_ring_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->source) events->source(zwp_tablet_pad_ring_v2_source(args[0].get<uint32_t>()));
      break;
    case 1:
      if(events->angle) events->angle(args[0].get<double>());
      break;
    case 2:
      if(events->stop) events->stop();
      break;
    case 3:
      if(events->frame) events->frame(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_strip_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_strip_v2_t(p); });
}

zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t()
{
  set_interface(&zwp_tablet_pad_strip_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_strip_v2_t(p); });
}

zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t(zwp_tablet_pad_strip_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_strip_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_strip_v2_t(p); });
}

zwp_tablet_pad_strip_v2_t::zwp_tablet_pad_strip_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_pad_strip_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_strip_v2_t(p); });
}

zwp_tablet_pad_strip_v2_t zwp_tablet_pad_strip_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_pad_strip_v2_t::interface_name = "zwp_tablet_pad_strip_v2";

zwp_tablet_pad_strip_v2_t::operator zwp_tablet_pad_strip_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_strip_v2*> (c_ptr());
}

void zwp_tablet_pad_strip_v2_t::set_feedback(std::string const& description, uint32_t serial)
{
  marshal(0U, description, serial);
}


std::function<void(zwp_tablet_pad_strip_v2_source)> &zwp_tablet_pad_strip_v2_t::on_source()
{
  return std::static_pointer_cast<events_t>(get_events())->source;
}

std::function<void(uint32_t)> &zwp_tablet_pad_strip_v2_t::on_position()
{
  return std::static_pointer_cast<events_t>(get_events())->position;
}

std::function<void()> &zwp_tablet_pad_strip_v2_t::on_stop()
{
  return std::static_pointer_cast<events_t>(get_events())->stop;
}

std::function<void(uint32_t)> &zwp_tablet_pad_strip_v2_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

int zwp_tablet_pad_strip_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->source) events->source(zwp_tablet_pad_strip_v2_source(args[0].get<uint32_t>()));
      break;
    case 1:
      if(events->position) events->position(args[0].get<uint32_t>());
      break;
    case 2:
      if(events->stop) events->stop();
      break;
    case 3:
      if(events->frame) events->frame(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_pad_group_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_group_v2_t(p); });
}

zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t()
{
  set_interface(&zwp_tablet_pad_group_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_group_v2_t(p); });
}

zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t(zwp_tablet_pad_group_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_tablet_pad_group_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_group_v2_t(p); });
}

zwp_tablet_pad_group_v2_t::zwp_tablet_pad_group_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_pad_group_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_group_v2_t(p); });
}

zwp_tablet_pad_group_v2_t zwp_tablet_pad_group_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_pad_group_v2_t::interface_name = "zwp_tablet_pad_group_v2";

zwp_tablet_pad_group_v2_t::operator zwp_tablet_pad_group_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_group_v2*> (c_ptr());
}

std::function<void(array_t)> &zwp_tablet_pad_group_v2_t::on_buttons()
{
  return std::static_pointer_cast<events_t>(get_events())->buttons;
}

std::function<void(zwp_tablet_pad_ring_v2_t)> &zwp_tablet_pad_group_v2_t::on_ring()
{
  return std::static_pointer_cast<events_t>(get_events())->ring;
}

std::function<void(zwp_tablet_pad_strip_v2_t)> &zwp_tablet_pad_group_v2_t::on_strip()
{
  return std::static_pointer_cast<events_t>(get_events())->strip;
}

std::function<void(uint32_t)> &zwp_tablet_pad_group_v2_t::on_modes()
{
  return std::static_pointer_cast<events_t>(get_events())->modes;
}

std::function<void()> &zwp_tablet_pad_group_v2_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void(uint32_t, uint32_t, uint32_t)> &zwp_tablet_pad_group_v2_t::on_mode_switch()
{
  return std::static_pointer_cast<events_t>(get_events())->mode_switch;
}

int zwp_tablet_pad_group_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->buttons) events->buttons(args[0].get<array_t>());
      break;
    case 1:
      if(events->ring) events->ring(zwp_tablet_pad_ring_v2_t(args[0].get<proxy_t>()));
      break;
    case 2:
      if(events->strip) events->strip(zwp_tablet_pad_strip_v2_t(args[0].get<proxy_t>()));
      break;
    case 3:
      if(events->modes) events->modes(args[0].get<uint32_t>());
      break;
    case 4:
      if(events->done) events->done();
      break;
    case 5:
      if(events->mode_switch) events->mode_switch(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>());
      break;
    }
  return 0;
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_v2_t(p); });
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t()
{
  set_interface(&zwp_tablet_pad_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_v2_t(p); });
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t(zwp_tablet_pad_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&zwp_tablet_pad_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_v2_t(p); });
}

zwp_tablet_pad_v2_t::zwp_tablet_pad_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_tablet_pad_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_tablet_pad_v2_t(p); });
}

zwp_tablet_pad_v2_t zwp_tablet_pad_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_tablet_pad_v2_t::interface_name = "zwp_tablet_pad_v2";

zwp_tablet_pad_v2_t::operator zwp_tablet_pad_v2*() const
{
  return reinterpret_cast<zwp_tablet_pad_v2*> (c_ptr());
}

void zwp_tablet_pad_v2_t::set_feedback(uint32_t button, std::string const& description, uint32_t serial)
{
  marshal(0U, button, description, serial);
}


std::function<void(zwp_tablet_pad_group_v2_t)> &zwp_tablet_pad_v2_t::on_group()
{
  return std::static_pointer_cast<events_t>(get_events())->group;
}

std::function<void(std::string)> &zwp_tablet_pad_v2_t::on_path()
{
  return std::static_pointer_cast<events_t>(get_events())->path;
}

std::function<void(uint32_t)> &zwp_tablet_pad_v2_t::on_buttons()
{
  return std::static_pointer_cast<events_t>(get_events())->buttons;
}

std::function<void()> &zwp_tablet_pad_v2_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void(uint32_t, uint32_t, zwp_tablet_pad_v2_button_state)> &zwp_tablet_pad_v2_t::on_button()
{
  return std::static_pointer_cast<events_t>(get_events())->button;
}

std::function<void(uint32_t, zwp_tablet_v2_t, surface_t)> &zwp_tablet_pad_v2_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void(uint32_t, surface_t)> &zwp_tablet_pad_v2_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void()> &zwp_tablet_pad_v2_t::on_removed()
{
  return std::static_pointer_cast<events_t>(get_events())->removed;
}

int zwp_tablet_pad_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->group) events->group(zwp_tablet_pad_group_v2_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->path) events->path(args[0].get<std::string>());
      break;
    case 2:
      if(events->buttons) events->buttons(args[0].get<uint32_t>());
      break;
    case 3:
      if(events->done) events->done();
      break;
    case 4:
      if(events->button) events->button(args[0].get<uint32_t>(), args[1].get<uint32_t>(), zwp_tablet_pad_v2_button_state(args[2].get<uint32_t>()));
      break;
    case 5:
      if(events->enter) events->enter(args[0].get<uint32_t>(), zwp_tablet_v2_t(args[1].get<proxy_t>()), surface_t(args[2].get<proxy_t>()));
      break;
    case 6:
      if(events->leave) events->leave(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()));
      break;
    case 7:
      if(events->removed) events->removed();
      break;
    }
  return 0;
}


zwp_text_input_v1_t::zwp_text_input_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_text_input_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v1_t(p); });
}

zwp_text_input_v1_t::zwp_text_input_v1_t()
{
  set_interface(&zwp_text_input_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v1_t(p); });
}

zwp_text_input_v1_t::zwp_text_input_v1_t(zwp_text_input_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_text_input_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v1_t(p); });
}

zwp_text_input_v1_t::zwp_text_input_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_text_input_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v1_t(p); });
}

zwp_text_input_v1_t zwp_text_input_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_text_input_v1_t::interface_name = "zwp_text_input_v1";

zwp_text_input_v1_t::operator zwp_text_input_v1*() const
{
  return reinterpret_cast<zwp_text_input_v1*> (c_ptr());
}

void zwp_text_input_v1_t::activate(seat_t const& seat, surface_t const& surface)
{
  marshal(0U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}


void zwp_text_input_v1_t::deactivate(seat_t const& seat)
{
  marshal(1U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
}


void zwp_text_input_v1_t::show_input_panel()
{
  marshal(2U);
}


void zwp_text_input_v1_t::hide_input_panel()
{
  marshal(3U);
}


void zwp_text_input_v1_t::reset()
{
  marshal(4U);
}


void zwp_text_input_v1_t::set_surrounding_text(std::string const& text, uint32_t cursor, uint32_t anchor)
{
  marshal(5U, text, cursor, anchor);
}


void zwp_text_input_v1_t::set_content_type(zwp_text_input_v1_content_hint const& hint, zwp_text_input_v1_content_purpose const& purpose)
{
  marshal(6U, static_cast<uint32_t>(hint), static_cast<uint32_t>(purpose));
}


void zwp_text_input_v1_t::set_cursor_rectangle(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(7U, x, y, width, height);
}


void zwp_text_input_v1_t::set_preferred_language(std::string const& language)
{
  marshal(8U, language);
}


void zwp_text_input_v1_t::commit_state(uint32_t serial)
{
  marshal(9U, serial);
}


void zwp_text_input_v1_t::invoke_action(uint32_t button, uint32_t index)
{
  marshal(10U, button, index);
}


std::function<void(surface_t)> &zwp_text_input_v1_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void()> &zwp_text_input_v1_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void(array_t)> &zwp_text_input_v1_t::on_modifiers_map()
{
  return std::static_pointer_cast<events_t>(get_events())->modifiers_map;
}

std::function<void(uint32_t)> &zwp_text_input_v1_t::on_input_panel_state()
{
  return std::static_pointer_cast<events_t>(get_events())->input_panel_state;
}

std::function<void(uint32_t, std::string, std::string)> &zwp_text_input_v1_t::on_preedit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_string;
}

std::function<void(uint32_t, uint32_t, zwp_text_input_v1_preedit_style)> &zwp_text_input_v1_t::on_preedit_styling()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_styling;
}

std::function<void(int32_t)> &zwp_text_input_v1_t::on_preedit_cursor()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_cursor;
}

std::function<void(uint32_t, std::string)> &zwp_text_input_v1_t::on_commit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->commit_string;
}

std::function<void(int32_t, int32_t)> &zwp_text_input_v1_t::on_cursor_position()
{
  return std::static_pointer_cast<events_t>(get_events())->cursor_position;
}

std::function<void(int32_t, uint32_t)> &zwp_text_input_v1_t::on_delete_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->delete_surrounding_text;
}

std::function<void(uint32_t, uint32_t, uint32_t, keyboard_key_state, uint32_t)> &zwp_text_input_v1_t::on_keysym()
{
  return std::static_pointer_cast<events_t>(get_events())->keysym;
}

std::function<void(uint32_t, std::string)> &zwp_text_input_v1_t::on_language()
{
  return std::static_pointer_cast<events_t>(get_events())->language;
}

std::function<void(uint32_t, zwp_text_input_v1_text_direction)> &zwp_text_input_v1_t::on_text_direction()
{
  return std::static_pointer_cast<events_t>(get_events())->text_direction;
}

int zwp_text_input_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->enter) events->enter(surface_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->leave) events->leave();
      break;
    case 2:
      if(events->modifiers_map) events->modifiers_map(args[0].get<array_t>());
      break;
    case 3:
      if(events->input_panel_state) events->input_panel_state(args[0].get<uint32_t>());
      break;
    case 4:
      if(events->preedit_string) events->preedit_string(args[0].get<uint32_t>(), args[1].get<std::string>(), args[2].get<std::string>());
      break;
    case 5:
      if(events->preedit_styling) events->preedit_styling(args[0].get<uint32_t>(), args[1].get<uint32_t>(), zwp_text_input_v1_preedit_style(args[2].get<uint32_t>()));
      break;
    case 6:
      if(events->preedit_cursor) events->preedit_cursor(args[0].get<int32_t>());
      break;
    case 7:
      if(events->commit_string) events->commit_string(args[0].get<uint32_t>(), args[1].get<std::string>());
      break;
    case 8:
      if(events->cursor_position) events->cursor_position(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 9:
      if(events->delete_surrounding_text) events->delete_surrounding_text(args[0].get<int32_t>(), args[1].get<uint32_t>());
      break;
    case 10:
      if(events->keysym) events->keysym(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), keyboard_key_state(args[3].get<uint32_t>()), args[4].get<uint32_t>());
      break;
    case 11:
      if(events->language) events->language(args[0].get<uint32_t>(), args[1].get<std::string>());
      break;
    case 12:
      if(events->text_direction) events->text_direction(args[0].get<uint32_t>(), zwp_text_input_v1_text_direction(args[1].get<uint32_t>()));
      break;
    }
  return 0;
}
const bitfield<10, 23> zwp_text_input_v1_content_hint::none{0x0};
const bitfield<10, 23> zwp_text_input_v1_content_hint::_default{0x7};
const bitfield<10, 23> zwp_text_input_v1_content_hint::password{0xc0};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_completion{0x1};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_correction{0x2};
const bitfield<10, 23> zwp_text_input_v1_content_hint::auto_capitalization{0x4};
const bitfield<10, 23> zwp_text_input_v1_content_hint::lowercase{0x8};
const bitfield<10, 23> zwp_text_input_v1_content_hint::uppercase{0x10};
const bitfield<10, 23> zwp_text_input_v1_content_hint::titlecase{0x20};
const bitfield<10, 23> zwp_text_input_v1_content_hint::hidden_text{0x40};
const bitfield<10, 23> zwp_text_input_v1_content_hint::sensitive_data{0x80};
const bitfield<10, 23> zwp_text_input_v1_content_hint::latin{0x100};
const bitfield<10, 23> zwp_text_input_v1_content_hint::multiline{0x200};





zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_text_input_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v1_t(p); });
}

zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t()
{
  set_interface(&zwp_text_input_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v1_t(p); });
}

zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t(zwp_text_input_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&zwp_text_input_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v1_t(p); });
}

zwp_text_input_manager_v1_t::zwp_text_input_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_text_input_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v1_t(p); });
}

zwp_text_input_manager_v1_t zwp_text_input_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_text_input_manager_v1_t::interface_name = "zwp_text_input_manager_v1";

zwp_text_input_manager_v1_t::operator zwp_text_input_manager_v1*() const
{
  return reinterpret_cast<zwp_text_input_manager_v1*> (c_ptr());
}

zwp_text_input_v1_t zwp_text_input_manager_v1_t::create_text_input()
{
  proxy_t p = marshal_constructor(0U, &zwp_text_input_v1_interface, nullptr);
  return zwp_text_input_v1_t(p);
}


int zwp_text_input_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_text_input_v3_t::zwp_text_input_v3_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_text_input_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v3_t(p); });
}

zwp_text_input_v3_t::zwp_text_input_v3_t()
{
  set_interface(&zwp_text_input_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v3_t(p); });
}

zwp_text_input_v3_t::zwp_text_input_v3_t(zwp_text_input_v3 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_text_input_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v3_t(p); });
}

zwp_text_input_v3_t::zwp_text_input_v3_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_text_input_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_v3_t(p); });
}

zwp_text_input_v3_t zwp_text_input_v3_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_text_input_v3_t::interface_name = "zwp_text_input_v3";

zwp_text_input_v3_t::operator zwp_text_input_v3*() const
{
  return reinterpret_cast<zwp_text_input_v3*> (c_ptr());
}

void zwp_text_input_v3_t::enable()
{
  marshal(1U);
}


void zwp_text_input_v3_t::disable()
{
  marshal(2U);
}


void zwp_text_input_v3_t::set_surrounding_text(std::string const& text, int32_t cursor, int32_t anchor)
{
  marshal(3U, text, cursor, anchor);
}


void zwp_text_input_v3_t::set_text_change_cause(zwp_text_input_v3_change_cause const& cause)
{
  marshal(4U, static_cast<uint32_t>(cause));
}


void zwp_text_input_v3_t::set_content_type(zwp_text_input_v3_content_hint const& hint, zwp_text_input_v3_content_purpose const& purpose)
{
  marshal(5U, static_cast<uint32_t>(hint), static_cast<uint32_t>(purpose));
}


void zwp_text_input_v3_t::set_cursor_rectangle(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(6U, x, y, width, height);
}


void zwp_text_input_v3_t::commit()
{
  marshal(7U);
}


std::function<void(surface_t)> &zwp_text_input_v3_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void(surface_t)> &zwp_text_input_v3_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void(std::string, int32_t, int32_t)> &zwp_text_input_v3_t::on_preedit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->preedit_string;
}

std::function<void(std::string)> &zwp_text_input_v3_t::on_commit_string()
{
  return std::static_pointer_cast<events_t>(get_events())->commit_string;
}

std::function<void(uint32_t, uint32_t)> &zwp_text_input_v3_t::on_delete_surrounding_text()
{
  return std::static_pointer_cast<events_t>(get_events())->delete_surrounding_text;
}

std::function<void(uint32_t)> &zwp_text_input_v3_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

int zwp_text_input_v3_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->enter) events->enter(surface_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->leave) events->leave(surface_t(args[0].get<proxy_t>()));
      break;
    case 2:
      if(events->preedit_string) events->preedit_string(args[0].get<std::string>(), args[1].get<int32_t>(), args[2].get<int32_t>());
      break;
    case 3:
      if(events->commit_string) events->commit_string(args[0].get<std::string>());
      break;
    case 4:
      if(events->delete_surrounding_text) events->delete_surrounding_text(args[0].get<uint32_t>(), args[1].get<uint32_t>());
      break;
    case 5:
      if(events->done) events->done(args[0].get<uint32_t>());
      break;
    }
  return 0;
}

const bitfield<10, 28> zwp_text_input_v3_content_hint::none{0x0};
const bitfield<10, 28> zwp_text_input_v3_content_hint::completion{0x1};
const bitfield<10, 28> zwp_text_input_v3_content_hint::spellcheck{0x2};
const bitfield<10, 28> zwp_text_input_v3_content_hint::auto_capitalization{0x4};
const bitfield<10, 28> zwp_text_input_v3_content_hint::lowercase{0x8};
const bitfield<10, 28> zwp_text_input_v3_content_hint::uppercase{0x10};
const bitfield<10, 28> zwp_text_input_v3_content_hint::titlecase{0x20};
const bitfield<10, 28> zwp_text_input_v3_content_hint::hidden_text{0x40};
const bitfield<10, 28> zwp_text_input_v3_content_hint::sensitive_data{0x80};
const bitfield<10, 28> zwp_text_input_v3_content_hint::latin{0x100};
const bitfield<10, 28> zwp_text_input_v3_content_hint::multiline{0x200};



zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_text_input_manager_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v3_t(p); });
}

zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t()
{
  set_interface(&zwp_text_input_manager_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v3_t(p); });
}

zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t(zwp_text_input_manager_v3 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_text_input_manager_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v3_t(p); });
}

zwp_text_input_manager_v3_t::zwp_text_input_manager_v3_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_text_input_manager_v3_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_text_input_manager_v3_t(p); });
}

zwp_text_input_manager_v3_t zwp_text_input_manager_v3_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_text_input_manager_v3_t::interface_name = "zwp_text_input_manager_v3";

zwp_text_input_manager_v3_t::operator zwp_text_input_manager_v3*() const
{
  return reinterpret_cast<zwp_text_input_manager_v3*> (c_ptr());
}

zwp_text_input_v3_t zwp_text_input_manager_v3_t::get_text_input(seat_t const& seat)
{
  proxy_t p = marshal_constructor(1U, &zwp_text_input_v3_interface, nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_text_input_v3_t(p);
}


int zwp_text_input_manager_v3_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

xdg_activation_v1_t::xdg_activation_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_activation_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_v1_t(p); });
}

xdg_activation_v1_t::xdg_activation_v1_t()
{
  set_interface(&xdg_activation_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_v1_t(p); });
}

xdg_activation_v1_t::xdg_activation_v1_t(xdg_activation_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&xdg_activation_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_v1_t(p); });
}

xdg_activation_v1_t::xdg_activation_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_activation_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_v1_t(p); });
}

xdg_activation_v1_t xdg_activation_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_activation_v1_t::interface_name = "xdg_activation_v1";

xdg_activation_v1_t::operator xdg_activation_v1*() const
{
  return reinterpret_cast<xdg_activation_v1*> (c_ptr());
}

xdg_activation_token_v1_t xdg_activation_v1_t::get_activation_token()
{
  proxy_t p = marshal_constructor(1U, &xdg_activation_token_v1_interface, nullptr);
  return xdg_activation_token_v1_t(p);
}


void xdg_activation_v1_t::activate(std::string const& token, surface_t const& surface)
{
  marshal(2U, token, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}


int xdg_activation_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(4U);
    }
  set_interface(&xdg_activation_token_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_token_v1_t(p); });
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t()
{
  set_interface(&xdg_activation_token_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_token_v1_t(p); });
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t(xdg_activation_token_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(4U);
    }
  set_interface(&xdg_activation_token_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_token_v1_t(p); });
}

xdg_activation_token_v1_t::xdg_activation_token_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&xdg_activation_token_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return xdg_activation_token_v1_t(p); });
}

xdg_activation_token_v1_t xdg_activation_token_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string xdg_activation_token_v1_t::interface_name = "xdg_activation_token_v1";

xdg_activation_token_v1_t::operator xdg_activation_token_v1*() const
{
  return reinterpret_cast<xdg_activation_token_v1*> (c_ptr());
}

void xdg_activation_token_v1_t::set_serial(uint32_t serial, seat_t const& seat)
{
  marshal(0U, serial, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
}


void xdg_activation_token_v1_t::set_app_id(std::string const& app_id)
{
  marshal(1U, app_id);
}


void xdg_activation_token_v1_t::set_surface(surface_t const& surface)
{
  marshal(2U, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}


void xdg_activation_token_v1_t::commit()
{
  marshal(3U);
}


std::function<void(std::string)> &xdg_activation_token_v1_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

int xdg_activation_token_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->done) events->done(args[0].get<std::string>());
      break;
    }
  return 0;
}


zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_decoration_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_decoration_manager_v1_t(p); });
}

zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t()
{
  set_interface(&zxdg_decoration_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_decoration_manager_v1_t(p); });
}

zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t(zxdg_decoration_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_decoration_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_decoration_manager_v1_t(p); });
}

zxdg_decoration_manager_v1_t::zxdg_decoration_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_decoration_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_decoration_manager_v1_t(p); });
}

zxdg_decoration_manager_v1_t zxdg_decoration_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_decoration_manager_v1_t::interface_name = "zxdg_decoration_manager_v1";

zxdg_decoration_manager_v1_t::operator zxdg_decoration_manager_v1*() const
{
  return reinterpret_cast<zxdg_decoration_manager_v1*> (c_ptr());
}

zxdg_toplevel_decoration_v1_t zxdg_decoration_manager_v1_t::get_toplevel_decoration(xdg_toplevel_t const& toplevel)
{
  proxy_t p = marshal_constructor(1U, &zxdg_toplevel_decoration_v1_interface, nullptr, toplevel.proxy_has_object() ? reinterpret_cast<wl_object*>(toplevel.c_ptr()) : nullptr);
  return zxdg_toplevel_decoration_v1_t(p);
}


int zxdg_decoration_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_toplevel_decoration_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_decoration_v1_t(p); });
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t()
{
  set_interface(&zxdg_toplevel_decoration_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_decoration_v1_t(p); });
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t(zxdg_toplevel_decoration_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_toplevel_decoration_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_decoration_v1_t(p); });
}

zxdg_toplevel_decoration_v1_t::zxdg_toplevel_decoration_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_toplevel_decoration_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_decoration_v1_t(p); });
}

zxdg_toplevel_decoration_v1_t zxdg_toplevel_decoration_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_toplevel_decoration_v1_t::interface_name = "zxdg_toplevel_decoration_v1";

zxdg_toplevel_decoration_v1_t::operator zxdg_toplevel_decoration_v1*() const
{
  return reinterpret_cast<zxdg_toplevel_decoration_v1*> (c_ptr());
}

void zxdg_toplevel_decoration_v1_t::set_mode(zxdg_toplevel_decoration_v1_mode const& mode)
{
  marshal(1U, static_cast<uint32_t>(mode));
}


void zxdg_toplevel_decoration_v1_t::unset_mode()
{
  marshal(2U);
}


std::function<void(zxdg_toplevel_decoration_v1_mode)> &zxdg_toplevel_decoration_v1_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

int zxdg_toplevel_decoration_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(zxdg_toplevel_decoration_v1_mode(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}



zxdg_exporter_v1_t::zxdg_exporter_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exporter_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v1_t(p); });
}

zxdg_exporter_v1_t::zxdg_exporter_v1_t()
{
  set_interface(&zxdg_exporter_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v1_t(p); });
}

zxdg_exporter_v1_t::zxdg_exporter_v1_t(zxdg_exporter_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exporter_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v1_t(p); });
}

zxdg_exporter_v1_t::zxdg_exporter_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_exporter_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v1_t(p); });
}

zxdg_exporter_v1_t zxdg_exporter_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_exporter_v1_t::interface_name = "zxdg_exporter_v1";

zxdg_exporter_v1_t::operator zxdg_exporter_v1*() const
{
  return reinterpret_cast<zxdg_exporter_v1*> (c_ptr());
}

zxdg_exported_v1_t zxdg_exporter_v1_t::_export(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &zxdg_exported_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zxdg_exported_v1_t(p);
}


int zxdg_exporter_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zxdg_importer_v1_t::zxdg_importer_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_importer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v1_t(p); });
}

zxdg_importer_v1_t::zxdg_importer_v1_t()
{
  set_interface(&zxdg_importer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v1_t(p); });
}

zxdg_importer_v1_t::zxdg_importer_v1_t(zxdg_importer_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_importer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v1_t(p); });
}

zxdg_importer_v1_t::zxdg_importer_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_importer_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v1_t(p); });
}

zxdg_importer_v1_t zxdg_importer_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_importer_v1_t::interface_name = "zxdg_importer_v1";

zxdg_importer_v1_t::operator zxdg_importer_v1*() const
{
  return reinterpret_cast<zxdg_importer_v1*> (c_ptr());
}

zxdg_imported_v1_t zxdg_importer_v1_t::import(std::string const& handle)
{
  proxy_t p = marshal_constructor(1U, &zxdg_imported_v1_interface, nullptr, handle);
  return zxdg_imported_v1_t(p);
}


int zxdg_importer_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zxdg_exported_v1_t::zxdg_exported_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v1_t(p); });
}

zxdg_exported_v1_t::zxdg_exported_v1_t()
{
  set_interface(&zxdg_exported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v1_t(p); });
}

zxdg_exported_v1_t::zxdg_exported_v1_t(zxdg_exported_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v1_t(p); });
}

zxdg_exported_v1_t::zxdg_exported_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_exported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v1_t(p); });
}

zxdg_exported_v1_t zxdg_exported_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_exported_v1_t::interface_name = "zxdg_exported_v1";

zxdg_exported_v1_t::operator zxdg_exported_v1*() const
{
  return reinterpret_cast<zxdg_exported_v1*> (c_ptr());
}

std::function<void(std::string)> &zxdg_exported_v1_t::on_handle()
{
  return std::static_pointer_cast<events_t>(get_events())->handle;
}

int zxdg_exported_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->handle) events->handle(args[0].get<std::string>());
      break;
    }
  return 0;
}

zxdg_imported_v1_t::zxdg_imported_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_imported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v1_t(p); });
}

zxdg_imported_v1_t::zxdg_imported_v1_t()
{
  set_interface(&zxdg_imported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v1_t(p); });
}

zxdg_imported_v1_t::zxdg_imported_v1_t(zxdg_imported_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_imported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v1_t(p); });
}

zxdg_imported_v1_t::zxdg_imported_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_imported_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v1_t(p); });
}

zxdg_imported_v1_t zxdg_imported_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_imported_v1_t::interface_name = "zxdg_imported_v1";

zxdg_imported_v1_t::operator zxdg_imported_v1*() const
{
  return reinterpret_cast<zxdg_imported_v1*> (c_ptr());
}

void zxdg_imported_v1_t::set_parent_of(surface_t const& surface)
{
  marshal(1U, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}


std::function<void()> &zxdg_imported_v1_t::on_destroyed()
{
  return std::static_pointer_cast<events_t>(get_events())->destroyed;
}

int zxdg_imported_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroyed) events->destroyed();
      break;
    }
  return 0;
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exporter_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v2_t(p); });
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t()
{
  set_interface(&zxdg_exporter_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v2_t(p); });
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t(zxdg_exporter_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exporter_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v2_t(p); });
}

zxdg_exporter_v2_t::zxdg_exporter_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_exporter_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exporter_v2_t(p); });
}

zxdg_exporter_v2_t zxdg_exporter_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_exporter_v2_t::interface_name = "zxdg_exporter_v2";

zxdg_exporter_v2_t::operator zxdg_exporter_v2*() const
{
  return reinterpret_cast<zxdg_exporter_v2*> (c_ptr());
}

zxdg_exported_v2_t zxdg_exporter_v2_t::export_toplevel(surface_t const& surface)
{
  proxy_t p = marshal_constructor(1U, &zxdg_exported_v2_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zxdg_exported_v2_t(p);
}


int zxdg_exporter_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


zxdg_importer_v2_t::zxdg_importer_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_importer_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v2_t(p); });
}

zxdg_importer_v2_t::zxdg_importer_v2_t()
{
  set_interface(&zxdg_importer_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v2_t(p); });
}

zxdg_importer_v2_t::zxdg_importer_v2_t(zxdg_importer_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_importer_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v2_t(p); });
}

zxdg_importer_v2_t::zxdg_importer_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_importer_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_importer_v2_t(p); });
}

zxdg_importer_v2_t zxdg_importer_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_importer_v2_t::interface_name = "zxdg_importer_v2";

zxdg_importer_v2_t::operator zxdg_importer_v2*() const
{
  return reinterpret_cast<zxdg_importer_v2*> (c_ptr());
}

zxdg_imported_v2_t zxdg_importer_v2_t::import_toplevel(std::string const& handle)
{
  proxy_t p = marshal_constructor(1U, &zxdg_imported_v2_interface, nullptr, handle);
  return zxdg_imported_v2_t(p);
}


int zxdg_importer_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zxdg_exported_v2_t::zxdg_exported_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v2_t(p); });
}

zxdg_exported_v2_t::zxdg_exported_v2_t()
{
  set_interface(&zxdg_exported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v2_t(p); });
}

zxdg_exported_v2_t::zxdg_exported_v2_t(zxdg_exported_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_exported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v2_t(p); });
}

zxdg_exported_v2_t::zxdg_exported_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_exported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_exported_v2_t(p); });
}

zxdg_exported_v2_t zxdg_exported_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_exported_v2_t::interface_name = "zxdg_exported_v2";

zxdg_exported_v2_t::operator zxdg_exported_v2*() const
{
  return reinterpret_cast<zxdg_exported_v2*> (c_ptr());
}

std::function<void(std::string)> &zxdg_exported_v2_t::on_handle()
{
  return std::static_pointer_cast<events_t>(get_events())->handle;
}

int zxdg_exported_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->handle) events->handle(args[0].get<std::string>());
      break;
    }
  return 0;
}

zxdg_imported_v2_t::zxdg_imported_v2_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_imported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v2_t(p); });
}

zxdg_imported_v2_t::zxdg_imported_v2_t()
{
  set_interface(&zxdg_imported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v2_t(p); });
}

zxdg_imported_v2_t::zxdg_imported_v2_t(zxdg_imported_v2 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_imported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v2_t(p); });
}

zxdg_imported_v2_t::zxdg_imported_v2_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_imported_v2_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_imported_v2_t(p); });
}

zxdg_imported_v2_t zxdg_imported_v2_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_imported_v2_t::interface_name = "zxdg_imported_v2";

zxdg_imported_v2_t::operator zxdg_imported_v2*() const
{
  return reinterpret_cast<zxdg_imported_v2*> (c_ptr());
}

void zxdg_imported_v2_t::set_parent_of(surface_t const& surface)
{
  marshal(1U, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}


std::function<void()> &zxdg_imported_v2_t::on_destroyed()
{
  return std::static_pointer_cast<events_t>(get_events())->destroyed;
}

int zxdg_imported_v2_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroyed) events->destroyed();
      break;
    }
  return 0;
}


zxdg_output_manager_v1_t::zxdg_output_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_output_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_manager_v1_t(p); });
}

zxdg_output_manager_v1_t::zxdg_output_manager_v1_t()
{
  set_interface(&zxdg_output_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_manager_v1_t(p); });
}

zxdg_output_manager_v1_t::zxdg_output_manager_v1_t(zxdg_output_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_output_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_manager_v1_t(p); });
}

zxdg_output_manager_v1_t::zxdg_output_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_output_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_manager_v1_t(p); });
}

zxdg_output_manager_v1_t zxdg_output_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_output_manager_v1_t::interface_name = "zxdg_output_manager_v1";

zxdg_output_manager_v1_t::operator zxdg_output_manager_v1*() const
{
  return reinterpret_cast<zxdg_output_manager_v1*> (c_ptr());
}

zxdg_output_v1_t zxdg_output_manager_v1_t::get_xdg_output(output_t const& output)
{
  proxy_t p = marshal_constructor(1U, &zxdg_output_v1_interface, nullptr, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
  return zxdg_output_v1_t(p);
}


int zxdg_output_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zxdg_output_v1_t::zxdg_output_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_output_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_v1_t(p); });
}

zxdg_output_v1_t::zxdg_output_v1_t()
{
  set_interface(&zxdg_output_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_v1_t(p); });
}

zxdg_output_v1_t::zxdg_output_v1_t(zxdg_output_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_output_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_v1_t(p); });
}

zxdg_output_v1_t::zxdg_output_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_output_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_output_v1_t(p); });
}

zxdg_output_v1_t zxdg_output_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_output_v1_t::interface_name = "zxdg_output_v1";

zxdg_output_v1_t::operator zxdg_output_v1*() const
{
  return reinterpret_cast<zxdg_output_v1*> (c_ptr());
}

std::function<void(int32_t, int32_t)> &zxdg_output_v1_t::on_logical_position()
{
  return std::static_pointer_cast<events_t>(get_events())->logical_position;
}

std::function<void(int32_t, int32_t)> &zxdg_output_v1_t::on_logical_size()
{
  return std::static_pointer_cast<events_t>(get_events())->logical_size;
}

std::function<void()> &zxdg_output_v1_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void(std::string)> &zxdg_output_v1_t::on_name()
{
  return std::static_pointer_cast<events_t>(get_events())->name;
}

std::function<void(std::string)> &zxdg_output_v1_t::on_description()
{
  return std::static_pointer_cast<events_t>(get_events())->description;
}

int zxdg_output_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->logical_position) events->logical_position(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 1:
      if(events->logical_size) events->logical_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 2:
      if(events->done) events->done();
      break;
    case 3:
      if(events->name) events->name(args[0].get<std::string>());
      break;
    case 4:
      if(events->description) events->description(args[0].get<std::string>());
      break;
    }
  return 0;
}

zxdg_shell_v6_t::zxdg_shell_v6_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_shell_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_shell_v6_t(p); });
}

zxdg_shell_v6_t::zxdg_shell_v6_t()
{
  set_interface(&zxdg_shell_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_shell_v6_t(p); });
}

zxdg_shell_v6_t::zxdg_shell_v6_t(zxdg_shell_v6 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_shell_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_shell_v6_t(p); });
}

zxdg_shell_v6_t::zxdg_shell_v6_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_shell_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_shell_v6_t(p); });
}

zxdg_shell_v6_t zxdg_shell_v6_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_shell_v6_t::interface_name = "zxdg_shell_v6";

zxdg_shell_v6_t::operator zxdg_shell_v6*() const
{
  return reinterpret_cast<zxdg_shell_v6*> (c_ptr());
}

zxdg_positioner_v6_t zxdg_shell_v6_t::create_positioner()
{
  proxy_t p = marshal_constructor(1U, &zxdg_positioner_v6_interface, nullptr);
  return zxdg_positioner_v6_t(p);
}


zxdg_surface_v6_t zxdg_shell_v6_t::get_xdg_surface(surface_t const& surface)
{
  proxy_t p = marshal_constructor(2U, &zxdg_surface_v6_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return zxdg_surface_v6_t(p);
}


void zxdg_shell_v6_t::pong(uint32_t serial)
{
  marshal(3U, serial);
}


std::function<void(uint32_t)> &zxdg_shell_v6_t::on_ping()
{
  return std::static_pointer_cast<events_t>(get_events())->ping;
}

int zxdg_shell_v6_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->ping) events->ping(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zxdg_positioner_v6_t::zxdg_positioner_v6_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_positioner_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_positioner_v6_t(p); });
}

zxdg_positioner_v6_t::zxdg_positioner_v6_t()
{
  set_interface(&zxdg_positioner_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_positioner_v6_t(p); });
}

zxdg_positioner_v6_t::zxdg_positioner_v6_t(zxdg_positioner_v6 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_positioner_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_positioner_v6_t(p); });
}

zxdg_positioner_v6_t::zxdg_positioner_v6_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_positioner_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_positioner_v6_t(p); });
}

zxdg_positioner_v6_t zxdg_positioner_v6_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_positioner_v6_t::interface_name = "zxdg_positioner_v6";

zxdg_positioner_v6_t::operator zxdg_positioner_v6*() const
{
  return reinterpret_cast<zxdg_positioner_v6*> (c_ptr());
}

void zxdg_positioner_v6_t::set_size(int32_t width, int32_t height)
{
  marshal(1U, width, height);
}


void zxdg_positioner_v6_t::set_anchor_rect(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(2U, x, y, width, height);
}


void zxdg_positioner_v6_t::set_anchor(zxdg_positioner_v6_anchor const& anchor)
{
  marshal(3U, static_cast<uint32_t>(anchor));
}


void zxdg_positioner_v6_t::set_gravity(zxdg_positioner_v6_gravity const& gravity)
{
  marshal(4U, static_cast<uint32_t>(gravity));
}


void zxdg_positioner_v6_t::set_constraint_adjustment(zxdg_positioner_v6_constraint_adjustment const& constraint_adjustment)
{
  marshal(5U, static_cast<uint32_t>(constraint_adjustment));
}


void zxdg_positioner_v6_t::set_offset(int32_t x, int32_t y)
{
  marshal(6U, x, y);
}


int zxdg_positioner_v6_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

const bitfield<4, 37> zxdg_positioner_v6_anchor::none{0};
const bitfield<4, 37> zxdg_positioner_v6_anchor::top{1};
const bitfield<4, 37> zxdg_positioner_v6_anchor::bottom{2};
const bitfield<4, 37> zxdg_positioner_v6_anchor::left{4};
const bitfield<4, 37> zxdg_positioner_v6_anchor::right{8};

const bitfield<4, 38> zxdg_positioner_v6_gravity::none{0};
const bitfield<4, 38> zxdg_positioner_v6_gravity::top{1};
const bitfield<4, 38> zxdg_positioner_v6_gravity::bottom{2};
const bitfield<4, 38> zxdg_positioner_v6_gravity::left{4};
const bitfield<4, 38> zxdg_positioner_v6_gravity::right{8};

const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::none{0};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::slide_x{1};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::slide_y{2};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::flip_x{4};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::flip_y{8};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::resize_x{16};
const bitfield<6, 39> zxdg_positioner_v6_constraint_adjustment::resize_y{32};


zxdg_surface_v6_t::zxdg_surface_v6_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_surface_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_surface_v6_t(p); });
}

zxdg_surface_v6_t::zxdg_surface_v6_t()
{
  set_interface(&zxdg_surface_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_surface_v6_t(p); });
}

zxdg_surface_v6_t::zxdg_surface_v6_t(zxdg_surface_v6 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_surface_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_surface_v6_t(p); });
}

zxdg_surface_v6_t::zxdg_surface_v6_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_surface_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_surface_v6_t(p); });
}

zxdg_surface_v6_t zxdg_surface_v6_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_surface_v6_t::interface_name = "zxdg_surface_v6";

zxdg_surface_v6_t::operator zxdg_surface_v6*() const
{
  return reinterpret_cast<zxdg_surface_v6*> (c_ptr());
}

zxdg_toplevel_v6_t zxdg_surface_v6_t::get_toplevel()
{
  proxy_t p = marshal_constructor(1U, &zxdg_toplevel_v6_interface, nullptr);
  return zxdg_toplevel_v6_t(p);
}


zxdg_popup_v6_t zxdg_surface_v6_t::get_popup(zxdg_surface_v6_t const& parent, zxdg_positioner_v6_t const& positioner)
{
  proxy_t p = marshal_constructor(2U, &zxdg_popup_v6_interface, nullptr, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr, positioner.proxy_has_object() ? reinterpret_cast<wl_object*>(positioner.c_ptr()) : nullptr);
  return zxdg_popup_v6_t(p);
}


void zxdg_surface_v6_t::set_window_geometry(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(3U, x, y, width, height);
}


void zxdg_surface_v6_t::ack_configure(uint32_t serial)
{
  marshal(4U, serial);
}


std::function<void(uint32_t)> &zxdg_surface_v6_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

int zxdg_surface_v6_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


zxdg_toplevel_v6_t::zxdg_toplevel_v6_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_toplevel_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_v6_t(p); });
}

zxdg_toplevel_v6_t::zxdg_toplevel_v6_t()
{
  set_interface(&zxdg_toplevel_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_v6_t(p); });
}

zxdg_toplevel_v6_t::zxdg_toplevel_v6_t(zxdg_toplevel_v6 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_toplevel_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_v6_t(p); });
}

zxdg_toplevel_v6_t::zxdg_toplevel_v6_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_toplevel_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_toplevel_v6_t(p); });
}

zxdg_toplevel_v6_t zxdg_toplevel_v6_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_toplevel_v6_t::interface_name = "zxdg_toplevel_v6";

zxdg_toplevel_v6_t::operator zxdg_toplevel_v6*() const
{
  return reinterpret_cast<zxdg_toplevel_v6*> (c_ptr());
}

void zxdg_toplevel_v6_t::set_parent(zxdg_toplevel_v6_t const& parent)
{
  marshal(1U, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr);
}


void zxdg_toplevel_v6_t::set_title(std::string const& title)
{
  marshal(2U, title);
}


void zxdg_toplevel_v6_t::set_app_id(std::string const& app_id)
{
  marshal(3U, app_id);
}


void zxdg_toplevel_v6_t::show_window_menu(seat_t const& seat, uint32_t serial, int32_t x, int32_t y)
{
  marshal(4U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, x, y);
}


void zxdg_toplevel_v6_t::move(seat_t const& seat, uint32_t serial)
{
  marshal(5U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial);
}


void zxdg_toplevel_v6_t::resize(seat_t const& seat, uint32_t serial, zxdg_toplevel_v6_resize_edge const& edges)
{
  marshal(6U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, static_cast<uint32_t>(edges));
}


void zxdg_toplevel_v6_t::set_max_size(int32_t width, int32_t height)
{
  marshal(7U, width, height);
}


void zxdg_toplevel_v6_t::set_min_size(int32_t width, int32_t height)
{
  marshal(8U, width, height);
}


void zxdg_toplevel_v6_t::set_maximized()
{
  marshal(9U);
}


void zxdg_toplevel_v6_t::unset_maximized()
{
  marshal(10U);
}


void zxdg_toplevel_v6_t::set_fullscreen(output_t const& output)
{
  marshal(11U, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}


void zxdg_toplevel_v6_t::unset_fullscreen()
{
  marshal(12U);
}


void zxdg_toplevel_v6_t::set_minimized()
{
  marshal(13U);
}


std::function<void(int32_t, int32_t, array_t)> &zxdg_toplevel_v6_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

std::function<void()> &zxdg_toplevel_v6_t::on_close()
{
  return std::static_pointer_cast<events_t>(get_events())->close;
}

int zxdg_toplevel_v6_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<array_t>());
      break;
    case 1:
      if(events->close) events->close();
      break;
    }
  return 0;
}
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::none{0};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top{1};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom{2};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::left{4};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top_left{5};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom_left{6};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::right{8};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::top_right{9};
const bitfield<4, 41> zxdg_toplevel_v6_resize_edge::bottom_right{10};



zxdg_popup_v6_t::zxdg_popup_v6_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_popup_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_popup_v6_t(p); });
}

zxdg_popup_v6_t::zxdg_popup_v6_t()
{
  set_interface(&zxdg_popup_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_popup_v6_t(p); });
}

zxdg_popup_v6_t::zxdg_popup_v6_t(zxdg_popup_v6 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zxdg_popup_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_popup_v6_t(p); });
}

zxdg_popup_v6_t::zxdg_popup_v6_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zxdg_popup_v6_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zxdg_popup_v6_t(p); });
}

zxdg_popup_v6_t zxdg_popup_v6_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zxdg_popup_v6_t::interface_name = "zxdg_popup_v6";

zxdg_popup_v6_t::operator zxdg_popup_v6*() const
{
  return reinterpret_cast<zxdg_popup_v6*> (c_ptr());
}

void zxdg_popup_v6_t::grab(seat_t const& seat, uint32_t serial)
{
  marshal(1U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial);
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &zxdg_popup_v6_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

std::function<void()> &zxdg_popup_v6_t::on_popup_done()
{
  return std::static_pointer_cast<events_t>(get_events())->popup_done;
}

int zxdg_popup_v6_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->configure) events->configure(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 1:
      if(events->popup_done) events->popup_done();
      break;
    }
  return 0;
}


zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_xwayland_keyboard_grab_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_manager_v1_t(p); });
}

zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t()
{
  set_interface(&zwp_xwayland_keyboard_grab_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_manager_v1_t(p); });
}

zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t(zwp_xwayland_keyboard_grab_manager_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_xwayland_keyboard_grab_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_manager_v1_t(p); });
}

zwp_xwayland_keyboard_grab_manager_v1_t::zwp_xwayland_keyboard_grab_manager_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_xwayland_keyboard_grab_manager_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_manager_v1_t(p); });
}

zwp_xwayland_keyboard_grab_manager_v1_t zwp_xwayland_keyboard_grab_manager_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_xwayland_keyboard_grab_manager_v1_t::interface_name = "zwp_xwayland_keyboard_grab_manager_v1";

zwp_xwayland_keyboard_grab_manager_v1_t::operator zwp_xwayland_keyboard_grab_manager_v1*() const
{
  return reinterpret_cast<zwp_xwayland_keyboard_grab_manager_v1*> (c_ptr());
}

zwp_xwayland_keyboard_grab_v1_t zwp_xwayland_keyboard_grab_manager_v1_t::grab_keyboard(surface_t const& surface, seat_t const& seat)
{
  proxy_t p = marshal_constructor(1U, &zwp_xwayland_keyboard_grab_v1_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return zwp_xwayland_keyboard_grab_v1_t(p);
}


int zwp_xwayland_keyboard_grab_manager_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_xwayland_keyboard_grab_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_v1_t(p); });
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t()
{
  set_interface(&zwp_xwayland_keyboard_grab_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_v1_t(p); });
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t(zwp_xwayland_keyboard_grab_v1 *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&zwp_xwayland_keyboard_grab_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_v1_t(p); });
}

zwp_xwayland_keyboard_grab_v1_t::zwp_xwayland_keyboard_grab_v1_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&zwp_xwayland_keyboard_grab_v1_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return zwp_xwayland_keyboard_grab_v1_t(p); });
}

zwp_xwayland_keyboard_grab_v1_t zwp_xwayland_keyboard_grab_v1_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string zwp_xwayland_keyboard_grab_v1_t::interface_name = "zwp_xwayland_keyboard_grab_v1";

zwp_xwayland_keyboard_grab_v1_t::operator zwp_xwayland_keyboard_grab_v1*() const
{
  return reinterpret_cast<zwp_xwayland_keyboard_grab_v1*> (c_ptr());
}

int zwp_xwayland_keyboard_grab_v1_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


