/* Generated by wayland-scanner 1.23.1 */

#ifndef WLR_VIRTUAL_POINTER_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define WLR_VIRTUAL_POINTER_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wlr_virtual_pointer_unstable_v1 The wlr_virtual_pointer_unstable_v1 protocol
 * @section page_ifaces_wlr_virtual_pointer_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_virtual_pointer_v1 - virtual pointer
 * - @subpage page_iface_zwlr_virtual_pointer_manager_v1 - virtual pointer manager
 * @section page_copyright_wlr_virtual_pointer_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Josef Gajdusek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_seat;
struct zwlr_virtual_pointer_manager_v1;
struct zwlr_virtual_pointer_v1;

#ifndef ZWLR_VIRTUAL_POINTER_V1_INTERFACE
#define ZWLR_VIRTUAL_POINTER_V1_INTERFACE
/**
 * @page page_iface_zwlr_virtual_pointer_v1 zwlr_virtual_pointer_v1
 * @section page_iface_zwlr_virtual_pointer_v1_desc Description
 *
 * This protocol allows clients to emulate a physical pointer device. The
 * requests are mostly mirror opposites of those specified in wl_pointer.
 * @section page_iface_zwlr_virtual_pointer_v1_api API
 * See @ref iface_zwlr_virtual_pointer_v1.
 */
/**
 * @defgroup iface_zwlr_virtual_pointer_v1 The zwlr_virtual_pointer_v1 interface
 *
 * This protocol allows clients to emulate a physical pointer device. The
 * requests are mostly mirror opposites of those specified in wl_pointer.
 */
extern const struct wl_interface zwlr_virtual_pointer_v1_interface;
#endif
#ifndef ZWLR_VIRTUAL_POINTER_MANAGER_V1_INTERFACE
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_virtual_pointer_manager_v1 zwlr_virtual_pointer_manager_v1
 * @section page_iface_zwlr_virtual_pointer_manager_v1_desc Description
 *
 * This object allows clients to create individual virtual pointer objects.
 * @section page_iface_zwlr_virtual_pointer_manager_v1_api API
 * See @ref iface_zwlr_virtual_pointer_manager_v1.
 */
/**
 * @defgroup iface_zwlr_virtual_pointer_manager_v1 The zwlr_virtual_pointer_manager_v1 interface
 *
 * This object allows clients to create individual virtual pointer objects.
 */
extern const struct wl_interface zwlr_virtual_pointer_manager_v1_interface;
#endif

#ifndef ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM
#define ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM
enum zwlr_virtual_pointer_v1_error {
	/**
	 * client sent invalid axis enumeration value
	 */
	ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS = 0,
	/**
	 * client sent invalid axis source enumeration value
	 */
	ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS_SOURCE = 1,
};
#endif /* ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM */

#define ZWLR_VIRTUAL_POINTER_V1_MOTION 0
#define ZWLR_VIRTUAL_POINTER_V1_MOTION_ABSOLUTE 1
#define ZWLR_VIRTUAL_POINTER_V1_BUTTON 2
#define ZWLR_VIRTUAL_POINTER_V1_AXIS 3
#define ZWLR_VIRTUAL_POINTER_V1_FRAME 4
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_SOURCE 5
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_STOP 6
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_DISCRETE 7
#define ZWLR_VIRTUAL_POINTER_V1_DESTROY 8


/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_MOTION_ABSOLUTE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_DISCRETE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_virtual_pointer_v1 */
static inline void
zwlr_virtual_pointer_v1_set_user_data(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_virtual_pointer_v1, user_data);
}

/** @ingroup iface_zwlr_virtual_pointer_v1 */
static inline void *
zwlr_virtual_pointer_v1_get_user_data(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_virtual_pointer_v1);
}

static inline uint32_t
zwlr_virtual_pointer_v1_get_version(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * The pointer has moved by a relative amount to the previous request.
 *
 * Values are in the global compositor space.
 */
static inline void
zwlr_virtual_pointer_v1_motion(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, wl_fixed_t dx, wl_fixed_t dy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_MOTION, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, dx, dy);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * The pointer has moved in an absolute coordinate frame.
 *
 * Value of x can range from 0 to x_extent, value of y can range from 0
 * to y_extent.
 */
static inline void
zwlr_virtual_pointer_v1_motion_absolute(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, uint32_t x, uint32_t y, uint32_t x_extent, uint32_t y_extent)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_MOTION_ABSOLUTE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, x, y, x_extent, y_extent);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * A button was pressed or released.
 */
static inline void
zwlr_virtual_pointer_v1_button(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, uint32_t button, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_BUTTON, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, button, state);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * Scroll and other axis requests.
 */
static inline void
zwlr_virtual_pointer_v1_axis(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, uint32_t axis, wl_fixed_t value)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_AXIS, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, axis, value);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * Indicates the set of events that logically belong together.
 */
static inline void
zwlr_virtual_pointer_v1_frame(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_FRAME, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * Source information for scroll and other axis.
 */
static inline void
zwlr_virtual_pointer_v1_axis_source(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t axis_source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_AXIS_SOURCE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, axis_source);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * Stop notification for scroll and other axes.
 */
static inline void
zwlr_virtual_pointer_v1_axis_stop(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, uint32_t axis)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_AXIS_STOP, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, axis);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 *
 * Discrete step information for scroll and other axes.
 *
 * This event allows the client to extend data normally sent using the axis
 * event with discrete value.
 */
static inline void
zwlr_virtual_pointer_v1_axis_discrete(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1, uint32_t time, uint32_t axis, wl_fixed_t value, int32_t discrete)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_AXIS_DISCRETE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), 0, time, axis, value, discrete);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
static inline void
zwlr_virtual_pointer_v1_destroy(struct zwlr_virtual_pointer_v1 *zwlr_virtual_pointer_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_v1,
			 ZWLR_VIRTUAL_POINTER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER 0
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_DESTROY 1
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_WITH_OUTPUT 2


/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_WITH_OUTPUT_SINCE_VERSION 2

/** @ingroup iface_zwlr_virtual_pointer_manager_v1 */
static inline void
zwlr_virtual_pointer_manager_v1_set_user_data(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_virtual_pointer_manager_v1, user_data);
}

/** @ingroup iface_zwlr_virtual_pointer_manager_v1 */
static inline void *
zwlr_virtual_pointer_manager_v1_get_user_data(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_virtual_pointer_manager_v1);
}

static inline uint32_t
zwlr_virtual_pointer_manager_v1_get_version(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_manager_v1);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 *
 * Creates a new virtual pointer. The optional seat is a suggestion to the
 * compositor.
 */
static inline struct zwlr_virtual_pointer_v1 *
zwlr_virtual_pointer_manager_v1_create_virtual_pointer(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_manager_v1,
			 ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER, &zwlr_virtual_pointer_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_manager_v1), 0, seat, NULL);

	return (struct zwlr_virtual_pointer_v1 *) id;
}

/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
static inline void
zwlr_virtual_pointer_manager_v1_destroy(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_manager_v1,
			 ZWLR_VIRTUAL_POINTER_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 *
 * Creates a new virtual pointer. The seat and the output arguments are
 * optional. If the seat argument is set, the compositor should assign the
 * input device to the requested seat. If the output argument is set, the
 * compositor should map the input device to the requested output.
 */
static inline struct zwlr_virtual_pointer_v1 *
zwlr_virtual_pointer_manager_v1_create_virtual_pointer_with_output(struct zwlr_virtual_pointer_manager_v1 *zwlr_virtual_pointer_manager_v1, struct wl_seat *seat, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_virtual_pointer_manager_v1,
			 ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_WITH_OUTPUT, &zwlr_virtual_pointer_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_virtual_pointer_manager_v1), 0, seat, output, NULL);

	return (struct zwlr_virtual_pointer_v1 *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
