/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBasicCredential.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBasicCredentialConstructorFunction_isConditionalMediationAvailable);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBasicCredentialConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBasicCredential_id);
static JSC_DECLARE_CUSTOM_GETTER(jsBasicCredential_type);

class JSBasicCredentialPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBasicCredentialPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBasicCredentialPrototype* ptr = new (NotNull, JSC::allocateCell<JSBasicCredentialPrototype>(vm)) JSBasicCredentialPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBasicCredentialPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBasicCredentialPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBasicCredentialPrototype, JSBasicCredentialPrototype::Base);

using JSBasicCredentialDOMConstructor = JSDOMConstructorNotConstructable<JSBasicCredential>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSBasicCredentialConstructorTableValues {
    HashTableValue { "isConditionalMediationAvailable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBasicCredentialConstructorFunction_isConditionalMediationAvailable, 0 } },
};

template<> const ClassInfo JSBasicCredentialDOMConstructor::s_info = { "Credential"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBasicCredentialDOMConstructor) };

template<> JSValue JSBasicCredentialDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBasicCredentialDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Credential"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBasicCredential::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSBasicCredential::info(), JSBasicCredentialConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSBasicCredentialPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBasicCredentialConstructor, 0 } },
    HashTableValue { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBasicCredential_id, 0 } },
    HashTableValue { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBasicCredential_type, 0 } },
};

const ClassInfo JSBasicCredentialPrototype::s_info = { "Credential"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBasicCredentialPrototype) };

void JSBasicCredentialPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBasicCredential::info(), JSBasicCredentialPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBasicCredential::s_info = { "Credential"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBasicCredential) };

JSBasicCredential::JSBasicCredential(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BasicCredential>&& impl)
    : JSDOMWrapper<BasicCredential>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, BasicCredential>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBasicCredential::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBasicCredentialPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSBasicCredentialPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBasicCredential::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBasicCredential>(vm, globalObject);
}

JSValue JSBasicCredential::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBasicCredentialDOMConstructor, DOMConstructorID::BasicCredential>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSBasicCredential::destroy(JSC::JSCell* cell)
{
    JSBasicCredential* thisObject = static_cast<JSBasicCredential*>(cell);
    thisObject->JSBasicCredential::~JSBasicCredential();
}

JSC_DEFINE_CUSTOM_GETTER(jsBasicCredentialConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBasicCredentialPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBasicCredential::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsBasicCredential_idGetter(JSGlobalObject& lexicalGlobalObject, JSBasicCredential& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBasicCredential_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBasicCredential>::get<jsBasicCredential_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBasicCredential_typeGetter(JSGlobalObject& lexicalGlobalObject, JSBasicCredential& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBasicCredential_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBasicCredential>::get<jsBasicCredential_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsBasicCredentialConstructorFunction_isConditionalMediationAvailableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, [&]() -> decltype(auto) { return BasicCredential::isConditionalMediationAvailable(document.get(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBasicCredentialConstructorFunction_isConditionalMediationAvailable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBasicCredential>::callStatic<jsBasicCredentialConstructorFunction_isConditionalMediationAvailableBody>(*lexicalGlobalObject, *callFrame, "isConditionalMediationAvailable");
}

JSC::GCClient::IsoSubspace* JSBasicCredential::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBasicCredential, UseCustomHeapCellType::No>(vm, "JSBasicCredential"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBasicCredential.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBasicCredential = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBasicCredential.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBasicCredential = std::forward<decltype(space)>(space); }
    );
}

void JSBasicCredential::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBasicCredential*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSBasicCredentialOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBasicCredentialOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBasicCredential = static_cast<JSBasicCredential*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsBasicCredential->protectedWrapped().ptr(), jsBasicCredential);
}

BasicCredential* JSBasicCredential::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBasicCredential*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
