/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBCursor.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBCursorDirection.h"
#include "JSIDBIndex.h"
#include "JSIDBObjectStore.h"
#include "JSIDBRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_advance);
static JSC_DECLARE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_continue);
static JSC_DECLARE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_continuePrimaryKey);
static JSC_DECLARE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_update);
static JSC_DECLARE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_delete);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursor_source);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursor_direction);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursor_key);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursor_primaryKey);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursor_request);

class JSIDBCursorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBCursorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBCursorPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBCursorPrototype>(vm)) JSIDBCursorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBCursorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBCursorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBCursorPrototype, JSIDBCursorPrototype::Base);

using JSIDBCursorDOMConstructor = JSDOMConstructorNotConstructable<JSIDBCursor>;

template<> const ClassInfo JSIDBCursorDOMConstructor::s_info = { "IDBCursor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursorDOMConstructor) };

template<> JSValue JSIDBCursorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBCursorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBCursor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBCursor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 11> JSIDBCursorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursorConstructor, 0 } },
    HashTableValue { "source"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursor_source, 0 } },
    HashTableValue { "direction"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursor_direction, 0 } },
    HashTableValue { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursor_key, 0 } },
    HashTableValue { "primaryKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursor_primaryKey, 0 } },
    HashTableValue { "request"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursor_request, 0 } },
    HashTableValue { "advance"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBCursorPrototypeFunction_advance, 1 } },
    HashTableValue { "continue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBCursorPrototypeFunction_continue, 0 } },
    HashTableValue { "continuePrimaryKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBCursorPrototypeFunction_continuePrimaryKey, 2 } },
    HashTableValue { "update"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBCursorPrototypeFunction_update, 1 } },
    HashTableValue { "delete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBCursorPrototypeFunction_delete, 0 } },
};

const ClassInfo JSIDBCursorPrototype::s_info = { "IDBCursor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursorPrototype) };

void JSIDBCursorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBCursor::info(), JSIDBCursorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBCursor::s_info = { "IDBCursor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursor) };

JSIDBCursor::JSIDBCursor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBCursor>&& impl)
    : JSDOMWrapper<IDBCursor>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, IDBCursor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIDBCursor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBCursorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIDBCursorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBCursor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBCursor>(vm, globalObject);
}

JSValue JSIDBCursor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBCursorDOMConstructor, DOMConstructorID::IDBCursor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBCursor::destroy(JSC::JSCell* cell)
{
    JSIDBCursor* thisObject = static_cast<JSIDBCursor*>(cell);
    thisObject->JSIDBCursor::~JSIDBCursor();
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBCursorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBCursor::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsIDBCursor_sourceGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLInterface<IDBObjectStore>, IDLInterface<IDBIndex>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.source())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursor_source, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursor>::get<jsIDBCursor_sourceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBCursor_directionGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<IDBCursorDirection>>(lexicalGlobalObject, throwScope, impl.direction())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursor_direction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursor>::get<jsIDBCursor_directionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBCursor_keyGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursor& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.key(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursor_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursor>::get<jsIDBCursor_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBCursor_primaryKeyGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursor& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.primaryKey(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursor_primaryKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursor>::get<jsIDBCursor_primaryKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBCursor_requestGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursor& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<IDBRequest>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.request())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursor_request, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursor>::get<jsIDBCursor_requestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIDBCursorPrototypeFunction_advanceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBCursor>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto countConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.advance(countConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_advance, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBCursor>::call<jsIDBCursorPrototypeFunction_advanceBody>(*lexicalGlobalObject, *callFrame, "advance");
}

static inline JSC::EncodedJSValue jsIDBCursorPrototypeFunction_continueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBCursor>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto keyConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (keyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.continueFunction(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), keyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_continue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBCursor>::call<jsIDBCursorPrototypeFunction_continueBody>(*lexicalGlobalObject, *callFrame, "continue");
}

static inline JSC::EncodedJSValue jsIDBCursorPrototypeFunction_continuePrimaryKeyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBCursor>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (keyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto primaryKeyConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    if (primaryKeyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.continuePrimaryKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), keyConversionResult.releaseReturnValue(), primaryKeyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_continuePrimaryKey, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBCursor>::call<jsIDBCursorPrototypeFunction_continuePrimaryKeyBody>(*lexicalGlobalObject, *callFrame, "continuePrimaryKey");
}

static inline JSC::EncodedJSValue jsIDBCursorPrototypeFunction_updateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBCursor>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (valueConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.update(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_update, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBCursor>::call<jsIDBCursorPrototypeFunction_updateBody>(*lexicalGlobalObject, *callFrame, "update");
}

static inline JSC::EncodedJSValue jsIDBCursorPrototypeFunction_deleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBCursor>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteFunction())));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBCursorPrototypeFunction_delete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBCursor>::call<jsIDBCursorPrototypeFunction_deleteBody>(*lexicalGlobalObject, *callFrame, "delete");
}

JSC::GCClient::IsoSubspace* JSIDBCursor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBCursor, UseCustomHeapCellType::No>(vm, "JSIDBCursor"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBCursor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBCursor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBCursor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBCursor = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIDBCursor::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBCursor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSIDBCursor);

template<typename Visitor>
void JSIDBCursor::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBCursor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSIDBCursor::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSIDBCursor::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSIDBCursor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBCursor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBCursorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBCursorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBCursor = static_cast<JSIDBCursor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBCursor->protectedWrapped().ptr(), jsIDBCursor);
}

IDBCursor* JSIDBCursor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBCursor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
