/* Generated by wayland-scanner 1.24.0 */

#ifndef WESTON_DESKTOP_CLIENT_PROTOCOL_H
#define WESTON_DESKTOP_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_weston_desktop The weston_desktop protocol
 * @section page_ifaces_weston_desktop Interfaces
 * - @subpage page_iface_weston_desktop_shell - create desktop widgets and helpers
 * - @subpage page_iface_weston_screensaver - interface for implementing screensavers
 */
struct weston_desktop_shell;
struct weston_screensaver;
struct wl_output;
struct wl_surface;

#ifndef WESTON_DESKTOP_SHELL_INTERFACE
#define WESTON_DESKTOP_SHELL_INTERFACE
/**
 * @page page_iface_weston_desktop_shell weston_desktop_shell
 * @section page_iface_weston_desktop_shell_desc Description
 *
 * Traditional user interfaces can rely on this interface to define the
 * foundations of typical desktops. Currently it's possible to set up
 * background, panels and locking surfaces.
 * @section page_iface_weston_desktop_shell_api API
 * See @ref iface_weston_desktop_shell.
 */
/**
 * @defgroup iface_weston_desktop_shell The weston_desktop_shell interface
 *
 * Traditional user interfaces can rely on this interface to define the
 * foundations of typical desktops. Currently it's possible to set up
 * background, panels and locking surfaces.
 */
extern const struct wl_interface weston_desktop_shell_interface;
#endif
#ifndef WESTON_SCREENSAVER_INTERFACE
#define WESTON_SCREENSAVER_INTERFACE
/**
 * @page page_iface_weston_screensaver weston_screensaver
 * @section page_iface_weston_screensaver_desc Description
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_weston_screensaver_api API
 * See @ref iface_weston_screensaver.
 */
/**
 * @defgroup iface_weston_screensaver The weston_screensaver interface
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface weston_screensaver_interface;
#endif

#ifndef WESTON_DESKTOP_SHELL_CURSOR_ENUM
#define WESTON_DESKTOP_SHELL_CURSOR_ENUM
enum weston_desktop_shell_cursor {
	WESTON_DESKTOP_SHELL_CURSOR_NONE = 0,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP = 1,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM = 2,
	WESTON_DESKTOP_SHELL_CURSOR_ARROW = 3,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_LEFT = 4,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_LEFT = 5,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_LEFT = 6,
	WESTON_DESKTOP_SHELL_CURSOR_MOVE = 7,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_RIGHT = 8,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_RIGHT = 9,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_RIGHT = 10,
	WESTON_DESKTOP_SHELL_CURSOR_BUSY = 11,
};
#endif /* WESTON_DESKTOP_SHELL_CURSOR_ENUM */

#ifndef WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM
#define WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM
enum weston_desktop_shell_panel_position {
	WESTON_DESKTOP_SHELL_PANEL_POSITION_TOP = 0,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_BOTTOM = 1,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_LEFT = 2,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_RIGHT = 3,
};
#endif /* WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM */

#ifndef WESTON_DESKTOP_SHELL_ERROR_ENUM
#define WESTON_DESKTOP_SHELL_ERROR_ENUM
enum weston_desktop_shell_error {
	/**
	 * an invalid argument was provided in a request
	 */
	WESTON_DESKTOP_SHELL_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* WESTON_DESKTOP_SHELL_ERROR_ENUM */

/**
 * @ingroup iface_weston_desktop_shell
 * @struct weston_desktop_shell_listener
 */
struct weston_desktop_shell_listener {
	/**
	 */
	void (*configure)(void *data,
			  struct weston_desktop_shell *weston_desktop_shell,
			  uint32_t edges,
			  struct wl_surface *surface,
			  int32_t width,
			  int32_t height);
	/**
	 * tell the client to create, set the lock surface
	 *
	 * Tell the client we want it to create and set the lock surface,
	 * which is a GUI asking the user to unlock the screen. The lock
	 * surface is announced with 'set_lock_surface'. Whether or not the
	 * client actually implements locking, it MUST send 'unlock'
	 * request to let the normal desktop resume.
	 */
	void (*prepare_lock_surface)(void *data,
				     struct weston_desktop_shell *weston_desktop_shell);
	/**
	 * tell client what cursor to show during a grab
	 *
	 * This event will be sent immediately before a fake enter event
	 * on the grab surface.
	 */
	void (*grab_cursor)(void *data,
			    struct weston_desktop_shell *weston_desktop_shell,
			    uint32_t cursor);
};

/**
 * @ingroup iface_weston_desktop_shell
 */
static inline int
weston_desktop_shell_add_listener(struct weston_desktop_shell *weston_desktop_shell,
				  const struct weston_desktop_shell_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) weston_desktop_shell,
				     (void (**)(void)) listener, data);
}

#define WESTON_DESKTOP_SHELL_SET_BACKGROUND 0
#define WESTON_DESKTOP_SHELL_SET_PANEL 1
#define WESTON_DESKTOP_SHELL_SET_LOCK_SURFACE 2
#define WESTON_DESKTOP_SHELL_UNLOCK 3
#define WESTON_DESKTOP_SHELL_SET_GRAB_SURFACE 4
#define WESTON_DESKTOP_SHELL_DESKTOP_READY 5
#define WESTON_DESKTOP_SHELL_SET_PANEL_POSITION 6

/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_PREPARE_LOCK_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_GRAB_CURSOR_SINCE_VERSION 1

/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_BACKGROUND_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_LOCK_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_UNLOCK_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_GRAB_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_DESKTOP_READY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_PANEL_POSITION_SINCE_VERSION 1

/** @ingroup iface_weston_desktop_shell */
static inline void
weston_desktop_shell_set_user_data(struct weston_desktop_shell *weston_desktop_shell, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_desktop_shell, user_data);
}

/** @ingroup iface_weston_desktop_shell */
static inline void *
weston_desktop_shell_get_user_data(struct weston_desktop_shell *weston_desktop_shell)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_desktop_shell);
}

static inline uint32_t
weston_desktop_shell_get_version(struct weston_desktop_shell *weston_desktop_shell)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell);
}

/** @ingroup iface_weston_desktop_shell */
static inline void
weston_desktop_shell_destroy(struct weston_desktop_shell *weston_desktop_shell)
{
	wl_proxy_destroy((struct wl_proxy *) weston_desktop_shell);
}

/**
 * @ingroup iface_weston_desktop_shell
 */
static inline void
weston_desktop_shell_set_background(struct weston_desktop_shell *weston_desktop_shell, struct wl_output *output, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_SET_BACKGROUND, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0, output, surface);
}

/**
 * @ingroup iface_weston_desktop_shell
 */
static inline void
weston_desktop_shell_set_panel(struct weston_desktop_shell *weston_desktop_shell, struct wl_output *output, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_SET_PANEL, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0, output, surface);
}

/**
 * @ingroup iface_weston_desktop_shell
 */
static inline void
weston_desktop_shell_set_lock_surface(struct weston_desktop_shell *weston_desktop_shell, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_SET_LOCK_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0, surface);
}

/**
 * @ingroup iface_weston_desktop_shell
 */
static inline void
weston_desktop_shell_unlock(struct weston_desktop_shell *weston_desktop_shell)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_UNLOCK, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0);
}

/**
 * @ingroup iface_weston_desktop_shell
 *
 * The surface set by this request will receive a fake
 * pointer.enter event during grabs at position 0, 0 and is
 * expected to set an appropriate cursor image as described by
 * the grab_cursor event sent just before the enter event.
 */
static inline void
weston_desktop_shell_set_grab_surface(struct weston_desktop_shell *weston_desktop_shell, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_SET_GRAB_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0, surface);
}

/**
 * @ingroup iface_weston_desktop_shell
 *
 * Tell the server, that enough desktop elements have been drawn
 * to make the desktop look ready for use. During start-up, the
 * server can wait for this request with a black screen before
 * starting to fade in the desktop, for instance. If the client
 * parts of a desktop take a long time to initialize, we avoid
 * showing temporary garbage.
 */
static inline void
weston_desktop_shell_desktop_ready(struct weston_desktop_shell *weston_desktop_shell)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_DESKTOP_READY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0);
}

/**
 * @ingroup iface_weston_desktop_shell
 *
 * Tell the shell which side of the screen the panel is
 * located. This is so that new windows do not overlap the panel
 * and maximized windows maximize properly.
 */
static inline void
weston_desktop_shell_set_panel_position(struct weston_desktop_shell *weston_desktop_shell, uint32_t position)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_desktop_shell,
			 WESTON_DESKTOP_SHELL_SET_PANEL_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) weston_desktop_shell), 0, position);
}

#define WESTON_SCREENSAVER_SET_SURFACE 0


/**
 * @ingroup iface_weston_screensaver
 */
#define WESTON_SCREENSAVER_SET_SURFACE_SINCE_VERSION 1

/** @ingroup iface_weston_screensaver */
static inline void
weston_screensaver_set_user_data(struct weston_screensaver *weston_screensaver, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_screensaver, user_data);
}

/** @ingroup iface_weston_screensaver */
static inline void *
weston_screensaver_get_user_data(struct weston_screensaver *weston_screensaver)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_screensaver);
}

static inline uint32_t
weston_screensaver_get_version(struct weston_screensaver *weston_screensaver)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_screensaver);
}

/** @ingroup iface_weston_screensaver */
static inline void
weston_screensaver_destroy(struct weston_screensaver *weston_screensaver)
{
	wl_proxy_destroy((struct wl_proxy *) weston_screensaver);
}

/**
 * @ingroup iface_weston_screensaver
 *
 * A screensaver surface is normally hidden, and only visible after an
 * idle timeout.
 */
static inline void
weston_screensaver_set_surface(struct weston_screensaver *weston_screensaver, struct wl_surface *surface, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_screensaver,
			 WESTON_SCREENSAVER_SET_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_screensaver), 0, surface, output);
}

#ifdef  __cplusplus
}
#endif

#endif
