/* Generated by wayland-scanner 1.24.0 */

#ifndef WESTON_DESKTOP_SERVER_PROTOCOL_H
#define WESTON_DESKTOP_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_weston_desktop The weston_desktop protocol
 * @section page_ifaces_weston_desktop Interfaces
 * - @subpage page_iface_weston_desktop_shell - create desktop widgets and helpers
 * - @subpage page_iface_weston_screensaver - interface for implementing screensavers
 */
struct weston_desktop_shell;
struct weston_screensaver;
struct wl_output;
struct wl_surface;

#ifndef WESTON_DESKTOP_SHELL_INTERFACE
#define WESTON_DESKTOP_SHELL_INTERFACE
/**
 * @page page_iface_weston_desktop_shell weston_desktop_shell
 * @section page_iface_weston_desktop_shell_desc Description
 *
 * Traditional user interfaces can rely on this interface to define the
 * foundations of typical desktops. Currently it's possible to set up
 * background, panels and locking surfaces.
 * @section page_iface_weston_desktop_shell_api API
 * See @ref iface_weston_desktop_shell.
 */
/**
 * @defgroup iface_weston_desktop_shell The weston_desktop_shell interface
 *
 * Traditional user interfaces can rely on this interface to define the
 * foundations of typical desktops. Currently it's possible to set up
 * background, panels and locking surfaces.
 */
extern const struct wl_interface weston_desktop_shell_interface;
#endif
#ifndef WESTON_SCREENSAVER_INTERFACE
#define WESTON_SCREENSAVER_INTERFACE
/**
 * @page page_iface_weston_screensaver weston_screensaver
 * @section page_iface_weston_screensaver_desc Description
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_weston_screensaver_api API
 * See @ref iface_weston_screensaver.
 */
/**
 * @defgroup iface_weston_screensaver The weston_screensaver interface
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface weston_screensaver_interface;
#endif

#ifndef WESTON_DESKTOP_SHELL_CURSOR_ENUM
#define WESTON_DESKTOP_SHELL_CURSOR_ENUM
enum weston_desktop_shell_cursor {
	WESTON_DESKTOP_SHELL_CURSOR_NONE = 0,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP = 1,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM = 2,
	WESTON_DESKTOP_SHELL_CURSOR_ARROW = 3,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_LEFT = 4,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_LEFT = 5,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_LEFT = 6,
	WESTON_DESKTOP_SHELL_CURSOR_MOVE = 7,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_RIGHT = 8,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_RIGHT = 9,
	WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_RIGHT = 10,
	WESTON_DESKTOP_SHELL_CURSOR_BUSY = 11,
};
#endif /* WESTON_DESKTOP_SHELL_CURSOR_ENUM */

#ifndef WESTON_DESKTOP_SHELL_CURSOR_ENUM_IS_VALID
#define WESTON_DESKTOP_SHELL_CURSOR_ENUM_IS_VALID
/**
 * @ingroup iface_weston_desktop_shell
 * Validate a weston_desktop_shell cursor value.
 *
 * @return true on success, false on error.
 * @ref weston_desktop_shell_cursor
 */
static inline bool
weston_desktop_shell_cursor_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WESTON_DESKTOP_SHELL_CURSOR_NONE:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_ARROW:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_LEFT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_LEFT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_LEFT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_MOVE:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_RIGHT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_TOP_RIGHT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_RESIZE_BOTTOM_RIGHT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_CURSOR_BUSY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WESTON_DESKTOP_SHELL_CURSOR_ENUM_IS_VALID */

#ifndef WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM
#define WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM
enum weston_desktop_shell_panel_position {
	WESTON_DESKTOP_SHELL_PANEL_POSITION_TOP = 0,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_BOTTOM = 1,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_LEFT = 2,
	WESTON_DESKTOP_SHELL_PANEL_POSITION_RIGHT = 3,
};
#endif /* WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM */

#ifndef WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM_IS_VALID
#define WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM_IS_VALID
/**
 * @ingroup iface_weston_desktop_shell
 * Validate a weston_desktop_shell panel_position value.
 *
 * @return true on success, false on error.
 * @ref weston_desktop_shell_panel_position
 */
static inline bool
weston_desktop_shell_panel_position_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WESTON_DESKTOP_SHELL_PANEL_POSITION_TOP:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_PANEL_POSITION_BOTTOM:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_PANEL_POSITION_LEFT:
		return version >= 1;
	case WESTON_DESKTOP_SHELL_PANEL_POSITION_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WESTON_DESKTOP_SHELL_PANEL_POSITION_ENUM_IS_VALID */

#ifndef WESTON_DESKTOP_SHELL_ERROR_ENUM
#define WESTON_DESKTOP_SHELL_ERROR_ENUM
enum weston_desktop_shell_error {
	/**
	 * an invalid argument was provided in a request
	 */
	WESTON_DESKTOP_SHELL_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* WESTON_DESKTOP_SHELL_ERROR_ENUM */

#ifndef WESTON_DESKTOP_SHELL_ERROR_ENUM_IS_VALID
#define WESTON_DESKTOP_SHELL_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_weston_desktop_shell
 * Validate a weston_desktop_shell error value.
 *
 * @return true on success, false on error.
 * @ref weston_desktop_shell_error
 */
static inline bool
weston_desktop_shell_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WESTON_DESKTOP_SHELL_ERROR_INVALID_ARGUMENT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WESTON_DESKTOP_SHELL_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_weston_desktop_shell
 * @struct weston_desktop_shell_interface
 */
struct weston_desktop_shell_interface {
	/**
	 */
	void (*set_background)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *output,
			       struct wl_resource *surface);
	/**
	 */
	void (*set_panel)(struct wl_client *client,
			  struct wl_resource *resource,
			  struct wl_resource *output,
			  struct wl_resource *surface);
	/**
	 */
	void (*set_lock_surface)(struct wl_client *client,
				 struct wl_resource *resource,
				 struct wl_resource *surface);
	/**
	 */
	void (*unlock)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * set grab surface
	 *
	 * The surface set by this request will receive a fake
	 * pointer.enter event during grabs at position 0, 0 and is
	 * expected to set an appropriate cursor image as described by the
	 * grab_cursor event sent just before the enter event.
	 */
	void (*set_grab_surface)(struct wl_client *client,
				 struct wl_resource *resource,
				 struct wl_resource *surface);
	/**
	 * desktop is ready to be shown
	 *
	 * Tell the server, that enough desktop elements have been drawn
	 * to make the desktop look ready for use. During start-up, the
	 * server can wait for this request with a black screen before
	 * starting to fade in the desktop, for instance. If the client
	 * parts of a desktop take a long time to initialize, we avoid
	 * showing temporary garbage.
	 */
	void (*desktop_ready)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * set panel position
	 *
	 * Tell the shell which side of the screen the panel is located.
	 * This is so that new windows do not overlap the panel and
	 * maximized windows maximize properly.
	 */
	void (*set_panel_position)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t position);
};

#define WESTON_DESKTOP_SHELL_CONFIGURE 0
#define WESTON_DESKTOP_SHELL_PREPARE_LOCK_SURFACE 1
#define WESTON_DESKTOP_SHELL_GRAB_CURSOR 2

/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_PREPARE_LOCK_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_GRAB_CURSOR_SINCE_VERSION 1

/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_BACKGROUND_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_LOCK_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_UNLOCK_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_GRAB_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_DESKTOP_READY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_desktop_shell
 */
#define WESTON_DESKTOP_SHELL_SET_PANEL_POSITION_SINCE_VERSION 1

/**
 * @ingroup iface_weston_desktop_shell
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_desktop_shell_send_configure(struct wl_resource *resource_, uint32_t edges, struct wl_resource *surface, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, WESTON_DESKTOP_SHELL_CONFIGURE, edges, surface, width, height);
}

/**
 * @ingroup iface_weston_desktop_shell
 * Sends an prepare_lock_surface event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_desktop_shell_send_prepare_lock_surface(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_DESKTOP_SHELL_PREPARE_LOCK_SURFACE);
}

/**
 * @ingroup iface_weston_desktop_shell
 * Sends an grab_cursor event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_desktop_shell_send_grab_cursor(struct wl_resource *resource_, uint32_t cursor)
{
	wl_resource_post_event(resource_, WESTON_DESKTOP_SHELL_GRAB_CURSOR, cursor);
}

/**
 * @ingroup iface_weston_screensaver
 * @struct weston_screensaver_interface
 */
struct weston_screensaver_interface {
	/**
	 * set the surface type as a screensaver
	 *
	 * A screensaver surface is normally hidden, and only visible
	 * after an idle timeout.
	 */
	void (*set_surface)(struct wl_client *client,
			    struct wl_resource *resource,
			    struct wl_resource *surface,
			    struct wl_resource *output);
};


/**
 * @ingroup iface_weston_screensaver
 */
#define WESTON_SCREENSAVER_SET_SURFACE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
