﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appconfig/AppConfig_EXPORTS.h>
#include <aws/appconfig/model/Validator.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppConfig {
namespace Model {
class CreateConfigurationProfileResult {
 public:
  AWS_APPCONFIG_API CreateConfigurationProfileResult() = default;
  AWS_APPCONFIG_API CreateConfigurationProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPCONFIG_API CreateConfigurationProfileResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The application ID.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  CreateConfigurationProfileResult& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration profile ID.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateConfigurationProfileResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configuration profile.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateConfigurationProfileResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration profile description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateConfigurationProfileResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URI location of the configuration.</p>
   */
  inline const Aws::String& GetLocationUri() const { return m_locationUri; }
  template <typename LocationUriT = Aws::String>
  void SetLocationUri(LocationUriT&& value) {
    m_locationUriHasBeenSet = true;
    m_locationUri = std::forward<LocationUriT>(value);
  }
  template <typename LocationUriT = Aws::String>
  CreateConfigurationProfileResult& WithLocationUri(LocationUriT&& value) {
    SetLocationUri(std::forward<LocationUriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of an IAM role with permission to access the configuration at the
   * specified <code>LocationUri</code>.</p>
   */
  inline const Aws::String& GetRetrievalRoleArn() const { return m_retrievalRoleArn; }
  template <typename RetrievalRoleArnT = Aws::String>
  void SetRetrievalRoleArn(RetrievalRoleArnT&& value) {
    m_retrievalRoleArnHasBeenSet = true;
    m_retrievalRoleArn = std::forward<RetrievalRoleArnT>(value);
  }
  template <typename RetrievalRoleArnT = Aws::String>
  CreateConfigurationProfileResult& WithRetrievalRoleArn(RetrievalRoleArnT&& value) {
    SetRetrievalRoleArn(std::forward<RetrievalRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of methods for validating the configuration.</p>
   */
  inline const Aws::Vector<Validator>& GetValidators() const { return m_validators; }
  template <typename ValidatorsT = Aws::Vector<Validator>>
  void SetValidators(ValidatorsT&& value) {
    m_validatorsHasBeenSet = true;
    m_validators = std::forward<ValidatorsT>(value);
  }
  template <typename ValidatorsT = Aws::Vector<Validator>>
  CreateConfigurationProfileResult& WithValidators(ValidatorsT&& value) {
    SetValidators(std::forward<ValidatorsT>(value));
    return *this;
  }
  template <typename ValidatorsT = Validator>
  CreateConfigurationProfileResult& AddValidators(ValidatorsT&& value) {
    m_validatorsHasBeenSet = true;
    m_validators.emplace_back(std::forward<ValidatorsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of configurations contained in the profile. AppConfig supports
   * <code>feature flags</code> and <code>freeform</code> configurations. We
   * recommend you create feature flag configurations to enable or disable new
   * features and freeform configurations to distribute configurations to an
   * application. When calling this API, enter one of the following values for
   * <code>Type</code>:</p> <p> <code>AWS.AppConfig.FeatureFlags</code> </p> <p>
   * <code>AWS.Freeform</code> </p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  CreateConfigurationProfileResult& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name of the Key Management Service key to encrypt new
   * configuration data versions in the AppConfig hosted configuration store. This
   * attribute is only used for <code>hosted</code> configuration types. To encrypt
   * data managed in other configuration stores, see the documentation for how to
   * specify an KMS key for that particular service.</p>
   */
  inline const Aws::String& GetKmsKeyArn() const { return m_kmsKeyArn; }
  template <typename KmsKeyArnT = Aws::String>
  void SetKmsKeyArn(KmsKeyArnT&& value) {
    m_kmsKeyArnHasBeenSet = true;
    m_kmsKeyArn = std::forward<KmsKeyArnT>(value);
  }
  template <typename KmsKeyArnT = Aws::String>
  CreateConfigurationProfileResult& WithKmsKeyArn(KmsKeyArnT&& value) {
    SetKmsKeyArn(std::forward<KmsKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Key Management Service key identifier (key ID, key alias, or key ARN)
   * provided when the resource was created or updated.</p>
   */
  inline const Aws::String& GetKmsKeyIdentifier() const { return m_kmsKeyIdentifier; }
  template <typename KmsKeyIdentifierT = Aws::String>
  void SetKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    m_kmsKeyIdentifierHasBeenSet = true;
    m_kmsKeyIdentifier = std::forward<KmsKeyIdentifierT>(value);
  }
  template <typename KmsKeyIdentifierT = Aws::String>
  CreateConfigurationProfileResult& WithKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    SetKmsKeyIdentifier(std::forward<KmsKeyIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateConfigurationProfileResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_locationUri;

  Aws::String m_retrievalRoleArn;

  Aws::Vector<Validator> m_validators;

  Aws::String m_type;

  Aws::String m_kmsKeyArn;

  Aws::String m_kmsKeyIdentifier;

  Aws::String m_requestId;
  bool m_applicationIdHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_locationUriHasBeenSet = false;
  bool m_retrievalRoleArnHasBeenSet = false;
  bool m_validatorsHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_kmsKeyArnHasBeenSet = false;
  bool m_kmsKeyIdentifierHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppConfig
}  // namespace Aws
