/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.MockPseudoRandom;

public class CombatTest
extends FreeColTestCase {
    private static final Role armedBraveRole = CombatTest.spec().getRole("model.role.armedBrave");
    private static final Role cavalryRole = CombatTest.spec().getRole("model.role.cavalry");
    private static final Role dragoonRole = CombatTest.spec().getRole("model.role.dragoon");
    private static final Role infantryRole = CombatTest.spec().getRole("model.role.infantry");
    private static final Role missionaryRole = CombatTest.spec().getRole("model.role.missionary");
    private static final Role nativeDragoonRole = CombatTest.spec().getRole("model.role.nativeDragoon");
    private static final Role soldierRole = CombatTest.spec().getRole("model.role.soldier");
    private static final TileType hills = CombatTest.spec().getTileType("model.tile.hills");
    private static final TileType ocean = CombatTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = CombatTest.spec().getTileType("model.tile.plains");
    private static final UnitType artilleryType = CombatTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType braveType = CombatTest.spec().getUnitType("model.unit.brave");
    private static final UnitType colonialRegularType = CombatTest.spec().getUnitType("model.unit.colonialRegular");
    private static final UnitType colonistType = CombatTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType damagedArtilleryType = CombatTest.spec().getUnitType("model.unit.damagedArtillery");
    private static final UnitType galleonType = CombatTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType indenturedServantType = CombatTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType indianConvertType = CombatTest.spec().getUnitType("model.unit.indianConvert");
    private static final UnitType jesuitMissionaryType = CombatTest.spec().getUnitType("model.unit.jesuitMissionary");
    private static final UnitType kingsRegularType = CombatTest.spec().getUnitType("model.unit.kingsRegular");
    private static final UnitType pettyCriminalType = CombatTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final UnitType privateerType = CombatTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType veteranType = CombatTest.spec().getUnitType("model.unit.veteranSoldier");

    public void testColonistAttackedByVeteran() throws Exception {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap(plains);
        game.changeMap(map);
        CombatModel combatModel = game.getCombatModel();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        FreeColTestCase.spec();
        Tile tile1 = map.getTile(5, 8);
        tile1.setType(hills);
        CombatTest.assertEquals((Object)hills, (Object)tile1.getType());
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        colonist.setStateUnchecked(Unit.UnitState.FORTIFIED);
        ServerUnit soldier = new ServerUnit(game, tile2, french, veteranType, dragoonRole);
        soldier.setMovesLeft(1);
        CombatTest.assertFalse((boolean)soldier.hasAbility("model.ability.ambushBonus"));
        CombatTest.assertFalse((boolean)colonist.hasAbility("model.ability.ambushPenalty"));
        Modifier bigMovementPenalty = CollectionUtils.first(CombatTest.spec().getModifiers("model.modifier.bigMovementPenalty"));
        Modifier attackModifier = CollectionUtils.first(CombatTest.spec().getModifiers("model.modifier.attackBonus"));
        List<Modifier> veteranModifiers = CollectionUtils.toList(veteranType.getModifiers("model.modifier.offence"));
        CombatTest.assertEquals((int)1, (int)veteranModifiers.size());
        Modifier veteranModifier = CollectionUtils.first(veteranModifiers);
        Set<Modifier> offenceModifiers = combatModel.getOffensiveModifiers(soldier, colonist);
        CombatTest.assertEquals((int)5, (int)offenceModifiers.size());
        int n = 0;
        for (Modifier m : offenceModifiers) {
            if (m.getSource() == Specification.BASE_OFFENCE_SOURCE) {
                ++n;
            }
            if (m == bigMovementPenalty) {
                n += 2;
            }
            if (m == attackModifier) {
                n += 4;
            }
            if (m == veteranModifier) {
                n += 8;
            }
            if (m.getSource() != dragoonRole) continue;
            n += 16;
        }
        CombatTest.assertEquals((int)31, (int)n);
        Modifier fortifiedModifier = CollectionUtils.first(CombatTest.spec().getModifiers("model.modifier.fortified"));
        List<Modifier> hillsModifiers = CollectionUtils.toList(hills.getDefenceModifiers());
        CombatTest.assertEquals((int)1, (int)hillsModifiers.size());
        Modifier hillsModifier = CollectionUtils.first(hillsModifiers);
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(soldier, colonist);
        CombatTest.assertEquals((int)3, (int)defenceModifiers.size());
        CombatTest.assertTrue((boolean)defenceModifiers.contains(fortifiedModifier));
        defenceModifiers.remove(fortifiedModifier);
        CombatTest.assertTrue((boolean)defenceModifiers.contains(hillsModifier));
        defenceModifiers.remove(hillsModifier);
        CombatTest.assertEquals((Object)Specification.BASE_DEFENCE_SOURCE, (Object)CollectionUtils.first(defenceModifiers).getSource());
    }

    public void testGalleonAttackedByPrivateer() throws Exception {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap(ocean);
        game.changeMap(map);
        CombatModel combatModel = game.getCombatModel();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        FreeColTestCase.spec();
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit galleon = new ServerUnit(game, tile1, dutch, galleonType);
        ServerUnit privateer = new ServerUnit(game, tile2, french, privateerType);
        Set<Modifier> offenceModifiers = combatModel.getOffensiveModifiers(privateer, galleon);
        CombatTest.assertEquals((int)2, (int)offenceModifiers.size());
        int n = 0;
        for (Modifier m : offenceModifiers) {
            if (m.getSource() == Specification.ATTACK_BONUS_SOURCE) {
                ++n;
            }
            if (m.getSource() != Specification.BASE_OFFENCE_SOURCE) continue;
            n += 2;
        }
        CombatTest.assertEquals((int)n, (int)3);
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(privateer, galleon);
        CombatTest.assertEquals((int)1, (int)defenceModifiers.size());
        CombatTest.assertEquals((Object)Specification.BASE_DEFENCE_SOURCE, (Object)CollectionUtils.first(defenceModifiers).getSource());
        galleon.setStateUnchecked(Unit.UnitState.FORTIFIED);
        defenceModifiers = combatModel.getDefensiveModifiers(privateer, galleon);
        CombatTest.assertEquals((int)1, (int)defenceModifiers.size());
        CombatTest.assertEquals((Object)Specification.BASE_DEFENCE_SOURCE, (Object)CollectionUtils.first(defenceModifiers).getSource());
        GoodsType lumberType = CombatTest.spec().getGoodsType("model.goods.lumber");
        Goods goods1 = new Goods(game, null, lumberType, 50);
        privateer.add(goods1);
        offenceModifiers = combatModel.getOffensiveModifiers(privateer, galleon);
        CombatTest.assertEquals((int)3, (int)offenceModifiers.size());
        n = 0;
        for (Modifier modifier : offenceModifiers) {
            if (modifier.getSource() == Specification.BASE_OFFENCE_SOURCE) {
                ++n;
            }
            if (modifier.getSource() == Specification.ATTACK_BONUS_SOURCE) {
                n += 2;
            }
            if (modifier.getSource() != Specification.CARGO_PENALTY_SOURCE) continue;
            n += 4;
        }
        CombatTest.assertEquals((int)7, (int)n);
        Goods goods2 = new Goods(game, null, lumberType, 150);
        galleon.add(goods2);
        CombatTest.assertEquals((int)2, (int)galleon.getVisibleGoodsCount());
        defenceModifiers = combatModel.getDefensiveModifiers(privateer, galleon);
        n = 0;
        CombatTest.assertEquals((int)2, (int)defenceModifiers.size());
        for (Modifier m : defenceModifiers) {
            if (m.getSource() == Specification.BASE_DEFENCE_SOURCE) {
                ++n;
            }
            if (m.getSource() != Specification.CARGO_PENALTY_SOURCE) continue;
            n += 2;
            CombatTest.assertEquals((Object)Float.valueOf(-25.0f), (Object)Float.valueOf(m.getValue()));
        }
        CombatTest.assertEquals((int)3, (int)n);
        FoundingFather foundingFather = CombatTest.spec().getFoundingFather("model.foundingFather.francisDrake");
        Modifier drakeModifier = CollectionUtils.first(foundingFather.getModifiers("model.modifier.offence", privateerType));
        CombatTest.assertNotNull((Object)drakeModifier);
        french.addFather(foundingFather);
        CombatTest.assertEquals((Object)drakeModifier, (Object)CollectionUtils.first(french.getModifiers("model.modifier.offence", privateerType)));
        offenceModifiers = combatModel.getOffensiveModifiers(privateer, galleon);
        CombatTest.assertEquals((int)4, (int)offenceModifiers.size());
        n = 0;
        for (Modifier m : offenceModifiers) {
            if (m.getSource() == Specification.BASE_OFFENCE_SOURCE) {
                ++n;
            }
            if (m.getSource() == foundingFather) {
                n += 2;
            }
            if (m.getSource() == Specification.ATTACK_BONUS_SOURCE) {
                n += 4;
            }
            if (m.getSource() != Specification.CARGO_PENALTY_SOURCE) continue;
            n += 8;
            CombatTest.assertEquals((Object)Float.valueOf(-12.5f), (Object)Float.valueOf(m.getValue()));
        }
        CombatTest.assertEquals((int)15, (int)n);
        CombatTest.assertEquals((String)"Wrong move type", (Object)((Object)Unit.MoveType.ATTACK_UNIT), (Object)((Object)privateer.getMoveType(tile1)));
    }

    public void testDefendColonyWithUnarmedColonist() {
        Game game = CombatTest.getGame();
        Map map = CombatTest.getTestMap(true);
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Unit colonist = CollectionUtils.first(colony.getUnitList());
        ServerUnit attacker = new ServerUnit(CombatTest.getGame(), tile2, inca, braveType, armedBraveRole);
        CombatTest.assertEquals((Object)colonist, (Object)colony.getDefendingUnit(attacker));
        CombatTest.assertEquals((Object)colonist, (Object)colony.getTile().getDefendingUnit(attacker));
        ServerUnit defender = new ServerUnit(CombatTest.getGame(), colony.getTile(), dutch, colonistType);
        CombatTest.assertFalse((String)"Colonist should not be defensive unit", (boolean)defender.isDefensiveUnit());
        CombatTest.assertEquals((Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
    }

    public void testDefendColonyWithRevere() {
        Game game = CombatTest.getGame();
        Map map = CombatTest.getTestMap(true);
        game.changeMap(map);
        SimpleCombatModel combatModel = new SimpleCombatModel();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Colony colony = this.getStandardColony();
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Unit colonist = CollectionUtils.first(colony.getUnitList());
        ServerUnit attacker = new ServerUnit(CombatTest.getGame(), tile2, inca, braveType, armedBraveRole);
        CombatTest.assertEquals((Object)colonist, (Object)colony.getDefendingUnit(attacker));
        dutch.addFather(CombatTest.spec().getFoundingFather("model.foundingFather.paulRevere"));
        for (AbstractGoods ag : soldierRole.getRequiredGoodsList()) {
            colony.addGoods(ag);
        }
        CombatTest.assertEquals((Object)soldierRole, (Object)colonist.getAutomaticRole());
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(attacker, colonist);
        CollectionUtils.forEach(soldierRole.getModifiers("model.modifier.defence"), m -> CombatTest.assertTrue((boolean)defenceModifiers.contains(m)));
    }

    public void testDefendSettlement() {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap();
        game.changeMap(map);
        SimpleCombatModel combatModel = new SimpleCombatModel();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player inca = game.getPlayerByNationId("model.nation.inca");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement is = builder.player(inca).settlementTile(tile1).skillToTeach(null).capital(true).build();
        ServerUnit defender = new ServerUnit(game, is, inca, braveType, nativeDragoonRole);
        ServerUnit attacker = new ServerUnit(game, tile2, dutch, colonistType, dragoonRole);
        for (AbstractGoods ag : nativeDragoonRole.getRequiredGoodsList()) {
            is.addGoods(ag);
        }
        Set<Modifier> defenceModifiers = combatModel.getDefensiveModifiers(attacker, defender);
        CollectionUtils.forEach(nativeDragoonRole.getModifiers("model.modifier.defence"), m -> CombatTest.assertTrue((boolean)defenceModifiers.contains(m)));
    }

    public void testAttackIgnoresMovementPoints() throws Exception {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap(plains, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile1.setType(hills);
        CombatTest.assertEquals((Object)hills, (Object)tile1.getType());
        dutch.setStance(french, Stance.WAR);
        french.setStance(dutch, Stance.WAR);
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        colonist.setStateUnchecked(Unit.UnitState.FORTIFIED);
        ServerUnit soldier = new ServerUnit(game, tile2, french, veteranType, dragoonRole);
        soldier.setStateUnchecked(Unit.UnitState.FORTIFIED);
        CombatTest.assertEquals((Object)tile1, (Object)colonist.getLocation());
        CombatTest.assertEquals((Object)tile2, (Object)soldier.getLocation());
        CombatTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_UNIT), (Object)((Object)soldier.getMoveType(tile2, tile1, 9)));
        CombatTest.assertEquals((Object)((Object)Unit.MoveType.ATTACK_UNIT), (Object)((Object)soldier.getMoveType(tile2, tile1, 1)));
        CombatTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_MOVES), (Object)((Object)soldier.getMoveType(tile2, tile1, 0)));
    }

    public void testSpanishAgainstNatives() throws Exception {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap(plains, true);
        game.changeMap(map);
        Player spanish = game.getPlayerByNationId("model.nation.spanish");
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player tupi = game.getPlayerByNationId("model.nation.tupi");
        SimpleCombatModel combatModel = new SimpleCombatModel();
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile1.setType(hills);
        CombatTest.assertEquals((Object)hills, (Object)tile1.getType());
        spanish.setStance(tupi, Stance.WAR);
        tupi.setStance(spanish, Stance.WAR);
        ServerUnit soldier = new ServerUnit(game, tile1, spanish, colonistType, soldierRole);
        ServerUnit brave = new ServerUnit(game, tile2, tupi, braveType);
        CombatTest.assertEquals((Object)tile1, (Object)soldier.getLocation());
        CombatTest.assertEquals((Object)tile2, (Object)brave.getLocation());
        Set<Modifier> offenceModifiers = combatModel.getOffensiveModifiers(soldier, brave);
        Modifier offenceAgainst = null;
        for (Modifier modifier : offenceModifiers) {
            if (!"model.modifier.offenceAgainst".equals(modifier.getId())) continue;
            offenceAgainst = modifier;
            break;
        }
        CombatTest.assertNotNull(offenceAgainst);
        CombatTest.assertEquals((int)50, (int)((int)offenceAgainst.getValue()));
        Tile tile3 = map.getTile(6, 8);
        ServerUnit dutchSoldier = new ServerUnit(game, tile3, dutch, colonistType, soldierRole);
        offenceAgainst = null;
        for (Modifier modifier : combatModel.getOffensiveModifiers(soldier, dutchSoldier)) {
            if (!"model.modifier.offenceAgainst".equals(modifier.getId())) continue;
            offenceAgainst = modifier;
            break;
        }
        CombatTest.assertNull((Object)offenceAgainst);
    }

    public void testAttackShipWithLandUnit() {
        Game game = CombatTest.getStandardGame();
        Map map = CombatTest.getTestMap(plains, true);
        game.changeMap(map);
        Player spanish = game.getPlayerByNationId("model.nation.spanish");
        Player tupi = game.getPlayerByNationId("model.nation.tupi");
        SimpleCombatModel combatModel = new SimpleCombatModel();
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile1.setType(hills);
        CombatTest.assertEquals((Object)hills, (Object)tile1.getType());
        tile2.setType(ocean);
        CombatTest.assertEquals((Object)ocean, (Object)tile2.getType());
        spanish.setStance(tupi, Stance.WAR);
        tupi.setStance(spanish, Stance.WAR);
        ServerUnit galleon = new ServerUnit(game, tile2, spanish, galleonType);
        ServerUnit brave = new ServerUnit(game, tile1, tupi, braveType);
        CombatTest.assertEquals((Object)tile1, (Object)brave.getLocation());
        CombatTest.assertEquals((Object)tile2, (Object)galleon.getLocation());
        CombatTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_LAND), (Object)((Object)galleon.getMoveType(tile2, tile1, 3)));
        CombatTest.assertEquals((Object)((Object)Unit.MoveType.MOVE_NO_ACCESS_EMBARK), (Object)((Object)brave.getMoveType(tile1, tile2, 3)));
    }

    public void testRegulars() {
        ServerGame game = ServerTestHelper.startServerGame(CombatTest.getTestMap(plains, true));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        french.addAbility(new Ability("model.ability.independenceDeclared"));
        ServerPlayer refPlayer = igc.createREFPlayer(french);
        SimpleCombatModel combatModel = new SimpleCombatModel();
        Map map = game.getMap();
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        ServerUnit regular = new ServerUnit(game, tile2, refPlayer, kingsRegularType, cavalryRole);
        ServerUnit colonial = new ServerUnit(game, tile1, french, colonialRegularType, dragoonRole);
        MockPseudoRandom loseRandom = new MockPseudoRandom();
        ArrayList<Integer> i1 = new ArrayList<Integer>();
        i1.add(0x6CCCCCCB);
        loseRandom.setNextNumbers(i1, true);
        MockPseudoRandom winRandom = new MockPseudoRandom();
        ArrayList<Integer> i2 = new ArrayList<Integer>();
        i2.add(0x19999999);
        winRandom.setNextNumbers(i2, true);
        double offence = 10.5;
        CombatTest.assertEquals((Object)offence, (Object)combatModel.getOffencePower(regular, colonial));
        double defence = 6.0;
        CombatTest.assertEquals((Object)defence, (Object)combatModel.getDefencePower(regular, colonial));
        List<CombatModel.CombatEffectType> crs = combatModel.generateAttackResult(loseRandom, regular, colonial).getEffects();
        this.checkCombat("Regular v Colonial", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        refPlayer.csCombat(regular, colonial, crs, loseRandom, new ChangeSet());
        CombatTest.assertEquals((Object)infantryRole, (Object)regular.getRole());
        offence = 9.0;
        CombatTest.assertEquals((Object)offence, (Object)combatModel.getOffencePower(regular, colonial));
        crs = combatModel.generateAttackResult(winRandom, colonial, regular).getEffects();
        this.checkCombat("Regular should be slaughtered upon losing all equipment", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        regular = new ServerUnit(game, tile2, french, kingsRegularType, cavalryRole);
        crs = combatModel.generateAttackResult(winRandom, regular, colonial).getEffects();
        this.checkCombat("Regular v Colonial (2)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        refPlayer.csCombat(regular, colonial, crs, winRandom, new ChangeSet());
        CombatTest.assertEquals((Object)soldierRole, (Object)colonial.getRole());
        crs = combatModel.generateAttackResult(winRandom, regular, colonial).getEffects();
        this.checkCombat("Regular v Colonial (3)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.DEMOTE_UNIT);
        refPlayer.csCombat(regular, colonial, crs, winRandom, new ChangeSet());
        CombatTest.assertFalse((boolean)colonial.isArmed());
        CombatTest.assertEquals((Object)veteranType, (Object)colonial.getType());
        CombatTest.assertEquals((Object)CombatTest.spec().getDefaultRole(), (Object)colonial.getRole());
        crs = combatModel.generateAttackResult(winRandom, regular, colonial).getEffects();
        this.checkCombat("Regular v Colonial (4)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.CAPTURE_UNIT);
        refPlayer.csCombat(regular, colonial, crs, winRandom, new ChangeSet());
    }

    public void testCaptureConvert() {
        Map map = CombatTest.getTestMap(plains, true);
        ServerGame game = ServerTestHelper.startServerGame(map);
        CombatModel combatModel = game.getCombatModel();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        dutch.setStance(inca, Stance.WAR);
        inca.setStance(dutch, Stance.WAR);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        ServerUnit missionary = new ServerUnit(game, null, dutch, jesuitMissionaryType, missionaryRole);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement is = builder.player(inca).settlementTile(tile1).skillToTeach(null).capital(true).initialBravesInCamp(8).missionary(missionary).build();
        CombatTest.spec().setInteger("model.option.nativeConvertProbability", 100);
        ServerUnit soldier = new ServerUnit(game, tile2, dutch, veteranType, soldierRole);
        Unit defender = is.getDefendingUnit(soldier);
        CombatTest.assertNotNull((Object)defender);
        CombatTest.assertTrue((boolean)defender.getOwner().isIndian());
        MockPseudoRandom random = new MockPseudoRandom();
        ArrayList<Integer> il = new ArrayList<Integer>();
        il.add(0);
        random.setNextNumbers(il, true);
        List<CombatModel.CombatEffectType> crs = combatModel.generateAttackResult(random, soldier, defender).getEffects();
        this.checkCombat("Capture convert", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT, CombatModel.CombatEffectType.CAPTURE_CONVERT);
        CombatTest.assertEquals((String)"One unit on tile", (int)1, (int)tile2.getUnitList().size());
        dutch.csCombat(soldier, defender, crs, new Random(), new ChangeSet());
        CombatTest.assertEquals((String)"Two units on tile", (int)2, (int)tile2.getUnitList().size());
        CombatTest.assertEquals((String)"Convert on tile", (Object)indianConvertType, (Object)tile2.getUnitList().get(1).getType());
    }
}

