/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.freeplane.view.swing.map.outline.BlockPanel;

class OutlineBlockViewCache {
    private final Map<Integer, BlockPanel> blocks = new HashMap<Integer, BlockPanel>();

    OutlineBlockViewCache() {
    }

    boolean has(int blockIndex) {
        return this.blocks.containsKey(blockIndex);
    }

    BlockPanel get(int blockIndex) {
        return this.blocks.get(blockIndex);
    }

    void put(int blockIndex, BlockPanel panel) {
        this.blocks.put(blockIndex, panel);
    }

    void remove(int blockIndex) {
        this.blocks.remove(blockIndex);
    }

    void clear() {
        this.blocks.clear();
    }

    boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    Set<Integer> keySet() {
        return Collections.unmodifiableSet(this.blocks.keySet());
    }

    Collection<BlockPanel> blockPanels() {
        return Collections.unmodifiableCollection(this.blocks.values());
    }

    void setBlockWidhts(int width) {
        this.blocks.values().forEach(block -> block.setSize(width, block.getHeight()));
    }
}

