# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## CoDualOnMorphisms
InstallMethod( AddCoDualOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoDualOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddCoDualOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoDualOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoDualOnMorphismsWithGivenCoDuals
InstallMethod( AddCoDualOnMorphismsWithGivenCoDuals,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoDualOnMorphismsWithGivenCoDuals", category, func, -1 );
    
end );

InstallMethod( AddCoDualOnMorphismsWithGivenCoDuals,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoDualOnMorphismsWithGivenCoDuals", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoDualOnMorphismsWithGivenCoDuals,
                    "CoDualOnMorphismsWithGivenCoDuals by calling CoDualOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ CoDualOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, r )
    
    return CoDualOnMorphisms( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoDualOnMorphisms,
                    "CoDualOnMorphisms by calling CoDualOnMorphismsWithGivenCoDuals with the WithGiven object(s)",
                    [
                        [ CoDualOnMorphismsWithGivenCoDuals, 1 ],
                        [ CoDualOnObjects, 2 ],
                    ],
  function( cat, alpha )
    
    return CoDualOnMorphismsWithGivenCoDuals( cat, CoDualOnObjects( cat, Range( alpha ) ), alpha, CoDualOnObjects( cat, Source( alpha ) ) );
    
end : is_with_given_derivation := true );

## CoDualOnObjects
InstallMethod( AddCoDualOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoDualOnObjects", category, func, -1 );
    
end );

InstallMethod( AddCoDualOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoDualOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoDualityTensorProductCompatibilityMorphism
InstallMethod( AddCoDualityTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoDualityTensorProductCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoDualityTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoDualityTensorProductCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoDualityTensorProductCompatibilityMorphismWithGivenObjects
InstallMethod( AddCoDualityTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoDualityTensorProductCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddCoDualityTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoDualityTensorProductCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoDualityTensorProductCompatibilityMorphismWithGivenObjects,
                    "CoDualityTensorProductCompatibilityMorphismWithGivenObjects by calling CoDualityTensorProductCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ CoDualityTensorProductCompatibilityMorphism, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return CoDualityTensorProductCompatibilityMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoDualityTensorProductCompatibilityMorphism,
                    "CoDualityTensorProductCompatibilityMorphism by calling CoDualityTensorProductCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ CoDualityTensorProductCompatibilityMorphismWithGivenObjects, 1 ],
                        [ CoDualOnObjects, 3 ],
                        [ TensorProductOnObjects, 2 ],
                    ],
  function( cat, a, b )
    
    return CoDualityTensorProductCompatibilityMorphismWithGivenObjects( cat, CoDualOnObjects( cat, TensorProductOnObjects( cat, a, b ) ), a, b, TensorProductOnObjects( cat, CoDualOnObjects( cat, a ), CoDualOnObjects( cat, b ) ) );
    
end : is_with_given_derivation := true );

## CoLambdaElimination
InstallMethod( AddCoLambdaElimination,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoLambdaElimination", category, func, -1 );
    
end );

InstallMethod( AddCoLambdaElimination,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoLambdaElimination", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoLambdaIntroduction
InstallMethod( AddCoLambdaIntroduction,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoLambdaIntroduction", category, func, -1 );
    
end );

InstallMethod( AddCoLambdaIntroduction,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoLambdaIntroduction", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedEvaluationForCoDual
InstallMethod( AddCoclosedEvaluationForCoDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedEvaluationForCoDual", category, func, -1 );
    
end );

InstallMethod( AddCoclosedEvaluationForCoDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedEvaluationForCoDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedEvaluationForCoDualWithGivenTensorProduct
InstallMethod( AddCoclosedEvaluationForCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedEvaluationForCoDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddCoclosedEvaluationForCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedEvaluationForCoDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedEvaluationForCoDualWithGivenTensorProduct,
                    "CoclosedEvaluationForCoDualWithGivenTensorProduct by calling CoclosedEvaluationForCoDual with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedEvaluationForCoDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return CoclosedEvaluationForCoDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedEvaluationForCoDual,
                    "CoclosedEvaluationForCoDual by calling CoclosedEvaluationForCoDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ CoclosedEvaluationForCoDualWithGivenTensorProduct, 1 ],
                        [ TensorUnit, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ CoDualOnObjects, 1 ],
                    ],
  function( cat, a )
    
    return CoclosedEvaluationForCoDualWithGivenTensorProduct( cat, TensorUnit( cat ), a, TensorProductOnObjects( cat, CoDualOnObjects( cat, a ), a ) );
    
end : is_with_given_derivation := true );

## CoclosedMonoidalLeftCoevaluationMorphism
InstallMethod( AddCoclosedMonoidalLeftCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalLeftCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalLeftCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalLeftCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource
InstallMethod( AddCoclosedMonoidalLeftCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalLeftCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource,
                    "CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource by calling CoclosedMonoidalLeftCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedMonoidalLeftCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return CoclosedMonoidalLeftCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedMonoidalLeftCoevaluationMorphism,
                    "CoclosedMonoidalLeftCoevaluationMorphism by calling CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return CoclosedMonoidalLeftCoevaluationMorphismWithGivenSource( cat, a, b, InternalCoHomOnObjects( cat, TensorProductOnObjects( cat, b, a ), a ) );
    
end : is_with_given_derivation := true );

## CoclosedMonoidalLeftEvaluationMorphism
InstallMethod( AddCoclosedMonoidalLeftEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalLeftEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalLeftEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalLeftEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedMonoidalLeftEvaluationMorphismWithGivenRange
InstallMethod( AddCoclosedMonoidalLeftEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalLeftEvaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalLeftEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalLeftEvaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedMonoidalLeftEvaluationMorphismWithGivenRange,
                    "CoclosedMonoidalLeftEvaluationMorphismWithGivenRange by calling CoclosedMonoidalLeftEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedMonoidalLeftEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return CoclosedMonoidalLeftEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedMonoidalLeftEvaluationMorphism,
                    "CoclosedMonoidalLeftEvaluationMorphism by calling CoclosedMonoidalLeftEvaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ CoclosedMonoidalLeftEvaluationMorphismWithGivenRange, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return CoclosedMonoidalLeftEvaluationMorphismWithGivenRange( cat, a, b, TensorProductOnObjects( cat, InternalCoHomOnObjects( cat, b, a ), a ) );
    
end : is_with_given_derivation := true );

## CoclosedMonoidalRightCoevaluationMorphism
InstallMethod( AddCoclosedMonoidalRightCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalRightCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalRightCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalRightCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedMonoidalRightCoevaluationMorphismWithGivenSource
InstallMethod( AddCoclosedMonoidalRightCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalRightCoevaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalRightCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalRightCoevaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedMonoidalRightCoevaluationMorphismWithGivenSource,
                    "CoclosedMonoidalRightCoevaluationMorphismWithGivenSource by calling CoclosedMonoidalRightCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedMonoidalRightCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return CoclosedMonoidalRightCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedMonoidalRightCoevaluationMorphism,
                    "CoclosedMonoidalRightCoevaluationMorphism by calling CoclosedMonoidalRightCoevaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ CoclosedMonoidalRightCoevaluationMorphismWithGivenSource, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return CoclosedMonoidalRightCoevaluationMorphismWithGivenSource( cat, a, b, InternalCoHomOnObjects( cat, TensorProductOnObjects( cat, a, b ), a ) );
    
end : is_with_given_derivation := true );

## CoclosedMonoidalRightEvaluationMorphism
InstallMethod( AddCoclosedMonoidalRightEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalRightEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalRightEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalRightEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedMonoidalRightEvaluationMorphismWithGivenRange
InstallMethod( AddCoclosedMonoidalRightEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedMonoidalRightEvaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddCoclosedMonoidalRightEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedMonoidalRightEvaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedMonoidalRightEvaluationMorphismWithGivenRange,
                    "CoclosedMonoidalRightEvaluationMorphismWithGivenRange by calling CoclosedMonoidalRightEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedMonoidalRightEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return CoclosedMonoidalRightEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedMonoidalRightEvaluationMorphism,
                    "CoclosedMonoidalRightEvaluationMorphism by calling CoclosedMonoidalRightEvaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ CoclosedMonoidalRightEvaluationMorphismWithGivenRange, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return CoclosedMonoidalRightEvaluationMorphismWithGivenRange( cat, a, b, TensorProductOnObjects( cat, a, InternalCoHomOnObjects( cat, b, a ) ) );
    
end : is_with_given_derivation := true );

## InternalCoHomOnMorphisms
InstallMethod( AddInternalCoHomOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomOnMorphismsWithGivenInternalCoHoms
InstallMethod( AddInternalCoHomOnMorphismsWithGivenInternalCoHoms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomOnMorphismsWithGivenInternalCoHoms", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomOnMorphismsWithGivenInternalCoHoms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomOnMorphismsWithGivenInternalCoHoms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalCoHomOnMorphismsWithGivenInternalCoHoms,
                    "InternalCoHomOnMorphismsWithGivenInternalCoHoms by calling InternalCoHomOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ InternalCoHomOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, beta, r )
    
    return InternalCoHomOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalCoHomOnMorphisms,
                    "InternalCoHomOnMorphisms by calling InternalCoHomOnMorphismsWithGivenInternalCoHoms with the WithGiven object(s)",
                    [
                        [ InternalCoHomOnMorphismsWithGivenInternalCoHoms, 1 ],
                        [ InternalCoHomOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return InternalCoHomOnMorphismsWithGivenInternalCoHoms( cat, InternalCoHomOnObjects( cat, Source( alpha ), Range( beta ) ), alpha, beta, InternalCoHomOnObjects( cat, Range( alpha ), Source( beta ) ) );
    
end : is_with_given_derivation := true );

## InternalCoHomOnObjects
InstallMethod( AddInternalCoHomOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomOnObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomTensorProductCompatibilityMorphism
InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects
InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
                    "InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects by calling InternalCoHomTensorProductCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalCoHomTensorProductCompatibilityMorphism, 1 ],
                    ],
  function( cat, source, list, range )
    
    return InternalCoHomTensorProductCompatibilityMorphism( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalCoHomTensorProductCompatibilityMorphism,
                    "InternalCoHomTensorProductCompatibilityMorphism by calling InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects, 1 ],
                        [ InternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return InternalCoHomTensorProductCompatibilityMorphismWithGivenObjects( cat, InternalCoHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[2] ), TensorProductOnObjects( cat, list[3], list[4] ) ), list, TensorProductOnObjects( cat, InternalCoHomOnObjects( cat, list[1], list[3] ), InternalCoHomOnObjects( cat, list[2], list[4] ) ) );
    
end : is_with_given_derivation := true );

## InternalCoHomToTensorProductLeftAdjunctMorphism
InstallMethod( AddInternalCoHomToTensorProductLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomToTensorProductLeftAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomToTensorProductLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomToTensorProductLeftAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddInternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct,
                    "InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct by calling InternalCoHomToTensorProductLeftAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalCoHomToTensorProductLeftAdjunctMorphism, 1 ],
                    ],
  function( cat, a, c, f, t )
    
    return InternalCoHomToTensorProductLeftAdjunctMorphism( cat, a, c, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalCoHomToTensorProductLeftAdjunctMorphism,
                    "InternalCoHomToTensorProductLeftAdjunctMorphism by calling InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, c, f )
    
    return InternalCoHomToTensorProductLeftAdjunctMorphismWithGivenTensorProduct( cat, a, c, f, TensorProductOnObjects( cat, Range( f ), c ) );
    
end : is_with_given_derivation := true );

## InternalCoHomToTensorProductRightAdjunctMorphism
InstallMethod( AddInternalCoHomToTensorProductRightAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomToTensorProductRightAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomToTensorProductRightAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomToTensorProductRightAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddInternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct,
                    "InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct by calling InternalCoHomToTensorProductRightAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ InternalCoHomToTensorProductRightAdjunctMorphism, 1 ],
                    ],
  function( cat, a, b, f, t )
    
    return InternalCoHomToTensorProductRightAdjunctMorphism( cat, a, b, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalCoHomToTensorProductRightAdjunctMorphism,
                    "InternalCoHomToTensorProductRightAdjunctMorphism by calling InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, f )
    
    return InternalCoHomToTensorProductRightAdjunctMorphismWithGivenTensorProduct( cat, a, b, f, TensorProductOnObjects( cat, b, Range( f ) ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromCoDualObjectToInternalCoHomFromTensorUnit
InstallMethod( AddIsomorphismFromCoDualObjectToInternalCoHomFromTensorUnit,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCoDualObjectToInternalCoHomFromTensorUnit", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCoDualObjectToInternalCoHomFromTensorUnit,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCoDualObjectToInternalCoHomFromTensorUnit", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalCoHomFromTensorUnitToCoDualObject
InstallMethod( AddIsomorphismFromInternalCoHomFromTensorUnitToCoDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalCoHomFromTensorUnitToCoDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalCoHomFromTensorUnitToCoDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalCoHomFromTensorUnitToCoDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalCoHomToObject
InstallMethod( AddIsomorphismFromInternalCoHomToObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalCoHomToObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalCoHomToObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalCoHomToObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom
InstallMethod( AddIsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom,
                    "IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom by calling IsomorphismFromInternalCoHomToObject with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromInternalCoHomToObject, 1 ],
                    ],
  function( cat, a, s )
    
    return IsomorphismFromInternalCoHomToObject( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromInternalCoHomToObject,
                    "IsomorphismFromInternalCoHomToObject by calling IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromInternalCoHomToObjectWithGivenInternalCoHom( cat, a, InternalCoHomOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromObjectToInternalCoHom
InstallMethod( AddIsomorphismFromObjectToInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom
InstallMethod( AddIsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom,
                    "IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom by calling IsomorphismFromObjectToInternalCoHom with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromObjectToInternalCoHom, 1 ],
                    ],
  function( cat, a, r )
    
    return IsomorphismFromObjectToInternalCoHom( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromObjectToInternalCoHom,
                    "IsomorphismFromObjectToInternalCoHom by calling IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromObjectToInternalCoHomWithGivenInternalCoHom( cat, a, InternalCoHomOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## MonoidalPostCoComposeMorphism
InstallMethod( AddMonoidalPostCoComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPostCoComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPostCoComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPostCoComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonoidalPostCoComposeMorphismWithGivenObjects
InstallMethod( AddMonoidalPostCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPostCoComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPostCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPostCoComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonoidalPostCoComposeMorphismWithGivenObjects,
                    "MonoidalPostCoComposeMorphismWithGivenObjects by calling MonoidalPostCoComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ MonoidalPostCoComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return MonoidalPostCoComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonoidalPostCoComposeMorphism,
                    "MonoidalPostCoComposeMorphism by calling MonoidalPostCoComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MonoidalPostCoComposeMorphismWithGivenObjects, 1 ],
                        [ InternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return MonoidalPostCoComposeMorphismWithGivenObjects( cat, InternalCoHomOnObjects( cat, a, c ), a, b, c, TensorProductOnObjects( cat, InternalCoHomOnObjects( cat, a, b ), InternalCoHomOnObjects( cat, b, c ) ) );
    
end : is_with_given_derivation := true );

## MonoidalPreCoComposeMorphism
InstallMethod( AddMonoidalPreCoComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPreCoComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPreCoComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPreCoComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonoidalPreCoComposeMorphismWithGivenObjects
InstallMethod( AddMonoidalPreCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonoidalPreCoComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMonoidalPreCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonoidalPreCoComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonoidalPreCoComposeMorphismWithGivenObjects,
                    "MonoidalPreCoComposeMorphismWithGivenObjects by calling MonoidalPreCoComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ MonoidalPreCoComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return MonoidalPreCoComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonoidalPreCoComposeMorphism,
                    "MonoidalPreCoComposeMorphism by calling MonoidalPreCoComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MonoidalPreCoComposeMorphismWithGivenObjects, 1 ],
                        [ InternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return MonoidalPreCoComposeMorphismWithGivenObjects( cat, InternalCoHomOnObjects( cat, a, c ), a, b, c, TensorProductOnObjects( cat, InternalCoHomOnObjects( cat, b, c ), InternalCoHomOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## MorphismFromCoBidual
InstallMethod( AddMorphismFromCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromCoBidualWithGivenCoBidual
InstallMethod( AddMorphismFromCoBidualWithGivenCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromCoBidualWithGivenCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromCoBidualWithGivenCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromCoBidualWithGivenCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromCoBidualWithGivenCoBidual,
                    "MorphismFromCoBidualWithGivenCoBidual by calling MorphismFromCoBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromCoBidual, 1 ],
                    ],
  function( cat, a, s )
    
    return MorphismFromCoBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromCoBidual,
                    "MorphismFromCoBidual by calling MorphismFromCoBidualWithGivenCoBidual with the WithGiven object(s)",
                    [
                        [ MorphismFromCoBidualWithGivenCoBidual, 1 ],
                        [ CoDualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismFromCoBidualWithGivenCoBidual( cat, a, CoDualOnObjects( cat, CoDualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## MorphismFromInternalCoHomToTensorProduct
InstallMethod( AddMorphismFromInternalCoHomToTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromInternalCoHomToTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromInternalCoHomToTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromInternalCoHomToTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromInternalCoHomToTensorProductWithGivenObjects
InstallMethod( AddMorphismFromInternalCoHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromInternalCoHomToTensorProductWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromInternalCoHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromInternalCoHomToTensorProductWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromInternalCoHomToTensorProductWithGivenObjects,
                    "MorphismFromInternalCoHomToTensorProductWithGivenObjects by calling MorphismFromInternalCoHomToTensorProduct with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromInternalCoHomToTensorProduct, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromInternalCoHomToTensorProduct( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromInternalCoHomToTensorProduct,
                    "MorphismFromInternalCoHomToTensorProduct by calling MorphismFromInternalCoHomToTensorProductWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromInternalCoHomToTensorProductWithGivenObjects, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ CoDualOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromInternalCoHomToTensorProductWithGivenObjects( cat, InternalCoHomOnObjects( cat, a, b ), a, b, TensorProductOnObjects( cat, CoDualOnObjects( cat, b ), a ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalCoHomLeftAdjunctMorphism
InstallMethod( AddTensorProductToInternalCoHomLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalCoHomLeftAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalCoHomLeftAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalCoHomLeftAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom
InstallMethod( AddTensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom,
                    "TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom by calling TensorProductToInternalCoHomLeftAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalCoHomLeftAdjunctMorphism, 1 ],
                    ],
  function( cat, b, c, g, i )
    
    return TensorProductToInternalCoHomLeftAdjunctMorphism( cat, b, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalCoHomLeftAdjunctMorphism,
                    "TensorProductToInternalCoHomLeftAdjunctMorphism by calling TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                    ],
  function( cat, b, c, g )
    
    return TensorProductToInternalCoHomLeftAdjunctMorphismWithGivenInternalCoHom( cat, b, c, g, InternalCoHomOnObjects( cat, Source( g ), c ) );
    
end : is_with_given_derivation := true );

## TensorProductToInternalCoHomRightAdjunctMorphism
InstallMethod( AddTensorProductToInternalCoHomRightAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalCoHomRightAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalCoHomRightAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalCoHomRightAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom
InstallMethod( AddTensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom,
                    "TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom by calling TensorProductToInternalCoHomRightAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToInternalCoHomRightAdjunctMorphism, 1 ],
                    ],
  function( cat, b, c, g, i )
    
    return TensorProductToInternalCoHomRightAdjunctMorphism( cat, b, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToInternalCoHomRightAdjunctMorphism,
                    "TensorProductToInternalCoHomRightAdjunctMorphism by calling TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom with the WithGiven object(s)",
                    [
                        [ TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                    ],
  function( cat, b, c, g )
    
    return TensorProductToInternalCoHomRightAdjunctMorphismWithGivenInternalCoHom( cat, b, c, g, InternalCoHomOnObjects( cat, Source( g ), b ) );
    
end : is_with_given_derivation := true );

## UniversalPropertyOfCoDual
InstallMethod( AddUniversalPropertyOfCoDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalPropertyOfCoDual", category, func, -1 );
    
end );

InstallMethod( AddUniversalPropertyOfCoDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalPropertyOfCoDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);
