/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.CteGenerateSeriesFunction;
import org.hibernate.dialect.function.NumberSeriesGenerateSeriesFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAGenerateSeriesFunction
extends NumberSeriesGenerateSeriesFunction {
    public HANAGenerateSeriesFunction(int maxSeriesSize, TypeConfiguration typeConfiguration) {
        super(new CteGenerateSeriesSetReturningFunctionTypeResolver(), typeConfiguration.getBasicTypeRegistry().resolve(java.time.Duration.class, 3015), false, maxSeriesSize);
    }

    @Override
    public boolean rendersIdentifierVariable(List<SqlAstNode> arguments, SessionFactoryImplementor sessionFactory) {
        return true;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup tableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                walker.registerQueryTransformer(new HANAGenerateSeriesQueryTransformer(tableGroup, tableGroup, HANAGenerateSeriesFunction.this.maxSeriesSize, "i", HANAGenerateSeriesFunction.this.coerceToTimestamp));
                return tableGroup;
            }
        };
    }

    @Override
    protected void renderGenerateSeries(SqlAppender sqlAppender, Expression start, Expression stop, @Nullable Expression step, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        boolean stepNeedsVariable;
        boolean startNeedsVariable = HANAGenerateSeriesFunction.needsVariable(start);
        boolean bl = stepNeedsVariable = step != null && HANAGenerateSeriesFunction.needsVariable(step);
        if (startNeedsVariable || stepNeedsVariable) {
            sqlAppender.appendSql("((select");
            int separator = 32;
            if (startNeedsVariable) {
                sqlAppender.appendSql((char)separator);
                start.accept(walker);
                sqlAppender.appendSql(" b");
                separator = 44;
            }
            if (stepNeedsVariable) {
                sqlAppender.appendSql((char)separator);
                if (step instanceof Duration) {
                    Duration duration = (Duration)step;
                    duration.getMagnitude().accept(walker);
                } else {
                    step.accept(walker);
                }
                sqlAppender.appendSql(" s");
            }
            sqlAppender.appendSql(" from sys.dummy) ");
            sqlAppender.appendSql(tableIdentifierVariable);
            sqlAppender.appendSql("_");
            sqlAppender.appendSql(" join ");
        }
        sqlAppender.appendSql("xmltable('/r/a' passing ");
        sqlAppender.appendSql("max_series");
        sqlAppender.appendSql(".v columns i for ordinality) ");
        sqlAppender.appendSql(tableIdentifierVariable);
        if (startNeedsVariable || stepNeedsVariable) {
            sqlAppender.appendSql(" on 1=1)");
        }
    }

    static class CteGenerateSeriesSetReturningFunctionTypeResolver
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver {
        public CteGenerateSeriesSetReturningFunctionTypeResolver() {
            super("v", "i");
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            return this.resolveIterationVariableBasedFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
        }
    }

    protected static class HANAGenerateSeriesQueryTransformer
    extends CteGenerateSeriesFunction.CteGenerateSeriesQueryTransformer {
        public HANAGenerateSeriesQueryTransformer(FunctionTableGroup functionTableGroup, TableGroup targetTableGroup, int maxSeriesSize, String positionColumnName, boolean coerceToTimestamp) {
            super(functionTableGroup, targetTableGroup, maxSeriesSize, positionColumnName, coerceToTimestamp);
        }

        @Override
        protected CteStatement createSeriesCte(SqmToSqlAstConverter converter) {
            final BasicType<String> stringType = converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(String.class);
            List<CteColumn> cteColumns = List.of(new CteColumn("v", stringType));
            QuerySpec query = new QuerySpec(false);
            query.getSelectClause().addSqlSelection(new SqlSelectionImpl(new SelfRenderingExpression(){

                @Override
                public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                    sqlAppender.appendSql("'<r>'||lpad('',");
                    sqlAppender.appendSql(maxSeriesSize * 4);
                    sqlAppender.appendSql(",'<a/>')||'</r>'");
                }

                @Override
                public JdbcMappingContainer getExpressionType() {
                    return stringType;
                }
            }));
            return new CteStatement(new CteTable("max_series", cteColumns), new SelectStatement(query));
        }
    }
}

