/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.admin.cli.KcAdmMain;
import org.keycloak.client.admin.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.admin.cli.operations.UserOperations;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.common.util.IoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="set-password", description={"[ARGUMENTS]"})
public class SetPasswordCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"--username"}, description={"Username"})
    String username;
    @CommandLine.Option(names={"--userid"}, description={"User ID"})
    String userid;
    @CommandLine.Option(names={"-p", "--new-password"}, description={"New password"}, defaultValue="${env:KC_CLI_PASSWORD}")
    String pass;
    @CommandLine.Option(names={"-t", "--temporary"}, description={"is password temporary"})
    boolean temporary;

    @Override
    protected void process() {
        String adminRoot;
        if (this.userid == null && this.username == null) {
            throw new IllegalArgumentException("No user specified. Use --username or --userid to specify user");
        }
        if (this.userid != null && this.username != null) {
            throw new IllegalArgumentException("Options --userid and --username are mutually exclusive");
        }
        if (this.pass == null) {
            this.pass = IoUtils.readPasswordFromConsole("password");
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config);
        Object auth = null;
        config = this.ensureAuthInfo(config);
        config = this.copyWithServerInfo(config);
        if (ConfigUtil.credentialsAvailable(config)) {
            auth = this.ensureToken(config);
        }
        auth = auth != null ? "Bearer " + (String)auth : null;
        String server = config.getServerUrl();
        String realm = this.getTargetRealm(config);
        String string = adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
        if (this.username != null) {
            this.userid = UserOperations.getIdFromUsername(adminRoot, realm, (String)auth, this.username);
        }
        UserOperations.resetUserPassword(adminRoot, realm, (String)auth, this.userid, this.pass, this.temporary);
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.username == null && this.userid == null && this.pass == null;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcAdmMain.CMD + " set-password (--username USERNAME | --userid ID) [--new-password PASSWORD] [ARGUMENTS]");
        out.println();
        out.println("Command to reset user's password.");
        out.println();
        out.println("Use `" + KcAdmMain.CMD + " config credentials` to establish an authenticated session, or use CREDENTIALS OPTIONS");
        out.println("to perform one time authentication.");
        this.globalOptions(out);
        out.println("    --username USERNAME       Identify target user by 'username'");
        out.println("    --userid ID               Identify target user by 'id'");
        out.println("    -p, --new-password        New password to set. If not specified and the env variable KC_CLI_PASSWORD is not defined, you will be prompted for it.");
        out.println("    -t, --temporary           Make the new password temporary - user has to change it on next logon");
        out.println("    -a, --admin-root URL      URL of Admin REST endpoint root if not default - e.g. http://localhost:8080/admin");
        out.println("    -r, --target-realm REALM  Target realm to issue requests against if not the one authenticated against");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Set new temporary password for the user:");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " set-password -r demorealm --username testuser --new-password NEWPASS -t");
        out.println();
        out.println();
        out.println("Use '" + KcAdmMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

