/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.PersistentUserSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.ClientSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangesUtils;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsWorker;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.UserSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.expiration.ExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.ExpirationTaskFactory;
import org.keycloak.models.sessions.infinispan.listeners.EmbeddedUserSessionExpirationListener;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory<UserSessionProvider>,
ServerInfoAwareProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String REMOVE_USER_SESSIONS_EVENT = "REMOVE_USER_SESSIONS_EVENT";
    public static final String CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineSessionCacheEntryLifespanOverride";
    public static final String CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineClientSessionCacheEntryLifespanOverride";
    public static final String CONFIG_MAX_BATCH_SIZE = "maxBatchSize";
    public static final int DEFAULT_MAX_BATCH_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    public static final String CONFIG_USE_CACHES = "useCaches";
    private static final boolean DEFAULT_USE_CACHES = true;
    public static final String CONFIG_USE_BATCHES = "useBatches";
    private static final boolean DEFAULT_USE_BATCHES = false;
    public static final String CONFIG_EXPIRATION_PERIOD = "sessionExpirationPeriod";
    private static final int DEFAULT_EXPIRATION_PERIOD_SECONDS = 180;
    private static final int MIN_EXPIRATION_PERIOD_SECONDS = 60;
    private CacheHolder<String, UserSessionEntity> sessionCacheHolder;
    private CacheHolder<String, UserSessionEntity> offlineSessionCacheHolder;
    private CacheHolder<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionCacheHolder;
    private CacheHolder<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineClientSessionCacheHolder;
    private EmbeddedUserSessionExpirationListener expirationListener;
    private ExpirationTask expirationTask;
    private long offlineSessionCacheEntryLifespanOverride;
    private long offlineClientSessionCacheEntryLifespanOverride;
    private PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate;
    private PersistentSessionsWorker persistentSessionsWorker;
    private int maxBatchSize;
    private boolean useCaches;
    private boolean useBatches;
    private int expirationPeriodSeconds;

    public UserSessionProvider create(KeycloakSession session) {
        if (MultiSiteUtils.isPersistentSessionsEnabled()) {
            PersistentTransaction tx = this.createPersistentTransaction(session);
            return new PersistentUserSessionProvider(session, tx.userTx, tx.clientTx);
        }
        VolatileTransactions tx = this.createVolatileTransaction(session);
        return new InfinispanUserSessionProvider(session, this.persisterLastSessionRefreshStore, tx.sessionTx, tx.offlineSessionTx, tx.clientSessionTx, tx.offlineClientSessionTx, this::deriveOfflineSessionCacheEntryLifespanMs, this::deriveOfflineClientSessionCacheEntryLifespanOverrideMs);
    }

    public void init(Config.Scope config) {
        this.offlineSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        if (this.offlineSessionCacheEntryLifespanOverride != -1L) {
            log.warn((Object)"The option spi-user-sessions--infinispan--offline-session-cache-entry-lifespan-override is deprecated and will be removed in a future release");
        }
        this.offlineClientSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        if (this.offlineClientSessionCacheEntryLifespanOverride != -1L) {
            log.warn((Object)"The option spi-user-sessions--infinispan--offline-client-session-cache-entry-lifespan-override is deprecated and will be removed in a future release");
        }
        this.maxBatchSize = config.getInt(CONFIG_MAX_BATCH_SIZE, Integer.valueOf(DEFAULT_MAX_BATCH_SIZE));
        this.useCaches = config.getBoolean(CONFIG_USE_CACHES, Boolean.valueOf(true)) != false && InfinispanUtils.isEmbeddedInfinispan();
        boolean bl = this.useBatches = config.getBoolean(CONFIG_USE_BATCHES, Boolean.valueOf(false)) != false && MultiSiteUtils.isPersistentSessionsEnabled();
        if (this.useBatches) {
            this.asyncQueuePersistentUpdate = new ArrayBlockingQueue(1000);
        }
        this.expirationPeriodSeconds = InfinispanUserSessionProviderFactory.getExpirationPeriodSeconds(config);
    }

    public void postInit(KeycloakSessionFactory factory) {
        KeycloakSession session;
        factory.register(event -> {
            if (event instanceof PostMigrationEvent) {
                if (!this.useCaches) return;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> {
                    if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
                        this.initializePersisterLastSessionRefreshStore(factory);
                    }
                    this.registerClusterListeners(session);
                });
                return;
            } else if (event instanceof UserModel.UserRemovedEvent) {
                UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                UserSessionProvider provider1 = (UserSessionProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionProvider.class, this.getId());
                if (provider1 instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                    return;
                } else {
                    if (!(provider1 instanceof PersistentUserSessionProvider)) throw new IllegalStateException("Unknown provider type: " + String.valueOf(provider1.getClass()));
                    ((PersistentUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                }
                return;
            } else {
                if (!(event instanceof ResetTimeOffsetEvent) || this.persisterLastSessionRefreshStore == null) return;
                this.persisterLastSessionRefreshStore.reset();
            }
        });
        if (MultiSiteUtils.isPersistentSessionsEnabled() && this.useBatches) {
            this.persistentSessionsWorker = new PersistentSessionsWorker(factory, this.asyncQueuePersistentUpdate, this.maxBatchSize);
            this.persistentSessionsWorker.start();
        }
        if (MultiSiteUtils.isPersistentSessionsEnabled()) {
            if (this.useCaches) {
                session = factory.create();
                try {
                    this.sessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "sessions", SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs, SecretGenerator.SECURE_ID_GENERATOR);
                    this.offlineSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "offlineSessions", SessionTimeouts::getOfflineSessionLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
                    this.clientSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "clientSessions", SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
                    this.offlineClientSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "offlineClientSessions", SessionTimeouts::getOfflineClientSessionLifespanMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            } else {
                this.sessionCacheHolder = InfinispanChangesUtils.createWithoutCache(SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs, SecretGenerator.SECURE_ID_GENERATOR);
                this.offlineSessionCacheHolder = InfinispanChangesUtils.createWithoutCache(SessionTimeouts::getOfflineSessionLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
                this.clientSessionCacheHolder = InfinispanChangesUtils.createWithoutCache(SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
                this.offlineClientSessionCacheHolder = InfinispanChangesUtils.createWithoutCache(SessionTimeouts::getOfflineClientSessionLifespanMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
            }
        } else {
            session = factory.create();
            try {
                this.sessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "sessions", SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs, SecretGenerator.SECURE_ID_GENERATOR);
                this.offlineSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "offlineSessions", this::deriveOfflineSessionCacheEntryLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
                this.clientSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "clientSessions", SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
                this.offlineClientSessionCacheHolder = InfinispanChangesUtils.createWithCache(session, "offlineClientSessions", this::deriveOfflineClientSessionCacheEntryLifespanOverrideMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
                BlockingManager blockingManager = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getBlockingManager();
                this.expirationListener = new EmbeddedUserSessionExpirationListener(session.getKeycloakSessionFactory(), blockingManager);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
            this.sessionCacheHolder.cache().addListener((Object)this.expirationListener);
        }
        session = factory.create();
        try {
            this.expirationTask = ExpirationTaskFactory.create(session, this.expirationPeriodSeconds);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        this.expirationTask.start();
    }

    public void initializePersisterLastSessionRefreshStore(KeycloakSessionFactory sessionFactory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session -> {
            this.persisterLastSessionRefreshStore = new PersisterLastSessionRefreshStoreFactory().createAndInit(session, true);
        });
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(REMOVE_USER_SESSIONS_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveUserSessionsEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RemoveUserSessionsEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected Long deriveOfflineSessionCacheEntryLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity entity) {
        long configuredOfflineSessionLifespan = SessionTimeouts.getOfflineSessionLifespanMs(realm, client, entity);
        if (this.offlineSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineSessionLifespan;
        }
        if (configuredOfflineSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride), configuredOfflineSessionLifespan);
    }

    protected Long deriveOfflineClientSessionCacheEntryLifespanOverrideMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity entity) {
        long configuredOfflineClientSessionLifespan = SessionTimeouts.getOfflineClientSessionLifespanMs(realm, client, entity);
        if (this.offlineClientSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineClientSessionLifespan;
        }
        if (configuredOfflineClientSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride), configuredOfflineClientSessionLifespan);
    }

    public void close() {
        if (this.persistentSessionsWorker != null) {
            this.persistentSessionsWorker.stop();
        }
        if (this.expirationListener != null) {
            this.sessionCacheHolder.cache().removeListener((Object)this.expirationListener);
            this.expirationListener = null;
        }
        if (this.expirationTask != null) {
            this.expirationTask.stop();
            this.expirationTask = null;
        }
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan() || MultiSiteUtils.isPersistentSessionsEnabled();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineSessionCacheEntryLifespanOverride));
        info.put(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineClientSessionCacheEntryLifespanOverride));
        info.put(CONFIG_MAX_BATCH_SIZE, Integer.toString(this.maxBatchSize));
        info.put(CONFIG_USE_CACHES, Boolean.toString(this.useCaches));
        info.put(CONFIG_USE_BATCHES, Boolean.toString(this.useBatches));
        info.put(CONFIG_EXPIRATION_PERIOD, Integer.toString(this.expirationPeriodSeconds));
        return info;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(CONFIG_USE_BATCHES).type("boolean").helpText("Enable or disable batch writes to the database. Enabled by default with the persistent-user-sessions Feature").defaultValue((Object)false).add();
        builder.property().name(CONFIG_MAX_BATCH_SIZE).type("int").helpText("Maximum size of a batch (only applicable to persistent sessions").defaultValue((Object)DEFAULT_MAX_BATCH_SIZE).add();
        builder.property().name(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline client sessions should be kept in memory in seconds (deprecated, to be removed in Keycloak 27)").add();
        builder.property().name(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline user sessions should be kept in memory in seconds (deprecated, to be removed in Keycloak 27)").add();
        builder.property().name(CONFIG_USE_CACHES).type("boolean").helpText("Enable or disable caches. Enabled by default unless the external feature to use only external remote caches is used").add();
        builder.property().name(CONFIG_EXPIRATION_PERIOD).type("int").helpText("Sets the expiration task run period, to remove the expired session.").add();
        return builder.build();
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class, InfinispanTransactionProvider.class);
    }

    public ExpirationTask getExpirationTask() {
        return this.expirationTask;
    }

    public static long getExpirationPeriod(TimeUnit outTimeUnit) {
        return outTimeUnit.convert(InfinispanUserSessionProviderFactory.getExpirationPeriodSeconds(Config.scope((String[])new String[]{"userSessions", "infinispan"})), TimeUnit.SECONDS);
    }

    private static int getExpirationPeriodSeconds(Config.Scope config) {
        int period = config.getInt(CONFIG_EXPIRATION_PERIOD, Integer.valueOf(180));
        if (period < 60) {
            log.warnf("Invalid user session expiration task period of %d seconds. Setting it to %d seconds", (Object)period, (Object)60);
            return 60;
        }
        return period;
    }

    private VolatileTransactions createVolatileTransaction(KeycloakSession session) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, this.sessionCacheHolder);
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, this.offlineSessionCacheHolder);
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionTx = new InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity>(session, this.clientSessionCacheHolder);
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineClientSessionTx = new InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity>(session, this.offlineClientSessionCacheHolder);
        InfinispanTransactionProvider transactionProvider = (InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class);
        transactionProvider.registerTransaction(sessionTx);
        transactionProvider.registerTransaction(offlineSessionTx);
        transactionProvider.registerTransaction(clientSessionTx);
        transactionProvider.registerTransaction(offlineClientSessionTx);
        return new VolatileTransactions(sessionTx, offlineSessionTx, clientSessionTx, offlineClientSessionTx);
    }

    private PersistentTransaction createPersistentTransaction(KeycloakSession session) {
        UserSessionPersistentChangelogBasedTransaction sessionTx = new UserSessionPersistentChangelogBasedTransaction(session, this.asyncQueuePersistentUpdate, this.sessionCacheHolder, this.offlineSessionCacheHolder);
        ClientSessionPersistentChangelogBasedTransaction clientSessionTx = new ClientSessionPersistentChangelogBasedTransaction(session, this.asyncQueuePersistentUpdate, this.clientSessionCacheHolder, this.offlineClientSessionCacheHolder, sessionTx);
        InfinispanTransactionProvider transactionProvider = (InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class);
        transactionProvider.registerTransaction(sessionTx);
        transactionProvider.registerTransaction(clientSessionTx);
        return new PersistentTransaction(sessionTx, clientSessionTx);
    }

    private record PersistentTransaction(UserSessionPersistentChangelogBasedTransaction userTx, ClientSessionPersistentChangelogBasedTransaction clientTx) {
    }

    private record VolatileTransactions(InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx, InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx, InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionTx, InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineClientSessionTx) {
    }
}

