/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.TimeClaimNormalizer;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderUtils;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.JwtCredentialBody;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.representations.JsonWebToken;

public class JwtCredentialBuilder
implements CredentialBuilder {
    private static final String VC_CLAIM_KEY = "vc";
    private static final String ID_CLAIM_KEY = "id";
    private final TimeProvider timeProvider;
    private final UnaryOperator<Instant> issuanceTimeNormalizer;

    public JwtCredentialBuilder(TimeProvider timeProvider) {
        this(timeProvider, instant -> {
            throw new IllegalStateException("KeycloakSession must not be null when defaulting issuance time");
        });
    }

    public JwtCredentialBuilder(TimeProvider timeProvider, KeycloakSession session) {
        this(timeProvider, new TimeClaimNormalizer(Objects.requireNonNull(session, "KeycloakSession must not be null when defaulting issuance time"))::normalize);
    }

    public JwtCredentialBuilder(TimeProvider timeProvider, UnaryOperator<Instant> issuanceTimeNormalizer) {
        this.timeProvider = Objects.requireNonNull(timeProvider, "TimeProvider must not be null");
        this.issuanceTimeNormalizer = Objects.requireNonNull(issuanceTimeNormalizer, "Issuance time normalizer must not be null");
    }

    @Override
    public String getSupportedFormat() {
        return "jwt_vc";
    }

    @Override
    public JwtCredentialBody buildCredentialBody(VerifiableCredential verifiableCredential, CredentialBuildConfig credentialBuildConfig) throws CredentialBuilderException {
        verifiableCredential.setIssuer(credentialBuildConfig.getCredentialIssuer());
        Instant issuanceInstant = Optional.ofNullable(verifiableCredential.getIssuanceDate()).orElseGet(() -> {
            Instant defaultTime = Instant.ofEpochSecond(this.timeProvider.currentTimeSeconds());
            return (Instant)this.issuanceTimeNormalizer.apply(defaultTime);
        });
        long iat = issuanceInstant.getEpochSecond();
        JsonWebToken jsonWebToken = new JsonWebToken().issuer(verifiableCredential.getIssuer().toString()).nbf(Long.valueOf(iat)).id(CredentialBuilderUtils.createCredentialId(verifiableCredential));
        jsonWebToken.setOtherClaims(VC_CLAIM_KEY, (Object)verifiableCredential);
        Optional.ofNullable(verifiableCredential.getExpirationDate()).ifPresent(d -> jsonWebToken.exp(Long.valueOf(d.getEpochSecond())));
        Optional.ofNullable(verifiableCredential.getCredentialSubject().getClaims().get(ID_CLAIM_KEY)).map(Object::toString).ifPresent(arg_0 -> ((JsonWebToken)jsonWebToken).subject(arg_0));
        JWSBuilder.EncodingBuilder jwsBuilder = new JWSBuilder().type(credentialBuildConfig.getTokenJwsType()).jsonContent((Object)jsonWebToken);
        return new JwtCredentialBody(jwsBuilder);
    }
}

