/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.resolve.calls.model.DiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionDiagnostic;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/VisibilityErrorOnArgument;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "invisibleMember", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)V", "getArgument", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getInvisibleMember", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "report", "", "reporter", "Lorg/jetbrains/kotlin/resolve/calls/model/DiagnosticReporter;", "resolution"})
public final class VisibilityErrorOnArgument
extends ResolutionDiagnostic {
    @NotNull
    private final KotlinCallArgument argument;
    @NotNull
    private final DeclarationDescriptorWithVisibility invisibleMember;

    public VisibilityErrorOnArgument(@NotNull KotlinCallArgument argument, @NotNull DeclarationDescriptorWithVisibility invisibleMember) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(invisibleMember, "invisibleMember");
        super(CandidateApplicability.K1_RUNTIME_ERROR);
        this.argument = argument;
        this.invisibleMember = invisibleMember;
    }

    @NotNull
    public final KotlinCallArgument getArgument() {
        return this.argument;
    }

    @NotNull
    public final DeclarationDescriptorWithVisibility getInvisibleMember() {
        return this.invisibleMember;
    }

    @Override
    public void report(@NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        reporter.onCallArgument(this.argument, this);
    }
}

